/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class RaftSprite
extends Sprite {
    private int mDirection;
    private int animCounter = 0;
    private int mKX;
    private int mKY;
    private int myHeight;
    private int dmg = 61;
    private int mStates = 0;
    private int screenX = 24;
    private int screenY = 24;
    private RaftingCanvas mParent;
    private int mLastDelta;
    private int motionModifier;
    private int motionCounter = 0;
    private boolean undoDone;
    private boolean mLastWasTurn;
    private boolean moving;
    public boolean moveModifierOn = true;
    private Random myRandom = new Random();
    private int spinEffect = 0;
    private int spinFinal = 0;
    private int modCount = 0;
    private int immuneTime = 0;
    public int myZ;
    public int lastX;
    public int lastY;
    public int lastDir;
    public int reqX = 0;
    public int reqY = 0;
    public int lastScreenX;
    private static final int K_NUMFRAMES = 5;
    private static final int[] K_TRANSFORMATIONS = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2};
    private static final int[][] K_PADDLEFRAMES = new int[][]{{4, 9, 14, 4, 9}, {4, 9, 14, 4, 9}, {3, 8, 13, 3, 8}, {3, 8, 13, 3, 8}, {2, 7, 12, 2, 7}, {2, 7, 12, 2, 7}, {1, 6, 11, 1, 6}, {1, 6, 11, 1, 6}, {0, 5, 10, 0, 5}, {0, 5, 10, 0, 5}, {1, 6, 11, 1, 6}, {1, 6, 11, 1, 6}, {2, 7, 12, 2, 7}, {2, 7, 12, 2, 7}, {3, 8, 13, 3, 8}, {3, 8, 13, 3, 8}};
    private static final int[] K_FLYOFF = new int[]{15, 16, 17, 18, 19, 20, 20, 21, 21, 22, 22};
    private static final int[] K_SINK = new int[]{1, 6, 23, 24, 25, 26, 27, 27, 28, 28};
    private static final int[] K_BUMPOFFSET = new int[]{1, 2, 3, -3, -2, -1, 0};
    private static final int[] K_SHADOW_BUMPOFFSET = new int[]{1, 3, 6, 6, 3, 1, 0};
    private static final int[] K_SLIDEOFFSET = new int[]{1, 2, 3, -3, -2, -2, -1};
    private static final int[] K_OBJECTDAMAGE = new int[]{3, 4, 8, 8, 2, 0, 1, 1, 1, 1};
    private static final int[] K_OBJECTMODIFIER = new int[]{1, 1, 0, 2, 4, 0, 0, 0, 2, 0};
    private static final int[] K_WINANIMATION = new int[]{29, 29, 30, 30, 29, 29, 30, 30, 29, 29, 30, 30, 29, 29, 30, 30, 32, 32, 33, 33, 32, 32, 33, 33, 32, 32, 33, 33, 32, 32, 33, 33, 32, 32, 31, 31, 32, 32, 31, 31};
    private static final int[] K_COSINE = new int[]{0, 383, 707, 924, 1000, 924, 707, 383, 0, -383, -707, -924, -1000, -924, -707, -383};
    private static final int[] K_SINE = new int[]{1000, 924, 707, 383, 0, -383, -707, -924, -1000, -924, -707, -383, 0, 383, 707, 924};

    public RaftSprite(Image image, int n, int n2, RaftingCanvas raftingCanvas) {
        super(image, n, n2);
        this.defineReferencePixel(n / 2, n2 / 2);
        this.setFrame(1);
        this.mParent = raftingCanvas;
        this.mDirection = 6;
        this.myHeight = n2 / 2;
    }

    public final void turn(int n) {
        if (this.mStates == 0) {
            if (this.mDirection + n < 11 && this.mDirection + n > 1) {
                this.lastDir = this.mDirection;
                this.mDirection += n;
                if (this.mDirection < 0) {
                    this.mDirection += 16;
                }
                if (this.mDirection > 15) {
                    this.mDirection %= 16;
                }
                this.setFrame(K_PADDLEFRAMES[this.mDirection][this.animCounter]);
                this.setTransform(K_TRANSFORMATIONS[this.mDirection]);
                this.mLastDelta = n;
            }
            this.undoDone = false;
        }
    }

    public final void followStream() {
        if (this.mStates == 0) {
            if (this.mDirection > 6) {
                this.mLastWasTurn = true;
                this.lastDir = this.mDirection--;
                this.setFrame(K_PADDLEFRAMES[this.mDirection][this.animCounter]);
                this.setTransform(K_TRANSFORMATIONS[this.mDirection]);
            } else if (this.mDirection < 6) {
                this.mLastWasTurn = true;
                this.lastDir = this.mDirection++;
                this.setFrame(K_PADDLEFRAMES[this.mDirection][this.animCounter]);
                this.setTransform(K_TRANSFORMATIONS[this.mDirection]);
            }
        }
    }

    public final void spin() {
        if (this.spinEffect == 0) {
            if (this.getRandomInt(10) < 5) {
                this.spinFinal = 26;
                this.spinEffect = 1;
            } else {
                this.spinFinal = 31;
                this.spinEffect = -1;
            }
        }
        this.mDirection += this.spinEffect;
        if (this.mDirection < 0) {
            this.mDirection += 16;
        }
        if (this.mDirection > 15) {
            this.mDirection %= 16;
        }
        this.setFrame(K_PADDLEFRAMES[this.mDirection][this.animCounter]);
        this.setTransform(K_TRANSFORMATIONS[this.mDirection]);
        this.mLastDelta = this.spinEffect;
        this.mLastWasTurn = true;
        if (this.mDirection + 20 == this.spinFinal && this.mStates != 2 && this.mStates != 3) {
            this.mStates = 0;
            this.moveModifierOn = true;
        }
    }

    public final void forward(int n) {
        if (this.mStates == 0) {
            if (n == 0) {
                n = this.mLastDelta;
            }
            this.mLastWasTurn = false;
            this.mLastDelta = n;
            this.lastScreenX = this.screenX;
            this.screenX += n;
            this.turn(-n);
            int n2 = 70 - this.screenX + this.mParent.myCurrentLeftY;
            int n3 = this.screenX + this.mParent.myCurrentLeftX;
            if (n > 0) {
                this.requestPosition(3, -3);
            } else if (n < 0) {
                this.requestPosition(-3, 3);
            }
        }
    }

    public final int getScreenX() {
        return this.screenX;
    }

    private final void requestPosition(int n, int n2) {
        this.reqX = n;
        this.reqY = n2;
        this.moving = true;
    }

    public final void requestMove(int n, int n2) {
        this.lastX = this.getX();
        this.lastY = this.getY();
        if (this.moving) {
            this.move(this.reqX, this.reqY);
        }
        this.moving = false;
    }

    public final void undoMove(int n, int n2) {
        this.screenX = this.lastScreenX;
        this.setPosition(this.lastX, this.lastY);
    }

    public final void stopDamage(int n) {
        this.dmg -= n;
    }

    public final int getGhostFrame() {
        return K_PADDLEFRAMES[this.mDirection][0];
    }

    public final int getGhostTransform() {
        return K_TRANSFORMATIONS[this.mDirection];
    }

    public final void tick(RaftingCanvas raftingCanvas) {
        if (this.immuneTime > 0) {
            --this.immuneTime;
        }
        ++this.modCount;
        switch (this.mStates) {
            case 0: {
                ++this.animCounter;
                this.animCounter %= 5;
                this.setFrame(K_PADDLEFRAMES[this.mDirection][this.animCounter]);
                break;
            }
            case 1: {
                this.move(0, -K_BUMPOFFSET[this.motionCounter]);
                ++this.motionCounter;
                if (this.motionCounter < K_BUMPOFFSET.length) break;
                this.motionCounter = 0;
                this.mStates = 0;
                this.moveModifierOn = true;
                this.modCount = 0;
                this.immuneTime = 5;
                break;
            }
            case 2: {
                this.dmg = -100;
                this.setFrame(K_FLYOFF[this.motionCounter]);
                ++this.motionCounter;
                if (this.motionCounter < K_FLYOFF.length) break;
                this.motionCounter -= 4;
                break;
            }
            case 3: {
                this.setFrame(K_SINK[this.motionCounter]);
                ++this.motionCounter;
                if (this.motionCounter < K_SINK.length) break;
                this.motionCounter -= 4;
                this.dmg = -100;
                break;
            }
            case 4: {
                this.spin();
                break;
            }
            case 9: {
                ++this.motionCounter;
                this.motionCounter %= K_WINANIMATION.length;
                this.setFrame(K_WINANIMATION[this.motionCounter]);
            }
        }
        this.myZ = this.getY() + this.myHeight;
    }

    public final void setDamage(int n) {
        this.dmg -= K_OBJECTDAMAGE[n];
        this.moveModifierOn = false;
        if (this.getState()) {
            this.mStates = K_OBJECTMODIFIER[n];
            if (this.dmg > 0) {
                this.mStates = K_OBJECTMODIFIER[n];
                this.motionCounter = 0;
                if (this.mStates == 2) {
                    if (this.dmg > 10) {
                        this.mStates = 0;
                    }
                } else if (this.mStates == 4) {
                    this.motionCounter = this.getRandomInt(12);
                } else if (this.mStates == 1 && this.immuneTime >= 1) {
                    this.mStates = 0;
                    this.moveModifierOn = true;
                }
            } else {
                if (this.mStates != 2) {
                    this.mStates = 3;
                }
                this.motionCounter = 0;
            }
        }
    }

    public final void setState(int n) {
        this.mStates = n;
    }

    public final void setDeath() {
        if (this.mStates != 2) {
            this.mStates = 3;
        }
    }

    public final int getDamage() {
        return this.dmg;
    }

    public final boolean getState() {
        return this.mStates == 0;
    }

    public final boolean getShadow() {
        return this.mStates == 1;
    }

    public final int getShadowPos() {
        return this.getY() + K_SHADOW_BUMPOFFSET[this.motionCounter];
    }

    public final int getRandomInt(int n) {
        int n2 = this.myRandom.nextInt() % n;
        if (n2 < 0) {
            n2 += n;
        }
        return n2;
    }
}

