/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.lcdui.game.TiledLayer;
import javax.microedition.midlet.MIDlet;

public class RaftingCanvas
extends GameCanvas
implements Runnable,
CommandListener {
    private boolean mTrucking = false;
    public boolean gameOver;
    public boolean levelComplete;
    public boolean hasHighscore = false;
    private RaftSprite mRaft;
    private Sprite mRaftGhost;
    private Sprite mCollSplash;
    private Sprite mSpeedSplash;
    private LevelData[] mBoard;
    private LayerManager mLayerManager;
    private WaterEffects[] water;
    private Random myRandom = new Random();
    private int winCondition;
    private int aTileset;
    private SonyEricssonTextLabels SELabels;
    private boolean myIntro = true;
    private int myIntroDelay = 0;
    private static final Image[] tileImages;
    private static Image interfaceImages;
    private static Image rot_interfaceImages;
    private static Image f_interfaceImages;
    public static Image raftImage;
    private static Image ghostImage;
    private static Image collSplash;
    private static Image speedSplash;
    private int repeater;
    private int level;
    private int grindDamage = 0;
    private int waterPower = 0;
    private int speedSplashCounter = 0;
    private int speedAnim = 0;
    private int inputDelta = 0;
    public int myCurrentLeftX;
    public int myCurrentLeftY;
    public int objectsX = -RaftDevice.WIDTH;
    public int objectsY = -RaftDevice.WIDTH;
    private int raftVel;
    private int maxSpeed;
    private int scoreCountDown = 0;
    private long gameTime;
    private long gameTimeNow;
    private long gameDuration;
    private SEGameController mParent;
    private Display display;
    private int splashCounter = -1;
    private int aLev;
    private int joyX = 0;
    private int joyY = 0;
    private int joyFire = 0;
    private boolean mapOn = false;
    private static Image renderImg;
    private LayerManager mLM;
    private Sprite renderSprite;
    private static int LEFTTOP;
    private static int RIGHTTOP;
    private static Image textImg;
    private Sprite textSprite;
    private static String[] menuTexts;
    private int menuIndex = 0;
    private int menuDelay = 0;
    private static Image mapImage;
    private Sprite mapSprite;
    private boolean isLoading = false;
    private boolean startLoad = false;

    public RaftingCanvas(int n, SEGameController sEGameController, SonyEricssonTextLabels sonyEricssonTextLabels) {
        super(false);
        this.setFullScreenMode(true);
        this.mParent = sEGameController;
        this.SELabels = sonyEricssonTextLabels;
        this.display = Display.getDisplay((MIDlet)this.mParent);
        this.level = n;
        menuTexts = new String[3];
        RaftingCanvas.menuTexts[0] = this.SELabels.getTextLabel(this.SELabels.getCurrentLanguage(), 1);
        RaftingCanvas.menuTexts[1] = this.SELabels.getTextLabel(this.SELabels.getCurrentLanguage(), 88);
        RaftingCanvas.menuTexts[2] = this.SELabels.getTextLabel(this.SELabels.getCurrentLanguage(), 20);
        this.isLoading = true;
        this.myIntro = true;
        this.startLoad = false;
        this.initAlways();
    }

    private final void initAlways() {
        this.repeater = 0;
        this.myCurrentLeftX = 0;
        this.myCurrentLeftY = 0;
        this.objectsX = 0;
        this.objectsY = 0;
        this.maxSpeed = 20;
        this.raftVel = 0;
        this.scoreCountDown = 0;
        this.gameTime = 0L;
        this.gameTimeNow = 0L;
        this.gameDuration = 0L;
        this.gameOver = false;
        this.levelComplete = false;
        this.hasHighscore = false;
    }

    public final void generateLevel() {
        int n;
        this.initAlways();
        this.maxSpeed += this.level - 27;
        this.waterPower = this.level - 27 + 5;
        this.mRaft = this.createRaft();
        this.mRaftGhost = this.createGhost();
        this.drawLoad(2);
        this.mBoard = new LevelData[2];
        for (n = 0; n < this.mBoard.length; ++n) {
            this.mBoard[n] = new LevelData(this.level, tileImages[this.level % 3], n);
            this.mBoard[n].move(0, -80);
        }
        this.drawLoad(3);
        this.mLayerManager = new LayerManager();
        this.mSpeedSplash = this.createSpeedSplash();
        this.mRaft.setPosition(80, 380);
        this.mRaft.forward(0);
        this.mRaft.requestMove(0, 0);
        this.mRaftGhost.setPosition(this.mRaft.getX(), this.mRaft.getY());
        this.mRaftGhost.setVisible(false);
        this.mLayerManager.append((Layer)this.mRaft);
        this.water = null;
        this.water = new WaterEffects[this.waterPower * 2 + 8];
        for (n = 0; n < this.water.length; ++n) {
            this.water[n] = new WaterEffects();
        }
        this.mCollSplash = this.createCollSplash();
        this.mCollSplash.setVisible(false);
        this.mCollSplash.setPosition(0, 24);
        this.mSpeedSplash.setVisible(false);
        this.mLayerManager.append((Layer)this.mSpeedSplash);
        this.mLayerManager.append((Layer)this.mCollSplash);
        this.drawLoad(4);
        for (n = 0; n < this.mBoard.length; ++n) {
            this.mLayerManager.append((Layer)this.mBoard[n]);
        }
        this.mLayerManager.append((Layer)this.mRaftGhost);
        this.gameOver = false;
        this.levelComplete = false;
        this.mLM = new LayerManager();
        this.renderSprite = new Sprite(renderImg, 240, 240);
        this.mLM.append((Layer)this.renderSprite);
        this.renderSprite.defineReferencePixel(0, 0);
        this.renderSprite.setTransform(0);
        this.renderSprite.setPosition(0, 0);
        this.textSprite = new Sprite(textImg, 72, 18);
        this.textSprite.setTransform(0);
        this.textSprite.setPosition(0, 0);
        this.mapSprite = new Sprite(mapImage, 64, 64);
        this.mapSprite.setTransform(0);
        this.mapSprite.setPosition(161, 8);
        if (this.mParent.renderState == 0) {
            this.renderSprite.setTransform(5);
            this.renderSprite.setPosition(0, 0);
            this.textSprite.setTransform(5);
            this.textSprite.setPosition(183, 2);
            this.mapSprite.setTransform(5);
            this.mapSprite.setPosition(23, 6);
        } else if (this.mParent.renderState == 1) {
            this.mapSprite.setTransform(0);
            this.mapSprite.setPosition(161, 8);
        } else {
            this.renderSprite.setTransform(6);
            this.renderSprite.setPosition(0, 0);
            this.textSprite.setTransform(6);
            this.textSprite.setPosition(48, 2);
            this.mapSprite.setTransform(6);
            this.mapSprite.setPosition(162, 6);
            this.mParent.renderState = -1;
        }
    }

    public final void start() {
        this.mTrucking = true;
        Thread thread = new Thread(this);
        thread.start();
    }

    private final void drawLoad(int n) {
        Graphics graphics = this.getGraphics();
        int n2 = (this.getWidth() - SplashCanvas.splash.getWidth()) / 2;
        int n3 = (this.getHeight() - SplashCanvas.splash.getHeight()) / 2;
        graphics.setFont(RaftDevice.FONT_MEDIUM);
        graphics.drawImage(SplashCanvas.splash, this.getWidth() / 2, this.getHeight() / 2, 3);
        graphics.setColor(0);
        graphics.drawString(this.SELabels.getTextLabel(this.SELabels.getCurrentLanguage(), 89), this.getWidth() / 2, 71, 17);
        graphics.drawRect(n2 - 1, n3 + SplashCanvas.splash.getHeight() + 2, SplashCanvas.splash.getWidth() + 2, 11);
        graphics.setColor(0xFFFFFF);
        graphics.drawString(this.SELabels.getTextLabel(this.SELabels.getCurrentLanguage(), 89), this.getWidth() / 2 + 1, 70, 17);
        graphics.setColor(0x3333FF);
        int n4 = SplashCanvas.splash.getWidth() / 5;
        graphics.fillRect(n2, n3 + SplashCanvas.splash.getHeight() + 3, n * n4, 10);
        this.flushGraphics();
    }

    public final void run() {
        long l;
        Graphics graphics = this.getGraphics();
        Graphics graphics2 = renderImg.getGraphics();
        int n = 80;
        long l2 = l = System.currentTimeMillis();
        while (this.mTrucking) {
            int n2;
            long l3 = System.currentTimeMillis();
            this.gameDuration = l3 - l;
            l = System.currentTimeMillis();
            if (this.myIntro) {
                if (this.isLoading) {
                    this.drawLoad(1);
                    this.isLoading = false;
                    this.generateLevel();
                    this.drawLoad(5);
                } else {
                    if (this.mParent.renderState == 1) {
                        this.render(graphics);
                        this.drawReadyGo(graphics);
                    } else {
                        this.render(graphics2);
                        this.drawReadyGo(graphics);
                        this.flipRender(graphics);
                    }
                    this.drawHUD(graphics);
                    this.flushGraphics();
                }
                if ((n2 = (int)((l2 = System.currentTimeMillis()) - l3)) >= n) continue;
                try {
                    Thread.sleep(n - n2);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            if (!(this.gameOver || this.levelComplete || this.mapOn)) {
                this.gameTimeNow += this.gameDuration;
            }
            if (!this.gameOver && !this.levelComplete) {
                this.input();
            }
            if (!this.mapOn) {
                this.tick();
            }
            if (this.mParent.renderState == 1) {
                this.render(graphics);
                if (this.gameOver) {
                    this.drawGameOver(graphics);
                }
                if (this.levelComplete) {
                    this.drawLevelComplete(graphics);
                }
            } else {
                this.render(graphics2);
                if (this.gameOver) {
                    this.drawGameOver(graphics2);
                }
                if (this.levelComplete) {
                    this.drawLevelComplete(graphics2);
                }
                this.flipRender(graphics);
            }
            this.drawHUD(graphics);
            this.flushGraphics();
            l2 = System.currentTimeMillis();
            n2 = (int)(l2 - l3);
            this.joyFire = 0;
            this.joyY = 0;
            this.joyX = 0;
            if (n2 >= n) continue;
            try {
                Thread.sleep(n - n2);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private final void tick() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        this.inputDelta = 1;
        if (this.joyFire != 0) {
            ++this.inputDelta;
            this.speedSplashCounter = 10;
        }
        if (this.joyX == -1) {
            this.mRaft.forward(-this.inputDelta);
            --this.raftVel;
        } else if (this.joyX == 1) {
            this.mRaft.forward(this.inputDelta);
            --this.raftVel;
        } else if (this.joyY == -1) {
            this.mRaft.forward(this.inputDelta);
            --this.raftVel;
        } else if (this.joyY == 1) {
            this.mRaft.forward(-this.inputDelta);
            --this.raftVel;
        } else {
            this.mRaft.followStream();
        }
        if (this.raftVel <= 0) {
            this.raftVel = 0;
        }
        if (this.raftVel < this.maxSpeed) {
            ++this.raftVel;
        }
        int n = (this.raftVel + this.inputDelta >> 3) * 2;
        int n2 = this.raftVel + this.inputDelta >> 3;
        if (!this.gameOver && !this.levelComplete) {
            this.mRaft.requestMove(n, n2);
            this.mRaftGhost.setVisible(true);
            this.mRaftGhost.setFrame(this.mRaft.getGhostFrame());
            this.mRaftGhost.setTransform(this.mRaft.getGhostTransform());
            this.mBoard[0].tick(n, n2);
            this.mBoard[1].tick(n, n2);
        } else {
            this.mBoard[0].tick(0, 0);
            this.mBoard[1].tick(0, 0);
        }
        this.mRaft.tick(this);
        this.mRaftGhost.setPosition(this.mRaft.getX(), this.mRaft.getY());
        if (this.mRaftGhost.collidesWith((TiledLayer)this.mBoard[0], true)) {
            bl2 = true;
            this.mBoard[0].move(n, n2);
            this.mBoard[1].move(n, n2);
            bl3 = true;
            this.splashCounter = 2;
            this.mCollSplash.setVisible(true);
            this.mCollSplash.setPosition(this.mRaft.getX() + 48 - this.getRandomInt(5), this.mRaft.getY() + 16 + this.getRandomInt(20));
        }
        if (this.mRaft.moveModifierOn && this.mRaftGhost.collidesWith((TiledLayer)this.mBoard[1], true)) {
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            n3 = (this.mRaftGhost.getX() - this.mBoard[1].getX()) / 20;
            n4 = (this.mRaftGhost.getY() - this.mBoard[1].getY()) / 20;
            ++n3;
            ++n4;
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    if (this.mBoard[1].getCell(n3 + i, n4 + j) != this.mBoard[1].W2[0] && this.mBoard[1].getCell(n3 + i, n4 + j) != this.mBoard[1].W2[1]) continue;
                    n5 = 4;
                }
            }
            this.mRaft.setDamage(n5);
            bl3 = true;
            this.splashCounter = 2;
            this.mCollSplash.setVisible(true);
            this.mCollSplash.setPosition(this.mRaft.getX() + 48, this.mRaft.getY() + 16);
        }
        if (bl2) {
            this.raftVel = 0;
            this.mRaft.undoMove(-n, -n2);
            this.mRaft.stopDamage(3 + this.raftVel);
        } else if (this.raftVel < 0) {
            this.raftVel = 0;
        }
        if (this.splashCounter >= 0) {
            this.mCollSplash.setFrame(2 - this.splashCounter);
            --this.splashCounter;
        } else {
            this.mCollSplash.setVisible(false);
        }
        if (this.speedSplashCounter > 0 && this.mRaft.getState()) {
            if (this.mRaft.getGhostFrame() < 4) {
                ++this.speedAnim;
                this.speedAnim %= 3;
                this.mSpeedSplash.setTransform(this.mRaft.getGhostTransform());
                this.mSpeedSplash.setFrame(this.mRaft.getGhostFrame() + this.speedAnim * 4);
                this.mSpeedSplash.setPosition(this.mRaft.getX() - 12, this.mRaft.getY());
                this.mSpeedSplash.setVisible(true);
                --this.speedSplashCounter;
            }
        } else {
            this.mSpeedSplash.setVisible(false);
        }
        if (this.mRaft.getDamage() < 1) {
            this.gameOver = true;
            this.mRaft.setDeath();
        }
        if (bl3 && !this.gameOver) {
            RaftDevice.collisionEffect(this.display, this.mParent.vibration);
        }
        if (this.gameOver) {
            RaftDevice.collisionEffect(this.display, 0);
        }
        if (this.mRaft.getShadow()) {
            this.mRaftGhost.setVisible(true);
            this.mRaftGhost.setPosition(this.mRaft.getX(), this.mRaft.getShadowPos());
        } else {
            this.mRaftGhost.setVisible(false);
        }
        this.wrapMap();
    }

    private final void render(Graphics graphics) {
        int n;
        if (this.mParent.renderState == 1) {
            graphics.setColor(4423868);
            graphics.fillRect(0, 80, RaftDevice.WIDTH, RaftDevice.GAME_HEIGHT);
            graphics.setColor(2639488);
            for (n = 0; n < this.waterPower; ++n) {
                this.water[n].rita(graphics);
            }
            graphics.setColor(0xFFFFFF);
            for (n = this.waterPower; n < this.water.length; ++n) {
                this.water[n].rita(graphics);
            }
            n = RaftDevice.GAME_HEIGHT >> 1;
            this.mLayerManager.setViewWindow(this.mRaftGhost.getX() - 16, this.mRaftGhost.getY() - 40, RaftDevice.WIDTH, RaftDevice.GAME_HEIGHT);
            this.mLayerManager.paint(graphics, 0, 80);
        } else {
            graphics.setColor(4423868);
            graphics.fillRect(0, 0, RaftDevice.WIDTH, RaftDevice.GAME_HEIGHT);
            graphics.setColor(2639488);
            for (n = 0; n < this.waterPower; ++n) {
                this.water[n].rita(graphics);
            }
            graphics.setColor(0xFFFFFF);
            for (n = this.waterPower; n < this.water.length; ++n) {
                this.water[n].rita(graphics);
            }
            n = RaftDevice.GAME_HEIGHT >> 1;
            this.mLayerManager.setViewWindow(this.mRaftGhost.getX() - 16, this.mRaftGhost.getY() - 40, RaftDevice.WIDTH, RaftDevice.GAME_HEIGHT);
            this.mLayerManager.paint(graphics, 0, 0);
        }
        if (this.mapOn) {
            int n2;
            ++this.menuDelay;
            n = RaftDevice.FONT_MEDIUM.getHeight();
            int n3 = RaftDevice.CENTERY - n;
            if (this.menuDelay <= 3 || this.joyY != 0) {
                // empty if block
            }
            graphics.setFont(RaftDevice.FONT_MEDIUM);
            graphics.setColor(0);
            for (n2 = 0; n2 < menuTexts.length; ++n2) {
                graphics.drawString(menuTexts[n2], RaftDevice.CENTERX + 1, n3 + n2 * n + 1, 17);
            }
            graphics.setColor(0xFFFFFF);
            for (n2 = 0; n2 < menuTexts.length; ++n2) {
                graphics.drawString(menuTexts[n2], RaftDevice.CENTERX, n3 + n2 * n, 17);
            }
            graphics.setColor(0x44FF44);
            graphics.drawString(menuTexts[this.menuIndex], RaftDevice.CENTERX, n3 + this.menuIndex * n, 17);
            if (this.joyFire != 0 && this.menuDelay > 1) {
                if (this.menuIndex == 0) {
                    this.mapOn = false;
                } else if (this.menuIndex == 1) {
                    ++this.mParent.renderState;
                    if (this.mParent.renderState == 0) {
                        this.renderSprite.setTransform(5);
                        this.renderSprite.setPosition(0, 0);
                        this.textSprite.setTransform(5);
                        this.textSprite.setPosition(183, 2);
                        this.mapSprite.setTransform(5);
                        this.mapSprite.setPosition(23, 6);
                    } else if (this.mParent.renderState == 1) {
                        this.mapSprite.setTransform(0);
                        this.mapSprite.setPosition(161, 8);
                    } else {
                        this.renderSprite.setTransform(6);
                        this.renderSprite.setPosition(0, 0);
                        this.textSprite.setTransform(6);
                        this.textSprite.setPosition(48, 2);
                        this.mapSprite.setTransform(6);
                        this.mapSprite.setPosition(162, 6);
                        this.mParent.renderState = -1;
                    }
                    this.menuDelay = 0;
                } else {
                    this.mParent.stopGame();
                }
            }
        }
    }

    private final void flipRender(Graphics graphics) {
        this.mLM.paint(graphics, 0, 80);
    }

    private final void wrapMap() {
        if (this.mBoard[0].victory && !this.levelComplete) {
            this.mRaft.setState(9);
            this.levelComplete = true;
            int n = 2 * this.mBoard[0].levelLength + this.mRaft.getDamage() * 2;
            int n2 = this.mBoard[0].levelLength * 20 * 2 / 52 * 10;
            int n3 = (int)this.gameTimeNow / 100;
            if (n2 > n3) {
                n += n2 - n3;
            }
            if (n < 0) {
                n = 0 + this.mRaft.getDamage() * 2;
            }
            if (this.mParent.unlockNextLevel(n)) {
                this.hasHighscore = true;
            }
        }
    }

    private final void drawHUD(Graphics graphics) {
        Graphics graphics2 = textImg.getGraphics();
        graphics2.setFont(RaftDevice.FONT_SMALL);
        graphics2.setColor(0xFFFFFF);
        graphics2.fillRect(0, 0, 72, 18);
        graphics2.setColor(0);
        graphics.setFont(RaftDevice.FONT_SMALL);
        graphics.setColor(0);
        long l = this.gameTimeNow / 100L;
        Graphics graphics3 = mapImage.getGraphics();
        LevelData cfr_ignored_0 = this.mBoard[0];
        graphics3.drawRGB(LevelData.miniMap, 0, 64, 0, 0, 64, 64, false);
        graphics3.setColor(255, 0, 0);
        graphics3.fillRect((this.mRaft.getX() - this.mBoard[0].getX()) / 20 * 2 - 4, (this.mRaft.getY() - this.mBoard[0].getY()) / 20 * 2 - 30, 2, 2);
        if (this.mParent.renderState == 1) {
            graphics.drawImage(rot_interfaceImages, 0, 0, 20);
            this.mapSprite.paint(graphics);
            graphics.drawString("" + l, 76, 13, 17);
            int n = this.mRaft.getDamage();
            if (n > 0) {
                graphics.setColor(255 - (n <<= 1), n + 100, 0);
                graphics.fillRect(40, 52, RaftDevice.scaleHealthbar(this.mRaft.getDamage()), 14);
            }
        } else if (this.mParent.renderState == 0) {
            graphics.drawImage(interfaceImages, 0, 0, 20);
            this.mapSprite.paint(graphics);
            graphics2.drawString("" + l, 36, 0, 17);
            this.textSprite.paint(graphics);
            int n = this.mRaft.getDamage();
            if (n > 0) {
                graphics.setColor(255 - (n <<= 1), n + 100, 0);
                graphics.fillRect(131, 1, 14, RaftDevice.scaleHealthbar(this.mRaft.getDamage()));
            }
        } else {
            graphics.drawImage(f_interfaceImages, 0, 0, 20);
            this.mapSprite.paint(graphics);
            graphics2.drawString("" + l, 36, 0, 17);
            this.textSprite.paint(graphics);
            int n = this.mRaft.getDamage();
            if (n > 0) {
                graphics.setColor(255 - (n <<= 1), n + 100, 0);
                graphics.fillRect(104, 1, 14, RaftDevice.scaleHealthbar(this.mRaft.getDamage()));
            }
        }
    }

    private final void drawGameOver(Graphics graphics) {
        graphics.setFont(RaftDevice.FONT_MEDIUM);
        graphics.setColor(0);
        graphics.drawString(this.SELabels.getTextLabel(this.SELabels.getCurrentLanguage(), 17), RaftDevice.CENTERX + 1, RaftDevice.CENTERY + 1, 33);
        graphics.setColor(0xFFFFFF);
        graphics.drawString(this.SELabels.getTextLabel(this.SELabels.getCurrentLanguage(), 17), RaftDevice.CENTERX, RaftDevice.CENTERY, 33);
        if (this.scoreCountDown >= 60) {
            this.mParent.setGametypeMenu();
        }
        ++this.scoreCountDown;
    }

    private final void drawReadyGo(Graphics graphics) {
        this.aLev = this.level - 27 + 74;
        if (RaftDevice.FONT_MEDIUM.stringWidth(this.SELabels.getTextLabel(this.SELabels.getCurrentLanguage(), this.level)) < RaftDevice.WIDTH) {
            this.aLev = this.level;
        }
        this.mBoard[0].drawMap(graphics, this.SELabels.getTextLabel(this.SELabels.getCurrentLanguage(), this.aLev));
        ++this.myIntroDelay;
        if (this.myIntroDelay < 30) {
            graphics.setFont(RaftDevice.FONT_MEDIUM);
            if (this.myIntroDelay % 6 < 3) {
                graphics.setColor(0);
                graphics.drawString(this.SELabels.getTextLabel(this.SELabels.getCurrentLanguage(), 22), RaftDevice.CENTERX + 1, RaftDevice.CENTERY + 1, 33);
                graphics.setColor(0xFFFFFF);
                graphics.drawString(this.SELabels.getTextLabel(this.SELabels.getCurrentLanguage(), 22), RaftDevice.CENTERX, RaftDevice.CENTERY, 33);
            }
            graphics.setColor(0);
            graphics.drawString(this.SELabels.getTextLabel(this.SELabels.getCurrentLanguage(), this.aLev), RaftDevice.CENTERX + 1, RaftDevice.CENTERY + 1 - RaftDevice.FONT_MEDIUM.getHeight(), 33);
            graphics.setColor(0xFFFFFF);
            graphics.drawString(this.SELabels.getTextLabel(this.SELabels.getCurrentLanguage(), this.aLev), RaftDevice.CENTERX, RaftDevice.CENTERY - RaftDevice.FONT_MEDIUM.getHeight(), 33);
        } else if (this.myIntroDelay < 40) {
            graphics.setFont(RaftDevice.FONT_MEDIUM);
            graphics.setColor(0);
            graphics.drawString(this.SELabels.getTextLabel(this.SELabels.getCurrentLanguage(), this.aLev), RaftDevice.CENTERX + 1, RaftDevice.CENTERY + 1 - RaftDevice.FONT_MEDIUM.getHeight(), 33);
            graphics.drawString(this.SELabels.getTextLabel(this.SELabels.getCurrentLanguage(), 23), RaftDevice.CENTERX + 1, RaftDevice.CENTERY + 1, 33);
            graphics.setColor(0xFFFFFF);
            graphics.drawString(this.SELabels.getTextLabel(this.SELabels.getCurrentLanguage(), this.aLev), RaftDevice.CENTERX, RaftDevice.CENTERY - RaftDevice.FONT_MEDIUM.getHeight(), 33);
            graphics.drawString(this.SELabels.getTextLabel(this.SELabels.getCurrentLanguage(), 23), RaftDevice.CENTERX, RaftDevice.CENTERY, 33);
        } else {
            this.myIntroDelay = 0;
            this.myIntro = false;
        }
    }

    private final void drawLevelComplete(Graphics graphics) {
        graphics.setFont(RaftDevice.FONT_MEDIUM);
        graphics.setColor(0);
        if (this.hasHighscore) {
            graphics.drawString(this.SELabels.getTextLabel(this.SELabels.getCurrentLanguage(), 18), RaftDevice.CENTERX + 1, RaftDevice.CENTERY + 1, 33);
            graphics.drawString(this.SELabels.getTextLabel(this.SELabels.getCurrentLanguage(), 16), RaftDevice.CENTERX + 1, RaftDevice.CENTERY + 21, 33);
            graphics.setColor(0xFFFFFF);
            graphics.drawString(this.SELabels.getTextLabel(this.SELabels.getCurrentLanguage(), 18), RaftDevice.CENTERX, RaftDevice.CENTERY, 33);
            graphics.drawString(this.SELabels.getTextLabel(this.SELabels.getCurrentLanguage(), 16), RaftDevice.CENTERX, RaftDevice.CENTERY + 20, 33);
            if (this.scoreCountDown >= 30) {
                this.mParent.requestSaveScore();
            }
        } else {
            graphics.drawString(this.SELabels.getTextLabel(this.SELabels.getCurrentLanguage(), 18), RaftDevice.CENTERX + 1, RaftDevice.CENTERY + 1, 33);
            graphics.setColor(0xFFFFFF);
            graphics.drawString(this.SELabels.getTextLabel(this.SELabels.getCurrentLanguage(), 18), RaftDevice.CENTERX, RaftDevice.CENTERY, 33);
            if (this.scoreCountDown >= 60) {
                this.mParent.setGametypeMenu();
            }
        }
        ++this.scoreCountDown;
    }

    public final void stop() {
        this.mTrucking = false;
    }

    protected final void hideNotify() {
        this.stop();
    }

    protected final void showNotify() {
        if (!this.mTrucking) {
            this.start();
        }
    }

    public final int getRandomInt(int n) {
        int n2 = this.myRandom.nextInt() % n;
        if (n2 < 0) {
            n2 += n;
        }
        return n2;
    }

    private final void input() {
        int n = this.getKeyStates();
        this.inputDelta = 1;
        if ((n & 0x100) != 0) {
            this.joyFire = 1;
        }
        if (this.mParent.renderState == 1) {
            if ((n & 4) != 0) {
                this.joyX = -1;
            } else if ((n & 0x20) != 0) {
                this.joyX = 1;
            } else if ((n & 2) != 0) {
                this.joyY = -1;
            } else if ((n & 0x40) != 0) {
                this.joyY = 1;
            }
        }
        if (this.mParent.renderState == 0) {
            if ((n & 4) != 0) {
                this.joyY = 1;
            } else if ((n & 0x20) != 0) {
                this.joyY = -1;
            } else if ((n & 2) != 0) {
                this.joyX = -1;
            } else if ((n & 0x40) != 0) {
                this.joyX = 1;
            }
        } else if ((n & 4) != 0) {
            this.joyY = -1;
        } else if ((n & 0x20) != 0) {
            this.joyY = 1;
        } else if ((n & 2) != 0) {
            this.joyX = 1;
        } else if ((n & 0x40) != 0) {
            this.joyX = -1;
        }
    }

    public final void keyPressed(int n) {
        if (n == -11) {
            if (this.mapOn) {
                this.mapOn = false;
            } else {
                this.mParent.stopGame();
            }
        } else if (n == -7 || n == -6) {
            if (!(this.myIntro || this.levelComplete || this.gameOver)) {
                this.mapOn = !this.mapOn;
            }
        } else if (this.mapOn) {
            int n2 = this.getGameAction(n);
            int n3 = 0;
            if (this.mParent.renderState == 1) {
                if (n2 == 1) {
                    n3 = -1;
                } else if (n2 == 6) {
                    n3 = 1;
                }
            }
            if (this.mParent.renderState == 0) {
                if (n2 == 2) {
                    n3 = 1;
                } else if (n2 == 5) {
                    n3 = -1;
                }
            } else if (n2 == 2) {
                n3 = -1;
            } else if (n2 == 5) {
                n3 = 1;
            }
            if (50 == n) {
                n3 = -1;
            } else if (56 == n) {
                n3 = 1;
            }
            this.menuIndex += n3;
            if (this.menuIndex < 0) {
                this.menuIndex = menuTexts.length - 1;
            }
            this.menuIndex %= menuTexts.length;
            this.menuDelay = 0;
        }
    }

    private final RaftSprite createRaft() {
        return new RaftSprite(raftImage, 64, 64, this);
    }

    private final Sprite createCollSplash() {
        return new Sprite(collSplash, 22, 22);
    }

    private final Sprite createSpeedSplash() {
        return new Sprite(speedSplash, 64, 64);
    }

    private final Sprite createGhost() {
        return new Sprite(ghostImage, 64, 64);
    }

    public final void commandAction(Command command, Displayable displayable) {
    }

    static {
        LEFTTOP = 20;
        RIGHTTOP = 24;
        mapImage = Image.createImage((int)64, (int)64);
        textImg = Image.createImage((int)72, (int)18);
        renderImg = Image.createImage((int)240, (int)240);
        tileImages = new Image[3];
        try {
            RaftingCanvas.tileImages[0] = Image.createImage((String)"/rockyTileSet.png");
            RaftingCanvas.tileImages[1] = Image.createImage((String)"/forestTileSet.png");
            RaftingCanvas.tileImages[2] = Image.createImage((String)"/mountainTileSet.png");
            interfaceImages = Image.createImage((String)"/gui_r.png");
            f_interfaceImages = Image.createImage((String)"/m_gui_r.png");
            rot_interfaceImages = Image.createImage((String)"/rot_gui_r.png");
            raftImage = Image.createImage((String)"/raft.png");
            ghostImage = Image.createImage((String)"/raft_mask.png");
            collSplash = Image.createImage((String)"/collSplash.png");
            speedSplash = Image.createImage((String)"/speedSplash.png");
        }
        catch (IOException iOException) {
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
    }
}

