/*
 * Decompiled with CFR 0.152.
 */
package com.tinyline.tiny2d;

public final class TinyString {
    public char[] data;
    public int count;

    public TinyString(char[] cArray) {
        this.count = cArray.length;
        this.data = new char[this.count];
        System.arraycopy(cArray, 0, this.data, 0, this.count);
    }

    public TinyString(char[] cArray, int n, int n2) {
        this.count = n2;
        this.data = new char[this.count];
        System.arraycopy(cArray, n, this.data, 0, this.count);
    }

    public final boolean startsWith(TinyString tinyString, int n) {
        char[] cArray = this.data;
        int n2 = n;
        char[] cArray2 = tinyString.data;
        int n3 = 0;
        int n4 = tinyString.count;
        if (n < 0 || n > this.count - n4) {
            return false;
        }
        while (--n4 >= 0) {
            if (cArray[n2++] == cArray2[n3++]) continue;
            return false;
        }
        return true;
    }

    public final boolean endsWith(TinyString tinyString) {
        return this.startsWith(tinyString, this.count - tinyString.count);
    }

    public final TinyString trim() {
        int n;
        int n2 = this.count;
        char[] cArray = this.data;
        for (n = 0; n < n2 && cArray[0 + n] <= ' '; ++n) {
        }
        while (n < n2 && cArray[0 + n2 - 1] <= ' ') {
            --n2;
        }
        if (n <= 0 && n2 >= this.count) {
            return this;
        }
        return new TinyString(this.data, n2, n - n2);
    }

    public final TinyString substring(int n) {
        return this.substring(n, this.count);
    }

    public final TinyString substring(int n, int n2) {
        if (n < 0 || n2 > this.count || n > n2) {
            return null;
        }
        if (n == 0 && n2 == this.count) {
            return new TinyString(this.data, 0, this.count);
        }
        return new TinyString(this.data, n, n2 - n);
    }

    public final int indexOf(int n, int n2) {
        int n3 = this.count;
        char[] cArray = this.data;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= this.count) {
            return -1;
        }
        for (int i = n2; i < n3; ++i) {
            if (cArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    public final int lastIndexOf(int n, int n2) {
        int n3;
        char[] cArray = this.data;
        int n4 = n3 = n2 >= this.count ? this.count - 1 : n2;
        while (n3 >= 0) {
            if (cArray[n3] == n) {
                return n3;
            }
            --n3;
        }
        return -1;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof TinyString) {
            TinyString tinyString = (TinyString)object;
            return TinyString.compareTo(this.data, 0, this.count, tinyString.data, 0, tinyString.count) == 0;
        }
        return false;
    }

    public static int compareTo(char[] cArray, int n, int n2, char[] cArray2, int n3, int n4) {
        int n5;
        int n6 = n5 = n2 <= n4 ? n2 : n4;
        while (n5-- != 0) {
            char c2;
            char c3;
            if ((c3 = cArray[n++]) == (c2 = cArray2[n3++])) continue;
            return c3 - c2;
        }
        return n2 - n4;
    }

    public static int hashCode(char[] cArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 = 31 * n3 + cArray[n++];
        }
        return n3;
    }

    public static int getIndex(char[][] cArray, char[] cArray2, int n, int n2) {
        int n3;
        int n4 = -1;
        int n5 = n3 = cArray.length;
        while (n3 - n4 > 1) {
            int n6 = (n3 + n4) / 2;
            if (TinyString.compareTo(cArray[n6], 0, cArray[n6].length, cArray2, n, n2) < 0) {
                n4 = n6;
                continue;
            }
            n5 = n6;
        }
        if (n3 < cArray.length && TinyString.compareTo(cArray[n3], 0, cArray[n3].length, cArray2, n, n2) == 0) {
            return n3;
        }
        return cArray.length;
    }
}

