/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.ProgressListener;
import game.SoccerCanvas;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import mirl.Mirl;

public class ImageBank {
    private static int numAngles = 30;
    private static int degPerFrame = 90 / numAngles;
    private static Hashtable images = new Hashtable();
    private static Hashtable rotatedImages = new Hashtable();
    private static String size = null;
    static /* synthetic */ Class class$0;

    public static void cache(String[] images, String[] rotatedImages) {
        ImageBank.cache(images, rotatedImages, -1, null);
    }

    public static void cache(String[] images, String[] rotatedImages, int angles, ProgressListener pl) {
        String path;
        if (angles > 0) {
            numAngles = angles;
            degPerFrame = 90 / angles;
        }
        int tot = images.length + rotatedImages.length * numAngles;
        int cur = 0;
        int i = 0;
        while (i < images.length) {
            path = images[i];
            ImageBank.getImage(path);
            ++cur;
            if (pl != null) {
                pl.progress(cur, tot);
            }
            ++i;
        }
        i = 0;
        while (i < rotatedImages.length) {
            path = rotatedImages[i];
            int j = 0;
            while (j < numAngles) {
                int a2 = j * degPerFrame;
                ImageBank.getRotatedImage(path, a2);
                ++cur;
                if (pl != null) {
                    pl.progress(cur, tot);
                }
                ++j;
            }
            ++i;
        }
    }

    private static void getSizePath() {
        if (size == null) {
            size = SoccerCanvas.getInstance().getHeight() >= 320 ? "/big" : (SoccerCanvas.getInstance().getHeight() >= 220 ? "/mid" : (SoccerCanvas.getInstance().getHeight() >= 160 ? "/small" : "/small"));
        }
    }

    public static int getRotationForRotatedImage(int a2) {
        float hdpf = (float)degPerFrame / 2.0f;
        if ((float)a2 > 360.0f - hdpf) {
            return 0;
        }
        if ((float)a2 > 270.0f - hdpf) {
            return 6;
        }
        if ((float)a2 > 180.0f - hdpf) {
            return 3;
        }
        if ((float)a2 > 90.0f - hdpf) {
            return 5;
        }
        return 0;
    }

    public static Image getRotatedImage(String path, int angle) {
        Image result;
        Vector<Image> images;
        int a2 = angle % 90;
        float hdpf = (float)degPerFrame / 2.0f;
        int r = 0;
        if ((float)a2 < 90.0f - hdpf) {
            r = (int)(((float)a2 + hdpf) / (float)degPerFrame);
        }
        if ((images = (Vector<Image>)rotatedImages.get(path)) == null) {
            images = new Vector<Image>(numAngles);
            int i = 0;
            while (i < numAngles) {
                images.addElement(null);
                ++i;
            }
            rotatedImages.put(path, images);
        }
        if ((result = (Image)images.elementAt(r)) == null) {
            Image img = ImageBank.getImage(path);
            result = Mirl.rotateImage(img, r * degPerFrame);
            images.setElementAt(result, r);
        }
        return result;
    }

    public static Image getImage(String path) {
        ImageBank.getSizePath();
        Image result = (Image)images.get(path);
        if (result == null) {
            try {
                String p = String.valueOf(size) + path;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("game.ImageBank");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                InputStream is = clazz.getResourceAsStream(p);
                Image img = Image.createImage((InputStream)is);
                images.put(path, img);
                result = img;
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        return result;
    }

    public static Image getImage(String name, int dir, int anim, int frame) {
        String path = "/" + name + "/" + dir + "." + anim + "." + frame + ".png";
        return ImageBank.getImage(path);
    }

    public static int getHeaderHeight() {
        if (SoccerCanvas.getInstance().getHeight() >= 320) {
            return 32;
        }
        if (SoccerCanvas.getInstance().getHeight() >= 220) {
            return 21;
        }
        if (SoccerCanvas.getInstance().getHeight() >= 160) {
            return 16;
        }
        return 16;
    }
}

