/*
 * Decompiled with CFR 0.152.
 */
package com.concretesoftware.holdem;

import com.concretesoftware.holdem.Player;
import com.concretesoftware.holdem.Sprite;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ChipPile
extends Sprite {
    private Image chipsImage;
    private short chipTileWidth;
    private short chipTileHeight;
    private short chipDisplayWidth;
    private short chipDisplayHeight;
    private short[] chipAmounts;
    private byte extraImageIndex;
    private byte chipsWide;
    private byte chipsHigh;
    private boolean displayBet;

    public ChipPile(int layer, int x, int y, int chipTileWidth, int chipDisplayWidth, int chipDisplayHeight, int chipsWide, int chipsHigh, boolean displayBet, Image chipsImage, short[] chipAmounts) {
        super(12, layer, new short[]{(short)x, (short)y, 0, 0, 0, 0}, null, null);
        this.chipTileWidth = (short)chipTileWidth;
        this.chipDisplayWidth = (short)chipDisplayWidth;
        this.chipDisplayHeight = (short)chipDisplayHeight;
        this.chipsWide = (byte)chipsWide;
        this.chipsHigh = (byte)chipsHigh;
        this.displayBet = displayBet;
        this.chipsImage = chipsImage;
        this.chipTileHeight = (short)chipsImage.getHeight();
        this.chipAmounts = chipAmounts;
        this.extraImageIndex = (byte)chipAmounts.length;
    }

    public void paint(Graphics g, byte layer, int x, int y, Player player) {
        if (this.layer != layer || !this.visible) {
            return;
        }
        if (this.pot != null || player != null) {
            long amount = this.pot != null ? this.pot.getAmount() : (this.displayBet ? player.bet : player.holdings);
            int xChip = 1;
            int yChip = 1;
            int origY = y -= this.chipTileHeight;
            for (int chipIndex = 0; amount > 0L && chipIndex < this.chipAmounts.length; ++chipIndex) {
                short chipAmount = this.chipAmounts[chipIndex];
                for (long count = amount / (long)chipAmount; count > 0L; --count) {
                    if ((amount -= (long)chipAmount) > 0L && xChip == this.chipsWide && yChip == this.chipsHigh) {
                        ChipPile.drawImagePart(g, x, y, this.extraImageIndex * this.chipTileWidth, 0, this.chipTileWidth, this.chipTileHeight, this.chipsImage);
                        count = 0L;
                        amount = 0L;
                        continue;
                    }
                    ChipPile.drawImagePart(g, x, y, chipIndex * this.chipTileWidth, 0, this.chipTileWidth, this.chipTileHeight, this.chipsImage);
                    if (yChip == this.chipsHigh) {
                        y = origY;
                        x += this.chipDisplayWidth;
                        yChip = 0;
                        ++xChip;
                        continue;
                    }
                    y -= this.chipDisplayHeight;
                    ++yChip;
                }
            }
        }
    }

    public Sprite clone(int x, int y) {
        return new ChipPile(this.layer, x, y, this.chipTileWidth, this.chipDisplayWidth, this.chipDisplayHeight, this.chipsWide, this.chipsHigh, this.displayBet, this.chipsImage, this.chipAmounts);
    }
}

