/*
 * Decompiled with CFR 0.152.
 */
package com.concretesoftware.holdem;

import com.concretesoftware.holdem.GameController;
import com.concretesoftware.holdem.HoldemCanvas;
import com.concretesoftware.holdem.InfoScreen;
import com.concretesoftware.holdem.Player;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;

public class Holdem
extends MIDlet
implements Runnable {
    private static long[] SPLASH_DELAYS = new long[]{1000L, 1000L, 4000L};
    public static HoldemCanvas gameCanvas;
    private static InfoScreen mainMenuScreen;
    private static InfoScreen editPlayerScreen;
    private static InfoScreen otherPlayersScreen1;
    private static InfoScreen otherPlayersScreen2;
    private static InfoScreen blindsInfoScreen;
    private static InfoScreen blindsTypeScreen;
    private static InfoScreen startingBlindsScreen;
    private static InfoScreen blindsTimeLimitScreen;
    private static InfoScreen blindsRoundsScreen;
    private static InfoScreen gameSettingsScreen;
    private static InfoScreen statisticsListScreen;
    private static InfoScreen statisticsDisplayScreen;
    private static InfoScreen setAllMoneyScreen;
    private static InfoScreen instructionsScreen;
    private static InfoScreen aboutScreen;
    private static GameController controller;
    public static Holdem instance;
    public static Display display;
    private static boolean gameSaved;
    public static HoldemCanvas splash;
    public static boolean ignoreCommands;

    public Holdem() {
        instance = this;
    }

    public void destroyApp(boolean destroy) {
        if (!gameSaved) {
            gameSaved = true;
            GameController.instance.saveGame();
        }
        this.notifyDestroyed();
    }

    public void pauseApp() {
        if (!gameSaved) {
            gameSaved = true;
            GameController.instance.saveGame();
        }
    }

    public void startApp() {
        if (display == null) {
            display = Display.getDisplay((MIDlet)this);
            splash = new HoldemCanvas(GameController.nextSplash());
            display.setCurrent((Displayable)splash);
            new Thread(this).start();
        }
        gameSaved = false;
    }

    public void run() {
        try {
            byte nextStep;
            long timeRemaining;
            long timestamp = System.currentTimeMillis();
            if (GameController.screenStep == 2) {
                splash.incrementProgress();
                GameController.initSettings();
                splash.incrementProgress();
                controller = GameController.instance;
                splash.incrementProgress();
                controller.loadGame();
                splash.incrementProgress();
                gameCanvas = new HoldemCanvas(3);
                splash.incrementProgress();
                mainMenuScreen = new InfoScreen(6);
                editPlayerScreen = new InfoScreen(12);
                otherPlayersScreen1 = new InfoScreen(5);
                otherPlayersScreen2 = new InfoScreen(5);
                blindsInfoScreen = new InfoScreen(15);
                blindsTypeScreen = new InfoScreen(1);
                splash.incrementProgress();
                startingBlindsScreen = new InfoScreen(2);
                blindsTimeLimitScreen = new InfoScreen(3);
                blindsRoundsScreen = new InfoScreen(4);
                gameSettingsScreen = new InfoScreen(13);
                statisticsListScreen = new InfoScreen(7);
                statisticsDisplayScreen = new InfoScreen(17);
                setAllMoneyScreen = new InfoScreen(20);
                instructionsScreen = new InfoScreen(8);
                aboutScreen = new InfoScreen(11);
                splash.incrementProgress();
            }
            if ((timeRemaining = SPLASH_DELAYS[GameController.screenStep] - (System.currentTimeMillis() - timestamp)) > 0L) {
                try {
                    Thread.sleep(timeRemaining);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if ((nextStep = GameController.nextSplash()) == 3) {
                Holdem.gotoMainMenu(true);
            } else {
                display.setCurrent((Displayable)new HoldemCanvas(nextStep));
                new Thread(this).start();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final void gotoMainMenu(boolean refresh) {
        InfoScreen tempMainMenuScreen = mainMenuScreen;
        if (refresh) {
            tempMainMenuScreen.init(null, 0, 0, 0);
        }
        display.setCurrent((Displayable)tempMainMenuScreen.screen);
    }

    public static void gotoGameCanvas(boolean startNewGame) {
        if (startNewGame && !GameController.instance.gameover && display.getCurrent() instanceof List) {
            InfoScreen preScreen = new InfoScreen(16);
            preScreen.message = "Starting a new game will erase the current game in progress.";
            preScreen.nextScreen = gameCanvas;
            preScreen.init(null, 0, 0, 0);
            preScreen.screen.setTitle("Game");
            display.setCurrent((Displayable)preScreen.screen);
        } else if (gameCanvas.init(startNewGame)) {
            display.setCurrent((Displayable)gameCanvas);
        } else {
            Holdem.gotoDemoAlert();
        }
    }

    public static void gotoDemoAlert() {
        Alert alert = new Alert("Demo Version", "This is the demo version of Aces Texas Hold'em - No Limit.  You can only play 25 hands.  Please purchase the full version at http://www.concretesoftware.com/", null, AlertType.ERROR);
        alert.setTimeout(-2);
        if (display.getCurrent() instanceof List) {
            display.setCurrent((Displayable)alert);
        } else {
            InfoScreen tempMainMenuScreen = mainMenuScreen;
            tempMainMenuScreen.init(null, 0, 0, 0);
            display.setCurrent(alert, (Displayable)tempMainMenuScreen.screen);
        }
    }

    public static final void gotoEditPlayerScreen(Player player) {
        InfoScreen tempEditPlayerScreen = editPlayerScreen;
        tempEditPlayerScreen.init(player, 0, 0, 0);
        display.setCurrent((Displayable)tempEditPlayerScreen.screen);
    }

    public static final void gotoOtherPlayersScreen(int selectedIndex) {
        InfoScreen nextScreen = null;
        if (display.getCurrent() == Holdem.otherPlayersScreen1.screen) {
            otherPlayersScreen2.init(null, selectedIndex, 0, 0);
            nextScreen = otherPlayersScreen2;
        } else {
            otherPlayersScreen1.init(null, selectedIndex, 0, 0);
            nextScreen = otherPlayersScreen1;
        }
        if (!GameController.otherPlayersDisplayedSetting) {
            GameController.otherPlayersDisplayedSetting = true;
            GameController.saveSettings();
            InfoScreen preScreen = new InfoScreen(16);
            preScreen.message = "Some player changes will not take effect until you start a new game.";
            preScreen.nextScreen = nextScreen.screen;
            preScreen.init(null, 0, 0, 0);
            preScreen.screen.setTitle(nextScreen.screen.getTitle());
            display.setCurrent((Displayable)preScreen.screen);
        } else {
            display.setCurrent((Displayable)nextScreen.screen);
        }
    }

    public static final void gotoStartingBlindsScreen(int blindsType, int numberOfSecondsOrRounds) {
        InfoScreen tempStartingBlindsScreen = startingBlindsScreen;
        tempStartingBlindsScreen.init(null, 0, blindsType, numberOfSecondsOrRounds);
        if (blindsType != 0 && !GameController.startingBlindsDisplayedSetting) {
            GameController.startingBlindsDisplayedSetting = true;
            GameController.saveSettings();
            InfoScreen preScreen = new InfoScreen(16);
            preScreen.nextScreen = tempStartingBlindsScreen.screen;
            preScreen.message = "Starting blinds will not take effect until you start a new game.";
            preScreen.init(null, 0, 0, 0);
            preScreen.screen.setTitle(tempStartingBlindsScreen.screen.getTitle());
            display.setCurrent((Displayable)preScreen.screen);
        } else {
            display.setCurrent((Displayable)tempStartingBlindsScreen.screen);
        }
    }

    public static final void gotoScreen(byte screenType) {
        InfoScreen tempScreen = screenType == 1 ? blindsTypeScreen : (screenType == 15 ? blindsInfoScreen : (screenType == 3 ? blindsTimeLimitScreen : (screenType == 4 ? blindsRoundsScreen : (screenType == 13 ? gameSettingsScreen : (screenType == 7 ? statisticsListScreen : (screenType == 17 ? statisticsDisplayScreen : (screenType == 18 ? statisticsDisplayScreen : (screenType == 19 ? statisticsDisplayScreen : (screenType == 20 ? setAllMoneyScreen : (screenType == 8 ? instructionsScreen : (screenType == 11 ? aboutScreen : null)))))))))));
        switch (screenType) {
            case 3: {
                tempScreen.init(null, 0, 1, 0);
                display.setCurrent((Displayable)tempScreen.screen);
                return;
            }
            case 4: {
                tempScreen.init(null, 0, 2, 0);
                display.setCurrent((Displayable)tempScreen.screen);
                return;
            }
            case 17: 
            case 18: 
            case 19: {
                tempScreen.screenType = screenType;
            }
            case 1: 
            case 13: 
            case 15: {
                tempScreen.init(null, 0, 0, 0);
            }
            case 7: 
            case 8: 
            case 11: 
            case 20: {
                display.setCurrent((Displayable)tempScreen.screen);
                return;
            }
        }
    }

    public static final void showErrorAlert(String title, String message) {
        Alert alert = new Alert(title, message, null, AlertType.ERROR);
        alert.setTimeout(3000);
        display.setCurrent((Displayable)alert);
    }

    static {
        gameSaved = false;
        ignoreCommands = false;
    }
}

