/*
 * Decompiled with CFR 0.152.
 */
package com.concretesoftware.holdem;

import com.concretesoftware.holdem.GameController;
import com.concretesoftware.holdem.Holdem;
import com.concretesoftware.holdem.HoldemCanvas;
import com.concretesoftware.holdem.Player;
import com.concretesoftware.holdem.Sprite;
import com.nokia.mid.sound.Sound;
import java.io.InputStream;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;

public class HoldemCanvasHelper
implements Runnable {
    private HoldemCanvas canvas;
    private static GameController controller;
    private static Sprite playerController;
    public static Image offscreen;
    public static byte lastSprite;
    public static Sprite[] sprites;
    public static Thread animationThread;
    public static volatile boolean running;
    public static long lastAnimation;
    public static int action;
    public static int clickX;
    public static int clickY;
    public static int shortcutId;
    public byte screenType;
    public static Sprite message;
    public static Sprite blinds;
    public static Sprite actionsMenu;
    public static Sprite allInMenu;
    public static Sprite amountEntry;
    public static Sprite continueMenu;
    public static Sprite foldMenu;
    public static Sprite congratsMenu;
    public static final byte DEALEM_ITEM = 1;
    public static final byte CONTINUE_ITEM = 0;
    public static final byte STATISTICS_ITEM = 1;
    public static final byte RESTART_ITEM = 0;
    public static Sprite congratsImage;
    public static Sprite extendedCongratsImage;
    public static Sprite congratsText;
    public static Player congratsPlayer;
    public static int scrollingTicksLeft;
    public static boolean clearAction;
    public static Sprite actionsButton;
    public static Sprite okButton;
    public static Sprite selectButton;
    public static Sprite backButton;
    public static Sprite continueButton;
    public static Sprite leftBorderSprite;
    public static Sprite rightBorderSprite;
    public static Sprite backgroundSprite;
    public static boolean bottomCached;
    public boolean progressBarVisible;
    public static short[] progressBarCoords;
    public short progressValue;
    public short maxProgressValue;
    public static Object playingSound;
    public static Object foldSound;
    public static Object shufflingSound;
    public static Object dealCardSound;
    public static Object raiseSound;
    public static Object playersTurnSound;
    public static Object humanCongratsSound;
    private static final byte[] humanCongratsData;
    public static Image splashImage;
    public static long callCheckAction;
    public static long foldAction;
    public static long betRaiseAction;
    public static long allInAction;
    public static Image buttonsImage;
    public static Sprite[][] otherPlayerSprites;
    public boolean useServiceRepaints;
    public static boolean repaintRequired;

    public HoldemCanvasHelper(HoldemCanvas canvas, byte screenType) {
        this.canvas = canvas;
        this.screenType = screenType;
        controller = GameController.instance;
    }

    public boolean setupSplashScreen(int maxProgressValue) {
        if (this.screenType == 2) {
            splashImage = GameController.getImage("/images/splash.png");
            this.maxProgressValue = (short)maxProgressValue;
            this.progressBarVisible = true;
        }
        return this.screenType != 3;
    }

    public void setupBasicSpritesAndImages(boolean offscreenBuffer) {
        if (offscreenBuffer) {
            offscreen = Image.createImage((int)this.canvas.getWidth(), (int)this.canvas.getHeight());
        }
        buttonsImage = GameController.getImage("/images/buttons.png");
        this.incrementProgress();
        backgroundSprite = new Sprite(0, 0, new short[]{0, 0, 0, 0, 0, 0}, null, null);
        this.addSprite(backgroundSprite);
    }

    public Sprite createButton(int layer, int x, int y, int imageXOffset, int imageYOffset, int imageWidth, int imageHeight, boolean visible) {
        Sprite result = new Sprite(0, layer, new short[]{(short)x, (short)y, (short)imageXOffset, (short)imageYOffset, (short)imageWidth, (short)imageHeight}, buttonsImage, null);
        result.visible = visible;
        this.addSprite(result);
        return result;
    }

    public Sprite createTextHeading(String text, int x, int y, Font font, int color) {
        Sprite result = new Sprite(3, 0, new short[]{(short)x, (short)y, 0}, null, font);
        result.setMessage(text, -1);
        result.colors = new int[]{color};
        this.addSprite(result);
        return result;
    }

    public Sprite createPlayerController(int visiblePlayersCount, Sprite otherChips, int cardStyle) {
        Sprite otherMoneyText = new Sprite(10, 0, new short[]{20, 34}, null, Font.getFont((int)64, (int)0, (int)8));
        Sprite dealerSprite = new Sprite(5, 0, new short[]{30, 40, 29, 131, 10, 7}, buttonsImage, null);
        Sprite face = new Sprite(8, 0, new short[]{12, 10, 15, 15}, null, null);
        Sprite faceHighlight = new Sprite(9, 0, new short[]{12, 10, 15, 15}, null, null);
        faceHighlight.colors = new int[]{0xFFFF00};
        leftBorderSprite = this.createBorderSprite(0, 9, 0, 9, 3, 65);
        rightBorderSprite = this.createBorderSprite(125, 9, 125, 9, 3, 65);
        otherPlayerSprites = new Sprite[][]{{face, faceHighlight, new Sprite(1, 0, new short[]{12, 38, 6, 0, 0, 0, 19, 131, 9, 11}, buttonsImage, null), new Sprite(1, 1, new short[]{8, 23, 14, 0, 1, (short)cardStyle}, null, null), dealerSprite, otherChips, otherMoneyText}, {face != null ? face.clone(12, 10) : null, faceHighlight != null ? faceHighlight.clone(12, 10) : null, new Sprite(1, 0, new short[]{12, 38, 6, 0, 0, 0, 19, 131, 9, 11}, buttonsImage, null), new Sprite(1, 1, new short[]{8, 23, 14, 0, 1, (short)cardStyle}, null, null), dealerSprite.clone(30, 40), otherChips != null ? otherChips.clone(30, 25) : null, otherMoneyText.clone(20, 34)}, {face != null ? face.clone(12, 10) : null, faceHighlight != null ? faceHighlight.clone(12, 10) : null, new Sprite(1, 0, new short[]{12, 38, 6, 0, 0, 0, 19, 131, 9, 11}, buttonsImage, null), new Sprite(1, 1, new short[]{8, 23, 14, 0, 1, (short)cardStyle}, null, null), dealerSprite.clone(30, 40), otherChips != null ? otherChips.clone(30, 25) : null, otherMoneyText.clone(20, 34)}};
        playerController = Sprite.createPlayerController(otherPlayerSprites, visiblePlayersCount + 2, 0, 0, 43, this.canvas);
        Sprite.faceRects = new short[][]{{12, 10, 15, 15}, {12, 10, 15, 15}, {12, 10, 15, 15}};
        HoldemCanvasHelper.playerController.layer = 1;
        Sprite.scrollLeftArrow = new Sprite(0, 1, new short[]{0, 0, 0, 131, 19, 8}, buttonsImage, null);
        Sprite.scrollRightArrow = new Sprite(0, 1, new short[]{109, 0, 0, 139, 19, 8}, buttonsImage, null);
        Sprite.scrollLeftArrow_highlight = new Sprite(0, 1, new short[]{0, 0, 0, 131, 19, 8}, buttonsImage, null);
        Sprite.scrollRightArrow_highlight = new Sprite(0, 1, new short[]{109, 0, 0, 139, 19, 8}, buttonsImage, null);
        this.addSprite(playerController);
        return playerController;
    }

    public Sprite createBorderSprite(int x, int y, int imageXOffset, int imageYOffset, int imageWidth, int imageHeight) {
        Sprite result = new Sprite(0, 1, new short[]{(short)x, (short)y, (short)imageXOffset, (short)imageYOffset, (short)imageWidth, (short)imageHeight}, null, null);
        this.addSprite(result);
        return result;
    }

    public Sprite createGameMessage(int x, int y, int maxWidth, Font messageFont) {
        message = new Sprite(3, 0, new short[]{(short)x, (short)y, (short)maxWidth}, null, messageFont);
        this.addSprite(message);
        return message;
    }

    public Sprite createBlindsSprite(int x, int y, Font blindsFont) {
        blinds = new Sprite(3, 0, new short[]{(short)x, (short)y, 0}, null, blindsFont);
        this.addSprite(blinds);
        return blinds;
    }

    public Sprite createCommunityHand(int x, int y, int xSpacing, int cardStyle) {
        Sprite hand = new Sprite(1, 0, new short[]{(short)x, (short)y, (short)xSpacing, 0, 1, (short)cardStyle}, null, null);
        hand.player = HoldemCanvasHelper.controller.community;
        this.addSprite(hand);
        return hand;
    }

    public Sprite createPotSprites(int textX, int textY, Font textFont, Sprite potChips) {
        if (potChips != null) {
            potChips.pot = HoldemCanvasHelper.controller.pot;
            this.addSprite(potChips);
        }
        Sprite potText = new Sprite(2, 0, new short[]{(short)textX, (short)textY, 0}, null, textFont);
        potText.pot = HoldemCanvasHelper.controller.pot;
        this.addSprite(potText);
        return potText;
    }

    public void createHumanSprites(Sprite humanChips, Font betFont, Font holdingsFont, int cardStyle) {
        Sprite humanBet = new Sprite(2, 0, new short[]{107, 138, 1}, null, betFont);
        Sprite humanHoldings = new Sprite(2, 0, new short[]{64, 152, 0}, null, holdingsFont);
        Sprite[] humanSprites = new Sprite[]{new Sprite(1, 1, new short[]{51, 119, 14, 0, 1, (short)cardStyle}, null, null), humanChips, humanBet, humanHoldings, new Sprite(5, 0, new short[]{27, 114, 29, 131, 10, 7}, buttonsImage, null)};
        Sprite.humanSprites = humanSprites;
        this.addSprite(humanSprites[0]);
        this.addSprite(humanSprites[1]);
        this.addSprite(humanSprites[2]);
        this.addSprite(humanSprites[3]);
        this.addSprite(humanSprites[4]);
    }

    public Sprite createActionsMenu(boolean useLeftSoft, Font itemFont) {
        actionsMenu = Sprite.createMenu(1, 32, new short[]{2, 145, (short)(useLeftSoft ? 1 : 0), 8, 0, 3, 25, 0, 25, 5, -9}, null, itemFont, null, new int[]{0, 0, 0, 0xFFFFFF, 0, 0x9696FF, 0}, null, null, null, null, null);
        this.addSprite(actionsMenu);
        return actionsMenu;
    }

    public void createAllInAndFoldMenus(boolean useLeftSoft, Image allInMenuImage) {
        allInMenu = Sprite.createMenu(1, 9, new short[]{1, 45, (short)(useLeftSoft ? 1 : 0), 8, 0, 0, 0, 125, 62}, allInMenuImage, null, null, null, null, new short[][]{{17, 86, 126, 0, 47, 20}, {64, 87, 126, 43, 47, 20}}, null, null, null);
        this.addSprite(allInMenu);
        foldMenu = Sprite.createMenu(1, 9, new short[]{1, 45, (short)(useLeftSoft ? 1 : 0), 8, 0, 0, 62, 125, 62}, allInMenuImage, null, null, null, null, new short[][]{{17, 86, 126, 0, 47, 20}, {64, 87, 126, 43, 47, 20}}, null, null, null);
        this.addSprite(foldMenu);
    }

    public Sprite createContinueMenu(boolean useLeftSoft) {
        continueMenu = Sprite.createMenu(1, 9, new short[]{0, 123, (short)(useLeftSoft ? 1 : 0), 8, 0, 55, 0, 51, 37}, buttonsImage, null, null, null, null, new short[][]{{0, 133, 55, 37, 51, 14}, {0, 147, 55, 51, 51, 13}}, null, new long[]{1L, 0L}, null);
        HoldemCanvasHelper.continueMenu.goesAway = false;
        this.addSprite(continueMenu);
        return continueMenu;
    }

    public Sprite createAmountEntry(boolean useLeftSoft) {
        amountEntry = Sprite.createMenu(1, 73, new short[]{3, 68, (short)(useLeftSoft ? 1 : 0), 8, 12, 0, 0, 54, 79, 51, 81}, buttonsImage, Font.getFont((int)32, (int)0, (int)8), null, null, null, new short[][]{{5, 92, 2, 79, 51, 13}, {5, 105, 2, 92, 17, 13}, {22, 105, 19, 92, 17, 13}, {39, 105, 36, 92, 17, 13}, {5, 118, 2, 105, 17, 13}, {22, 118, 19, 105, 17, 13}, {39, 118, 36, 105, 17, 13}, {5, 130, 2, 117, 51, 13}}, new short[]{1, 3, 3, 1}, new long[]{-2L, 1L, 5L, 10L, 25L, 100L, 500L, -1L}, null);
        this.addSprite(amountEntry);
        return amountEntry;
    }

    public void createCongrats(boolean useLeftSoft) {
        congratsImage = new Sprite(0, 1, new short[]{0, 0, 0, 0, 0, 0}, null, null);
        HoldemCanvasHelper.congratsImage.visible = false;
        this.addSprite(congratsImage);
        if (extendedCongratsImage != null) {
            this.addSprite(extendedCongratsImage);
        }
        congratsText = new Sprite(3, 1, new short[]{300, 0, 0}, null, Font.getFont((int)64, (int)1, (int)16));
        HoldemCanvasHelper.congratsText.visible = false;
        this.addSprite(congratsText);
        congratsMenu = Sprite.createMenu(1, 8, new short[]{0, 0, (short)(useLeftSoft ? 1 : 0), 8, 0}, buttonsImage, null, null, null, null, new short[][]{{0, 133, 55, 64, 51, 14}, {0, 146, 55, 77, 51, 14}}, null, new long[]{1L, 0L}, null);
        HoldemCanvasHelper.congratsMenu.goesAway = false;
        this.addSprite(congratsMenu);
    }

    public void loadSecondaryImages() {
        if (HoldemCanvasHelper.backgroundSprite.image == null) {
            splashImage = null;
            HoldemCanvasHelper.rightBorderSprite.image = HoldemCanvasHelper.backgroundSprite.image = GameController.getImage("/images/game_background.png");
            HoldemCanvasHelper.leftBorderSprite.image = HoldemCanvasHelper.backgroundSprite.image;
            this.canvas.loadFaceImages();
        }
    }

    public void initMenusAndAction() {
        if (amountEntry != null) {
            amountEntry.hide();
        }
        if (actionsMenu != null) {
            actionsMenu.hide();
        }
        if (allInMenu != null) {
            allInMenu.hide();
            foldMenu.hide();
        }
        action = 0;
        clearAction = false;
        scrollingTicksLeft = 0;
    }

    public void initForNewGame(boolean startNewGame) {
        if (startNewGame) {
            message.setMessage("", 2 * GameController.instance.gameSpeed);
            if (continueButton != null) {
                HoldemCanvasHelper.continueButton.visible = false;
            }
            if (continueMenu != null) {
                continueMenu.hide();
            }
            if (congratsMenu != null) {
                congratsMenu.hide();
            }
            congratsPlayer = null;
            if (congratsText != null) {
                HoldemCanvasHelper.congratsText.visible = false;
            }
            if (congratsImage != null) {
                HoldemCanvasHelper.congratsImage.visible = false;
            }
            if (extendedCongratsImage != null) {
                HoldemCanvasHelper.extendedCongratsImage.visible = false;
            }
            allInAction = -2L;
            betRaiseAction = -2L;
            foldAction = -2L;
            callCheckAction = -2L;
        }
    }

    public void paintSplashScreen(Graphics g) {
        g.drawImage(splashImage, 0, 0, 20);
        if (this.progressValue > 0) {
            Sprite.drawImagePart(g, 30, 144, progressBarCoords[0], progressBarCoords[1], progressBarCoords[2] * Math.min(this.progressValue, this.maxProgressValue) / this.maxProgressValue, progressBarCoords[3], splashImage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void paintSprites(Graphics g, boolean useBottomCaching, int dynamicTopHalfHeight) {
        originalG = null;
        if (HoldemCanvasHelper.offscreen != null) {
            originalG = g;
            g = HoldemCanvasHelper.offscreen.getGraphics();
            g.setClip(originalG.getClipX(), originalG.getClipY(), originalG.getClipWidth(), originalG.getClipHeight());
        }
        var5_5 = this.canvas;
        synchronized (var5_5) {
            if (!useBottomCaching || HoldemCanvasHelper.offscreen == null || !HoldemCanvasHelper.bottomCached) ** GOTO lbl-1000
            if (Sprite.isAnimating) {
                g.clipRect(0, 0, g.getClipWidth(), dynamicTopHalfHeight);
                if (HoldemCanvasHelper.backgroundSprite != null && HoldemCanvasHelper.backgroundSprite.image != null) {
                    g.drawImage(HoldemCanvasHelper.backgroundSprite.image, 0, 0, 20);
                }
                players = Sprite.playerDisplays;
                for (i = 0; i < players.size(); ++i) {
                    ((Sprite)players.elementAt(i)).paint(g, (byte)0);
                }
                HoldemCanvasHelper.message.paint(g, (byte)0);
                for (i = 0; i < players.size(); ++i) {
                    ((Sprite)players.elementAt(i)).paint(g, (byte)1);
                }
                if (HoldemCanvasHelper.leftBorderSprite != null) {
                    HoldemCanvasHelper.leftBorderSprite.paint(g, (byte)1);
                }
                if (HoldemCanvasHelper.rightBorderSprite != null) {
                    HoldemCanvasHelper.rightBorderSprite.paint(g, (byte)1);
                }
                HoldemCanvasHelper.playerController.paint(g, (byte)1);
            } else lbl-1000:
            // 3 sources

            {
                for (j = 0; j < 2; j = (byte)((byte)(j + 1))) {
                    for (i = 0; i <= HoldemCanvasHelper.lastSprite; ++i) {
                        sprite = HoldemCanvasHelper.sprites[i];
                        if (sprite == null) continue;
                        sprite.paint(g, j);
                    }
                }
            }
            if (useBottomCaching) {
                HoldemCanvasHelper.bottomCached = Sprite.isAnimating != false;
            }
        }
        if (HoldemCanvasHelper.offscreen != null) {
            originalG.drawImage(HoldemCanvasHelper.offscreen, 0, 0, 20);
        }
    }

    public void addSprite(Sprite sprite) {
        if (sprite != null) {
            byte by = lastSprite;
            lastSprite = (byte)(by + 1);
            HoldemCanvasHelper.sprites[by] = sprite;
        }
    }

    public void incrementProgress() {
        if (this.canvas == Holdem.splash || Holdem.splash == null) {
            this.progressValue = (short)(this.progressValue + 1);
            if (this.progressBarVisible) {
                this.canvas.repaint();
            }
        } else {
            Holdem.splash.incrementProgress();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showNotify(boolean useServiceRepaints) {
        this.useServiceRepaints = useServiceRepaints;
        if (this.screenType == 3) {
            HoldemCanvasHelper holdemCanvasHelper = this;
            synchronized (holdemCanvasHelper) {
                bottomCached = false;
                if (animationThread == null) {
                    running = true;
                    animationThread = new Thread(this);
                    animationThread.start();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideNotify() {
        if (this.screenType == 3) {
            HoldemCanvasHelper holdemCanvasHelper = this;
            synchronized (holdemCanvasHelper) {
                if (animationThread != null) {
                    running = false;
                    animationThread = null;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public int readStandardAction(int keyCode) {
        block6: {
            block5: {
                if (keyCode == -6) break block5;
                if (keyCode == -7) break block5;
                if (keyCode != -8) break block6;
            }
            action = keyCode;
            return action;
        }
        if (keyCode >= 48) {
            if (keyCode <= 57) {
                action = -101;
                shortcutId = keyCode - 48;
                return action;
            }
        }
        action = this.canvas.getGameAction(keyCode);
        return action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetAction(boolean condition) {
        if (condition) {
            HoldemCanvas holdemCanvas = this.canvas;
            synchronized (holdemCanvas) {
                action = 0;
                clearAction = false;
                scrollingTicksLeft = 0;
                if (actionsMenu != null) {
                    HoldemCanvasHelper.actionsMenu.fireTicksLeft = 0;
                    HoldemCanvasHelper.actionsMenu.moveTicksLeft = 0;
                }
                if (allInMenu != null) {
                    HoldemCanvasHelper.allInMenu.fireTicksLeft = 0;
                    HoldemCanvasHelper.allInMenu.moveTicksLeft = 0;
                    HoldemCanvasHelper.foldMenu.fireTicksLeft = 0;
                    HoldemCanvasHelper.foldMenu.moveTicksLeft = 0;
                    HoldemCanvasHelper.foldMenu.fireTicksLeft = 0;
                    HoldemCanvasHelper.foldMenu.moveTicksLeft = 0;
                }
                if (continueMenu != null) {
                    HoldemCanvasHelper.continueMenu.fireTicksLeft = 0;
                    HoldemCanvasHelper.continueMenu.moveTicksLeft = 0;
                }
                if (congratsMenu != null) {
                    HoldemCanvasHelper.congratsMenu.fireTicksLeft = 0;
                    HoldemCanvasHelper.congratsMenu.moveTicksLeft = 0;
                }
                if (amountEntry != null) {
                    HoldemCanvasHelper.amountEntry.fireTicksLeft = 0;
                    HoldemCanvasHelper.amountEntry.moveTicksLeft = 0;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (HoldemCanvasHelper.running) {
                block13: {
                    currentTime = System.currentTimeMillis();
                    if (HoldemCanvasHelper.lastAnimation != 0L && currentTime - HoldemCanvasHelper.lastAnimation < 25L) break block13;
                    HoldemCanvasHelper.lastAnimation = currentTime;
                    needsRepaint = false;
                    serviceRepaints = false;
                    var5_6 /* !! */  = this.canvas;
                    synchronized (var5_6 /* !! */ ) {
                        needsRepaint = this.canvas.update();
                        if (!this.useServiceRepaints || !needsRepaint) ** GOTO lbl-1000
                        if (!Sprite.isAnimating) ** GOTO lbl-1000
                        if (Sprite.dontAllowScrolling) {
                            v0 = true;
                        } else lbl-1000:
                        // 3 sources

                        {
                            v0 = false;
                        }
                        serviceRepaints = v0;
                        ** if (!needsRepaint) goto lbl24
                    }
lbl-1000:
                    // 1 sources

                    {
                        this.canvas.repaint();
                        if (serviceRepaints) {
                            this.canvas.serviceRepaints();
                        }
                    }
                }
                waitTime = 25L - (System.currentTimeMillis() - HoldemCanvasHelper.lastAnimation);
                if (!HoldemCanvasHelper.running || waitTime <= 0L) continue;
                var5_6 /* !! */  = this;
                synchronized (var5_6 /* !! */ ) {
                    try {
                        this.wait(waitTime);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            return;
        }
        catch (Exception e) {
            System.err.println("Update exception");
            e.printStackTrace();
        }
    }

    public boolean animateOtherPlayers() {
        if (Sprite.isAnimating) {
            repaintRequired = playerController.update(0, 0, 0, 0) || repaintRequired;
            return repaintRequired;
        }
        return repaintRequired;
    }

    public boolean displayCongratsScreen() {
        if (HoldemCanvasHelper.congratsImage.image == null) {
            HoldemCanvasHelper.congratsImage.image = GameController.getImage("/images/congrats.png");
        }
        if (HoldemCanvasHelper.congratsPlayer.type == 1) {
            this.canvas.playSound((byte)8);
        }
        congratsText.setMessage(HoldemCanvasHelper.congratsPlayer.name, -1);
        HoldemCanvasHelper.congratsImage.visible = true;
        HoldemCanvasHelper.congratsText.visible = true;
        congratsMenu.show(null, null, 1);
        congratsPlayer = null;
        Sprite.isAnimating = false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkForMessageOrScrollDelay() {
        if (HoldemCanvasHelper.controller.roundStep == 6) return false;
        if (HoldemCanvasHelper.controller.roundStep == 7) return false;
        if (message.update(0, 0, 0, 0)) return true;
        if (!Sprite.isAnimating) return false;
        return true;
    }

    public void checkForLastBetsExpired() {
        for (int i = 1; !repaintRequired && i < HoldemCanvasHelper.controller.players.size(); ++i) {
            repaintRequired = ((Player)HoldemCanvasHelper.controller.players.elementAt(i)).lastBetDisplayPastDue();
        }
    }

    public boolean displayActionsMenu() {
        if (!(actionsMenu != null && HoldemCanvasHelper.actionsMenu.visible || allInMenu != null && HoldemCanvasHelper.allInMenu.visible || continueMenu != null && HoldemCanvasHelper.continueMenu.visible || amountEntry != null && HoldemCanvasHelper.amountEntry.visible || foldMenu != null && HoldemCanvasHelper.foldMenu.visible || congratsImage != null && HoldemCanvasHelper.congratsImage.visible)) {
            if (controller.canPlayerPlay(HoldemCanvasHelper.controller.humanPlayer)) {
                this.canvas.showActions();
                repaintRequired = true;
                return this.displayAllLastBets();
            }
            HoldemCanvasHelper.controller.showActionsRightAway = true;
        }
        return false;
    }

    public void showActions() {
        long[] availableBets = controller.getAvailableBets(HoldemCanvasHelper.controller.humanPlayer);
        String[] actionNames = controller.getActionNames(availableBets);
        actionsMenu.show(availableBets, actionNames, availableBets.length > 1 ? 1 : 0);
        if (allInMenu != null && (HoldemCanvasHelper.allInMenu.visible || HoldemCanvasHelper.foldMenu.visible)) {
            allInMenu.hide();
            foldMenu.hide();
        }
        this.setMenuButtonsActive(true, false);
    }

    public boolean hideMenus() {
        if (actionsMenu != null && HoldemCanvasHelper.actionsMenu.visible || amountEntry != null && HoldemCanvasHelper.amountEntry.visible || allInMenu != null && HoldemCanvasHelper.allInMenu.visible || foldMenu != null && HoldemCanvasHelper.foldMenu.visible) {
            if (actionsMenu != null) {
                actionsMenu.hide();
            }
            if (allInMenu != null) {
                allInMenu.hide();
            }
            if (foldMenu != null) {
                foldMenu.hide();
            }
            if (amountEntry != null) {
                amountEntry.hide();
            }
            this.setMenuButtonsActive(false, false);
            this.canvas.yourTurn();
            repaintRequired = true;
            return true;
        }
        return false;
    }

    public boolean amountEntryChooseOK() {
        if (HoldemCanvasHelper.amountEntry.visible) {
            amountEntry.choose(-1L);
            repaintRequired = true;
            return true;
        }
        return false;
    }

    public boolean clickedContinueButton() {
        return action == -100 && GameController.isWithinRect(clickX, clickY, HoldemCanvasHelper.continueButton.coords[0], HoldemCanvasHelper.continueButton.coords[1], HoldemCanvasHelper.continueButton.coords[4], HoldemCanvasHelper.continueButton.coords[5]);
    }

    public void continueAction() {
        controller.afterWin();
        if (continueButton != null) {
            HoldemCanvasHelper.continueButton.visible = false;
        }
        message.setMessage("", 0);
        this.setMenuButtonsActive(false, false);
    }

    public boolean checkMenu(Sprite menu) {
        if (menu.visible) {
            repaintRequired = menu.update(action, clickX, clickY, shortcutId) || repaintRequired;
            return true;
        }
        return false;
    }

    public boolean checkAmountEntry() {
        if (HoldemCanvasHelper.amountEntry.visible) {
            if (action == -8) {
                if (HoldemCanvasHelper.amountEntry.theAmount > 0L) {
                    HoldemCanvasHelper.amountEntry.theAmount /= 10L;
                    repaintRequired = true;
                }
            } else {
                repaintRequired = amountEntry.update(action, clickX, clickY, shortcutId) || repaintRequired;
            }
            return true;
        }
        return false;
    }

    public boolean checkForShortcut() {
        if (action == -101) {
            long betAmt;
            long l = shortcutId == 0 ? foldAction : (shortcutId == 1 ? callCheckAction : (shortcutId == 2 ? betRaiseAction : (shortcutId == 3 ? (allInAction == -2L ? callCheckAction : allInAction) : (betAmt = -2L))));
            if (this.processAction(betAmt)) {
                repaintRequired = true;
                return true;
            }
        }
        return false;
    }

    public boolean checkForScrollingClickDelay() {
        if (scrollingTicksLeft > 0) {
            --scrollingTicksLeft;
            return true;
        }
        return false;
    }

    public boolean checkForClick(short[] rect) {
        return action == -100 && GameController.isWithinRect(clickX, clickY, rect);
    }

    public boolean scroll(boolean left) {
        if (playerController.scroll(left)) {
            scrollingTicksLeft = 10;
        }
        return this.displayAllLastBets();
    }

    public boolean checkForPlayerFaceClick() {
        Player p;
        if (action == -100 && (p = playerController.lookForPlayerFace(clickX, clickY)) != null && p.lastBet.length() > 0) {
            p.lastBetDisplayTimestamp = System.currentTimeMillis();
            repaintRequired = true;
            return true;
        }
        return false;
    }

    public boolean checkForContinueButtonPause() {
        return (continueButton != null && HoldemCanvasHelper.continueButton.visible || continueMenu != null && HoldemCanvasHelper.continueMenu.visible) && HoldemCanvasHelper.controller.roundStep != 6 && HoldemCanvasHelper.controller.roundStep != 7;
    }

    public void yourTurn() {
        if (actionsButton != null) {
            HoldemCanvasHelper.actionsButton.visible = true;
        }
        message.setMessage("Your Turn", -1);
        allInAction = -2L;
        betRaiseAction = -2L;
        foldAction = -2L;
        callCheckAction = -2L;
        long[] availableBets = controller.getAvailableBets(HoldemCanvasHelper.controller.humanPlayer);
        block6: for (int i = 0; i < availableBets.length; ++i) {
            long amt = availableBets[i];
            switch (controller.getAction(HoldemCanvasHelper.controller.humanPlayer, amt)) {
                case -1: {
                    foldAction = amt;
                    continue block6;
                }
                case 0: 
                case 2: {
                    callCheckAction = amt;
                    continue block6;
                }
                case 1: 
                case 3: {
                    betRaiseAction = amt;
                    continue block6;
                }
                case 4: {
                    allInAction = amt;
                }
            }
        }
    }

    public boolean displayAllLastBets() {
        long timestamp = System.currentTimeMillis();
        for (int i = 1; i < HoldemCanvasHelper.controller.players.size(); ++i) {
            Player p = (Player)HoldemCanvasHelper.controller.players.elementAt(i);
            if (p.lastBet.length() <= 0) continue;
            p.lastBetDisplayTimestamp = timestamp;
        }
        repaintRequired = true;
        return true;
    }

    public boolean actionsMenuChoice(Sprite menu, long itemId) {
        if (menu == actionsMenu) {
            this.processAction(itemId);
            return true;
        }
        return false;
    }

    public boolean allInMenuChoice(Sprite menu, long itemId) {
        if (menu == allInMenu) {
            if (itemId > 0L) {
                this.playerAction(itemId, true);
            } else {
                this.setMenuButtonsActive(false, false);
            }
            return true;
        }
        return false;
    }

    public boolean foldMenuChoice(Sprite menu, long itemId) {
        if (menu == foldMenu) {
            if (itemId < 0L) {
                this.playerAction(itemId, false);
            } else {
                this.setMenuButtonsActive(false, false);
            }
            return true;
        }
        return false;
    }

    public boolean continueMenuChoice(Sprite menu, long itemId) {
        if (menu == continueMenu) {
            if (itemId == 0L) {
                controller.afterWin();
                message.setMessage("", 0);
                this.setMenuButtonsActive(false, false);
            } else if (itemId == 1L) {
                controller.dealem();
                HoldemCanvasHelper.continueButton.visible = true;
            }
            return true;
        }
        return false;
    }

    public boolean congratsMenuChoice(Sprite menu, long itemId) {
        if (menu == congratsMenu) {
            if (itemId == 1L) {
                controller.saveGame();
                controller.savePlayers();
                Holdem.gotoScreen((byte)17);
                clearAction = true;
            } else if (itemId == 0L) {
                HoldemCanvasHelper.congratsImage.visible = false;
                HoldemCanvasHelper.congratsText.visible = false;
                if (extendedCongratsImage != null) {
                    HoldemCanvasHelper.extendedCongratsImage.visible = false;
                }
                message.setMessage("", 0);
            }
            return true;
        }
        return false;
    }

    public void amountEntered(long amount, boolean isRaise) {
        if (isRaise) {
            amount = controller.getBetAmount(HoldemCanvasHelper.controller.humanPlayer, amount);
        }
        if (amount == HoldemCanvasHelper.controller.humanPlayer.holdings) {
            this.showAllInMenu(amount);
        } else {
            this.playerAction(amount, false);
        }
    }

    public void pauseForWin() {
        if (actionsButton != null) {
            HoldemCanvasHelper.actionsButton.visible = false;
        }
        if (GameController.dealemButtonSetting && HoldemCanvasHelper.controller.community.cards.size() <= 4) {
            continueMenu.show(null, null, 1);
        } else {
            HoldemCanvasHelper.continueButton.visible = true;
        }
    }

    public void showAllInMenu(long amt) {
        allInMenu.show(new long[]{amt, 0L}, null, 0);
        this.setMenuButtonsActive(true, false);
        clearAction = true;
    }

    public void showFoldMenu(long amt) {
        foldMenu.show(new long[]{amt, 0L}, null, 0);
        this.setMenuButtonsActive(true, false);
        clearAction = true;
    }

    public boolean processAction(long amt) {
        if (amt != -2L && controller.canPlayerPlay(HoldemCanvasHelper.controller.humanPlayer)) {
            int action = controller.getAction(HoldemCanvasHelper.controller.humanPlayer, amt);
            if (action == 3) {
                long raiseAmount = controller.getRaiseAmount(HoldemCanvasHelper.controller.humanPlayer, amt);
                amountEntry.show(raiseAmount, controller.getRaiseAmount(HoldemCanvasHelper.controller.humanPlayer, HoldemCanvasHelper.controller.humanPlayer.holdings), true);
                clearAction = true;
                this.setMenuButtonsActive(false, true);
            } else if (action == 1) {
                amountEntry.show(amt, HoldemCanvasHelper.controller.humanPlayer.holdings, false);
                clearAction = true;
                this.setMenuButtonsActive(false, true);
            } else if (action == 4) {
                this.showAllInMenu(amt);
            } else if (action == -1 && callCheckAction == 0L) {
                this.showFoldMenu(amt);
            } else {
                this.playerAction(amt, false);
            }
            return action != -2;
        }
        return false;
    }

    public void playerAction(long amt, boolean choseAllIn) {
        allInAction = -2L;
        betRaiseAction = -2L;
        foldAction = -2L;
        callCheckAction = -2L;
        controller.playerAction(HoldemCanvasHelper.controller.humanPlayer, amt, choseAllIn);
        this.setMenuButtonsActive(false, false);
        clearAction = true;
    }

    /*
     * Unable to fully structure code
     */
    public void setMenuButtonsActive(boolean selectButton, boolean okButton) {
        block9: {
            block6: {
                block8: {
                    block7: {
                        if (HoldemCanvasHelper.actionsButton == null) break block6;
                        if (!selectButton) break block7;
                        if (HoldemCanvasHelper.selectButton != null) ** GOTO lbl-1000
                    }
                    if (!okButton) break block8;
                    if (HoldemCanvasHelper.okButton != null) ** GOTO lbl-1000
                    if (HoldemCanvasHelper.selectButton != null) ** GOTO lbl-1000
                }
                if (HoldemCanvasHelper.controller.canPlayerPlay(HoldemCanvasHelper.controller.humanPlayer)) {
                    HoldemCanvasHelper.actionsButton.visible = true;
                } else lbl-1000:
                // 4 sources

                {
                    HoldemCanvasHelper.actionsButton.visible = false;
                }
            }
            if (HoldemCanvasHelper.backButton != null) {
                HoldemCanvasHelper.backButton.visible = selectButton != false || okButton != false;
            }
            if (HoldemCanvasHelper.selectButton == null) break block9;
            if (selectButton) ** GOTO lbl-1000
            if (HoldemCanvasHelper.okButton == null && okButton) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else {
                v0 = false;
            }
            HoldemCanvasHelper.selectButton.visible = v0;
        }
        if (HoldemCanvasHelper.okButton != null) {
            HoldemCanvasHelper.okButton.visible = okButton;
        }
    }

    public void loadFaceImages() {
        if (HoldemCanvas.faceImages == null) {
            HoldemCanvas.faceImages = new Image[8];
            for (int i = 0; i < 8; ++i) {
                HoldemCanvas.faceImages[i] = GameController.getImage("/images/face" + i + ".png");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadNokiaAPISounds() {
        InputStream tune = null;
        try {
            tune = this.getClass().getResourceAsStream("/sounds/shuffling.ota");
            byte[] sounddata = new byte[512];
            tune.read(sounddata, 0, sounddata.length);
            shufflingSound = new Sound(sounddata, 1);
            tune.close();
            tune = null;
            tune = this.getClass().getResourceAsStream("/sounds/raise.ota");
            sounddata = new byte[512];
            tune.read(sounddata, 0, sounddata.length);
            raiseSound = new Sound(sounddata, 1);
            tune = this.getClass().getResourceAsStream("/sounds/fold.ota");
            sounddata = new byte[512];
            tune.read(sounddata, 0, sounddata.length);
            foldSound = new Sound(sounddata, 1);
            tune = this.getClass().getResourceAsStream("/sounds/playersturn.ota");
            sounddata = new byte[512];
            tune.read(sounddata, 0, sounddata.length);
            playersTurnSound = new Sound(sounddata, 1);
            humanCongratsSound = new Sound(humanCongratsData, 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (tune != null) {
                    tune.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void playNokiaAPISound(byte soundId) {
        switch (soundId) {
            case 1: {
                ((Sound)shufflingSound).play(1);
                break;
            }
            case 3: {
                ((Sound)foldSound).play(1);
                break;
            }
            case 4: {
                ((Sound)raiseSound).play(2);
                break;
            }
            case 5: {
                ((Sound)playersTurnSound).play(1);
                break;
            }
            case 8: {
                ((Sound)humanCongratsSound).play(1);
            }
        }
    }

    public void playAlertSound(byte soundId) {
        switch (soundId) {
            case 1: {
                AlertType.CONFIRMATION.playSound(Holdem.display);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                AlertType.ERROR.playSound(Holdem.display);
                break;
            }
            case 4: {
                AlertType.WARNING.playSound(Holdem.display);
                break;
            }
            case 5: {
                AlertType.CONFIRMATION.playSound(Holdem.display);
                break;
            }
            case 7: {
                AlertType.INFO.playSound(Holdem.display);
                break;
            }
            case 8: {
                AlertType.INFO.playSound(Holdem.display);
            }
        }
    }

    public void playMMApiSound(byte soundId) {
        try {
            if (soundId == 1 && shufflingSound != null) {
                ((javax.microedition.media.Player)shufflingSound).setLoopCount(1);
                ((javax.microedition.media.Player)shufflingSound).start();
            } else if (soundId == 2 && dealCardSound != null) {
                ((javax.microedition.media.Player)dealCardSound).setLoopCount(1);
                ((javax.microedition.media.Player)dealCardSound).start();
            } else if (soundId == 3 && foldSound != null) {
                ((javax.microedition.media.Player)foldSound).setLoopCount(1);
                ((javax.microedition.media.Player)foldSound).start();
            } else if (soundId == 4 && raiseSound != null) {
                ((javax.microedition.media.Player)raiseSound).setLoopCount(2);
                ((javax.microedition.media.Player)raiseSound).start();
            } else if (soundId == 5 && playersTurnSound != null) {
                ((javax.microedition.media.Player)playersTurnSound).setLoopCount(1);
                ((javax.microedition.media.Player)playersTurnSound).start();
            } else if (soundId == 8 && humanCongratsSound != null) {
                ((javax.microedition.media.Player)humanCongratsSound).setLoopCount(1);
                ((javax.microedition.media.Player)humanCongratsSound).start();
            }
        }
        catch (Exception e) {
            System.err.println("Error playing sound " + soundId);
            e.printStackTrace();
        }
    }

    public void playMMApiSoundSinglePrefetch(byte soundId) {
        try {
            if (soundId == 1 && shufflingSound != null) {
                this.playMMApiSoundSinglePrefetch(shufflingSound, 1);
            } else if (soundId == 2 && dealCardSound != null) {
                this.playMMApiSoundSinglePrefetch(dealCardSound, 1);
            } else if (soundId == 3 && foldSound != null) {
                this.playMMApiSoundSinglePrefetch(foldSound, 1);
            } else if (soundId == 4 && raiseSound != null) {
                this.playMMApiSoundSinglePrefetch(raiseSound, 2);
            } else if (soundId == 5 && playersTurnSound != null) {
                this.playMMApiSoundSinglePrefetch(playersTurnSound, 1);
            } else if (soundId == 8 && humanCongratsSound != null) {
                this.playMMApiSoundSinglePrefetch(humanCongratsSound, 1);
            }
        }
        catch (Exception e) {
            System.err.println("Error playing sound " + soundId);
            e.printStackTrace();
        }
    }

    private synchronized void playMMApiSoundSinglePrefetch(Object player, int loopCount) throws Exception {
        if (playingSound != null && playingSound != player) {
            ((javax.microedition.media.Player)playingSound).deallocate();
        }
        playingSound = player;
        ((javax.microedition.media.Player)player).prefetch();
        ((javax.microedition.media.Player)player).setLoopCount(loopCount);
        ((javax.microedition.media.Player)player).start();
    }

    public static boolean supportsMMApi() {
        try {
            Class.forName("javax.microedition.media.Player").newInstance();
        }
        catch (InstantiationException e) {
            return true;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public Object loadMMApiSound(String fileName, boolean prefetch) {
        InputStream stream = null;
        try {
            javax.microedition.media.Player result = null;
            stream = this.getClass().getResourceAsStream(fileName);
            result = Manager.createPlayer((InputStream)stream, (String)(fileName.endsWith(".wav") ? "audio/x-wav" : "audio/midi"));
            if (prefetch) {
                result.prefetch();
            }
            return result;
        }
        catch (Exception e) {
            System.err.println("Error loading sound " + fileName);
            e.printStackTrace();
            return null;
        }
    }

    public synchronized boolean playDynamicWavSound(String filename, int loopCount) {
        return false;
    }

    static {
        sprites = new Sprite[40];
        running = true;
        shortcutId = -1;
        bottomCached = false;
        progressBarCoords = new short[]{30, 160, 68, 4};
        humanCongratsData = new byte[]{2, 74, 58, 64, 4, 0, 27, 28, -125, 77, 33, 67, 81, 53, 19, 80, 52, -46, 20, 56, -46, 20, 73, 48, 0, 0};
        callCheckAction = -2L;
        foldAction = -2L;
        betRaiseAction = -2L;
        allInAction = -2L;
    }
}

