/*
 * Decompiled with CFR 0.152.
 */
package com.concretesoftware.holdem.athnolimit;

import com.concretesoftware.holdem.Card;
import com.concretesoftware.holdem.GameController;
import com.concretesoftware.holdem.Player;
import java.util.Vector;

public final class AI {
    public static final AI instance = new AI();
    private final GameController gameController = GameController.instance;
    static final int NORMAL_STACK = 0;
    static final int TROUBLE_STACK = 1;
    static final int MOVE_IN_STACK = 2;
    static final int NO_BLUFFING = 0;
    static final int DUMB_BLUFFING = 1;
    static final int SEMI_BLUFFING = 2;
    static final int POSITIONAL_BLUFF = 3;
    static final int BET_ACTION = 3;
    static final int STAY_ACTION = 2;
    static final int FOLD_ACTION = 1;
    static final int RAISE_AMOUNT = 90;
    boolean potentialStraight = false;
    boolean potentialFlush = false;

    public final void choosePlayerAction(Player player) {
        int stackType = this.getStackType(player);
        int adjustedHandScore = this.getHandScore(player);
        int bluff = this.getBluff(player);
        adjustedHandScore = this.getIntelligenceAdjustment(adjustedHandScore, player);
        adjustedHandScore = this.getAdjustedForPosition(adjustedHandScore, player);
        adjustedHandScore = this.getAdjustedForNumberOfPlayers(adjustedHandScore, player);
        long[] availableBets = this.gameController.getAvailableBets(player);
        if (availableBets[0] != -2L) {
            int playerAction = this.getPlayerAction(adjustedHandScore, stackType, bluff, player);
            if (playerAction >= 3 && this.gameController.isBetPossible(player)) {
                this.gameController.playerAction(player, this.getBetAmount(adjustedHandScore, stackType, bluff, player), false);
            } else if (playerAction >= 2 || this.noBetNeeded(player)) {
                this.gameController.playerAction(player, availableBets[1], false);
            } else {
                this.gameController.playerAction(player, availableBets[0], false);
            }
        }
    }

    private int getAdjustedForNumberOfPlayers(int adjustedHandScore, Player player) {
        int numberOfPlayers = this.gameController.players.size();
        int adjust = 0;
        if (numberOfPlayers >= 15) {
            if (player.intelligence > 7) {
                adjust = -25;
            } else if (player.intelligence > 3) {
                adjust = -15;
            }
        } else if (numberOfPlayers >= 10) {
            if (player.intelligence > 7) {
                adjust = -15;
            } else if (player.intelligence > 3) {
                adjust = -5;
            }
        } else if (numberOfPlayers >= 5) {
            adjust = 0;
        } else if (numberOfPlayers >= 3) {
            if (player.intelligence > 7) {
                adjust = 15;
            } else if (player.intelligence > 3) {
                adjust = 5;
            }
        } else if (numberOfPlayers >= 2) {
            adjust = player.intelligence > 7 ? 25 : (player.intelligence > 3 ? 10 : 5);
        } else if (numberOfPlayers >= 1) {
            adjust = player.intelligence > 7 ? 30 : (player.intelligence > 3 ? 20 : 10);
        }
        return adjustedHandScore + adjust;
    }

    private int getAdjustedForPosition(int adjustedHandScore, Player player) {
        if (player.intelligence > 5) {
            int positionRatio = this.getPositionRatio();
            if (positionRatio > 90) {
                adjustedHandScore += 10;
            } else if (positionRatio > 75) {
                adjustedHandScore += 5;
            } else if (positionRatio < 30) {
                adjustedHandScore -= 5;
            } else if (positionRatio < 10) {
                adjustedHandScore -= 10;
            }
        }
        return adjustedHandScore;
    }

    private int getPlayerAction(int handScore, int stackType, int bluff, Player player) {
        if (bluff > 0) {
            return 3;
        }
        int raiseAdjust = 0;
        int callAdjust = 0;
        long potOdds = this.getPotOdds();
        if (player.intelligence >= 7) {
            if (potOdds > 35L) {
                callAdjust -= 50;
            } else if (potOdds > 20L) {
                callAdjust -= 30;
            } else if (potOdds > 10L) {
                callAdjust -= 20;
            } else if (potOdds > 5L) {
                callAdjust -= 10;
            } else if (potOdds > 2L) {
                callAdjust -= 5;
            }
            if (player.intelligence == 7) {
                callAdjust += 5;
            }
        }
        if (player.intelligence == 5) {
            if (potOdds > 35L) {
                callAdjust -= 20;
            } else if (potOdds > 20L) {
                callAdjust -= 15;
            } else if (potOdds > 8L) {
                callAdjust -= 5;
            }
        }
        long betHoldingsRatio = 100L;
        if (this.gameController.pot.getRequiredBet() != 0L && player.holdings != 0L) {
            betHoldingsRatio = player.holdings / this.gameController.pot.getRequiredBet();
        }
        if (stackType == 0) {
            if (betHoldingsRatio < 3L) {
                callAdjust = player.intelligence > 5 ? (callAdjust += 90 - this.getStayAmount(player) - 5) : (callAdjust += 35);
                raiseAdjust += 5;
            } else if (betHoldingsRatio < 5L) {
                raiseAdjust += 3;
                callAdjust += 30;
            } else if (betHoldingsRatio < 10L) {
                callAdjust += 25;
            } else if (betHoldingsRatio < 20L) {
                callAdjust += 20;
            } else if (betHoldingsRatio > 100L) {
                callAdjust -= 35;
            } else if (betHoldingsRatio > 90L) {
                callAdjust -= 25;
            } else if (betHoldingsRatio > 50L) {
                callAdjust -= 15;
            }
        } else if (stackType == 1) {
            raiseAdjust -= 20;
        } else if (stackType == 2) {
            raiseAdjust -= 50;
        }
        if (this.gameController.pot.getNumberOfBets() > 1 && stackType == 0) {
            raiseAdjust += 10;
        } else if (this.gameController.pot.getNumberOfBets() > 2 && stackType == 0) {
            raiseAdjust += 20;
        } else if (this.gameController.pot.getNumberOfBets() > 3) {
            raiseAdjust += 40;
        }
        if (this.gameController.players.size() <= 3) {
            callAdjust -= 10;
        }
        if (handScore > 90 + raiseAdjust) {
            return 3;
        }
        if (handScore > this.getStayAmount(player) + callAdjust) {
            return 2;
        }
        return 1;
    }

    private long getPotOdds() {
        return this.gameController.pot.getRequiredBet() > 0L ? this.gameController.pot.getAmount() / this.gameController.pot.getRequiredBet() : -1L;
    }

    private int getPositionRatio() {
        return (this.gameController.getPlayerPosition() == 0 ? this.gameController.players.size() : this.gameController.getPlayerPosition()) * 100 / this.gameController.players.size();
    }

    private int getStackType(Player player) {
        long stackBlindRatio = player.holdings / (long)(this.gameController.smallBlind * 2);
        if (stackBlindRatio <= 5L) {
            return 2;
        }
        if (stackBlindRatio <= 10L) {
            return 1;
        }
        return 0;
    }

    private long getBetAmount(int score, int stackType, int bluff, Player player) {
        long bet = this.gameController.smallBlind * 2 * (GameController.RANDOM.nextInt() > 0 ? 3 : 4);
        if (stackType > 0 && player.intelligence > 5) {
            bet = player.holdings;
        } else {
            switch (player.intelligence) {
                case 1: {
                    bet = score > 99 ? player.holdings : (long)(this.gameController.smallBlind * 2 * (score / 10));
                    break;
                }
                case 3: {
                    bet = score > 103 ? player.holdings : (long)(this.gameController.smallBlind * 2 * (score / 15));
                    break;
                }
                case 5: {
                    bet = score > 109 ? player.holdings : (long)(this.gameController.smallBlind * 2 * (score / 20));
                    break;
                }
                case 7: {
                    bet = score > 115 ? player.holdings : (long)(this.gameController.smallBlind * 2 * (score > 85 ? 4 : 3));
                    break;
                }
                case 10: {
                    bet = this.gameController.pot.getAmount() >= (long)(this.gameController.smallBlind * 35) ? (score > 110 && bluff == 0 ? player.holdings : (long)(this.gameController.smallBlind * 32)) : (this.gameController.pot.getAmount() >= (long)(this.gameController.smallBlind * 24) ? (long)(this.gameController.smallBlind * 16) : (long)(this.gameController.smallBlind * 8));
                }
            }
        }
        if (bet < this.gameController.pot.getRequiredBet()) {
            bet = this.gameController.pot.getRequiredBet();
        }
        return bet > player.holdings ? player.holdings : bet;
    }

    private int getIntelligenceAdjustment(int adjustedHandScore, Player player) {
        int random = Math.abs(GameController.RANDOM.nextInt());
        int adjust = 1;
        switch (player.intelligence) {
            case 10: {
                adjust = random % 2;
                break;
            }
            case 7: {
                adjust = random % 5;
                break;
            }
            case 5: {
                adjust = random % 10;
                break;
            }
            case 3: {
                adjust = random % 15;
                break;
            }
            case 1: {
                adjust = random % 25;
            }
        }
        return adjustedHandScore + adjust;
    }

    private int getBluff(Player player) {
        int random = GameController.RANDOM.nextInt();
        switch (player.intelligence) {
            case 5: {
                return random % 30 == 1 ? 1 : 0;
            }
            case 3: {
                return random % 15 == 1 ? 1 : 0;
            }
            case 7: {
                return random % 40 == 1 ? 1 : 0;
            }
        }
        if ((player.intelligence == 10 || player.intelligence == 7) && (this.potentialFlush || this.potentialStraight) && this.noBetNeeded(player)) {
            return random % 6 == 1 ? 2 : 0;
        }
        if (player.intelligence == 10 && this.getPositionRatio() == 100 && this.noBetNeeded(player) && GameController.RANDOM.nextInt() % 2 == 1) {
            return 3;
        }
        return 0;
    }

    private int getStayAmount(Player player) {
        switch (player.intelligence) {
            case 10: {
                return 50;
            }
            case 7: {
                return 40;
            }
            case 5: {
                return 35;
            }
            case 3: {
                return 30;
            }
            case 1: {
                return 15;
            }
        }
        return 0;
    }

    private boolean noBetNeeded(Player player) {
        return player.bet >= this.gameController.pot.getRequiredBet();
    }

    private int getHandScore(Player player) {
        player.initPokerHand();
        if (player.cards.size() < 2) {
            return -1;
        }
        if (player.combinedSortedCards.size() == 2) {
            return AI.handScore2(player);
        }
        if (player.combinedSortedCards.size() > 2) {
            return this.handScore(player);
        }
        return 0;
    }

    private static int handScore2(Player player) {
        Card firstCard = player.getCard(0);
        Card secondCard = player.getCard(1);
        byte firstNumber = firstCard.number;
        byte secondNumber = secondCard.number;
        int difference = Math.abs(firstNumber - secondNumber);
        int score = 0;
        if (firstCard.compare(secondCard, true) == 0) {
            score = firstNumber > 13 ? 105 : (firstNumber >= 11 || firstNumber == 1 ? 100 : (firstNumber > 7 ? 90 : 65));
        } else if (!(firstNumber <= 11 && firstNumber != 1 || secondNumber <= 11 && secondNumber != 1)) {
            score = 93;
        } else if (firstNumber > 7 && secondNumber > 7) {
            score = firstNumber == 1 || secondNumber == 1 ? 75 : (difference < 3 ? 65 : 55);
        } else if (firstNumber == 1 || secondNumber == 1) {
            score = 60;
        } else if (difference == 1 && firstCard.suit == secondCard.suit) {
            score = 55;
        } else if (difference < 3) {
            score = 25;
        } else if (difference < 4) {
            score = 15;
        } else if (firstNumber > 10 || secondNumber > 10) {
            score = 20;
        }
        if (firstCard.suit == secondCard.suit) {
            score += score > 80 ? 5 : 15;
        }
        return score;
    }

    private int handScore(Player player) {
        int i;
        Card communityFirstCard;
        Vector communityHighCards;
        Card firstCard = player.getCard(0);
        Card secondCard = player.getCard(1);
        byte playerCard1 = firstCard.number;
        byte playerCard2 = secondCard.number;
        Player community = GameController.instance.community;
        community.initPokerHand();
        byte pokerHandType = player.combinedPokerType;
        boolean sameHandAsCommunity = player.combinedPokerType == community.pokerType;
        int score = 0;
        if (pokerHandType == 10) {
            score = 150;
        } else if (pokerHandType == 9) {
            score = 100;
        } else if (pokerHandType == 8) {
            score = sameHandAsCommunity ? (playerCard1 == 1 || playerCard2 == 1 ? 150 : (playerCard1 > 11 || playerCard2 > 11 ? 70 : 40)) : 150;
        } else if (pokerHandType == 7) {
            score = sameHandAsCommunity ? 70 : 100;
        } else if (pokerHandType == 6) {
            score = 90;
        } else if (pokerHandType == 5) {
            score = 88;
        } else if (pokerHandType == 4) {
            score = sameHandAsCommunity ? 30 : 93;
        } else if (pokerHandType == 3) {
            if (sameHandAsCommunity) {
                score = 20;
            } else if (community.pokerType == 2) {
                communityHighCards = community.pokerHandCards;
                communityFirstCard = (Card)communityHighCards.elementAt(0);
                Card highCard = (Card)player.combinedPokerHandCards.elementAt(0);
                int firstCombinedComparison = highCard.compare(communityFirstCard, true);
                score = firstCombinedComparison == 0 ? 60 : 75;
            } else {
                score = 90;
            }
        } else if (pokerHandType == 2) {
            communityHighCards = community.pokerHandCards;
            communityFirstCard = (Card)communityHighCards.elementAt(0);
            Card communitySecondCard = (Card)communityHighCards.elementAt(1);
            Card highCard = (Card)player.combinedPokerHandCards.elementAt(0);
            int firstCombinedComparison = highCard.compare(communityFirstCard, true);
            int secondCombinedComparison = highCard.compare(communitySecondCard, true);
            score = sameHandAsCommunity ? 0 : (firstCombinedComparison > 0 ? 92 : (firstCombinedComparison == 0 ? 85 : (secondCombinedComparison > 0 ? 75 : (secondCombinedComparison == 0 ? 65 : 40))));
        } else if (pokerHandType == 1) {
            if (playerCard1 == 1 || playerCard2 == 1) {
                score = 35;
            } else if (playerCard1 > 10 && playerCard2 > 10) {
                score = 30;
            }
        }
        Vector<Card> pokerHandCards = new Vector<Card>(5);
        int sortedSize = player.combinedSortedCards.size();
        Vector pokerCards = new Vector(sortedSize);
        Player.sortCards(pokerCards, player.combinedSortedCards);
        for (i = 0; i <= sortedSize - 5; ++i) {
            pokerHandCards.removeAllElements();
            Card card = (Card)pokerCards.elementAt(i);
            pokerHandCards.addElement(card);
            byte suit = card.suit;
            for (int j = i + 1; j < sortedSize && pokerHandCards.size() < 5; ++j) {
                Card nextCard = (Card)pokerCards.elementAt(j);
                if (nextCard.suit != suit) continue;
                pokerHandCards.addElement(nextCard);
            }
            if (pokerHandType == 6) {
                byte flushSuit = ((Card)pokerHandCards.firstElement()).suit;
                if (firstCard.suit == secondCard.suit && player.getCard((int)1).suit == flushSuit) {
                    score += 10;
                    continue;
                }
                if (firstCard.suit == flushSuit || secondCard.suit == flushSuit) {
                    byte flushCardNumber = firstCard.suit == flushSuit ? firstCard.number : player.getCard((int)1).number;
                    score += flushCardNumber * 2 - 12;
                    continue;
                }
                score -= 20;
                continue;
            }
            if (pokerHandCards.size() == 4) {
                this.potentialFlush = true;
                if (sortedSize == 5) {
                    score += 35;
                    continue;
                }
                if (sortedSize != 6) continue;
                score += 20;
                continue;
            }
            if (pokerHandCards.size() != 3 || sortedSize != 5) continue;
            score += 5;
        }
        for (i = 0; i <= sortedSize - 4 && (((Card)pokerCards.elementAt((int)i)).number >= 5 || ((Card)pokerCards.elementAt((int)i)).number == 1); ++i) {
            if (!AI.checkForStraight(i, pokerCards)) continue;
            this.potentialStraight = true;
            score += 25;
        }
        return score += sortedSize == 5 ? 14 : (sortedSize == 6 ? 5 : 0);
    }

    private static boolean checkForStraight(int index, Vector pokerCards) {
        Card nextCard;
        int i;
        Vector<Card> pokerHandCards = new Vector<Card>(4);
        Card card = (Card)pokerCards.elementAt(index);
        pokerHandCards.addElement(card);
        byte suit = card.suit;
        int number = card.number;
        if (number == 1) {
            number = 14;
        }
        for (i = index + 1; i < pokerCards.size() && pokerHandCards.size() < 4; ++i) {
            nextCard = (Card)pokerCards.elementAt(i);
            if (nextCard.suit != suit || nextCard.number != number - pokerHandCards.size()) continue;
            pokerHandCards.addElement(nextCard);
        }
        if (number == 4 && pokerHandCards.size() == 3 && (i = 0) < pokerCards.size() && ((Card)pokerCards.elementAt((int)i)).number == 1) {
            nextCard = (Card)pokerCards.elementAt(i);
            pokerHandCards.addElement(nextCard);
            return true;
        }
        return pokerHandCards.size() == 4;
    }
}

