/*
 * Decompiled with CFR 0.152.
 */
package com.concretesoftware.holdem;

import com.concretesoftware.holdem.GameController;
import com.concretesoftware.holdem.Sprite;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Card {
    public static final byte SINGULAR = 1;
    public static final byte PLURAL = 2;
    public static final byte CHARACTER = 3;
    public static final byte ACE = 1;
    public static final byte JACK = 11;
    public static final byte QUEEN = 12;
    public static final byte KING = 13;
    public static final byte HEARTS = 1;
    public static final byte DIAMONDS = 2;
    public static final byte SPADES = 3;
    public static final byte CLUBS = 4;
    private static Vector allCardsList = new Vector(54);
    private static Card[] origAllCardsList = new Card[52];
    public static final byte HAS_TEMPLATE = 1;
    public static final byte HAS_4ROW_IMAGE_NUMBER = 2;
    public static final byte HAS_2ROW_IMAGE_NUMBER = 4;
    public static final byte HAS_1ROW_IMAGE_NUMBER = 8;
    public static final byte HAS_FONT_NUMBER = 16;
    public static final byte HAS_DETAIL = 32;
    public static final byte HAS_HIGHLIGHT = 64;
    public static Image cardsImage;
    public static short[][] styleCoords;
    public static Font[] numberFonts;
    public final byte number;
    public final byte suit;
    public boolean highlighted;

    public Card(int number, int suit) {
        this.number = (byte)number;
        this.suit = (byte)suit;
    }

    public void paint(Graphics g, int x, int y, int styleIndex) {
        if (styleIndex < 0) {
            styleIndex = 0;
        }
        short[] style = styleCoords[styleIndex];
        short features = style[0];
        int i = 1;
        int s = this.suit - 1;
        Sprite.drawImagePart(g, x + style[i], y + style[i + 1], style[i + 2] + s * style[i + 4], style[i + 3], style[i + 4], style[i + 5], cardsImage);
        i += 6;
        int n = this.number - 1;
        if ((features & 0x10) == 0) {
            Sprite.drawImagePart(g, x + style[i + 2 * s], y + style[i + 1 + 2 * s], style[i + 8] + n * style[i + 10], style[i + 9] + ((features & 2) != 0 ? s * style[i + 11] : ((features & 4) != 0 ? s / 2 * style[i + 11] : 0)), style[i + 10], style[i + 11], cardsImage);
            i += 12;
        } else {
            g.setFont(numberFonts[styleIndex]);
            g.setColor(s < 2 ? 0xDC0000 : 0);
            String num = this.getNumberString((byte)3);
            if (num.length() > 1) {
                g.drawString(num.substring(0, 1), x + style[i + 2], y + style[i + 1], 65);
                g.drawString(num.substring(1, 2), x + style[i + 2] + style[i + 3], y + style[i + 1], 65);
            } else {
                g.drawString(num, x + style[i], y + style[i + 1], 65);
            }
            i += 4;
        }
        if ((features & 0x40) != 0) {
            if (this.highlighted) {
                Sprite.drawImagePart(g, x + style[i], y + style[i + 1], style[i + 2], style[i + 3], style[i + 4], style[i + 5], cardsImage);
            }
            i += 6;
        }
    }

    public boolean equals(Object o) {
        if (o instanceof Card) {
            Card c = (Card)o;
            return c.suit == this.suit && c.number == this.number;
        }
        return false;
    }

    public int hashCode() {
        return this.number ^ this.suit;
    }

    public int compare(Card otherCard, boolean aceHigh) {
        int thisNumber = this.number;
        int otherNumber = otherCard.number;
        if (aceHigh && thisNumber == 1) {
            thisNumber = 14;
        }
        if (aceHigh && otherNumber == 1) {
            otherNumber = 14;
        }
        return thisNumber > otherNumber ? 1 : (thisNumber < otherNumber ? -1 : 0);
    }

    public String getNumberString(byte type) {
        switch (this.number) {
            case 1: {
                switch (type) {
                    case 2: {
                        return "Aces";
                    }
                    case 1: {
                        return "Ace";
                    }
                    case 3: {
                        return "A";
                    }
                }
            }
            case 13: {
                switch (type) {
                    case 2: {
                        return "Kings";
                    }
                    case 1: {
                        return "King";
                    }
                    case 3: {
                        return "K";
                    }
                }
            }
            case 12: {
                switch (type) {
                    case 2: {
                        return "Queens";
                    }
                    case 1: {
                        return "Queen";
                    }
                    case 3: {
                        return "Q";
                    }
                }
            }
            case 11: {
                switch (type) {
                    case 2: {
                        return "Jacks";
                    }
                    case 1: {
                        return "Jack";
                    }
                    case 3: {
                        return "J";
                    }
                }
            }
        }
        switch (type) {
            case 2: {
                return GameController.replace("&1s", Integer.toString(this.number), null);
            }
        }
        return Integer.toString(this.number);
    }

    public static void initDeck() {
        int k = 0;
        for (int i = 1; i <= 4; ++i) {
            for (int j = 1; j <= 13; ++j) {
                Card.origAllCardsList[k] = new Card(j, i);
                ++k;
            }
        }
    }

    public static void shuffleDeck() {
        allCardsList.removeAllElements();
        for (int i = 0; i < 52; ++i) {
            int index = Math.abs(GameController.RANDOM.nextInt()) % (allCardsList.size() + 1);
            allCardsList.insertElementAt(origAllCardsList[i], index);
        }
    }

    public static Card removeTopCard() {
        Card card;
        Card card2 = card = allCardsList.isEmpty() ? null : (Card)allCardsList.elementAt(0);
        if (card != null) {
            allCardsList.removeElementAt(0);
        }
        return card;
    }

    public static void removeCard(Card card) {
        allCardsList.removeElement(card);
    }

    public String toString() {
        return this.getNumberString((byte)3) + (this.suit == 1 ? "H" : (this.suit == 2 ? "D" : (this.suit == 3 ? "S" : "C")));
    }
}

