/*
 * Decompiled with CFR 0.152.
 */
package com.concretesoftware.holdem;

import com.concretesoftware.holdem.Card;
import com.concretesoftware.holdem.Holdem;
import com.concretesoftware.holdem.HoldemCanvas;
import com.concretesoftware.holdem.Player;
import com.concretesoftware.holdem.Pot;
import com.concretesoftware.holdem.Sprite;
import com.concretesoftware.holdem.athnolimit.AI;
import java.io.IOException;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public final class GameController {
    public static final int RED = 0xDC0000;
    public static final int BLUE = 255;
    public static final int BLACK = 0;
    public static final int WHITE = 0xFFFFFF;
    public static final int YELLOW = 0xFFFF00;
    public static final byte LEFT_END_PLYR = 0;
    public static final byte MIDDLE_PLYR = 1;
    public static final byte RIGHT_END_PLYR = 2;
    public static final byte GAME_RESTART = 0;
    public static final byte PRE_FLOP = 1;
    public static final byte FLOP = 2;
    public static final byte TURN = 3;
    public static final byte RIVER = 4;
    public static final byte SHOWDOWN = 5;
    public static final byte NULL_STEP = 0;
    public static final byte RESET_STEP = 1;
    public static final byte PAUSE_STEP = 2;
    public static final byte SIT_IN_STEP = 3;
    public static final byte BLINDS_INCREASE_STEP = 4;
    public static final byte BLINDS_STEP = 5;
    public static final byte DEALING_STEP = 6;
    public static final byte AFTER_DEALING_STEP = 7;
    public static final byte BETTING_STEP = 8;
    public static final byte SHOWDOWN_STEP = 9;
    public static final byte WINNING_STEP = 10;
    public static final byte ELIMINATION_STEP = 11;
    public static final byte CONGRATS_STEP = 12;
    private static final byte SHOW_MESSAGE = 0;
    private static final byte AFTER_SHOW_MESSAGE = 1;
    private static final byte AFTER_ACTION = 2;
    public static final byte NONE = -2;
    public static final byte FOLD = -1;
    public static final byte CHECK = 0;
    public static final byte BET = 1;
    public static final byte CALL = 2;
    public static final byte RAISE = 3;
    public static final byte ALL_IN = 4;
    public static final byte SOUND_SHUFFLING = 1;
    public static final byte SOUND_DEALCARD = 2;
    public static final byte SOUND_FOLD = 3;
    public static final byte SOUND_RAISE = 4;
    public static final byte SOUND_PLAYERSTURN = 5;
    public static final byte SOUND_OPPONENTSTURN = 6;
    public static final byte SOUND_PLAYERWIN = 7;
    public static final byte SOUND_HUMANCONGRATS = 8;
    public static final Random RANDOM = new Random(System.currentTimeMillis());
    private static final byte GAME_VERSION = 2;
    private static final String[] NAME_POOL = new String[]{"Jose", "Jackie", "Hawk", "Alex", "Kris", "Norman", "Shred", "Sam", "Snake", "Kelli", "Nick", "Will", "Widow", "Al", "Weasel", "Omar", "Ted", "Marcy", "Joe", "Trips"};
    private static final byte[] INTELLIGENCE_POOL = new byte[]{10, 7, 3, 7, 5, 5, 3, 7, 1, 10, 3, 10, 7, 1, 7, 3, 10, 10, 10, 5};
    private static byte[] FACE_POOL;
    public static final GameController instance;
    private HoldemCanvas canvas;
    public Vector players;
    public Player humanPlayer;
    private int currentPlayer;
    private int dealingPlayer;
    private int bettingPlayer;
    private int roundPlayer;
    public final Pot pot = new Pot();
    private boolean playerFirstTime = true;
    private Vector removedPlayers = new Vector();
    public byte currentRound = 0;
    public int roundStep = 1;
    private int playerStep;
    public byte gameSpeed;
    private int nextPlayerToDealTo;
    private int dealingTicksLeft;
    private int showdownTicksLeft;
    private boolean showHandOnWin;
    private boolean incrementCurrentPlayer;
    private boolean incrementDealingPlayer = true;
    private boolean beginningOfRound = true;
    private boolean makePlayerVisible;
    public final Player community = new Player(0, null, 3, 0, 0L);
    public boolean gameover = true;
    public boolean paused;
    private boolean resetPlayersOnNextReset;
    private boolean initFromSettings;
    public boolean showActionsRightAway;
    public int smallBlind;
    private int lastSmallBlind;
    private static final short[] smallBlindSchedule;
    public byte blindsType;
    private long lastBlindsIncreaseTimestamp;
    private int blindsIncreaseMillisLeft;
    private short blindsIncreaseRoundsLeft;
    public static final byte STAY_THE_SAME = 0;
    public static final byte INCREASE_BY_TIMER = 1;
    public static final byte INCREASE_BY_ROUNDS = 2;
    public static byte SETTINGS_VERSION;
    public static byte blindsTypeSetting;
    public static int startingSmallBlindSetting;
    public static int blindIncreaseSecondsSetting;
    public static short blindIncreaseRoundsSetting;
    public static int gameSpeedSetting;
    public static boolean soundOnSetting;
    public static boolean autoPopupSetting;
    public static int demoGameCountSetting;
    public static boolean playerRespawnSetting;
    public static boolean pauseForWinSetting;
    public static boolean dealemButtonSetting;
    public static boolean restrictedRaisingSetting;
    public static boolean largeCardsSetting;
    public static boolean fastAfterHumanFoldSetting;
    public static boolean otherPlayersDisplayedSetting;
    public static boolean startingBlindsDisplayedSetting;
    private static final String PLAYER_RECORD_STORE_NAME = "Player";
    private static final String SETTINGS_RECORD_STORE_NAME = "Settings3";
    private static final String GAME_RECORD_STORE_NAME = "Game";
    public static final byte INIT = -1;
    public static final byte PRE_SPLASH1 = 0;
    public static final byte PRE_SPLASH2 = 1;
    public static final byte SPLASH = 2;
    public static final byte GAME_SCREEN = 3;
    public static byte screenStep;
    private static int settingsRecordId;
    public static final int INT_LENGTH = 4;
    public static final byte LONG_LENGTH = 8;

    private GameController() {
        Card.initDeck();
        FACE_POOL = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 0, 1, 2, 3, 4, 5, 6, 7, 0, 1, 2, 3};
        if (NAME_POOL.length != FACE_POOL.length) {
            throw new RuntimeException("NAME_POOL and FACE_POOL don't match");
        }
        if (NAME_POOL.length != INTELLIGENCE_POOL.length) {
            throw new RuntimeException("NAME_POOL and INTELLIGENCE_POOL don't match");
        }
    }

    public final boolean init(boolean startNewGame) {
        this.canvas = Holdem.gameCanvas;
        this.gameSpeed = (byte)gameSpeedSetting;
        if (this.humanPlayer != null && !this.humanPlayer.inTheGame && fastAfterHumanFoldSetting) {
            this.gameSpeed = (byte)Math.max(this.gameSpeed - 8, 0);
        }
        if (startNewGame || this.gameover) {
            this.gameover = false;
            this.initFromSettings();
            return this.reset();
        }
        this.initBlindsType(false);
        this.syncPlayers();
        HoldemCanvas.playerController.recomputePlayers();
        this.paused = false;
        return true;
    }

    private void initFromSettings() {
        Player p;
        int i;
        this.players = GameController.getPlayers(-1, -1);
        for (i = 0; i < this.players.size(); ++i) {
            p = (Player)this.players.elementAt(i);
            p.holdings = p.origHoldings;
        }
        this.humanPlayer = GameController.extractHumanPlayer(this.players);
        if (this.players.isEmpty()) {
            GameController.addDefaultComputerPlayers(this.players);
        }
        for (i = this.players.size() - 1; i >= 0; --i) {
            if (((Player)this.players.elementAt((int)i)).holdings != 0L) continue;
            this.players.removeElementAt(i);
        }
        this.players.insertElementAt(this.humanPlayer, 0);
        for (i = 0; i < this.players.size(); ++i) {
            p = (Player)this.players.elementAt(i);
            p.resetForNewGame();
        }
        this.dealingPlayer = Math.abs(RANDOM.nextInt()) % this.players.size();
        Player dealer = this.getDealerPlayer();
        if (dealer.holdings == 0L && this.dealingPlayer < this.players.size() - 1) {
            ++this.dealingPlayer;
        }
        this.bettingPlayer = this.roundPlayer = this.dealingPlayer;
        this.currentPlayer = this.roundPlayer;
        this.beginningOfRound = true;
        this.incrementDealingPlayer = false;
        this.initBlindsType(true);
        this.smallBlind = this.lastSmallBlind = startingSmallBlindSetting;
        this.canvas.updateBlinds();
        this.initFromSettings = true;
    }

    private void initBlindsType(boolean startNewGame) {
        byte newBlindsType = blindsTypeSetting;
        if (newBlindsType == 0) {
            this.smallBlind = this.lastSmallBlind = startingSmallBlindSetting;
            this.blindsIncreaseMillisLeft = 0;
            this.lastBlindsIncreaseTimestamp = 0;
            this.blindsIncreaseRoundsLeft = 0;
        } else if (newBlindsType == 1) {
            this.lastBlindsIncreaseTimestamp = System.currentTimeMillis();
            if (startNewGame || this.blindsType != newBlindsType) {
                this.blindsIncreaseMillisLeft = blindIncreaseSecondsSetting * 1000;
            }
        } else if (newBlindsType == 2 && (startNewGame || this.blindsType != newBlindsType)) {
            this.blindsIncreaseRoundsLeft = blindIncreaseRoundsSetting;
        }
        this.blindsType = newBlindsType;
    }

    private void syncPlayers() {
        Vector rmsPlayers = GameController.getComputerPlayers();
        rmsPlayers.insertElementAt(GameController.getHumanPlayer(), 0);
        for (int i = 0; i < this.players.size(); ++i) {
            Player player = (Player)this.players.elementAt(i);
            boolean found = false;
            for (int j = 0; j < rmsPlayers.size() && !found; ++j) {
                Player rmsPlayer = (Player)rmsPlayers.elementAt(j);
                if (rmsPlayer.recordId != player.recordId) continue;
                player.copyFrom(rmsPlayer);
                if (player.inTheGame && player.holdings == 0L) {
                    player.allIn = true;
                }
                found = true;
            }
            if (found) continue;
            player.deleted = true;
        }
    }

    private boolean reset() {
        if (this.resetPlayersOnNextReset) {
            this.initFromSettings();
        }
        for (int i = 0; i < this.players.size(); ++i) {
            Player player = (Player)this.players.elementAt(i);
            player.reset();
        }
        GameController.savePlayers(this.players);
        if (this.incrementDealingPlayer) {
            this.dealingPlayer = this.nextBlindPlayer(this.dealingPlayer);
            Player dealer = this.getDealerPlayer();
            if (dealer.holdings == 0L && !dealer.respawning && this.dealingPlayer < this.players.size() - 1) {
                ++this.dealingPlayer;
            }
        }
        this.currentRound = 0;
        this.roundStep = this.initFromSettings && this.countPlayersInGame() > 1 ? 4 : 3;
        if (!this.initFromSettings) {
            this.beginningOfRound = false;
            this.bettingPlayer = this.dealingPlayer;
            this.currentPlayer = 0;
        }
        this.initFromSettings = false;
        this.gameSpeed = (byte)gameSpeedSetting;
        this.community.reset();
        Card.shuffleDeck();
        this.pot.reset();
        this.dealingTicksLeft = 0;
        this.showdownTicksLeft = 0;
        this.incrementCurrentPlayer = false;
        this.playerFirstTime = true;
        this.showActionsRightAway = false;
        this.resetPlayersOnNextReset = false;
        this.makePlayerVisible = false;
        this.showHandOnWin = false;
        this.playerStep = 0;
        this.incrementDealingPlayer = true;
        if (!GameController.canPlay()) {
            this.gameover = true;
            return false;
        }
        this.canvas.playSound((byte)1);
        this.showNoPlayerHands();
        HoldemCanvas.playerController.recomputePlayers();
        this.paused = false;
        return true;
    }

    public final Player getCurrentPlayer() {
        return this.currentPlayer >= 0 && this.currentPlayer < this.players.size() ? this.players.elementAt(this.currentPlayer) : null;
    }

    public final Player getDealerPlayer() {
        return this.dealingPlayer >= 0 && this.dealingPlayer < this.players.size() ? this.players.elementAt(this.dealingPlayer) : null;
    }

    public final void pause() {
        if (this.paused) {
            return;
        }
        this.saveGame();
        this.savePlayers();
        this.paused = true;
        Holdem.gotoMainMenu(true);
    }

    public final void savePlayers() {
        for (int i = 0; i < this.players.size(); ++i) {
            this.removedPlayers.addElement(this.players.elementAt(i));
        }
        GameController.savePlayers(this.removedPlayers);
        this.removedPlayers.removeAllElements();
    }

    public final boolean update() {
        if (this.gameover || this.paused) {
            return false;
        }
        if (this.currentRound == 0) {
            switch (this.roundStep) {
                case 0: {
                    return false;
                }
                case 1: {
                    if (this.reset()) break;
                    Holdem.gotoDemoAlert();
                    this.roundStep = 0;
                    return false;
                }
                case 2: {
                    if (this.countPlayersInGame() > 1) {
                        this.roundStep = 3;
                        break;
                    }
                    this.canvas.setMessage("Not enough players");
                    this.gameover = true;
                    break;
                }
                case 3: {
                    while (true) {
                        if (this.incrementCurrentPlayer) {
                            this.incrementCurrentPlayer = false;
                            if (this.currentPlayer >= this.players.size() - 1) {
                                this.currentPlayer = this.dealingPlayer;
                                ++this.roundStep;
                                break;
                            }
                            ++this.currentPlayer;
                        }
                        Player p = this.getCurrentPlayer();
                        if (p.respawning) {
                            if (p.holdings == 0L) {
                                GameController.respawnPlayer(p);
                            }
                            if (this.makePlayerVisible(p)) {
                                return true;
                            }
                            p.respawning = false;
                            this.canvas.setMessage(GameController.replace("&1 sits down!", p.name, null));
                            this.incrementCurrentPlayer = true;
                            return true;
                        }
                        if (p.holdings > 0L && p.allDone) {
                            p.allDone = false;
                            p.mustPayLargeBlind = true;
                        }
                        this.incrementCurrentPlayer = true;
                    }
                }
                case 4: {
                    if (this.countPlayersInGame() < 2) {
                        this.roundStep = 2;
                        return false;
                    }
                    ++this.roundStep;
                    this.nextPlayerToDealTo = this.incrementPlayer(this.dealingPlayer);
                    if (this.checkForBlindsIncrease()) {
                        this.increaseBlinds();
                        this.pot.requiredBet = this.smallBlind * 2;
                        this.canvas.setMessage(GameController.replace("Blinds increase to &1", GameController.toBlindsString(this.smallBlind), null));
                        break;
                    }
                    this.pot.requiredBet = this.smallBlind * 2;
                }
                case 5: {
                    if (!this.getDealerPlayer().inTheGame) {
                        this.dealingPlayer = this.incrementPlayer(this.dealingPlayer);
                        this.nextPlayerToDealTo = this.incrementPlayer(this.dealingPlayer);
                    }
                    if (this.incrementCurrentPlayer) {
                        this.incrementCurrentPlayer = false;
                        this.currentPlayer = this.incrementPlayer(this.currentPlayer);
                        if (this.currentPlayer == this.dealingPlayer) {
                            ++this.roundStep;
                        }
                    }
                    while (this.roundStep == 5) {
                        if (this.computeBlindsToPay()) {
                            if (!this.makePlayerVisible) {
                                this.incrementCurrentPlayer = true;
                            }
                            return true;
                        }
                        this.currentPlayer = this.incrementPlayer(this.currentPlayer);
                        if (this.currentPlayer != this.dealingPlayer) continue;
                        ++this.roundStep;
                    }
                    this.currentPlayer = this.dealingPlayer;
                }
                case 6: {
                    Player nextPlayer = this.getNextPlayerToDealTo();
                    if (this.dealingTicksLeft > 0) {
                        --this.dealingTicksLeft;
                        return false;
                    }
                    boolean firstTime = true;
                    boolean keepDealing = true;
                    while (keepDealing) {
                        if (firstTime) {
                            this.canvas.playSound((byte)2);
                        }
                        nextPlayer.addCard(Card.removeTopCard());
                        firstTime = false;
                        keepDealing = false;
                        if (this.nextPlayerToDealTo == this.dealingPlayer && nextPlayer.cards.size() == 2) {
                            this.currentPlayer = this.countPlayersInGame() == 2 ? (this.bettingPlayer = this.dealingPlayer) : (this.bettingPlayer = this.incrementPlayer(this.incrementPlayer(this.incrementPlayer(this.dealingPlayer))));
                            if (this.getCurrentPlayer().type == 1) {
                                this.currentRound = (byte)(this.currentRound + 1);
                                this.roundStep = 8;
                                continue;
                            }
                            this.roundStep = 7;
                            this.dealingTicksLeft = 2 * this.gameSpeed;
                            continue;
                        }
                        this.nextPlayerToDealTo = this.incrementPlayer(this.nextPlayerToDealTo);
                        if (!Sprite.isVisible(nextPlayer)) {
                            nextPlayer = this.getNextPlayerToDealTo();
                            keepDealing = true;
                            continue;
                        }
                        this.dealingTicksLeft = 3;
                    }
                    break;
                }
                case 7: {
                    if (this.makePlayerVisible(this.getCurrentPlayer())) {
                        return true;
                    }
                    if (this.dealingTicksLeft > 0) {
                        --this.dealingTicksLeft;
                        return false;
                    }
                    this.currentRound = (byte)(this.currentRound + 1);
                    this.roundStep = 8;
                }
            }
        } else if (this.roundStep == 8) {
            if (this.getCurrentPlayer().allIn) {
                this.incrementCurrentPlayer = true;
            }
            boolean firstTime = true;
            while (firstTime || this.incrementCurrentPlayer) {
                firstTime = false;
                boolean doIncrement = this.incrementCurrentPlayer;
                this.incrementCurrentPlayer = false;
                int onlyPlayer = this.getOnlyPlayerInGame();
                if (onlyPlayer >= 0) {
                    this.currentPlayer = onlyPlayer;
                    this.win(false);
                    return true;
                }
                if (doIncrement && this.incrementCurrentPlayer() < 0) {
                    this.nextRound();
                    return true;
                }
                if (!this.getCurrentPlayer().allIn) continue;
                this.incrementCurrentPlayer = true;
            }
            Player player = this.getCurrentPlayer();
            if (this.countNonAllInPlayers() < 2 && (player.allIn || player.bet == this.pot.getMaxBet())) {
                this.nextRound();
                return true;
            }
            if (player.type == 1) {
                this.canvas.yourTurn();
                if (this.playerFirstTime) {
                    this.canvas.playSound((byte)5);
                    if (autoPopupSetting || this.showActionsRightAway) {
                        this.canvas.showActions();
                        this.showActionsRightAway = false;
                    }
                }
                this.playerFirstTime = false;
            } else {
                if (this.makePlayerVisible(player)) {
                    return true;
                }
                this.canvas.playSound((byte)6);
                this.playerFirstTime = true;
                AI.instance.choosePlayerAction(player);
            }
        } else if (this.roundStep == 6) {
            if (this.dealingTicksLeft > 0) {
                --this.dealingTicksLeft;
                return false;
            }
            if (this.currentRound == 2 && this.community.cards.size() == 3 || this.currentRound == 3 && this.community.cards.size() == 4 || this.currentRound == 4 && this.community.cards.size() == 5) {
                if (this.getOnlyPlayerInGame() >= 0 || this.currentRound <= 3 && this.countNonAllInPlayers() < 2) {
                    this.roundStep = 7;
                    this.dealingTicksLeft = this.currentRound <= 3 ? 4 * this.gameSpeed : 0;
                } else if (this.getCurrentPlayer().type == 1) {
                    this.roundStep = 8;
                } else {
                    this.roundStep = 7;
                    this.dealingTicksLeft = 2 * this.gameSpeed;
                }
                return false;
            }
            this.community.addCard(Card.removeTopCard());
            this.dealingTicksLeft = 3;
        } else {
            if (this.roundStep == 7) {
                if (this.getOnlyPlayerInGame() < 0 && this.countNonAllInPlayers() >= 2 && this.makePlayerVisible(this.getCurrentPlayer())) {
                    return true;
                }
                if (this.dealingTicksLeft > 0) {
                    --this.dealingTicksLeft;
                    return false;
                }
                if (this.getOnlyPlayerInGame() >= 0) {
                    if (this.currentRound == 4) {
                        this.afterWin();
                    } else {
                        this.currentRound = (byte)(this.currentRound + 1);
                        this.roundStep = 6;
                    }
                } else {
                    this.roundStep = 8;
                }
                return false;
            }
            if (this.roundStep == 9) {
                Player player;
                if (this.showdownTicksLeft > 0) {
                    --this.showdownTicksLeft;
                    return false;
                }
                this.highlightCards(this.community.cards, false);
                if (this.getCurrentPlayer() != null) {
                    this.highlightCards(this.getCurrentPlayer().cards, false);
                }
                if (this.incrementCurrentPlayer) {
                    this.incrementCurrentPlayer = false;
                    if (this.incrementCurrentPlayer() < 0) {
                        this.pot.computeWinners();
                        this.currentPlayer = this.players.indexOf(this.pot.nextWinner());
                        this.win(true);
                        return true;
                    }
                }
                if (this.makePlayerVisible(player = this.getCurrentPlayer())) {
                    return true;
                }
                player.showCards();
                this.highlightCards(player.combinedPokerHandCards, true);
                String s = player.handToString(true);
                char c = s.charAt(0);
                if (Character.isLowerCase(c)) {
                    s = Character.toUpperCase(c) + s.substring(1);
                }
                this.canvas.setLongMessage(s);
                this.incrementCurrentPlayer = true;
                this.showdownTicksLeft = this.gameSpeed;
            } else if (this.roundStep == 10) {
                Player nextWinner;
                if (this.getCurrentPlayer() != null) {
                    this.highlightCards(this.getCurrentPlayer().combinedPokerHandCards, false);
                }
                if ((nextWinner = this.pot.nextWinner()) != null) {
                    this.currentPlayer = this.players.indexOf(nextWinner);
                }
                this.win(this.showHandOnWin);
            } else {
                if (this.roundStep == 11) {
                    if (this.playerStep < 0) {
                        if (this.getCurrentPlayer() != null) {
                            this.highlightCards(this.getCurrentPlayer().combinedPokerHandCards, false);
                        }
                        this.playerStep = 0;
                        this.currentPlayer = 0;
                    }
                    int nextDealingPlayer = this.incrementDealingPlayer ? this.nextBlindPlayer(this.dealingPlayer) : this.dealingPlayer;
                    int position = 0;
                    for (int i = 0; i < this.players.size(); ++i) {
                        Player p = (Player)this.players.elementAt(i);
                        if (p.allDone || p.holdings <= 0L) continue;
                        ++position;
                    }
                    ++position;
                    while (true) {
                        if (this.incrementCurrentPlayer) {
                            this.incrementCurrentPlayer = false;
                            if (this.currentPlayer >= this.players.size() - 1) break;
                            this.playerStep = 0;
                            ++this.currentPlayer;
                        }
                        Player p = this.getCurrentPlayer();
                        if (p.holdings == 0L) {
                            if (this.makePlayerVisible(p)) {
                                return true;
                            }
                            if (this.playerStep == 0 && !p.allDone) {
                                this.canvas.setMessage(GameController.replace("&1 is eliminated!", p.name, null));
                                this.playerStep = 1;
                                return true;
                            }
                            if (this.playerStep != 0 && this.playerStep != 1) continue;
                            if (playerRespawnSetting && p.type == 2 && p.recordId >= 0) {
                                p.respawning = true;
                                this.canvas.setShortMessage("");
                                this.incrementCurrentPlayer = true;
                                return true;
                            }
                            int next = this.nextBlindPlayer(nextDealingPlayer);
                            if (this.currentPlayer == nextDealingPlayer || this.currentPlayer == next) {
                                ((Player)this.players.elementAt((int)this.nextBlindPlayer((int)next))).mustPayLargeBlind = true;
                            }
                            if (p.type == 2) {
                                HoldemCanvas.playerController.removePlayer(p);
                                this.removedPlayers.addElement(p);
                                if (this.currentPlayer == this.dealingPlayer) {
                                    this.incrementDealingPlayer = false;
                                    nextDealingPlayer = this.dealingPlayer;
                                } else if (this.currentPlayer < this.dealingPlayer) {
                                    --this.dealingPlayer;
                                    if (this.currentPlayer < nextDealingPlayer) {
                                        --nextDealingPlayer;
                                    }
                                }
                                if (this.currentPlayer < this.roundPlayer) {
                                    --this.roundPlayer;
                                }
                                if (this.dealingPlayer >= this.players.size()) {
                                    int n = this.dealingPlayer = this.humanPlayer.allDone ? 1 : 0;
                                }
                                if (nextDealingPlayer >= this.players.size()) {
                                    int n = nextDealingPlayer = this.humanPlayer.allDone ? 1 : 0;
                                }
                                if (this.roundPlayer >= this.players.size()) {
                                    int n = this.roundPlayer = this.humanPlayer.allDone ? 1 : 0;
                                }
                                if (this.currentPlayer >= this.players.size()) {
                                    this.currentPlayer = 0;
                                    break;
                                }
                                this.playerStep = 0;
                                p.eliminated(position);
                                return true;
                            }
                            if (this.currentPlayer == this.roundPlayer) {
                                this.roundPlayer = this.nextBlindPlayer(this.currentPlayer);
                            }
                            if (this.currentPlayer == nextDealingPlayer) {
                                nextDealingPlayer = this.nextBlindPlayer(this.currentPlayer);
                            }
                            if (this.currentPlayer == this.dealingPlayer) {
                                this.dealingPlayer = this.nextBlindPlayer(this.currentPlayer);
                                this.incrementDealingPlayer = false;
                                nextDealingPlayer = this.dealingPlayer;
                            }
                            if (this.currentPlayer >= this.players.size() - 1) break;
                            this.incrementCurrentPlayer = true;
                            this.playerStep = 0;
                            p.eliminated(position);
                            continue;
                        }
                        if (this.currentPlayer >= this.players.size() - 1) break;
                        this.incrementCurrentPlayer = true;
                    }
                    if (!playerRespawnSetting && this.getLastPlayerStanding() != null) {
                        this.roundStep = 12;
                    } else {
                        this.currentRound = 0;
                        this.roundStep = 1;
                    }
                    return true;
                }
                if (this.roundStep == 12) {
                    Player winningPlayer = this.getLastPlayerStanding();
                    winningPlayer.wonItAll();
                    this.canvas.displayCongrats(winningPlayer);
                    this.resetPlayersOnNextReset = true;
                    this.currentRound = 0;
                    this.roundStep = 1;
                }
            }
        }
        return true;
    }

    public final void playerAction(Player player, long betamt, boolean choseAllIn) {
        long[] availableBets;
        int action = this.getAction(player, betamt);
        if (action == -2) {
            return;
        }
        if (player != this.getCurrentPlayer() || this.incrementCurrentPlayer || this.roundStep != 8) {
            return;
        }
        if (player.type == 2 && (action == 1 || action == 3) && (availableBets = this.getAvailableBets(player)).length > 2 && betamt < availableBets[2]) {
            betamt = availableBets[2];
            action = this.getAction(player, betamt);
        }
        this.playerFirstTime = true;
        if (action == -1) {
            this.canvas.playSound((byte)3);
            player.recordPlayerAction(-1L, choseAllIn);
            player.bet = 0L;
            player.inTheGame = false;
            this.incrementCurrentPlayer = true;
            if (player.type == 1 && fastAfterHumanFoldSetting) {
                this.gameSpeed = (byte)Math.max(this.gameSpeed - 8, 0);
            }
            this.canvas.setMessage(GameController.replace("&1 folds", player.name, null));
        } else if (action == 0) {
            if (player.bet < this.pot.getRequiredBet()) {
                return;
            }
            player.recordPlayerAction(0L, choseAllIn);
            this.incrementCurrentPlayer = true;
            this.canvas.setMessage(GameController.replace("&1 checks", player.name, null));
        } else {
            if (action != 4 && action != 2 && player.bet + betamt < this.pot.getRequiredBet()) {
                return;
            }
            if (action == 2 && player.bet + betamt > this.pot.getRequiredBet()) {
                return;
            }
            player.recordPlayerAction(betamt, choseAllIn);
            long raiseAmount = this.getRaiseAmount(player, betamt);
            long origPlayerHoldings = player.holdings;
            boolean atRequiredBet = player.bet == this.pot.getRequiredBet();
            this.bet(betamt, true);
            if (action == 2) {
                this.canvas.setMessage(GameController.replace("&1 calls", player.name, null));
            } else if (action == 1 || action == 4 && !choseAllIn && betamt < origPlayerHoldings && atRequiredBet) {
                this.canvas.playSound((byte)4);
                this.canvas.setMessage(GameController.replace("&1 bets &2", player.name, GameController.toMoney(betamt)));
            } else if (action == 3 || action == 4 && !choseAllIn && betamt < origPlayerHoldings) {
                this.canvas.playSound((byte)4);
                this.canvas.setMessage(GameController.replace("&1 raises &2", player.name, GameController.toMoney(raiseAmount)));
            } else if (action == 4) {
                this.canvas.playSound((byte)4);
                this.canvas.setMessage(GameController.replace("&1 is all in", player.name, null));
            }
            this.incrementCurrentPlayer = true;
        }
    }

    public void afterWin() {
        this.playerStep = -1;
        this.roundStep = this.pot.nextWinner() == null ? 11 : 10;
    }

    public void dealem() {
        this.currentRound = (byte)(this.currentRound + 1);
        this.roundStep = 6;
        this.update();
    }

    public long getRaiseAmount(Player player, long betamt) {
        return player.bet + betamt - this.pot.getRequiredBet();
    }

    public long getBetAmount(Player player, long raiseamt) {
        return raiseamt - player.bet + this.pot.getRequiredBet();
    }

    public final int getAction(Player player, long betamt) {
        if (betamt == -1L) {
            return -1;
        }
        if (player.holdings - betamt <= 0L) {
            return 4;
        }
        if (betamt == 0L) {
            return 0;
        }
        if (betamt == this.getPlayerCallAmount(player)) {
            return 2;
        }
        if (this.getMaxPlayerMoney(player) - betamt <= 0L) {
            return 4;
        }
        if (player.bet == this.pot.getRequiredBet() && betamt > 0L) {
            return 1;
        }
        if (player.bet + betamt > this.pot.getRequiredBet()) {
            return 3;
        }
        return -2;
    }

    public final long[] getAvailableBets(Player player) {
        if (player != this.getCurrentPlayer() || this.incrementCurrentPlayer || !player.inTheGame || this.roundStep != 8) {
            return new long[]{-2L};
        }
        long betIncrement = this.smallBlind * 2;
        if (betIncrement < this.pot.lastBet && restrictedRaisingSetting) {
            betIncrement = this.pot.lastBet;
        }
        int numberOfBets = 2;
        numberOfBets = this.isBetPossible(player) ? (player.holdings > this.pot.getRequiredBet() - player.bet + betIncrement && this.getMaxPlayerMoney(player) > this.pot.getRequiredBet() - player.bet + betIncrement ? 4 : 3) : 2;
        long[] result = new long[numberOfBets];
        result[0] = -1L;
        result[1] = Math.min(this.getPlayerCallAmount(player), player.holdings);
        if (numberOfBets >= 3) {
            result[2] = Math.min(result[1] + betIncrement, Math.min(this.getMaxPlayerMoney(player), player.holdings));
        }
        if (numberOfBets >= 4) {
            result[3] = Math.min(player.holdings, this.getMaxPlayerMoney(player));
        }
        return result;
    }

    public boolean canPlayerPlay(Player player) {
        return !this.gameover && player == this.getCurrentPlayer() && !this.incrementCurrentPlayer && player.inTheGame && this.roundStep == 8;
    }

    public final boolean isBetPossible(Player player) {
        return player.holdings > this.pot.getRequiredBet() - player.bet && this.getMaxPlayerMoney(player) > this.pot.getRequiredBet() - player.bet && this.countNonAllInPlayers() > 1;
    }

    private long getPlayerCallAmount(Player player) {
        return Math.min(this.getMaxPlayerMoney(player), this.pot.getRequiredBet() - player.bet);
    }

    private void highlightCards(Vector cards, boolean highlighted) {
        for (int i = 0; cards != null && i < cards.size(); ++i) {
            ((Card)cards.elementAt((int)i)).highlighted = highlighted;
        }
    }

    public final int getPlayerPosition() {
        int position = 0;
        position = this.currentPlayer > this.dealingPlayer ? this.currentPlayer - this.dealingPlayer : this.players.size() - this.dealingPlayer + this.currentPlayer;
        return position;
    }

    private boolean checkForBlindsIncrease() {
        if (this.blindsType == 1 && System.currentTimeMillis() - this.lastBlindsIncreaseTimestamp >= (long)this.blindsIncreaseMillisLeft) {
            return true;
        }
        if (this.blindsType == 2 && this.isAtEndOfRound()) {
            this.blindsIncreaseRoundsLeft = (short)(this.blindsIncreaseRoundsLeft - 1);
            if (this.blindsIncreaseRoundsLeft <= 0) {
                return true;
            }
        }
        return false;
    }

    private void increaseBlinds() {
        if (this.blindsType == 1) {
            this.blindsIncreaseMillisLeft = blindIncreaseSecondsSetting * 1000;
            this.lastBlindsIncreaseTimestamp = System.currentTimeMillis();
        } else if (this.blindsType == 2) {
            this.blindsIncreaseRoundsLeft = blindIncreaseRoundsSetting;
        }
        int nextSmallBlind = 2 * this.lastSmallBlind;
        for (int i = 0; i < smallBlindSchedule.length - 1; ++i) {
            if (smallBlindSchedule[i] != this.smallBlind) continue;
            nextSmallBlind = smallBlindSchedule[i + 1];
            break;
        }
        this.lastSmallBlind = this.smallBlind;
        this.smallBlind = nextSmallBlind;
        this.canvas.updateBlinds();
    }

    private boolean isAtEndOfRound() {
        return this.dealingPlayer == this.roundPlayer && !this.beginningOfRound;
    }

    private boolean computeBlindsToPay() {
        Player p = this.getCurrentPlayer();
        if (this.countPlayersInGame() == 2) {
            p.mustPaySmallBlind = false;
            p.mustPayLargeBlind = false;
            if (this.currentPlayer == this.dealingPlayer) {
                this.payBlinds(true, false, false);
                return true;
            }
            this.payBlinds(false, true, true);
            return true;
        }
        boolean countAsBet = false;
        if (this.currentPlayer == this.incrementPlayer(this.dealingPlayer) && !p.mustPayLargeBlind) {
            p.mustPaySmallBlind = true;
        }
        if (this.currentPlayer == this.incrementPlayer(this.incrementPlayer(this.dealingPlayer))) {
            p.mustPayLargeBlind = true;
            countAsBet = true;
        }
        if (p.mustPayLargeBlind) {
            if (this.payBlinds(p.mustPaySmallBlind, true, countAsBet)) {
                p.mustPaySmallBlind = true;
                p.mustPayLargeBlind = false;
            }
            return true;
        }
        if (p.mustPaySmallBlind) {
            if (this.payBlinds(true, false, false)) {
                p.mustPaySmallBlind = false;
            }
            return true;
        }
        return false;
    }

    private boolean payBlinds(boolean paySmallBlind, boolean payLargeBlind, boolean countAsBet) {
        Player p = this.getCurrentPlayer();
        if (this.makePlayerVisible(p)) {
            return false;
        }
        long actualAmount = (paySmallBlind ? this.smallBlind : 0) + (payLargeBlind ? this.smallBlind * 2 : 0);
        long amt = Math.min(actualAmount, this.getMaxPlayerMoney(p));
        if (p.holdings < actualAmount && p.holdings <= amt) {
            this.bet(p.holdings, countAsBet);
            this.canvas.setMessage(GameController.replace("&1 is all in", p.name, null));
        } else {
            this.bet(amt, countAsBet);
            if (paySmallBlind && payLargeBlind) {
                this.canvas.setShortMessage(GameController.replace("Both blinds", p.name, null));
            } else if (paySmallBlind) {
                this.canvas.setShortMessage(GameController.replace("Small blind", p.name, null));
            } else if (payLargeBlind) {
                this.canvas.setShortMessage(GameController.replace("Large blind", p.name, null));
            }
        }
        return true;
    }

    private void nextRound() {
        block4: {
            int i;
            block5: {
                block3: {
                    this.currentRound = (byte)(this.currentRound + 1);
                    if (this.currentRound != 1) break block3;
                    this.roundStep = 8;
                    break block4;
                }
                if (this.currentRound != 5) break block5;
                this.currentPlayer = this.bettingPlayer;
                this.roundStep = 9;
                for (int i2 = 0; i2 < this.players.size(); ++i2) {
                    ((Player)this.players.elementAt(i2)).clearBet();
                }
                break block4;
            }
            this.roundStep = 6;
            this.currentPlayer = this.bettingPlayer = this.incrementPlayer(this.dealingPlayer);
            this.pot.clearBet();
            for (i = 0; i < this.players.size(); ++i) {
                ((Player)this.players.elementAt(i)).clearBet();
            }
            this.dealingTicksLeft = 0;
            if (this.countNonAllInPlayers() >= 2) break block4;
            for (i = 0; i < this.players.size(); ++i) {
                Player p = (Player)this.players.elementAt(i);
                if (!p.inTheGame) continue;
                p.displayCards = true;
                p.showCards = true;
            }
        }
    }

    private boolean win(boolean showHand) {
        Player player = this.getCurrentPlayer();
        this.showHandOnWin = showHand;
        this.roundStep = 10;
        if (this.makePlayerVisible(player)) {
            return false;
        }
        long amt = this.pot.win(player, true);
        if (amt == 0L) {
            this.afterWin();
            return true;
        }
        long reportableAmount = amt;
        if (!showHand) {
            reportableAmount -= this.pot.lastBet;
        }
        if (player.showCards) {
            this.highlightCards(player.combinedPokerHandCards, true);
        }
        this.canvas.setLongMessage(GameController.replace("&1 wins &2", player.name, GameController.toMoney(reportableAmount)));
        if (pauseForWinSetting) {
            this.canvas.pauseForWin();
        }
        if (player.type == 1) {
            this.canvas.playSound((byte)7);
        }
        this.afterWin();
        return true;
    }

    private void bet(long amount, boolean countAsBet) {
        boolean allIn;
        Player player = this.getCurrentPlayer();
        boolean bl = allIn = player.holdings <= amount || this.getMaxPlayerMoney(player) <= amount;
        if (this.pot.bet(player, player.bet, amount, countAsBet) && countAsBet) {
            if (allIn) {
                player.allIn = true;
            }
            this.bettingPlayer = this.currentPlayer;
        }
    }

    private Player getLastPlayerStanding() {
        Player playerWithMoney = null;
        boolean foundaPlayer = false;
        for (int i = 0; i < this.players.size(); ++i) {
            Player p = (Player)this.players.elementAt(i);
            if (p.holdings <= 0L) continue;
            if (playerWithMoney == null) {
                playerWithMoney = p;
                foundaPlayer = true;
                continue;
            }
            playerWithMoney = null;
            break;
        }
        return playerWithMoney;
    }

    private int getOnlyPlayerInGame() {
        int player = -1;
        for (int i = 0; i < this.players.size(); ++i) {
            Player p = (Player)this.players.elementAt(i);
            if (!p.inTheGame) continue;
            if (player == -1) {
                player = i;
                continue;
            }
            return -1;
        }
        return player;
    }

    private long getMaxPlayerMoney(Player player) {
        long max = 0L;
        for (int i = 0; i < this.players.size(); ++i) {
            long amt;
            Player p = (Player)this.players.elementAt(i);
            if (p == player || !p.inTheGame || (amt = p.holdings + (player != null ? p.bet - player.bet : 0L)) <= max) continue;
            max = amt;
        }
        return max;
    }

    private int countPlayersInGame() {
        int count = 0;
        for (int i = 0; i < this.players.size(); ++i) {
            Player p = (Player)this.players.elementAt(i);
            if (!p.inTheGame) continue;
            ++count;
        }
        return count;
    }

    private int countNonAllInPlayers() {
        int count = 0;
        for (int i = 0; i < this.players.size(); ++i) {
            Player p = (Player)this.players.elementAt(i);
            if (!p.inTheGame || p.allIn) continue;
            ++count;
        }
        return count;
    }

    private int nextBlindPlayer(int playerIndex) {
        return this.incrementPlayer(playerIndex, playerIndex, false, true);
    }

    private int incrementPlayer(int playerIndex) {
        return this.incrementPlayer(playerIndex, playerIndex, false, false);
    }

    private int incrementCurrentPlayer() {
        int next = this.incrementPlayer(this.currentPlayer, this.currentPlayer, true, false);
        if (next >= 0) {
            this.currentPlayer = next;
        }
        return next;
    }

    private int incrementPlayer(int playerIndex, int origIndex, boolean stopAtBettingPlayer, boolean isForBlinds) {
        int nextIndex;
        int n = nextIndex = playerIndex >= this.players.size() - 1 ? 0 : playerIndex + 1;
        if (stopAtBettingPlayer && nextIndex == this.bettingPlayer) {
            return -1;
        }
        Player p = (Player)this.players.elementAt(nextIndex);
        if (nextIndex == origIndex || !isForBlinds && p.inTheGame || isForBlinds && (!p.allDone || p.holdings > 0L)) {
            return nextIndex;
        }
        return this.incrementPlayer(nextIndex, origIndex, stopAtBettingPlayer, isForBlinds);
    }

    private Player getNextPlayerToDealTo() {
        return (Player)this.players.elementAt(this.nextPlayerToDealTo);
    }

    private void showNoPlayerHands() {
        for (int i = 0; i < this.players.size(); ++i) {
            Player p = (Player)this.players.elementAt(i);
            p.displayCards = p.type == 1;
        }
    }

    public String[] getActionNames(long[] availableBets) {
        String[] result = new String[availableBets.length];
        for (int i = 0; i < availableBets.length; ++i) {
            result[i] = this.getActionName(this.humanPlayer, availableBets[i]);
        }
        return result;
    }

    public String getActionName(Player player, long bet) {
        int action = this.getAction(player, bet);
        switch (action) {
            case -1: {
                return "Fold";
            }
            case 0: {
                return "Check";
            }
            case 2: {
                if (player.type == 2) {
                    return GameController.replace("Call", GameController.toMoney(bet), null);
                }
                return GameController.replace("Call (&1)", GameController.toMoney(bet), null);
            }
            case 1: {
                if (player.type == 2) {
                    return GameController.replace("B &1 ", GameController.toMoney(bet), null);
                }
                return "Bet";
            }
            case 3: {
                if (player.type == 2) {
                    return GameController.replace("R &1 ", GameController.toMoney(this.getRaiseAmount(player, bet)), null);
                }
                return "Raise";
            }
            case 4: {
                return "All In";
            }
        }
        return null;
    }

    public byte getPlayerScrollInfo(Player player) {
        if (this.players.size() <= 2) {
            return 1;
        }
        int index = this.players.indexOf(player);
        return (byte)(index == 1 ? 0 : (index == this.players.size() - 1 ? 2 : 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveGame() {
        try {
            byte[][] data = new byte[][]{new byte[1024]};
            int offset = 0;
            offset += GameController.writeInt(2, data, offset);
            offset += GameController.writeInt(this.gameover ? 1 : 0, data, offset);
            if (!this.gameover) {
                offset += GameController.writeInt(this.currentPlayer, data, offset);
                offset += GameController.writeInt(this.dealingPlayer, data, offset);
                offset += GameController.writeInt(this.bettingPlayer, data, offset);
                offset += GameController.writeInt(this.nextPlayerToDealTo, data, offset);
                offset += GameController.writeInt(this.players != null ? this.players.size() : 0, data, offset);
                for (int i = 0; i < (this.players != null ? this.players.size() : 0); ++i) {
                    offset = ((Player)this.players.elementAt(i)).writeBytes(data, offset, true);
                }
                if (this.players.size() >= 2) {
                    offset = this.pot.writeBytes(data, offset);
                    offset += GameController.writeInt((this.playerFirstTime ? 1 : 0) | (this.incrementCurrentPlayer ? 2 : 0) | (this.paused ? 4 : 0) | (this.resetPlayersOnNextReset ? 8 : 0) | (this.beginningOfRound ? 16 : 0) | (this.showHandOnWin ? 32 : 0) | (this.incrementDealingPlayer ? 64 : 0), data, offset);
                    offset += GameController.writeInt(this.currentRound, data, offset);
                    offset += GameController.writeInt(this.roundStep, data, offset);
                    offset += GameController.writeInt(this.playerStep, data, offset);
                    offset = this.community.writeHandBytes(data, offset);
                    offset += GameController.writeInt(this.smallBlind, data, offset);
                    offset += GameController.writeInt(this.lastSmallBlind, data, offset);
                    offset += GameController.writeInt(this.blindsType, data, offset);
                    offset += GameController.writeInt(this.blindsIncreaseMillisLeft, data, offset);
                    offset += GameController.writeInt(this.blindsIncreaseRoundsLeft, data, offset);
                    offset += GameController.writeInt(this.gameSpeed, data, offset);
                }
            }
            try {
                RecordStore.deleteRecordStore((String)GAME_RECORD_STORE_NAME);
            }
            catch (Exception e) {
                // empty catch block
            }
            RecordStore store = null;
            try {
                store = RecordStore.openRecordStore((String)GAME_RECORD_STORE_NAME, (boolean)true);
                store.addRecord(data[0], 0, offset);
            }
            finally {
                GameController.closeStore(store);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadGame() {
        try {
            int i;
            int offset = 0;
            byte[] data = null;
            RecordStore store = null;
            try {
                RecordEnumeration e;
                store = RecordStore.openRecordStore((String)GAME_RECORD_STORE_NAME, (boolean)false);
                if (store != null && store.getNumRecords() > 0 && (e = store.enumerateRecords(null, null, true)).hasNextElement()) {
                    data = e.nextRecord();
                }
            }
            finally {
                GameController.closeStore(store);
            }
            if (data == null) {
                return;
            }
            int version = GameController.readInt(data, offset);
            offset += 4;
            if (version != 2) {
                this.gameover = true;
                return;
            }
            this.gameover = GameController.readInt(data, offset) == 1;
            offset += 4;
            if (this.gameover) {
                return;
            }
            this.currentPlayer = GameController.readInt(data, offset);
            this.dealingPlayer = GameController.readInt(data, offset += 4);
            this.bettingPlayer = GameController.readInt(data, offset += 4);
            this.nextPlayerToDealTo = GameController.readInt(data, offset += 4);
            int playersSize = GameController.readInt(data, offset += 4);
            offset += 4;
            this.players = new Vector();
            for (int i2 = 0; i2 < playersSize; ++i2) {
                Player p = new Player();
                offset = p.readBytes(data, offset, true);
                this.players.addElement(p);
                if (p.type != 1) continue;
                this.humanPlayer = p;
            }
            if (this.players.size() < 2) {
                this.gameover = true;
                return;
            }
            offset = this.pot.readBytes(data, offset, this.players);
            int booleans = GameController.readInt(data, offset);
            offset += 4;
            this.playerFirstTime = (booleans & 1) != 0;
            this.incrementCurrentPlayer = (booleans & 2) != 0;
            this.paused = (booleans & 4) != 0;
            this.resetPlayersOnNextReset = (booleans & 8) != 0;
            this.beginningOfRound = (booleans & 0x10) != 0;
            this.showHandOnWin = (booleans & 0x20) != 0;
            this.incrementDealingPlayer = (booleans & 0x40) != 0;
            this.currentRound = (byte)GameController.readInt(data, offset);
            this.roundStep = GameController.readInt(data, offset += 4);
            this.playerStep = GameController.readInt(data, offset += 4);
            offset += 4;
            if (this.roundStep == 12) {
                this.gameover = true;
                return;
            }
            if (this.roundStep == 9) {
                this.currentPlayer = this.bettingPlayer;
            }
            this.dealingTicksLeft = 0;
            this.showdownTicksLeft = 0;
            offset = this.community.readHandBytes(data, offset);
            this.smallBlind = GameController.readInt(data, offset);
            this.lastSmallBlind = GameController.readInt(data, offset += 4);
            this.blindsType = (byte)GameController.readInt(data, offset += 4);
            this.blindsIncreaseMillisLeft = GameController.readInt(data, offset += 4);
            this.blindsIncreaseRoundsLeft = (short)GameController.readInt(data, offset += 4);
            this.gameSpeed = (byte)GameController.readInt(data, offset += 4);
            offset += 4;
            Card.shuffleDeck();
            for (i = 0; i < this.community.cards.size(); ++i) {
                Card.removeCard(this.community.getCard(i));
            }
            for (i = 0; i < this.players.size(); ++i) {
                Player p = (Player)this.players.elementAt(i);
                for (int j = 0; j < p.cards.size(); ++j) {
                    Card.removeCard(p.getCard(j));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean makePlayerVisible(Player player) {
        if (this.makePlayerVisible) ** GOTO lbl-1000
        if (HoldemCanvas.playerController.makePlayerVisible(player)) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        this.makePlayerVisible = v0;
        return this.makePlayerVisible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void savePlayer(Player player) {
        RecordStore store = null;
        try {
            store = RecordStore.openRecordStore((String)PLAYER_RECORD_STORE_NAME, (boolean)true);
            byte[][] data = new byte[][]{new byte[256]};
            int size = player.writeBytes(data, 0, false);
            if (player.recordId == -1) {
                player.recordId = store.addRecord(data[0], 0, size);
            } else if (player.recordId >= 0 && !player.deleted) {
                store.setRecord(player.recordId, data[0], 0, size);
            }
        }
        catch (Exception exception) {
        }
        finally {
            GameController.closeStore(store);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void savePlayers(Vector players) {
        RecordStore store = null;
        try {
            store = RecordStore.openRecordStore((String)PLAYER_RECORD_STORE_NAME, (boolean)true);
            byte[][] data = new byte[][]{new byte[256]};
            for (int i = 0; i < players.size(); ++i) {
                Player player = (Player)players.elementAt(i);
                int size = player.writeBytes(data, 0, false);
                if (player.recordId == -1) {
                    player.recordId = store.addRecord(data[0], 0, size);
                    continue;
                }
                if (player.recordId < 0 || player.deleted) continue;
                store.setRecord(player.recordId, data[0], 0, size);
            }
        }
        catch (Exception exception) {
        }
        finally {
            GameController.closeStore(store);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deletePlayer(Player player) {
        RecordStore store = null;
        try {
            store = RecordStore.openRecordStore((String)PLAYER_RECORD_STORE_NAME, (boolean)true);
            if (player.recordId >= 0 && !player.deleted) {
                store.deleteRecord(player.recordId);
                player.deleted = true;
            }
        }
        catch (Exception exception) {
        }
        finally {
            GameController.closeStore(store);
        }
    }

    public static Vector getComputerPlayers() {
        Vector players = null;
        try {
            players = GameController.getPlayers(2, -1);
        }
        catch (Exception e) {
            players = new Vector();
        }
        if (players.isEmpty()) {
            GameController.addDefaultComputerPlayers(players);
        }
        return players;
    }

    public static Player getHumanPlayer() {
        Vector players = null;
        try {
            players = GameController.getPlayers(1, 1);
        }
        catch (Exception e) {
            players = new Vector();
        }
        return GameController.extractHumanPlayer(players);
    }

    private static Player extractHumanPlayer(Vector players) {
        for (int i = 0; i < players.size(); ++i) {
            Player p = (Player)players.elementAt(i);
            if (p.type != 1) continue;
            players.removeElementAt(i);
            return p;
        }
        Player player = new Player(1, "Ace", 1, 5, 1000L);
        GameController.savePlayer(player);
        return player;
    }

    private static void addDefaultComputerPlayers(Vector players) {
        for (int i = 0; i < 5; ++i) {
            players.addElement(new Player(i, NAME_POOL[i], 2, INTELLIGENCE_POOL[i], 1000L));
        }
        for (int j = players.size() - 5; j < players.size(); ++j) {
            ((Player)players.elementAt((int)j)).faceIndex = FACE_POOL[j - players.size() + 5];
        }
        GameController.savePlayers(players);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getPlayers(int type, int maxNumber) {
        Vector<Player> result = new Vector<Player>(16);
        RecordStore store = null;
        try {
            store = RecordStore.openRecordStore((String)PLAYER_RECORD_STORE_NAME, (boolean)true);
            if (store.getNumRecords() > 0) {
                int number = 0;
                RecordEnumeration e = store.enumerateRecords(null, null, true);
                while (e.hasNextElement() && (maxNumber <= 0 || number < maxNumber)) {
                    Player player = new Player();
                    player.recordId = e.nextRecordId();
                    player.readBytes(store.getRecord(player.recordId), 0, false);
                    if (type > 0 && player.type != type) continue;
                    boolean added = false;
                    int i = 0;
                    while (!added) {
                        if (i >= result.size() || player.sortOrder < ((Player)result.elementAt((int)i)).sortOrder) {
                            result.insertElementAt(player, i);
                            added = true;
                        }
                        ++i;
                    }
                    ++number;
                }
            }
        }
        catch (Exception e) {
        }
        finally {
            GameController.closeStore(store);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initSettings() {
        RecordStore recordStore = null;
        try {
            RecordEnumeration recordEnumeration;
            recordStore = RecordStore.openRecordStore((String)SETTINGS_RECORD_STORE_NAME, (boolean)false);
            if (recordStore.getNumRecords() > 0 && (recordEnumeration = recordStore.enumerateRecords(null, null, true)).hasNextElement()) {
                settingsRecordId = recordEnumeration.nextRecordId();
                int offset = 0;
                byte[] data = recordStore.getRecord(settingsRecordId);
                int version = GameController.readInt(data, offset);
                blindsTypeSetting = (byte)GameController.readInt(data, offset += 4);
                startingSmallBlindSetting = GameController.readInt(data, offset += 4);
                blindIncreaseSecondsSetting = GameController.readInt(data, offset += 4);
                blindIncreaseRoundsSetting = (short)GameController.readInt(data, offset += 4);
                gameSpeedSetting = GameController.readInt(data, offset += 4);
                offset += 4;
                if (gameSpeedSetting != 4 && gameSpeedSetting != 10 && gameSpeedSetting != 16 && gameSpeedSetting != 26) {
                    gameSpeedSetting = 16;
                }
                int booleans = GameController.readInt(data, offset);
                offset += 4;
                soundOnSetting = (booleans & 1) != 0;
                autoPopupSetting = (booleans & 2) != 0;
                playerRespawnSetting = (booleans & 4) != 0;
                pauseForWinSetting = (booleans & 8) != 0;
                dealemButtonSetting = (booleans & 0x10) != 0;
                restrictedRaisingSetting = (booleans & 0x20) != 0;
                fastAfterHumanFoldSetting = (booleans & 0x80) != 0;
                otherPlayersDisplayedSetting = (booleans & 0x100) != 0;
                startingBlindsDisplayedSetting = (booleans & 0x200) != 0;
                demoGameCountSetting = GameController.readInt(data, offset);
                offset += 4;
            }
        }
        catch (Exception exception) {
        }
        finally {
            GameController.closeStore(recordStore);
        }
    }

    public static void respawnPlayer(Player player) {
        int nameIndex;
        Vector players = GameController.getComputerPlayers();
        int origNameIndex = nameIndex = Math.abs(RANDOM.nextInt()) % NAME_POOL.length;
        boolean firstTime = true;
        while (true) {
            String name = NAME_POOL[nameIndex];
            if (!firstTime && nameIndex == origNameIndex) {
                player.name = name;
                break;
            }
            boolean found = false;
            for (int i = 0; i < players.size() && !found; ++i) {
                if (!((Player)players.elementAt((int)i)).name.equals(name)) continue;
                found = true;
            }
            if (!found) {
                player.name = name;
                break;
            }
            firstTime = false;
            if (++nameIndex < NAME_POOL.length) continue;
            nameIndex = 0;
        }
        player.origHoldings = player.holdings = (long)((Math.abs(RANDOM.nextInt() % 5) + 1) * 1000);
        player.intelligence = INTELLIGENCE_POOL[nameIndex];
        player.faceIndex = FACE_POOL[nameIndex];
        player.allDone = false;
        player.mustPayLargeBlind = true;
        player.mustPaySmallBlind = false;
        player.inTheGame = true;
        GameController.savePlayer(player);
    }

    public static void resetPlayers(boolean includeHuman) {
        Vector players = GameController.getComputerPlayers();
        if (includeHuman) {
            players.addElement(GameController.getHumanPlayer());
        }
        for (int i = 0; i < players.size(); ++i) {
            Player p = (Player)players.elementAt(i);
            p.holdings = p.origHoldings;
        }
        GameController.savePlayers(players);
    }

    public static boolean canPlay() {
        if (demoGameCountSetting >= 26) {
            return false;
        }
        ++demoGameCountSetting;
        GameController.saveSettings();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void saveSettings() {
        byte[][] data = new byte[][]{new byte[64]};
        int offset = 0;
        offset += GameController.writeInt(SETTINGS_VERSION, data, offset);
        offset += GameController.writeInt(blindsTypeSetting, data, offset);
        offset += GameController.writeInt(startingSmallBlindSetting, data, offset);
        offset += GameController.writeInt(blindIncreaseSecondsSetting, data, offset);
        offset += GameController.writeInt(blindIncreaseRoundsSetting, data, offset);
        offset += GameController.writeInt(gameSpeedSetting, data, offset);
        int booleans = (soundOnSetting ? 1 : 0) + (autoPopupSetting ? 2 : 0) + (playerRespawnSetting ? 4 : 0) + (pauseForWinSetting ? 8 : 0) + (dealemButtonSetting ? 16 : 0) + (restrictedRaisingSetting ? 32 : 0) + 0 + (fastAfterHumanFoldSetting ? 128 : 0) + (otherPlayersDisplayedSetting ? 256 : 0) + (startingBlindsDisplayedSetting ? 512 : 0);
        offset += GameController.writeInt(booleans, data, offset);
        offset += GameController.writeInt(demoGameCountSetting, data, offset);
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)SETTINGS_RECORD_STORE_NAME, (boolean)true);
            if (settingsRecordId < 0) {
                settingsRecordId = recordStore.addRecord(data[0], 0, offset);
            } else {
                recordStore.setRecord(settingsRecordId, data[0], 0, offset);
            }
        }
        catch (Exception e) {
        }
        finally {
            GameController.closeStore(recordStore);
        }
    }

    private static void closeStore(RecordStore store) {
        if (store != null) {
            try {
                store.closeRecordStore();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static byte nextSplash() {
        if (screenStep != 3) {
            if ((screenStep = (byte)(screenStep + 1)) == 0) {
                return GameController.nextSplash();
            }
            if (screenStep == 1) {
                return GameController.nextSplash();
            }
        }
        return screenStep;
    }

    public static String toMoney(long amount) {
        String moneyFormat = "$&1";
        if (amount > 999999999999L) {
            amount = 999L;
            moneyFormat = "$&1B+";
        } else if (amount > 9999999999L) {
            amount /= 1000000000L;
            moneyFormat = "$&1B";
        } else if (amount > 9999999L) {
            amount /= 1000000L;
            moneyFormat = "$&1M";
        } else if (amount > 10000L) {
            amount /= 1000L;
            moneyFormat = "$&1K";
        }
        StringBuffer stringAmount = new StringBuffer(Long.toString(amount));
        int j = 1;
        int i = stringAmount.length() - 1;
        while (i >= 0) {
            if (j == 4) {
                stringAmount.insert(i + 1, ",");
                j = 1;
            }
            --i;
            ++j;
        }
        return GameController.replace(moneyFormat, stringAmount.toString(), null);
    }

    public static String toBlindsString(int smallBlind) {
        return GameController.replace("$&1-&2", Integer.toString(smallBlind), Integer.toString(smallBlind * 2));
    }

    public static synchronized Image getImage(String name) {
        try {
            return Image.createImage((String)name);
        }
        catch (IOException e) {
            System.err.println("Error getting image " + name);
            return null;
        }
    }

    public static final boolean isWithinRect(int x, int y, int rectX, int rectY, int rectWidth, int rectHeight) {
        return x >= rectX && y >= rectY && x < rectX + rectWidth && y < rectY + rectHeight;
    }

    public static final boolean isWithinRect(int x, int y, short[] rect) {
        return x >= rect[0] && y >= rect[1] && x < rect[0] + rect[2] && y < rect[1] + rect[3];
    }

    public static String replace(String text, String parm1, String parm2) {
        int nextIndex;
        text = text.trim();
        StringBuffer result = new StringBuffer(text.length() + 30);
        int index = 0;
        while (index >= 0 && index < text.length() - 1 && (nextIndex = text.indexOf(38, index)) >= 0 && nextIndex < text.length() - 1) {
            char c;
            if (nextIndex != index) {
                result.append(text.substring(index, nextIndex));
            }
            if ((c = text.charAt(nextIndex + 1)) == '1' && parm1 != null) {
                result.append(parm1);
            } else if (c == '2' && parm2 != null) {
                result.append(parm2);
            } else {
                result.append(text.substring(nextIndex, nextIndex + 2));
            }
            index = nextIndex + 2;
        }
        if (index < text.length()) {
            result.append(text.substring(index));
        }
        return result.toString();
    }

    public static Player getPlayer(int recordId, Vector players) {
        if (players != null) {
            for (int i = 0; i < players.size(); ++i) {
                Player p = (Player)players.elementAt(i);
                if (p.recordId != recordId) continue;
                return p;
            }
        }
        return null;
    }

    public static int readInt(byte[] data, int offset) {
        int ch1 = data[offset++] & 0xFF;
        int ch2 = data[offset++] & 0xFF;
        int ch3 = data[offset++] & 0xFF;
        int ch4 = data[offset++] & 0xFF;
        return ch1 << 24 | ch2 << 16 | ch3 << 8 | ch4 << 0;
    }

    public static long readLong(byte[] data, int offset) {
        long ch1 = data[offset++] & 0xFF;
        long ch2 = data[offset++] & 0xFF;
        long ch3 = data[offset++] & 0xFF;
        long ch4 = data[offset++] & 0xFF;
        long ch5 = data[offset++] & 0xFF;
        long ch6 = data[offset++] & 0xFF;
        long ch7 = data[offset++] & 0xFF;
        long ch8 = data[offset++] & 0xFF;
        long value = ch1 << 56 | ch2 << 48 | ch3 << 40 | ch4 << 32 | ch5 << 24 | ch6 << 16 | ch7 << 8 | ch8 << 0;
        return value;
    }

    public static int stringLength(byte[] data, int offset) {
        return GameController.readInt(data, offset) + 4;
    }

    public static String readString(byte[] data, int offset) {
        int length = GameController.readInt(data, offset);
        return new String(data, offset += 4, length);
    }

    public static int writeInt(int i, byte[][] data, int offset) {
        GameController.checkSize(data, offset, 4);
        data[0][offset++] = (byte)(i >>> 24 & 0xFF);
        data[0][offset++] = (byte)(i >>> 16 & 0xFF);
        data[0][offset++] = (byte)(i >>> 8 & 0xFF);
        data[0][offset] = (byte)(i >>> 0 & 0xFF);
        return 4;
    }

    public static int writeLong(long i, byte[][] data, int offset) {
        GameController.checkSize(data, offset, 8);
        data[0][offset++] = (byte)((int)(i >>> 56) & 0xFF);
        data[0][offset++] = (byte)((int)(i >>> 48) & 0xFF);
        data[0][offset++] = (byte)((int)(i >>> 40) & 0xFF);
        data[0][offset++] = (byte)((int)(i >>> 32) & 0xFF);
        data[0][offset++] = (byte)((int)(i >>> 24) & 0xFF);
        data[0][offset++] = (byte)((int)(i >>> 16) & 0xFF);
        data[0][offset++] = (byte)((int)(i >>> 8) & 0xFF);
        data[0][offset++] = (byte)((int)(i >>> 0) & 0xFF);
        return 8;
    }

    public static int writeString(String s, byte[][] data, int offset) {
        byte[] temp = null;
        temp = s.getBytes();
        offset += GameController.writeInt(temp.length, data, offset);
        GameController.checkSize(data, offset, temp.length);
        for (int i = 0; i < temp.length; ++i) {
            data[0][offset++] = temp[i];
        }
        return temp.length + 4;
    }

    private static void checkSize(byte[][] data, int offset, int bytes) {
        if (data[0].length < offset + bytes) {
            byte[] newData = new byte[(offset + bytes) * 2];
            if (offset > 0) {
                System.arraycopy(data[0], 0, newData, 0, offset);
            }
            data[0] = newData;
        }
    }

    private static int parseInt(String str, int defaultValue) {
        if (str != null) {
            try {
                return Integer.parseInt(str);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                return defaultValue;
            }
        }
        return defaultValue;
    }

    static {
        instance = new GameController();
        smallBlindSchedule = new short[]{5, 10, 15, 25, 50, 75, 100, 150, 200, 300, 400, 600, 1000, 1500, 2000, 3000};
        SETTINGS_VERSION = 1;
        blindsTypeSetting = 1;
        startingSmallBlindSetting = 5;
        blindIncreaseSecondsSetting = 120;
        blindIncreaseRoundsSetting = (short)2;
        gameSpeedSetting = 16;
        soundOnSetting = true;
        pauseForWinSetting = true;
        restrictedRaisingSetting = true;
        fastAfterHumanFoldSetting = true;
        screenStep = (byte)-1;
        settingsRecordId = -1;
    }
}

