/*
 * Decompiled with CFR 0.152.
 */
package com.concretesoftware.holdem;

import com.concretesoftware.holdem.Card;
import com.concretesoftware.holdem.ChipPile;
import com.concretesoftware.holdem.GameController;
import com.concretesoftware.holdem.HoldemCanvasHelper;
import com.concretesoftware.holdem.Player;
import com.concretesoftware.holdem.Sprite;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class HoldemCanvas
extends Canvas {
    public static final byte NO_ACTION = 0;
    public static final byte CLICK = -100;
    public static final byte SHORTCUT_KEY = -101;
    public static final byte CLEAR_KEY = -8;
    public static final byte LEFT_SOFT = -6;
    public static final byte RIGHT_SOFT = -7;
    private HoldemCanvasHelper helper;
    private static GameController controller;
    public static Sprite playerController;
    public static Image[] faceImages;
    public static Image facesImage;

    public HoldemCanvas(byte screenType) {
        this.setFullScreenMode(true);
        this.helper = new HoldemCanvasHelper(this, screenType);
        if (this.helper.setupSplashScreen(14)) {
            return;
        }
        controller = GameController.instance;
        this.helper.setupBasicSpritesAndImages(!this.isDoubleBuffered());
        HoldemCanvasHelper.actionsButton = this.helper.createButton(0, 0, 145, 55, 91, 47, 15, true);
        HoldemCanvasHelper.okButton = this.helper.createButton(0, 0, 145, 55, 136, 47, 15, true);
        HoldemCanvasHelper.selectButton = this.helper.createButton(0, 0, 145, 55, 121, 47, 15, true);
        HoldemCanvasHelper.continueButton = this.helper.createButton(1, 0, 145, 55, 151, 47, 15, false);
        HoldemCanvasHelper.backButton = this.helper.createButton(0, 81, 145, 55, 106, 47, 15, false);
        this.helper.incrementProgress();
        Font textFont = Font.getFont((int)64, (int)1, (int)8);
        this.helper.createTextHeading("Pot", 19, 125, textFont, 0);
        this.helper.createTextHeading("Bet", 107, 125, textFont, 0);
        ChipPile otherChips = null;
        otherChips = new ChipPile(0, 30, 25, 9, 10, 3, 1, 4, true, GameController.getImage("/images/small_chips.png"), new short[]{5000, 1000, 500, 100, 50, 20, 10, 5, 1});
        this.helper.incrementProgress();
        playerController = this.helper.createPlayerController(3, otherChips, 0);
        this.helper.createGameMessage(64, 63, this.getWidth() - 16, null);
        this.helper.createBlindsSprite(64, 110, Font.getFont((int)64, (int)0, (int)8));
        this.helper.createCommunityHand(33, 68, 13, 1);
        Font middleFont = Font.getFont((int)64, (int)0, (int)0);
        Object middleChips = null;
        Object middleChipAmounts = null;
        Sprite potChips = null;
        this.helper.incrementProgress();
        this.helper.createPotSprites(19, 138, middleFont, potChips);
        Sprite humanChips = null;
        this.helper.createHumanSprites(humanChips, middleFont, Font.getFont((int)64, (int)0, (int)8), 0);
        this.helper.createActionsMenu(true, Font.getFont((int)64, (int)0, (int)8));
        this.helper.incrementProgress();
        Image allInMenuImage = GameController.getImage("/images/allin_menu.png");
        this.helper.createAllInAndFoldMenus(true, allInMenuImage);
        this.helper.createContinueMenu(true);
        this.helper.incrementProgress();
        this.helper.createAmountEntry(false);
        this.helper.createCongrats(true);
        Card.cardsImage = GameController.getImage("/images/cards.png");
        Card.styleCoords = new short[][]{{80, 0, 0, 0, 0, 12, 25, 5, 8, 3, 4, 1, 24, 0, 25, 10, 1}, {80, 0, 0, 0, 0, 12, 25, 5, 8, 3, 4, 1, 24, 0, 25, 10, 1}};
        Card.numberFonts = new Font[]{Font.getFont((int)64, (int)0, (int)8), Font.getFont((int)64, (int)0, (int)8)};
        this.helper.incrementProgress();
        this.helper.loadNokiaAPISounds();
        this.helper.incrementProgress();
    }

    public final boolean init(boolean startNewGame) {
        if (!controller.init(startNewGame)) {
            return false;
        }
        this.helper.loadSecondaryImages();
        this.helper.initMenusAndAction();
        this.helper.setMenuButtonsActive(false, false);
        this.updateBlinds();
        this.helper.initForNewGame(startNewGame);
        return true;
    }

    protected void paint(Graphics g) {
        try {
            g.setClip(0, 0, this.getWidth(), this.getHeight());
            if (this.helper.screenType == 2) {
                this.helper.paintSplashScreen(g);
            } else {
                this.helper.paintSprites(g, false, 0);
            }
        }
        catch (Throwable e) {
            System.err.println("Paint exception");
            e.printStackTrace();
        }
    }

    public void addSprite(Sprite sprite) {
        this.helper.addSprite(sprite);
    }

    public void incrementProgress() {
        this.helper.incrementProgress();
    }

    protected void showNotify() {
        this.helper.showNotify(false);
    }

    protected void hideNotify() {
        this.helper.hideNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void keyPressed(int keyCode) {
        if (this.helper.screenType != 3) {
            return;
        }
        boolean needsRepaint = false;
        HoldemCanvas holdemCanvas = this;
        synchronized (holdemCanvas) {
            this.helper.readStandardAction(keyCode);
            if (HoldemCanvasHelper.action != 0) {
                this.updateForUserInput();
                needsRepaint = HoldemCanvasHelper.repaintRequired;
            }
        }
        if (needsRepaint) {
            this.repaint();
        }
    }

    protected void keyReleased(int keyCode) {
        if (this.helper.screenType != 3) {
            return;
        }
        this.helper.resetAction(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean update() {
        if (this.updateForUserInput()) {
            return this.helper.animateOtherPlayers();
        }
        if (HoldemCanvasHelper.congratsPlayer != null) {
            return this.helper.displayCongratsScreen();
        }
        if (this.helper.checkForMessageOrScrollDelay()) {
            return this.helper.animateOtherPlayers();
        }
        this.helper.animateOtherPlayers();
        if (controller.update()) return true;
        if (!HoldemCanvasHelper.repaintRequired) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean updateForUserInput() {
        block73: {
            block72: {
                block71: {
                    block70: {
                        block69: {
                            block68: {
                                block67: {
                                    block66: {
                                        block65: {
                                            block64: {
                                                block63: {
                                                    block62: {
                                                        block60: {
                                                            block61: {
                                                                block57: {
                                                                    block59: {
                                                                        block58: {
                                                                            HoldemCanvasHelper.repaintRequired = false;
                                                                            try {
                                                                                this.helper.checkForLastBetsExpired();
                                                                                if (HoldemCanvasHelper.action != -6) break block57;
                                                                                if (!this.helper.amountEntryChooseOK()) break block58;
                                                                                var1_1 = true;
                                                                            }
                                                                            catch (Throwable var2_19) {
                                                                                if (HoldemCanvasHelper.action == -6) ** GOTO lbl-1000
                                                                                if (HoldemCanvasHelper.action == -7) ** GOTO lbl-1000
                                                                                if (HoldemCanvasHelper.action == -101) ** GOTO lbl-1000
                                                                                if (HoldemCanvasHelper.clearAction) ** GOTO lbl-1000
                                                                                if (HoldemCanvasHelper.action == -8) lbl-1000:
                                                                                // 5 sources

                                                                                {
                                                                                    v0 = true;
                                                                                } else {
                                                                                    v0 = false;
                                                                                }
                                                                                this.helper.resetAction(v0);
                                                                                throw var2_19;
                                                                            }
                                                                            if (HoldemCanvasHelper.action == -6) ** GOTO lbl-1000
                                                                            if (HoldemCanvasHelper.action == -7) ** GOTO lbl-1000
                                                                            if (HoldemCanvasHelper.action == -101) ** GOTO lbl-1000
                                                                            if (HoldemCanvasHelper.clearAction) ** GOTO lbl-1000
                                                                            if (HoldemCanvasHelper.action == -8) lbl-1000:
                                                                            // 5 sources

                                                                            {
                                                                                v1 = true;
                                                                            } else {
                                                                                v1 = false;
                                                                            }
                                                                            this.helper.resetAction(v1);
                                                                            return var1_1;
                                                                        }
                                                                        if (!HoldemCanvasHelper.continueButton.visible) break block59;
                                                                        this.helper.continueAction();
                                                                        var1_2 = false;
                                                                        if (HoldemCanvasHelper.action == -6) ** GOTO lbl-1000
                                                                        if (HoldemCanvasHelper.action == -7) ** GOTO lbl-1000
                                                                        if (HoldemCanvasHelper.action == -101) ** GOTO lbl-1000
                                                                        if (HoldemCanvasHelper.clearAction) ** GOTO lbl-1000
                                                                        if (HoldemCanvasHelper.action == -8) lbl-1000:
                                                                        // 5 sources

                                                                        {
                                                                            v2 = true;
                                                                        } else {
                                                                            v2 = false;
                                                                        }
                                                                        this.helper.resetAction(v2);
                                                                        return var1_2;
                                                                    }
                                                                    if (!this.helper.displayActionsMenu()) break block60;
                                                                    var1_3 = true;
                                                                    if (HoldemCanvasHelper.action == -6) ** GOTO lbl-1000
                                                                    if (HoldemCanvasHelper.action == -7) ** GOTO lbl-1000
                                                                    if (HoldemCanvasHelper.action == -101) ** GOTO lbl-1000
                                                                    if (HoldemCanvasHelper.clearAction) ** GOTO lbl-1000
                                                                    if (HoldemCanvasHelper.action == -8) lbl-1000:
                                                                    // 5 sources

                                                                    {
                                                                        v3 = true;
                                                                    } else {
                                                                        v3 = false;
                                                                    }
                                                                    this.helper.resetAction(v3);
                                                                    return var1_3;
                                                                }
                                                                if (HoldemCanvasHelper.action != -7) break block60;
                                                                if (!this.helper.hideMenus()) break block61;
                                                                var1_4 = true;
                                                                if (HoldemCanvasHelper.action == -6) ** GOTO lbl-1000
                                                                if (HoldemCanvasHelper.action == -7) ** GOTO lbl-1000
                                                                if (HoldemCanvasHelper.action == -101) ** GOTO lbl-1000
                                                                if (HoldemCanvasHelper.clearAction) ** GOTO lbl-1000
                                                                if (HoldemCanvasHelper.action == -8) lbl-1000:
                                                                // 5 sources

                                                                {
                                                                    v4 = true;
                                                                } else {
                                                                    v4 = false;
                                                                }
                                                                this.helper.resetAction(v4);
                                                                return var1_4;
                                                            }
                                                            HoldemCanvas.controller.pause();
                                                            var1_5 = true;
                                                            if (HoldemCanvasHelper.action == -6) ** GOTO lbl-1000
                                                            if (HoldemCanvasHelper.action == -7) ** GOTO lbl-1000
                                                            if (HoldemCanvasHelper.action == -101) ** GOTO lbl-1000
                                                            if (HoldemCanvasHelper.clearAction) ** GOTO lbl-1000
                                                            if (HoldemCanvasHelper.action == -8) lbl-1000:
                                                            // 5 sources

                                                            {
                                                                v5 = true;
                                                            } else {
                                                                v5 = false;
                                                            }
                                                            this.helper.resetAction(v5);
                                                            return var1_5;
                                                        }
                                                        if (!this.helper.checkMenu(HoldemCanvasHelper.congratsMenu)) break block62;
                                                        var1_6 = true;
                                                        if (HoldemCanvasHelper.action == -6) ** GOTO lbl-1000
                                                        if (HoldemCanvasHelper.action == -7) ** GOTO lbl-1000
                                                        if (HoldemCanvasHelper.action == -101) ** GOTO lbl-1000
                                                        if (HoldemCanvasHelper.clearAction) ** GOTO lbl-1000
                                                        if (HoldemCanvasHelper.action == -8) lbl-1000:
                                                        // 5 sources

                                                        {
                                                            v6 = true;
                                                        } else {
                                                            v6 = false;
                                                        }
                                                        this.helper.resetAction(v6);
                                                        return var1_6;
                                                    }
                                                    if (!this.helper.checkMenu(HoldemCanvasHelper.actionsMenu)) break block63;
                                                    var1_7 = true;
                                                    if (HoldemCanvasHelper.action == -6) ** GOTO lbl-1000
                                                    if (HoldemCanvasHelper.action == -7) ** GOTO lbl-1000
                                                    if (HoldemCanvasHelper.action == -101) ** GOTO lbl-1000
                                                    if (HoldemCanvasHelper.clearAction) ** GOTO lbl-1000
                                                    if (HoldemCanvasHelper.action == -8) lbl-1000:
                                                    // 5 sources

                                                    {
                                                        v7 = true;
                                                    } else {
                                                        v7 = false;
                                                    }
                                                    this.helper.resetAction(v7);
                                                    return var1_7;
                                                }
                                                if (!this.helper.checkAmountEntry()) break block64;
                                                var1_8 = true;
                                                if (HoldemCanvasHelper.action == -6) ** GOTO lbl-1000
                                                if (HoldemCanvasHelper.action == -7) ** GOTO lbl-1000
                                                if (HoldemCanvasHelper.action == -101) ** GOTO lbl-1000
                                                if (HoldemCanvasHelper.clearAction) ** GOTO lbl-1000
                                                if (HoldemCanvasHelper.action == -8) lbl-1000:
                                                // 5 sources

                                                {
                                                    v8 = true;
                                                } else {
                                                    v8 = false;
                                                }
                                                this.helper.resetAction(v8);
                                                return var1_8;
                                            }
                                            if (!this.helper.checkMenu(HoldemCanvasHelper.allInMenu)) break block65;
                                            var1_9 = true;
                                            if (HoldemCanvasHelper.action == -6) ** GOTO lbl-1000
                                            if (HoldemCanvasHelper.action == -7) ** GOTO lbl-1000
                                            if (HoldemCanvasHelper.action == -101) ** GOTO lbl-1000
                                            if (HoldemCanvasHelper.clearAction) ** GOTO lbl-1000
                                            if (HoldemCanvasHelper.action == -8) lbl-1000:
                                            // 5 sources

                                            {
                                                v9 = true;
                                            } else {
                                                v9 = false;
                                            }
                                            this.helper.resetAction(v9);
                                            return var1_9;
                                        }
                                        if (!this.helper.checkMenu(HoldemCanvasHelper.foldMenu)) break block66;
                                        var1_10 = true;
                                        if (HoldemCanvasHelper.action == -6) ** GOTO lbl-1000
                                        if (HoldemCanvasHelper.action == -7) ** GOTO lbl-1000
                                        if (HoldemCanvasHelper.action == -101) ** GOTO lbl-1000
                                        if (HoldemCanvasHelper.clearAction) ** GOTO lbl-1000
                                        if (HoldemCanvasHelper.action == -8) lbl-1000:
                                        // 5 sources

                                        {
                                            v10 = true;
                                        } else {
                                            v10 = false;
                                        }
                                        this.helper.resetAction(v10);
                                        return var1_10;
                                    }
                                    if (!this.helper.checkMenu(HoldemCanvasHelper.continueMenu)) break block67;
                                    var1_11 = true;
                                    if (HoldemCanvasHelper.action == -6) ** GOTO lbl-1000
                                    if (HoldemCanvasHelper.action == -7) ** GOTO lbl-1000
                                    if (HoldemCanvasHelper.action == -101) ** GOTO lbl-1000
                                    if (HoldemCanvasHelper.clearAction) ** GOTO lbl-1000
                                    if (HoldemCanvasHelper.action == -8) lbl-1000:
                                    // 5 sources

                                    {
                                        v11 = true;
                                    } else {
                                        v11 = false;
                                    }
                                    this.helper.resetAction(v11);
                                    return var1_11;
                                }
                                if (!this.helper.checkForShortcut()) break block68;
                                var1_12 = true;
                                if (HoldemCanvasHelper.action == -6) ** GOTO lbl-1000
                                if (HoldemCanvasHelper.action == -7) ** GOTO lbl-1000
                                if (HoldemCanvasHelper.action == -101) ** GOTO lbl-1000
                                if (HoldemCanvasHelper.clearAction) ** GOTO lbl-1000
                                if (HoldemCanvasHelper.action == -8) lbl-1000:
                                // 5 sources

                                {
                                    v12 = true;
                                } else {
                                    v12 = false;
                                }
                                this.helper.resetAction(v12);
                                return var1_12;
                            }
                            if (!this.helper.checkForScrollingClickDelay()) break block69;
                            var1_13 = true;
                            if (HoldemCanvasHelper.action == -6) ** GOTO lbl-1000
                            if (HoldemCanvasHelper.action == -7) ** GOTO lbl-1000
                            if (HoldemCanvasHelper.action == -101) ** GOTO lbl-1000
                            if (HoldemCanvasHelper.clearAction) ** GOTO lbl-1000
                            if (HoldemCanvasHelper.action == -8) lbl-1000:
                            // 5 sources

                            {
                                v13 = true;
                            } else {
                                v13 = false;
                            }
                            this.helper.resetAction(v13);
                            return var1_13;
                        }
                        if (HoldemCanvasHelper.action != 2) break block70;
                        var1_14 = this.helper.scroll(true);
                        if (HoldemCanvasHelper.action == -6) ** GOTO lbl-1000
                        if (HoldemCanvasHelper.action == -7) ** GOTO lbl-1000
                        if (HoldemCanvasHelper.action == -101) ** GOTO lbl-1000
                        if (HoldemCanvasHelper.clearAction) ** GOTO lbl-1000
                        if (HoldemCanvasHelper.action == -8) lbl-1000:
                        // 5 sources

                        {
                            v14 = true;
                        } else {
                            v14 = false;
                        }
                        this.helper.resetAction(v14);
                        return var1_14;
                    }
                    if (HoldemCanvasHelper.action != 5) break block71;
                    var1_15 = this.helper.scroll(false);
                    if (HoldemCanvasHelper.action == -6) ** GOTO lbl-1000
                    if (HoldemCanvasHelper.action == -7) ** GOTO lbl-1000
                    if (HoldemCanvasHelper.action == -101) ** GOTO lbl-1000
                    if (HoldemCanvasHelper.clearAction) ** GOTO lbl-1000
                    if (HoldemCanvasHelper.action == -8) lbl-1000:
                    // 5 sources

                    {
                        v15 = true;
                    } else {
                        v15 = false;
                    }
                    this.helper.resetAction(v15);
                    return var1_15;
                }
                if (HoldemCanvasHelper.action != 8) break block72;
                var1_16 = this.helper.displayAllLastBets();
                if (HoldemCanvasHelper.action == -6) ** GOTO lbl-1000
                if (HoldemCanvasHelper.action == -7) ** GOTO lbl-1000
                if (HoldemCanvasHelper.action == -101) ** GOTO lbl-1000
                if (HoldemCanvasHelper.clearAction) ** GOTO lbl-1000
                if (HoldemCanvasHelper.action == -8) lbl-1000:
                // 5 sources

                {
                    v16 = true;
                } else {
                    v16 = false;
                }
                this.helper.resetAction(v16);
                return var1_16;
            }
            if (!this.helper.checkForContinueButtonPause()) break block73;
            var1_17 = true;
            if (HoldemCanvasHelper.action == -6) ** GOTO lbl-1000
            if (HoldemCanvasHelper.action == -7) ** GOTO lbl-1000
            if (HoldemCanvasHelper.action == -101) ** GOTO lbl-1000
            if (HoldemCanvasHelper.clearAction) ** GOTO lbl-1000
            if (HoldemCanvasHelper.action == -8) lbl-1000:
            // 5 sources

            {
                v17 = true;
            } else {
                v17 = false;
            }
            this.helper.resetAction(v17);
            return var1_17;
        }
        var1_18 = false;
        if (HoldemCanvasHelper.action == -6) ** GOTO lbl-1000
        if (HoldemCanvasHelper.action == -7) ** GOTO lbl-1000
        if (HoldemCanvasHelper.action == -101) ** GOTO lbl-1000
        if (HoldemCanvasHelper.clearAction) ** GOTO lbl-1000
        if (HoldemCanvasHelper.action == -8) lbl-1000:
        // 5 sources

        {
            v18 = true;
        } else {
            v18 = false;
        }
        this.helper.resetAction(v18);
        return var1_18;
    }

    public final void yourTurn() {
        this.helper.yourTurn();
    }

    public final void displayCongrats(Player player) {
        HoldemCanvasHelper.congratsPlayer = player;
    }

    public final void showActions() {
        this.helper.showActions();
    }

    public void updateBlinds() {
        HoldemCanvasHelper.blinds.setMessage(GameController.replace("Blinds: &1", GameController.toBlindsString(HoldemCanvas.controller.smallBlind), null), -1);
    }

    public final boolean menuChoice(Sprite menu, long itemId) {
        if (this.helper.actionsMenuChoice(menu, itemId)) {
            return true;
        }
        if (this.helper.allInMenuChoice(menu, itemId)) {
            return true;
        }
        if (this.helper.foldMenuChoice(menu, itemId)) {
            return true;
        }
        if (this.helper.continueMenuChoice(menu, itemId)) {
            return true;
        }
        if (this.helper.congratsMenuChoice(menu, itemId)) {
            return itemId != 1L;
        }
        return true;
    }

    public final void amountEntered(long amount, boolean isRaise) {
        this.helper.amountEntered(amount, isRaise);
    }

    public final void setMessage(String msg) {
        HoldemCanvasHelper.message.setMessage(msg, 5 * GameController.instance.gameSpeed);
    }

    public final void setShortMessage(String msg) {
        HoldemCanvasHelper.message.setMessage(msg, 4 * GameController.instance.gameSpeed);
    }

    public final void setLongMessage(String msg) {
        HoldemCanvasHelper.message.setMessage(msg, 10 * GameController.instance.gameSpeed);
    }

    public final void pauseForWin() {
        this.helper.pauseForWin();
    }

    public void loadFaceImages() {
        this.helper.loadFaceImages();
    }

    public void playSound(byte soundId) {
        if (!GameController.soundOnSetting) {
            return;
        }
        switch (soundId) {
            case 1: 
            case 8: {
                this.helper.playNokiaAPISound(soundId);
                break;
            }
            default: {
                this.helper.playAlertSound(soundId);
            }
        }
    }
}

