/*
 * Decompiled with CFR 0.152.
 */
package com.concretesoftware.holdem;

import com.concretesoftware.holdem.GameController;
import com.concretesoftware.holdem.Holdem;
import com.concretesoftware.holdem.HoldemCanvas;
import com.concretesoftware.holdem.Player;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.Screen;
import javax.microedition.lcdui.TextField;
import javax.microedition.lcdui.Ticker;

public final class InfoScreen
implements CommandListener {
    public static final byte BLINDS_TYPE_SCREEN = 1;
    public static final byte STARTING_BLINDS_SCREEN = 2;
    public static final byte BLINDS_TIME_LIMIT_SCREEN = 3;
    public static final byte BLINDS_ROUNDS_SCREEN = 4;
    public static final byte OTHER_PLAYERS_SCREEN = 5;
    public static final byte MAIN_MENU_SCREEN = 6;
    public static final byte STATISTICS_LIST_SCREEN = 7;
    public static final byte INSTRUCTIONS_MENU_SCREEN = 8;
    public static final byte INSTRUCTIONS_SCREEN = 10;
    public static final byte ABOUT_SCREEN = 11;
    public static final byte EDIT_PLAYER_SCREEN = 12;
    public static final byte GAME_SETTINGS_SCREEN = 13;
    public static final byte BLINDS_INFO_SCREEN = 15;
    public static final byte PRE_SCREEN = 16;
    public static final byte GAME_STATISTICS_SCREEN = 17;
    public static final byte OVERALL_STATISTICS_SCREEN = 18;
    public static final byte TOURNAMENT_STATISTICS_SCREEN = 19;
    public static final byte SET_ALL_MONEY_SCREEN = 20;
    public static final byte OMAHA_AD_SCREEN = 30;
    private static final Command ADD = new Command("Add", 1, 1);
    private static final Command EDIT = new Command("Edit", 1, 2);
    public static final Command MOVE_UP = new Command("Move Up", 1, 4);
    public static final Command MOVE_DOWN = new Command("Move Down", 1, 5);
    public static final Command DELETE = new Command("Delete", 1, 6);
    public static final Command OPTIONS = new Command("Options", 1, 8);
    private static final Command RESET_ALL_MONEY = new Command("Reset All Money", 1, 7);
    private static final Command RESET_MONEY = new Command("Reset $", 1, 2);
    private static final Command RESET = new Command("Reset", 1, 2);
    public static final Command BACK = new Command("Back", 2, 1);
    public static final Command SELECT = new Command("Select", 4, 1);
    public static final Command EXIT = new Command("Exit", 7, 1);
    public static final Command OK = new Command("OK", 4, 1);
    public static final Command CANCEL = new Command("Cancel", 2, 1);
    private static final Command BLANK = new Command("", 1, 1);
    public static final Command NEXT = new Command("Next", 1, 1);
    private static final short[] SMALL_BLINDS = new short[]{5, 10, 15, 25, 50, 75, 100, 150, 200, 300, 400, 600, 1000};
    private static final short[] BLINDS_TIME_LIMIT_MINUTES = new short[]{1, 2, 5, 10, 15, 20, 30, 60, 90, 120};
    private static final short[] BLINDS_ROUNDS = new short[]{1, 2, 3, 4, 5, 10};
    private static final String[] YES_NO_SETTINGS = new String[]{"Yes", "No"};
    public static Vector players;
    public byte screenType;
    private static Image continueImage;
    private static Image newGameImage;
    private static Image currentPlayerImage;
    private static Image otherPlayersImage;
    private static Image blindsImage;
    private static Image gameImage;
    private static Image statisticsImage;
    private static Image setAllMoneyImage;
    private static Image instructionsImage;
    private static Image aboutImage;
    private static Player player;
    private static Player humanPlayer;
    private static int continueItem;
    private static int newGame;
    private static int currentPlayer;
    private static int otherPlayers;
    private static int blinds;
    private static int gameSettings;
    private static int statistics;
    private static int setAllMoney;
    private static int instructions;
    private static int about;
    private static List optionsScreen;
    private static int resetIndex;
    private static int moveUpIndex;
    private static int moveDownIndex;
    private static int deleteIndex;
    private static byte blindsType;
    private static int numberOfSecondsOrRounds;
    public List list;
    public Form form;
    public Screen screen;
    private Displayable previousScreen;
    public Displayable nextScreen;
    public String message;
    private static TextField name;
    private static TextField money;
    private static ChoiceGroup face;
    private static ChoiceGroup intelligence;
    private static String[] faceStringElements;
    private static ChoiceGroup gameSpeed;
    private static ChoiceGroup settings;
    private static Vector settingsList;
    private boolean ignoreCommands;
    private boolean runSelectCommand;
    private static TextField allMoney;
    private static final byte LAST_INSTRUCTIONS_NUMBER = 5;
    public byte instructionsNumber;
    private static String[] FACE_NAMES;

    public InfoScreen(byte screenType) {
        this.screenType = screenType;
        if (screenType >= 10) {
            this.form = new Form(null);
            this.screen = this.form;
            if (screenType != 20) {
                this.screen.addCommand(BACK);
            }
        } else {
            this.list = new List("", 3);
            this.screen = this.list;
        }
        this.screen.setCommandListener((CommandListener)this);
        if (screenType == 1 || screenType == 2 || screenType == 3 || screenType == 4) {
            if (screenType == 1) {
                this.screen.setTitle("Blinds");
                this.list.append("Stay the Same", null);
                this.list.append("Inc. by timer", null);
                this.list.append("Inc. by rounds", null);
            } else if (screenType == 3) {
                this.screen.setTitle("Time Limit");
            } else if (screenType == 4) {
                this.screen.setTitle("Rounds");
            }
            this.screen.addCommand(BACK);
        } else if (screenType == 5) {
            this.screen.setTitle("Other Players");
            this.screen.setTicker(new Ticker("Some player changes will not take effect until you start a new game."));
            this.screen.addCommand(BACK);
            this.screen.addCommand(EDIT);
            this.screen.addCommand(MOVE_UP);
            this.screen.addCommand(MOVE_DOWN);
            this.screen.addCommand(DELETE);
            this.screen.addCommand(RESET_ALL_MONEY);
        } else if (screenType == 6) {
            if (newGameImage == null) {
                continueImage = GameController.getImage("/images/continue.png");
                newGameImage = GameController.getImage("/images/new_game.png");
                currentPlayerImage = GameController.getImage("/images/player.png");
                otherPlayersImage = GameController.getImage("/images/players.png");
                blindsImage = GameController.getImage("/images/blinds.png");
                gameImage = GameController.getImage("/images/gameSettings.png");
                statisticsImage = GameController.getImage("/images/statistics.png");
                setAllMoneyImage = GameController.getImage("/images/set_all_money.png");
                instructionsImage = GameController.getImage("/images/instructions.png");
                aboutImage = GameController.getImage("/images/about.png");
            }
            this.screen.setTitle("Menu");
            this.screen.addCommand(EXIT);
        } else if (screenType == 10) {
            this.screen.setTitle("Help");
        } else if (screenType == 8) {
            this.screen.setTitle("Help");
            this.screen.addCommand(BACK);
            this.list.append("Overview", null);
            this.list.append("Rules", null);
            this.list.append("Controls", null);
            this.list.append("Main Menu Options", null);
            this.list.append("Game Settings", null);
            this.list.append("Contact", null);
        } else if (screenType == 11) {
            this.screen.setTitle("About");
            Image companyLogo = GameController.getImage("/images/logo.png");
            this.form.append("Aces Texas Hold'em - No Limit\n");
            this.form.append("Version 1.2.1\nDemo Version\n\nThis is the demo version of Aces Texas Hold'em - No Limit.  You can only play 25 hands.  Please purchase the full version at http://www.concretesoftware.com/\n\ncreated by\n");
            this.form.append(companyLogo);
            this.form.append("\nwww.concretesoftware.com\n");
        } else if (screenType == 13) {
            this.screen.setTitle("Settings");
            gameSpeed = new ChoiceGroup("Speed", 1, new String[]{"Fastest", "Fast", "Normal", "Slow"}, null);
            this.form.append((Item)gameSpeed);
            settings = new ChoiceGroup("", 2);
            settings.append("Sound On", null);
            settings.append("Auto-popup Actions", null);
            settings.append("Auto Sit In", null);
            settings.append("Pause at Game End", null);
            settings.append("Deal'em Button", null);
            settings.append("Raise to last bet", null);
            settings.append("Go fast after I fold", null);
            this.form.append((Item)settings);
        } else if (screenType == 7) {
            this.screen.setTitle("Stats");
            this.screen.addCommand(BACK);
            this.screen.addCommand(RESET);
            this.list.append("Game Statistics", null);
            this.list.append("Overall Statistics", null);
            this.list.append("Tourn. Statistics", null);
        } else if (screenType == 17 || screenType == 18 || screenType == 19) {
            this.screen.addCommand(BACK);
        } else if (screenType == 15) {
            this.screen.setTitle("Blinds");
            this.screen.addCommand(EDIT);
        } else if (screenType == 16) {
            this.screen.addCommand(OK);
        } else if (screenType == 20) {
            this.screen.setTitle("Set All Money");
            this.screen.addCommand(CANCEL);
            this.screen.addCommand(OK);
            allMoney = new TextField("Money", "", 6, 2);
            this.form.append((Item)allMoney);
        }
    }

    public void init(Player inpPlayer, int selectedIndex, int inpBlindsType, int inpNumberOfSecondsOrRounds) {
        byte blindsType;
        int i;
        this.ignoreCommands = false;
        if (this.list != null && this.screenType != 1 && this.screenType != 7) {
            for (i = this.list.size() - 1; i >= 0; --i) {
                this.list.delete(i);
            }
        }
        if (this.screenType == 2 || this.screenType == 3 || this.screenType == 4 || this.screenType == 17 || this.screenType == 18 || this.screenType == 19) {
            this.previousScreen = Holdem.display.getCurrent();
            InfoScreen.blindsType = (byte)inpBlindsType;
            numberOfSecondsOrRounds = inpNumberOfSecondsOrRounds;
        }
        if (this.screenType == 1) {
            this.list.setSelectedIndex((int)GameController.blindsTypeSetting, true);
        } else if (this.screenType == 2) {
            if (InfoScreen.blindsType == 0) {
                this.screen.setTitle("Blind Amounts");
                this.screen.setTicker((Ticker)null);
            } else {
                this.screen.setTitle("Starting Blinds");
                this.screen.setTicker(new Ticker("Starting blinds will not take effect until you start a new game."));
            }
            for (i = 0; i < SMALL_BLINDS.length; ++i) {
                this.list.append(GameController.toBlindsString(SMALL_BLINDS[i]), null);
            }
            int startingSmallBlind = GameController.startingSmallBlindSetting;
            int index = InfoScreen.indexOf(SMALL_BLINDS, startingSmallBlind);
            if (index >= 0) {
                this.list.setSelectedIndex(index, true);
            } else {
                this.list.append(GameController.toBlindsString(startingSmallBlind), null);
                this.list.setSelectedIndex(SMALL_BLINDS.length, true);
            }
        } else if (this.screenType == 3) {
            for (i = 0; i < BLINDS_TIME_LIMIT_MINUTES.length; ++i) {
                short m = BLINDS_TIME_LIMIT_MINUTES[i];
                if (m == 1) {
                    this.list.append("1 minute", null);
                    continue;
                }
                this.list.append(GameController.replace("&1 minutes", Integer.toString(m), null), null);
            }
            int minutes = GameController.blindIncreaseSecondsSetting / 60;
            int index = InfoScreen.indexOf(BLINDS_TIME_LIMIT_MINUTES, minutes);
            if (index >= 0) {
                this.list.setSelectedIndex(index, true);
            } else {
                this.list.append(GameController.replace("&1 minutes", Integer.toString(minutes), null), null);
                this.list.setSelectedIndex(BLINDS_TIME_LIMIT_MINUTES.length, true);
            }
        } else if (this.screenType == 4) {
            for (i = 0; i < BLINDS_ROUNDS.length; ++i) {
                this.list.append(Integer.toString(BLINDS_ROUNDS[i]), null);
            }
            short rounds = GameController.blindIncreaseRoundsSetting;
            int index = InfoScreen.indexOf(BLINDS_TIME_LIMIT_MINUTES, rounds);
            if (index >= 0) {
                this.list.setSelectedIndex(index, true);
            } else {
                this.list.append(Integer.toString(rounds), null);
                this.list.setSelectedIndex(BLINDS_ROUNDS.length, true);
            }
        } else if (this.screenType == 5) {
            players = GameController.getComputerPlayers();
            this.list.append("<NEW>", null);
            for (i = 0; i < players.size(); ++i) {
                Player player = (Player)players.elementAt(i);
                this.list.append(player.name + " - " + GameController.toMoney(player.holdings), null);
            }
            if (selectedIndex >= 0 && selectedIndex < this.list.size()) {
                this.list.setSelectedIndex(selectedIndex, true);
            }
        } else if (this.screenType == 6) {
            humanPlayer = GameController.getHumanPlayer();
            continueItem = GameController.instance.gameover ? -1 : this.list.append("Continue", continueImage);
            newGame = this.list.append("New Game", newGameImage);
            currentPlayer = this.list.append("" + InfoScreen.humanPlayer.name + " - " + GameController.toMoney(InfoScreen.humanPlayer.holdings) + "", currentPlayerImage);
            otherPlayers = this.list.append("Other Players", otherPlayersImage);
            blindsType = GameController.blindsTypeSetting;
            int smallBlind = GameController.instance.smallBlind;
            if (smallBlind == 0) {
                smallBlind = GameController.startingSmallBlindSetting;
            }
            blinds = this.list.append("Blinds - " + GameController.toBlindsString(smallBlind) + "", blindsImage);
            gameSettings = this.list.append("Game Settings", gameImage);
            statistics = this.list.append("Stats", statisticsImage);
            setAllMoney = this.list.append("Set All Money", setAllMoneyImage);
            instructions = this.list.append("Help", instructionsImage);
            about = this.list.append("About", aboutImage);
            this.list.setSelectedIndex(selectedIndex, true);
        } else if (this.screenType == 12) {
            player = inpPlayer;
            this.screen.setTitle(InfoScreen.player.type == 2 ? (InfoScreen.player.recordId == -1 ? "New Player" : InfoScreen.player.name) : "User");
            for (i = this.form.size() - 1; i >= 0; --i) {
                this.form.delete(i);
            }
            this.screen.removeCommand(RESET_MONEY);
            this.screen.removeCommand(OPTIONS);
            this.screen.removeCommand(MOVE_UP);
            this.screen.removeCommand(MOVE_DOWN);
            this.screen.removeCommand(DELETE);
            this.screen.removeCommand(BACK);
            this.screen.removeCommand(OK);
            this.screen.removeCommand(CANCEL);
            name = new TextField("Name", InfoScreen.player.name, 9, 0);
            this.form.append((Item)name);
            String playerHoldings = Long.toString(InfoScreen.player.holdings);
            String origPlayerHoldings = Long.toString(InfoScreen.player.origHoldings);
            money = new TextField("Money", playerHoldings, Math.max(6, Math.max(playerHoldings.length(), origPlayerHoldings.length())), 2);
            this.form.append((Item)money);
            intelligence = null;
            face = null;
            if (InfoScreen.player.type == 2) {
                this.previousScreen = Holdem.display.getCurrent();
                if (faceStringElements == null) {
                    faceStringElements = new String[8];
                    for (int i2 = 0; i2 < 8; ++i2) {
                        InfoScreen.faceStringElements[i2] = " ";
                    }
                }
                Holdem.gameCanvas.loadFaceImages();
                face = new ChoiceGroup("Face", 1, faceStringElements, HoldemCanvas.faceImages);
                face.setSelectedIndex((int)InfoScreen.player.faceIndex, true);
                this.form.append((Item)face);
                intelligence = new ChoiceGroup("Intelligence", 1, new String[]{"Hold'em Pro", "Smart", "Amateur", "Below Average", "Dead Money"}, null);
                switch (InfoScreen.player.intelligence) {
                    case 10: {
                        intelligence.setSelectedIndex(0, true);
                        break;
                    }
                    case 7: {
                        intelligence.setSelectedIndex(1, true);
                        break;
                    }
                    case 5: {
                        intelligence.setSelectedIndex(2, true);
                        break;
                    }
                    case 3: {
                        intelligence.setSelectedIndex(3, true);
                        break;
                    }
                    case 1: {
                        intelligence.setSelectedIndex(4, true);
                    }
                }
                this.form.append((Item)intelligence);
                if (InfoScreen.player.recordId == -1) {
                    this.screen.addCommand(CANCEL);
                    this.screen.addCommand(OK);
                } else {
                    this.screen.addCommand(BACK);
                    this.screen.addCommand(RESET_MONEY);
                }
            } else {
                this.screen.addCommand(BACK);
                this.screen.addCommand(RESET_MONEY);
            }
        } else if (this.screenType == 13) {
            switch (GameController.gameSpeedSetting) {
                case 4: {
                    gameSpeed.setSelectedIndex(0, true);
                    break;
                }
                case 10: {
                    gameSpeed.setSelectedIndex(1, true);
                    break;
                }
                case 16: {
                    gameSpeed.setSelectedIndex(2, true);
                    break;
                }
                case 26: {
                    gameSpeed.setSelectedIndex(3, true);
                }
            }
            i = 0;
            boolean value = false;
            value = GameController.soundOnSetting;
            settings.setSelectedIndex(i++, value);
            value = GameController.autoPopupSetting;
            settings.setSelectedIndex(i++, value);
            value = GameController.playerRespawnSetting;
            settings.setSelectedIndex(i++, value);
            value = GameController.pauseForWinSetting;
            settings.setSelectedIndex(i++, value);
            value = GameController.dealemButtonSetting;
            settings.setSelectedIndex(i++, value);
            value = GameController.restrictedRaisingSetting;
            settings.setSelectedIndex(i++, value);
            value = GameController.fastAfterHumanFoldSetting;
            settings.setSelectedIndex(i++, value);
        } else if (this.screenType == 17 || this.screenType == 18 || this.screenType == 19) {
            if (this.screenType == 17) {
                this.screen.setTitle("Game Statistics");
            } else if (this.screenType == 18) {
                this.screen.setTitle("Overall Statistics");
            } else if (this.screenType == 19) {
                this.screen.setTitle("Tourn. Statistics");
            }
            for (i = this.form.size() - 1; i >= 0; --i) {
                this.form.delete(i);
            }
            if (inpPlayer == null) {
                inpPlayer = GameController.getHumanPlayer();
            }
            player = inpPlayer;
            if (this.screenType == 17) {
                this.form.append(GameController.replace("Game Stats for &1:", InfoScreen.player.name, null) + "\nHands: " + InfoScreen.player.gameHands + "\nWins: " + InfoScreen.player.gameWins + "\nPercent Won: " + (InfoScreen.player.gameHands > 0 ? 100 * InfoScreen.player.gameWins / InfoScreen.player.gameHands : 0) + "%" + "\nFolds: " + InfoScreen.player.gameFolds + "\nPercent Folded: " + (InfoScreen.player.gameHands > 0 ? 100 * InfoScreen.player.gameFolds / InfoScreen.player.gameHands : 0) + "%" + "\nRaises: " + InfoScreen.player.gameRaises + "\nAll-ins: " + InfoScreen.player.gameAllIns + "\nPercent All-in: " + (InfoScreen.player.gameHands > 0 ? 100 * InfoScreen.player.gameAllIns / InfoScreen.player.gameHands : 0) + "%" + "\nTotal Amount Bet: " + GameController.toMoney(InfoScreen.player.gameTotalBet) + "\nTotal Amount Won: " + GameController.toMoney(InfoScreen.player.gameTotalWon) + "\nLargest Pot Won: " + GameController.toMoney(InfoScreen.player.gameLargestPotWon));
            } else if (this.screenType == 18) {
                this.form.append(GameController.replace("Overall Stats for &1:", InfoScreen.player.name, null) + "\nHands: " + InfoScreen.player.hands + "\nWins: " + InfoScreen.player.wins + "\nPercent Won: " + (InfoScreen.player.hands > 0 ? 100 * InfoScreen.player.wins / InfoScreen.player.hands : 0) + "%" + "\nFolds: " + InfoScreen.player.folds + "\nPercent Folded: " + (InfoScreen.player.hands > 0 ? 100 * InfoScreen.player.folds / InfoScreen.player.hands : 0) + "%" + "\nRaises: " + InfoScreen.player.raises + "\nAll-ins: " + InfoScreen.player.allIns + "\nPercent All-in: " + (InfoScreen.player.hands > 0 ? 100 * InfoScreen.player.allIns / InfoScreen.player.hands : 0) + "%" + "\nTotal Amount Bet: " + GameController.toMoney(InfoScreen.player.totalBet) + "\nTotal Amount Won: " + GameController.toMoney(InfoScreen.player.totalWon) + "\nLargest Pot Won: " + GameController.toMoney(InfoScreen.player.largestPotWon));
            } else if (this.screenType == 19) {
                this.form.append(GameController.replace("Tournament Stats for &1:", InfoScreen.player.name, null) + "\nTournaments Won: " + InfoScreen.player.tournamentsWon + "\nTournaments Lost: " + (InfoScreen.player.tournamentsPlayed - InfoScreen.player.tournamentsWon) + "\nAverage Position: " + (InfoScreen.player.tournamentsPlayed > 0 ? Integer.toString(InfoScreen.player.positionTotal / InfoScreen.player.tournamentsPlayed) : "N/A") + "\nLowest Hands to Win: " + (InfoScreen.player.lowestHands == 0 ? "N/A" : Integer.toString(InfoScreen.player.lowestHands)));
            }
        } else if (this.screenType == 15) {
            if (this.form.size() > 0) {
                this.form.delete(0);
            }
            blindsType = GameController.blindsTypeSetting;
            String incrementStr = null;
            if (blindsType == 1) {
                int minutes = GameController.blindIncreaseSecondsSetting / 60;
                incrementStr = minutes == 1 ? "1 minute" : GameController.replace("&1 minutes", Integer.toString(minutes), null);
            } else if (blindsType == 2) {
                short rounds = GameController.blindIncreaseRoundsSetting;
                incrementStr = rounds == 1 ? "1 round" : GameController.replace("&1 rounds", Integer.toString(rounds), null);
            }
            String startingBlindsStr = GameController.toBlindsString(GameController.startingSmallBlindSetting);
            String blindsStr = incrementStr != null ? GameController.replace("Increase every &1, starting at &2", incrementStr, startingBlindsStr) : startingBlindsStr;
            this.form.append(blindsStr);
        } else if (this.screenType == 16) {
            this.previousScreen = Holdem.display.getCurrent();
            this.form.append(GameController.replace("Note: &1", this.message, null));
        } else if (this.screenType == 10) {
            if (this.instructionsNumber < 5) {
                this.screen.addCommand(NEXT);
            }
            switch (this.instructionsNumber) {
                case 0: {
                    this.form.append("Aces Texas Hold'em - No Limit by Concrete Software.\n\nThis is the demo version of Aces Texas Hold'em - No Limit.  You can only play 25 hands.  Please purchase the full version at http://www.concretesoftware.com/\n\nAces Texas Hold'em - No Limit is a no limit Texas Hold'em poker game where you take on virtual players of all different skill levels.  Start with easier players and lower limit tables and then bluff, raise, and go all-in until you're ready to take on the pros! \n\n");
                    break;
                }
                case 1: {
                    this.form.append("Aces Texas Hold'em - No Limit is played as follows:\n  1. First 2 players left of the dealer chip pay the small and large blinds. (amounts depend on blinds settings)\n  2. Each player is dealt two cards.\n  3. There is a betting round starting with the player to the left of the large blind.\n  4. 3 community cards are flipped up which anyone can use.\n  5. Another betting round starting with the player to the left of the dealer.\n  6. 1 more community card is flipped up.\n  7. Another betting round.\n  8. Final community card is flipped up.\n  9. Final betting round.\n  10. Player with highest poker hand wins!\nRank of Poker Hands: Royal Flush, Straight Flush, 4 of a Kind, Full House, Flush, Straight, 3 of a Kind, 2 Pair, Pair, High Card\n\n");
                    break;
                }
                case 2: {
                    this.form.append("Game Controls:\n  Left Soft Key - Brings up the Actions menu when it is your turn to bet\n  Right Soft Key - Go to the main menu (pauses and saves the game), or back out of a menu you are in\n  Center-Select Key - Used to select highlighted options\n  Up/Down Arrows - Used in menus to select a different option\n  Select Key - Used in menus to choose the selected option\n  Left/Right Arrows - Scroll left/right to other players\n  Bet/Raise Widget - Use the arrow keys to select on different amounts and press the Center-Select key to have that amount added to the total bet/raise.  If you go over the desired amount, select Clear to start over.  Choose OK or press the Left soft key to bet/raise with the displayed amount.\n  Shortcuts -  0 - Fold, 1 - Call/Check, 2 - Bet/Raise, 3 - All In\n\n");
                    break;
                }
                case 3: {
                    this.form.append("Main Menu Options:\n  The 'Ace' option allows you to change your money and name.  The 'Other Players' option allows you to change computer players' intelligence, name, picture, and money and add more players.  The 'Blinds' option allows you to set the amount of money the blinds will start at and how quickly the blinds increase.  You can have the blinds increase by a timer, number of rounds played, or stay the same.  The 'Set All Money' option lets you set all players' money to a set amount.");
                    break;
                }
                case 4: {
                    this.form.append("The 'Game Settings' option allows you to set the following options:\n  Game Speed - How fast the game is.\n  Sound On - Whether to play sound during the game.\n  Auto-popup Actions - When it is your turn, the actions menu will appear automatically.\n  Auto Sit In - When a player is eliminated, another player will automatically sit down at the table.\n  Pause at Game End - At the end of a hand, pause the game until you press the Continue button.\n  Deal'em Button - At the end of each hand if not all the community cards are played out the Deal'em button allows you to see what the community cards would have been.\n  Raise to last bet - during a betting round, it requires that the next raise be at least as large as the last bet or raise.\n  Go fast after I fold - after you fold, the game will go much faster.\n\n");
                    break;
                }
                case 5: {
                    this.form.append("For any issues with this game, please contact support@concretesoftware.com or check us out on the web at www.concretesoftware.com\n");
                }
            }
        }
    }

    public final synchronized void commandAction(Command c, Displayable d) {
        if (Holdem.ignoreCommands) {
            Holdem.ignoreCommands = false;
            return;
        }
        if (this.ignoreCommands) {
            return;
        }
        int index = this.list != null ? this.list.getSelectedIndex() : 0;
        boolean goback = false;
        boolean refreshMainMenu = false;
        if (this.screenType == 12 || this.screenType == 2) {
            refreshMainMenu = true;
        }
        if (c == BACK || c == CANCEL) {
            goback = true;
        }
        if (this.screenType == 1) {
            if (c == SELECT || c == List.SELECT_COMMAND) {
                if (index == 0) {
                    Holdem.gotoStartingBlindsScreen(index, 0);
                } else if (index == 1) {
                    Holdem.gotoScreen((byte)3);
                } else if (index == 2) {
                    Holdem.gotoScreen((byte)4);
                }
            }
        } else if (this.screenType == 2) {
            if ((c == SELECT || c == List.SELECT_COMMAND) && index >= 0) {
                GameController.blindsTypeSetting = blindsType;
                if (blindsType == 1) {
                    GameController.blindIncreaseSecondsSetting = numberOfSecondsOrRounds;
                } else if (blindsType == 2) {
                    GameController.blindIncreaseRoundsSetting = (short)numberOfSecondsOrRounds;
                }
                if (index < SMALL_BLINDS.length) {
                    int smallBlind;
                    GameController.startingSmallBlindSetting = smallBlind = SMALL_BLINDS[index];
                    if (blindsType == 0) {
                        GameController.instance.smallBlind = smallBlind;
                    }
                }
                GameController.saveSettings();
                Holdem.gotoMainMenu(true);
            }
        } else if (this.screenType == 3) {
            if ((c == SELECT || c == List.SELECT_COMMAND) && index >= 0) {
                int seconds = index < BLINDS_TIME_LIMIT_MINUTES.length ? BLINDS_TIME_LIMIT_MINUTES[index] * 60 : GameController.blindIncreaseSecondsSetting / 60 * 60;
                Holdem.gotoStartingBlindsScreen(blindsType, seconds);
            }
        } else if (this.screenType == 4) {
            if ((c == SELECT || c == List.SELECT_COMMAND) && index >= 0) {
                short rounds = index < BLINDS_ROUNDS.length ? BLINDS_ROUNDS[index] : GameController.blindIncreaseRoundsSetting;
                Holdem.gotoStartingBlindsScreen(blindsType, rounds);
            }
        } else if (this.screenType == 5) {
            boolean isNew = index == 0;
            player = null;
            if (index > 0 && index <= players.size() && !isNew) {
                player = (Player)players.elementAt(index - 1);
            }
            if (c == EDIT || c == ADD || c == List.SELECT_COMMAND) {
                if (isNew) {
                    Player p = new Player();
                    if (players.size() >= 22) {
                        Holdem.showErrorAlert("New Player", GameController.replace("You can not have more than &1 computer players.", "22", null));
                        return;
                    }
                    if (players.size() > 0) {
                        p.sortOrder = ((Player)InfoScreen.players.elementAt((int)(InfoScreen.players.size() - 1))).sortOrder + 1;
                        p.playerIndex = this.list.size();
                    }
                    Holdem.gotoEditPlayerScreen(p);
                    this.ignoreCommands = true;
                } else if (player != null) {
                    InfoScreen.player.playerIndex = index;
                    Holdem.gotoEditPlayerScreen(player);
                    this.ignoreCommands = true;
                }
            } else if (c == MOVE_UP && player != null && index >= 2) {
                this.movePlayer(index, true);
            } else if (c == MOVE_DOWN && player != null && index <= players.size() - 1) {
                this.movePlayer(index, false);
            } else if (c == DELETE && player != null) {
                this.deletePlayer(index);
            } else if (c == RESET_ALL_MONEY) {
                GameController.resetPlayers(false);
                Holdem.gotoOtherPlayersScreen(index);
            } else if (c == BACK) {
                this.ignoreCommands = true;
            }
        } else if (this.screenType == 6) {
            if (c == SELECT || c == List.SELECT_COMMAND) {
                int option = this.list.getSelectedIndex();
                if (continueItem >= 0 && option == continueItem) {
                    Holdem.gotoGameCanvas(false);
                }
                if (option == newGame) {
                    Holdem.gotoGameCanvas(true);
                } else if (option == currentPlayer) {
                    Holdem.gotoEditPlayerScreen(humanPlayer);
                } else if (option == otherPlayers) {
                    Holdem.gotoOtherPlayersScreen(0);
                } else if (option == blinds) {
                    if (GameController.blindsTypeSetting == 0) {
                        Holdem.gotoScreen((byte)1);
                    } else {
                        Holdem.gotoScreen((byte)15);
                    }
                } else if (option == gameSettings) {
                    Holdem.gotoScreen((byte)13);
                } else if (option == statistics) {
                    Holdem.gotoScreen((byte)7);
                } else if (option == setAllMoney) {
                    Holdem.gotoScreen((byte)20);
                } else if (option == instructions) {
                    Holdem.gotoScreen((byte)8);
                } else if (option == about) {
                    Holdem.gotoScreen((byte)11);
                }
            } else if (c == EXIT) {
                Holdem.instance.destroyApp(true);
            }
        } else if (this.screenType == 12) {
            if (c == BACK || c == OK) {
                if (name.getString() == null || name.getString().trim().length() == 0) {
                    Holdem.showErrorAlert("Save Player", "The player must have a name.");
                    return;
                }
                boolean changed = false;
                if (money != null) {
                    long newHoldings = this.parseMoney("Save Player", money.getString());
                    if (newHoldings < 0L) {
                        money.setString(Long.toString(InfoScreen.player.holdings));
                        return;
                    }
                    if (newHoldings != InfoScreen.player.holdings) {
                        if (Long.toString(newHoldings).length() > 6 && newHoldings > InfoScreen.player.holdings) {
                            money.setString(Long.toString(InfoScreen.player.holdings));
                            Holdem.showErrorAlert("Save Player", GameController.replace("Can not increase the money past &1 digits.", "6", null));
                            return;
                        }
                        InfoScreen.player.origHoldings = InfoScreen.player.holdings = newHoldings;
                        changed = true;
                    }
                }
                if (!InfoScreen.player.name.equals(name.getString().trim())) {
                    InfoScreen.player.name = name.getString().trim();
                    changed = true;
                }
                if (intelligence != null) {
                    int newIntelligence = 10;
                    switch (intelligence.getSelectedIndex()) {
                        case 1: {
                            newIntelligence = 7;
                            break;
                        }
                        case 2: {
                            newIntelligence = 5;
                            break;
                        }
                        case 3: {
                            newIntelligence = 3;
                            break;
                        }
                        case 4: {
                            newIntelligence = 1;
                        }
                    }
                    if (newIntelligence != InfoScreen.player.intelligence) {
                        InfoScreen.player.intelligence = newIntelligence;
                        changed = true;
                    }
                }
                if (face != null && face.getSelectedIndex() != InfoScreen.player.faceIndex) {
                    InfoScreen.player.faceIndex = (byte)face.getSelectedIndex();
                    changed = true;
                }
                if (changed) {
                    GameController.savePlayer(player);
                }
                goback = true;
            } else if (c == RESET_MONEY) {
                InfoScreen.player.holdings = InfoScreen.player.origHoldings;
                GameController.savePlayer(player);
                money.setString(Long.toString(InfoScreen.player.holdings));
            } else if (c == MOVE_UP) {
                this.movePlayer(InfoScreen.player.playerIndex, true);
            } else if (c == MOVE_DOWN) {
                this.movePlayer(InfoScreen.player.playerIndex, false);
            } else if (c == DELETE) {
                this.deletePlayer(InfoScreen.player.playerIndex);
            }
        } else if (this.screenType == 13) {
            if (c == BACK) {
                switch (gameSpeed.getSelectedIndex()) {
                    case 0: {
                        GameController.gameSpeedSetting = 4;
                        break;
                    }
                    case 1: {
                        GameController.gameSpeedSetting = 10;
                        break;
                    }
                    case 2: {
                        GameController.gameSpeedSetting = 16;
                        break;
                    }
                    case 3: {
                        GameController.gameSpeedSetting = 26;
                    }
                }
                int i = 0;
                boolean value = false;
                GameController.soundOnSetting = value = settings.isSelected(i++);
                GameController.autoPopupSetting = value = settings.isSelected(i++);
                GameController.playerRespawnSetting = value = settings.isSelected(i++);
                GameController.pauseForWinSetting = value = settings.isSelected(i++);
                GameController.dealemButtonSetting = value = settings.isSelected(i++);
                GameController.restrictedRaisingSetting = value = settings.isSelected(i++);
                GameController.fastAfterHumanFoldSetting = value = settings.isSelected(i++);
                GameController.saveSettings();
                goback = true;
            }
        } else if (this.screenType == 7) {
            if (c == RESET) {
                Player p = GameController.getHumanPlayer();
                p.resetStatistics();
                GameController.savePlayer(p);
                if (!GameController.instance.gameover) {
                    GameController.instance.humanPlayer.resetStatistics();
                }
                Alert alert = new Alert("Stats", "All stats have been reset, except for the game stats.  You need to start a new game to reset the game stats.", null, AlertType.CONFIRMATION);
                alert.setTimeout(-2);
                Holdem.display.setCurrent((Displayable)alert);
            } else if ((c == SELECT || c == List.SELECT_COMMAND) && index >= 0 && index < 3) {
                Holdem.gotoScreen((byte)(index == 0 ? 17 : (index == 1 ? 18 : 19)));
            }
        } else if (this.screenType == 15) {
            if (c == EDIT) {
                Holdem.gotoScreen((byte)1);
            }
        } else if (this.screenType == 16) {
            if (c == OK) {
                if (this.nextScreen instanceof HoldemCanvas) {
                    Holdem.gotoGameCanvas(true);
                } else {
                    Holdem.display.setCurrent(this.nextScreen);
                }
            }
        } else if (this.screenType == 20) {
            if (c == OK) {
                long moneyValue = this.parseMoney("Set All Money", allMoney.getString());
                if (moneyValue < 0L) {
                    allMoney.setString("");
                    return;
                }
                Vector players = GameController.getComputerPlayers();
                players.addElement(GameController.getHumanPlayer());
                for (int i = 0; i < players.size(); ++i) {
                    Player p = (Player)players.elementAt(i);
                    p.holdings = p.origHoldings = moneyValue;
                }
                GameController.savePlayers(players);
                Holdem.gotoMainMenu(true);
            }
        } else if (this.screenType == 10) {
            if (c == NEXT) {
                InfoScreen nextScreen = new InfoScreen(10);
                nextScreen.instructionsNumber = (byte)(this.instructionsNumber + 1);
                nextScreen.init(null, 0, 0, 0);
                Holdem.display.setCurrent((Displayable)nextScreen.screen);
            }
        } else if (this.screenType == 8 && (c == SELECT || c == List.SELECT_COMMAND && index >= 0 && index <= 5)) {
            InfoScreen instructionsScreen = new InfoScreen(10);
            instructionsScreen.instructionsNumber = (byte)index;
            instructionsScreen.init(null, 0, 0, 0);
            Holdem.display.setCurrent((Displayable)instructionsScreen.screen);
        }
        if (goback) {
            if (this.screenType == 2 || this.screenType == 3 || this.screenType == 4 || this.screenType == 16 || this.screenType == 17 || this.screenType == 18 || this.screenType == 19) {
                Holdem.display.setCurrent(this.previousScreen);
            } else if (this.screenType == 12 && InfoScreen.player.type == 2) {
                Holdem.gotoOtherPlayersScreen(InfoScreen.player.recordId >= 0 ? InfoScreen.player.playerIndex : 0);
            } else if (this.screenType == 10) {
                Holdem.gotoScreen((byte)8);
            } else {
                Holdem.gotoMainMenu(refreshMainMenu);
            }
        }
    }

    private void movePlayer(int index, boolean moveUp) {
        int i = players.indexOf(player);
        players.removeElementAt(i);
        players.insertElementAt(player, i + (moveUp ? -1 : 1));
        this.setSortOrders();
        GameController.savePlayers(players);
        Holdem.gotoOtherPlayersScreen(index + (moveUp ? -1 : 1));
    }

    private void deletePlayer(int index) {
        GameController.deletePlayer(player);
        Holdem.gotoOtherPlayersScreen(index);
    }

    private void setSortOrders() {
        for (int i = 0; i < players.size(); ++i) {
            ((Player)InfoScreen.players.elementAt((int)i)).sortOrder = i;
        }
    }

    private static int indexOf(short[] array, int number) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != number) continue;
            return i;
        }
        return -1;
    }

    private void displayOptionsScreen() {
        int index;
        for (int i = optionsScreen.size() - 1; i >= 0; --i) {
            optionsScreen.delete(i);
        }
        deleteIndex = -1;
        moveDownIndex = -1;
        moveUpIndex = -1;
        resetIndex = -1;
        if (this.list == null) {
            resetIndex = optionsScreen.append("Reset $", null);
        }
        if ((index = players.indexOf(player)) > 0 && players.size() > 1) {
            moveUpIndex = optionsScreen.append("Move Up", null);
        }
        if (index < players.size() - 1 && players.size() > 1) {
            moveDownIndex = optionsScreen.append("Move Down", null);
        }
        deleteIndex = optionsScreen.append("Delete", null);
        optionsScreen.setCommandListener((CommandListener)this);
        Holdem.display.setCurrent((Displayable)optionsScreen);
    }

    private long parseMoney(String screenTitle, String moneyString) {
        try {
            long result = Long.parseLong(moneyString);
            if (result < 0L) {
                Holdem.showErrorAlert(screenTitle, "Invalid money number.");
                return -1L;
            }
            return result;
        }
        catch (NumberFormatException e) {
            Holdem.showErrorAlert(screenTitle, "Invalid money number.");
            return -1L;
        }
    }

    static {
        continueItem = -1;
        blindsType = 0;
        numberOfSecondsOrRounds = 0;
        name = null;
    }
}

