/*
 * Decompiled with CFR 0.152.
 */
package com.concretesoftware.holdem;

import com.concretesoftware.holdem.Card;
import com.concretesoftware.holdem.GameController;
import java.util.Vector;

public class Player {
    private static final byte VERSION = 2;
    public static final int NEW_RECORD = -1;
    public static final byte HUMAN = 1;
    public static final byte COMPUTER = 2;
    public static final byte COMMUNITY = 3;
    public static final short DEFAULT_ORIG_HOLDINGS = 1000;
    public static final byte ROYAL_FLUSH = 10;
    public static final byte STRAIGHT_FLUSH = 9;
    public static final byte FOUR_OF_A_KIND = 8;
    public static final byte FULL_HOUSE = 7;
    public static final byte FLUSH = 6;
    public static final byte STRAIGHT = 5;
    public static final byte THREE_OF_A_KIND = 4;
    public static final byte TWO_PAIR = 3;
    public static final byte ONE_PAIR = 2;
    public static final byte HIGH_CARD = 1;
    public static final byte UNKNOWN = 0;
    public static final byte SMART = 10;
    public static final byte ABOVE_AVERAGE = 7;
    public static final byte AVERAGE = 5;
    public static final byte BELOW_AVERAGE = 3;
    public static final byte DUMB = 1;
    public static final byte[] ALL_LEVELS = new byte[]{10, 7, 5, 3, 1};
    public int recordId = -1;
    public String name = "";
    public long holdings = 1000L;
    public long origHoldings = 1000L;
    public long bet;
    public String lastBet = "";
    public byte type = (byte)2;
    public boolean allIn;
    public boolean inTheGame = true;
    public boolean allDone;
    public int sortOrder;
    public int intelligence = 5;
    public byte faceIndex;
    public boolean mustPayLargeBlind;
    public boolean mustPaySmallBlind;
    public boolean deleted;
    public boolean displayCards;
    public boolean showCards;
    public Vector cards = new Vector();
    public long lastBetDisplayTimestamp;
    public boolean pokerHandInitialized;
    public Vector sortedCards = new Vector();
    public byte pokerType;
    public Vector pokerHandCards;
    public Vector possibleFlushes = new Vector();
    public Vector possibleStraights = new Vector();
    public Vector quad;
    public Vector trip;
    public Vector pairs = new Vector();
    public boolean rainbow;
    public byte combinedPokerType;
    public Vector combinedSortedCards = new Vector();
    public Vector combinedPokerHandCards;
    public Vector combinedPossibleFlushes;
    public Vector combinedPossibleStraights;
    public Vector combinedQuads;
    public Vector combinedTrips;
    public Vector combinedPairs;
    private boolean lastRoundBetting = false;
    public boolean respawning = false;
    public transient int playerIndex = 0;
    public int hands;
    public int handsShown;
    public int wins;
    public int bluffs;
    public int folds;
    public int raises;
    public long totalBet;
    public long totalWon;
    public int allIns;
    public long largestPotWon;
    public int gameHands;
    public int gameHandsShown;
    public int gameWins;
    public int gameBluffs;
    public int gameFolds;
    public int gameRaises;
    public long gameTotalBet;
    public long gameTotalWon;
    public int gameAllIns;
    public long gameLargestPotWon;
    public int tournamentsWon;
    public int tournamentsPlayed;
    public int positionTotal;
    public int lowestHands;

    public Player() {
    }

    public Player(int sortOrder, String name, int type, int intelligence, long holdings) {
        this();
        this.sortOrder = sortOrder;
        this.name = name;
        this.type = (byte)type;
        this.intelligence = intelligence;
        this.holdings = this.origHoldings = holdings;
        this.displayCards = type == 1 || type == 3;
    }

    public void reset() {
        this.bet = 0L;
        this.lastBet = "";
        this.lastBetDisplayTimestamp = 0L;
        this.allIn = false;
        this.inTheGame = this.holdings > 0L && !this.allDone;
        this.lastRoundBetting = false;
        this.displayCards = this.type == 1 || this.type == 3;
        this.showCards = false;
        this.cards.removeAllElements();
        this.resetPokerHand();
    }

    public boolean lastBetDisplayPastDue() {
        if (this.lastBetDisplayTimestamp > 0L && this.lastBet.length() > 0 && System.currentTimeMillis() - this.lastBetDisplayTimestamp > 5000L) {
            this.lastBetDisplayTimestamp = 0L;
            return true;
        }
        return false;
    }

    public String getMoneyOrLastBet() {
        if (this.lastBetDisplayTimestamp == 0L || this.lastBet.length() == 0 || this.lastBetDisplayPastDue()) {
            return GameController.toMoney(this.holdings);
        }
        return this.lastBet;
    }

    private void resetPokerHand() {
        this.sortedCards.removeAllElements();
        this.pokerHandCards = null;
        this.pokerType = 0;
        this.pokerHandInitialized = false;
        this.resetCombinedHand();
    }

    private void resetCombinedHand() {
        this.combinedSortedCards.removeAllElements();
        this.combinedPokerHandCards = null;
        this.combinedPokerType = 0;
    }

    public void resetForNewGame() {
        this.mustPayLargeBlind = false;
        this.mustPaySmallBlind = false;
        this.allDone = this.holdings == 0L;
        this.respawning = false;
        this.gameAllIns = 0;
        this.gameRaises = 0;
        this.gameFolds = 0;
        this.gameBluffs = 0;
        this.gameWins = 0;
        this.gameHandsShown = 0;
        this.gameHands = 0;
        this.gameLargestPotWon = 0L;
        this.gameTotalWon = 0L;
        this.gameTotalBet = 0L;
    }

    public void resetStatistics() {
        this.allIns = 0;
        this.raises = 0;
        this.folds = 0;
        this.bluffs = 0;
        this.wins = 0;
        this.handsShown = 0;
        this.hands = 0;
        this.largestPotWon = 0L;
        this.totalWon = 0L;
        this.totalBet = 0L;
        this.lowestHands = 0;
        this.positionTotal = 0;
        this.tournamentsPlayed = 0;
        this.tournamentsWon = 0;
    }

    public void clearBet() {
        this.bet = 0L;
        this.lastBet = "";
    }

    public void addCard(Card card) {
        this.resetPokerHand();
        card.highlighted = false;
        this.cards.addElement(card);
    }

    public Card getCard(int i) {
        return (Card)this.cards.elementAt(i);
    }

    public void initPokerHand() {
        if (!this.pokerHandInitialized && !this.cards.isEmpty()) {
            Player.sortCards(this.sortedCards, this.cards);
            this.pokerHandCards = new Vector();
            this.pokerType = Player.initTexasHoldemPokerHand(this.sortedCards, this.pokerHandCards);
            this.pokerHandInitialized = true;
        }
        Vector communityCards = GameController.instance.community.cards;
        if (this.type != 3 && (this.combinedPokerType == 0 || this.combinedSortedCards.size() != this.cards.size() + communityCards.size())) {
            int i;
            this.resetCombinedHand();
            Vector combinedCards = new Vector(9);
            for (i = 0; i < this.cards.size(); ++i) {
                combinedCards.addElement(this.cards.elementAt(i));
            }
            for (i = 0; i < communityCards.size(); ++i) {
                combinedCards.addElement(communityCards.elementAt(i));
            }
            Player.sortCards(this.combinedSortedCards, combinedCards);
            if (communityCards.size() > 0) {
                this.combinedPokerHandCards = new Vector();
                this.combinedPokerType = Player.initTexasHoldemPokerHand(this.combinedSortedCards, this.combinedPokerHandCards);
            }
        }
    }

    private static byte initTexasHoldemPokerHand(Vector sortedCards, Vector pokerHandCards) {
        int i;
        for (i = 0; i < sortedCards.size() && Player.getCard((Vector)sortedCards, (int)i).number == 1; ++i) {
            if (!Player.checkForStraightQuick(i, true, sortedCards, pokerHandCards)) continue;
            return 10;
        }
        for (i = 0; i <= sortedCards.size() - 4 && (Player.getCard((Vector)sortedCards, (int)i).number >= 5 || Player.getCard((Vector)sortedCards, (int)i).number == 1); ++i) {
            if (!Player.checkForStraightQuick(i, true, sortedCards, pokerHandCards)) continue;
            return 9;
        }
        for (i = 0; i <= sortedCards.size() - 4; ++i) {
            if (!Player.checkForMultiplesQuick(i, 4, 0, sortedCards, pokerHandCards)) continue;
            return 8;
        }
        for (i = 0; i <= sortedCards.size() - 3; ++i) {
            if (!Player.checkForMultiplesQuick(i, 3, 2, sortedCards, pokerHandCards)) continue;
            return 7;
        }
        for (i = 0; i <= sortedCards.size() - 5; ++i) {
            pokerHandCards.removeAllElements();
            Card card = Player.getCard(sortedCards, i);
            pokerHandCards.addElement(card);
            byte suit = card.suit;
            for (int j = i + 1; j < sortedCards.size() && pokerHandCards.size() < 5; ++j) {
                Card nextCard = Player.getCard(sortedCards, j);
                if (nextCard.suit != suit) continue;
                pokerHandCards.addElement(nextCard);
            }
            if (pokerHandCards.size() != 5) continue;
            return 6;
        }
        for (i = 0; i <= sortedCards.size() - 4 && (Player.getCard((Vector)sortedCards, (int)i).number >= 5 || Player.getCard((Vector)sortedCards, (int)i).number == 1); ++i) {
            if (!Player.checkForStraightQuick(i, false, sortedCards, pokerHandCards)) continue;
            return 5;
        }
        for (i = 0; i <= sortedCards.size() - 3; ++i) {
            if (!Player.checkForMultiplesQuick(i, 3, 0, sortedCards, pokerHandCards)) continue;
            return 4;
        }
        for (i = 0; i <= sortedCards.size() - 4; ++i) {
            if (!Player.checkForMultiplesQuick(i, 2, 2, sortedCards, pokerHandCards)) continue;
            return 3;
        }
        for (i = 0; i <= sortedCards.size() - 2; ++i) {
            if (!Player.checkForMultiplesQuick(i, 2, 0, sortedCards, pokerHandCards)) continue;
            return 2;
        }
        if (sortedCards.size() > 0) {
            pokerHandCards.removeAllElements();
            for (i = 0; i < 5 && i < sortedCards.size(); ++i) {
                pokerHandCards.addElement(Player.getCard(sortedCards, i));
            }
            return 1;
        }
        return 0;
    }

    private void initMyOmahaHoldemPokerHand() {
        int i;
        int flushStraightLength = this.type == 3 ? 3 : 2;
        Vector pokerHandCards = new Vector(5);
        for (i = 0; i <= this.cards.size() - flushStraightLength; ++i) {
            this.checkForFlushes(i, flushStraightLength, flushStraightLength, false, 0, this.sortedCards, pokerHandCards, this.possibleFlushes);
            this.checkForStraights(i, false, flushStraightLength, flushStraightLength, false, 0, this.sortedCards, pokerHandCards, this.possibleStraights);
        }
        this.checkForStraights(this.cards.size() - flushStraightLength + 1, false, flushStraightLength, flushStraightLength, false, 0, this.sortedCards, pokerHandCards, this.possibleStraights);
        for (i = 0; i <= this.cards.size() - 4 && this.quad == null; ++i) {
            this.quad = this.checkForMultiples(i, 4, 0, false, 0, this.sortedCards, pokerHandCards);
        }
        if (this.quad == null) {
            Vector pair;
            for (i = 0; i <= this.cards.size() - 3 && this.trip == null; ++i) {
                this.trip = this.checkForMultiples(i, 3, 0, false, 0, this.sortedCards, pokerHandCards);
                if (this.trip == null || this.cards.size() != 5 || i != 0 && i != 3 || (pair = this.checkForMultiples(i == 0 ? 4 : 0, 2, 0, false, 0, this.sortedCards, pokerHandCards)) == null) continue;
                this.pairs.addElement(pair);
            }
            if (this.trip == null) {
                for (i = 0; i <= this.cards.size() - 2; ++i) {
                    pair = this.checkForMultiples(i, 2, 0, false, 0, this.sortedCards, pokerHandCards);
                    if (pair == null) continue;
                    this.pairs.addElement(pair);
                    ++i;
                }
            }
        }
        if (this.cards.size() == 3) {
            this.rainbow = this.getCard((int)0).suit != this.getCard((int)1).suit && this.getCard((int)0).suit != this.getCard((int)2).suit && this.getCard((int)1).suit != this.getCard((int)2).suit;
        } else if (this.cards.size() == 4) {
            this.rainbow = this.getCard((int)0).suit != this.getCard((int)1).suit && this.getCard((int)0).suit != this.getCard((int)2).suit && this.getCard((int)0).suit != this.getCard((int)3).suit && this.getCard((int)1).suit != this.getCard((int)2).suit && this.getCard((int)1).suit != this.getCard((int)3).suit && this.getCard((int)2).suit != this.getCard((int)3).suit;
        }
        this.pokerHandInitialized = true;
    }

    private void initCombinedOmahaHoldemPokerHand() {
        Vector hand;
        Vector hand2;
        int i;
        byte maxQuadNumber = 0;
        byte maxTripNumber = 0;
        Vector pokerHandCards = new Vector(5);
        for (i = 0; i <= this.combinedSortedCards.size() - 5 && Player.getCard((Vector)this.combinedSortedCards, (int)i).number == 1; ++i) {
            hand2 = this.checkForStraights(i, true, 5, 5, true, 0, this.combinedSortedCards, pokerHandCards, null);
            if (hand2 == null) continue;
            this.combinedPokerType = (byte)10;
            this.combinedPokerHandCards = hand2;
            break;
        }
        if (this.combinedPokerType == 0) {
            for (i = 0; i <= this.combinedSortedCards.size() - 4 && (Player.getCard((Vector)this.combinedSortedCards, (int)i).number >= 5 || Player.getCard((Vector)this.combinedSortedCards, (int)i).number == 1); ++i) {
                hand2 = this.checkForStraights(i, true, 5, 5, true, 0, this.combinedSortedCards, pokerHandCards, null);
                if (hand2 == null) continue;
                this.combinedPokerType = (byte)9;
                this.combinedPokerHandCards = hand2;
                break;
            }
        }
        for (i = 0; i <= this.combinedSortedCards.size() - 4; ++i) {
            hand2 = this.checkForMultiples(i, 4, 0, true, 0, this.combinedSortedCards, pokerHandCards);
            if (hand2 == null) continue;
            if (this.combinedPokerType == 0) {
                this.combinedPokerType = (byte)8;
                this.combinedPokerHandCards = hand2;
            }
            this.combinedQuads.addElement(hand2);
            if (maxQuadNumber != 0) continue;
            maxQuadNumber = Player.getCard((Vector)hand2, (int)0).number;
        }
        if (this.combinedPokerType == 0) {
            for (i = 0; i <= this.combinedSortedCards.size() - 3; ++i) {
                hand2 = this.checkForMultiples(i, 3, 2, true, 0, this.combinedSortedCards, pokerHandCards);
                if (hand2 == null) continue;
                this.combinedPokerType = (byte)7;
                this.combinedPokerHandCards = hand2;
                break;
            }
        }
        for (i = 0; i <= this.combinedSortedCards.size() - 4; ++i) {
            hand2 = this.checkForFlushes(i, 4, 5, true, 0, this.combinedSortedCards, pokerHandCards, this.combinedPossibleFlushes);
            if (hand2 == null || hand2.size() != 5 || this.combinedPokerType != 0) continue;
            this.combinedPokerType = (byte)6;
            this.combinedPokerHandCards = hand2;
        }
        for (i = 0; i <= this.combinedSortedCards.size() - 3; ++i) {
            hand2 = this.checkForStraights(i, false, 4, 5, true, 0, this.combinedSortedCards, pokerHandCards, this.combinedPossibleStraights);
            if (hand2 == null || hand2.size() != 5 || this.combinedPokerType != 0) continue;
            this.combinedPokerType = (byte)5;
            this.combinedPokerHandCards = hand2;
        }
        for (i = 0; i <= this.combinedSortedCards.size() - 3 && maxQuadNumber != 1 && (Player.getCard((Vector)this.combinedSortedCards, (int)i).number == 1 || Player.getCard((Vector)this.combinedSortedCards, (int)i).number > maxQuadNumber); ++i) {
            hand2 = this.checkForMultiples(i, 3, 0, true, 0, this.combinedSortedCards, pokerHandCards);
            if (hand2 == null) continue;
            if (this.combinedPokerType == 0) {
                this.combinedPokerType = (byte)4;
                this.combinedPokerHandCards = hand2;
            }
            this.combinedTrips.addElement(hand2);
            if (maxTripNumber != 0) continue;
            maxTripNumber = Player.getCard((Vector)hand2, (int)0).number;
        }
        if (this.combinedPokerType == 0) {
            for (i = 0; i <= this.combinedSortedCards.size() - 4; ++i) {
                hand2 = this.checkForMultiples(i, 2, 2, true, 0, this.combinedSortedCards, pokerHandCards);
                if (hand2 == null) continue;
                this.combinedPokerType = (byte)3;
                this.combinedPokerHandCards = hand2;
                break;
            }
        }
        for (i = 0; i <= this.combinedSortedCards.size() - 2 && maxQuadNumber != 1 && maxTripNumber != 1 && (Player.getCard((Vector)this.combinedSortedCards, (int)i).number == 1 || Player.getCard((Vector)this.combinedSortedCards, (int)i).number > maxQuadNumber && Player.getCard((Vector)this.combinedSortedCards, (int)i).number > maxTripNumber); ++i) {
            hand2 = this.checkForMultiples(i, 2, 0, true, 0, this.combinedSortedCards, pokerHandCards);
            if (hand2 == null) continue;
            if (this.combinedPokerType == 0) {
                this.combinedPokerType = (byte)2;
                this.combinedPokerHandCards = hand2;
            }
            this.combinedPairs.addElement(hand2);
        }
        if (this.combinedPokerType == 0 && (hand = this.checkForHighCards(0, true, 0, this.combinedSortedCards, pokerHandCards)) != null) {
            this.combinedPokerType = 1;
            this.combinedPokerHandCards = hand;
        }
    }

    public void copyFrom(Player player) {
        this.name = player.name;
        this.faceIndex = player.faceIndex;
        this.intelligence = player.intelligence;
        this.holdings = player.holdings;
        this.origHoldings = player.origHoldings;
        if (this.holdings > 0L) {
            this.respawning = false;
        }
    }

    public int writeBytes(byte[][] data, int offset, boolean includeTransients) {
        offset += GameController.writeInt(2, data, offset);
        offset += GameController.writeInt(this.sortOrder, data, offset);
        offset += GameController.writeInt(this.type, data, offset);
        offset += GameController.writeString(this.name, data, offset);
        offset += GameController.writeInt(this.intelligence, data, offset);
        offset += GameController.writeLong(this.holdings, data, offset);
        offset += GameController.writeLong(this.origHoldings, data, offset);
        offset += GameController.writeInt(this.hands, data, offset);
        offset += GameController.writeInt(this.handsShown, data, offset);
        offset += GameController.writeInt(this.wins, data, offset);
        offset += GameController.writeInt(this.bluffs, data, offset);
        offset += GameController.writeInt(this.folds, data, offset);
        offset += GameController.writeInt(this.raises, data, offset);
        offset += GameController.writeInt(this.faceIndex, data, offset);
        offset += GameController.writeLong(this.totalBet, data, offset);
        offset += GameController.writeLong(this.totalWon, data, offset);
        offset += GameController.writeInt(this.allIns, data, offset);
        offset += GameController.writeLong(this.largestPotWon, data, offset);
        offset += GameController.writeInt(this.gameHands, data, offset);
        offset += GameController.writeInt(this.gameHandsShown, data, offset);
        offset += GameController.writeInt(this.gameWins, data, offset);
        offset += GameController.writeInt(this.gameBluffs, data, offset);
        offset += GameController.writeInt(this.gameFolds, data, offset);
        offset += GameController.writeInt(this.gameRaises, data, offset);
        offset += GameController.writeLong(this.gameTotalBet, data, offset);
        offset += GameController.writeLong(this.gameTotalWon, data, offset);
        offset += GameController.writeInt(this.gameAllIns, data, offset);
        offset += GameController.writeLong(this.gameLargestPotWon, data, offset);
        offset += GameController.writeInt(this.tournamentsWon, data, offset);
        offset += GameController.writeInt(this.tournamentsPlayed, data, offset);
        offset += GameController.writeInt(this.positionTotal, data, offset);
        offset += GameController.writeInt(this.lowestHands, data, offset);
        if (includeTransients) {
            offset += GameController.writeInt(this.recordId, data, offset);
            offset += GameController.writeLong(this.bet, data, offset);
            offset += GameController.writeInt((this.allIn ? 1 : 0) | (this.inTheGame ? 2 : 0) | (this.mustPaySmallBlind ? 4 : 0) | (this.mustPayLargeBlind ? 8 : 0) | (this.lastRoundBetting ? 16 : 0) | (this.deleted ? 32 : 0) | (this.showCards ? 64 : 0) | (this.allDone ? 128 : 0) | (this.respawning ? 256 : 0), data, offset);
            offset = this.writeHandBytes(data, offset);
        }
        return offset;
    }

    public int readBytes(byte[] data, int offset, boolean includeTransients) {
        int version = GameController.readInt(data, offset);
        this.sortOrder = GameController.readInt(data, offset += 4);
        this.type = (byte)GameController.readInt(data, offset += 4);
        int length = GameController.stringLength(data, offset += 4);
        this.name = GameController.readString(data, offset);
        this.intelligence = GameController.readInt(data, offset += length);
        this.holdings = GameController.readLong(data, offset += 4);
        this.origHoldings = GameController.readLong(data, offset += 8);
        this.hands = GameController.readInt(data, offset += 8);
        this.handsShown = GameController.readInt(data, offset += 4);
        this.wins = GameController.readInt(data, offset += 4);
        this.bluffs = GameController.readInt(data, offset += 4);
        this.folds = GameController.readInt(data, offset += 4);
        this.raises = GameController.readInt(data, offset += 4);
        offset += 4;
        if (version >= 2) {
            this.faceIndex = (byte)GameController.readInt(data, offset);
            this.totalBet = GameController.readLong(data, offset += 4);
            this.totalWon = GameController.readLong(data, offset += 8);
            this.allIns = GameController.readInt(data, offset += 8);
            this.largestPotWon = GameController.readLong(data, offset += 4);
            this.gameHands = GameController.readInt(data, offset += 8);
            this.gameHandsShown = GameController.readInt(data, offset += 4);
            this.gameWins = GameController.readInt(data, offset += 4);
            this.gameBluffs = GameController.readInt(data, offset += 4);
            this.gameFolds = GameController.readInt(data, offset += 4);
            this.gameRaises = GameController.readInt(data, offset += 4);
            this.gameTotalBet = GameController.readLong(data, offset += 4);
            this.gameTotalWon = GameController.readLong(data, offset += 8);
            this.gameAllIns = GameController.readInt(data, offset += 8);
            this.gameLargestPotWon = GameController.readLong(data, offset += 4);
            this.tournamentsWon = GameController.readInt(data, offset += 8);
            this.tournamentsPlayed = GameController.readInt(data, offset += 4);
            this.positionTotal = GameController.readInt(data, offset += 4);
            this.lowestHands = GameController.readInt(data, offset += 4);
            offset += 4;
        }
        if (includeTransients) {
            this.recordId = GameController.readInt(data, offset);
            this.bet = GameController.readLong(data, offset += 4);
            int booleans = GameController.readInt(data, offset += 8);
            offset += 4;
            this.allIn = (booleans & 1) != 0;
            this.inTheGame = (booleans & 2) != 0;
            this.mustPaySmallBlind = (booleans & 4) != 0;
            this.mustPayLargeBlind = (booleans & 8) != 0;
            this.lastRoundBetting = (booleans & 0x10) != 0;
            this.deleted = (booleans & 0x20) != 0;
            this.showCards = (booleans & 0x40) != 0;
            this.displayCards = this.type == 1 || this.type == 3 || this.showCards;
            this.allDone = (booleans & 0x80) != 0;
            this.respawning = (booleans & 0x100) != 0;
            offset = this.readHandBytes(data, offset);
        }
        return offset;
    }

    public int writeHandBytes(byte[][] data, int offset) {
        offset += GameController.writeInt(this.cards.size(), data, offset);
        for (int i = 0; i < this.cards.size(); ++i) {
            Card card = (Card)this.cards.elementAt(i);
            offset += GameController.writeInt(card.number, data, offset);
            offset += GameController.writeInt(card.suit, data, offset);
        }
        return offset;
    }

    public int readHandBytes(byte[] data, int offset) {
        this.resetPokerHand();
        int size = GameController.readInt(data, offset);
        offset += 4;
        this.cards.removeAllElements();
        for (int i = 0; i < size; ++i) {
            int number = GameController.readInt(data, offset);
            int suit = GameController.readInt(data, offset += 4);
            offset += 4;
            this.cards.addElement(new Card(number, suit));
        }
        return offset;
    }

    public void addToBet(long amount) {
        this.holdings -= amount;
        this.bet += amount;
        if (this.holdings == 0L) {
            this.allIn = true;
        }
    }

    public void win(long amount, boolean countWin) {
        this.holdings += amount;
        this.totalWon += amount;
        this.gameTotalWon += amount;
        if (countWin) {
            ++this.wins;
            ++this.gameWins;
            if (!this.showCards) {
                ++this.hands;
                ++this.gameHands;
            }
            if (amount > this.largestPotWon) {
                this.largestPotWon = amount;
            }
            if (amount > this.gameLargestPotWon) {
                this.gameLargestPotWon = amount;
            }
        }
    }

    public final void recordPlayerAction(long amt, boolean choseAllIn) {
        int action = GameController.instance.getAction(this, amt);
        this.lastBet = GameController.instance.getActionName(this, amt);
        this.lastBetDisplayTimestamp = System.currentTimeMillis();
        if (action == 4 || choseAllIn) {
            ++this.allIns;
            ++this.gameAllIns;
        }
        if (this.bet + amt > GameController.instance.pot.getRequiredBet()) {
            ++this.raises;
            ++this.gameRaises;
            if (GameController.instance.currentRound == 4) {
                this.lastRoundBetting = true;
            }
        } else if (action == -1) {
            ++this.hands;
            ++this.gameHands;
            ++this.folds;
            ++this.gameFolds;
        }
        if (amt > 0L) {
            this.totalBet += amt;
            this.gameTotalBet += amt;
        }
    }

    public final void showCards() {
        this.displayCards = true;
        this.showCards = true;
        this.initPokerHand();
        ++this.hands;
        ++this.gameHands;
        ++this.handsShown;
        ++this.gameHandsShown;
        if (this.lastRoundBetting) {
            this.initPokerHand();
            GameController.instance.community.initPokerHand();
            if (this.combinedPokerType <= GameController.instance.community.pokerType) {
                ++this.bluffs;
                ++this.gameBluffs;
            }
        }
    }

    public void eliminated(int position) {
        this.allDone = true;
        ++this.tournamentsPlayed;
        this.positionTotal += position;
    }

    public void wonItAll() {
        ++this.tournamentsWon;
        ++this.tournamentsPlayed;
        ++this.positionTotal;
        if (this.lowestHands == 0 || this.lowestHands > this.gameHands) {
            this.lowestHands = this.gameHands;
        }
    }

    public String toString() {
        return "player " + this.name;
    }

    public int compareHands(Player otherPlayer) {
        this.initPokerHand();
        otherPlayer.initPokerHand();
        if (this.combinedPokerType > otherPlayer.combinedPokerType) {
            return 1;
        }
        if (this.combinedPokerType < otherPlayer.combinedPokerType) {
            return -1;
        }
        if (this.combinedPokerHandCards != null) {
            for (int i = 0; i < this.combinedPokerHandCards.size() && i < otherPlayer.combinedPokerHandCards.size(); ++i) {
                Card otherCard;
                Card thisCard = (Card)this.combinedPokerHandCards.elementAt(i);
                int comparison = thisCard.compare(otherCard = (Card)otherPlayer.combinedPokerHandCards.elementAt(i), true);
                if (comparison == 0) continue;
                return comparison;
            }
        }
        return 0;
    }

    public String handToString(boolean combined) {
        this.initPokerHand();
        byte thisPokerType = this.combinedPokerType;
        Vector thisPokerHandCards = this.combinedPokerHandCards;
        if (!combined) {
            thisPokerType = this.pokerType;
            thisPokerHandCards = this.pokerHandCards;
        }
        if (thisPokerType == 10) {
            return "a Royal Flush";
        }
        if (thisPokerType == 9) {
            return "a Straight Flush";
        }
        if (thisPokerType == 8) {
            return GameController.replace("four &1", ((Card)thisPokerHandCards.elementAt(0)).getNumberString((byte)2), null);
        }
        if (thisPokerType == 7) {
            return "a Full House";
        }
        if (thisPokerType == 6) {
            return GameController.replace("a &1 high flush", ((Card)thisPokerHandCards.elementAt(0)).getNumberString((byte)1), null);
        }
        if (thisPokerType == 5) {
            return GameController.replace("a &1 high straight", ((Card)thisPokerHandCards.elementAt(0)).getNumberString((byte)1), null);
        }
        if (thisPokerType == 4) {
            return GameController.replace("three &1", ((Card)thisPokerHandCards.elementAt(0)).getNumberString((byte)2), null);
        }
        if (thisPokerType == 3) {
            return GameController.replace("&1 and &2", ((Card)thisPokerHandCards.elementAt(0)).getNumberString((byte)2), ((Card)thisPokerHandCards.elementAt(2)).getNumberString((byte)2));
        }
        if (thisPokerType == 2) {
            return GameController.replace("a pair of &1", ((Card)thisPokerHandCards.elementAt(0)).getNumberString((byte)2), null);
        }
        if (thisPokerType == 1) {
            return GameController.replace("&1 high", ((Card)thisPokerHandCards.elementAt(0)).getNumberString((byte)1), null);
        }
        return "Unknown";
    }

    public static void sortCards(Vector sortedCards, Vector cards) {
        sortedCards.removeAllElements();
        for (int i = 0; i < cards.size(); ++i) {
            Card card = (Card)cards.elementAt(i);
            boolean inserted = false;
            for (int j = 0; j < sortedCards.size() && !inserted; ++j) {
                if (card.compare((Card)sortedCards.elementAt(j), true) <= 0) continue;
                sortedCards.insertElementAt(card, j);
                inserted = true;
            }
            if (inserted) continue;
            sortedCards.addElement(card);
        }
    }

    public static Card getCard(Vector cards, int i) {
        return (Card)cards.elementAt(i);
    }

    private static boolean checkForStraightQuick(int index, boolean flushRequired, Vector pokerCards, Vector highCards) {
        Card nextCard;
        int i;
        highCards.removeAllElements();
        Card card = Player.getCard(pokerCards, index);
        highCards.addElement(card);
        byte suit = card.suit;
        int number = card.number;
        if (number == 1) {
            number = 14;
        }
        for (i = index + 1; i < pokerCards.size() && highCards.size() < 5; ++i) {
            nextCard = Player.getCard(pokerCards, i);
            if (flushRequired && nextCard.suit != suit || nextCard.number != number - highCards.size()) continue;
            highCards.addElement(nextCard);
        }
        if (number == 5 && highCards.size() == 4) {
            for (i = 0; i < pokerCards.size() && Player.getCard((Vector)pokerCards, (int)i).number == 1; ++i) {
                nextCard = Player.getCard(pokerCards, i);
                if (flushRequired && nextCard.suit != suit) continue;
                highCards.addElement(nextCard);
                return true;
            }
        }
        return highCards.size() == 5;
    }

    private Vector checkForStraights(int index, boolean flushRequired, int minLength, int maxLength, boolean requiresTwoHandCards, int inHandCardCount, Vector sortedCards, Vector pokerHandCards, Vector results) {
        Card nextCard;
        int i;
        Vector bestHand = null;
        Card lastCard = Player.getCard(sortedCards, index);
        pokerHandCards.addElement(lastCard);
        byte lastCardSuit = lastCard.suit;
        byte lastCardNumber = lastCard.number;
        if (lastCardNumber == 1) {
            lastCardNumber = 14;
        }
        Card firstCard = Player.getCard(pokerHandCards, 0);
        int firstCardNumber = firstCard.number;
        if (firstCardNumber == 1) {
            firstCardNumber = 14;
        }
        if (this.cards.contains(lastCard)) {
            ++inHandCardCount;
        }
        int maxIndex = Math.min(sortedCards.size() - 1, sortedCards.size() - minLength + 2);
        for (i = index + 1; maxLength > 1 && i <= maxIndex; ++i) {
            nextCard = Player.getCard(sortedCards, i);
            int nextCardNumber = nextCard.number;
            if (nextCardNumber == 1) {
                nextCardNumber = 14;
            }
            if (!(flushRequired && nextCard.suit != lastCardSuit || nextCard.number >= lastCardNumber || nextCard.number <= firstCardNumber - 5)) {
                Vector straight = this.checkForStraights(i, flushRequired, Math.max(1, minLength - 1), maxLength - 1, requiresTwoHandCards, inHandCardCount, sortedCards, pokerHandCards, results);
                if (straight == null || bestHand != null && straight.size() <= bestHand.size()) continue;
                bestHand = straight;
                continue;
            }
            if (nextCardNumber <= firstCardNumber - 5) break;
        }
        if (firstCardNumber <= 5 && maxLength > 1 && minLength <= 2) {
            for (i = 0; i < sortedCards.size() && Player.getCard((Vector)sortedCards, (int)i).number == 1; ++i) {
                Vector straight;
                nextCard = Player.getCard(sortedCards, i);
                if (flushRequired && nextCard.suit != lastCardSuit || (straight = this.checkForStraights(i, flushRequired, 1, 1, requiresTwoHandCards, inHandCardCount, sortedCards, pokerHandCards, results)) == null || bestHand != null && straight.size() <= bestHand.size()) continue;
                bestHand = straight;
            }
        }
        if (!(minLength != 1 || bestHand != null || requiresTwoHandCards && inHandCardCount != 2)) {
            boolean containedInOther = false;
            for (int i2 = 0; results != null && i2 < results.size() && !containedInOther; ++i2) {
                containedInOther = this.completelyContains((Vector)results.elementAt(i2), pokerHandCards);
            }
            if (!containedInOther) {
                bestHand = this.cloneHand(pokerHandCards);
                if (results != null) {
                    results.addElement(bestHand);
                }
            }
        }
        pokerHandCards.removeElementAt(pokerHandCards.size() - 1);
        return bestHand;
    }

    private Vector checkForFlushes(int index, int minLength, int maxLength, boolean requiresTwoHandCards, int inHandCardCount, Vector sortedCards, Vector pokerHandCards, Vector results) {
        Vector bestHand = null;
        Card lastCard = Player.getCard(sortedCards, index);
        pokerHandCards.addElement(lastCard);
        byte lastCardSuit = lastCard.suit;
        if (this.cards.contains(lastCard)) {
            ++inHandCardCount;
        }
        int maxIndex = Math.min(sortedCards.size() - 1, sortedCards.size() - minLength + 1);
        for (int i = index + 1; maxLength > 1 && i <= maxIndex; ++i) {
            Vector flush;
            Card nextCard = Player.getCard(sortedCards, i);
            if (nextCard.suit != lastCardSuit || (flush = this.checkForFlushes(i, Math.max(1, minLength - 1), maxLength - 1, requiresTwoHandCards, inHandCardCount, sortedCards, pokerHandCards, results)) == null || bestHand != null && flush.size() <= bestHand.size()) continue;
            bestHand = flush;
        }
        if (!(minLength != 1 || bestHand != null || requiresTwoHandCards && inHandCardCount != 2)) {
            boolean containedInOther = false;
            for (int i = 0; results != null && i < results.size() && !containedInOther; ++i) {
                containedInOther = this.completelyContains((Vector)results.elementAt(i), pokerHandCards);
            }
            if (!containedInOther) {
                bestHand = this.cloneHand(pokerHandCards);
                if (results != null) {
                    results.addElement(bestHand);
                }
            }
        }
        pokerHandCards.removeElementAt(pokerHandCards.size() - 1);
        return bestHand;
    }

    private static boolean checkForMultiplesQuick(int index, int firstCardCount, int secondCardCount, Vector pokerCards, Vector highCards) {
        highCards.removeAllElements();
        Card card = Player.getCard(pokerCards, index);
        highCards.addElement(card);
        byte firstNumber = card.number;
        for (int i = index + 1; i < pokerCards.size() && Player.getCard((Vector)pokerCards, (int)i).number == firstNumber && highCards.size() < firstCardCount; ++i) {
            highCards.addElement(Player.getCard(pokerCards, i));
        }
        if (highCards.size() == firstCardCount) {
            int i;
            boolean success = true;
            if (secondCardCount > 0) {
                for (i = 0; i <= pokerCards.size() - secondCardCount && highCards.size() < firstCardCount + secondCardCount; ++i) {
                    Card secondCard = Player.getCard(pokerCards, i);
                    byte secondNumber = secondCard.number;
                    if (secondNumber == firstNumber) continue;
                    while (firstCardCount < highCards.size()) {
                        highCards.removeElementAt(firstCardCount);
                    }
                    highCards.addElement(secondCard);
                    for (int j = i + 1; j < pokerCards.size() && Player.getCard((Vector)pokerCards, (int)j).number == secondNumber && highCards.size() < firstCardCount + secondCardCount; ++j) {
                        highCards.addElement(Player.getCard(pokerCards, j));
                    }
                }
                if (highCards.size() < firstCardCount + secondCardCount) {
                    success = false;
                }
            }
            if (success) {
                for (i = 0; i < pokerCards.size() && highCards.size() < 5; ++i) {
                    Card nextCard = Player.getCard(pokerCards, i);
                    if (highCards.contains(nextCard)) continue;
                    highCards.addElement(nextCard);
                }
                return true;
            }
        }
        return false;
    }

    private Vector checkForMultiples(int index, int firstCardCount, int secondCardCount, boolean requiresTwoHandCards, int inHandCardCount, Vector sortedCards, Vector pokerHandCards) {
        int i;
        Vector bestHand = null;
        Card lastCard = Player.getCard(sortedCards, index);
        pokerHandCards.addElement(lastCard);
        byte lastCardNumber = lastCard.number;
        if (this.cards.contains(lastCard)) {
            ++inHandCardCount;
        }
        int maxIndex = Math.min(sortedCards.size() - 1, sortedCards.size() - firstCardCount + 1);
        for (i = index + 1; firstCardCount > 1 && i <= maxIndex; ++i) {
            Card nextCard = Player.getCard(sortedCards, i);
            if (nextCard.number != lastCardNumber || (bestHand = this.checkForMultiples(i, firstCardCount - 1, secondCardCount, requiresTwoHandCards, inHandCardCount, sortedCards, pokerHandCards)) != null) break;
        }
        if (firstCardCount == 1) {
            if (secondCardCount > 0) {
                int startIndex;
                for (int i2 = startIndex = secondCardCount != pokerHandCards.size() ? 0 : index + 1; i2 <= maxIndex; ++i2) {
                    Card c = Player.getCard(sortedCards, i2);
                    if (c.number == lastCardNumber || (bestHand = this.checkForMultiples(i2, secondCardCount, 0, requiresTwoHandCards, inHandCardCount, sortedCards, pokerHandCards)) == null) {
                        continue;
                    }
                    break;
                }
            } else if (pokerHandCards.size() < sortedCards.size() && pokerHandCards.size() < 5) {
                Card c;
                for (i = 0; i < sortedCards.size() && (pokerHandCards.contains(c = Player.getCard(sortedCards, i)) || (bestHand = this.checkForHighCards(i, requiresTwoHandCards, inHandCardCount, sortedCards, pokerHandCards)) == null); ++i) {
                }
            } else if (!requiresTwoHandCards || inHandCardCount == 2) {
                bestHand = this.cloneHand(pokerHandCards);
            }
        }
        pokerHandCards.removeElementAt(pokerHandCards.size() - 1);
        return bestHand;
    }

    private Vector checkForHighCards(int index, boolean requiresTwoHandCards, int inHandCardCount, Vector sortedCards, Vector pokerHandCards) {
        Card c;
        Vector bestHand = null;
        Card lastCard = Player.getCard(sortedCards, index);
        pokerHandCards.addElement(lastCard);
        if (this.cards.contains(lastCard)) {
            ++inHandCardCount;
        }
        int maxSize = Math.min(sortedCards.size(), 5);
        int maxIndex = sortedCards.size() - (maxSize - pokerHandCards.size());
        for (int i = index + 1; pokerHandCards.size() < maxSize && i <= maxIndex && (pokerHandCards.contains(c = Player.getCard(sortedCards, i)) || (bestHand = this.checkForHighCards(i, requiresTwoHandCards, inHandCardCount, sortedCards, pokerHandCards)) == null); ++i) {
        }
        if (!(pokerHandCards.size() != maxSize || requiresTwoHandCards && inHandCardCount != 2)) {
            bestHand = this.cloneHand(pokerHandCards);
        }
        pokerHandCards.removeElementAt(pokerHandCards.size() - 1);
        return bestHand;
    }

    private boolean completelyContains(Vector outerHand, Vector innerHand) {
        int j = 0;
        int i = 0;
        block0: while (i < innerHand.size() && j < outerHand.size()) {
            Card inner = Player.getCard(innerHand, i);
            while (j < outerHand.size()) {
                Card outer = Player.getCard(outerHand, j);
                if (inner.equals(outer)) {
                    ++j;
                    ++i;
                    continue block0;
                }
                ++j;
            }
        }
        return i == innerHand.size();
    }

    private Vector cloneHand(Vector hand) {
        Vector result = new Vector(hand.size());
        for (int i = 0; i < hand.size(); ++i) {
            result.addElement(hand.elementAt(i));
        }
        return result;
    }
}

