/*
 * Decompiled with CFR 0.152.
 */
package com.concretesoftware.holdem;

import com.concretesoftware.holdem.GameController;
import com.concretesoftware.holdem.Player;
import java.util.Vector;

public class Pot {
    private long amount;
    private long maxBet;
    public long requiredBet;
    public int numberOfBets;
    public long lastBet;
    private Vector players = new Vector();
    private Pot sidePot;
    private Vector winnerPlayers = new Vector();

    public boolean bet(Player player, long existingBet, long newBet, boolean countAsBet) {
        if (player.allIn) {
            return false;
        }
        if (!this.players.contains(player)) {
            this.players.addElement(player);
        }
        if (existingBet + newBet < this.maxBet && newBet >= player.holdings) {
            Pot newPot = new Pot();
            newPot.requiredBet = this.requiredBet - (existingBet + newBet);
            newPot.maxBet = this.maxBet - (existingBet + newBet);
            newPot.numberOfBets = this.numberOfBets;
            for (int i = 0; i < this.players.size(); ++i) {
                Player p = (Player)this.players.elementAt(i);
                if (p.bet <= existingBet + newBet) continue;
                newPot.players.addElement(p);
                newPot.amount += p.bet - (existingBet + newBet);
            }
            this.amount -= newPot.amount;
            this.requiredBet = this.maxBet = existingBet + newBet;
            newPot.sidePot = this.sidePot;
            this.sidePot = newPot;
            this.amount += newBet;
            player.addToBet(newBet);
            player.allIn = true;
        } else {
            if (existingBet + newBet > this.maxBet) {
                this.lastBet = existingBet + newBet - this.maxBet;
                if (this.sidePot != null) {
                    if (existingBet < this.maxBet) {
                        long thisAmt = this.maxBet - existingBet;
                        this.amount += thisAmt;
                        player.addToBet(thisAmt);
                        return this.sidePot.bet(player, 0L, newBet - thisAmt, countAsBet);
                    }
                    return this.sidePot.bet(player, existingBet - this.maxBet, newBet, countAsBet);
                }
                this.amount += newBet;
                player.addToBet(newBet);
                this.maxBet = existingBet + newBet;
                if (this.maxBet > this.requiredBet) {
                    this.requiredBet = this.maxBet;
                }
                if (countAsBet) {
                    ++this.numberOfBets;
                }
                if (player.allIn) {
                    this.sidePot = new Pot();
                    this.sidePot.requiredBet = this.requiredBet - this.maxBet;
                    this.requiredBet = this.maxBet;
                }
                return true;
            }
            this.amount += newBet;
            player.addToBet(newBet);
            if (player.allIn && this.sidePot == null) {
                this.sidePot = new Pot();
                this.sidePot.requiredBet = this.requiredBet - this.maxBet;
                this.requiredBet = this.maxBet;
            }
        }
        return false;
    }

    public void computeWinners() {
        for (int i = 0; i < this.players.size(); ++i) {
            Player p = (Player)this.players.elementAt(i);
            if (!p.inTheGame) continue;
            if (this.winnerPlayers.isEmpty()) {
                this.winnerPlayers.addElement(p);
                continue;
            }
            Player other = (Player)this.winnerPlayers.elementAt(0);
            int comparison = p.compareHands(other);
            if (comparison < 0) continue;
            if (comparison > 0) {
                this.winnerPlayers.removeAllElements();
            }
            this.winnerPlayers.addElement(p);
        }
        if (this.sidePot != null) {
            this.sidePot.computeWinners();
        }
    }

    public Player nextWinner() {
        return !this.winnerPlayers.isEmpty() ? (Player)this.winnerPlayers.elementAt(0) : (this.sidePot != null ? this.sidePot.nextWinner() : null);
    }

    public long win(Player player, boolean countWin) {
        long winnings = 0L;
        if (!this.players.contains(player)) {
            return 0L;
        }
        if (this.winnerPlayers.isEmpty()) {
            winnings = this.amount;
        } else if (this.winnerPlayers.contains(player)) {
            winnings = this.amount / (long)this.winnerPlayers.size();
            this.winnerPlayers.removeElement(player);
        }
        if (winnings > 0L) {
            this.amount -= winnings;
            if (this.players.size() <= 1) {
                player.win(winnings, false);
                winnings = 0L;
            }
        }
        if (this.sidePot != null) {
            winnings += this.sidePot.win(player, false);
        }
        if (countWin) {
            player.win(winnings, true);
        }
        return winnings;
    }

    public void reset() {
        this.players.removeAllElements();
        this.winnerPlayers.removeAllElements();
        this.amount = 0L;
        this.sidePot = null;
        this.clearBet();
    }

    public void clearBet() {
        this.numberOfBets = 0;
        this.maxBet = this.lastBet = (long)0;
        this.requiredBet = this.lastBet;
        if (this.sidePot != null) {
            this.sidePot.clearBet();
        }
    }

    public int getNumberOfBets() {
        if (this.sidePot != null) {
            return this.sidePot.getNumberOfBets();
        }
        return this.numberOfBets;
    }

    public long getRequiredBet() {
        return this.requiredBet + (this.sidePot != null ? this.sidePot.getRequiredBet() : 0L);
    }

    public long getMaxBet() {
        return this.maxBet + (this.sidePot != null ? this.sidePot.getMaxBet() : 0L);
    }

    public long getAmount() {
        return this.amount + (this.sidePot != null ? this.sidePot.getAmount() : 0L);
    }

    public int writeBytes(byte[][] data, int offset) {
        int i;
        offset += GameController.writeLong(this.amount, data, offset);
        offset += GameController.writeLong(this.maxBet, data, offset);
        offset += GameController.writeLong(this.requiredBet, data, offset);
        offset += GameController.writeInt(this.numberOfBets, data, offset);
        offset += GameController.writeLong(this.lastBet, data, offset);
        offset += GameController.writeInt(this.players.size(), data, offset);
        for (i = 0; i < this.players.size(); ++i) {
            offset += GameController.writeInt(((Player)this.players.elementAt((int)i)).recordId, data, offset);
        }
        offset += GameController.writeInt(this.winnerPlayers.size(), data, offset);
        for (i = 0; i < this.winnerPlayers.size(); ++i) {
            offset += GameController.writeInt(((Player)this.winnerPlayers.elementAt((int)i)).recordId, data, offset);
        }
        offset += GameController.writeInt(this.sidePot != null ? 1 : 0, data, offset);
        if (this.sidePot != null) {
            offset = this.sidePot.writeBytes(data, offset);
        }
        return offset;
    }

    public int readBytes(byte[] data, int offset, Vector allPlayers) {
        this.amount = GameController.readLong(data, offset);
        this.maxBet = GameController.readLong(data, offset += 8);
        this.requiredBet = GameController.readLong(data, offset += 8);
        this.numberOfBets = GameController.readInt(data, offset += 8);
        this.lastBet = GameController.readLong(data, offset += 4);
        int playersSize = GameController.readInt(data, offset += 8);
        offset += 4;
        this.players.removeAllElements();
        for (int i = 0; i < playersSize; ++i) {
            this.players.addElement(GameController.getPlayer(GameController.readInt(data, offset), allPlayers));
            offset += 4;
        }
        int winnerPlayersSize = GameController.readInt(data, offset);
        offset += 4;
        this.winnerPlayers.removeAllElements();
        for (int i = 0; i < winnerPlayersSize; ++i) {
            this.winnerPlayers.addElement(GameController.getPlayer(GameController.readInt(data, offset), allPlayers));
            offset += 4;
        }
        this.sidePot = null;
        boolean hasSidePot = GameController.readInt(data, offset) == 1;
        offset += 4;
        if (hasSidePot) {
            this.sidePot = new Pot();
            offset = this.sidePot.readBytes(data, offset, this.players);
        }
        return offset;
    }
}

