/*
 * Decompiled with CFR 0.152.
 */
package com.concretesoftware.holdem;

import com.concretesoftware.holdem.GameController;
import com.concretesoftware.holdem.Holdem;
import com.concretesoftware.holdem.HoldemCanvas;
import com.concretesoftware.holdem.Player;
import com.concretesoftware.holdem.Pot;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Sprite {
    public static final byte OK = -1;
    public static final byte CLEAR = -2;
    public static final byte GENERAL = 0;
    public static final byte HAND_DISPLAY = 1;
    public static final byte MONEY_TEXT = 2;
    public static final byte STRING_MESSAGE = 3;
    public static final byte PLAYER_NAME = 4;
    public static final byte DEALER_MARKER = 5;
    public static final byte PLAYER_DISPLAY = 6;
    public static final byte PLAYER_CONTROLLER = 7;
    public static final byte PLAYER_FACE = 8;
    public static final byte PLAYER_HIGHLIGHT = 9;
    public static final byte PLAYER_MONEY_OR_LAST_BET = 10;
    public static final byte MENU = 11;
    public static final byte CHIPPILE = 12;
    public byte type;
    public byte layer;
    public short[] coords;
    public static final byte IMAGE_BACKGROUND = 1;
    public static final byte BOX_BACKGROUND = 2;
    public static final byte TITLE = 4;
    public static final byte STATIC_IMAGE_ITEMS = 8;
    public static final byte STATIC_BOX_ITEMS = 16;
    public static final byte DYNAMIC_BOX_ITEMS = 32;
    public static final byte AMOUNT = 64;
    public int features;
    public boolean visible = true;
    public int[] colors;
    public Image image;
    public Font font;
    public int anchor = 65;
    public Player player;
    public Pot pot;
    public String prefix = "";
    public static boolean fontsInitialized;
    public static Font largeFont;
    public static Font smallFont;
    public static Font smallSmallFont;
    public String message = "";
    public boolean messageDisplayed;
    public int displayDelayTicksLeft;
    public Sprite[][] playerSprites;
    public byte scrollInfo = (byte)-1;
    public Font titleFont;
    public Font highlightFont;
    String[] titleStrings;
    public short[][] itemCoords;
    private short[] rowWidths;
    private long[] itemIds;
    private String[] itemText;
    public boolean goesAway;
    private long minAmount;
    private long maxAmount;
    public long theAmount;
    private boolean isRaise;
    public boolean hasUpDown = true;
    public boolean upDownReversed;
    private byte selectedItem;
    private boolean itemClicked;
    private boolean itemDisplayed;
    private byte lastX;
    private short itemWidth;
    public byte moveTicksLeft;
    public byte fireTicksLeft;
    public static Sprite scrollLeftArrow;
    public static Sprite scrollRightArrow;
    public static Sprite scrollLeftArrow_highlight;
    public static Sprite scrollRightArrow_highlight;
    private static int scrollingDirection;
    public static boolean isAnimating;
    public static boolean dontAllowScrolling;
    private static int leftPlayerIndexInGame;
    private static int leftPlayerIndexInDisplays;
    public static short leftPlayerX;
    public static short rightPlayerX;
    public static short playerSpacing;
    private static short scrollingAnimationIncrement;
    public static Sprite[] humanSprites;
    public static Vector playerDisplays;
    public static short[][] faceRects;

    public Sprite(int type, int layer, short[] coords, Image image, Font font) {
        this.type = (byte)type;
        this.layer = (byte)layer;
        this.coords = coords;
        this.image = image;
        this.font = font;
        if (!fontsInitialized) {
            fontsInitialized = true;
            largeFont = Font.getFont((int)32, (int)1, (int)0);
            smallFont = Font.getFont((int)32, (int)1, (int)8);
            smallSmallFont = Font.getFont((int)32, (int)0, (int)8);
        }
    }

    public static Sprite createMenu(int layer, int features, short[] coords, Image image, Font font, Font titleFont, int[] colors, String[] titleStrings, short[][] itemCoords, short[] rowWidths, long[] itemIds, String[] itemText) {
        Sprite result = new Sprite(11, layer, coords, image, font);
        result.visible = false;
        result.features = features;
        result.titleFont = titleFont;
        result.colors = colors;
        result.titleStrings = titleStrings;
        result.itemCoords = itemCoords;
        result.rowWidths = rowWidths;
        result.itemIds = itemIds;
        result.itemText = itemText;
        result.goesAway = true;
        return result;
    }

    public static Sprite createPlayerController(Sprite[][] playerSprites, int numberOfDisplays, int leftPlayerX, int playerY, int playerSpacing, HoldemCanvas canvas) {
        Sprite result = new Sprite(7, 0, new short[]{0, 0}, null, null);
        Sprite.leftPlayerX = (short)leftPlayerX;
        Sprite.playerSpacing = (short)playerSpacing;
        rightPlayerX = (short)(leftPlayerX + (numberOfDisplays - 3) * playerSpacing);
        playerDisplays = new Vector(numberOfDisplays);
        for (int i = 0; i < numberOfDisplays; ++i) {
            Sprite s = new Sprite(6, 0, new short[]{0, (short)playerY}, null, null);
            s.playerSprites = playerSprites;
            playerDisplays.addElement(s);
            canvas.addSprite(s);
        }
        return result;
    }

    public void setLocation(int x, int y) {
        this.coords[0] = (short)x;
        this.coords[1] = (short)y;
    }

    public void setPlayerCoords(int leftPlayerX, int playerY, int playerSpacing) {
        Sprite.leftPlayerX = (short)leftPlayerX;
        Sprite.playerSpacing = (short)playerSpacing;
        for (int i = 0; i < playerDisplays.size(); ++i) {
            Sprite s = (Sprite)playerDisplays.elementAt(i);
            s.coords[1] = (short)playerY;
        }
    }

    public void setHandCoords(int x, int y, int xSpacing, int ySpacing) {
        this.coords[0] = (short)x;
        this.coords[1] = (short)y;
        this.coords[2] = (byte)xSpacing;
        this.coords[3] = (byte)ySpacing;
    }

    public void setMessage(String message, int displayDelayTicks) {
        this.message = message;
        this.displayDelayTicksLeft = displayDelayTicks;
        this.messageDisplayed = false;
    }

    public void paint(Graphics g, byte layer) {
        if (this.visible) {
            this.paint(g, layer, this.coords[0], this.coords[1], this.player);
        }
    }

    public void paint(Graphics g, byte layer, int x, int y, Player player) {
        if (!(this.layer == layer && this.visible || this.type == 6)) {
            return;
        }
        boolean highlighted = false;
        if (player != null) {
            boolean bl = highlighted = (this.type != 2 || this.coords[2] != 1) && GameController.instance.getCurrentPlayer() == player;
            if (this.font != null && highlighted) {
                g.setColor(0xFFFF00);
            }
        }
        if (this.font != null) {
            if (highlighted) {
                // empty if block
            }
            g.setFont(this.font);
            if (!highlighted) {
                g.setColor(this.colors != null ? this.colors[0] : 0);
            }
        }
        switch (this.type) {
            case 1: {
                if (player == null || player.type != 3 && !player.inTheGame) break;
                for (int i = 0; i < player.cards.size(); ++i) {
                    if (this.coords[4] == 1 && player.displayCards) {
                        player.getCard(i).paint(g, x + i * this.coords[2], y + i * this.coords[3], this.coords[5]);
                        continue;
                    }
                    if (this.image == null || player.displayCards) continue;
                    Sprite.drawImagePart(g, x + i * this.coords[2], y + i * this.coords[3], this.coords[6], this.coords[7], this.coords[8], this.coords[9], this.image);
                }
                break;
            }
            case 2: {
                long amount;
                if (player == null && this.pot == null) break;
                long l = this.pot != null ? this.pot.getAmount() : (amount = this.coords[2] == 1 ? player.bet : player.holdings);
                if (amount < 0L) break;
                g.drawString(this.prefix + GameController.toMoney(amount), x, y, this.anchor);
                break;
            }
            case 10: {
                String value;
                if (player == null || (value = player.getMoneyOrLastBet()).length() <= 0) break;
                g.drawString(value, x, y, this.anchor);
                break;
            }
            case 3: {
                if (this.message == null || this.message.equals("")) break;
                if (this.font == null) {
                    if (largeFont != null && largeFont.stringWidth(this.message) < this.coords[2]) {
                        g.setFont(largeFont);
                    } else if (smallFont != null && smallFont.stringWidth(this.message) < this.coords[2]) {
                        g.setFont(smallFont);
                    } else {
                        g.setFont(smallSmallFont);
                    }
                    g.setColor(0);
                }
                g.drawString(this.message, x, y, this.anchor);
                this.messageDisplayed = true;
                break;
            }
            case 4: {
                if (player == null) break;
                g.drawString(player.name, x, y, this.anchor);
                break;
            }
            case 8: {
                if (player == null || player.faceIndex < 0 || player.faceIndex >= 8) break;
                g.drawImage(HoldemCanvas.faceImages[player.faceIndex], x, y, 20);
                break;
            }
            case 6: {
                if (player == null || player.respawning) break;
                if (this.scrollInfo == -1) {
                    this.scrollInfo = GameController.instance.getPlayerScrollInfo(player);
                }
                if (x <= leftPlayerX - playerSpacing || x >= rightPlayerX + playerSpacing) break;
                Sprite[] sprites = this.playerSprites[this.scrollInfo];
                for (int i = 0; i < sprites.length; ++i) {
                    Sprite s = sprites[i];
                    if (s == null) continue;
                    s.paint(g, layer, x + s.coords[0], y + s.coords[1], player);
                }
                break;
            }
            case 7: {
                byte leftSpriteIndex = this.getLeftSpriteOnScreen();
                Sprite leftSprite = (Sprite)playerDisplays.elementAt(leftSpriteIndex);
                if (leftSprite.player != null && leftSpriteIndex - leftPlayerIndexInDisplays + leftPlayerIndexInGame > 1 && GameController.instance.getPlayerScrollInfo(leftSprite.player) == 1) {
                    if (isAnimating && scrollingDirection < 0) {
                        scrollLeftArrow_highlight.paint(g, layer);
                    } else {
                        scrollLeftArrow.paint(g, layer);
                    }
                }
                Sprite rightSprite = null;
                int rightSpriteIndex = 0;
                for (int i = 0; i < playerDisplays.size(); i = (int)((byte)(i + 1))) {
                    Sprite s = (Sprite)playerDisplays.elementAt(i);
                    if (s.player == null || s.coords[0] > rightPlayerX || rightSprite != null && rightPlayerX - s.coords[0] >= rightPlayerX - rightSprite.coords[0]) continue;
                    rightSprite = s;
                    rightSpriteIndex = i;
                }
                if (rightSprite == null || rightSprite.player == null || rightSpriteIndex - leftPlayerIndexInDisplays + leftPlayerIndexInGame >= GameController.instance.players.size() - 1 || GameController.instance.getPlayerScrollInfo(rightSprite.player) != 1) break;
                if (isAnimating && scrollingDirection > 0) {
                    scrollRightArrow_highlight.paint(g, layer);
                    break;
                }
                scrollRightArrow.paint(g, layer);
                break;
            }
            case 11: {
                int i = 5;
                g.setStrokeStyle(0);
                if ((this.features & 1) != 0) {
                    Sprite.drawImagePart(g, x, y, this.coords[i], this.coords[i + 1], this.coords[i + 2], this.coords[i + 3], this.image);
                    i += 4;
                }
                if (this.font != null) {
                    g.setFont(this.font);
                }
                for (int j = 0; this.itemIds != null && j < this.itemIds.length; ++j) {
                    if ((this.features & 8) != 0) {
                        if (j != this.selectedItem) continue;
                        Sprite.drawImagePart(g, this.itemCoords[j][0], this.itemCoords[j][1], this.itemCoords[j][2], this.itemCoords[j][3], this.itemCoords[j][4], this.itemCoords[j][5], this.image);
                        continue;
                    }
                    if ((this.features & 0x20) == 0) continue;
                    int itemX = x + this.coords[i + 2] * (j - this.itemIds.length);
                    int itemY = y + this.coords[i + 3] * (j - this.itemIds.length);
                    g.setColor(j == this.selectedItem ? this.colors[5] : this.colors[3]);
                    g.fillRect(itemX, itemY, (int)this.itemWidth, (int)this.coords[i + 1]);
                    g.setColor(0);
                    g.drawRect(itemX, itemY, (int)this.itemWidth, (int)this.coords[i + 1]);
                    g.setColor(j == this.selectedItem ? this.colors[6] : this.colors[4]);
                    g.setFont(this.font);
                    g.drawString(this.itemText[j], itemX + this.coords[i + 4], itemY + this.coords[i + 1] + this.coords[i + 5], 68);
                }
                if ((this.features & 0x20) != 0) {
                    i += 6;
                }
                if ((this.features & 0x40) != 0) {
                    g.setColor(0);
                    g.setFont(this.font);
                    g.drawString(GameController.toMoney(this.theAmount), (int)this.coords[i], (int)this.coords[i + 1], 72);
                    i += 2;
                }
                if (!this.itemClicked) break;
                this.itemDisplayed = true;
                break;
            }
            case 9: {
                if (this.image != null || !highlighted) break;
                g.setStrokeStyle(0);
                g.setColor(this.colors != null ? this.colors[0] : 0);
                g.drawRect(x, y, (int)this.coords[2], (int)this.coords[3]);
                break;
            }
            default: {
                if (this.type == 5 && (player == null || GameController.instance.getDealerPlayer() != player) || this.type == 9 && !highlighted) {
                    return;
                }
                if (this.image == null) break;
                if (this.coords[4] == 0) {
                    g.drawImage(this.image, x, y, 20);
                    break;
                }
                Sprite.drawImagePart(g, x, y, this.coords[2], this.coords[3], this.coords[4], this.coords[5], this.image);
            }
        }
    }

    public Sprite clone(int x, int y) {
        short[] newCoords = new short[this.coords.length];
        System.arraycopy(this.coords, 0, newCoords, 0, this.coords.length);
        newCoords[0] = (short)x;
        newCoords[1] = (short)y;
        Sprite result = new Sprite(this.type, this.layer, newCoords, this.image, this.font);
        result.colors = this.colors;
        result.visible = this.visible;
        result.anchor = this.anchor;
        return result;
    }

    public void show(long[] itemIds, String[] itemText, int selectedItem) {
        if (itemIds != null) {
            this.itemIds = itemIds;
        }
        if (itemText != null) {
            this.itemText = itemText;
        }
        if (this.features == 32) {
            int maxWidth = 0;
            for (int i = 0; this.itemText != null && this.font != null && i < this.itemText.length; ++i) {
                maxWidth = Math.max(maxWidth, this.font.stringWidth(this.itemText[i]));
            }
            this.itemWidth = (short)(this.coords[9] + maxWidth + this.coords[5]);
        }
        this.selectedItem = (byte)selectedItem;
        this.visible = true;
        this.fireTicksLeft = 0;
        this.moveTicksLeft = 0;
        this.itemDisplayed = false;
        this.itemClicked = false;
    }

    public void show(long minAmount, long maxAmount, boolean isRaise) {
        this.minAmount = minAmount;
        this.maxAmount = maxAmount;
        this.isRaise = isRaise;
        this.theAmount = 0L;
        this.visible = true;
        this.fireTicksLeft = 0;
        this.moveTicksLeft = 0;
        this.selectedItem = 1;
        this.itemDisplayed = false;
        this.itemClicked = false;
        this.lastX = 0;
    }

    public void hide() {
        this.visible = false;
        this.fireTicksLeft = 0;
        this.moveTicksLeft = 0;
        this.itemDisplayed = false;
        this.itemClicked = false;
    }

    public Player lookForPlayerFace(int x, int y) {
        for (int i = 0; i < playerDisplays.size(); ++i) {
            short[] rect;
            Sprite playerDisplay = (Sprite)playerDisplays.elementAt(i);
            if (playerDisplay.player == null || playerDisplay.player.respawning) continue;
            if (playerDisplay.scrollInfo == -1) {
                playerDisplay.scrollInfo = GameController.instance.getPlayerScrollInfo(playerDisplay.player);
            }
            if (!GameController.isWithinRect(x, y, playerDisplay.coords[0] + (rect = faceRects[playerDisplay.scrollInfo])[0], playerDisplay.coords[1] + rect[1], rect[2], rect[3])) continue;
            return playerDisplay.player;
        }
        return null;
    }

    public boolean update(int action, int clickX, int clickY, int shortcutId) {
        if (this.type == 3) {
            if (this.displayDelayTicksLeft > 0) {
                --this.displayDelayTicksLeft;
                return true;
            }
            if (!(this.message == null || this.message.equals("") || this.messageDisplayed && this.displayDelayTicksLeft >= 0)) {
                return true;
            }
            this.message = "";
        } else {
            if (this.type == 11) {
                if (this.itemClicked && !this.itemDisplayed) {
                    return false;
                }
                if (this.itemDisplayed) {
                    this.itemDisplayed = false;
                    this.itemClicked = false;
                    this.choose(this.itemIds[this.selectedItem]);
                    return true;
                }
                if ((this.features & 0x40) != 0 && action == -101) {
                    this.theAmount = Math.min(this.maxAmount, 10L * this.theAmount + (long)shortcutId);
                    return true;
                }
                if (this.fireTicksLeft > 0) {
                    this.fireTicksLeft = (byte)(this.fireTicksLeft - 1);
                } else if (this.selectedItem >= 0 && (action == 8 || this.coords[2] > 0 && action == -6)) {
                    this.choose(this.itemIds[this.selectedItem]);
                    this.fireTicksLeft = (byte)this.coords[4];
                    return true;
                }
                if (action == -100) {
                    this.fireTicksLeft = 0;
                    this.moveTicksLeft = 0;
                    if (this.goesAway && ((this.features & 1) != 0 ? !GameController.isWithinRect(clickX, clickY, this.coords[0], this.coords[1], this.coords[7], this.coords[8]) : this.features == 32 && !GameController.isWithinRect(clickX, clickY, this.coords[0] - this.coords[7] * this.itemIds.length, this.coords[1] - this.coords[8] * this.itemIds.length, this.coords[7] * (this.itemIds.length - 1) + this.itemWidth, this.coords[8] * (this.itemIds.length - 1) + this.coords[6]))) {
                        this.hide();
                        return true;
                    }
                    for (int i = 0; i < this.itemIds.length; i = (int)((byte)(i + 1))) {
                        if (!GameController.isWithinRect(clickX, clickY, this.itemCoords != null ? this.itemCoords[i][0] : this.coords[0] + this.coords[7] * (i - this.itemIds.length), this.itemCoords != null ? this.itemCoords[i][1] : this.coords[1] + this.coords[8] * (i - this.itemIds.length), this.itemCoords != null ? this.itemCoords[i][4] : this.itemWidth, this.itemCoords != null ? this.itemCoords[i][5] : this.coords[6])) continue;
                        if (i != this.selectedItem && ((this.features & 0x40) != 0 || this.itemIds[i] == -1L)) {
                            this.selectedItem = (byte)i;
                            this.itemClicked = true;
                        } else {
                            this.selectedItem = (byte)i;
                            this.choose(this.itemIds[i]);
                        }
                        return true;
                    }
                }
                if (this.moveTicksLeft > 0) {
                    this.moveTicksLeft = (byte)(this.moveTicksLeft - 1);
                    return false;
                }
                if ((action == 6 || action == 1) && (this.features & 0x40) != 0 && this.hasUpDown) {
                    int y;
                    this.fireTicksLeft = 0;
                    int x = 0;
                    int item = 0;
                    for (y = 0; y < this.rowWidths.length; ++y) {
                        if (this.selectedItem < item + this.rowWidths[y]) {
                            x = this.selectedItem - item;
                            break;
                        }
                        item += this.rowWidths[y];
                    }
                    if (this.rowWidths[y] == 1) {
                        x = this.lastX;
                    }
                    if (action == 6 && y < this.rowWidths.length - 1) {
                        if (this.rowWidths[y + 1] == 1 && this.rowWidths[y] > 1) {
                            this.lastX = (byte)x;
                        }
                        this.selectedItem = (byte)(item + this.rowWidths[y] + Math.min(x, this.rowWidths[y + 1] - 1));
                        this.moveTicksLeft = (byte)this.coords[3];
                        return true;
                    }
                    if (action == 1 && y > 0) {
                        if (this.rowWidths[y - 1] == 1 && this.rowWidths[y] > 1) {
                            this.lastX = (byte)x;
                        }
                        this.selectedItem = (byte)(item - this.rowWidths[y - 1] + Math.min(x, this.rowWidths[y - 1] - 1));
                        this.moveTicksLeft = (byte)this.coords[3];
                        return true;
                    }
                } else if (action == 6 && !this.upDownReversed || action == 1 && this.upDownReversed || action == 5) {
                    if (this.selectedItem < this.itemIds.length - 1) {
                        this.selectedItem = (byte)(this.selectedItem + 1);
                        this.fireTicksLeft = 0;
                        this.moveTicksLeft = (byte)this.coords[3];
                        return true;
                    }
                } else if ((action == 1 && !this.upDownReversed || action == 6 && this.upDownReversed || action == 2) && this.selectedItem > 0) {
                    this.selectedItem = (byte)(this.selectedItem - 1);
                    this.fireTicksLeft = 0;
                    this.moveTicksLeft = (byte)this.coords[3];
                    return true;
                }
                return false;
            }
            if (this.type == 7 && isAnimating) {
                boolean hasAnimations = false;
                for (int i = 0; i < playerDisplays.size(); ++i) {
                    Sprite s = (Sprite)playerDisplays.elementAt(i);
                    short targetX = this.getTargetX(i);
                    if (s.player == null || s.player.respawning) {
                        s.coords[0] = targetX;
                        continue;
                    }
                    if (s.coords[0] > targetX) {
                        s.coords[0] = (short)Math.max(targetX, s.coords[0] - scrollingAnimationIncrement);
                        hasAnimations = true;
                        if (s.coords[0] != targetX) continue;
                        s.scrollInfo = GameController.instance.getPlayerScrollInfo(s.player);
                        continue;
                    }
                    if (s.coords[0] >= targetX) continue;
                    s.coords[0] = (short)Math.min(targetX, s.coords[0] + scrollingAnimationIncrement);
                    hasAnimations = true;
                    if (s.coords[0] != targetX) continue;
                    s.scrollInfo = GameController.instance.getPlayerScrollInfo(s.player);
                }
                if (((Sprite)Sprite.playerDisplays.elementAt((int)0)).coords[0] >= leftPlayerX) {
                    this.repopulate(playerDisplays.size() - 1);
                } else if (((Sprite)Sprite.playerDisplays.elementAt((int)(Sprite.playerDisplays.size() - 1))).coords[0] <= rightPlayerX) {
                    this.repopulate(0);
                }
                int oldScrollingDirection = scrollingDirection;
                isAnimating = hasAnimations;
                if (!hasAnimations) {
                    dontAllowScrolling = false;
                    scrollingAnimationIncrement = 0;
                    scrollingDirection = 0;
                }
                return hasAnimations || oldScrollingDirection != scrollingDirection;
            }
        }
        return false;
    }

    public void choose(long value) {
        if ((this.features & 0x40) != 0) {
            if (value == -1L) {
                if (this.theAmount >= this.minAmount) {
                    this.hide();
                    Holdem.gameCanvas.amountEntered(this.theAmount, this.isRaise);
                } else {
                    this.theAmount = this.minAmount;
                }
            } else {
                this.theAmount = value == -2L ? 0L : Math.min(this.maxAmount, this.theAmount + value);
            }
        } else if (Holdem.gameCanvas.menuChoice(this, value)) {
            this.hide();
        }
    }

    public void recomputePlayers() {
        int visibleDisplaysCount;
        dontAllowScrolling = false;
        isAnimating = false;
        scrollingAnimationIncrement = 0;
        scrollingDirection = 0;
        for (int i = 0; i < humanSprites.length; ++i) {
            if (humanSprites[i] == null) continue;
            Sprite.humanSprites[i].player = GameController.instance.humanPlayer;
        }
        Vector players = GameController.instance.players;
        int otherPlayersCount = players.size() - 1;
        if (otherPlayersCount < (visibleDisplaysCount = playerDisplays.size() - 2)) {
            leftPlayerIndexInDisplays = 1;
            leftPlayerIndexInGame = 1;
        } else {
            leftPlayerIndexInDisplays = 1;
            leftPlayerIndexInGame = Math.min(otherPlayersCount - visibleDisplaysCount + 1, Math.max(1, leftPlayerIndexInGame));
        }
        for (int i = 0; i < playerDisplays.size(); ++i) {
            this.initPlayerDisplay(i, false);
        }
    }

    public boolean scroll(boolean left) {
        scrollingDirection = left ? -1 : 1;
        Vector players = GameController.instance.players;
        if (!dontAllowScrolling) {
            if (left && leftPlayerIndexInGame > 1) {
                --leftPlayerIndexInGame;
                --leftPlayerIndexInDisplays;
                return this.startScrollingAnimating(false);
            }
            if (!left && leftPlayerIndexInGame < players.size() - 1 - (playerDisplays.size() - 2) + 1) {
                ++leftPlayerIndexInGame;
                ++leftPlayerIndexInDisplays;
                return this.startScrollingAnimating(false);
            }
        }
        return false;
    }

    public static boolean isVisible(Player p) {
        for (int i = 0; i < playerDisplays.size(); ++i) {
            Sprite playerDisplay = (Sprite)playerDisplays.elementAt(i);
            if (playerDisplay.player != p) continue;
            return playerDisplay.coords[0] > leftPlayerX - playerSpacing && playerDisplay.coords[0] < rightPlayerX + playerSpacing;
        }
        return false;
    }

    public boolean makePlayerVisible(Player p) {
        scrollingDirection = 0;
        Vector players = GameController.instance.players;
        short gameIndex = (short)players.indexOf(p);
        if (gameIndex >= 1) {
            int displayOffset = gameIndex - leftPlayerIndexInGame;
            if (displayOffset < 0) {
                leftPlayerIndexInDisplays += displayOffset;
                leftPlayerIndexInGame = gameIndex;
                return this.startScrollingAnimating(true);
            }
            if (displayOffset >= playerDisplays.size() - 2) {
                leftPlayerIndexInDisplays += displayOffset - (playerDisplays.size() - 3);
                leftPlayerIndexInGame = gameIndex - (playerDisplays.size() - 3);
                return this.startScrollingAnimating(true);
            }
        }
        return false;
    }

    public boolean removePlayer(Player p) {
        Vector players = GameController.instance.players;
        int gameIndex = players.indexOf(p);
        if (gameIndex >= 1) {
            int displayIndex = leftPlayerIndexInDisplays + (gameIndex - leftPlayerIndexInGame);
            if (gameIndex < leftPlayerIndexInGame) {
                --leftPlayerIndexInGame;
            }
            players.removeElementAt(gameIndex);
            if (displayIndex >= 0 && displayIndex < playerDisplays.size()) {
                this.repopulate(displayIndex);
                int diff = leftPlayerIndexInGame - (players.size() - 1 - (playerDisplays.size() - 2) + 1);
                if (diff > 0 && players.size() - 1 >= playerDisplays.size() - 2) {
                    leftPlayerIndexInDisplays -= diff;
                    leftPlayerIndexInGame -= diff;
                }
                if (gameIndex == 1 || gameIndex == players.size()) {
                    int newDisplayIndex;
                    if (gameIndex == players.size()) {
                        --gameIndex;
                    }
                    if ((newDisplayIndex = leftPlayerIndexInDisplays + gameIndex - leftPlayerIndexInGame) >= 0 && newDisplayIndex < playerDisplays.size()) {
                        short targetX = this.getTargetX(newDisplayIndex);
                        Sprite s = (Sprite)playerDisplays.elementAt(newDisplayIndex);
                        if (s.coords[0] == targetX && s.player != null) {
                            s.scrollInfo = GameController.instance.getPlayerScrollInfo(s.player);
                        }
                    }
                }
                if (displayIndex >= 1 && displayIndex <= playerDisplays.size() - 2 && players.size() > 1) {
                    return this.startScrollingAnimating(false);
                }
            }
        }
        return false;
    }

    private void repopulate(int displayIndex) {
        Sprite s = (Sprite)playerDisplays.elementAt(displayIndex);
        playerDisplays.removeElementAt(displayIndex);
        if (displayIndex < leftPlayerIndexInDisplays) {
            --leftPlayerIndexInDisplays;
        }
        Sprite rightOffscreen = (Sprite)playerDisplays.elementAt(playerDisplays.size() - 1);
        Sprite leftOffscreen = (Sprite)playerDisplays.elementAt(0);
        if (leftOffscreen.coords[0] >= leftPlayerX) {
            playerDisplays.insertElementAt(s, 0);
            ++leftPlayerIndexInDisplays;
            this.initPlayerDisplay(0, true);
        } else {
            playerDisplays.addElement(s);
            this.initPlayerDisplay(playerDisplays.size() - 1, true);
        }
    }

    private void initPlayerDisplay(int i, boolean repopulating) {
        Vector players = GameController.instance.players;
        Sprite s = (Sprite)playerDisplays.elementAt(i);
        s.coords[0] = repopulating ? (short)(i == 0 ? ((Sprite)Sprite.playerDisplays.elementAt((int)1)).coords[0] - playerSpacing : (i == 1 ? leftPlayerX : ((Sprite)Sprite.playerDisplays.elementAt((int)(i - 1))).coords[0] + playerSpacing)) : this.getTargetX(i);
        int index = i - leftPlayerIndexInDisplays + leftPlayerIndexInGame;
        if (index >= 1 && index < players.size()) {
            s.player = (Player)players.elementAt(index);
            s.scrollInfo = GameController.instance.getPlayerScrollInfo(s.player);
        } else {
            s.player = null;
            s.scrollInfo = (byte)-1;
        }
    }

    private short getTargetX(int displayIndex) {
        Vector players = GameController.instance.players;
        if (players.size() - 1 == 3 && displayIndex == leftPlayerIndexInDisplays + 1) {
            return (short)(leftPlayerX + (playerDisplays.size() - 3) * playerSpacing / 2);
        }
        if (players.size() - 1 == 1 && displayIndex == leftPlayerIndexInDisplays) {
            return (short)(leftPlayerX + (playerDisplays.size() - 3) * playerSpacing / 2);
        }
        if (players.size() - 1 < playerDisplays.size() - 2 && displayIndex == leftPlayerIndexInDisplays + players.size() - 2) {
            return (short)(leftPlayerX + (playerDisplays.size() - 3) * playerSpacing);
        }
        return (short)(leftPlayerX + (displayIndex - leftPlayerIndexInDisplays) * playerSpacing);
    }

    private boolean startScrollingAnimating(boolean dontAllowScrolling) {
        Sprite.dontAllowScrolling = Sprite.dontAllowScrolling || dontAllowScrolling;
        isAnimating = true;
        if (GameController.gameSpeedSetting == 4) {
            scrollingAnimationIncrement = !GameController.instance.humanPlayer.inTheGame && GameController.fastAfterHumanFoldSetting ? (short)30 : (short)10;
        } else if (!GameController.instance.humanPlayer.inTheGame && GameController.fastAfterHumanFoldSetting) {
            scrollingAnimationIncrement = (short)10;
        }
        byte leftSpriteIndex = this.getLeftSpriteOnScreen();
        int diff = Math.abs(leftSpriteIndex - leftPlayerIndexInDisplays);
        scrollingAnimationIncrement = diff >= 3 ? (short)Math.max(scrollingAnimationIncrement, 7) : (diff == 2 ? (short)Math.max(scrollingAnimationIncrement, 5) : (short)Math.max(scrollingAnimationIncrement, 3));
        return this.update(0, 0, 0, 0);
    }

    private byte getLeftSpriteOnScreen() {
        Sprite leftSprite = null;
        int leftSpriteIndex = 0;
        for (int i = 0; i < playerDisplays.size(); i = (int)((byte)(i + 1))) {
            Sprite s = (Sprite)playerDisplays.elementAt(i);
            if (s.player == null || s.coords[0] < leftPlayerX || leftSprite != null && s.coords[0] - leftPlayerX >= leftSprite.coords[0] - leftPlayerX) continue;
            leftSpriteIndex = i;
            leftSprite = s;
        }
        return (byte)leftSpriteIndex;
    }

    public String toString() {
        String className = this.getClass().getName();
        return className.substring(className.lastIndexOf(46) + 1) + ":" + this.type;
    }

    public static void drawImagePart(Graphics g, int x, int y, int imageXOffset, int imageYOffset, int imageWidth, int imageHeight, Image image) {
        int origClipX = g.getClipX();
        int origClipY = g.getClipY();
        int origClipWidth = g.getClipWidth();
        int origClipHeight = g.getClipHeight();
        if (x < 0) {
            imageWidth += x;
            imageXOffset -= x;
            x = 0;
        }
        if (y < 0) {
            imageHeight += y;
            imageYOffset -= y;
            y = 0;
        }
        if (x + imageWidth > origClipWidth) {
            imageWidth -= x + imageWidth - origClipWidth;
        }
        if (y + imageHeight > origClipHeight) {
            imageHeight -= y + imageHeight - origClipHeight;
        }
        if (imageWidth > 0 && imageHeight > 0) {
            g.clipRect(x, y, imageWidth, imageHeight);
            g.drawImage(image, x - imageXOffset, y - imageYOffset, 20);
            g.setClip(origClipX, origClipY, origClipWidth, origClipHeight);
        }
    }

    public static int computeStringWidth(String s, int lowercaseCharWidth, int uppercaseCharWidth) {
        int total = 0;
        for (int i = 0; s != null && i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= 'a' && c <= 'z' || c == '!' || c == ',' || c == ' ' || c == '.' || c == ';' || c == '\"' || c == '\'' || c == ':' || c == '*' || c == '1') {
                total += lowercaseCharWidth;
                continue;
            }
            total += uppercaseCharWidth;
        }
        return total;
    }
}

