/*
 * Decompiled with CFR 0.152.
 */
package arrorpig;

import arrorpig.ArrorCanvas;
import arrorpig.StartDisp;
import arrorpig.Topten;

public class Runman
implements Runnable {
    public static final byte STOP = 0;
    public static final byte RUNNING = 1;
    public static final byte PAUSE = 2;
    public static final byte START = 3;
    public static final byte RESUME = 4;
    private ArrorCanvas catDisp = null;
    private StartDisp startDisp = null;
    private Topten topten = null;
    private int nTimer = 50;
    private Thread thread = null;
    private byte nStatus = 0;

    public Runman(ArrorCanvas d, int n) {
        this.catDisp = d;
        this.nTimer = n;
    }

    public Runman(Topten top, int n) {
        this.topten = top;
        this.nTimer = n;
    }

    public Runman(StartDisp d, int n) {
        this.startDisp = d;
        this.nTimer = n;
    }

    byte getStatus() {
        return this.nStatus;
    }

    void setTimer(int t) {
        this.nTimer = t;
    }

    public void run() {
        long t1 = System.currentTimeMillis();
        while (this.nStatus == 1) {
            try {
                if (this.catDisp != null) {
                    this.catDisp.run();
                } else if (this.startDisp != null) {
                    this.startDisp.run();
                } else if (this.topten != null) {
                    this.topten.run();
                }
                long t2 = System.currentTimeMillis();
                if (t2 - t1 < (long)this.nTimer) {
                    Thread.sleep((long)this.nTimer - (t2 - t1));
                }
                t1 = System.currentTimeMillis();
            }
            catch (Exception exception) {}
        }
    }

    boolean start() {
        if (this.nStatus != 0) {
            return false;
        }
        this.nStatus = 1;
        this.thread = new Thread(this);
        this.thread.start();
        return true;
    }

    boolean canDO(byte s) {
        switch (s) {
            case 3: {
                if (this.nStatus == 0) break;
                return false;
            }
            case 0: {
                if (this.nStatus == 1 || this.nStatus == 2) break;
                return false;
            }
            case 2: {
                if (this.nStatus == 1) break;
                return false;
            }
            case 4: {
                if (this.nStatus == 2) break;
                return false;
            }
        }
        return true;
    }

    boolean resume() {
        if (this.nStatus != 2) {
            return false;
        }
        this.nStatus = 1;
        this.thread = new Thread(this);
        this.thread.start();
        return true;
    }

    boolean stop() {
        if (this.nStatus == 0) {
            return false;
        }
        this.thread = null;
        this.nStatus = 0;
        return true;
    }

    boolean pause() {
        if (this.nStatus != 1) {
            return false;
        }
        this.thread = null;
        this.nStatus = (byte)2;
        return true;
    }

    static {
        STOP = 0;
        RUNNING = 1;
        PAUSE = (byte)2;
        START = (byte)3;
        RESUME = (byte)4;
    }
}

