/*
 * Decompiled with CFR 0.152.
 */
package BurgerKing;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class BurgerDisplay {
    private static final Image logoImage;
    private static final Image titleImage;
    private static final Image pressKeyImage;
    private static final Image screenImage;
    private static final Image gameOverImage;
    private static final Image[] digitImage;
    private static final Image[] pieceImage;
    private static final int digitWidth;
    private static final int digitHeight;
    private static final int scoreXBase;
    private static final int scoreYBase;
    private static final int makeXBase;
    private static final int makeYBase;
    private static final int[] height;
    private static final int[] stackHeight;

    public void drawScreen(int stage, int[] x, int[] y, boolean[] isReal, int[] type, int numPieces, int score, Graphics g) {
        switch (stage) {
            case 10: {
                this.drawLogoScreen(g);
                break;
            }
            case 20: {
                this.drawBackground(g);
                this.drawScore(0, g);
                this.drawTitleScreen(g);
                break;
            }
            case 30: 
            case 40: 
            case 50: {
                this.drawBackground(g);
                this.drawScore(score, g);
                this.drawMake(isReal, type, numPieces, g);
                this.drawPieces(x, y, type, numPieces, g);
                break;
            }
            case 60: {
                this.drawGameOver(g);
            }
        }
    }

    private void drawLogoScreen(Graphics g) {
        g.drawImage(logoImage, 27, 71, 20);
    }

    private void drawTitleScreen(Graphics g) {
        g.drawImage(titleImage, 14, 29, 20);
        g.drawImage(pressKeyImage, 12, 194, 20);
    }

    private void drawBackground(Graphics g) {
        g.drawImage(screenImage, 0, 0, 20);
    }

    private void drawScore(int score, Graphics g) {
        g.drawImage(digitImage[score / 10000], scoreXBase, scoreYBase, 20);
        g.drawImage(digitImage[score % 10000 / 1000], scoreXBase + digitWidth, scoreYBase, 20);
        g.drawImage(digitImage[score % 1000 / 100], scoreXBase + 2 * digitWidth, scoreYBase, 20);
        g.drawImage(digitImage[score % 100 / 10], scoreXBase + 3 * digitWidth, scoreYBase, 20);
        g.drawImage(digitImage[score % 10], scoreXBase + 4 * digitWidth, scoreYBase, 20);
    }

    private void drawMake(boolean[] isReal, int[] type, int numPieces, Graphics g) {
        int yPos = makeYBase;
        int lastReal = 0;
        for (int i = 0; i < numPieces; ++i) {
            if (!isReal[i]) continue;
            yPos = i == 0 ? (yPos -= height[0]) : (yPos -= height[type[i]] - (height[type[lastReal]] - stackHeight[type[lastReal]]));
            g.drawImage(pieceImage[type[i]], makeXBase, yPos, 20);
            lastReal = i;
        }
    }

    private void drawPieces(int[] x, int[] y, int[] type, int numPieces, Graphics g) {
        for (int i = 0; i < numPieces; ++i) {
            if (y[i] < 0) continue;
            g.drawImage(pieceImage[type[i]], x[i], y[i], 20);
        }
    }

    private void drawGameOver(Graphics g) {
        g.drawImage(gameOverImage, 8, 82, 20);
        g.drawImage(pressKeyImage, 35, 108, 20);
    }

    private static Image loadImage(String imageFile) {
        Image image = null;
        try {
            image = Image.createImage((String)imageFile);
        }
        catch (Exception e) {
            System.out.println("Error loading image: ".concat(String.valueOf(String.valueOf(imageFile))));
        }
        return image;
    }

    static {
        int i;
        scoreXBase = 32;
        scoreYBase = 2;
        makeXBase = 131;
        makeYBase = 195;
        height = new int[]{12, 16, 9, 12, 9, 11, 11, 14, 14};
        stackHeight = new int[]{7, 16, 5, 4, 4, 4, 5, 5, 6};
        logoImage = BurgerDisplay.loadImage("/GameisLive.png");
        titleImage = BurgerDisplay.loadImage("/Title.png");
        pressKeyImage = BurgerDisplay.loadImage("/PressKey.png");
        screenImage = BurgerDisplay.loadImage("/GameScreen.png");
        gameOverImage = BurgerDisplay.loadImage("/GameOver.png");
        Image fontImage = BurgerDisplay.loadImage("/Digits.png");
        digitWidth = fontImage.getWidth() / 10;
        digitHeight = fontImage.getHeight();
        digitImage = new Image[10];
        for (i = 0; i < 10; ++i) {
            BurgerDisplay.digitImage[i] = Image.createImage((int)digitWidth, (int)digitHeight);
            Graphics gDigit = digitImage[i].getGraphics();
            gDigit.drawImage(fontImage, -i * digitWidth, 0, 20);
        }
        pieceImage = new Image[9];
        for (i = 0; i < 9; ++i) {
            BurgerDisplay.pieceImage[i] = BurgerDisplay.loadImage(String.valueOf(String.valueOf(new StringBuffer("/Pieces_0").append(i + 1).append(".png"))));
        }
    }
}

