/*
 * Decompiled with CFR 0.152.
 */
package BurgerKing;

import BurgerKing.GameEffect;
import com.nokia.mid.sound.Sound;
import com.nokia.mid.sound.SoundListener;
import com.nokia.mid.ui.DeviceControl;

public class NokiaGameEffect
extends GameEffect
implements SoundListener {
    private volatile int state = 1;
    private Sound sound = null;
    private volatile int currentSoundPriority = 0;
    private static final byte[] BULLET_SOUND_BYTES = new byte[]{2, 74, 58, -128, 64, 65, 51, 13, -88, -110, -80, 35, 4, 26, -127, 104, -128, 0};
    private static final byte[] BASE_EXPLODE_SOUND_BYTES = new byte[]{2, 74, 58, -128, 64, 1, -110, 77, -88, -126, -48, 39, 20, -111, -126, 13, 65, 39, 32, 0};
    private static final byte[] BLOCK_EXPLODE_SOUND_BYTES = new byte[]{2, 74, 58, -128, 64, 1, 18, -52, -88, -125, 16, 57, 2, 49, 43, 0, 0};

    public void soundStateChanged(Sound s, int event) {
        if (s == this.sound && event == 1) {
            this.currentSoundPriority = 0;
        }
    }

    private void playSound(int priority, byte[] bytes) {
        if (priority > this.currentSoundPriority) {
            try {
                if (this.sound == null) {
                    this.sound = new Sound(bytes, 1);
                    this.sound.setSoundListener((SoundListener)this);
                }
                if (this.state == 0) {
                    this.sound.stop();
                }
                this.sound.init(bytes, 1);
                this.sound.play(1);
                this.currentSoundPriority = priority;
            }
            catch (Exception e) {
                this.currentSoundPriority = 0;
            }
        }
    }

    void PlayCorrectSound() {
        this.playSound(2, BLOCK_EXPLODE_SOUND_BYTES);
    }

    void PlayWrongSound() {
        this.playSound(3, BASE_EXPLODE_SOUND_BYTES);
    }

    void pause() {
        DeviceControl.stopVibra();
    }

    void resume() {
    }

    void vibrate() {
        try {
            DeviceControl.startVibra((int)100, (long)200L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void flashLights() {
        DeviceControl.flashLights((long)250L);
    }
}

