/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.sound.Sound;
import com.nokia.mid.ui.FullCanvas;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreNotFoundException;

class mainCanvas
extends FullCanvas {
    private COD cod;
    private static final short LEFT_SOFTKEY = -6;
    private static final short RIGHT_SOFTKEY = -7;
    private static final byte pagemargin = 4;
    private static final int ROWMAX = 128;
    private static final int COLMAX = 11;
    private static final int MAP_HEIGHT = 2048;
    private static final int MAP_WIDTH = 176;
    private static final int SCREEN_MARGIN = 22;
    private static final byte SCREEN_SPEED_MAX = 3;
    private static final byte PLAYER_MAX = 3;
    private static final byte OPPONENT_MAX = 42;
    private static final byte SPECIAL_MAX = 40;
    private static final byte SQUARE_MAX = 30;
    private static final byte PROJECTILE_MAX = 20;
    private static final byte PROJECTILE_TIME_MAX_BULLET = 10;
    private static final byte PROJECTILE_TIME_MAX_GRENADE = 8;
    private static final byte PROJECTILE_TIME_MAX_EXPLOSIVES = 38;
    private static final byte PROJECTILE_TIME_MAX_RIFLE = 2;
    private static final byte EXPLOSION_FRAMES = 4;
    private static final byte DEATH_FRAMES = 30;
    private static final byte SHOT_DELAY_AXIS = 20;
    private static final byte SHOT_DELAY_AI = 10;
    private static final byte SHOT_DELAY_GRENADE = 10;
    private static final byte SHOT_DELAY_RIFLE = 10;
    private static final byte SHOT_DELAY_EXPLOSIVES = 10;
    private static final byte HEALING_DELAY = 60;
    private static final int FLAK_JACKET_TIME = 180;
    private static final byte[] INITIAL_AMMO = new byte[]{10, 5, 5};
    private static final byte[] INITIAL_HEALTH = new byte[]{2, 1, 3, 2, 3};
    private static final byte SHOW_STATUS_TIME = 60;
    private static final byte STATUS_BAR_WIDTH = 66;
    private static final byte STATUS_BAR_HEIGHT = 14;
    private static final byte SHOW_ORDERS_TIME = 50;
    private static final int INVISIBILITY_TIME = 180;
    private static final short screen_splash = 0;
    private static final short screen_menu = 1;
    private static final short screen_play = 2;
    private static final short screen_rules_menu = 3;
    private static final short screen_options = 4;
    private static final short screen_options_ingame = 5;
    private static final short screen_mission = 6;
    private static final short screen_briefing = 7;
    private static final short screen_briefing_no_back = 8;
    private static final short screen_squad_select = 9;
    private static final short screen_squad_confirm = 10;
    private static final short screen_end_level = 11;
    private static final short screen_player_dead = 12;
    private static final short screen_player_dead_extra = 13;
    private static final short screen_options_ingame_extra = 14;
    private static final short screen_reset_confirm = 15;
    private static final short screen_exit = 16;
    private static final short timer_loop = 0;
    private static final short timer_splash = 1;
    private static final short timer_menu_anim = 2;
    private static final short timer_suspend_key_presses = 3;
    private static final short timer_player_dead = 4;
    private static final int DELAY_LOOP = 50;
    private static final int DELAY_SPLASH_ACTIVISION = 2500;
    private static final int DELAY_SPLASH_NGAME = 2000;
    private static final int DELAY_SPLASH_TITLE = 3000;
    private static final int DELAY_ANIM = 100;
    private static final int DELAY_SUSPEND = 750;
    private int height;
    private int width;
    private int halfHeight;
    private int halfWidth;
    private short fontHeight;
    private short largeFontHeight;
    private Font font;
    private Font largeFont;
    private Timer timer;
    private SimpleTimerTask simpletimertask;
    private short screenType;
    private byte missionNumberCurrent;
    private byte missionNumberMax;
    private static final byte MISSION_COUNT = 8;
    private boolean endLevel;
    private Image tilesImage;
    private Image unitImage;
    private Image screenImage;
    private Image specialImage;
    private Image symbolsImage;
    private Image statusBar;
    private Image titleImage;
    private Image arrowsImage;
    private short menuStart;
    private short menuLines;
    private short menuGraphicHeight;
    private short menuLineHeight;
    private short menuLength;
    private short menuSelection;
    private String[] menuStringArray;
    private Graphics screenImageGraphics;
    private int screenImageLeft;
    private int screenImageTop;
    private int screenImageHeight;
    private int screenSplit;
    private int screenImageDiscontinuity;
    private byte[] projectileArrayNext = new byte[20];
    private byte projectileArrayUsedStart;
    private byte projectileArrayUnusedStart;
    private int[] projectileX = new int[20];
    private int[] projectileY = new int[20];
    private byte[] projectileDirection = new byte[20];
    private byte[] projectileTime = new byte[20];
    private byte[] projectileType = new byte[20];
    private byte opponentArrayStart;
    private byte[] playerArrayNext = new byte[45];
    private byte playerArrayStart;
    private byte currentPlayer;
    private boolean takeCover;
    private int[] playerX = new int[45];
    private int[] playerY = new int[45];
    private byte[] playerDirection = new byte[45];
    private boolean[] playerMoving = new boolean[45];
    private byte[] playerHealth = new byte[45];
    private int[] playerNextShot = new int[45];
    private int[] playerAimX = new int[2];
    private int[] playerAimY = new int[2];
    private byte[] playerType = new byte[3];
    private int[] playerSpecial = new int[3];
    private int[] playerProtected = new int[3];
    private boolean[] playerInBuilding = new boolean[3];
    private int[] playerShowStatus = new int[3];
    private byte[] specialArrayNext = new byte[40];
    private byte[] specialArrayPrevious = new byte[40];
    private byte specialArrayStart;
    private byte specialArrayExplodableStart;
    private int[] specialX = new int[40];
    private int[] specialY = new int[40];
    private byte[] specialType = new byte[40];
    private byte[] specialDamage = new byte[40];
    private byte[] squarePlayer = new byte[30];
    private byte[] squareRow = new byte[30];
    private byte[] squareCol = new byte[30];
    private byte squareMax;
    private int currentKeyCode;
    private int nextKeyCode;
    private byte frameCount;
    private int clockTicks;
    private int showOrders;
    private boolean soundOn;
    private boolean allowKeyPresses = true;
    private Random random = new Random();
    private Sound introSound;
    private Sound fireSound;
    private Sound pickupSound;
    private Sound secondarySound;
    private Sound explosionSound;
    private Sound unitSound;
    private Sound winSound;
    private Sound loseSound;
    private int[] missionTime = new int[9];
    private long startTime;
    private byte[][] MapData = new byte[128][11];
    private byte[] TileTextureData;
    private byte[] TileBlockData;
    private byte[] TileSpecialData;
    private static final byte PLAYER_INFANTRY = 0;
    private static final byte PLAYER_SNIPER = 1;
    private static final byte PLAYER_ENGINEER = 2;
    private static final byte PLAYER_COMMANDO = 3;
    private static final byte PLAYER_MEDIC = 4;
    private static final byte SPECIAL_TANK = 0;
    private static final byte SPECIAL_JEEP = 1;
    private static final byte SPECIAL_V2 = 2;
    private static final byte SPECIAL_DOOR = 3;
    private static final byte SPECIAL_FLAK_JACKET = 4;
    private static final byte SPECIAL_MEDIPACK = 5;
    private static final byte SPECIAL_AMMUNITION = 6;
    private static final byte SPECIAL_END = 7;
    private static final byte SPECIAL_BACK_DOOR = 8;
    private static final int[] SPECIAL_GFX_X = new int[]{0, 80, 112, 112, 128, 128, 32};
    private static final byte[] SPECIAL_GFX_Y = new byte[]{0, 0, 0, 32, 0, 16, 32};
    private static final byte[] SPECIAL_GFX_W = new byte[]{64, 32, 16, 32, 16, 16, 16, 16, 32};
    private static final byte[] SPECIAL_GFX_H = new byte[]{32, 32, 32, 16, 16, 16, 16, 16, 16};
    private static final byte[] CRATER_GFX_X = new byte[]{0, 64, 96, 96};
    private static final byte[] CRATER_GFX_Y = new byte[]{0, 0, 16, 0};
    private static final byte[] CRATER_GFX_W = new byte[]{64, 32, 16, 32};
    private static final byte[] CRATER_GFX_H = new byte[]{32, 32, 32, 16};
    private static final byte[] CRATER_DRAW_Y = new byte[]{0, 0, 16, 0};
    private static final byte EXPLOSIVES_GFX_X = 48;
    private static final byte EXPLOSIVES_GFX_Y = 32;
    private static final byte FLAG_GFX_X = 0;
    private static final byte FLAG_GFX_Y = 32;
    private static final byte SECONDARY_GFX_X = 64;
    private static final byte FLAK_JACKET_GFX_X = 82;
    private static final byte DAGGER_GFX_X = 72;
    private static final byte DAGGER_GFX_Y = 6;
    private static final byte GUNFLARE_GFX_X = 74;
    private static final byte GUNFLARE_GFX_Y = 15;
    private static final byte PROJECTILE_BULLET = 99;
    private static final byte PROJECTILE_GRENADE = 0;
    private static final byte PROJECTILE_RIFLE = 1;
    private static final byte PROJECTILE_EXPLOSIVES = 2;
    private static final byte PROJECTILE_EXPLOSION = 10;
    private static final byte DAMAGE_BULLET = 1;
    private static final byte DAMAGE_RIFLE = 2;
    private static final byte DAMAGE_EXPLOSION = 2;
    private static final byte TILE_BLOCKED_IMPASSABLE = 0;
    private static final byte TILE_BLOCKED_DOOR = 1;
    private static final byte TILE_BLOCKED_WALK_UNDER = 2;
    private static final byte TILE_BLOCKED_WATER = 3;
    private static final byte TILE_BLOCKED_CLEAR = 4;
    private static final byte TILE_BLOCKED_BACK_DOOR = 5;
    private static final byte[] WEAPON_TYPE = new byte[]{0, 1, 2, 0, -1};
    private static final byte[] bulletDeltaX = new byte[]{-4, 0, 4, -6, 0, 6, -4, 0, 4};
    private static final byte[] bulletDeltaY = new byte[]{-4, -6, -4, 0, 0, 0, 4, 6, 4};
    private static final byte[] bulletClipDeltaX = new byte[]{11, 1, 0, 13, 0, 0, 11, 1, 0};
    private static final byte[] bulletClipDeltaY = new byte[]{11, 13, 11, 1, 0, 1, 0, 0, 0};
    private static final byte[] bulletImageDeltaX = new byte[]{101, 86, 98, 93, 0, 80, 109, 86, 90};
    private static final byte[] bulletImageDeltaY = new byte[]{48, 45, 48, 38, 0, 38, 37, 32, 37};
    private static final byte[] bulletClipWidth = new byte[]{11, 3, 11, 13, 0, 13, 11, 3, 11};
    private static final byte[] bulletClipHeight = new byte[]{11, 13, 11, 3, 0, 3, 11, 13, 11};
    private static final byte[] bulletEndDeltaX = new byte[]{-11, 0, 11, -13, 0, 13, -11, 0, 11};
    private static final byte[] bulletEndDeltaY = new byte[]{-11, -13, -11, 0, 0, 0, 11, 13, 11};
    private static final byte[] gunFlareX = new byte[]{0, 8, 15, 0, 0, 15, 0, 8, 15};
    private static final byte[] gunFlareY = new byte[]{5, 0, 5, 9, 0, 9, 10, 11, 10};

    public mainCanvas(COD cOD) {
        this.cod = cOD;
        this.font = Font.getFont((int)0, (int)0, (int)8);
        this.fontHeight = (short)this.font.getHeight();
        this.largeFont = Font.getFont((int)64, (int)1, (int)0);
        this.largeFontHeight = (short)this.largeFont.getHeight();
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.halfWidth = this.width >> 1;
        this.halfHeight = this.height >> 1;
        this.missionNumberCurrent = 0;
        this.missionNumberMax = 0;
        this.soundOn = true;
        int n = 0;
        while (n <= 8) {
            this.missionTime[n] = 0;
            ++n;
        }
        try {
            if (RecordStore.listRecordStores() == null) {
                this.writeRecords();
            } else {
                this.readRecords();
            }
        }
        catch (Exception exception) {
            System.out.println("Record Store not found");
        }
        try {
            this.unitImage = Image.createImage((String)"/player.png");
            this.symbolsImage = Image.createImage((String)"/symbols.png");
            this.specialImage = Image.createImage((String)"/activision.png");
            this.titleImage = Image.createImage((String)"/title.png");
            this.arrowsImage = Image.createImage((String)"/arrows.png");
            this.statusBar = Image.createImage((int)66, (int)14);
        }
        catch (Exception exception) {
            System.out.println("Images not found");
        }
        int n2 = (this.height >> 4) + 1;
        if ((this.height & 0xF) > 0) {
            ++n2;
        }
        this.screenImageHeight = n2 << 4;
        this.screenImage = Image.createImage((int)176, (int)this.screenImageHeight);
        this.screenImageGraphics = this.screenImage.getGraphics();
        this.introSound = new Sound(new byte[]{2, 74, 58, -128, 64, 6, 81, -41, -56, -91, 7, 32, 106, 7, 18, 106, 7, 32, -110, 41, 65, -56, 26, -127, -58, 26, 97, 4, 36, -118, 80, 114, 6, -96, 113, 38, -96, 114, 9, 34, -108, 28, -127, -88, 28, 97, -90, 16, 97, -56, 26, -126, 72, -91, 7, 32, 106, 9, 38, -110, 48, 65, -56, 36, -86, 13, 52, -60, 13, 48, 0}, 1);
        this.fireSound = new Sound(new byte[]{2, 74, 58, -128, 64, 0, -79, -41, -53, 80, -83, 10, 80, 0}, 1);
        this.pickupSound = new Sound(new byte[]{2, 74, 58, -128, 64, 0, -111, -41, -56, -80, -84, 64, 0}, 1);
        this.secondarySound = new Sound(new byte[]{2, 74, 58, -128, 64, 0, -111, -41, -48, 89, -96, 0}, 1);
        this.explosionSound = new Sound(new byte[]{2, 74, 58, -128, 64, 1, 113, -41, -56, -63, 4, 104, 74, -124, 104, 74, -124, 104, -110, 48, 0}, 1);
        this.unitSound = new Sound(new byte[]{2, 74, 58, -128, 64, 0, -47, -41, -44, 70, 4, 40, 70, 0, 0}, 1);
        this.winSound = new Sound(new byte[]{2, 74, 58, -128, 64, 1, -111, -41, -48, 97, -122, 32, 98, 7, 32, 98, 7, 32, -110, 112, 48, -48, 0}, 1);
        this.loseSound = new Sound(new byte[]{2, 74, 58, -128, 64, 1, 81, -41, -51, 32, -45, 10, -96, -85, 8, -96, -117, 16, 105, 0, 0}, 1);
        System.gc();
        this.PlaySound(this.introSound);
        this.screenType = 0;
        this.timer = new Timer();
        this.frameCount = 0;
        this.StartSimpleTimer((short)1, 2500);
    }

    private void GetSpecialImage(String string) {
        this.specialImage = null;
        System.gc();
        try {
            this.specialImage = Image.createImage((String)("/" + string + ".png"));
        }
        catch (Exception exception) {
            System.out.println(string + ".png not found");
        }
    }

    private void GetGameImages(boolean bl) {
        this.titleImage = null;
        this.arrowsImage = null;
        System.gc();
        try {
            if (bl) {
                this.titleImage = Image.createImage((String)"/axis.png");
                this.arrowsImage = Image.createImage((String)"/bang.png");
            } else {
                this.titleImage = Image.createImage((String)"/title.png");
                this.arrowsImage = Image.createImage((String)"/arrows.png");
            }
        }
        catch (Exception exception) {
            System.out.println("GetGameImages failed");
        }
    }

    private void ReadMap() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        this.projectileArrayUsedStart = (byte)-1;
        this.projectileArrayUnusedStart = 0;
        int n13 = 18;
        while (n13 >= 0) {
            this.projectileArrayNext[n13] = (byte)(n13 + 1);
            --n13;
        }
        this.projectileArrayNext[19] = -1;
        this.screenImageLeft = 0;
        int n14 = 0;
        while (n14 < 3) {
            this.playerSpecial[n14] = this.playerType[n14] == 4 || this.playerType[n14] == 3 ? 0 : INITIAL_AMMO[WEAPON_TYPE[this.playerType[n14]]];
            this.playerHealth[n14] = INITIAL_HEALTH[this.playerType[n14]];
            this.playerNextShot[n14] = 0;
            this.playerDirection[n14] = 1;
            this.playerMoving[n14] = false;
            this.playerProtected[n14] = 0;
            this.playerInBuilding[n14] = false;
            this.playerShowStatus[n14] = 60;
            ++n14;
        }
        InputStream inputStream = null;
        DataInputStream dataInputStream = null;
        Vector<Integer> vector = new Vector<Integer>();
        Vector<Integer> vector2 = new Vector<Integer>();
        Vector<Integer> vector3 = new Vector<Integer>();
        Vector<Integer> vector4 = new Vector<Integer>();
        Vector<Integer> vector5 = new Vector<Integer>();
        Vector<Integer> vector6 = new Vector<Integer>();
        try {
            inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("m" + this.missionNumberCurrent);
            dataInputStream = new DataInputStream(inputStream);
            int n15 = dataInputStream.read();
            while (true) {
                n12 = n15 >>> 4 & 0xF;
                n11 = n15 & 0xF;
                if (n12 > 1) break;
                n10 = dataInputStream.read();
                vector2.addElement(new Integer(n11));
                vector3.addElement(new Integer(n10));
                n15 = dataInputStream.read();
            }
            n9 = 3;
            n8 = vector2.size() - 1;
            while (n8 >= 0) {
                this.playerX[n9] = (Integer)vector2.elementAt(n8) << 4;
                this.playerY[n9] = (Integer)vector3.elementAt(n8) << 4;
                this.playerNextShot[n9] = 0;
                int n16 = this.missionNumberCurrent == 9 ? 2 : this.missionNumberCurrent / 3;
                this.playerHealth[n9] = n16 == 0 ? (byte)0 : (byte)(Math.abs(this.random.nextInt()) % (n16 + 1));
                this.playerDirection[n9] = 7;
                n9 = (byte)(n9 + 1);
                --n8;
            }
            this.playerArrayNext[n9 - 1] = -1;
            n7 = n9 - 2;
            while (n7 >= 0) {
                this.playerArrayNext[n7] = (byte)(n7 + 1);
                --n7;
            }
            this.opponentArrayStart = n9 > 3 ? (byte)3 : (byte)-1;
            vector2 = new Vector();
            vector3 = new Vector();
            while (n15 != 240) {
                n10 = dataInputStream.read();
                if (n12 == 7) {
                    this.screenImageLeft = (n11 << 4) + 8 - this.width / 2;
                    if (this.screenImageLeft < 0) {
                        this.screenImageLeft = 0;
                    } else if (this.screenImageLeft + this.width > 176) {
                        this.screenImageLeft = 176 - this.width;
                    }
                    this.currentPlayer = 0;
                    this.playerArrayStart = 0;
                    this.takeCover = false;
                    this.playerX[0] = n11 << 4;
                    this.playerY[0] = n10 << 4;
                    this.playerX[1] = n11 - 1 << 4;
                    this.playerY[1] = n10 + 1 << 4;
                    this.playerX[2] = n11 + 1 << 4;
                    this.playerY[2] = this.playerY[1];
                } else {
                    vector.addElement(new Integer(n12));
                    vector2.addElement(new Integer(n11));
                    vector3.addElement(new Integer(n10));
                }
                n15 = dataInputStream.read();
                n12 = n15 >>> 4 & 0xF;
                n11 = n15 & 0xF;
            }
            n15 = dataInputStream.read();
            while (true) {
                n12 = n15 >>> 2 & 0x3F;
                n11 = n15 & 3;
                if (n12 == 63) break;
                vector4.addElement(new Integer(n12 - 1));
                switch (n11) {
                    case 0: {
                        vector5.addElement(new Integer(4));
                        break;
                    }
                    case 1: {
                        vector5.addElement(new Integer(0));
                        break;
                    }
                    case 2: {
                        vector5.addElement(new Integer(2));
                        break;
                    }
                    case 3: {
                        vector5.addElement(new Integer(3));
                    }
                }
                vector6.addElement(new Integer(-1));
                n15 = dataInputStream.read();
            }
            int n17 = -1;
            int n18 = 0;
            n6 = 0;
            n5 = -1;
            n11 = 0;
            while (true) {
                if (n17 < 0) {
                    n18 = 0;
                    n4 = 2;
                    while (n4 >= 0) {
                        n15 = dataInputStream.read();
                        n18 += n15 << n4 * 8;
                        --n4;
                    }
                    n17 = 3;
                }
                if (n5 == -1) {
                    n5 = n18 >>> n17 * 6 & 0x3F;
                    if (n5 == 63) {
                        break;
                    }
                } else {
                    n15 = n18 >>> n17 * 6 & 0x3F;
                    if (n6 != 0) {
                        if (n15 == 0) {
                            this.MapData[n11 / 11][n11 % 11] = (byte)(n5 - 1);
                            ++n11;
                            break;
                        }
                        n4 = n15;
                        while (n4 > 0) {
                            this.MapData[n11 / 11][n11 % 11] = (byte)(n5 - 1);
                            ++n11;
                            --n4;
                        }
                        n6 = 0;
                        n5 = -1;
                    } else if (n15 == 63) {
                        n6 = 1;
                    } else {
                        this.MapData[n11 / 11][n11 % 11] = (byte)(n5 - 1);
                        ++n11;
                        n5 = n15;
                    }
                }
                --n17;
            }
            dataInputStream.close();
            inputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.toString());
        }
        n9 = 0;
        int n19 = vector4.size();
        this.specialArrayExplodableStart = (byte)-1;
        byte[] byArray = new byte[16];
        byte[] byArray2 = new byte[16];
        n4 = vector.size() - 1;
        while (n4 >= 0) {
            n12 = (Integer)vector.elementAt(n4);
            if (this.specialArrayExplodableStart < 0 && n12 <= 6) {
                this.specialArrayExplodableStart = (byte)n9;
            }
            switch (n12) {
                case 2: {
                    n8 = 3;
                    n7 = 1;
                    break;
                }
                case 3: {
                    n8 = 0;
                    n7 = 0;
                    break;
                }
                case 4: {
                    n8 = 1;
                    n7 = 0;
                    break;
                }
                case 6: {
                    n8 = 2;
                    n7 = 0;
                    break;
                }
                case 8: {
                    n8 = 7;
                    n7 = 4;
                    break;
                }
                case 9: {
                    n8 = 5;
                    n7 = 4;
                    break;
                }
                case 10: {
                    n8 = 4;
                    n7 = 4;
                    break;
                }
                case 11: {
                    n8 = 6;
                    n7 = 4;
                    break;
                }
                case 12: {
                    n8 = 8;
                    n7 = 5;
                    break;
                }
                default: {
                    n8 = -1;
                    n7 = -1;
                }
            }
            if (n8 >= 0) {
                n11 = (Integer)vector2.elementAt(n4);
                n10 = (Integer)vector3.elementAt(n4);
                n6 = 0;
                n3 = (SPECIAL_GFX_W[n8] >> 4) - 1;
                while (n3 >= 0) {
                    n2 = (SPECIAL_GFX_H[n8] >> 4) - 1;
                    while (n2 >= 0) {
                        n5 = 0;
                        while (n5 < n6) {
                            if (byArray[n5] == this.MapData[n10 + n2][n11 + n3]) {
                                this.MapData[n10 + n2][n11 + n3] = byArray2[n5];
                                break;
                            }
                            n5 = (byte)(n5 + 1);
                        }
                        if (n5 == n6) {
                            byArray[n6] = this.MapData[n10 + n2][n11 + n3];
                            byArray2[n6] = n19;
                            n6 = (byte)(n6 + 1);
                            vector4.addElement((Integer)vector4.elementAt(this.MapData[n10 + n2][n11 + n3]));
                            vector5.addElement(new Integer(n7));
                            if (n7 == 5) {
                                vector6.addElement(new Integer(-1));
                            } else {
                                vector6.addElement(new Integer(n9));
                            }
                            this.MapData[n10 + n2][n11 + n3] = n19;
                            n19 = (byte)(n19 + 1);
                        }
                        --n2;
                    }
                    --n3;
                }
                if (n8 != 8) {
                    this.specialX[n9] = n11 << 4;
                    this.specialY[n9] = n10 << 4;
                    this.specialType[n9] = n8;
                    this.specialDamage[n9] = 2;
                    n9 = (byte)(n9 + 1);
                }
            }
            --n4;
        }
        this.TileTextureData = new byte[n19];
        this.TileBlockData = new byte[n19];
        this.TileSpecialData = new byte[n19];
        n3 = 0;
        while (n3 < n19) {
            this.TileTextureData[n3] = (byte)((Integer)vector4.elementAt(n3)).intValue();
            this.TileBlockData[n3] = (byte)((Integer)vector5.elementAt(n3)).intValue();
            this.TileSpecialData[n3] = (byte)((Integer)vector6.elementAt(n3)).intValue();
            ++n3;
        }
        byArray = new byte[28];
        n2 = 0;
        int n20 = 0;
        while (n20 < 28) {
            byArray[n20] = 0;
            ++n20;
        }
        int n21 = 0;
        while (n21 < n19) {
            if (byArray[this.TileTextureData[n21]] == 0) {
                byArray[this.TileTextureData[n21]] = n2;
                n2 = (byte)(n2 + 1);
            }
            ++n21;
        }
        vector = null;
        vector2 = null;
        vector3 = null;
        vector4 = null;
        vector5 = null;
        vector6 = null;
        this.tilesImage = null;
        System.gc();
        this.GetSpecialImage("ground");
        this.tilesImage = Image.createImage((int)(n2 << 4), (int)16);
        Graphics graphics = this.tilesImage.getGraphics();
        int n22 = 0;
        while (n22 < 28) {
            byArray[n22] = 0;
            ++n22;
        }
        n2 = 0;
        int n23 = 0;
        while (n23 < n19) {
            if (byArray[this.TileTextureData[n23]] == 0) {
                graphics.setClip(n2 << 4, 0, 16, 16);
                graphics.drawImage(this.specialImage, n2 - this.TileTextureData[n23] % 7 << 4, -(this.TileTextureData[n23] / 7) << 4, 20);
                byArray[this.TileTextureData[n23]] = n2;
                this.TileTextureData[n23] = n2;
                n2 = (byte)(n2 + 1);
            } else {
                this.TileTextureData[n23] = byArray[this.TileTextureData[n23]];
            }
            ++n23;
        }
        this.specialImage = null;
        System.gc();
        if (n9 > 0) {
            this.specialArrayStart = 0;
            this.specialArrayNext[n9 - 1] = -1;
            this.specialArrayPrevious[0] = -1;
            if (n9 > 1) {
                n = n9 - 2;
                while (n >= 0) {
                    this.specialArrayNext[n] = (byte)(n + 1);
                    this.specialArrayPrevious[n + 1] = (byte)n;
                    --n;
                }
            }
        } else {
            this.specialArrayStart = (byte)-1;
        }
        this.playerAimY[1] = -1;
        this.playerAimY[0] = -1;
        this.playerAimX[1] = -1;
        this.playerAimX[0] = -1;
        n = Math.min(this.playerY[this.currentPlayer] + 16 + 22, 2048);
        this.screenImageTop = n - this.height;
        n = n + 15 >> 4 << 4;
        this.screenSplit = n - this.screenImageHeight;
        this.screenImageDiscontinuity = this.screenImageHeight;
        int n24 = n >> 4;
        int n25 = this.screenImageHeight >> 4;
        int n26 = n25 - 1;
        while (n26 >= 0) {
            --n24;
            int n27 = 10;
            while (n27 >= 0) {
                this.screenImageGraphics.setClip(n27 << 4, n26 << 4, 16, 16);
                byte by = this.TileTextureData[this.MapData[n24][n27]];
                this.screenImageGraphics.drawImage(this.tilesImage, n27 - by << 4, n26 << 4, 20);
                --n27;
            }
            --n26;
        }
        this.GetSpecialImage("special");
        this.GetGameImages(true);
    }

    public final void pause() {
        this.cod.notifyPaused();
    }

    private final void readRecords() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"cod", (boolean)false);
            byte[] byArray = recordStore.getRecord(1);
            recordStore.closeRecordStore();
            this.missionNumberMax = byArray[0];
            this.soundOn = byArray[1] > 0;
            int n = 0;
            while (n <= this.missionNumberMax) {
                this.missionTime[n] = 0;
                int n2 = 0;
                while (n2 < 4) {
                    this.missionTime[n] = (this.missionTime[n] << 8) + (byArray[2 + 4 * n + n2] & 0xFF);
                    ++n2;
                }
                ++n;
            }
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            this.writeRecords();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void writeRecords() {
        try {
            byte[] byArray = new byte[4 * this.missionNumberMax + 6];
            byArray[0] = this.missionNumberMax;
            byArray[1] = (byte)(this.soundOn ? 1 : 0);
            int n = 0;
            while (n <= this.missionNumberMax) {
                int n2 = 0;
                while (n2 < 4) {
                    byArray[2 + 4 * n + n2] = (byte)(this.missionTime[n] >>> (3 - n2) * 8 & 0xFF);
                    ++n2;
                }
                ++n;
            }
            RecordStore recordStore = RecordStore.openRecordStore((String)"cod", (boolean)true);
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byArray, 0, byArray.length);
            } else {
                recordStore.setRecord(1, byArray, 0, byArray.length);
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void PlaySound(Sound sound) {
        if (this.soundOn) {
            sound.play(1);
        }
    }

    private void StopSound(Sound sound) {
        if (this.soundOn) {
            sound.stop();
        }
    }

    public final void exitGame() {
        this.cod.midletExit();
    }

    public final void paint(Graphics graphics) {
        if (this.screenType == 2) {
            byte by;
            int n;
            int n2;
            byte by2;
            graphics.drawImage(this.screenImage, -this.screenImageLeft, this.screenSplit - this.screenImageTop, 20);
            graphics.drawImage(this.screenImage, -this.screenImageLeft, this.screenSplit - this.screenImageTop - this.screenImageHeight, 20);
            byte by3 = this.specialArrayStart;
            while (by3 >= 0) {
                by2 = this.specialType[by3];
                if (by2 < 0) {
                    n2 = this.specialY[by3] - this.screenImageTop + CRATER_DRAW_Y[by2 = (byte)(-1 - by2)];
                    if (n2 < this.height && n2 + CRATER_GFX_H[by2] >= 0) {
                        graphics.setClip(this.specialX[by3] - this.screenImageLeft, n2, (int)CRATER_GFX_W[by2], (int)CRATER_GFX_H[by2]);
                        graphics.drawImage(this.arrowsImage, this.specialX[by3] - this.screenImageLeft - CRATER_GFX_X[by2], n2 - CRATER_GFX_Y[by2], 20);
                    }
                } else if (by2 != 3) {
                    graphics.setClip(this.specialX[by3] - this.screenImageLeft, this.specialY[by3] - this.screenImageTop, (int)SPECIAL_GFX_W[by2], (int)SPECIAL_GFX_H[by2]);
                    if (by2 == 7) {
                        graphics.drawImage(this.specialImage, this.specialX[by3] - this.screenImageLeft - ((this.frameCount & 1) << 4) - 0, this.specialY[by3] - this.screenImageTop - 32, 20);
                    } else {
                        graphics.drawImage(this.specialImage, this.specialX[by3] - this.screenImageLeft - SPECIAL_GFX_X[by2], this.specialY[by3] - this.screenImageTop - SPECIAL_GFX_Y[by2], 20);
                    }
                }
                by3 = this.specialArrayNext[by3];
            }
            by3 = this.projectileArrayUsedStart;
            while (by3 >= 0) {
                switch (this.projectileType[by3]) {
                    case 99: {
                        n = this.projectileX[by3] - this.screenImageLeft;
                        n2 = this.projectileY[by3] - this.screenImageTop;
                        by = this.projectileDirection[by3];
                        graphics.setClip(n - bulletClipDeltaX[by], n2 - bulletClipDeltaY[by], (int)bulletClipWidth[by], (int)bulletClipHeight[by]);
                        graphics.drawImage(this.specialImage, n - bulletImageDeltaX[by], n2 - bulletImageDeltaY[by], 20);
                        this.RedrawSceneryAbove(graphics, this.projectileX[by3] - bulletClipDeltaX[by], this.projectileY[by3] - bulletClipDeltaY[by], bulletClipWidth[by], bulletClipHeight[by], (byte)-1);
                        break;
                    }
                    case 2: {
                        n = this.projectileX[by3] - this.screenImageLeft - 8;
                        n2 = this.projectileY[by3] - this.screenImageTop - 8;
                        graphics.setClip(n, n2, 16, 16);
                        graphics.drawImage(this.specialImage, n - ((this.frameCount & 1) << 4) - 48, n2 - 32, 20);
                    }
                }
                by3 = this.projectileArrayNext[by3];
            }
            this.squareMax = 0;
            by3 = this.playerArrayStart;
            Image image = this.unitImage;
            if (by3 == this.opponentArrayStart) {
                image = this.titleImage;
            }
            while (by3 >= 0) {
                n2 = this.playerY[by3];
                if (n2 <= this.screenImageTop + this.height && n2 + 16 >= this.screenImageTop) {
                    n = this.playerX[by3];
                    graphics.setClip(n - this.screenImageLeft, n2 - this.screenImageTop, 16, 16);
                    by = this.playerDirection[by3];
                    if (by > 4) {
                        by = (byte)(by - 1);
                    }
                    if (this.playerHealth[by3] < 0) {
                        by = -this.playerHealth[by3];
                        if ((by & 1) == 1) {
                            if ((by = (byte)(by >> 1 & 7)) > 3) {
                                by = (byte)(by + 1);
                            }
                            graphics.drawImage(image, n - this.screenImageLeft - 16, n2 - this.screenImageTop - (by << 4), 20);
                        }
                    } else {
                        graphics.drawImage(image, n - this.screenImageLeft - (this.playerMoving[by3] ? this.frameCount >> 1 << 4 : 16), n2 - this.screenImageTop - (by << 4), 20);
                    }
                    this.RedrawSceneryAbove(graphics, n, n2, 15, 15, by3);
                    if (this.TileBlockData[this.MapData[n2 + 8 >> 4][n + 8 >> 4]] == 3) {
                        graphics.setClip(n - this.screenImageLeft, n2 - this.screenImageTop + 10, 16, 6);
                        graphics.drawImage(this.screenImage, -this.screenImageLeft, this.screenSplit - this.screenImageTop, 20);
                        graphics.drawImage(this.screenImage, -this.screenImageLeft, this.screenSplit - this.screenImageTop - this.screenImageHeight, 20);
                    }
                }
                if ((by3 = this.playerArrayNext[by3]) != this.opponentArrayStart) continue;
                image = this.titleImage;
            }
            byte by4 = 0;
            while (by4 < this.squareMax) {
                graphics.setClip((this.squareCol[by4] << 4) - this.screenImageLeft, (this.squareRow[by4] << 4) - this.screenImageTop, 16, 16);
                by3 = this.squarePlayer[by4];
                if (by3 < 3) {
                    graphics.setColor(65280);
                } else {
                    graphics.setColor(0xFF0000);
                }
                graphics.fillRect(this.playerX[by3] - this.screenImageLeft + 5, this.playerY[by3] - this.screenImageTop + 5, 6, 6);
                by4 = (byte)(by4 + 1);
            }
            by3 = this.specialArrayExplodableStart;
            while (by3 >= 0) {
                by2 = this.specialType[by3];
                if (by2 == 3) {
                    graphics.setClip(this.specialX[by3] - this.screenImageLeft, this.specialY[by3] - this.screenImageTop, (int)SPECIAL_GFX_W[by2], (int)SPECIAL_GFX_H[by2]);
                    graphics.drawImage(this.specialImage, this.specialX[by3] - this.screenImageLeft - SPECIAL_GFX_X[by2], this.specialY[by3] - this.screenImageTop - SPECIAL_GFX_Y[by2], 20);
                }
                by3 = this.specialArrayNext[by3];
            }
            by3 = this.projectileArrayUsedStart;
            while (by3 >= 0) {
                switch (this.projectileType[by3]) {
                    case 0: {
                        n = this.projectileX[by3] - this.screenImageLeft - 3;
                        n2 = this.projectileY[by3] - this.screenImageTop - 5;
                        graphics.setClip(n, n2, 7, 10);
                        graphics.drawImage(this.specialImage, n - 1 - 64, n2, 20);
                        break;
                    }
                    case 1: {
                        n = this.projectileX[by3] - this.screenImageLeft - 2;
                        n2 = this.projectileY[by3] - this.screenImageTop - 2;
                        graphics.setClip(n, n2, 5, 5);
                        graphics.drawImage(this.specialImage, n - 74, n2 - 15, 20);
                        break;
                    }
                    case 10: {
                        n = this.projectileX[by3] - this.screenImageLeft - 16;
                        n2 = this.projectileY[by3] - this.screenImageTop - 16;
                        graphics.setClip(n, n2, 32, 32);
                        graphics.drawImage(this.arrowsImage, n - (this.projectileTime[by3] << 5), n2 - 32, 20);
                    }
                }
                by3 = this.projectileArrayNext[by3];
            }
            by3 = this.playerArrayStart;
            while (by3 != this.opponentArrayStart) {
                if (this.playerShowStatus[by3] > this.clockTicks && this.playerHealth[by3] >= 0) {
                    n = this.playerX[by3] - this.screenImageLeft;
                    n2 = this.playerY[by3] - this.screenImageTop;
                    graphics.setClip(n - 3, n2 + 16, 21, 7);
                    graphics.setColor(0);
                    graphics.fillRect(n - 3, n2 + 16, 21, 7);
                    graphics.setColor(0xFF0000);
                    graphics.fillRect(n + 5, n2 + 18, this.playerHealth[by3] * 4, 3);
                    graphics.setClip(n - 2, n2 + 17, 5, 5);
                    graphics.drawImage(this.symbolsImage, n - 2 - this.playerType[by3] * 5, n2 + 17, 20);
                    graphics.setClip(n + 4, n2 + 17, 13, 5);
                    if (by3 == this.currentPlayer) {
                        graphics.drawImage(this.symbolsImage, n - 35, n2 + 17, 20);
                    } else {
                        graphics.drawImage(this.symbolsImage, n - 22, n2 + 17, 20);
                    }
                }
                by3 = this.playerArrayNext[by3];
            }
            graphics.setClip(0, 0, this.width, this.height);
            graphics.drawImage(this.statusBar, 1, this.height - 14 - 1, 20);
            if (this.playerProtected[this.currentPlayer] > this.clockTicks) {
                graphics.setClip(67, this.height - 14 - 1, 12, 14);
                graphics.drawImage(this.symbolsImage, -15, this.height - 17, 20);
                graphics.setClip(0, 0, this.width, this.height);
            }
            if (this.showOrders > this.clockTicks) {
                graphics.setColor(0xFFFFFF);
                graphics.setFont(this.font);
                if (this.takeCover) {
                    graphics.drawString("Orders: Take Cover", this.width - 2, this.height - this.fontHeight, 24);
                } else {
                    graphics.drawString("Orders: Follow Me", this.width - 2, this.height - this.fontHeight, 24);
                }
            }
        } else {
            graphics.setColor(0);
            graphics.fillRect(0, 0, this.width, this.height);
            graphics.setColor(0xFFFFFF);
            graphics.setFont(this.largeFont);
            if (this.screenType >= 100) {
                graphics.drawString(Strings.helpTitles[this.screenType - 100], this.halfWidth, 4, 17);
                this.ShowButtons(graphics, null, "BACK");
                graphics.setFont(this.font);
                this.PrintTextStrings(graphics);
            } else {
                switch (this.screenType) {
                    case 0: {
                        if (this.frameCount == 2) {
                            graphics.drawImage(this.titleImage, this.halfWidth, this.halfHeight, 3);
                            break;
                        }
                        graphics.drawImage(this.specialImage, this.halfWidth, this.halfHeight, 3);
                        break;
                    }
                    case 1: {
                        graphics.drawImage(this.titleImage, this.halfWidth, 4, 17);
                        this.PrintMenuStrings(graphics);
                        break;
                    }
                    case 3: {
                        graphics.drawString("Help", this.halfWidth, 4, 17);
                        this.ShowButtons(graphics, "SELECT", "BACK");
                        this.PrintMenuStrings(graphics);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 14: {
                        graphics.drawString("Options", this.halfWidth, 4, 17);
                        this.ShowButtons(graphics, "SELECT", "BACK");
                        this.PrintMenuStrings(graphics);
                        break;
                    }
                    case 15: {
                        graphics.drawString("Reset Game", this.halfWidth, 4, 17);
                        graphics.drawString("Are you sure?", this.halfWidth, this.halfHeight, 17);
                        this.ShowButtons(graphics, "CONFIRM", "BACK");
                        break;
                    }
                    case 6: {
                        graphics.drawImage(this.titleImage, this.halfWidth, 4, 17);
                        this.ShowButtons(graphics, "SELECT", "BACK");
                        this.PrintMenuStrings(graphics);
                        break;
                    }
                    case 7: 
                    case 8: {
                        graphics.drawString(Strings.missionTitle[this.missionNumberCurrent], this.halfWidth, 4, 17);
                        this.ShowButtons(graphics, "CONTINUE", this.screenType == 7 ? "BACK" : "MENU");
                        graphics.setFont(this.font);
                        this.PrintTextStrings(graphics);
                        break;
                    }
                    case 11: {
                        graphics.drawString(Strings.missionTitle[this.missionNumberCurrent], this.halfWidth, 4, 17);
                        if (this.missionNumberCurrent < 8) {
                            this.ShowButtons(graphics, "CONTINUE", "MENU");
                        } else {
                            this.ShowButtons(graphics, null, "MENU");
                        }
                        graphics.setFont(this.font);
                        this.PrintTextStrings(graphics);
                        break;
                    }
                    case 12: 
                    case 13: {
                        this.ShowButtons(graphics, "RESTART", "MENU");
                        graphics.drawString("All units killed", this.halfWidth, this.halfHeight, 17);
                        break;
                    }
                    case 9: {
                        int n = this.halfWidth - 22;
                        int n3 = 23;
                        int n4 = 0;
                        while (n4 < 3) {
                            graphics.setClip(n, n3, 12, 12);
                            if (this.playerType[n4] >= 0) {
                                graphics.drawImage(this.symbolsImage, n - 12 * this.playerType[n4], n3 - 5, 20);
                            } else {
                                graphics.drawImage(this.symbolsImage, n - 60, n3 - 5, 20);
                            }
                            n += 16;
                            ++n4;
                        }
                        n = 10;
                        graphics.setClip(n, n3 += 16, 32, 48);
                        graphics.drawImage(this.specialImage, n - 31 * this.frameCount, n3, 20);
                        graphics.setClip(n + 4, n3 + 56, 5, 9);
                        graphics.drawImage(this.arrowsImage, n + 4, n3 + 52, 20);
                        graphics.setClip(n + 22, n3 + 56, 5, 9);
                        graphics.drawImage(this.arrowsImage, n + 18, n3 + 52, 20);
                        graphics.setClip(0, 0, this.width, this.height);
                        graphics.drawString("Select Squad", this.halfWidth, 4, 17);
                        if (this.playerType[0] == this.frameCount || this.playerType[1] == this.frameCount || this.playerType[2] == this.frameCount) {
                            graphics.drawString("DROP", 4, this.height - 4 - this.largeFontHeight, 20);
                        } else if (this.playerType[0] < 0 || this.playerType[1] < 0 || this.playerType[2] < 0) {
                            graphics.drawString("SELECT", 4, this.height - 4 - this.largeFontHeight, 20);
                        }
                        if (this.playerType[0] >= 0 && this.playerType[1] >= 0 && this.playerType[2] >= 0) {
                            graphics.drawString("CONTINUE", this.width - 4, this.height - 4 - this.largeFontHeight, 24);
                        }
                        graphics.setFont(this.font);
                        n = this.halfWidth + 16;
                        n3 = this.halfHeight - 20;
                        graphics.drawString(Strings.playerName[this.frameCount], n, n3, 17);
                        graphics.drawString("Armor: ", n, n3 + this.fontHeight + 4, 17);
                        graphics.drawString(Strings.armourLevel[INITIAL_HEALTH[this.frameCount] - 1], n, n3 + 2 * this.fontHeight + 4, 17);
                        graphics.drawString("Special: ", n, n3 + 3 * this.fontHeight + 4, 17);
                        graphics.drawString(Strings.playerSpecialName[this.frameCount], n, n3 + 4 * this.fontHeight + 4, 17);
                        break;
                    }
                    case 10: {
                        graphics.drawString("Select Squad", this.halfWidth, 4, 17);
                        this.ShowButtons(graphics, "CONFIRM", "CHANGE");
                        int n = 0;
                        while (n < 3) {
                            graphics.setClip(this.halfWidth - 50 + 34 * n, this.halfHeight - 24, 32, 48);
                            graphics.drawImage(this.specialImage, this.halfWidth - 50 + 34 * n - 31 * this.playerType[n], this.halfHeight - 24, 20);
                            ++n;
                        }
                        break;
                    }
                    case 16: {
                        graphics.drawImage(this.titleImage, this.halfWidth, 4, 17);
                        this.ShowButtons(graphics, "CONTINUE", null);
                        graphics.setFont(this.font);
                        this.PrintTextStrings(graphics);
                    }
                }
            }
        }
    }

    private void PrintMenuStrings(Graphics graphics) {
        int n = 0;
        while (n < this.menuLines) {
            graphics.drawString(this.menuStringArray[this.menuStart + n - 1], this.halfWidth, this.menuGraphicHeight + 1 + this.menuLineHeight * n, 17);
            ++n;
        }
        int n2 = this.menuGraphicHeight + this.menuLineHeight * (this.menuSelection - this.menuStart);
        graphics.setClip(4, n2, 16, 16);
        graphics.drawImage(this.unitImage, 4 - (this.frameCount << 4), n2 - 64, 20);
        graphics.setClip(this.width - 4 - 16, n2, 16, 16);
        graphics.drawImage(this.unitImage, this.width - 4 - 16 - (this.frameCount << 4), n2 - 48, 20);
        if (this.menuStart > 1 || this.menuStart + this.menuLines <= this.menuLength) {
            graphics.setClip(this.halfWidth - 3, this.height - 4 - 9, 7, 4);
            graphics.drawImage(this.arrowsImage, this.halfWidth - 4, this.height - 4 - (this.menuStart == 1 ? 9 : 13), 20);
            graphics.setClip(this.halfWidth - 3, this.height - 4 - 4, 7, 4);
            graphics.drawImage(this.arrowsImage, this.halfWidth - 4, this.height - 4 - (this.menuStart + this.menuLines > this.menuLength ? 17 : 13), 20);
        }
    }

    private void PrintTextStrings(Graphics graphics) {
        int n = 0;
        while (n < this.menuLines) {
            graphics.drawString(this.menuStringArray[this.menuStart + n - 1], 4, this.menuGraphicHeight + 1 + this.menuLineHeight * n, 20);
            ++n;
        }
        if (this.menuStart > 1 || this.menuStart + this.menuLines <= this.menuLength) {
            int n2 = this.menuLines * this.menuLineHeight;
            graphics.drawRect(this.width - 4 - 7, this.menuGraphicHeight + 5, 6, n2 - 11);
            if (this.menuLines >= this.menuLength) {
                graphics.fillRect(this.width - 4 - 5, this.menuGraphicHeight + 7, 3, n2 - 14);
            } else {
                graphics.fillRect(this.width - 4 - 5, this.menuGraphicHeight + (this.menuStart - 1) * (n2 - 14) / this.menuLength + 7, 3, this.menuLines * (n2 - 14) / this.menuLength);
            }
            graphics.setClip(this.width - 4 - 7, (int)this.menuGraphicHeight, 7, 4);
            graphics.drawImage(this.arrowsImage, this.width - 4 - 8, this.menuStart == 1 ? this.menuGraphicHeight : this.menuGraphicHeight - 4, 20);
            graphics.setClip(this.width - 4 - 7, this.menuGraphicHeight + n2 - 4, 7, 4);
            graphics.drawImage(this.arrowsImage, this.width - 4 - 8, this.menuGraphicHeight + n2 - (this.menuStart + this.menuLines > this.menuLength ? 17 : 13), 20);
        }
    }

    private void ShowButtons(Graphics graphics, String string, String string2) {
        if (string != null) {
            graphics.drawString(string, 4, this.height - 4 - this.largeFontHeight, 20);
        }
        if (string2 != null) {
            graphics.drawString(string2, this.width - 4, this.height - 4 - this.largeFontHeight, 24);
        }
    }

    private void CheckTextUpAndDown(int n) {
        if (n == 1 && this.menuStart > 1) {
            this.menuStart = (short)(this.menuStart - 1);
        } else if (n == 6 && this.menuStart + this.menuLines <= this.menuLength) {
            this.menuStart = (short)(this.menuStart + 1);
        }
    }

    private void CheckMenuUpAndDown(int n) {
        if (n == 1 && this.menuSelection > 1) {
            this.menuSelection = (short)(this.menuSelection - 1);
            if (this.menuSelection < this.menuStart) {
                this.menuStart = (short)(this.menuStart - 1);
            }
            this.repaint();
        } else if (n == 6 && this.menuSelection < this.menuLength) {
            this.menuSelection = (short)(this.menuSelection + 1);
            if (this.menuSelection >= this.menuStart + this.menuLines) {
                this.menuStart = (short)(this.menuStart + 1);
            }
            this.repaint();
        }
    }

    private void UpdateStatusBar() {
        Graphics graphics = this.statusBar.getGraphics();
        graphics.setColor(0);
        graphics.fillRect(0, 0, 66, 14);
        graphics.setClip(1, 1, 12, 12);
        graphics.drawImage(this.symbolsImage, 1 - 12 * this.playerType[this.currentPlayer], -4, 20);
        graphics.setClip(0, 0, 66, 14);
        int n = 0;
        while (n < 3) {
            graphics.setColor(0xFFFFFF);
            graphics.drawRect(14 + n * 9, 1, 9, 11);
            if (this.playerHealth[this.currentPlayer] > n) {
                graphics.setColor(0xFF0000);
                graphics.fillRect(15 + n * 9, 2, 8, 10);
            }
            ++n;
        }
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(43, 1, 22, 12);
        if (this.playerType[this.currentPlayer] != 4 && this.playerType[this.currentPlayer] != 3) {
            graphics.setClip(43, 2, 10, 10);
            graphics.drawImage(this.specialImage, -21, 2 - 10 * WEAPON_TYPE[this.playerType[this.currentPlayer]], 20);
            graphics.setClip(0, 0, 66, 14);
            graphics.setColor(0);
            graphics.setFont(this.font);
            graphics.drawString("" + this.playerSpecial[this.currentPlayer], 64, 2, 24);
        }
    }

    private void SetInvisibility(byte by, boolean bl) {
        if (bl) {
            if (by == this.currentPlayer) {
                Graphics graphics = this.statusBar.getGraphics();
                graphics.setClip(43, 2, 10, 10);
                graphics.drawImage(this.symbolsImage, -29, -4, 20);
            }
            this.playerSpecial[by] = this.clockTicks + 180;
        } else {
            if (by == this.currentPlayer) {
                Graphics graphics = this.statusBar.getGraphics();
                graphics.setClip(43, 2, 10, 10);
                graphics.setColor(0xFFFFFF);
                graphics.fillRect(43, 2, 10, 10);
            }
            this.playerSpecial[by] = 0;
        }
    }

    private void RedrawSceneryAbove(Graphics graphics, int n, int n2, int n3, int n4, byte by) {
        int n5 = n2 >> 4;
        while (n5 <= n2 + n4 >> 4) {
            if (n5 >= 0 && n5 < 128) {
                int n6 = n >> 4;
                while (n6 <= n + n3 >> 4) {
                    if (n6 >= 0 && n6 < 11 && this.TileBlockData[this.MapData[n5][n6]] == 2) {
                        graphics.setClip((n6 << 4) - this.screenImageLeft, (n5 << 4) - this.screenImageTop, 16, 16);
                        graphics.drawImage(this.tilesImage, (n6 - this.TileTextureData[this.MapData[n5][n6]] << 4) - this.screenImageLeft, (n5 << 4) - this.screenImageTop, 20);
                        if (by >= 0 && this.playerHealth[by] >= 0 && this.squareMax < 30) {
                            this.squarePlayer[this.squareMax] = by;
                            this.squareRow[this.squareMax] = (byte)n5;
                            this.squareCol[this.squareMax] = (byte)n6;
                            this.squareMax = (byte)(this.squareMax + 1);
                        }
                    }
                    ++n6;
                }
            }
            ++n5;
        }
    }

    protected void keyPressed(int n) {
        if (this.screenType == 2) {
            this.nextKeyCode = n;
        } else {
            int n2 = this.getGameAction(n);
            if (this.screenType >= 100) {
                if (n == -7) {
                    short s = (short)(this.screenType - 99);
                    this.SetMenuScreenType((short)3);
                    this.StartSimpleTimer((short)2, 100);
                    this.SetMenuSelection(s);
                } else {
                    this.CheckTextUpAndDown(n2);
                }
            } else {
                switch (this.screenType) {
                    case 0: {
                        this.simpletimertask.cancel();
                        this.GoToMainMenu(true);
                        break;
                    }
                    case 1: {
                        if (n == -6 || n2 == 8) {
                            switch (this.menuSelection) {
                                case 1: {
                                    if (this.missionNumberMax > 0) {
                                        this.SetMenuScreenType((short)6);
                                        break;
                                    }
                                    this.simpletimertask.cancel();
                                    this.SetMenuScreenType((short)7);
                                    break;
                                }
                                case 2: {
                                    this.SetMenuScreenType((short)4);
                                    break;
                                }
                                case 3: {
                                    this.SetMenuScreenType((short)3);
                                    break;
                                }
                                case 4: {
                                    this.simpletimertask.cancel();
                                    this.SetMenuScreenType((short)16);
                                }
                            }
                            break;
                        }
                        this.CheckMenuUpAndDown(n2);
                        break;
                    }
                    case 3: {
                        if (n == -6 || n2 == 8) {
                            this.simpletimertask.cancel();
                            this.SetMenuScreenType((short)(99 + this.menuSelection));
                            break;
                        }
                        if (n == -7) {
                            this.GoToMainMenu(false);
                            this.SetMenuSelection((short)3);
                            break;
                        }
                        if (n == 49) {
                            if (this.clockTicks != 0) break;
                            ++this.clockTicks;
                            break;
                        }
                        if (n == 51) {
                            if (this.clockTicks == 2) {
                                ++this.clockTicks;
                                break;
                            }
                            this.clockTicks = 0;
                            break;
                        }
                        if (n == 57) {
                            if (this.clockTicks == 1) {
                                ++this.clockTicks;
                                break;
                            }
                            if (this.clockTicks == 3) {
                                this.missionNumberMax = (byte)8;
                                break;
                            }
                            this.clockTicks = 0;
                            break;
                        }
                        this.CheckMenuUpAndDown(n2);
                        break;
                    }
                    case 4: {
                        if (n == -6 || n2 == 8) {
                            switch (this.menuSelection) {
                                case 1: {
                                    this.soundOn = !this.soundOn;
                                    this.menuStringArray[0] = this.soundOn ? "Sound: ON" : "Sound: OFF";
                                    this.writeRecords();
                                    break;
                                }
                                case 2: {
                                    this.simpletimertask.cancel();
                                    this.screenType = (short)15;
                                }
                            }
                            break;
                        }
                        if (n == -7) {
                            this.GoToMainMenu(false);
                            this.SetMenuSelection((short)2);
                            break;
                        }
                        this.CheckMenuUpAndDown(n2);
                        break;
                    }
                    case 15: {
                        if (n == -6 || n2 == 8) {
                            this.missionNumberMax = 0;
                            this.missionNumberCurrent = 0;
                            int n3 = 0;
                            while (n3 <= 8) {
                                this.missionTime[n3] = 0;
                                ++n3;
                            }
                            this.writeRecords();
                            this.GoToMainMenu(true);
                            break;
                        }
                        if (n != -7) break;
                        this.StartSimpleTimer((short)2, 100);
                        this.screenType = (short)4;
                        break;
                    }
                    case 5: {
                        if (n == -6 || n2 == 8) {
                            switch (this.menuSelection) {
                                case 1: {
                                    this.soundOn = !this.soundOn;
                                    this.menuStringArray[0] = this.soundOn ? "Sound: ON" : "Sound: OFF";
                                    this.writeRecords();
                                    break;
                                }
                                case 2: {
                                    this.simpletimertask.cancel();
                                    this.tilesImage = null;
                                    this.specialImage = null;
                                    this.titleImage = null;
                                    this.arrowsImage = null;
                                    System.gc();
                                    this.screenType = (short)14;
                                    this.StartSimpleTimer((short)4, 400);
                                    break;
                                }
                                case 3: {
                                    this.GetGameImages(false);
                                    this.GoToMainMenu(false);
                                }
                            }
                            break;
                        }
                        if (n == -7) {
                            this.simpletimertask.cancel();
                            this.frameCount = 0;
                            this.StartSimpleTimer((short)0, 50);
                            this.screenType = (short)2;
                            break;
                        }
                        this.CheckMenuUpAndDown(n2);
                        break;
                    }
                    case 6: {
                        if (n == -6 || n2 == 8) {
                            this.simpletimertask.cancel();
                            this.missionNumberCurrent = (byte)(this.missionNumberMax - this.menuSelection + 1);
                            this.SetMenuScreenType((short)7);
                            break;
                        }
                        if (n == -7) {
                            this.GoToMainMenu(false);
                            break;
                        }
                        this.CheckMenuUpAndDown(n2);
                        break;
                    }
                    case 7: 
                    case 8: {
                        if (n == -6 || n2 == 8) {
                            this.GetSpecialImage("select");
                            this.playerType[2] = -1;
                            this.playerType[1] = -1;
                            this.playerType[0] = -1;
                            this.frameCount = 0;
                            this.screenType = (short)9;
                            break;
                        }
                        if (n == -7) {
                            if (this.screenType == 8 || this.missionNumberMax == 0) {
                                this.GoToMainMenu(true);
                                break;
                            }
                            this.StartSimpleTimer((short)2, 100);
                            this.SetMenuScreenType((short)6);
                            break;
                        }
                        this.CheckTextUpAndDown(n2);
                        break;
                    }
                    case 9: {
                        if (n == -6 || n2 == 8) {
                            int n4 = -1;
                            int n5 = -1;
                            int n6 = 0;
                            while (n6 < 3) {
                                if (this.playerType[n6] < 0 && n4 < 0) {
                                    n4 = n6;
                                }
                                if (this.playerType[n6] == this.frameCount) {
                                    n5 = n6;
                                    break;
                                }
                                ++n6;
                            }
                            if (n5 >= 0) {
                                this.playerType[n5] = -1;
                                while (n5 < 2) {
                                    this.playerType[n5] = this.playerType[n5 + 1];
                                    this.playerType[n5 + 1] = -1;
                                    ++n5;
                                }
                                break;
                            }
                            if (n4 < 0) break;
                            this.playerType[n4] = this.frameCount;
                            this.frameCount = (byte)((this.frameCount + 1) % 5);
                            break;
                        }
                        if (n == -7 && this.playerType[0] >= 0 && this.playerType[1] >= 0 && this.playerType[2] >= 0) {
                            this.screenType = (short)10;
                            break;
                        }
                        if (n2 == 2 || n2 == 1) {
                            this.frameCount = (byte)(this.frameCount - 1);
                            if (this.frameCount >= 0) break;
                            this.frameCount = (byte)4;
                            break;
                        }
                        if (n2 != 5 && n2 != 6) break;
                        this.frameCount = (byte)((this.frameCount + 1) % 5);
                        break;
                    }
                    case 10: {
                        if (n == -6 || n2 == 8) {
                            this.menuStringArray = null;
                            this.specialImage = null;
                            this.titleImage = null;
                            this.arrowsImage = null;
                            System.gc();
                            this.ReadMap();
                            System.gc();
                            this.frameCount = 0;
                            this.showOrders = 0;
                            this.UpdateStatusBar();
                            this.clockTicks = 0;
                            this.endLevel = false;
                            this.screenType = (short)2;
                            this.startTime = System.currentTimeMillis();
                            this.StartSimpleTimer((short)0, 50);
                            break;
                        }
                        if (n != -7) break;
                        this.frameCount = 0;
                        this.screenType = (short)9;
                        break;
                    }
                    case 11: {
                        if ((n == -6 || n2 == 8) && this.missionNumberCurrent < 8) {
                            this.missionNumberCurrent = (byte)(this.missionNumberCurrent + 1);
                            this.GetGameImages(false);
                            this.SetMenuScreenType((short)8);
                            break;
                        }
                        if (n == -7) {
                            this.GetGameImages(false);
                            this.GoToMainMenu(true);
                            break;
                        }
                        this.CheckTextUpAndDown(n2);
                        break;
                    }
                    case 12: {
                        if (n == -6 || n2 == 8) {
                            this.tilesImage = null;
                            this.specialImage = null;
                            this.titleImage = null;
                            this.arrowsImage = null;
                            System.gc();
                            this.screenType = (short)13;
                            this.StartSimpleTimer((short)4, 400);
                            break;
                        }
                        if (n != -7) break;
                        this.GetGameImages(false);
                        this.GoToMainMenu(true);
                        break;
                    }
                    case 16: {
                        if (n == -6 || n2 == 8) {
                            this.cod.midletExit();
                            break;
                        }
                        this.CheckTextUpAndDown(n2);
                    }
                }
            }
            this.repaint();
        }
    }

    private void GoToMainMenu(boolean bl) {
        this.SetMenuScreenType((short)1);
        this.frameCount = 0;
        if (bl) {
            this.StartSimpleTimer((short)2, 100);
        }
    }

    private void SetMenuSelection(short s) {
        this.menuStart = 1;
        this.menuSelection = s;
        if (this.menuSelection >= this.menuStart + this.menuLines) {
            this.menuStart = (short)(this.menuSelection - this.menuLines + 1);
        }
    }

    protected void keyReleased(int n) {
        if (this.nextKeyCode == n) {
            this.nextKeyCode = 0;
        }
    }

    private void StartSimpleTimer(short s, int n) {
        this.simpletimertask = new SimpleTimerTask(this, s);
        this.timer.schedule((TimerTask)this.simpletimertask, n);
    }

    public void SimpleTimerEndEvent(short s) {
        if (s == 0) {
            boolean bl;
            byte by;
            byte by2;
            int n;
            int n2;
            byte by3;
            int n3;
            int n4;
            int n5;
            int n6;
            ++this.clockTicks;
            this.frameCount = this.frameCount == 5 ? (byte)0 : (byte)(this.frameCount + 1);
            this.currentKeyCode = this.nextKeyCode;
            int n7 = -1;
            byte by4 = this.playerArrayStart;
            while (by4 >= 0) {
                if (this.playerHealth[by4] < 0) {
                    byte by5 = by4;
                    this.playerHealth[by5] = (byte)(this.playerHealth[by5] - 1);
                    if (this.playerHealth[by4] + 30 < 0) {
                        if (n7 >= 0) {
                            this.playerArrayNext[n7] = this.playerArrayNext[by4];
                        } else {
                            this.playerArrayStart = this.playerArrayNext[by4];
                            if (this.playerArrayStart == this.opponentArrayStart) {
                                this.PlaySound(this.loseSound);
                                this.screenType = (short)12;
                                this.allowKeyPresses = false;
                                this.StartSimpleTimer((short)3, 750);
                                this.repaint();
                                return;
                            }
                        }
                        if (by4 == this.opponentArrayStart) {
                            this.opponentArrayStart = this.playerArrayNext[by4];
                        }
                    } else {
                        n7 = by4;
                    }
                } else {
                    n7 = by4;
                }
                by4 = this.playerArrayNext[by4];
            }
            by4 = this.playerArrayStart;
            while (by4 != this.opponentArrayStart) {
                if (this.playerType[by4] == 3 && this.clockTicks == this.playerSpecial[by4]) {
                    this.SetInvisibility(by4, false);
                }
                by4 = this.playerArrayNext[by4];
            }
            int n8 = -1;
            byte by6 = this.projectileArrayUsedStart;
            while (by6 >= 0) {
                boolean bl2 = false;
                byte by7 = this.projectileDirection[by6];
                byte by8 = by6;
                this.projectileTime[by8] = (byte)(this.projectileTime[by8] + 1);
                byte by9 = this.projectileArrayNext[by6];
                switch (this.projectileType[by6]) {
                    case 99: {
                        if (this.projectileTime[by6] > 10) {
                            bl2 = true;
                            break;
                        }
                        byte by10 = by6;
                        this.projectileX[by10] = this.projectileX[by10] + bulletDeltaX[by7];
                        byte by11 = by6;
                        this.projectileY[by11] = this.projectileY[by11] + bulletDeltaY[by7];
                        n6 = this.projectileX[by6] + bulletEndDeltaX[by7];
                        n5 = this.projectileY[by6] + bulletEndDeltaY[by7];
                        if (n6 < 0 || n6 >= 176 || n5 < 0 || n5 >= 2048 || this.TileBlockData[this.MapData[n5 >> 4][n6 >> 4]] <= 1) {
                            bl2 = true;
                            break;
                        }
                        bl2 = this.CheckPlayerDamage(n6, n6 - 16, n5, n5 - 16, (byte)1);
                        break;
                    }
                    case 1: {
                        if (this.projectileTime[by6] <= 2) break;
                        bl2 = true;
                        break;
                    }
                    case 0: {
                        if (this.projectileTime[by6] > 8) {
                            this.DoExplosion(by6, 1);
                            break;
                        }
                        byte by12 = by6;
                        this.projectileX[by12] = this.projectileX[by12] + bulletDeltaX[by7];
                        byte by13 = by6;
                        this.projectileY[by13] = this.projectileY[by13] + bulletDeltaY[by7];
                        n6 = this.projectileX[by6];
                        n5 = this.projectileY[by6];
                        if (n6 >= -3 && n6 <= 179 && n5 >= -4 && n5 <= 2053) break;
                        bl2 = true;
                        break;
                    }
                    case 2: {
                        if (this.projectileTime[by6] <= 38) break;
                        this.DoExplosion(by6, 2);
                        break;
                    }
                    case 10: {
                        if (this.projectileTime[by6] <= 4) break;
                        bl2 = true;
                    }
                }
                if (bl2) {
                    if (n8 >= 0) {
                        this.projectileArrayNext[n8] = by9;
                    } else {
                        this.projectileArrayUsedStart = by9;
                    }
                    this.projectileArrayNext[by6] = this.projectileArrayUnusedStart;
                    this.projectileArrayUnusedStart = by6;
                } else {
                    n8 = by6;
                }
                by6 = by9;
            }
            this.playerMoving[this.currentPlayer] = false;
            if (this.currentKeyCode != 0) {
                n4 = this.getGameAction(this.currentKeyCode);
                if (n4 == 8 || this.currentKeyCode == 53) {
                    this.PlaySound(this.fireSound);
                    this.StartProjectile(this.currentPlayer, (byte)99);
                    if (this.playerType[this.currentPlayer] == 3 && this.clockTicks < this.playerSpecial[this.currentPlayer]) {
                        this.SetInvisibility(this.currentPlayer, false);
                    }
                    this.nextKeyCode = 0;
                } else if (this.currentKeyCode == 42) {
                    n3 = this.playerType[this.currentPlayer];
                    if (n3 == 3 && this.clockTicks < this.playerSpecial[this.currentPlayer]) {
                        this.PlaySound(this.secondarySound);
                        n6 = this.playerX[this.currentPlayer];
                        n5 = this.playerY[this.currentPlayer];
                        by4 = this.opponentArrayStart;
                        while (by4 >= 0) {
                            if (this.playerHealth[by4] >= 0 && this.playerX[by4] <= n6 + 16 && this.playerX[by4] >= n6 - 16 && this.playerY[by4] <= n5 + 16 && this.playerY[by4] >= n5 - 16) {
                                this.playerHealth[by4] = -1;
                            }
                            by4 = this.playerArrayNext[by4];
                        }
                        this.nextKeyCode = 0;
                    } else if (this.clockTicks > this.playerNextShot[this.currentPlayer] && this.playerSpecial[this.currentPlayer] > 0) {
                        this.PlaySound(this.secondarySound);
                        byte by14 = this.currentPlayer;
                        this.playerSpecial[by14] = this.playerSpecial[by14] - 1;
                        this.UpdateStatusBar();
                        switch (n3) {
                            case 0: {
                                this.StartProjectile(this.currentPlayer, (byte)0);
                                this.playerNextShot[this.currentPlayer] = this.clockTicks + 10;
                                break;
                            }
                            case 1: {
                                this.StartProjectile(this.currentPlayer, (byte)1);
                                this.playerNextShot[this.currentPlayer] = this.clockTicks + 10;
                                break;
                            }
                            case 2: {
                                this.StartProjectile(this.currentPlayer, (byte)2);
                                this.playerNextShot[this.currentPlayer] = this.clockTicks + 10;
                            }
                        }
                    }
                } else {
                    if (this.currentKeyCode == -7) {
                        this.SetMenuScreenType((short)5);
                        this.frameCount = 0;
                        this.StartSimpleTimer((short)2, 100);
                        this.repaint();
                        return;
                    }
                    if (this.currentKeyCode == 35) {
                        this.currentPlayer = this.NextUnit(this.currentPlayer);
                        this.PlaySound(this.unitSound);
                        this.playerDirection[this.currentPlayer] = 1;
                        this.nextKeyCode = 0;
                        if (this.playerType[this.currentPlayer] == 4) {
                            this.takeCover = true;
                            this.showOrders = this.clockTicks + 50;
                        }
                        if (this.takeCover) {
                            this.SetHidingAims(this.currentPlayer);
                        }
                        this.UpdateStatusBar();
                        by4 = this.playerArrayStart;
                        while (by4 != this.opponentArrayStart) {
                            this.playerShowStatus[by4] = this.clockTicks + 60;
                            by4 = this.playerArrayNext[by4];
                        }
                    } else if (this.currentKeyCode == 48) {
                        boolean bl3 = this.takeCover = !this.takeCover;
                        if (this.takeCover) {
                            this.SetHidingAims(this.currentPlayer);
                        } else {
                            this.playerAimY[1] = -1;
                            this.playerAimY[0] = -1;
                            this.playerAimX[1] = -1;
                            this.playerAimX[0] = -1;
                        }
                        this.showOrders = this.clockTicks + 50;
                        this.nextKeyCode = 0;
                    } else {
                        by3 = 4;
                        switch (n4) {
                            case 1: {
                                by3 = 1;
                                break;
                            }
                            case 2: {
                                by3 = 3;
                                break;
                            }
                            case 5: {
                                by3 = 5;
                                break;
                            }
                            case 6: {
                                by3 = 7;
                                break;
                            }
                            default: {
                                if (this.currentKeyCode < 49 || this.currentKeyCode > 57) break;
                                by3 = (byte)(this.currentKeyCode - 49);
                            }
                        }
                        if (by3 != 4) {
                            this.playerDirection[this.currentPlayer] = by3;
                            int n9 = n2 = this.TileBlockData[this.MapData[this.playerY[this.currentPlayer] + 8 >> 4][this.playerX[this.currentPlayer] + 8 >> 4]] == 3 ? 1 : 2;
                            if (by3 < 3) {
                                n = this.MovePlayerUp(this.currentPlayer, n2);
                                if (n > 0) {
                                    byte by15 = this.currentPlayer;
                                    this.playerY[by15] = this.playerY[by15] - n;
                                } else {
                                    by3 = (byte)(by3 + 3);
                                }
                            } else if (by3 > 5) {
                                n = this.MovePlayerDown(this.currentPlayer, n2);
                                if (n > 0) {
                                    byte by16 = this.currentPlayer;
                                    this.playerY[by16] = this.playerY[by16] + n;
                                } else {
                                    by3 = (byte)(by3 - 3);
                                }
                            }
                            if (by3 % 3 == 0) {
                                n = this.MovePlayerLeft(this.currentPlayer, n2);
                                if (n > 0) {
                                    byte by17 = this.currentPlayer;
                                    this.playerX[by17] = this.playerX[by17] - n;
                                } else {
                                    by3 = (byte)(by3 + 1);
                                }
                            } else if (by3 % 3 == 2) {
                                n = this.MovePlayerRight(this.currentPlayer, n2);
                                if (n > 0) {
                                    byte by18 = this.currentPlayer;
                                    this.playerX[by18] = this.playerX[by18] + n;
                                } else {
                                    by3 = (byte)(by3 - 1);
                                }
                            }
                        }
                        if (by3 != 4) {
                            this.playerMoving[this.currentPlayer] = true;
                        }
                        if (this.endLevel) {
                            if (this.missionNumberCurrent == this.missionNumberMax && this.missionNumberMax < 8) {
                                this.missionNumberMax = (byte)(this.missionNumberMax + 1);
                                this.writeRecords();
                            }
                            this.PlaySound(this.winSound);
                            this.SetMenuScreenType((short)11);
                            this.allowKeyPresses = false;
                            this.StartSimpleTimer((short)3, 750);
                            this.repaint();
                            return;
                        }
                    }
                }
            }
            if (this.playerDirection[this.currentPlayer] < 3) {
                n5 = this.screenImageTop + this.height - this.playerY[this.currentPlayer] - 16 - 22;
                if (n5 > 0) {
                    this.MoveScreenUp(n5);
                } else if (n5 < 0) {
                    this.MoveScreenDown(-n5);
                }
            } else if (this.playerDirection[this.currentPlayer] > 5) {
                n5 = this.playerY[this.currentPlayer] - this.screenImageTop - 22;
                if (n5 > 0) {
                    this.MoveScreenDown(n5);
                } else if (n5 < 0) {
                    this.MoveScreenUp(-n5);
                }
            }
            if (this.playerDirection[this.currentPlayer] % 3 == 0) {
                n6 = this.screenImageLeft + this.width - this.playerX[this.currentPlayer] - 16 - 22;
                if (n6 > 0) {
                    this.MoveScreenLeft(n6);
                } else if (n6 < 0) {
                    this.MoveScreenRight(-n6);
                }
            } else if (this.playerDirection[this.currentPlayer] % 3 == 2) {
                n6 = this.playerX[this.currentPlayer] - this.screenImageLeft - 22;
                if (n6 > 0) {
                    this.MoveScreenRight(n6);
                } else if (n6 < 0) {
                    this.MoveScreenLeft(-n6);
                }
            }
            by4 = this.NextUnit(this.currentPlayer);
            n4 = 0;
            n3 = 0;
            byte by19 = 0;
            boolean bl4 = false;
            while (by4 != this.currentPlayer) {
                if (this.playerHealth[by4] >= 0) {
                    by2 = this.playerDirection[by4];
                    boolean bl5 = true;
                    if (this.playerY[by4] >= this.screenImageTop && this.playerY[by4] <= this.screenImageTop + this.height - 16 && this.playerX[by4] >= this.screenImageLeft && this.playerX[by4] <= this.screenImageLeft + this.width - 16) {
                        by = this.opponentArrayStart;
                        bl = by >= 0;
                        while (bl) {
                            if (this.playerHealth[by] >= 0 && this.playerY[by] >= this.screenImageTop && this.playerY[by] <= this.screenImageTop + this.height - 16 && this.playerX[by] >= this.screenImageLeft && this.playerX[by] <= this.screenImageLeft + this.width - 16 && this.TargetAhead(by2, n6 = this.playerX[by] - this.playerX[by4], n5 = this.playerY[by] - this.playerY[by4]) && this.HasClearView(this.playerX[by4] + 8, this.playerY[by4] + 8, n6, n5)) {
                                by3 = this.GetDirection(n6, n5);
                                byte by20 = this.NextUnit(by4);
                                boolean bl6 = true;
                                while (bl6 && by20 != by4) {
                                    n6 = this.playerX[by20] - this.playerX[by4];
                                    n5 = this.playerY[by20] - this.playerY[by4];
                                    switch (by3) {
                                        case 0: {
                                            bl6 = n6 > 0 || n5 > n6 + 8 || n5 < n6 - 8;
                                            break;
                                        }
                                        case 1: {
                                            bl6 = n5 > 0 || n6 > 8 || n6 < -8;
                                            break;
                                        }
                                        case 2: {
                                            bl6 = n6 < 0 || n6 + n5 > 8 || n6 + n5 < -8;
                                            break;
                                        }
                                        case 3: {
                                            bl6 = n6 > 0 || n5 > 8 || n5 < -8;
                                            break;
                                        }
                                        case 5: {
                                            bl6 = n6 < 0 || n5 > 8 || n5 < -8;
                                            break;
                                        }
                                        case 6: {
                                            bl6 = n6 > 0 || n6 + n5 > 8 || n6 + n5 < -8;
                                            break;
                                        }
                                        case 7: {
                                            bl6 = n5 < 0 || n6 > 8 || n6 < -8;
                                            break;
                                        }
                                        case 8: {
                                            bl6 = n6 < 0 || n5 > n6 + 8 || n5 < n6 - 8;
                                        }
                                    }
                                    by20 = this.NextUnit(by20);
                                }
                                if (bl6) {
                                    if (this.clockTicks <= this.playerNextShot[by4]) break;
                                    this.playerDirection[by4] = by3;
                                    this.StartProjectile(by4, (byte)99);
                                    this.playerNextShot[by4] = this.clockTicks + 10;
                                    bl5 = false;
                                    break;
                                }
                            }
                            if ((by = this.playerArrayNext[by]) >= 0) continue;
                            bl = false;
                        }
                    }
                    if (bl5) {
                        int n10 = n2 = this.TileBlockData[this.MapData[this.playerY[by4] + 8 >> 4][this.playerX[by4] + 8 >> 4]] == 3 ? 1 : 2;
                        if (by19 == 0) {
                            if (this.playerAimX[0] >= 0) {
                                n4 = this.playerAimX[0];
                                n3 = this.playerAimY[0];
                            } else if (this.takeCover) {
                                n4 = this.playerX[by4];
                                n3 = this.playerY[by4];
                            } else if (this.playerDirection[this.currentPlayer] == 3) {
                                n4 = this.playerX[this.currentPlayer] + 16;
                                n3 = this.playerY[this.currentPlayer] + 16;
                            } else if (this.playerDirection[this.currentPlayer] == 5) {
                                n4 = this.playerX[this.currentPlayer] - 16;
                                n3 = this.playerY[this.currentPlayer] - 16;
                            } else if (this.playerDirection[this.currentPlayer] < 3) {
                                n4 = this.playerX[this.currentPlayer] - 16;
                                n3 = this.playerY[this.currentPlayer] + 16;
                            } else {
                                n4 = this.playerX[this.currentPlayer] + 16;
                                n3 = this.playerY[this.currentPlayer] - 16;
                            }
                        } else if (this.playerAimX[1] >= 0) {
                            n4 = this.playerAimX[1];
                            n3 = this.playerAimY[1];
                        } else if (this.takeCover) {
                            n4 = this.playerX[by4];
                            n3 = this.playerY[by4];
                        } else if (this.playerDirection[this.currentPlayer] == 3) {
                            n4 = this.playerX[this.currentPlayer] + 16;
                            n3 = this.playerY[this.currentPlayer] - 16;
                        } else if (this.playerDirection[this.currentPlayer] == 5) {
                            n4 = this.playerX[this.currentPlayer] - 16;
                            n3 = this.playerY[this.currentPlayer] + 16;
                        } else if (this.playerDirection[this.currentPlayer] < 3) {
                            n4 = this.playerX[this.currentPlayer] + 16;
                            n3 = this.playerY[this.currentPlayer] + 16;
                        } else {
                            n4 = this.playerX[this.currentPlayer] - 16;
                            n3 = this.playerY[this.currentPlayer] - 16;
                        }
                        by3 = 4;
                        if (n3 < this.playerY[by4]) {
                            n = this.MovePlayerUp(by4, Math.min(n2, this.playerY[by4] - n3));
                            if (n > 0) {
                                by3 = (byte)(by3 - 3);
                                byte by21 = by4;
                                this.playerY[by21] = this.playerY[by21] - n;
                            }
                        } else if (n3 > this.playerY[by4] && (n = this.MovePlayerDown(by4, Math.min(n2, n3 - this.playerY[by4]))) > 0) {
                            by3 = (byte)(by3 + 3);
                            byte by22 = by4;
                            this.playerY[by22] = this.playerY[by22] + n;
                        }
                        if (n4 < this.playerX[by4]) {
                            n = this.MovePlayerLeft(by4, Math.min(n2, this.playerX[by4] - n4));
                            if (n > 0) {
                                by3 = (byte)(by3 - 1);
                                byte by23 = by4;
                                this.playerX[by23] = this.playerX[by23] - n;
                            }
                        } else if (n4 > this.playerX[by4] && (n = this.MovePlayerRight(by4, Math.min(n2, n4 - this.playerX[by4]))) > 0) {
                            by3 = (byte)(by3 + 1);
                            byte by24 = by4;
                            this.playerX[by24] = this.playerX[by24] + n;
                        }
                        if (by3 == 4) {
                            if (this.takeCover) {
                                this.playerDirection[by4] = 1;
                            } else {
                                this.playerDirection[by4] = this.playerDirection[this.currentPlayer];
                                if (n4 == this.playerX[by4] && n3 == this.playerY[by4]) {
                                    this.playerAimY[by19] = -1;
                                    this.playerAimX[by19] = -1;
                                } else if (bl4 && by19 == 1 && this.playerAimX[1] >= 0) {
                                    this.playerAimY[1] = -1;
                                    this.playerAimY[0] = -1;
                                    this.playerAimX[1] = -1;
                                    this.playerAimX[0] = -1;
                                } else {
                                    bl4 = this.playerAimX[by19] >= 0;
                                    n6 = this.playerX[by4];
                                    n5 = this.playerY[by4];
                                    if (n3 < n5 - 16 && n5 >= 16) {
                                        if ((n5 & 0xF) == 0) {
                                            this.SetAvoidanceAimUpAndDown(n6 >> 4, n5 >> 4, -1, by19);
                                        }
                                    } else if (n4 < n6 - 16 && n6 >= 16) {
                                        if ((n6 & 0xF) == 0) {
                                            this.SetAvoidanceAimLeftAndRight(n6 >> 4, n5 >> 4, -1, by19);
                                        }
                                    } else if (n4 > n6 + 16 && n6 <= 144) {
                                        if ((n6 & 0xF) == 0) {
                                            this.SetAvoidanceAimLeftAndRight(n6 >> 4, n5 >> 4, 1, by19);
                                        }
                                    } else if (n3 > n5 + 16 && n5 <= 2016 && (n5 & 0xF) == 0) {
                                        this.SetAvoidanceAimUpAndDown(n6 >> 4, n5 >> 4, 1, by19);
                                    }
                                }
                            }
                            this.playerMoving[by4] = false;
                        } else {
                            this.playerDirection[by4] = by3;
                            this.playerMoving[by4] = true;
                        }
                    }
                }
                by4 = this.NextUnit(by4);
                by19 = (byte)(by19 + 1);
            }
            by4 = this.opponentArrayStart;
            while (by4 >= 0) {
                if (this.playerHealth[by4] >= 0 && this.playerY[by4] >= this.screenImageTop && this.playerY[by4] <= this.screenImageTop + this.height - 16 && this.playerX[by4] >= this.screenImageLeft && this.playerX[by4] <= this.screenImageLeft + this.width - 16) {
                    by2 = this.playerDirection[by4];
                    bl = true;
                    boolean bl7 = false;
                    by = this.currentPlayer;
                    while (bl) {
                        if (this.playerHealth[by] >= 0 && (this.playerType[by] != 3 || this.playerSpecial[by] < this.clockTicks) && this.playerY[by] >= this.screenImageTop && this.playerY[by] <= this.screenImageTop + this.height - 16 && this.playerX[by] >= this.screenImageLeft && this.playerX[by] <= this.screenImageLeft + this.width - 16) {
                            n6 = this.playerX[by] - this.playerX[by4];
                            n5 = this.playerY[by] - this.playerY[by4];
                            bl7 = true;
                            if (this.TargetAhead(by2, n6, n5) && this.HasClearView(this.playerX[by4] + 8, this.playerY[by4] + 8, n6, n5)) {
                                by3 = this.GetDirection(n6, n5);
                                if (this.clockTicks > this.playerNextShot[by4]) {
                                    this.playerDirection[by4] = by3;
                                    this.StartProjectile(by4, (byte)99);
                                    this.playerNextShot[by4] = this.clockTicks + 20;
                                    break;
                                }
                                this.MoveEnemy(by4, by3);
                                break;
                            }
                        }
                        if ((by = this.NextUnit(by)) != this.currentPlayer) continue;
                        if (bl7 && (Math.abs(this.random.nextInt()) % 10 < 1 || !this.MoveEnemy(by4, this.playerDirection[by4]))) {
                            int n11 = Math.abs(this.random.nextInt()) % 10;
                            if (n11 < 4) {
                                this.MoveEnemy(by4, (byte)(8 - this.playerDirection[by4]));
                            } else if (n11 < 6) {
                                this.MoveEnemy(by4, (byte)7);
                            } else if (n11 < 8) {
                                this.MoveEnemy(by4, (byte)(n11 * 2 - 6));
                            } else {
                                this.MoveEnemy(by4, (byte)(n11 * 2 - 13));
                            }
                        }
                        bl = false;
                    }
                }
                by4 = this.playerArrayNext[by4];
            }
            this.StartSimpleTimer((short)0, 50);
        } else if (s == 1) {
            this.frameCount = (byte)(this.frameCount + 1);
            if (this.frameCount == 1) {
                this.GetSpecialImage("nGame");
                this.StartSimpleTimer((short)1, 2000);
            } else if (this.frameCount == 2) {
                this.StartSimpleTimer((short)1, 3000);
            } else {
                this.GoToMainMenu(true);
            }
        } else if (s == 2) {
            this.frameCount = this.frameCount == 2 ? (byte)0 : (byte)(this.frameCount + 1);
            this.StartSimpleTimer((short)2, 100);
        } else if (s == 3) {
            this.allowKeyPresses = true;
        } else if (s == 4) {
            this.GetSpecialImage("select");
            this.GetGameImages(false);
            this.screenType = (short)10;
        }
        this.repaint();
    }

    private byte NextUnit(byte by) {
        return this.NextUnitRecurse(by, by);
    }

    private byte NextUnitRecurse(byte by, byte by2) {
        byte by3 = this.playerArrayNext[by];
        if (by3 == this.opponentArrayStart) {
            by3 = this.playerArrayStart;
        }
        if (this.playerHealth[by3] >= 0 || by3 == by2) {
            return by3;
        }
        return this.NextUnitRecurse(by3, by2);
    }

    private void StartProjectile(byte by, byte by2) {
        if (this.projectileArrayUnusedStart >= 0) {
            byte by3 = this.StartProjectileCommonCode(by2);
            this.projectileDirection[by3] = this.playerDirection[by];
            if (by2 == 1) {
                byte by4 = this.opponentArrayStart;
                byte by5 = -1;
                int n = 99999999;
                int n2 = this.playerX[by];
                int n3 = this.playerY[by];
                while (by4 >= 0) {
                    if (this.playerHealth[by4] >= 0 && this.playerY[by4] >= this.screenImageTop && this.playerY[by4] <= this.screenImageTop + this.height - 16 && this.playerX[by4] >= this.screenImageLeft && this.playerX[by4] <= this.screenImageLeft + this.width - 16) {
                        int n4 = this.playerX[by4] - n2;
                        int n5 = this.playerY[by4] - n3;
                        int n6 = n4 > 0 ? n4 : -n4;
                        n6 = n5 > 0 ? (n6 += n5) : (n6 -= n5);
                        if (n6 < n && this.HasClearView(n2 + 8, n3 + 8, n4, n5)) {
                            by5 = by4;
                            n = n6;
                        }
                    }
                    by4 = this.playerArrayNext[by4];
                }
                if (by5 >= 0) {
                    this.playerDirection[by] = this.GetDirection(this.playerX[by5] - n2, this.playerY[by5] - n3);
                    this.DoPlayerDamage(by5, (byte)2);
                }
                this.projectileX[by3] = this.playerX[by] + gunFlareX[this.playerDirection[by]];
                this.projectileY[by3] = this.playerY[by] + gunFlareY[this.playerDirection[by]];
            } else {
                this.projectileX[by3] = this.playerX[by] + 8;
                this.projectileY[by3] = this.playerY[by] + 8;
            }
        }
    }

    private byte StartProjectileCommonCode(byte by) {
        byte by2 = this.projectileArrayUnusedStart;
        this.projectileArrayUnusedStart = this.projectileArrayNext[by2];
        this.projectileArrayNext[by2] = this.projectileArrayUsedStart;
        this.projectileArrayUsedStart = by2;
        this.projectileType[by2] = by;
        this.projectileTime[by2] = 0;
        return by2;
    }

    private boolean TargetAhead(byte by, int n, int n2) {
        switch (by) {
            case 0: {
                return n <= -n2;
            }
            case 1: {
                return n2 <= 0;
            }
            case 2: {
                return n >= n2;
            }
            case 3: {
                return n <= 0;
            }
            case 5: {
                return n >= 0;
            }
            case 6: {
                return n2 >= n;
            }
            case 7: {
                return n2 >= 0;
            }
            case 8: {
                return n >= -n2;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean HasClearView(int var1_1, int var2_2, int var3_3, int var4_4) {
        block8: {
            block7: {
                if (var3_3 < 0) {
                    var1_1 += var3_3;
                    var2_2 += var4_4;
                    var3_3 = -var3_3;
                    var4_4 = -var4_4;
                }
                var5_5 = var1_1 >> 4;
                var6_6 = var2_2 >> 4;
                var9_7 = var4_4 >= 0 ? 1 : -1;
                if (var3_3 != 0) break block7;
                var8_8 = var2_2 + var4_4 >> 4;
                if (this.TileBlockData[this.MapData[var6_6][var5_5]] > 1) ** GOTO lbl16
                return false;
lbl-1000:
                // 1 sources

                {
                    if (this.TileBlockData[this.MapData[var6_6][var5_5]] <= 1) {
                        return false;
                    }
                    var6_6 += var9_7;
lbl16:
                    // 2 sources

                    ** while (var6_6 != var8_8)
                }
lbl17:
                // 1 sources

                break block8;
            }
            var10_10 = (var4_4 << 10) / var3_3;
            var11_11 = (var2_2 << 10) - var10_10 * var1_1;
            var12_12 = var1_1 + var3_3;
            var13_13 = true;
            while (var13_13) {
                var7_14 = var5_5 + 1 << 4;
                if (var7_14 >= var12_12) {
                    var8_9 = var2_2 + var4_4 >> 4;
                    var13_13 = false;
                } else {
                    var8_9 = var7_14 * var10_10 + var11_11 >> 14;
                }
                if (this.TileBlockData[this.MapData[var6_6][var5_5]] > 1) ** GOTO lbl34
                return false;
lbl-1000:
                // 1 sources

                {
                    if (this.TileBlockData[this.MapData[var6_6 += var9_7][var5_5]] > 1) continue;
                    return false;
lbl34:
                    // 2 sources

                    ** while (var6_6 != var8_9)
                }
lbl35:
                // 1 sources

                var5_5 = var7_14 >> 4;
            }
        }
        return true;
    }

    private byte GetDirection(int n, int n2) {
        if (n == 0) {
            if (n2 > 0) {
                return 7;
            }
            return 1;
        }
        int n3 = (n2 << 10) / n;
        int n4 = n3 > 2472 ? 7 : (n3 > 424 ? 8 : (n3 > -424 ? 5 : (n3 > -2472 ? 2 : 1)));
        if (n > 0) {
            return (byte)n4;
        }
        return (byte)(8 - n4);
    }

    private boolean MoveEnemy(byte by, byte by2) {
        int n;
        int n2;
        int n3 = n2 = this.TileBlockData[this.MapData[this.playerY[by] + 8 >> 4][this.playerX[by] + 8 >> 4]] == 3 ? 1 : 2;
        if (by2 < 3) {
            n = this.MovePlayerUp(by, n2);
            if (n > 0) {
                byte by3 = by;
                this.playerY[by3] = this.playerY[by3] - n;
            } else {
                by2 = (byte)(by2 + 3);
            }
        } else if (by2 > 5) {
            n = this.MovePlayerDown(by, n2);
            if (n > 0) {
                byte by4 = by;
                this.playerY[by4] = this.playerY[by4] + n;
            } else {
                by2 = (byte)(by2 - 3);
            }
        }
        if (by2 % 3 == 0) {
            n = this.MovePlayerLeft(by, n2);
            if (n > 0) {
                byte by5 = by;
                this.playerX[by5] = this.playerX[by5] - n;
            } else {
                by2 = (byte)(by2 + 1);
            }
        } else if (by2 % 3 == 2) {
            n = this.MovePlayerRight(by, n2);
            if (n > 0) {
                byte by6 = by;
                this.playerX[by6] = this.playerX[by6] + n;
            } else {
                by2 = (byte)(by2 - 1);
            }
        }
        if (by2 == 4) {
            this.playerMoving[by] = false;
            return false;
        }
        this.playerDirection[by] = by2;
        this.playerMoving[by] = true;
        return true;
    }

    private void SetHidingAims(byte by) {
        byte by2 = this.NextUnit(by);
        byte by3 = -1;
        while (by2 != by) {
            this.SetHidingAimOneSide(by3, by2);
            by2 = this.NextUnit(by2);
            by3 = -by3;
        }
    }

    private void SetHidingAimOneSide(byte by, byte by2) {
        int n = (by + 1) / 2;
        int n2 = this.playerY[by2] >> 4;
        int n3 = 0;
        while (n3 <= 1) {
            int n4;
            int n5;
            if (by == -1) {
                n5 = this.playerX[by2] >> 4;
                if (n2 >= 1 && this.TileBlockData[this.MapData[n2 - 1][n5]] == 0 && this.StoreHidingAim(n, n2 << 4, n5 << 4)) {
                    return;
                }
                if (n2 >= 2 && this.TileBlockData[this.MapData[n2 - 2][n5]] == 0 && this.StoreHidingAim(n, n2 - 1 << 4, n5 << 4)) {
                    return;
                }
                n4 = n5 - 1;
            } else {
                n5 = this.playerX[by2] + 15 >> 4;
                if (n2 >= 1 && this.TileBlockData[this.MapData[n2 - 1][n5]] == 0 && this.StoreHidingAim(n, n2 << 4, n5 << 4)) {
                    return;
                }
                if (n2 >= 2 && this.TileBlockData[this.MapData[n2 - 2][n5]] == 0 && this.StoreHidingAim(n, n2 - 1 << 4, n5 << 4)) {
                    return;
                }
                n4 = n5 + 1;
            }
            if (n2 >= 1 && n4 >= 0 && n4 < 11 && this.TileBlockData[this.MapData[n2 - 1][n4]] == 0 && this.StoreHidingAim(n, n2 << 4, n4 << 4)) {
                return;
            }
            if (n2 >= 2 && n4 >= 0 && n4 < 11 && this.TileBlockData[this.MapData[n2 - 2][n4]] == 0 && this.StoreHidingAim(n, n2 - 1 << 4, n4 << 4)) {
                return;
            }
            int n6 = 0;
            while (n6 < 4 && n4 >= 0 && n4 < 11) {
                int n7 = 0;
                int n8 = n2 - 3;
                if (n8 < 0) {
                    n8 = 0;
                }
                boolean bl = false;
                while (n7 < 7 && n8 < 128) {
                    if (this.TileBlockData[this.MapData[n8][n4]] == 0) {
                        bl = true;
                    } else if (bl) {
                        if (this.StoreHidingAim(n, n8 << 4, n4 << 4)) {
                            return;
                        }
                        bl = false;
                    }
                    ++n7;
                    ++n8;
                }
                ++n6;
                n4 += by;
                if (!bl) continue;
                n6 = 99;
            }
            by = -by;
            ++n3;
        }
        this.playerAimX[n] = -1;
        this.playerAimY[n] = -1;
    }

    private boolean StoreHidingAim(int n, int n2, int n3) {
        if (n == 1 && this.playerAimX[0] == n3 && this.playerAimY[0] == n2) {
            return false;
        }
        this.playerAimX[n] = n3;
        this.playerAimY[n] = n2;
        return true;
    }

    private void SetAvoidanceAimUpAndDown(int n, int n2, int n3, byte by) {
        int n4 = n2 + n3;
        if (this.TileBlockData[this.MapData[n4][n]] > 1) {
            this.playerAimX[by] = n << 4;
            this.playerAimY[by] = n4 << 4;
        } else {
            boolean[] blArray = new boolean[]{true, true};
            boolean bl = true;
            int n5 = 1;
            while (bl) {
                if (blArray[0]) {
                    if (n < n5 || this.TileBlockData[this.MapData[n2][n - n5]] <= 1) {
                        blArray[0] = false;
                        if (!blArray[1]) {
                            bl = false;
                        }
                    } else if (this.TileBlockData[this.MapData[n4][n - n5]] > 1) {
                        this.playerAimX[by] = n - n5 << 4;
                        this.playerAimY[by] = n4 << 4;
                        bl = false;
                    }
                }
                if (blArray[1]) {
                    if (n >= 11 - n5 || this.TileBlockData[this.MapData[n2][n + n5]] <= 1) {
                        blArray[1] = false;
                        if (!blArray[0]) {
                            bl = false;
                        }
                    } else if (this.TileBlockData[this.MapData[n4][n + n5]] > 1) {
                        this.playerAimX[by] = n + n5 << 4;
                        this.playerAimY[by] = n4 << 4;
                        bl = false;
                    }
                }
                ++n5;
            }
        }
    }

    private void SetAvoidanceAimLeftAndRight(int n, int n2, int n3, byte by) {
        int n4 = n + n3;
        if (this.TileBlockData[this.MapData[n2][n4]] > 1) {
            this.playerAimX[by] = n4 << 4;
            this.playerAimY[by] = n2 << 4;
        } else {
            boolean[] blArray = new boolean[]{true, true};
            boolean bl = true;
            int n5 = 1;
            while (bl) {
                if (blArray[0]) {
                    if (n2 < n5 || this.TileBlockData[this.MapData[n2 - n5][n]] <= 1) {
                        blArray[0] = false;
                        if (!blArray[1]) {
                            bl = false;
                        }
                    } else if (this.TileBlockData[this.MapData[n2 - n5][n4]] > 1) {
                        this.playerAimX[by] = n4 << 4;
                        this.playerAimY[by] = n2 - n5 << 4;
                        bl = false;
                    }
                }
                if (blArray[1]) {
                    if (n2 >= 128 - n5 || this.TileBlockData[this.MapData[n2 + n5][n]] <= 1) {
                        blArray[1] = false;
                        if (!blArray[0]) {
                            bl = false;
                        }
                    } else if (this.TileBlockData[this.MapData[n2 + n5][n4]] > 1) {
                        this.playerAimX[by] = n4 << 4;
                        this.playerAimY[by] = n2 + n5 << 4;
                        bl = false;
                    }
                }
                ++n5;
            }
        }
    }

    private void MoveScreenUp(int n) {
        if (this.screenImageTop > 0) {
            if (n > 3) {
                n = 3;
            }
            this.screenImageTop -= n;
            if (this.screenImageTop < 0) {
                this.screenImageTop = 0;
            }
            if (this.screenImageDiscontinuity == 0) {
                this.screenImageDiscontinuity += this.screenImageHeight;
                this.screenSplit -= this.screenImageHeight;
            }
            if (this.screenImageHeight - this.screenImageDiscontinuity < this.screenSplit - this.screenImageTop) {
                this.screenImageDiscontinuity -= 16;
                int n2 = this.screenImageTop >> 4;
                int n3 = 10;
                while (n3 >= 0) {
                    this.screenImageGraphics.setClip(n3 << 4, this.screenImageDiscontinuity, 16, 16);
                    this.screenImageGraphics.drawImage(this.tilesImage, n3 - this.TileTextureData[this.MapData[n2][n3]] << 4, this.screenImageDiscontinuity, 20);
                    --n3;
                }
            }
        }
    }

    private void MoveScreenDown(int n) {
        if (this.screenImageTop < 2048 - this.height) {
            if (n > 3) {
                n = 3;
            }
            this.screenImageTop += n;
            if (this.screenImageTop > 2048 - this.height) {
                this.screenImageTop = 2048 - this.height;
            }
            if (this.screenImageDiscontinuity == this.screenImageHeight) {
                this.screenImageDiscontinuity -= this.screenImageHeight;
                this.screenSplit += this.screenImageHeight;
            }
            if (this.screenImageDiscontinuity < this.screenImageTop + this.height - this.screenSplit) {
                this.screenImageDiscontinuity += 16;
                int n2 = this.screenImageTop + this.height >> 4;
                int n3 = 10;
                while (n3 >= 0) {
                    this.screenImageGraphics.setClip(n3 << 4, this.screenImageDiscontinuity - 16, 16, 16);
                    this.screenImageGraphics.drawImage(this.tilesImage, n3 - this.TileTextureData[this.MapData[n2][n3]] << 4, this.screenImageDiscontinuity - 16, 20);
                    --n3;
                }
            }
        }
    }

    private void MoveScreenLeft(int n) {
        if (this.screenImageLeft > 0) {
            if (n > 3) {
                n = 3;
            }
            this.screenImageLeft -= n;
            if (this.screenImageLeft < 0) {
                this.screenImageLeft = 0;
            }
        }
    }

    private void MoveScreenRight(int n) {
        if (this.screenImageLeft < 176 - this.width) {
            if (n > 3) {
                n = 3;
            }
            this.screenImageLeft += n;
            if (this.screenImageLeft > 176 - this.width) {
                this.screenImageLeft = 176 - this.width;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int MovePlayerUp(byte by, int n) {
        int n2;
        byte by2;
        if (this.playerY[by] < n) return this.playerY[by];
        if ((this.playerY[by] & 0xF) < n) {
            by2 = 0;
            boolean bl = false;
            int n3 = 0;
            while (n3 <= 15) {
                n2 = this.MapData[(this.playerY[by] >> 4) - 1][this.playerX[by] + n3 >> 4];
                if (this.TileBlockData[n2] == 1) {
                    if (by >= 3 || this.playerType[by] != 3) return this.playerY[by] & 0xF;
                    if (by2 != 0) {
                        this.Infiltrate(by, true);
                    } else {
                        by2 = 1;
                    }
                } else {
                    if (this.TileBlockData[n2] == 0) {
                        return this.playerY[by] & 0xF;
                    }
                    if (this.TileBlockData[n2] == 5) {
                        if (by < 3 && this.playerType[by] == 3) {
                            if (bl) {
                                this.Infiltrate(by, false);
                            } else {
                                bl = true;
                            }
                        }
                    } else if (by == this.currentPlayer && (n2 = this.TileSpecialData[n2]) >= 0) {
                        this.PickUpItem(by, (byte)n2);
                    }
                }
                n3 += 15;
            }
        }
        by2 = this.playerArrayStart;
        while (by2 >= 0 && n > 0) {
            if (by2 != by && this.playerHealth[by2] >= 0 && (n2 = this.playerX[by] - this.playerX[by2]) > -16 && n2 < 16 && (n2 = this.playerY[by] - n - this.playerY[by2]) > -16 && n2 < 16) {
                n = this.playerY[by] - this.playerY[by2] - 16;
                this.CheckCollision(by, by2);
            }
            by2 = this.playerArrayNext[by2];
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int MovePlayerDown(byte by, int n) {
        int n2;
        byte by2;
        if (this.playerY[by] + n > 2032) return 2032 - this.playerY[by];
        if ((1 - this.playerY[by] & 0xF) <= n) {
            by2 = 0;
            boolean bl = false;
            int n3 = 0;
            while (n3 <= 15) {
                n2 = this.MapData[this.playerY[by] + n + 15 >> 4][this.playerX[by] + n3 >> 4];
                if (this.TileBlockData[n2] == 1) {
                    if (by >= 3 || this.playerType[by] != 3) return -this.playerY[by] & 0xF;
                    if (by2 != 0) {
                        this.Infiltrate(by, true);
                    } else {
                        by2 = 1;
                    }
                } else {
                    if (this.TileBlockData[n2] == 0) {
                        return -this.playerY[by] & 0xF;
                    }
                    if (this.TileBlockData[n2] == 5) {
                        if (by < 3 && this.playerType[by] == 3) {
                            if (bl) {
                                this.Infiltrate(by, false);
                            } else {
                                bl = true;
                            }
                        }
                    } else if (by == this.currentPlayer && (n2 = this.TileSpecialData[n2]) >= 0) {
                        this.PickUpItem(by, (byte)n2);
                    }
                }
                n3 += 15;
            }
        }
        by2 = this.playerArrayStart;
        while (by2 >= 0 && n > 0) {
            if (by2 != by && this.playerHealth[by2] >= 0 && (n2 = this.playerX[by] - this.playerX[by2]) > -16 && n2 < 16 && (n2 = this.playerY[by2] - this.playerY[by] - n) > -16 && n2 < 16) {
                n = this.playerY[by2] - this.playerY[by] - 16;
                this.CheckCollision(by, by2);
            }
            by2 = this.playerArrayNext[by2];
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int MovePlayerLeft(byte by, int n) {
        int n2;
        byte by2;
        if (this.playerX[by] < n) return this.playerX[by];
        if ((this.playerX[by] & 0xF) < n) {
            by2 = 0;
            boolean bl = false;
            int n3 = 0;
            while (n3 <= 15) {
                n2 = this.MapData[this.playerY[by] + n3 >> 4][(this.playerX[by] >> 4) - 1];
                if (this.TileBlockData[n2] == 1) {
                    if (by >= 3 || this.playerType[by] != 3) return this.playerX[by] & 0xF;
                    if (by2 != 0) {
                        this.Infiltrate(by, true);
                    } else {
                        by2 = 1;
                    }
                } else {
                    if (this.TileBlockData[n2] == 0) {
                        return this.playerX[by] & 0xF;
                    }
                    if (this.TileBlockData[n2] == 5) {
                        if (by < 3 && this.playerType[by] == 3) {
                            if (bl) {
                                this.Infiltrate(by, false);
                            } else {
                                bl = true;
                            }
                        }
                    } else if (by == this.currentPlayer && (n2 = this.TileSpecialData[n2]) >= 0) {
                        this.PickUpItem(by, (byte)n2);
                    }
                }
                n3 += 15;
            }
        }
        by2 = this.playerArrayStart;
        while (by2 >= 0 && n > 0) {
            if (by2 != by && this.playerHealth[by2] >= 0 && (n2 = this.playerY[by] - this.playerY[by2]) > -16 && n2 < 16 && (n2 = this.playerX[by] - n - this.playerX[by2]) > -16 && n2 < 16) {
                n = this.playerX[by] - this.playerX[by2] - 16;
                this.CheckCollision(by, by2);
            }
            by2 = this.playerArrayNext[by2];
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int MovePlayerRight(byte by, int n) {
        int n2;
        byte by2;
        if (this.playerX[by] + n > 160) return 160 - this.playerX[by];
        if ((1 - this.playerX[by] & 0xF) <= n) {
            by2 = 0;
            boolean bl = false;
            int n3 = 0;
            while (n3 <= 15) {
                n2 = this.MapData[this.playerY[by] + n3 >> 4][this.playerX[by] + n + 15 >> 4];
                if (this.TileBlockData[n2] == 1) {
                    if (by >= 3 || this.playerType[by] != 3) return -this.playerX[by] & 0xF;
                    if (by2 != 0) {
                        this.Infiltrate(by, true);
                    } else {
                        by2 = 1;
                    }
                } else {
                    if (this.TileBlockData[n2] == 0) {
                        return -this.playerX[by] & 0xF;
                    }
                    if (this.TileBlockData[n2] == 5) {
                        if (by < 3 && this.playerType[by] == 3) {
                            if (bl) {
                                this.Infiltrate(by, false);
                            } else {
                                bl = true;
                            }
                        }
                    } else if (by == this.currentPlayer && (n2 = this.TileSpecialData[n2]) >= 0) {
                        this.PickUpItem(by, (byte)n2);
                    }
                }
                n3 += 15;
            }
        }
        by2 = this.playerArrayStart;
        while (by2 >= 0 && n > 0) {
            if (by2 != by && this.playerHealth[by2] >= 0 && (n2 = this.playerY[by] - this.playerY[by2]) > -16 && n2 < 16 && (n2 = this.playerX[by2] - this.playerX[by] - n) > -16 && n2 < 16) {
                n = this.playerX[by2] - this.playerX[by] - 16;
                this.CheckCollision(by, by2);
            }
            by2 = this.playerArrayNext[by2];
        }
        return n;
    }

    private void CheckCollision(byte by, byte by2) {
        if (by == this.currentPlayer && this.playerType[by] == 4 && by2 < 3 && this.playerHealth[by] > 0 && this.clockTicks > this.playerNextShot[by]) {
            byte by3 = by2;
            this.playerHealth[by3] = (byte)(this.playerHealth[by3] + this.playerHealth[by]);
            this.playerNextShot[by] = this.clockTicks + 60;
            if (this.playerHealth[by2] > INITIAL_HEALTH[this.playerType[by2]]) {
                this.playerHealth[by2] = INITIAL_HEALTH[this.playerType[by2]];
            }
            this.playerShowStatus[by2] = this.clockTicks + 60;
        }
    }

    private void PickUpItem(byte by, byte by2) {
        switch (this.specialType[by2]) {
            case 4: {
                this.playerProtected[by] = this.clockTicks + 180;
                break;
            }
            case 5: {
                if (this.playerHealth[by] < INITIAL_HEALTH[this.playerType[by]]) {
                    this.playerShowStatus[by] = this.clockTicks + 60;
                    byte by3 = by;
                    this.playerHealth[by3] = (byte)(this.playerHealth[by3] + 1);
                    this.UpdateStatusBar();
                    break;
                }
                return;
            }
            case 6: {
                if (this.playerType[by] != 4 && this.playerType[by] != 3 && this.playerSpecial[by] < INITIAL_AMMO[WEAPON_TYPE[this.playerType[by]]]) {
                    this.playerSpecial[by] = INITIAL_AMMO[WEAPON_TYPE[this.playerType[by]]];
                    this.UpdateStatusBar();
                    break;
                }
                return;
            }
            case 7: {
                this.endLevel = true;
                return;
            }
        }
        this.TileSpecialData[this.MapData[this.specialY[by2] >> 4][this.specialX[by2] >> 4]] = -1;
        byte by4 = this.specialArrayPrevious[by2];
        if (by4 < 0) {
            this.specialArrayStart = this.specialArrayNext[by2];
        } else {
            this.specialArrayNext[by4] = this.specialArrayNext[by2];
        }
        by4 = this.specialArrayNext[by2];
        if (by4 >= 0) {
            this.specialArrayPrevious[by4] = this.specialArrayPrevious[by2];
        }
    }

    private void Infiltrate(byte by, boolean bl) {
        if (this.playerInBuilding[by]) {
            this.playerInBuilding[by] = false;
            if (this.clockTicks < this.playerSpecial[by]) {
                this.SetInvisibility(by, false);
            }
        } else {
            this.playerInBuilding[by] = true;
            if (bl) {
                this.SetInvisibility(by, true);
            }
        }
    }

    private void DoExplosion(byte by, int n) {
        this.PlaySound(this.explosionSound);
        int n2 = this.projectileX[by];
        int n3 = this.projectileY[by];
        this.CheckPlayerDamage(n2 + 16, n2 - 32, n3 + 16, n3 - 32, (byte)2);
        byte by2 = this.specialArrayExplodableStart;
        while (by2 >= 0) {
            byte by3 = this.specialType[by2];
            if (by3 >= 0 && n3 + 24 >= this.specialY[by2] && n3 - 24 <= this.specialY[by2] + SPECIAL_GFX_H[by3] && n2 + 24 >= this.specialX[by2] && n2 - 24 <= this.specialX[by2] + SPECIAL_GFX_W[by3]) {
                byte by4 = by2;
                this.specialDamage[by4] = (byte)(this.specialDamage[by4] - n);
                if (this.specialDamage[by2] <= 0) {
                    int n4 = this.specialX[by2] >> 4;
                    int n5 = this.specialY[by2] >> 4;
                    int n6 = (SPECIAL_GFX_W[by3] >> 4) - 1;
                    while (n6 >= 0) {
                        int n7 = (SPECIAL_GFX_H[by3] >> 4) - 1;
                        while (n7 >= 0) {
                            byte by5 = this.MapData[n5 + n7][n4 + n6];
                            this.TileSpecialData[by5] = -1;
                            this.TileBlockData[by5] = 4;
                            --n7;
                        }
                        --n6;
                    }
                    this.specialType[by2] = (byte)(-1 - by3);
                }
            }
            by2 = this.specialArrayNext[by2];
        }
        this.projectileType[by] = 10;
        this.projectileTime[by] = 0;
    }

    private boolean CheckPlayerDamage(int n, int n2, int n3, int n4, byte by) {
        boolean bl = false;
        byte by2 = this.playerArrayStart;
        while (by2 >= 0) {
            if (this.playerHealth[by2] >= 0 && this.playerX[by2] <= n && this.playerX[by2] > n2 && this.playerY[by2] <= n3 && this.playerY[by2] > n4) {
                this.DoPlayerDamage(by2, by);
                bl = true;
            }
            if ((by2 = this.playerArrayNext[by2]) != this.opponentArrayStart) continue;
            n += 2;
            n2 -= 2;
            n3 += 2;
            n4 -= 2;
        }
        return bl;
    }

    private void DoPlayerDamage(byte by, byte by2) {
        if (by >= 3 || this.clockTicks > this.playerProtected[by]) {
            byte by3 = by;
            this.playerHealth[by3] = (byte)(this.playerHealth[by3] - by2);
            if (this.playerHealth[by] < -1) {
                this.playerHealth[by] = -1;
            }
            if (by < 3) {
                this.playerShowStatus[by] = this.clockTicks + 60;
            }
            if (by == this.currentPlayer) {
                if (this.playerHealth[by] < 0) {
                    this.currentPlayer = this.NextUnit(by);
                    this.playerDirection[this.currentPlayer] = 1;
                }
                this.UpdateStatusBar();
            }
        }
    }

    private void SetMenuScreenType(short s) {
        int n;
        System.gc();
        this.menuGraphicHeight = (short)(4 + this.largeFontHeight + 3);
        this.menuLineHeight = this.fontHeight;
        int n2 = this.largeFontHeight + 4;
        if (s >= 100) {
            this.SetMenuScreenParseText("h" + (s - 100), "");
        } else if (s == 7 || s == 8) {
            if (this.missionTime[this.missionNumberCurrent] > 0) {
                this.SetMenuScreenParseText("b" + this.missionNumberCurrent, "~ ~Best time: " + this.missionTime[this.missionNumberCurrent] / 10 + "." + this.missionTime[this.missionNumberCurrent] % 10);
            } else {
                this.SetMenuScreenParseText("b" + this.missionNumberCurrent, "");
            }
        } else if (s == 11) {
            this.menuStringArray = null;
            System.gc();
            n = (int)((System.currentTimeMillis() - this.startTime) / 100L);
            if (this.missionTime[this.missionNumberCurrent] == 0 || n < this.missionTime[this.missionNumberCurrent]) {
                this.missionTime[this.missionNumberCurrent] = n;
                this.writeRecords();
                this.SetMenuScreenParseText("d" + this.missionNumberCurrent, "~ ~New best time: " + n / 10 + "." + n % 10);
            } else {
                this.SetMenuScreenParseText("d" + this.missionNumberCurrent, "~ ~Time: " + n / 10 + "." + n % 10);
            }
        } else if (s == 16) {
            this.menuGraphicHeight = (short)(4 + this.titleImage.getHeight() + 3);
            this.SetMenuScreenParseText("end", "");
        } else {
            this.menuLineHeight = this.largeFontHeight;
            if (s == 3) {
                this.menuStringArray = Strings.helpTitles;
                this.clockTicks = 0;
            } else if (s == 1) {
                this.menuStringArray = new String[]{"Play", "Options", "Help", "Exit"};
                this.menuGraphicHeight = (short)(4 + this.titleImage.getHeight() + 3);
            } else if (s == 6) {
                this.menuStringArray = new String[this.missionNumberMax + 1];
                n = 0;
                while (n <= this.missionNumberMax) {
                    this.menuStringArray[n] = Strings.missionTitle[this.missionNumberMax - n];
                    ++n;
                }
                this.menuGraphicHeight = (short)(4 + this.titleImage.getHeight() + 3);
            } else if (s == 4) {
                this.menuStringArray = new String[]{this.soundOn ? "Sound: ON" : "Sound: OFF", "Reset Game"};
            } else if (s == 5) {
                this.menuStringArray = new String[]{this.soundOn ? "Sound: ON" : "Sound: OFF", "Restart Mission", "Main Menu"};
            }
            this.menuSelection = 1;
        }
        this.menuLength = (short)this.menuStringArray.length;
        this.screenType = s;
        this.menuStart = 1;
        this.menuLines = (short)Math.min((this.height - this.menuGraphicHeight - n2) / this.menuLineHeight, this.menuLength);
        n = this.height - this.menuGraphicHeight - n2 - this.menuLines * this.menuLineHeight >> 1;
        if (n > 0) {
            this.menuGraphicHeight = (short)(this.menuGraphicHeight + n);
        }
        System.gc();
    }

    private void SetMenuScreenParseText(String string, String string2) {
        System.gc();
        InputStream inputStream = null;
        DataInputStream dataInputStream = null;
        int n = 0;
        byte[] byArray = new byte[860];
        String string3 = "";
        try {
            inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(string + ".txt");
            dataInputStream = new DataInputStream(inputStream);
            int n2 = dataInputStream.read();
            while (n2 != -1 && n2 != 10 && n2 != 13) {
                byArray[n] = (byte)n2;
                ++n;
                n2 = dataInputStream.read();
            }
            string3 = new String(byArray, 0, n);
            dataInputStream.close();
            inputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.toString());
        }
        string3 = string3 + string2;
        Vector vector = this.ParseString(string3);
        this.menuStringArray = null;
        System.gc();
        this.menuStringArray = new String[vector.size() - 1];
        int n3 = vector.size() - 2;
        while (n3 >= 0) {
            this.menuStringArray[n3] = string3.substring((Integer)vector.elementAt(n3), (Integer)vector.elementAt(n3 + 1) - 1);
            --n3;
        }
        this.menuSelection = 0;
    }

    private Vector ParseString(String string) {
        Vector<Integer> vector = new Vector<Integer>();
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        int n4 = this.width - 14 - 8;
        while (n < n3) {
            vector.addElement(new Integer(n));
            n2 = n;
            int n5 = 0;
            while (n5 < n4 && n < n3 && string.charAt(n) != '~') {
                n5 += this.font.charWidth(string.charAt(n));
                ++n;
            }
            if (n5 >= n4) {
                int n6 = --n;
                while (n6 > n2 && string.charAt(n6) != ' ') {
                    --n6;
                }
                if (n6 <= n2) continue;
                n = n6 + 1;
                continue;
            }
            ++n;
        }
        vector.addElement(new Integer(n));
        return vector;
    }
}

