package classes;

import java.io.*;
import javax.microedition.lcdui.*;
import javax.microedition.lcdui.game.*;
import javax.microedition.rms.*;


public class FlipullDebug extends GameCanvas
{
  private Image font;
  private TiledLayer textLayer;
  private String message;

  public FlipullDebug(String message) {
    super(false);
    setFullScreenMode(true);

    try {
      font = Image.createImage("/images/font-trans.png");
    }
    catch(IOException e) { }

    textLayer = new TiledLayer(28,28,font,6,6);
    textLayer.setPosition(4,4);

    this.message = message;
    writeAt(0,3,"EXCEPTION FAILURE:");

    int x=0, y=5, i;
    for(i=0; i<message.length(); i++) {
      char ch = Character.toUpperCase( message.charAt(i) );
      textLayer.setCell(x,y,((int)ch)-31);
      x++;
      if(x==28) {
        x = 0;
        y++;
      }
    }
  }

  public void writeAt(int x, int y, String s) {
    for(int i=0; i<s.length(); i++)
      textLayer.setCell(x+i,y,((int)s.charAt(i))-31);
  }

  public void keyPressed(int keyCode) {
    System.exit(-1);
  }

  public void paint(Graphics g) {
    g.setColor(0,0,0);
    g.fillRect(0,0,176,208);
    textLayer.paint(g);
  }
};

