package classes;

import java.util.*;
import javax.microedition.lcdui.*;

public class FlipullThread extends Thread
{
  private Display display;
  private FlipullMap flipullMap;
  private FlipullCanvas flipullCanvas;
  private final Random rnd = new Random();

  private int level, score, limit, time;
  private long timeStart, timeNow;
  private int blocks, superBlocks;
  private int heroPos;
  private int X, Y, H, V, Vd;

  // First level at start (Change on debug only).
  private final static int firstLevel = 1;
  // Last level in the game.
  private final static int lastLevel = 3;
  // Super blocks at start.
  private final static int superBlocksAtStart = 3;

  private boolean gameOverFlag;
  
  private boolean haveMiss;
  
  private boolean doQuitImmed;

  public FlipullThread(Display display, FlipullMap flipullMap, FlipullCanvas flipullCanvas) {
    this.display = display;
    this.flipullMap = flipullMap;
    this.flipullCanvas = flipullCanvas;
  }

  public void run() {
    try {

      level = firstLevel;
      score = 0;
      superBlocks = superBlocksAtStart;

      gameOverFlag = false;
      doQuitImmed = false;

      /**
       * Level loop
       */
      for(;;) {
        haveMiss = false;
        loadLevel();
        infoPanel();
        flipullCanvas.setLevelCompleted(false);
        flipullCanvas.setCongratulations(false);
        flipullCanvas.setBonus(false);

        flipullMap.setLevel( (int)(((level-1))/5)+1, (((level-1))%5)+1 );
        display.setCurrent(flipullMap);
        while(!flipullMap.doStartLevel()) {
          flipullMap.tick();
          sleep(500);
        }

        display.setCurrent(flipullCanvas);

        flipullCanvas.pointerSprite.setVisible(true);
        flipullCanvas.blockSprite.setFrame(0);
        //flipullCanvas.writeSwap();
        flipullCanvas.repaint();

        timeNow = (int)((new Date()).getTime() / 1000);
        timeStart = timeNow;

        /**
         * Action loop
         */
        while(!gameOverFlag) {
          checkKeyStates();
          if(doQuitImmed==true) {
            flipullCanvas.quit(-1);
            return;
          }
          if(blocks <= limit) {
            level++;
            break;
          }
          sleep(20);
          if( (int)((new Date()).getTime() / 1000) != timeNow ) {
            updateTimer();
            flipullCanvas.writeFlush();
            flipullCanvas.repaint();
            if(timeNow-timeStart>time)
              timeOver();
          }
        }

        if(level>lastLevel) {
          flipullCanvas.setCongratulations(true);
          flipullCanvas.repaint();
          sleep(1000);
          evaluateBonuses();
          flipullCanvas.setBonus(true);
          flipullCanvas.repaint();
          sleep(1000);
          score += flipullCanvas.consumeBonuses();
          infoPanel();
          flipullCanvas.repaint();
          sleep(1000);
          flipullCanvas.startFinalScene(score);
          break;
        }
        if(gameOverFlag) {
          flipullCanvas.quit(score);
          break;
        }
        flipullCanvas.setLevelCompleted(true);
        flipullCanvas.repaint();
        sleep(1000);
        evaluateBonuses();
        flipullCanvas.setBonus(true);
        flipullCanvas.repaint();
        sleep(1000);
        score += flipullCanvas.consumeBonuses();
        infoPanel();
        flipullCanvas.repaint();
        sleep(2000);
      }

    } catch(InterruptedException e) {
    }
  }

  private void updateTimer() {
    timeNow = (int)((new Date()).getTime() / 1000);

    int timeRemaining = time - (int)( timeNow - timeStart );
    if(timeRemaining<0)
      timeRemaining = 0;
      
    int minutes = (int)( timeRemaining / 60 );
    int seconds = ( timeRemaining % 60 );

    String timeString = "" + minutes + ":";
    if(seconds<10)
      timeString += "0";
    timeString += seconds;

    flipullCanvas.writeAt(17,0,timeString);
  }

  private void evaluateBonuses() {
    int bonusTime;
    int bonusLimit;
    int bonusNoMiss;
    int timeNow;
    int timeRemaining;

    timeNow = (int)((new Date()).getTime() / 1000);
    timeRemaining = time - (int)( timeNow - timeStart );
    if(timeRemaining<0)
      timeRemaining = 0;
    bonusTime = (int)( timeRemaining / 60 );  // Minutes
    bonusTime *= (int)( ( level - 1 ) / 5 ) + 1;

    bonusLimit = limit - blocks;
    bonusLimit *= (int)( ( level - 1 ) / 5 ) + 1;

    bonusNoMiss = haveMiss ? 0 : level;

    flipullCanvas.setBonusValues(bonusTime,bonusLimit,bonusNoMiss);
  }

  private void checkKeyStates() throws InterruptedException {
    int keyStates;

    keyStates = flipullCanvas.getKeyStates();
    if((keyStates&flipullCanvas.UP_PRESSED) != 0 && heroPos>1) {
      flipullCanvas.heroSprite.setFrame(2);
      flipullCanvas.heroSprite.move(0,-6);
      flipullCanvas.blockSprite.move(0,-6);
      flipullCanvas.repaint();
      sleep(40);
      flipullCanvas.heroSprite.setFrame(0);
      flipullCanvas.heroSprite.move(0,-6);
      flipullCanvas.blockSprite.move(0,-6);
      heroPos--;
      adjustPointer();
      flipullCanvas.repaint();
      sleep(20);
    }
    if((keyStates&flipullCanvas.DOWN_PRESSED) != 0 && heroPos<12) {
      flipullCanvas.heroSprite.setFrame(2);
      flipullCanvas.heroSprite.move(0,6);
      flipullCanvas.blockSprite.move(0,6);
      flipullCanvas.repaint();
      sleep(40);
      flipullCanvas.heroSprite.setFrame(0);
      flipullCanvas.heroSprite.move(0,6);
      flipullCanvas.blockSprite.move(0,6);
      heroPos++;
      adjustPointer();
      flipullCanvas.repaint();
      sleep(20);
    }
    if((keyStates&flipullCanvas.FIRE_PRESSED) != 0) {
      flipullCanvas.play(flipullCanvas.sndShot);
      flipullCanvas.pointerSprite.setVisible(false);
      shot();
      //flipullCanvas.writeSwap();
      adjustPointer();
      flipullCanvas.pointerSprite.setVisible(true);
      flipullCanvas.repaint();
      if(isMiss() && blocks>limit) {
        if(superBlocks==0) {
          gameOver();
        } else {
          superBlocks--;
          infoPanel();
          miss();
          //flipullCanvas.writeSwap();
          flipullCanvas.blockSprite.setFrame(0);
          flipullCanvas.repaint();
        }
      }
    }
    if((keyStates&flipullCanvas.GAME_D_PRESSED) != 0) {
      doQuitImmed = true;
    }
  }

  private void gameOver() throws InterruptedException {
    flipullCanvas.isGameOver = true;
    flipullCanvas.repaint();
    sleep(2000);
    flipullCanvas.isGameOver = false;
    flipullCanvas.repaint();
    sleep(1000);
    gameOverFlag = true;
  }

  private void timeOver() throws InterruptedException {
    flipullCanvas.isTimeOver = true;
    flipullCanvas.repaint();
    sleep(2000);
    flipullCanvas.isTimeOver = false;
    flipullCanvas.repaint();
    sleep(1000);
    gameOverFlag = true;
  }

  private void miss() throws InterruptedException {
    haveMiss = true;
  
    flipullCanvas.isMiss = true;
    for(int i=0; i<10; i++) {
      flipullCanvas.repaint();
      sleep(20);
    }
    flipullCanvas.isMiss = false;
    flipullCanvas.rBlockSprite.setRefPixelPosition(144,189);
    flipullCanvas.rBlockSprite.setFrame(0);
    flipullCanvas.rBlockSprite.setVisible(true);
    adjustRollBackParameters();
    while(doRollBack()) {
      sleep(20);
      flipullCanvas.repaint();
    }
    flipullCanvas.rBlockSprite.setVisible(false);
  }

  private void shot() throws InterruptedException {
    int scorePlus;
    // X and Y coordinates of the thrown block.
    int x, y;
    // Direction of the thrown block.
    int h, v;
    // Hit flag.
    boolean haveHit;

    /**
     * Initial settings of block motion.
     */
    x = 2;
    y = heroPos;
    h = 1;
    v = 0;
    scorePlus = 1;
    
    haveHit = false;

    /**
     * Short hero animation before block throwing.
     */
    flipullCanvas.heroSprite.setFrame(2);
    flipullCanvas.repaint();
    sleep(40);
    flipullCanvas.heroSprite.setFrame(3);
    flipullCanvas.heroSprite.move(1,0);
    flipullCanvas.repaint();
    sleep(30);
    flipullCanvas.heroSprite.setFrame(0);
    flipullCanvas.heroSprite.move(-1,0);
    flipullCanvas.repaint();

    /**
     * Flying block.
     */
    for(;;) {

      /**
       * Vertical deviation on horizontal motion and wall block ahead.
       */
      if(h==1 && flipullCanvas.layer.getCell(x+h,y+v)==6) {
        h = 0;
        v = 1;
        flipullCanvas.play(flipullCanvas.sndWall);
      }

      flipullCanvas.blockSprite.setRefPixelPosition((x+h)*12+4,(y+v)*12+15);
      flipullCanvas.repaint();

      /**
       * Vertical motion and wall block ahead.
       */
      if(flipullCanvas.layer.getCell(x+h,y+v)==6) {
        flipullCanvas.play(flipullCanvas.sndWall);
        break;
      }

      /**
       * Block ahead.
       */
      if(flipullCanvas.layer.getCell(x+h,y+v)>=2 && flipullCanvas.layer.getCell(x+h,y+v)<=5) {
        /**
         * Superblock hits arbitrary block.
         */
        if(flipullCanvas.blockSprite.getFrame()==0) {
          flipullCanvas.blockSprite.setFrame(flipullCanvas.layer.getCell(x+h,y+v)-1);
        }

        /**
         * Blocks match.
         */
        if(flipullCanvas.layer.getCell(x+h,y+v)-1==flipullCanvas.blockSprite.getFrame()) {
          flipullCanvas.play(flipullCanvas.sndBlock);
          flipullCanvas.addRollingSprite((x+h)*12+3,(y+v)*12+3,flipullCanvas.layer.getCell(x+h,y+v)-1);
          flipullCanvas.layer.setCell(x+h,y+v,0);
          score += scorePlus;
          scorePlus++;
          blocks--;
          haveHit = true;
        }

        /**
         * Non-matching block ahead.
         */
        else {
          if(!haveHit) {
            flipullCanvas.play(flipullCanvas.sndWBlock);
            break;
          }
          int swp = flipullCanvas.layer.getCell(x+h,y+v);
          flipullCanvas.layer.setCell(x+h,y+v,flipullCanvas.blockSprite.getFrame()+1);
          flipullCanvas.blockSprite.setFrame(swp-1);
          break;
        }
      }

      x += h;
      y += v;

      flipullCanvas.rollRollingSprites();

      sleep(20);
    }

    infoPanel();

    /**
     * Restore block position.
     */
    flipullCanvas.rBlockSprite.setVisible(true);
    flipullCanvas.rBlockSprite.setRefPixelPosition((x+h)*12+3,(y+v)*12+16);
    flipullCanvas.rBlockSprite.setFrame(flipullCanvas.blockSprite.getFrame()*2);

    x = 2;
    y = heroPos;
    flipullCanvas.blockSprite.setVisible(false);
    flipullCanvas.blockSprite.setRefPixelPosition(x*12+4,y*12+15);

    adjustRollBackParameters();
    while(doRollBack()) {
      sleep(20);
      flipullCanvas.rollRollingSprites();
      flipullCanvas.repaint();
    }
    flipullCanvas.clearRollingSprites();
    while(doScroll()) {
      sleep(20);
      flipullCanvas.repaint();
    }

    flipullCanvas.blockSprite.setVisible(true);
    flipullCanvas.rBlockSprite.setVisible(false);
  }

  private boolean doScroll() {
    int x, y;
    boolean result = false;

    for(y=12; y>1; y--) {
      for(x=1; x<=13; x++) {
        if(flipullCanvas.layer.getCell(x,y-1)>=2 && flipullCanvas.layer.getCell(x,y-1)<=5 &&
           flipullCanvas.layer.getCell(x,y)==0) {
          flipullCanvas.layer.setCell(x,y,flipullCanvas.layer.getCell(x,y-1));
          flipullCanvas.layer.setCell(x,y-1,0);
          result = true;
        }
      }
    }

    return result;
  }

  public void infoPanel() {
    flipullCanvas.writeAt(7,0,""+score);
    flipullCanvas.writeAt(7,2,""+limit);
    updateTimer();
    //flipullCanvas.writeAt(17,0,"3:00");
    flipullCanvas.writeAt(19,2,""+blocks+" ");
    flipullCanvas.writeAt(26,0,""+superBlocks+" ");
    flipullCanvas.writeAt(25,2,""+((int)(((level-1))/5)+1)+"-"+((((level-1))%5)+1));
    flipullCanvas.writeFlush();
  }

  private boolean doRollBack() {
    X += H;
    Y += V;
    V += Vd;
    flipullCanvas.rBlockSprite.setRefPixelPosition(X,Y);

    if(flipullCanvas.rBlockSprite.getFrame()%2==0)
      flipullCanvas.rBlockSprite.nextFrame();
    else
      flipullCanvas.rBlockSprite.prevFrame();

    if(flipullCanvas.rBlockSprite.getRefPixelX()<28)
      return false;
    return true;
  }

  private void adjustRollBackParameters() {
    int testV, goodV=0, diff=100, cdiff;
    int targetY = heroPos * 12 + 15;

    for(testV=0;testV>-30;testV--) {
      int testV2 = testV;
      X = flipullCanvas.rBlockSprite.getRefPixelX();
      Y = flipullCanvas.rBlockSprite.getRefPixelY();
      while(X>28) {
        X += -6;
        Y += testV2;
        testV2++;
      }
      cdiff = (Y>targetY) ? (Y-targetY) : (targetY-Y);
      if(cdiff<diff) {
        diff = cdiff;
        goodV = testV;
      }
    }

    X = flipullCanvas.rBlockSprite.getRefPixelX();
    Y = flipullCanvas.rBlockSprite.getRefPixelY();
    Vd = 1;
    H = -6;
    V = goodV;
  }
  
  private void adjustPointer() {
    int frame = 1, x=2, y=heroPos, h=1, v=0;
    for(;;) {
      if(flipullCanvas.layer.getCell(x+h,y+v)==6) {
        if(h==1) {
          h = 0;
          v = 1;
          frame = 0;
        } else {
          break;
        }
      }
      if(flipullCanvas.layer.getCell(x+h,y+v)>=2 && flipullCanvas.layer.getCell(x+h,y+v)<=5)
        break;
      x += h;
      y += v;
    }

    flipullCanvas.pointerSprite.setPosition(x*12+4,y*12+4);
    flipullCanvas.pointerSprite.setFrame(frame);
  }

  private boolean isMiss() {
    int y;
    for(y=1; y<13; y++)
      if(traceLine(y)==true)
        return false;
    return true;
  }
  private boolean traceLine(int y) {
    int x=2, h=1, v=0;
    for(;;) {
      if(flipullCanvas.layer.getCell(x+h,y+v)==6) {
        if(h==1) {
          h = 0;
          v = 1;
        } else {
          break;
        }
      }
      if(flipullCanvas.layer.getCell(x+h,y+v)>=2 && flipullCanvas.layer.getCell(x+h,y+v)<=5) {
        if(flipullCanvas.blockSprite.getFrame()==0)
          return true;
        if(flipullCanvas.layer.getCell(x+h,y+v)-1==flipullCanvas.blockSprite.getFrame())
          return true;
        break;
      }
      x += h;
      y += v;
    }
    return false;
  }

  private void loadLevel() {
    int x, y;

    /**
     * Initialize level
     */
    flipullCanvas.layer.fillCells(0,0,14,14,6);
    flipullCanvas.layer.fillCells(1,1,12,12,0);

    heroPos = 1;

    flipullCanvas.heroSprite.setRefPixelPosition(22,heroPos*12+15);
    flipullCanvas.blockSprite.setRefPixelPosition(28,heroPos*12+15);

    // --- Levels ---
    switch(level) {

      /** Level 1 */
      case 1:
        for(y=0; y<5; y++)
          for(x=0; x<5; x++)
            flipullCanvas.layer.setCell(12-x,12-y,randomBlock());
        for(y=1; y<=4; y++)
          for(x=8+y; x<=12; x++)
            flipullCanvas.layer.setCell(x,y,6);
        limit = 9;
        time = 180;
        break;
      /** Level 2 */
      case 2:
        for(y=0; y<6; y++)
          for(x=0; x<5; x++)
            flipullCanvas.layer.setCell(12-x,12-y,randomBlock());
        for(y=1; y<=4; y++)
          for(x=8+y; x<=12; x++)
            flipullCanvas.layer.setCell(x,y,6);
        limit = 9;
        time = 180;
        break;
      /** Level 3 */
      case 3:
        for(y=0; y<5; y++)
          for(x=0; x<6; x++)
            flipullCanvas.layer.setCell(12-x,12-y,randomBlock());
        for(y=1; y<=4; y++)
          for(x=8+y; x<=12; x++)
            flipullCanvas.layer.setCell(x,y,6);
        limit = 9;
        time = 180;
        break;
    }
    // -- End of Levels ---

    /** Block counter */
    blocks = 0;
    for(y=0; y<14; y++)
      for(x=0; x<14; x++)
        if(flipullCanvas.layer.getCell(x,y)>=2 && flipullCanvas.layer.getCell(x,y)<=5)
          blocks++;

    adjustPointer();
  }

  private int randomBlock() {
    int block = rnd.nextInt();
    return ( (block<0) ? -block : block ) % 4 + 2;
  }
};

