package classes;

import java.io.*;
import java.util.*;
import javax.microedition.lcdui.*;
import javax.microedition.lcdui.game.*;
import javax.microedition.media.*;

public class FlipullCanvas extends GameCanvas
{
  private FlipullMIDlet flipullMIDlet;
  private Display display;

  private Image heroImages;
  private Image blockImages;
  private Image rBlockImages;
  private Image pointerImages;
  private Image superBlock;
  private Image font;
  private Image msgLevelCompleted;
  private Image msgCongratulations;
  private Image msgGameOver;
  private Image msgTimeOver;
  private Image msgMiss1, msgMiss2;
  private Image textLayerImage;

  private Image textTable;

  public Player sndShot;
  public Player sndBlock;
  public Player sndWall;
  public Player sndWBlock;

  public Sprite heroSprite;
  public Sprite blockSprite;
  public Sprite rBlockSprite;
  public Sprite[] rollingSprites;
  public TiledLayer layer;
  public TiledLayer textLayer;
  public TiledLayer bonusTextLayer;
  public Sprite pointerSprite;

  public boolean isMiss, missFrame;
  public boolean isGameOver;
  public boolean isTimeOver;
  private boolean isLevelCompleted;
  private boolean isCongratulations;
  private boolean isBonus;

  private int bonusTime;
  private int bonusLimit;
  private int bonusNoMiss;

  public FlipullCanvas(FlipullMIDlet flipullMIDlet, Display display) {
    super(false);
    setFullScreenMode(true);

    this.flipullMIDlet = flipullMIDlet;
    this.display = display;

    isMiss = false;
    isGameOver = false;
    isTimeOver = false;

    try {
      heroImages = Image.createImage("/images/hero.png");
      flipullMIDlet.touchScrollBar();
      blockImages = Image.createImage("/images/blocks.png");
      flipullMIDlet.touchScrollBar();
      rBlockImages = Image.createImage("/images/rotblocks.png");
      superBlock = Image.createImage("/images/superblock.png");
      flipullMIDlet.touchScrollBar();
      pointerImages = Image.createImage("/images/pointers.png");
      flipullMIDlet.touchScrollBar();
      font = Image.createImage("/images/font-trans.png");
      flipullMIDlet.touchScrollBar();
      msgLevelCompleted = Image.createImage("/images/msglvlcomp.png");
      flipullMIDlet.touchScrollBar();
      msgCongratulations = Image.createImage("/images/msgcon.png");
      flipullMIDlet.touchScrollBar();
      msgTimeOver = Image.createImage("/images/msgtmovr.png");
      msgGameOver = Image.createImage("/images/msggmovr.png");
      flipullMIDlet.touchScrollBar();
      msgMiss1 = Image.createImage("/images/msgmiss1.png");
      flipullMIDlet.touchScrollBar();
      msgMiss2 = Image.createImage("/images/msgmiss2.png");
      flipullMIDlet.touchScrollBar();

      InputStream is;
      is = flipullMIDlet.getClass().getResourceAsStream("/sounds/shot.wav");
      sndShot = Manager.createPlayer(is,"audio/x-wav");
      sndShot.prefetch();
      flipullMIDlet.touchScrollBar();
      is = flipullMIDlet.getClass().getResourceAsStream("/sounds/block.wav");
      sndBlock = Manager.createPlayer(is,"audio/x-wav");
      sndBlock.prefetch();
      flipullMIDlet.touchScrollBar();
      is = flipullMIDlet.getClass().getResourceAsStream("/sounds/wall.wav");
      sndWall = Manager.createPlayer(is,"audio/x-wav");
      sndWall.prefetch();
      flipullMIDlet.touchScrollBar();
      is = flipullMIDlet.getClass().getResourceAsStream("/sounds/wblock.wav");
      sndWBlock = Manager.createPlayer(is,"audio/x-wav");
      sndWBlock.prefetch();
      flipullMIDlet.touchScrollBar();
    }
    catch(IOException e) { }
    catch(MediaException e) { }

    textTable = Image.createImage(176,32);
    textTable.getGraphics().setColor(0,0,0);
    textTable.getGraphics().fillRect(0,0,textTable.getWidth(),textTable.getHeight());
    flipullMIDlet.touchScrollBar();

    heroSprite = new Sprite(heroImages,16,16);
    heroSprite.defineReferencePixel(8,15);
    heroSprite.setFrame(0);
    flipullMIDlet.touchScrollBar();

    blockSprite = new Sprite(blockImages,12,12);
    blockSprite.defineReferencePixel(0,11);
    blockSprite.setFrame(0);
    flipullMIDlet.touchScrollBar();

    rBlockSprite = new Sprite(rBlockImages,14,14);
    rBlockSprite.defineReferencePixel(0,13);
    rBlockSprite.setVisible(false);
    flipullMIDlet.touchScrollBar();

    rollingSprites = new Sprite[64];        // Too many, but it never hurts :)
    for(int i=0; i<64; i++)
      rollingSprites[i] = null;

    pointerSprite = new Sprite(pointerImages,12,12);
    pointerSprite.setVisible(false);

    layer = new TiledLayer(14,14,blockImages,12,12);
    layer.setPosition(4,4);

    bonusTextLayer = new TiledLayer(28,28,font,6,6);
    bonusTextLayer.setPosition(4,4);

    textLayer = new TiledLayer(28,3,font,6,6);
    textLayer.setPosition(4,4);
    textLayerImage = Image.createImage(176,32);

    Graphics textLayerGraphics = textLayerImage.getGraphics();
    textLayerGraphics.setColor(0,0,0);
    textLayerGraphics.fillRect(0,0,
      textLayerImage.getWidth(),
      textLayerImage.getHeight());
    writeAt(0,0,"SCORE:");
    writeAt(0,2,"LIMIT:");
    writeAt(11,0,"TIME:");
    writeAt(11,2,"BLOCKS:");
//    flipullCanvas.writeAt(26,0,""+superBlocks+" ");
//    flipullCanvas.writeAt(25,2,"1-1");
    textLayer.paint(textLayerGraphics);
    textLayerGraphics.drawImage(superBlock,146,0,textLayerGraphics.TOP|textLayerGraphics.LEFT);
    flipullMIDlet.touchScrollBar();
  }

  public void quit(int score) {
    flipullMIDlet.startMenu();
  }

  public void startFinalScene(int score) {
    flipullMIDlet.startFinalScene(score);
  }

  public void writeAt(int x, int y, String s) {
    for(int i=0; i<s.length(); i++)
      textLayer.setCell(x+i,y,((int)s.charAt(i))-31);
  }

  public void clearBonus() {
    for(int y=0; y<28; y++)
      for(int x=0; x<28; x++)
        bonusTextLayer.setCell(x,y,0);
  }
  public void writeAtBonus(int x, int y, String s) {
    for(int i=0; i<s.length(); i++)
      bonusTextLayer.setCell(x+i,y,((int)s.charAt(i))-31);
  }

  public void writeFlush() {
    Graphics textTableGraphics = textTable.getGraphics();
    textTableGraphics.drawImage(
      textLayerImage,0,0,
      textTableGraphics.TOP|textTableGraphics.LEFT);
    textLayer.paint(textTable.getGraphics());
  }

  public void play(Player p) {
    try {
      p.start();
    }
    catch(MediaException e) { }
  }

  public void addRollingSprite(int x, int y, int no) {
    int i;
    for(i=0; i<64; i++)
      if(rollingSprites[i]==null) {
        rollingSprites[i] = new Sprite(rBlockImages,14,14);
        rollingSprites[i].setRefPixelPosition(x,y);
        rollingSprites[i].setFrame(no*2);
        rollingSprites[i].setVisible(true);
        break;
      }
  }

  public void rollRollingSprites() {
    int i;
    for(i=0; i<64; i++)
      if(rollingSprites[i]!=null)
        if(rollingSprites[i].getFrame()%2==0)
          rollingSprites[i].nextFrame();
        else
          rollingSprites[i].prevFrame();
  }

  public void clearRollingSprites() {
    int i;
    for(i=0; i<64; i++)
      rollingSprites[i] = null;
  }

  public void setLevelCompleted(boolean isLevelCompleted) {
    this.isLevelCompleted = isLevelCompleted;
  }

  public void setCongratulations(boolean isCongratulations) {
    this.isCongratulations = isCongratulations;
  }

  public void setBonus(boolean isBonus) {
    this.isBonus = isBonus;
  }

  public void setBonusValues(int bonusTime, int bonusLimit, int bonusNoMiss) {
    this.bonusTime = bonusTime;
    this.bonusLimit = bonusLimit;
    this.bonusNoMiss = bonusNoMiss;
    clearBonus();
    writeAtBonus(8,12,"   TIME: "+bonusTime);
    writeAtBonus(8,14,"  LIMIT: "+bonusLimit);
    writeAtBonus(8,16,"NO MISS: "+bonusNoMiss);
  }

  public int consumeBonuses() {
    int result = bonusTime + bonusLimit + bonusNoMiss;
    
    setBonusValues(0,0,0);
    play(sndBlock);

    return result;
  }

  public void paint(Graphics g) {
    int ix, iy;
    g.setColor(0,0,0);
    g.fillRect(0,0,getWidth(),getWidth());

    layer.paint(g);
    g.drawImage(textTable,0,176,g.TOP|g.LEFT);
    heroSprite.paint(g);
    blockSprite.paint(g);
    rBlockSprite.paint(g);
    pointerSprite.paint(g);
    for(int i=0; i<64; i++)
      if(rollingSprites[i]!=null)
        rollingSprites[i].paint(g);
    if(isMiss) {
      if(missFrame)
        g.drawImage(msgMiss1,73,50,g.TOP|g.LEFT);
      else
        g.drawImage(msgMiss2,73,50,g.TOP|g.LEFT);
      missFrame = !missFrame;
    }
    if(isGameOver)
      g.drawImage(msgGameOver,58,50,g.TOP|g.LEFT);
    if(isTimeOver)
      g.drawImage(msgTimeOver,60,50,g.TOP|g.LEFT);
    if(isLevelCompleted)
      g.drawImage(msgLevelCompleted,40,50,g.TOP|g.LEFT);
    if(isCongratulations)
      g.drawImage(msgCongratulations,42,50,g.TOP|g.LEFT);
    if(isBonus)
      bonusTextLayer.paint(g);
  }
};

