package classes;

import java.io.*;
import javax.microedition.lcdui.*;
import javax.microedition.lcdui.game.*;
import javax.microedition.rms.*;


public class FlipullHelp extends GameCanvas
{
  private FlipullMIDlet flipullMIDlet;
  private Display display;
  private Image background;
  private Image font;
  private TiledLayer textLayer;
  private int top;
  private final static int lines = 26;

  public FlipullHelp(FlipullMIDlet flipullMIDlet, Display display) {
    super(false);
    setFullScreenMode(true);

    this.flipullMIDlet = flipullMIDlet;
    this.display = display;

    try {
      background = Image.createImage("/images/help.png");
      font = Image.createImage("/images/font-trans.png");
    }
    catch(IOException e) { }

    textLayer = new TiledLayer(28,lines,font,6,6);

    /*            ---------------------------- */
    writeAt(0, 0,"FLIPULL OVERVIEW");

    writeAt(0, 2,"FLIPULL IS AN ADDICTIVE");
    writeAt(0, 3,"STRATEGIC GAME. YOUR GOAL IS");
    writeAt(0, 4,"TO DESTROY AS MANY BLOCKS ON");
    writeAt(0, 5,"THE PLAYGROUND FIELD AS");
    writeAt(0, 6,"POSSIBLE");

    writeAt(0, 8,"PLAY FLIPULL");
    
    writeAt(0,10,"YOU CAN CHOOSE YOUR SHOOTING");
    writeAt(0,11,"DIRECTION BY USING THE 'UP'");
    writeAt(0,12,"AND 'DOWN' BUTTONS. ONCE YOU");
    writeAt(0,13,"CHOOSE YOUR POSITION, PRESS");
    writeAt(0,14,"'FIRE' BUTTON TO SHOOT. ON");
    writeAt(0,15,"YOUR FIRST SHOT YOU HOLD A");
    writeAt(0,16,"DIAMOND, SO YOU CAN DESTROY");
    writeAt(0,17,"ANY OF THE BLOCKS ON THE");
    writeAt(0,18,"PLAYGROUND FIELD. AFTER THE");
    writeAt(0,19,"SHOT YOU'LL GET THE BLOCK,");
    writeAt(0,20,"WHICH IS NEXT TO THE DEST-");
    writeAt(0,21,"ROYED ONE. BE CAREFUL! IF");
    writeAt(0,22,"YOU ARE NOT ON THE MOVE YOU");
    writeAt(0,23,"WILL GET ANOTHER DIAMOND,");
    writeAt(0,24,"BUT IF YOU HAVE NO MORE DI-");
    writeAt(0,25,"AMONDS THE GAME IS OVER.");

    top = 0;
  }

  public void writeAt(int x, int y, String s) {
    for(int i=0; i<s.length(); i++)
      textLayer.setCell(x+i,y,((int)s.charAt(i))-31);
  }

  public void keyPressed(int keyCode) {
    int action = getGameAction(keyCode);
    if(action==FIRE)
      flipullMIDlet.startMenu();
    if(action==DOWN && top > -((lines-1)*6)) {
      top -= 6;
      repaint();
    }
    if(action==UP && top < 0) {
      top += 6;
      repaint();
    }
  }

  public void paint(Graphics g) {
    g.setColor(0,0,0);
    g.fillRect(0,100,176,108);
    g.drawImage(background,0,0,g.TOP|g.LEFT);
    Image scroll = Image.createImage(168,96);
    Graphics sg = scroll.getGraphics();
    sg.setColor(0,0,0);
    sg.fillRect(0,0,168,96);
    textLayer.setPosition(0,top);
    textLayer.paint(sg);
    g.drawImage(scroll,4,106,g.TOP|g.LEFT);
  }
};

