package classes;

import java.io.*;
import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;

public class FlipullMIDlet extends MIDlet
{
  private static Display display;
  private LoadCanvas loadCanvas;
  private MenuCanvas menuCanvas;
  private HOFCanvas hofCanvas;
  private FlipullCanvas flipullCanvas;
  private FlipullMap flipullMap;

  public FlipullMIDlet() {
    display = Display.getDisplay(this);

    loadCanvas = new LoadCanvas();
    display.setCurrent(loadCanvas);

    menuCanvas = new MenuCanvas(this,display);
    flipullCanvas = new FlipullCanvas(this,display);
    flipullMap = new FlipullMap(this);
  }

  public void touchScrollBar() {
    loadCanvas.increase(6);
  }

  public void startMenu() {
    menuCanvas.start();
    //startFinalScene();
  }
  
  public void startFinalScene(int score) {
    FinalScene finalScene = new FinalScene(this,display,score);
    display.setCurrent(finalScene);
  }

  public void showTop10() {
    hofCanvas = new HOFCanvas(this);
    display.setCurrent(hofCanvas);
  }
  
  public void showHelp() {
    FlipullHelp help = new FlipullHelp(this,display);
    display.setCurrent(help);
  }
  
  public void startGame() {
    //display.setCurrent(display, flipullMap, flipullCanvas);
    FlipullThread flipullThread = new FlipullThread(display, flipullMap, flipullCanvas);
    flipullThread.start();
  }

  public void startApp() {
    startMenu();
  }

  public void pauseApp() {
  }

  public void destroyApp(boolean ign) {
  }

  public static void showException(String message) {
    display.setCurrent(new FlipullDebug(message));
  }
};

