package classes;

import java.io.*;
import javax.microedition.lcdui.*;
import javax.microedition.lcdui.game.*;


public class FlipullMap extends GameCanvas
{
  private FlipullMIDlet flipullMIDlet;
  private Image background;
  private Image imgLevel;
  private Image dash;
  private Image[] numbers;
  private Image hero, heroleft;

  private int level, subLevel;
  private boolean showHero;
  private boolean startLevel;

  public FlipullMap(FlipullMIDlet flipullMIDlet) {
    super(false);
    setFullScreenMode(true);

    this.flipullMIDlet = flipullMIDlet;

    try {
      background = Image.createImage("/images/map.png");
      flipullMIDlet.touchScrollBar();
      imgLevel = Image.createImage("/images/map-level.png");
      flipullMIDlet.touchScrollBar();
      dash = Image.createImage("/images/map-dash.png");
      flipullMIDlet.touchScrollBar();
      numbers = new Image[5];
      flipullMIDlet.touchScrollBar();
      for(int i=1; i<=5; i++) {
        numbers[i-1] = Image.createImage("/images/map-"+i+".png");
        flipullMIDlet.touchScrollBar();
      }
      hero = Image.createImage("/images/map-hero.png");
      flipullMIDlet.touchScrollBar();
      heroleft = Image.createImage("/images/map-hero2.png");
      flipullMIDlet.touchScrollBar();
    }
    catch(IOException e) { }

    level = 1;
    subLevel = 1;
  }

  public void setLevel(int level, int subLevel) {
    this.level = level;
    this.subLevel = subLevel;
    startLevel = false;
  }

  public void tick() {
    showHero = !showHero;
    repaint();
  }

  public void keyPressed(int keyCode) {
    startLevel = true;
  }

  public boolean doStartLevel() {
    return startLevel;
  }

  public void paint(Graphics g) {
    g.drawImage(background,0,0,g.TOP|g.LEFT);
    g.drawImage(imgLevel,41,90,g.TOP|g.LEFT);
    g.drawImage(numbers[level-1],93,90,g.TOP|g.LEFT);
    g.drawImage(dash,106,90,g.TOP|g.LEFT);
    g.drawImage(numbers[subLevel-1],115,90,g.TOP|g.LEFT);

    if(showHero) {
      int x, y;
      y = 194 - (level-1) * 15;
      if(level%2==1) {
        /* @ ---> */
        x = 47 + ( (subLevel-1) * 15 );
        g.drawImage(hero,x,y,g.TOP|g.LEFT);
      } else {
        /* <--- @ */
        x = 108 - ( (subLevel-1) * 15 );
        g.drawImage(heroleft,x,y,g.TOP|g.LEFT);
      }
    }

  }
};

