package classes;

import java.io.*;
import javax.microedition.lcdui.*;
import javax.microedition.lcdui.game.*;

public class MenuCanvas extends GameCanvas
{
  private Image image;
  private Image menuImg;
  private Image menuHLImg;
  private FlipullMIDlet flipullMIDlet;
  private Display display;
  private boolean showMenu;
  private int menuPointer;

  public MenuCanvas(FlipullMIDlet flipullMIDlet, Display display) {
    super(false);
    setFullScreenMode(true);
    showMenu = false;
    menuPointer = 0;

    this.flipullMIDlet = flipullMIDlet;
    this.display = display;

    try {
      image = Image.createImage("/images/menu.png");
      flipullMIDlet.touchScrollBar();
      menuImg = Image.createImage("/images/mm.png");
      flipullMIDlet.touchScrollBar();
      menuHLImg = Image.createImage("/images/mm-hl.png");
      flipullMIDlet.touchScrollBar();
    } catch(IOException e) {
      throw new RuntimeException("Unable to load Image: "+e);
    }
  }

  public void start() {
    display.setCurrent(this);
    repaint();
  }

  private void takeAction() {
    switch(menuPointer) {
      case 0:
        flipullMIDlet.startGame();
        break;
      case 1:
        flipullMIDlet.showTop10();
        break;
      case 2:
        flipullMIDlet.showHelp();
        break;
      case 3:
        flipullMIDlet.destroyApp(false);
        flipullMIDlet.notifyDestroyed();
        break;
    }
  }

  public void keyPressed(int keyCode) {
    int action = getGameAction(keyCode);

    if(showMenu==false) {
      showMenu = true;
      repaint();
    } else
    if(action==UP) {
      menuPointer--;
      if(menuPointer<0)
        menuPointer = 3;
      repaint();
    } else
    if(action==DOWN) {
      menuPointer++;
      if(menuPointer>3)
        menuPointer = 0;
      repaint();
    } else
    if(action==FIRE)
      takeAction();
  }

  public void paint(Graphics g) {
    int left = (int)((getWidth()-image.getWidth())/2);
    int top = (int)((getHeight()-image.getHeight())/2);
    g.drawImage(image,left,top,Graphics.TOP|Graphics.LEFT);
    if(showMenu==true) {
      Image crop = Image.createImage(menuHLImg,
        8,
        8+menuPointer*18,
        104,
        18,
        Sprite.TRANS_NONE);
      g.drawImage(menuImg,
        left+28,
        top+image.getHeight()-88-20,
        Graphics.TOP|Graphics.LEFT);

      g.drawImage(crop,
        left+28+8,
        top+image.getHeight()-88-20+8+menuPointer*18,
        Graphics.TOP|Graphics.LEFT);
    }
  }
};

