/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.FullCanvas;
import java.util.Random;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotFoundException;

public class GliderCanvas
extends FullCanvas
implements Runnable,
GliderProperty {
    private Image IMAGE_NOKIA;
    private Image IMAGE_COM2US;
    private static final int STATE_PREV = -1;
    private static final int STATE_INIT = 0;
    private static final int STATE_TITLE = 2;
    private static final int STATE_MENU = 3;
    private static final int STATE_CONTINUE = 4;
    private static final int STATE_START = 5;
    private static final int STATE_HELP = 6;
    private static final int STATE_SETUP = 7;
    private static final int STATE_SCORE = 8;
    private static final int STATE_PORTAL = 9;
    private static final int STATE_ABOUT = 9;
    private static final int STATE_EXIT = 10;
    private static final int STATE_RUN = 11;
    private static final int STATE_PAUSE = 12;
    private static final int STATE_GAMEOVER = 13;
    private static final int STATE_LOAD = 1000;
    private static final int STATE_EXIT_Q = 1001;
    private static final int STATE_TITLE_Q = 1002;
    protected static final int STATE_NOKIA = 2001;
    protected static final int STATE_COM2US = 2002;
    private static final int RUN_STATE_READY = 0;
    private static final int RUN_STATE_ALIVE = 1;
    private static final int RUN_STATE_DEAD = 2;
    private static final int RUN_STATE_CLEAR = 5;
    private static final int RUN_STATE_ALL_CLEAR = 6;
    private static final int RUN_STATE_GAME_OVER = 7;
    private static final int COMMAND_NULL = -1;
    private static final int COMMAND_OPTIONS = 0;
    private static final int COMMAND_SELECT = 1;
    private static final int COMMAND_PLAY = 2;
    private static final int COMMAND_OK = 3;
    private static final int COMMAND_RETURN = 4;
    private static final int COMMAND_RETRY = 5;
    private static final int COMMAND_CLOSE = 6;
    private static final int TIME_UFO_BEAM = 200;
    private static final int TIME_UFO = 100;
    private static final int X_MAX = 79;
    private final int SCREEN_WIDTH = this.getWidth() < 101 ? 96 : 101;
    private final int SCREEN_HEIGHT = this.getHeight() < 80 ? 64 : 80;
    private final int ADJUST_X = (this.getWidth() - this.SCREEN_WIDTH) / 2;
    private final int ADJUST_Y = (this.getHeight() - this.SCREEN_HEIGHT) / 2;
    private final int LINE_HEIGHT = this.SCREEN_HEIGHT > 100 ? 14 : 12;
    private final int LINE_PER_PAGE = this.SCREEN_HEIGHT < 80 ? 4 : 6;
    private final int N_HELP_PAGE = this.SCREEN_HEIGHT < 80 ? 6 : 4;
    private final Font FONT_LARGE = Font.getFont((int)0, (int)0, (int)16);
    private final Font FONT_MEDIUM = Font.getFont((int)0, (int)0, (int)0);
    private final Font FONT_SMALL = Font.getFont((int)0, (int)0, (int)8);
    private int X_START;
    private int Y_START;
    private int X_JEWEL;
    private int Y_JEWEL;
    private MIDlet midlet;
    private GliderEffect effect;
    private Thread thread;
    private Random rnd = new Random();
    private RecordStore rsData;
    private Image imgOffScreen;
    private Image imgCommand;
    private Image imgChar;
    private Image imgVoidDestination;
    private Image imgCloud;
    private Image imgJewels;
    private Image imgObj;
    private Image imgUfo;
    private Image imgDirArrow;
    private Image imgLogo;
    private Image imgStageClear;
    private Image imgAllStageClear;
    private Image imgGameOver;
    private Image imgTitle;
    private Image imgAbout;
    private int nCurrentCommand1;
    private int nCurrentCommand2;
    private int nState;
    private int nPreviousState;
    private int nSecondPreviousState;
    private int nCurrentIndex = 0;
    private int[] nHighScore = new int[4];
    private int nBalloonTime;
    private int nTime;
    private int nLastBalloonStage;
    private int nStage;
    private int nRunState;
    private int nScore;
    private int nGlider;
    private int nMenuIndex;
    private int nSubIndex;
    private int leftHs;
    private int gliderX;
    private int gliderY;
    private int gliderDirection;
    private int[] birdDx = new int[5];
    private int[] birdX = new int[5];
    private int[] birdY = new int[5];
    private int birdCount;
    private int[] cloudX = new int[5];
    private int[] cloudY = new int[5];
    private int cloudCount;
    private int balloonX;
    private int balloonY;
    private int nAniSeqBalloon;
    private boolean balloonVisible;
    private int ufoX;
    private int ufoY;
    private int nAniSeqUFO;
    private int beamX;
    private int beamY;
    private boolean beamVisible;
    private int nAniSeqDirArrow;
    private int nAniSeqGlider;
    private int nAniSeqTitle;
    private int nAniBottomSeq;
    private int nAniSeqBirds;
    private int preGliderDirection;
    private int preDirection;
    private int[] regionH = new int[7];
    private int[] regionV = new int[2];
    private int[][] board = new int[7][7];
    private boolean on;
    protected long lStopWatchStartTime;
    protected static final String STR_DEMO = "This is a demo&version. The full&version is avail-&able from your&carrier/operator.";
    protected static final int COLOR_YELLOW = 0;
    protected static final int COLOR_ORANGE = 0;
    protected static final int COLOR_RED = 0;
    protected static final int COLOR_BROWN = 0;
    protected static final int COLOR_SKY_BLUE = 0xFFFFFF;
    protected static final int COLOR_WHITE = 0xFFFFFF;
    protected static final int COLOR_BLACK = 0;
    protected static final int COLOR_LIGHT_GRAY = 0xFFFFFF;
    protected static final int COLOR_GRAY = 0;
    protected static final int COLOR_DARK_GRAY = 0;
    protected static final int COLOR_BLUE = 0;
    protected static final int COLOR_LIGHT_BLUE = 0;

    public GliderCanvas(GliderMIDlet gliderMIDlet) {
        this.imgOffScreen = Image.createImage((int)this.SCREEN_WIDTH, (int)this.SCREEN_HEIGHT);
        this.midlet = gliderMIDlet;
    }

    protected void startCanvas() {
        this.effect = new GliderEffect();
        this.startGame();
    }

    protected void destroyCanvas() {
        this.midlet.notifyDestroyed();
    }

    protected void pauseCanvas() {
        if (this.nState == 11) {
            this.updateCommands(12);
        }
    }

    protected void startGame() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    private void doJob(int n) {
        switch (n) {
            case 0: {
                this.updateCommands(5);
                break;
            }
            case 1: {
                this.updateCommands(6);
                break;
            }
            case 2: {
                this.updateCommands(8);
                break;
            }
            case 3: {
                this.updateCommands(9);
                break;
            }
            case 4: {
                if (this.nState == 3) {
                    this.updateCommands(10);
                    break;
                }
                this.updateCommands(2);
            }
        }
    }

    protected void addCommandWrap(int n, int n2) {
        this.nCurrentCommand1 = n;
        this.nCurrentCommand2 = n2;
    }

    protected void updateCommands(int n) {
        if (n == -1) {
            this.nState = this.nPreviousState;
            this.nPreviousState = this.nSecondPreviousState;
        } else {
            this.nSecondPreviousState = this.nPreviousState;
            this.nPreviousState = this.nState;
            this.nState = n;
        }
        if (this.nState == 11) {
            this.addCommandWrap(-1, 0);
        } else if (this.nState == 2) {
            this.addCommandWrap(0, 2);
        } else if (this.nState == 3 || this.nState == 12) {
            this.addCommandWrap(1, 4);
        } else if (this.nState == 6 || this.nState == 8 || this.nState == 9) {
            this.addCommandWrap(-1, 4);
        } else if (this.nState == 10) {
            this.destroyCanvas();
        } else if (this.nState == 13) {
            this.addCommandWrap(6, 5);
        }
        if (this.nState == 2) {
            this.saveData();
            this.nMenuIndex = 0;
            this.initRun();
            this.effect.playSound(0);
        } else if (this.nState == 6) {
            this.nSubIndex = 0;
            this.repaint();
        } else if (this.nState == 8) {
            this.rankScore(0);
            this.repaint();
        } else if (this.nState == 3 || this.nState == 9) {
            this.repaint();
        } else if (this.nState == 12) {
            this.saveData();
            this.nSubIndex = 0;
            this.repaint();
        }
    }

    public void commandAction(int n) {
        if (n == 2) {
            this.updateCommands(5);
        } else if (n == 0) {
            if (this.nState == 2) {
                this.updateCommands(3);
            } else {
                this.updateCommands(12);
            }
        } else if (n == 3) {
            this.updateCommands(-1);
        } else if (n == 1) {
            if (this.nState == 3) {
                this.doJob(this.nMenuIndex);
            } else if (this.nState == 12) {
                this.doJob(this.nSubIndex + 1);
            }
        } else if (n == 4) {
            this.updateCommands(-1);
        } else if (n == 5) {
            this.rankScore(0);
            this.saveData();
            this.updateCommands(5);
        } else if (n == 6) {
            this.rankScore(0);
            this.updateCommands(2);
        }
    }

    public int getCommand(int n) {
        if (n == -6) {
            return this.nCurrentCommand1;
        }
        if (n == -7 || n == -5) {
            return this.nCurrentCommand2;
        }
        return -1;
    }

    protected void keyPressed(int n) {
        if (this.nState == 2001) {
            this.updateCommands(1000);
        } else if (this.nState == 2002) {
            this.updateCommands(1000);
        } else if (n == -6 || n == -7 || n == -5) {
            this.commandAction(this.getCommand(n));
        } else if (n == -10) {
            if (this.nState == 3 || this.nState == 12) {
                this.updateCommands(-1);
            }
        } else if (this.nState == 11) {
            if (this.nRunState == 1) {
                switch (this.getKeyDir(n)) {
                    case 2: {
                        this.gliderX -= 3;
                        this.gliderDirection = -1;
                        if (this.gliderX >= 0) break;
                        this.gliderX = 0;
                        break;
                    }
                    case 5: {
                        this.gliderX += 3;
                        this.gliderDirection = 1;
                        if (this.gliderX <= 79) break;
                        this.gliderX = 79;
                    }
                }
            } else if (this.nRunState == 0) {
                this.nTime = 0;
                this.nRunState = 1;
            } else if (this.nRunState == 5) {
                if (this.getKeyDir(n) != 2 && this.getKeyDir(n) != 5) {
                    ++this.nStage;
                    this.nRunState = 0;
                    this.saveGameData();
                    this.initStage(this.nStage);
                }
            } else if (this.nRunState == 6) {
                if (this.getKeyDir(n) != 2 && this.getKeyDir(n) != 5) {
                    this.updateCommands(2);
                }
            } else if (this.nRunState == 2) {
                if (this.getKeyDir(n) != 2 && this.getKeyDir(n) != 5) {
                    this.nRunState = 0;
                    this.saveGameData();
                    this.initStage(this.nStage);
                }
            } else if (this.nRunState == 7 && this.getKeyDir(n) != 2 && this.getKeyDir(n) != 5) {
                this.updateCommands(13);
            }
        } else if (this.nState == 3) {
            if (this.getKeyDir(n) == 1) {
                this.nMenuIndex = this.nMenuIndex > 0 ? --this.nMenuIndex : GliderProperty.S_MENU_TEXT.length - 1;
            } else if (this.getKeyDir(n) == 6) {
                this.nMenuIndex = this.nMenuIndex < GliderProperty.S_MENU_TEXT.length - 1 ? ++this.nMenuIndex : 0;
            } else if (this.getKeyDir(n) == 8) {
                this.doJob(this.nMenuIndex);
            }
            this.repaint();
        } else if (this.nState == 12) {
            if (this.getKeyDir(n) == 1) {
                this.nSubIndex = this.nSubIndex > 0 ? --this.nSubIndex : GliderProperty.S_MENU_TEXT.length - 2;
            } else if (this.getKeyDir(n) == 6) {
                this.nSubIndex = this.nSubIndex < GliderProperty.S_MENU_TEXT.length - 2 ? ++this.nSubIndex : 0;
            } else if (this.getKeyDir(n) == 8) {
                this.doJob(this.nSubIndex + 1);
            }
            this.repaint();
        } else if (this.nState == 6) {
            if (this.getKeyDir(n) == 1 && this.nSubIndex > 0) {
                --this.nSubIndex;
                this.repaint();
            } else if (this.getKeyDir(n) == 6 && this.nSubIndex < this.N_HELP_PAGE - 1) {
                ++this.nSubIndex;
                this.repaint();
            } else if (this.getKeyDir(n) == 8) {
                this.updateCommands(-1);
            }
        } else if ((this.nState == 8 || this.nState == 9) && this.getKeyDir(n) == 8) {
            this.updateCommands(-1);
        }
    }

    public void run() {
        do {
            this.delay(100);
        } while (!this.isShown());
        this.loadResource();
        this.gameThread();
    }

    private void gameThread() {
        while (true) {
            if (this.nState == 11) {
                if (this.nRunState == 1) {
                    this.moveAll();
                } else if (this.nRunState == 2 || this.nRunState == 7) {
                    int n = (this.gliderY + 10 - 2) / 10;
                    if (n < 6) {
                        this.gliderY += 4;
                        this.gliderDirection *= -1;
                    } else {
                        this.gliderY = n * 10 - 10 + 2;
                    }
                }
                this.repaint();
                if (this.nRunState == 1) {
                    this.checkAll();
                    if (this.nTime == 100) {
                        this.effect.playSound(5);
                    }
                    ++this.nTime;
                    if (this.nBalloonTime > 0 && this.nTime == this.nBalloonTime && this.nLastBalloonStage != this.nStage) {
                        this.nLastBalloonStage = this.nStage;
                        this.balloonVisible = true;
                    }
                    if (this.nTime > 200) {
                        this.dieOne();
                    }
                }
            } else if (this.nState == 5) {
                this.nStage = 1;
                this.nLastBalloonStage = 0;
                this.initStage(this.nStage);
                this.nRunState = 0;
                this.updateCommands(11);
            } else {
                this.repaint();
                this.checkStopWatch();
            }
            this.delay(500);
        }
    }

    protected void paint(Graphics graphics) {
        Graphics graphics2 = this.imgOffScreen.getGraphics();
        this.paintOffScreen(graphics2);
        graphics.translate(this.ADJUST_X - graphics.getTranslateX(), this.ADJUST_Y - graphics.getTranslateY());
        graphics.drawImage(this.imgOffScreen, 0, 0, 20);
    }

    private void paintOffScreen(Graphics graphics) {
        if (this.nState == 11) {
            this.clearScreen(graphics);
            this.drawAllThings(graphics);
            if (this.nRunState == 0) {
                this.drawReady(graphics);
            } else if (this.nRunState == 5) {
                this.drawStageClear(graphics);
            } else if (this.nRunState == 6) {
                this.drawAllStageClear(graphics);
            } else if (this.nRunState == 7) {
                this.drawGameOver(graphics);
            }
            if (this.nRunState != 1 || this.SCREEN_HEIGHT > 79) {
                this.drawCurrentCommands(graphics);
            }
        } else if (this.nState == 12) {
            this.clearScreen(graphics);
            this.drawAllThings(graphics);
            this.paintPause(graphics);
            this.drawCurrentCommands(graphics);
        } else if (this.nState == 2) {
            this.clearScreen(graphics);
            this.paintTitle(graphics);
            this.drawCurrentCommands(graphics);
        } else if (this.nState == 3) {
            this.clearScreen(graphics);
            this.paintTitle(graphics);
            this.paintMenu(graphics);
            this.drawCurrentCommands(graphics);
        } else if (this.nState == 6) {
            this.clearScreen(graphics);
            this.paintHelp(graphics);
            this.drawCurrentCommands(graphics);
        } else if (this.nState == 8) {
            this.clearScreen(graphics);
            this.paintScore(graphics);
            this.drawCurrentCommands(graphics);
        } else if (this.nState == 9) {
            this.clearScreen(graphics);
            this.paintAbout(graphics);
            this.drawCurrentCommands(graphics);
        } else if (this.nState == 1000) {
            this.drawLoad(graphics);
        } else if (this.nState == 13) {
            this.clearScreen(graphics);
            this.paintScore(graphics);
            this.drawCurrentCommands(graphics);
        } else if (this.nState == 2001) {
            this.clearScreen(graphics, 0);
            this.drawImageCenter(graphics, this.IMAGE_NOKIA);
        } else if (this.nState == 2002) {
            this.clearScreen(graphics, 0xFFFFFF);
            this.drawImageCenter(graphics, this.IMAGE_COM2US);
        }
    }

    private void initRun() {
        this.X_START = (this.SCREEN_WIDTH - 91) / 2;
        this.Y_START = this.SCREEN_HEIGHT - 60 - 10 + 1;
        if (this.Y_START > 8) {
            this.Y_START -= 8;
        }
        this.X_JEWEL = (this.imgChar.getWidth() / 7 - this.imgJewels.getWidth() / 3) / 2;
        this.Y_JEWEL = (this.imgChar.getHeight() / 3 - this.imgJewels.getHeight()) / 2;
        this.nStage = 0;
        this.nScore = 0;
        this.nGlider = 5;
        this.initStage(this.nStage);
    }

    private void initStage(int n) {
        this.nTime = 0;
        if (n == 0) {
            return;
        }
        this.birdCount = 0;
        this.cloudCount = 0;
        this.leftHs = 0;
        this.balloonVisible = false;
        int n2 = 0;
        while (n2 < 7) {
            int n3 = 0;
            while (n3 < 7) {
                char c = GliderProperty.STAGE_DATA[n - 1].charAt(n2 * 7 + n3);
                this.board[n2][n3] = 0;
                if (c == '}') {
                    this.gliderX = n3 * 13;
                    this.gliderY = n2 * 10;
                    this.gliderDirection = 1;
                } else if (c == '{') {
                    this.gliderX = n3 * 13;
                    this.gliderY = n2 * 10;
                    this.gliderDirection = -1;
                } else if (c == '>') {
                    this.birdX[this.birdCount] = n3 * 13;
                    this.birdY[this.birdCount] = n2 * 10;
                    this.birdDx[this.birdCount] = 2;
                    ++this.birdCount;
                } else if (c == '<') {
                    this.birdX[this.birdCount] = n3 * 13;
                    this.birdY[this.birdCount] = n2 * 10;
                    this.birdDx[this.birdCount] = -2;
                    ++this.birdCount;
                } else if (c == '.') {
                    this.board[n2][n3] = 0;
                } else if (c == '=') {
                    this.board[n2][n3] = 61;
                    this.cloudX[this.cloudCount] = n3 * 13;
                    this.cloudY[this.cloudCount] = n2 * 10;
                    ++this.cloudCount;
                } else if (c == '-') {
                    this.board[n2][n3] = 61;
                } else if (c == '#') {
                    ++this.leftHs;
                    this.board[n2][n3] = 35;
                } else if (c == '&') {
                    this.board[n2][n3] = 38;
                    this.balloonX = n3 * 13;
                    this.balloonY = n2 * 10;
                    this.balloonVisible = false;
                } else {
                    this.board[n2][n3] = c;
                }
                ++n3;
            }
            ++n2;
        }
        this.nBalloonTime = (GliderProperty.STAGE_DATA[n - 1].charAt(49) - 48) * 50 + (GliderProperty.STAGE_DATA[n - 1].charAt(50) - 48) * 10 + (GliderProperty.STAGE_DATA[n - 1].charAt(51) - 48);
    }

    private int getKeyDir(int n) {
        if (n == 53) {
            return 8;
        }
        if (n == 50) {
            return 1;
        }
        if (n == 56) {
            return 6;
        }
        if (n == 54) {
            return 5;
        }
        if (n == 52) {
            return 2;
        }
        return this.getGameAction(n);
    }

    private void dieOne() {
        if (this.nRunState != 2) {
            this.nRunState = 2;
            --this.nGlider;
            this.effect.playSound(3);
            if (this.nGlider <= 0) {
                this.nRunState = 7;
            }
        }
    }

    private void saveGameData() {
        this.putScore(0, this.nScore);
    }

    private boolean collision(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = Math.abs(n - n3);
        int n8 = Math.abs(n2 - n4);
        return n7 < n5 && n8 < n6;
    }

    private void moveAll() {
        int n = 0;
        while (n < this.birdCount) {
            int n2;
            int n3;
            if (this.birdDx[n] < 0) {
                n3 = (this.birdX[n] + 6) / 13;
                n2 = this.birdY[n] / 10;
                this.birdX[n] = this.birdX[n] + this.birdDx[n];
                if (this.birdX[n] < 0) {
                    this.birdDx[n] = -this.birdDx[n];
                    this.birdX[n] = this.birdX[n] + this.birdDx[n] * 2;
                } else if (this.board[n2][n3] == 61) {
                    this.birdDx[n] = -this.birdDx[n];
                    this.birdX[n] = this.birdX[n] + this.birdDx[n] * 2;
                }
            } else if (this.birdDx[n] > 0) {
                n3 = (this.birdX[n] + 17) / 13;
                n2 = this.birdY[n] / 10;
                if (n3 > 6) {
                    n3 = 6;
                }
                this.birdX[n] = this.birdX[n] + this.birdDx[n];
                if (this.birdX[n] >= 78) {
                    this.birdDx[n] = -this.birdDx[n];
                    this.birdX[n] = this.birdX[n] + this.birdDx[n] * 2;
                } else if (this.board[n2][n3] == 61) {
                    this.birdDx[n] = -this.birdDx[n];
                    this.birdX[n] = this.birdX[n] + this.birdDx[n] * 2;
                }
            }
            ++n;
        }
        if (this.Y_START + this.gliderY < 4) {
            this.gliderY = 4 - this.Y_START;
        }
        if (this.gliderY < 4) {
            this.gliderY = 4;
        }
        if (this.gliderX < 0) {
            this.gliderX = 0;
        }
        if (this.gliderX > 79) {
            this.gliderX = 79;
        }
        if (this.balloonVisible) {
            this.balloonY -= 2;
        }
    }

    private void checkAll() {
        int n;
        int n2 = (this.gliderY + 8) / 10;
        int n3 = (this.gliderX + 8) / 13;
        if (this.board[n2][n3] == 35 && this.collision(this.gliderX, this.gliderY, n3 * 13, n2 * 10, 11, 6)) {
            this.effect.playSound(4);
            this.board[n2][n3] = 0;
            --this.leftHs;
            this.nScore += 5;
            this.putScore(0, this.nScore);
        }
        if (this.board[n2][n3] == 42 && this.collision(this.gliderX, this.gliderY, n3 * 13, n2 * 10, 11, 6)) {
            this.board[n2][n3] = 0;
            this.nScore += 5;
            this.putScore(0, this.nScore);
        }
        int n4 = Math.abs(n3 * 13 - this.gliderX) / 2;
        if (this.board[6][n3] == 65) {
            n4 = 4 - n4;
            this.gliderY -= n4;
        } else if (this.board[6][n3] == 86) {
            n4 = 4 - n4;
            this.gliderY += n4;
        } else if (this.board[6][n3] == 38) {
            ++this.gliderY;
        } else if (this.board[6][n3] == 72) {
            ++this.gliderY;
        } else if (this.board[6][n3] == 84) {
            ++this.gliderY;
        }
        int n5 = 0;
        while (n5 < this.birdCount) {
            if (this.collision(this.gliderX + 8, this.gliderY + 8, this.birdX[n5] + 8, this.birdY[n5] + 8, 11, 9)) {
                this.dieOne();
            }
            ++n5;
        }
        if (this.balloonVisible && this.collision(this.gliderX + 8, this.Y_START + this.gliderY + 7, this.balloonX + 3, this.balloonY + 3, 11, 9)) {
            this.effect.playSound(1);
            ++this.nGlider;
            this.balloonVisible = false;
        }
        if (this.Y_START == 0 && this.nTime > 100 && this.gliderY < 9) {
            this.dieOne();
        }
        if ((n = (this.gliderY + 10 - 2) / 10) == 6) {
            this.gliderY = (n - 1) * 10 + 2;
            if (this.board[6][n3] == 72) {
                if (this.leftHs == 0) {
                    this.nRunState = this.nStage == GliderProperty.STAGE_DATA.length ? 6 : 5;
                    this.effect.playSound(2);
                    this.nScore += 50;
                } else {
                    this.dieOne();
                }
            } else {
                this.dieOne();
            }
        }
    }

    private void paintTitle(Graphics graphics) {
        int n = (this.SCREEN_HEIGHT - 10 - this.imgLogo.getHeight() - this.imgTitle.getHeight()) / 2;
        graphics.drawImage(this.imgTitle, this.SCREEN_WIDTH / 2, n, 0x10 | 1);
        this.nAniSeqGlider = (this.nAniSeqGlider + 1) % 3;
        this.drawClipImage(graphics, 7, n + 10, this.imgChar, 13, 10 * this.nAniSeqGlider, 13, 10);
        graphics.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
    }

    private void paintMenu(Graphics graphics) {
        this.drawWindow(graphics, "Options", GliderProperty.S_MENU_TEXT, this.nMenuIndex, 0, GliderProperty.S_MENU_TEXT.length, 80);
    }

    private void paintPause(Graphics graphics) {
        this.drawWindow(graphics, "Options", GliderProperty.S_MENU_TEXT, this.nSubIndex, 1, GliderProperty.S_MENU_TEXT.length, 80);
    }

    private void paintHelp(Graphics graphics) {
        int n = (this.SCREEN_HEIGHT - 10) * this.nSubIndex / this.N_HELP_PAGE;
        graphics.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT - 9);
        graphics.setColor(0);
        graphics.drawRect(this.SCREEN_WIDTH - 6, 0, 4, this.SCREEN_HEIGHT - 10);
        graphics.fillRect(this.SCREEN_WIDTH - 6, n, 4, (this.SCREEN_HEIGHT - 10) * (this.nSubIndex + 1) / this.N_HELP_PAGE - n);
        graphics.setFont(this.FONT_SMALL);
        if (this.SCREEN_HEIGHT < 80) {
            n = this.SCREEN_HEIGHT / 2 - this.LINE_PER_PAGE * this.LINE_HEIGHT / 2 + this.LINE_HEIGHT / 2;
            if (this.nSubIndex == 0) {
                graphics.setColor(0xFF0000);
                graphics.drawString("INSTRUCTION", this.SCREEN_WIDTH / 2, 4, 0x10 | 1);
            }
            graphics.setColor(0);
            if (this.nSubIndex < 4) {
                int n2 = this.nSubIndex * 4;
                while (n2 < this.nSubIndex * 4 + 4) {
                    n = this.drawStringCenter(graphics, GliderProperty.S_HELP_TEXT[n2], n);
                    n -= 2;
                    ++n2;
                }
            } else if (this.nSubIndex == 4) {
                graphics.drawString(GliderProperty.S_HELP_TEXT[16], 14, (n += 5) + 0, 20);
                graphics.drawString(GliderProperty.S_HELP_TEXT[17], 14, n + 18, 20);
                this.drawClipImage(graphics, 0, n + 0, this.imgObj, 52, 0, 13, 10);
                this.drawClipImage(graphics, 0, n + 18, this.imgObj, 0, 10, 13, 10);
            } else if (this.nSubIndex == 5) {
                graphics.drawString(GliderProperty.S_HELP_TEXT[18], 14, (n += 5) + 0, 20);
                graphics.drawString(GliderProperty.S_HELP_TEXT[19], 14, n + 18, 20);
                this.drawClipImage(graphics, 0, n + 0, this.imgObj, 13, 0, 13, 10);
                this.drawClipImage(graphics, 0, n + 18, this.imgObj, 26, 0, 13, 10);
            }
        } else if (this.nSubIndex == 0) {
            graphics.setColor(0xFF0000);
            graphics.drawString("INSTRUCTION", this.SCREEN_WIDTH / 2, 4, 0x10 | 1);
            n = 20;
            graphics.setColor(0);
            int n3 = this.nSubIndex * 4;
            while (n3 < this.nSubIndex * 4 + 4) {
                n = this.drawStringCenter(graphics, GliderProperty.S_HELP_TEXT[n3], n);
                n -= 2;
                ++n3;
            }
        } else {
            n = 5;
            graphics.setColor(0);
            if (this.nSubIndex < 3) {
                int n4 = (this.nSubIndex - 1) * this.LINE_PER_PAGE + 4;
                while (n4 < this.nSubIndex * this.LINE_PER_PAGE + 4) {
                    n = this.drawStringCenter(graphics, GliderProperty.S_HELP_TEXT[n4], n);
                    --n;
                    ++n4;
                }
            } else {
                graphics.drawString(GliderProperty.S_HELP_TEXT[16], 14, n + 0, 20);
                graphics.drawString(GliderProperty.S_HELP_TEXT[17], 14, n + 18, 20);
                graphics.drawString(GliderProperty.S_HELP_TEXT[18], 14, n + 36, 20);
                graphics.drawString(GliderProperty.S_HELP_TEXT[19], 14, n + 54, 20);
                this.drawClipImage(graphics, 0, n + 0, this.imgObj, 52, 0, 13, 10);
                this.drawClipImage(graphics, 0, n + 18, this.imgObj, 0, 10, 13, 10);
                this.drawClipImage(graphics, 0, n + 36, this.imgObj, 13, 0, 13, 10);
                this.drawClipImage(graphics, 0, n + 54, this.imgObj, 26, 0, 13, 10);
            }
        }
    }

    private void paintScore(Graphics graphics) {
        graphics.drawImage(this.imgCloud, 5, 10, 20);
        graphics.drawImage(this.imgCloud, 17, 15, 20);
        graphics.drawImage(this.imgCloud, this.SCREEN_WIDTH - 44, this.SCREEN_HEIGHT - 25, 20);
        int n = this.SCREEN_HEIGHT / 2 - this.LINE_HEIGHT * 3 / 2 + this.LINE_HEIGHT / 2;
        this.clearScreen(graphics);
        graphics.setColor(0xFF0000);
        graphics.drawString("HIGH SCORE", this.SCREEN_WIDTH / 2, 4, 17);
        graphics.setColor(0x8080FF);
        int n2 = 0;
        while (n2 < 3) {
            graphics.drawString(n2 + 1 + ".", 15, n + n2 * this.LINE_HEIGHT, 20);
            graphics.drawString(this.getScore(0, n2), this.SCREEN_WIDTH - 15, n + n2 * this.LINE_HEIGHT, 24);
            ++n2;
        }
        if (n > 35) {
            graphics.drawString("rank", 10, n - this.LINE_HEIGHT - 5, 20);
            graphics.drawString("score", this.SCREEN_WIDTH - 15, n - this.LINE_HEIGHT - 5, 24);
        }
        this.drawLogo(graphics);
    }

    private void paintAbout(Graphics graphics) {
        graphics.drawImage(this.imgAbout, this.SCREEN_WIDTH / 2, (this.SCREEN_HEIGHT - 10 - this.imgAbout.getHeight()) / 2, 0x10 | 1);
    }

    private void drawLogo(Graphics graphics) {
        if (this.SCREEN_HEIGHT > 120) {
            graphics.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
        }
    }

    private void drawAllThings(Graphics graphics) {
        graphics.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
        graphics.fillRect(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
        this.drawClouds(graphics);
        this.drawItems(graphics);
        this.drawBalloon(graphics);
        this.drawBottom(graphics);
        this.drawBirds(graphics);
        this.drawGlider(graphics);
        this.drawUFO(graphics);
        graphics.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
    }

    private void drawBottom(Graphics graphics) {
        if (this.nRunState == 1) {
            this.nAniBottomSeq = (this.nAniBottomSeq + 1) % 3;
        }
        int n = 6;
        int n2 = 0;
        while (n2 < 7) {
            graphics.setClip(this.X_START + n2 * 13, this.Y_START + n * 10 - 1, 13, 10);
            if (this.board[n][n2] == 38) {
                graphics.drawImage(this.imgObj, this.X_START + n2 * 13 - 39, this.Y_START + n * 10 - 10 * this.nAniBottomSeq - 1, 20);
            } else if (this.board[n][n2] == 86) {
                graphics.drawImage(this.imgObj, this.X_START + n2 * 13 - 13, this.Y_START + n * 10 - 10 * this.nAniBottomSeq - 1, 20);
            } else if (this.board[n][n2] == 65) {
                graphics.drawImage(this.imgObj, this.X_START + n2 * 13 - 0, this.Y_START + n * 10 - 10 * this.nAniBottomSeq - 1, 20);
            } else if (this.board[n][n2] == 84) {
                graphics.drawImage(this.imgObj, this.X_START + n2 * 13 - 52, this.Y_START + n * 10 - 1, 20);
            } else if (this.board[n][n2] == 72) {
                if (this.leftHs == 0) {
                    graphics.drawImage(this.imgObj, this.X_START + n2 * 13 - 26, this.Y_START + n * 10 - 10 * this.nAniBottomSeq - 1, 20);
                } else {
                    graphics.drawImage(this.imgVoidDestination, this.X_START + n2 * 13, this.Y_START + n * 10 - 1, 20);
                }
            }
            ++n2;
        }
    }

    private void drawGlider(Graphics graphics) {
        graphics.setClip(this.X_START + this.gliderX, this.Y_START + this.gliderY, 13, 10);
        if (this.nRunState == 2 || this.nRunState == 7) {
            int n;
            if (this.nAniSeqGlider < 1) {
                this.nAniSeqGlider = (this.nAniSeqGlider + 1) % 3;
            }
            if ((n = (this.gliderY + 14) / 10) == 6) {
                switch (this.gliderDirection) {
                    case 1: {
                        graphics.drawImage(this.imgChar, this.X_START + this.gliderX - 65, this.Y_START + this.gliderY - 10 * this.nAniSeqGlider, 20);
                        break;
                    }
                    case -1: {
                        graphics.drawImage(this.imgChar, this.X_START + this.gliderX - 78, this.Y_START + this.gliderY - 10 * this.nAniSeqGlider, 20);
                    }
                }
            } else {
                switch (this.gliderDirection) {
                    case 1: {
                        graphics.drawImage(this.imgChar, this.X_START + this.gliderX - 13, this.Y_START + this.gliderY - 10 * this.nAniSeqGlider, 20);
                        break;
                    }
                    case -1: {
                        graphics.drawImage(this.imgChar, this.X_START + this.gliderX - 0, this.Y_START + this.gliderY - 10 * this.nAniSeqGlider, 20);
                    }
                }
            }
        } else {
            this.nAniSeqGlider = (this.nAniSeqGlider + 1) % 3;
            switch (this.gliderDirection) {
                case 1: {
                    graphics.drawImage(this.imgChar, this.X_START + this.gliderX - 13, this.Y_START + this.gliderY - 10 * this.nAniSeqGlider, 20);
                    break;
                }
                case -1: {
                    graphics.drawImage(this.imgChar, this.X_START + this.gliderX - 0, this.Y_START + this.gliderY - 10 * this.nAniSeqGlider, 20);
                }
            }
        }
        this.preGliderDirection = this.gliderDirection;
    }

    private void drawBirds(Graphics graphics) {
        if (this.nRunState == 1 || this.nRunState == 2 || this.nRunState == 7) {
            this.nAniSeqBirds = (this.nAniSeqBirds + 1) % 3;
        }
        int n = 0;
        while (n < this.birdCount) {
            graphics.setClip(this.X_START + this.birdX[n], this.Y_START + this.birdY[n], 13, 10);
            if (this.birdDx[n] < 0) {
                graphics.drawImage(this.imgChar, this.X_START + this.birdX[n] - 26, this.Y_START + this.birdY[n] - 10 * this.nAniSeqBirds, 20);
            } else if (this.birdDx[n] > 0) {
                graphics.drawImage(this.imgChar, this.X_START + this.birdX[n] - 39, this.Y_START + this.birdY[n] - 10 * this.nAniSeqBirds, 20);
            }
            ++n;
        }
    }

    private void drawItems(Graphics graphics) {
        int n = 0;
        while (n < 7) {
            int n2 = 0;
            while (n2 < 7) {
                if (this.board[n][n2] == 35) {
                    graphics.setClip(this.X_START + n2 * 13 + this.X_JEWEL, this.Y_START + n * 10 + this.Y_JEWEL, 8, 8);
                    graphics.drawImage(this.imgJewels, this.X_START + n2 * 13 + this.X_JEWEL - 8, this.Y_START + n * 10 + this.Y_JEWEL, 20);
                } else if (this.board[n][n2] == 42) {
                    graphics.setClip(this.X_START + n2 * 13 + this.X_JEWEL, this.Y_START + n * 10 + this.Y_JEWEL, 8, 8);
                    graphics.drawImage(this.imgJewels, this.X_START + n2 * 13 + this.X_JEWEL, this.Y_START + n * 10 + this.Y_JEWEL, 20);
                }
                ++n2;
            }
            ++n;
        }
    }

    private void drawClouds(Graphics graphics) {
        int n = 0;
        while (n < this.cloudCount) {
            graphics.drawImage(this.imgCloud, this.X_START + this.cloudX[n], this.Y_START + this.cloudY[n], 20);
            ++n;
        }
    }

    private void drawBalloon(Graphics graphics) {
        this.nAniSeqBalloon = (this.nAniSeqBalloon + 1) % 3;
        if (this.balloonVisible) {
            if (this.balloonY < 0) {
                graphics.setClip(this.balloonX, 0, 13, 10 + this.balloonY);
            } else if (this.SCREEN_HEIGHT - this.balloonY < 10) {
                graphics.setClip(this.X_START + this.balloonX, this.Y_START + this.balloonY, 13, this.SCREEN_HEIGHT - this.balloonY);
            } else {
                graphics.setClip(this.X_START + this.balloonX, this.Y_START + this.balloonY, 13, 10);
            }
            graphics.drawImage(this.imgChar, this.X_START + this.balloonX - 52, this.Y_START + this.balloonY - 10 * this.nAniSeqBalloon, 20);
        }
    }

    private void drawUFO(Graphics graphics) {
        if (this.nTime > 100) {
            this.ufoX = this.gliderX + 4;
            this.nAniSeqUFO = (this.nAniSeqUFO + 1) % 3;
            graphics.setClip(this.ufoX, this.ufoY, 16, 9);
            graphics.drawImage(this.imgUfo, this.ufoX, this.ufoY - 9 * this.nAniSeqUFO, 20);
            if (this.nTime > 200) {
                this.beamX = this.ufoX + 7;
                this.beamY = this.ufoY + 10;
                graphics.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
                graphics.setColor(0xFFFF00);
                graphics.drawLine(this.beamX, this.beamY, this.beamX, this.SCREEN_HEIGHT - 10);
                graphics.drawLine(this.beamX + 1, this.beamY, this.beamX + 1, this.SCREEN_HEIGHT - 10);
            }
        }
    }

    private void drawReady(Graphics graphics) {
        this.drawWindow(graphics, "STAGE " + this.nStage, new String[]{"Lives : " + this.nGlider, "Score : " + this.nScore}, -1, 0, 2, 70);
    }

    private void drawStageClear(Graphics graphics) {
        graphics.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT - 10);
        graphics.drawImage(this.imgStageClear, this.SCREEN_WIDTH / 2, this.SCREEN_HEIGHT / 2, 0x10 | 1);
    }

    private void drawAllStageClear(Graphics graphics) {
        graphics.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT - 10);
        graphics.drawImage(this.imgAllStageClear, this.SCREEN_WIDTH / 2, this.SCREEN_HEIGHT / 2, 0x10 | 1);
    }

    private void drawGameOver(Graphics graphics) {
        graphics.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT - 10);
        graphics.drawImage(this.imgGameOver, this.SCREEN_WIDTH / 2, this.SCREEN_HEIGHT / 2, 0x10 | 1);
    }

    private void drawClipImage(Graphics graphics, int n, int n2, Image image, int n3, int n4, int n5, int n6) {
        graphics.setClip(n, n2, n5, n6);
        graphics.drawImage(image, n - n3, n2 - n4, 20);
    }

    private void drawWindow(Graphics graphics, String string, String[] stringArray, int n, int n2, int n3, int n4) {
        graphics.setFont(this.FONT_SMALL);
        int n5 = (this.FONT_SMALL.getHeight() + 2) * (n3 - n2 + 1) + 5;
        if (n5 < this.SCREEN_HEIGHT - 12) {
            int n6 = (this.SCREEN_HEIGHT - 8 - n5) / 2;
            int n7 = (this.SCREEN_WIDTH - n4) / 2;
            graphics.setClip(n7 - 1, n6 - 1, n4 + 3, n5 + 3);
            graphics.setColor(0xEEEEEE);
            graphics.fillRect(n7 - 1, n6 - 1, n4 + 3, n5 + 3);
            graphics.setColor(0);
            graphics.drawRect(n7, n6, n4, n5);
            graphics.fillRect(n7, n6, n4, this.FONT_SMALL.getHeight() + 5);
            int n8 = 0;
            while (n8 < n3 - n2) {
                graphics.drawString(stringArray[n8 + n2], n7 + 5, n6 + (n8 + 1) * (this.FONT_SMALL.getHeight() + 2) + 6, 20);
                ++n8;
            }
            if (n >= 0) {
                graphics.fillRect(n7 + 2, n6 + (n + 1) * (this.FONT_SMALL.getHeight() + 2) + 4, n4 - 3, this.FONT_SMALL.getHeight() + 2);
                graphics.setColor(0xEEEEEE);
                graphics.drawString(stringArray[n + n2], n7 + 5, n6 + (n + 1) * (this.FONT_SMALL.getHeight() + 2) + 6, 20);
            } else {
                graphics.setColor(0xEEEEEE);
            }
            graphics.drawString(string, this.SCREEN_WIDTH / 2, n6 + 3, 17);
        } else {
            graphics.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
            n5 = this.FONT_SMALL.getHeight() * (n3 - n2);
            int n9 = (this.SCREEN_HEIGHT - 8 - n5) / 2;
            int n10 = (this.SCREEN_WIDTH - n4) / 2;
            graphics.setClip(n10 - 1, n9 - 4, n4 + 3, n5 + 7);
            graphics.setColor(0xEEEEEE);
            graphics.fillRect(n10 - 1, n9 - 4, n4 + 3, n5 + 7);
            graphics.setColor(0);
            graphics.drawRect(n10, n9 - 3, n4, n5 + 4);
            int n11 = 0;
            while (n11 < n3 - n2) {
                graphics.drawString(stringArray[n11 + n2], n10 + 5, n9 + n11 * this.FONT_SMALL.getHeight(), 20);
                ++n11;
            }
            if (n >= 0) {
                graphics.fillRect(n10 + 2, n9 - 1 + n * this.FONT_SMALL.getHeight(), n4 - 3, this.FONT_SMALL.getHeight() + 1);
                graphics.setColor(0xEEEEEE);
                graphics.drawString(stringArray[n + n2], n10 + 5, n9 + n * this.FONT_SMALL.getHeight(), 20);
            }
        }
    }

    private void drawCurrentCommands(Graphics graphics) {
        graphics.setClip(0, this.SCREEN_HEIGHT - 7, this.SCREEN_WIDTH, 7);
        this.drawCommand(graphics, this.nCurrentCommand1, false);
        this.drawCommand(graphics, this.nCurrentCommand2, true);
    }

    private void drawCommand(Graphics graphics, int n, boolean bl) {
        if (n != -1) {
            graphics.drawImage(this.imgCommand, bl ? this.SCREEN_WIDTH - 2 : 2, this.SCREEN_HEIGHT - 7 - n * 7, 0x10 | (bl ? 8 : 4));
        }
    }

    private void clearScreen(Graphics graphics) {
        graphics.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
        graphics.setColor(9231100);
        graphics.fillRect(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
    }

    private void delay(int n) {
        try {
            Thread.sleep(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadResource() {
        this.resetStopWatch();
        this.nState = 2001;
        this.IMAGE_NOKIA = this.getImage("0");
        this.IMAGE_COM2US = this.getImage("1");
        this.imgCommand = this.getImage("cmd");
        this.imgAbout = this.getImage("about");
        this.imgJewels = this.getImage("jewels");
        this.imgCloud = this.getImage("cloud");
        this.imgVoidDestination = this.getImage("voiddest");
        this.imgUfo = this.getImage("ufo");
        this.imgLogo = this.getImage("logo");
        this.imgObj = this.getImage("obj");
        this.imgChar = this.getImage("char");
        this.imgStageClear = this.getImage("stageclear");
        this.imgAllStageClear = this.getImage("allstageclear");
        this.imgGameOver = this.getImage("gameover");
        this.imgTitle = this.getImage("title");
        this.loadData();
    }

    private boolean loadData() {
        int n = 0;
        while (n < 3) {
            this.nHighScore[n] = 0;
            ++n;
        }
        try {
            this.rsData = RecordStore.openRecordStore((String)"Rank", (boolean)false);
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            try {
                this.rsData = RecordStore.openRecordStore((String)"Rank", (boolean)true);
                byte[] byArray = "000".getBytes();
                byte[] byArray2 = "000".getBytes();
                byte[] byArray3 = "000".getBytes();
                this.rsData.addRecord(byArray, 0, byArray.length);
                this.rsData.addRecord(byArray2, 0, byArray2.length);
                this.rsData.addRecord(byArray3, 0, byArray3.length);
            }
            catch (RecordStoreException recordStoreException) {
                return false;
            }
        }
        catch (RecordStoreException recordStoreException) {
            return false;
        }
        try {
            this.nHighScore[0] = Integer.parseInt(new String(this.rsData.getRecord(1)));
            this.nHighScore[1] = Integer.parseInt(new String(this.rsData.getRecord(2)));
            this.nHighScore[2] = Integer.parseInt(new String(this.rsData.getRecord(3)));
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public void saveData() {
        byte[] byArray = String.valueOf(this.nHighScore[0]).getBytes();
        byte[] byArray2 = String.valueOf(this.nHighScore[1]).getBytes();
        byte[] byArray3 = String.valueOf(this.nHighScore[2]).getBytes();
        try {
            this.rsData.setRecord(1, byArray, 0, byArray.length);
            this.rsData.setRecord(2, byArray2, 0, byArray2.length);
            this.rsData.setRecord(3, byArray3, 0, byArray3.length);
        }
        catch (Exception exception) {
            return;
        }
    }

    protected String getScore(int n, int n2) {
        return String.valueOf(this.nHighScore[n2]);
    }

    protected boolean isNewHigh(int n, int n2) {
        return n < n2;
    }

    protected void putScore(int n, int n2) {
        if (this.isNewHigh(this.nHighScore[3], n2)) {
            this.nHighScore[3] = n2;
        }
    }

    protected void rankScore(int n) {
        int n2 = 3;
        while (n2 > 0) {
            if (this.nHighScore[n2] > this.nHighScore[n2 - 1]) {
                int n3 = this.nHighScore[n2];
                this.nHighScore[n2] = this.nHighScore[n2 - 1];
                this.nHighScore[n2 - 1] = n3;
            }
            --n2;
        }
    }

    protected Image getImage(String string) {
        this.checkStopWatch();
        Image image = null;
        try {
            image = Image.createImage((String)("/image/" + string + ".png"));
            ++this.nCurrentIndex;
        }
        catch (Exception exception) {
            return null;
        }
        this.repaint();
        this.serviceRepaints();
        return image;
    }

    public int drawStringCenter(Graphics graphics, String string, int n) {
        graphics.drawString(string, 0, n, 20);
        return n + 12;
    }

    protected void drawMsgBack(Graphics graphics) {
        graphics.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
        graphics.setColor(0);
        graphics.setFont(this.FONT_SMALL);
    }

    private void drawLoad(Graphics graphics) {
        int n = this.nCurrentIndex * 80 / 19;
        if (n > 80) {
            n = 80;
        }
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, this.SCREEN_WIDTH, 65);
        graphics.setColor(0, 0, 0);
        graphics.setFont(this.FONT_MEDIUM);
        graphics.drawString("GliderAction", this.SCREEN_WIDTH / 2, 25, 0x10 | 1);
        graphics.fillRect((this.SCREEN_WIDTH - 80) / 2, 45, n, 11);
        graphics.drawRect((this.SCREEN_WIDTH - 80) / 2, 45, 79, 10);
    }

    protected void resetStopWatch() {
        this.lStopWatchStartTime = System.currentTimeMillis();
    }

    protected long getStopWatchTime() {
        return System.currentTimeMillis() - this.lStopWatchStartTime;
    }

    protected void checkStopWatch() {
        if (this.nState == 2001) {
            this.repaint();
            if (this.getStopWatchTime() >= 3000L) {
                this.resetStopWatch();
                this.updateCommands(1000);
            }
        } else if (this.nState == 2002) {
            this.repaint();
            if (this.getStopWatchTime() >= 3000L) {
                this.updateCommands(1000);
            }
        }
        if (this.nState == 1000 && this.imgTitle != null) {
            this.updateCommands(2);
        }
    }

    protected void drawText(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        do {
            n6 = string.indexOf("&", n5);
            if (n2 >= 0 && n2 < this.SCREEN_HEIGHT) {
                graphics.drawSubstring(string, n5, n6 == -1 ? string.length() - n5 : n6 - n5, n, n2, n3);
            }
            n5 = n6 + 1;
            n2 += n4;
        } while (n6 != -1);
    }

    protected void paintDemo(Graphics graphics) {
        int n = (this.SCREEN_HEIGHT - 60) / 2;
        this.clearScreen(graphics);
        graphics.setColor(0, 0, 0);
        graphics.setFont(this.FONT_SMALL);
        this.drawText(graphics, STR_DEMO, 7, n, 20, 12);
    }

    protected void clearScreen(Graphics graphics, int n) {
        graphics.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
        graphics.setColor(n);
        graphics.fillRect(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
    }

    private void drawImageCenter(Graphics graphics, Image image) {
        this.drawImageCenter(graphics, image, 0, 0);
    }

    private void drawImageCenter(Graphics graphics, Image image, int n, int n2) {
        if (image != null) {
            graphics.drawImage(image, this.SCREEN_WIDTH / 2 + n, (this.SCREEN_HEIGHT - image.getHeight()) / 2 + n2, 17);
        }
    }
}

