/*
 * Decompiled with CFR 0.152.
 */
import com.bsg.nokia.BSCanvas;
import com.nokia.mid.sound.Sound;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MACanvas
extends BSCanvas
implements CommandListener {
    public Display display;
    private Command OKCom;
    private int MiniStartX = this.getWidth() - 15;
    private byte[][][] LookAhead = new byte[][][]{new byte[][]{{-2, -3, 1, 0}, {3, -2, 0, 1}, {2, 3, -1, 0}, {-3, 2, 0, -1}}, new byte[][]{{-1, -2, 1, 0}, {2, -1, 0, 1}, {1, 2, -1, 0}, {-2, 1, 0, -1}}, new byte[][]{{-1, -1, 1, 0}, {1, -1, 0, 1}, {1, 1, -1, 0}, {-1, 1, 0, -1}}, new byte[][]{{-2, -2, 2, -2}, {2, -2, 2, 2}, {2, 2, -2, 2}, {-2, 2, -2, -2}}, new byte[][]{{-1, -2, 1, -2}, {2, -1, 2, 1}, {1, 2, -1, 2}, {-2, 1, -2, -1}}, new byte[][]{{-1, -1, 1, -1}, {1, -1, 1, 1}, {1, 1, -1, 1}, {-1, 1, -1, -1}}, new byte[][]{{-1, 0, 1, 0}, {0, -1, 0, 1}, {1, 0, -1, 0}, {0, 1, 0, -1}}, new byte[][]{{0, -2}, {2, 0}, {0, 2}, {-2, 0}}, new byte[][]{{0, -1}, {1, 0}, {0, 1}, {-1, 0}}};
    private int[][] DrawCoords;
    private int UserX;
    private int UserY;
    private int UserDirection;
    private int Level;
    private int Moves;
    private int ParScore;
    private byte[][] board;
    private byte[][] AutoMap;
    private int ExitX;
    private int ExitY;
    private int TotalMoves;
    private Image[] Compass;
    private Image Options;
    private Image[] TileSet;
    private Image[] Exits;
    private boolean Viewing;
    private int HalfWidth;
    private int HalfHeight;
    private Sound[] sounds = new Sound[4];

    public MACanvas() {
        this.HalfWidth = this.getWidth() / 2;
        this.HalfHeight = this.getHeight() / 2;
        try {
            int i;
            byte[] sound1 = new byte[]{2, 74, 58, 81, -47, -107, -51, -48, 4, 0, 27, 24, 70, 4, -32, 86, 5, -96, 98, 0, 0};
            byte[] sound2 = new byte[]{2, 74, 58, 81, -47, -107, -51, -48, 4, 0, 27, 24, 98, 5, -96, 86, 4, -32, 70, 0, 0};
            byte[] sound3 = new byte[]{2, 74, 58, 81, -47, -107, -51, -48, 4, 0, 27, 24, 69, -123, 96, 90, 6, 32, -94, 44, 65, 22, 0, 0};
            byte[] sound4 = new byte[]{2, 74, 58, 81, -47, -107, -51, -48, 4, 0, 27, 32, 70, 0, 0};
            this.sounds[0] = new Sound(sound1, 1);
            this.sounds[0].init(sound1, 1);
            this.sounds[1] = new Sound(sound3, 1);
            this.sounds[1].init(sound3, 1);
            this.sounds[2] = new Sound(sound2, 1);
            this.sounds[2].init(sound2, 1);
            this.sounds[3] = new Sound(sound4, 1);
            this.sounds[3].init(sound4, 1);
            int[][] c = new int[][]{{15, 15, 0, 0}, {15, 15, -15, 0}, {15, 15, 0, -15}, {15, 15, -15, -15}, {19, 8, -289, -25}, {38, 11, -270, -15}, {52, 15, -256, 0}, {20, 64, -84, 0}, {32, 64, -52, 0}, {52, 64, 0, 0}, {22, 64, -104, 0}, {22, 64, -126, 0}, {6, 64, -180, 0}, {6, 64, -218, 0}, {10, 64, -170, 0}, {10, 64, -208, 0}, {22, 64, -148, 0}, {22, 64, -186, 0}, {22, 64, -224, 0}};
            this.TileSet = new Image[12];
            this.Exits = new Image[3];
            this.Compass = new Image[4];
            this.Options = Image.createImage((String)"/Options.png");
            Image images = Image.createImage((String)"/Compass.png");
            for (i = 0; i < 4; ++i) {
                this.Compass[i] = this.getImage(images, c[i][0], c[i][1], c[i][2], c[i][3]);
            }
            for (i = 5; i < 7; ++i) {
                this.Exits[i - 4] = Image.createImage((String)String.valueOf(String.valueOf(new StringBuffer("/e").append(i - 4).append(".png"))));
            }
            for (i = 7; i < 19; ++i) {
                this.TileSet[i - 7] = Image.createImage((String)String.valueOf(String.valueOf(new StringBuffer("/").append(i - 7).append(".png"))));
            }
            this.DrawCoords = new int[][]{{0, this.getWidth()}, {this.TileSet[9].getWidth() + this.TileSet[7].getWidth(), this.getWidth() - this.TileSet[10].getWidth() - this.TileSet[8].getWidth()}, {this.TileSet[9].getWidth(), this.getWidth() - this.TileSet[10].getWidth()}, {0, this.getWidth()}};
            System.out.println("hello");
            images = Image.createImage((String)"/bsg.png");
            System.out.println("here");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Image getImage(Image i, int w, int h, int x, int y) {
        Image im = Image.createImage((int)w, (int)h);
        Graphics g = im.getGraphics();
        g.drawImage(i, x, y, 0x10 | 4);
        return im;
    }

    public void createCommands() {
        this.OKCom = new Command(this.langT[0], 2, 1);
    }

    private void LoadLevel(Gauge progress) {
        try {
            this.Viewing = true;
            DataInputStream in = new DataInputStream(((Object)((Object)this)).getClass().getResourceAsStream("/".concat(String.valueOf(String.valueOf(this.Level)))));
            int wid = Integer.parseInt(new String(new byte[]{in.readByte(), in.readByte()}), 16);
            int hei = Integer.parseInt(new String(new byte[]{in.readByte(), in.readByte()}), 16);
            this.board = new byte[hei][wid];
            this.AutoMap = new byte[hei][wid];
            this.UserX = Integer.parseInt(new String(new byte[]{in.readByte(), in.readByte()}), 16);
            this.UserY = Integer.parseInt(new String(new byte[]{in.readByte(), in.readByte()}), 16);
            this.ExitX = Integer.parseInt(new String(new byte[]{in.readByte(), in.readByte()}), 16);
            this.ExitY = Integer.parseInt(new String(new byte[]{in.readByte(), in.readByte()}), 16);
            for (int y = 0; y < hei; ++y) {
                for (int x = 0; x < wid; ++x) {
                    this.board[y][x] = in.readByte();
                }
            }
            this.ParScore = Integer.parseInt(new String(new byte[]{in.readByte(), in.readByte(), in.readByte(), in.readByte()}), 16);
            this.UserDirection = 0;
            this.ClearMap();
            this.LookAround();
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void ClearMap() {
        for (int y = 0; y < this.AutoMap.length; ++y) {
            for (int x = 0; x < this.AutoMap[y].length; ++x) {
                this.AutoMap[y][x] = 1;
            }
        }
    }

    private void LookAround() {
        for (int y = this.UserY - 1; y < this.UserY + 2; ++y) {
            for (int x = this.UserX - 1; x < this.UserX + 2; ++x) {
                if (y <= 0 || x <= 0 || y >= this.board.length || x >= this.board[0].length) continue;
                this.AutoMap[y][x] = this.board[y][x];
            }
        }
    }

    protected void keyPressed(int keyCode) {
        if (keyCode == -7) {
            this.commandListener.commandAction(BSCanvas.DISPLAY_MENU, (Displayable)this);
            return;
        }
        if (!this.paused) {
            this.ControledKey(keyCode);
        }
    }

    private synchronized void ControledKey(int keyCode) {
        int oldX = this.UserX;
        int oldY = this.UserY;
        int action = this.getGameAction(keyCode);
        if (!this.Viewing) {
            if (keyCode == 49) {
                this.Viewing = true;
            }
        } else {
            if (action == 2 || keyCode == 52) {
                BSCanvas.playSound(this.sounds[3]);
                --this.UserDirection;
                if (this.UserDirection < 0) {
                    this.UserDirection = 3;
                }
            } else if (action == 1 || keyCode == 50) {
                BSCanvas.playSound(this.sounds[3]);
                ++this.Moves;
                ++this.TotalMoves;
                if (this.UserDirection == 0) {
                    --this.UserY;
                } else if (this.UserDirection == 1) {
                    ++this.UserX;
                } else if (this.UserDirection == 2) {
                    ++this.UserY;
                } else {
                    --this.UserX;
                }
            } else if (action == 5 || keyCode == 54) {
                BSCanvas.playSound(this.sounds[3]);
                ++this.UserDirection;
                if (this.UserDirection > 3) {
                    this.UserDirection = 0;
                }
            } else if (action == 6 || keyCode == 56) {
                BSCanvas.playSound(this.sounds[3]);
                ++this.Moves;
                ++this.TotalMoves;
                if (this.UserDirection == 0) {
                    ++this.UserY;
                } else if (this.UserDirection == 1) {
                    --this.UserX;
                } else if (this.UserDirection == 2) {
                    --this.UserY;
                } else {
                    ++this.UserX;
                }
            } else if (keyCode == 49) {
                this.Viewing = false;
            }
            if (this.board[this.UserY][this.UserX] == 1) {
                BSCanvas.vibrate(50, 1000);
                this.UserX = oldX;
                this.UserY = oldY;
            }
            this.LookAround();
        }
        if (this.TotalMoves >= 750) {
            this.UnifiedMethod(1);
        } else if (this.UserX == this.ExitX && this.UserY == this.ExitY) {
            this.UnifiedMethod(0);
        } else {
            this.UnifiedMethod(-1);
        }
    }

    public void loadGame(byte[] saveData, Gauge progress) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(saveData);
            DataInputStream in = new DataInputStream(is);
            this.Level = in.readInt();
            this.LoadLevel(progress);
            this.UserX = in.readInt();
            this.UserY = in.readInt();
            this.UserDirection = in.readInt();
            this.Moves = in.readInt();
            this.score = in.readInt();
            this.TotalMoves = in.readInt();
            this.LookAround();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte[] saveGame(Gauge progress) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(os);
            out.writeInt(this.Level);
            out.writeInt(this.UserX);
            out.writeInt(this.UserY);
            out.writeInt(this.UserDirection);
            out.writeInt(this.Moves);
            out.writeInt(this.score);
            out.writeInt(this.TotalMoves);
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void showNotify() {
    }

    protected void hideNotify() {
    }

    public void startGame(int diff, Gauge progress) {
        this.Level = 0;
        this.Moves = 0;
        this.score = 0;
        this.LoadLevel(progress);
        this.commandListener.commandAction(BSCanvas.DISPLAY_CANVAS, (Displayable)this);
    }

    public void nextLevel(Gauge progress) {
        ++this.Level;
        this.Moves = 0;
        this.LoadLevel(progress);
        this.commandListener.commandAction(BSCanvas.DISPLAY_CANVAS, (Displayable)this);
    }

    public synchronized void UnifiedMethod(int i) {
        Form form;
        if (i == -1) {
            this.repaint();
            this.serviceRepaints();
        }
        if (i == 0) {
            form = new Form(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.langT[1]))).append(this.Level + 1).append(this.langT[2]))));
            if (this.Level == 9) {
                BSCanvas.playSound(this.sounds[1]);
                this.score = this.GetScore(this.TotalMoves, 750);
                form.append(String.valueOf(String.valueOf(this.langT[4])).concat(".\n"));
                form.append(String.valueOf(String.valueOf(this.langT[5])).concat(String.valueOf(String.valueOf(this.score))));
            } else {
                BSCanvas.playSound(this.sounds[0]);
                form.append(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.langT[3]))).append(this.Moves).append("\n"))));
                form.append(String.valueOf(String.valueOf(this.langT[6])).concat(String.valueOf(String.valueOf(750 - this.TotalMoves))));
            }
            form.addCommand(this.OKCom);
            form.setCommandListener((CommandListener)this);
            this.display.setCurrent((Displayable)form);
        }
        if (i == 1) {
            BSCanvas.playSound(this.sounds[2]);
            form = new Form(String.valueOf(String.valueOf(this.langT[1])).concat(String.valueOf(String.valueOf(this.Level))));
            form.append(this.langT[8]);
            form.addCommand(this.OKCom);
            form.setCommandListener((CommandListener)this);
            this.display.setCurrent((Displayable)form);
        }
    }

    private int GetScore(int moves, int ps) {
        return ps * 20 / moves;
    }

    public void paint(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.Viewing) {
            int tl = this.TileSet[11].getWidth() * 5;
            int offset = (tl - this.getWidth()) / 2;
            for (int i = 0; i < 5; ++i) {
                g.drawImage(this.TileSet[11], i * this.TileSet[11].getWidth() - offset, this.HalfHeight, 2 | 4);
            }
            this.DrawFaceWall(g, 0);
            this.DrawExit(g, 0);
            this.DrawSideWalls(g, 0);
            this.DrawSideWalls(g, 1);
            this.DrawFaceWall(g, 1);
            this.DrawExit(g, 1);
            this.DrawSideWalls(g, 2);
            this.DrawFaceWall(g, 2);
            this.DrawSideWalls(g, 3);
            g.drawImage(this.Compass[this.UserDirection], 0, 0, 0x10 | 4);
            this.drawTextBL(g, String.valueOf(String.valueOf(this.langT[9])).concat(String.valueOf(String.valueOf(this.Moves))));
            g.setColor(0);
            g.fillRect(this.MiniStartX, 0, 15, 15);
            g.setColor(0xFFFFFF);
            int X = 0;
            int Y = 0;
            if (this.UserDirection == 0) {
                for (int y = this.UserY - 2; y < this.UserY + 3; ++y) {
                    X = 0;
                    for (int x = this.UserX - 2; x < this.UserX + 3; ++x) {
                        if (y > -1 && x > -1 && x < this.board[0].length && y < this.board.length && this.board[y][x] == 0) {
                            g.fillRect(this.MiniStartX + X * 3, Y * 3, 3, 3);
                        }
                        ++X;
                    }
                    ++Y;
                }
            } else if (this.UserDirection == 1) {
                for (int x = this.UserX + 2; x > this.UserX - 3; --x) {
                    X = 0;
                    for (int y = this.UserY - 2; y < this.UserY + 3; ++y) {
                        if (y > -1 && x > -1 && x < this.board[0].length && y < this.board.length && this.board[y][x] == 0) {
                            g.fillRect(this.MiniStartX + X * 3, Y * 3, 3, 3);
                        }
                        ++X;
                    }
                    ++Y;
                }
            } else if (this.UserDirection == 2) {
                for (int y = this.UserY + 2; y > this.UserY - 3; --y) {
                    X = 0;
                    for (int x = this.UserX + 2; x > this.UserX - 3; --x) {
                        if (y > -1 && x > -1 && x < this.board[0].length && y < this.board.length && this.board[y][x] == 0) {
                            g.fillRect(this.MiniStartX + X * 3, Y * 3, 3, 3);
                        }
                        ++X;
                    }
                    ++Y;
                }
            } else {
                for (int x = this.UserX - 2; x < this.UserX + 3; ++x) {
                    X = 0;
                    for (int y = this.UserY + 2; y > this.UserY - 3; --y) {
                        if (y > -1 && x > -1 && x < this.board[0].length && y < this.board.length && this.board[y][x] == 0) {
                            g.fillRect(this.MiniStartX + X * 3, Y * 3, 3, 3);
                        }
                        ++X;
                    }
                    ++Y;
                }
            }
        } else {
            int offsetx = this.UserX * 3;
            int offsety = this.UserY * 3;
            g.setColor(0xFFFFFF);
            for (int y = 0; y < this.AutoMap.length; ++y) {
                for (int x = 0; x < this.AutoMap[y].length; ++x) {
                    if (this.AutoMap[y][x] != 0) continue;
                    g.fillRect(x * 3 - offsetx + this.HalfWidth, y * 3 - offsety + this.HalfHeight, 3, 3);
                }
            }
            g.drawRect(this.ExitX * 3 - offsetx + this.HalfWidth, this.ExitY * 3 - offsety + this.HalfHeight, 3, 3);
        }
        if (this.paused) {
            this.drawText(g, this.langT[7], this.HalfWidth, this.HalfHeight);
        }
        g.drawImage(this.Options, this.getWidth(), this.getHeight(), 0x20 | 8);
    }

    public void drawText(Graphics g, String text, int centerX, int topY) {
        Font f = g.getFont();
        int Sw = f.stringWidth(text);
        int Sh = f.getHeight();
        g.setColor(0);
        g.fillRect(centerX - Sw / 2 - 2, topY - 1, Sw + 3, Sh + 1);
        g.setColor(0xFFFFFF);
        g.drawString(text, centerX, topY, 0x10 | 1);
    }

    public void drawTextBL(Graphics g, String text) {
        Font f = g.getFont();
        int Sw = f.stringWidth(text);
        int Sh = f.getHeight();
        g.setColor(0);
        g.fillRect(0, this.getHeight() - Sh, Sw, Sh);
        g.setColor(0xFFFFFF);
        g.drawString(text, 0, this.getHeight() - Sh + 1, 0x10 | 4);
    }

    private void DrawExit(Graphics g, int type) {
        int X = this.UserX + this.LookAhead[type + 7][this.UserDirection][0];
        int Y = this.UserY + this.LookAhead[type + 7][this.UserDirection][1];
        if (X == this.ExitX && Y == this.ExitY) {
            g.drawImage(this.Exits[type + 1], this.HalfWidth, this.HalfHeight, 2 | 1);
        }
    }

    private void DrawFaceWall(Graphics g, int type) {
        int wid = this.TileSet[type].getWidth();
        int len = 3;
        if (type == 0) {
            len = 5;
        }
        int offset = (this.getWidth() - wid * len) / 2;
        int X = this.UserX + this.LookAhead[type][this.UserDirection][0];
        int Y = this.UserY + this.LookAhead[type][this.UserDirection][1];
        byte modx = this.LookAhead[type][this.UserDirection][2];
        byte mody = this.LookAhead[type][this.UserDirection][3];
        for (int i = 0; i < len; ++i) {
            if (Y > -1 && X > -1 && X < this.board[0].length && Y < this.board.length && this.board[Y][X] == 1) {
                g.drawImage(this.TileSet[type], i * wid + offset, this.HalfHeight, 2 | 4);
            }
            Y += mody;
            X += modx;
        }
    }

    private void DrawSideWalls(Graphics g, int type) {
        int X = this.UserX + this.LookAhead[type + 3][this.UserDirection][0];
        int Y = this.UserY + this.LookAhead[type + 3][this.UserDirection][1];
        int t = 3 + type * 2;
        if (Y > -1 && X > -1 && X < this.board[0].length && Y < this.board.length && this.board[Y][X] == 1) {
            g.drawImage(this.TileSet[t], this.DrawCoords[type][0], this.HalfHeight, 2 | 4);
        }
        ++t;
        X = this.UserX + this.LookAhead[type + 3][this.UserDirection][2];
        Y = this.UserY + this.LookAhead[type + 3][this.UserDirection][3];
        if (Y > -1 && X > -1 && X < this.board[0].length && Y < this.board.length && this.board[Y][X] == 1) {
            g.drawImage(this.TileSet[t], this.DrawCoords[type][1], this.HalfHeight, 2 | 8);
        }
    }

    public void commandAction(Command c, Displayable s) {
        if (this.Level == 9 || this.TotalMoves >= 750) {
            this.commandListener.commandAction(BSCanvas.GAME_ENDED, (Displayable)this);
        } else {
            this.commandListener.commandAction(BSCanvas.LEVEL_ENDED, (Displayable)this);
        }
    }
}

