/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.sound.Sound;
import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import com.nokia.mid.ui.FullCanvas;
import javax.microedition.lcdui.Graphics;

public class Splash
extends FullCanvas {
    private Sprite splash = Setup.getSprite("splash_logo.kspr");
    private Sprite support;
    private Sprite introBack;
    private Sprite introLogo;
    private Sprite introChar;
    private int curFrame;
    private boolean splashScreenMode = true;
    private boolean initialized = false;
    private boolean running;
    private Sound sndIntro;

    public Splash() {
        this.splash.setPosition((128 - this.splash.width) / 2, (128 - this.splash.height) / 2);
        this.support = Setup.getSprite("support.kspr");
        this.support.setPosition((128 - this.support.width) / 2, (128 - this.support.height) / 2);
        this.splash.setVisible(true);
        this.support.setVisible(false);
        this.introBack = Setup.getSprite("intro_back.kspr");
        this.introLogo = Setup.getSprite("intro_logo.kspr");
        this.introLogo.setVisible(true);
        this.introChar = Setup.getSprite("intro_char.kspr");
        this.sndIntro = Setup.loadSound("/res/intro.snd");
        this.initialized = true;
    }

    public void paint(Graphics graphics) {
        if (!this.initialized) {
            return;
        }
        DirectGraphics directGraphics = DirectUtils.getDirectGraphics((Graphics)graphics);
        graphics.setClip(0, 0, 128, 128);
        if (this.splashScreenMode) {
            graphics.setColor(255, 135, 0);
            graphics.fillRect(0, 0, 128, 128);
            this.splash.paint(directGraphics);
            this.support.paint(directGraphics);
            return;
        }
        graphics.setColor(0, 129, 233);
        graphics.fillRect(0, 0, 128, 128);
        this.introBack.paint(directGraphics);
        this.introChar.paint(directGraphics);
        this.introLogo.paint(directGraphics);
        ++this.curFrame;
    }

    public void run() {
        this.splashScreenMode = true;
        this.repaint();
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {}
        this.splash.setVisible(false);
        this.support.setVisible(true);
        this.repaint();
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {}
        this.splashScreenMode = false;
        this.curFrame = 0;
        this.running = true;
        try {
            this.sndIntro.play(1);
        }
        catch (Exception exception) {}
        while (this.running) {
            try {
                Thread.sleep(20L);
            }
            catch (Exception exception) {}
            this.introLogo.setPosition((128 - this.introLogo.getWidth()) / 2, -this.introLogo.height * 3 + this.curFrame);
            if (this.introLogo.getPositionY() > 4) {
                this.introLogo.setPosition((128 - this.introLogo.getWidth()) / 2, 4);
            }
            this.introBack.setPosition(128 - this.introBack.getWidth() - 2, 128 - this.curFrame / 2);
            if (this.introBack.getPositionY() < 128 - this.introBack.getHeight()) {
                this.introBack.setPosition(128 - this.introBack.getWidth() - 2, 128 - this.introBack.getHeight());
            }
            this.introChar.setPosition(0, 173 - this.curFrame);
            if (this.introChar.getPositionY() < 128 - this.introChar.getHeight()) {
                this.introChar.setPosition(0, 128 - this.introChar.getHeight());
            }
            if (this.curFrame > 250) {
                this.running = false;
            }
            this.repaint();
            this.serviceRepaints();
        }
    }

    public void keyPressed(int n) {
        if (!this.splashScreenMode) {
            this.running = false;
            this.sndIntro.stop();
        }
    }

    public void destroy() {
        this.splash = null;
        this.support = null;
        this.introBack = null;
        this.introLogo = null;
        this.introChar = null;
    }
}

