/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class PNGList {
    public static final int MAX_PIC = 36;
    private static final String ImagePath = "/images/";
    private static Image[] source = new Image[36];
    private static String[] strName = new String[36];

    public PNGList() {
        int n = 0;
        while (n < 36) {
            PNGList.strName[n] = "";
            ++n;
        }
    }

    public void loadPNG(String string) {
        if (this.findKey(string) >= 0) {
            return;
        }
        int n = this.findSpace();
        String string2 = ImagePath + string + ".png";
        try {
            PNGList.source[n] = Image.createImage((String)string2);
            PNGList.strName[n] = string;
        }
        catch (Exception exception) {
            System.out.println("Ooops .. Error reading file " + string);
        }
    }

    public static void drawPNGImageRaw(String string, Graphics graphics, int n, int n2) {
        String string2 = ImagePath + string + ".png";
        try {
            Image image = Image.createImage((String)string2);
            graphics.drawImage(image, n, n2, 20);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void drawPNGImage(String string, Graphics graphics, int n, int n2) {
        int n3 = this.findKey(string);
        if (n3 >= 0) {
            graphics.drawImage(source[n3], n, n2, 20);
        } else {
            System.out.println("Ooops .. Error reading file " + string);
        }
    }

    public Image getImage(String string) {
        int n = this.findKey(string);
        if (n >= 0) {
            return source[n];
        }
        return null;
    }

    public int findKey(String string) {
        int n = 0;
        while (n < 36) {
            if (string.compareTo(strName[n]) == 0) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int findSpace() {
        int n = 0;
        while (n < 36) {
            if (strName[n].compareTo("") == 0) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void remove(String string) {
        int n = this.findKey(string);
        if (n == -1) {
            return;
        }
        PNGList.strName[n] = "";
        PNGList.source[n] = null;
    }

    public void drawSmallString(Graphics graphics, int n, int n2, String string) {
        int n3 = 0;
        while (n3 < string.length()) {
            char c = string.charAt(n3);
            if (c >= '0' && c <= 'Z') {
                int n4 = c - 48;
                graphics.setClip(n + 5 * n3, n2, 5, 7);
                this.drawPNGImage("0toz", graphics, n + 5 * n3 - n4 * 5, n2);
            }
            ++n3;
        }
    }
}

