/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.DeviceControl;
import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import com.nokia.mid.ui.FullCanvas;
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameCanvas
extends FullCanvas {
    GameMain gameMain;
    Random random = new Random();
    Graphics gx;
    Image gun1;
    Image gun2;
    Image gun3;
    Image shadow;
    Image sun;
    Image tombstone;
    DirectGraphics dg;
    DeviceControl dc;
    public final NokiaGameEffects gameEffects;
    static short GAME_INI = 0;
    static short GAME_READY = 1;
    static short GAME_NUMBER = (short)2;
    static short GAME_FAIL = (short)3;
    static short GAME_SHOW = (short)4;
    static short GAME_SUC = (short)5;
    static short GAME_OVER = (short)7;
    static short GAME_PLAY = (short)8;
    boolean oneTimeFlag;
    boolean[][] bAKiller;
    boolean[][] bAMap;
    boolean bMove;
    boolean bPaint;
    boolean bTarget;
    boolean bMap;
    boolean bBullet;
    int nTarget;
    int nX;
    int nY;
    int nTX;
    int nTY;
    int nGame;
    int nLevel;
    int nWindow;
    int nKiller;
    int nChar;
    int nChoose;
    int nTime;
    int nScore;
    int nGun;
    int nShoot;
    int nBullet;
    int nPlus;

    public GameCanvas(GameMain gameMain) {
        this.gameMain = gameMain;
        this.oneTimeFlag = true;
        this.nTX = 23;
        this.nTY = 96;
        this.gameEffects = new NokiaGameEffects(this.gameMain);
        try {
            this.gun1 = Image.createImage((String)"/img/gun_hk.png");
            this.gun2 = Image.createImage((String)"/img/gun_psg.png");
            this.gun3 = Image.createImage((String)"/img/gun_us.png");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void showNotify() {
    }

    protected void keyPressed(int n) {
        if (this.nGame == GAME_INI) {
            if (n == -1 || n == 50) {
                this.nLevel = this.nLevel == 0 ? 3 : --this.nLevel;
            } else if (n == -2 || n == 56) {
                this.nLevel = this.nLevel == 3 ? 0 : ++this.nLevel;
            } else if (n == -3 || n == 52) {
                this.nGun = this.nGun == 0 ? 2 : --this.nGun;
            } else if (n == -4 || n == 54) {
                this.nGun = this.nGun == 2 ? 0 : ++this.nGun;
            } else if (n == 53) {
                this.gameMain.gameTimer.count = 0;
                if (this.nLevel == 0) {
                    this.nTime = 90;
                    this.nWindow = 5;
                } else if (this.nLevel == 1) {
                    this.nTime = 90;
                    this.nWindow = 5;
                } else if (this.nLevel == 2) {
                    this.nTime = 150;
                    this.nWindow = 7;
                } else if (this.nLevel == 3) {
                    this.nTime = 210;
                    this.nWindow = 9;
                }
                if (this.nLevel == 0) {
                    this.nKiller = 1;
                    this.nY = 2;
                    this.nX = 2;
                    this.bAMap = new boolean[5][5];
                    this.bAKiller = new boolean[5][5];
                } else {
                    this.nKiller = this.nWindow;
                    this.nX = this.nY = this.nWindow / 2;
                    this.bAMap = new boolean[this.nWindow][this.nWindow];
                    this.bAKiller = new boolean[this.nWindow][this.nWindow];
                }
                if (this.nGun == 0) {
                    this.nPlus = 4;
                    this.nBullet = 10;
                } else if (this.nGun == 1) {
                    this.nPlus = 3;
                    this.nBullet = 20;
                } else if (this.nGun == 2) {
                    this.nPlus = 6;
                    this.nBullet = 5;
                }
                this.gun3 = null;
                this.gun2 = null;
                this.gun1 = null;
                this.gameMain.gameImg.load();
                this.setKiller();
                this.nGame = GAME_SHOW;
            }
            this.repaint();
        } else if (this.nGame == GAME_PLAY) {
            if (n == 50 || n == -1) {
                this.gameEffects.eachSound(4);
                if (this.bAMap[this.nX][this.nY] && this.bAKiller[this.nX][this.nY]) {
                    this.setOneKiller();
                }
                if (this.nY > 0) {
                    this.bMove = true;
                    --this.nY;
                }
                this.nShoot = 0;
                this.nTY = 96;
                this.nTX = 23;
            } else if (n == 56 || n == -2) {
                this.gameEffects.eachSound(4);
                if (this.bAMap[this.nX][this.nY] && this.bAKiller[this.nX][this.nY]) {
                    this.setOneKiller();
                }
                if (this.nY < this.nWindow - 1) {
                    this.bMove = true;
                    ++this.nY;
                }
                this.nShoot = 0;
                this.nTY = 96;
                this.nTX = 23;
            } else if (n == 52 || n == -3) {
                this.gameEffects.eachSound(4);
                if (this.bAMap[this.nX][this.nY] && this.bAKiller[this.nX][this.nY]) {
                    this.setOneKiller();
                }
                if (this.nX > 0) {
                    this.bMove = true;
                    --this.nX;
                }
                this.nShoot = 0;
                this.nTY = 96;
                this.nTX = 23;
            } else if (n == 54 || n == -4) {
                this.gameEffects.eachSound(4);
                if (this.bAMap[this.nX][this.nY] && this.bAKiller[this.nX][this.nY]) {
                    this.setOneKiller();
                }
                if (this.nX < this.nWindow - 1) {
                    this.bMove = true;
                    ++this.nX;
                }
                this.nShoot = 0;
                this.nTY = 96;
                this.nTX = 23;
            } else if (n == 48 && !this.bAMap[this.nX][this.nY]) {
                this.bAMap[this.nX][this.nY] = true;
                this.gameMain.gameTimer.count = 0;
                this.gameEffects.eachSound(12);
                if (this.bAKiller[this.nX][this.nY]) {
                    this.nTarget = this.random.nextInt() % 3;
                    if (this.nTarget < 0) {
                        this.nTarget = -this.nTarget;
                    }
                    this.nChar = this.random.nextInt() % 3;
                    if (this.nChar < 0) {
                        this.nChar = -this.nChar;
                    }
                } else if (this.random.nextInt() % 2 == 0) {
                    this.nTarget = this.random.nextInt() % 3;
                    if (this.nTarget < 0) {
                        this.nTarget = -this.nTarget;
                    }
                    this.nChar = this.random.nextInt() % 3;
                    if (this.nChar < 0) {
                        this.nChar = -this.nChar;
                    }
                    this.nChar += 3;
                    if (this.random.nextInt() % 2 == 0) {
                        this.bBullet = true;
                    }
                }
            } else if (n == 53) {
                if (this.nShoot == 0) {
                    this.nShoot = 1;
                } else if (this.nShoot == 1 && this.bAMap[this.nX][this.nY]) {
                    this.gameEffects.eachSound(1);
                    if (this.bAKiller[this.nX][this.nY]) {
                        if ((58 - this.nTY) * (58 - this.nTY) + (34 + this.nTarget * 30 - this.nTX) * (34 + this.nTarget * 30 - this.nTX) <= 64) {
                            this.bTarget = true;
                            this.nShoot = 2;
                        } else {
                            this.nShoot = 0;
                            this.nTY = 96;
                            this.nTX = 23;
                        }
                    } else if (this.bBullet && this.nTY < 89 && this.nTY > 71 && this.nTX > 26 + this.nTarget * 30 && this.nTX < 42 + this.nTarget * 30) {
                        this.nBullet += 5;
                        this.bTarget = true;
                    } else if (this.nTY < 95 && this.nTY > 35 && this.nTX > 11 + this.nTarget * 30 && this.nTX < 49 + this.nTarget * 30) {
                        this.bBullet = false;
                        this.bTarget = true;
                    }
                    --this.nBullet;
                }
            }
            this.repaint();
            if (n == -7) {
                this.gameMain.gameFlag = this.gameMain.gameFlag == 4 ? 0 : 4;
                this.repaint();
            } else if (n == -6 && this.gameMain.gameFlag != 4) {
                this.gameMain.resumeFlag = true;
                this.gameMain.gameFlag = 2;
                if (this.gameMain.titleCanvas == null) {
                    this.gameMain.titleCanvas = new TitleCanvas(this.gameMain);
                }
                this.gameMain.display.setCurrent((Displayable)this.gameMain.titleCanvas.menuList);
            }
        } else if (this.nGame == GAME_SUC || this.nGame == GAME_FAIL) {
            if (n == 53) {
                if (this.nGame == GAME_SUC) {
                    this.nScore += this.nTime * this.nWindow;
                }
                this.gameMain.totalScore = this.nScore;
                if (this.gameMain.scoreBoard == null) {
                    this.gameMain.scoreBoard = new ScoreBoard(this.gameMain);
                }
                this.gameMain.scoreBoard.rank = this.gameMain.rank = this.gameMain.scoreCal();
                this.nScore = 0;
                this.gameMain.gameTimer.cancel();
                this.gameMain.gameTimer = null;
                this.gameMain.gameImg = null;
                this.gameMain.gameCanvas = null;
                this.gameMain.resumeFlag = false;
                this.gameMain.gameFlag = 2;
                this.gameMain.display.setCurrent((Displayable)this.gameMain.scoreBoard);
            }
            this.repaint();
        }
        if (n == 42) {
            this.bMap = !this.bMap;
        }
    }

    public void paint(Graphics graphics) {
        this.bPaint = false;
        if (this.oneTimeFlag) {
            this.gx = graphics;
            this.oneTimeFlag = false;
            this.dg = DirectUtils.getDirectGraphics((Graphics)graphics);
        }
        if (this.gameMain.gameFlag == 4) {
            this.gx.setColor(249, 185, 15);
            this.gx.fillRect(44, 45, 40, 20);
            this.gx.setFont(Font.getFont((int)0, (int)0, (int)8));
            this.gx.setColor(30, 30, 200);
            this.gx.drawString("PAUSE", 64, 50, 0x10 | 1);
        } else {
            this.gx.setFont(Font.getFont((int)0, (int)0, (int)8));
            if (this.nGame == GAME_INI) {
                this.drawIni();
            } else if (this.nGame == GAME_SHOW) {
                this.drawShow();
            } else if (this.nGame == GAME_READY) {
                this.drawBG();
                this.drawWindow();
                this.drawReady();
                this.drawClock();
            } else if (this.nGame == GAME_PLAY) {
                this.drawBG();
                if (!this.bMove) {
                    this.drawWindow();
                    if (!this.bAMap[this.nX][this.nY] || !this.bAKiller[this.nX][this.nY] && this.nChar < 3) {
                        this.drawTarget();
                    }
                } else {
                    this.nChar = 0;
                }
                if (this.bTarget) {
                    this.drawHole();
                }
                this.drawClock();
                if (this.bMap) {
                    this.drawMap();
                }
            } else if (this.nGame == GAME_SUC || this.nGame == GAME_FAIL) {
                this.drawEnd();
            } else if (this.nGame == GAME_OVER) {
                this.drawBG();
                this.drawWindow();
                if (this.bTarget) {
                    this.drawHole();
                }
                this.drawClock();
                this.gx.drawImage(this.gameMain.gameImg.bang, 64, 50, 1 | 0x10);
                this.gx.setColor(255, 0, 0);
                this.gx.drawString("Oh No!", 54, 70, 1 | 0x10);
                if (this.bMap) {
                    this.drawMap();
                }
            }
            this.bPaint = true;
            this.bMove = false;
        }
    }

    private void drawIni() {
        int n = 0;
        while (n < 17) {
            int n2 = 0;
            while (n2 < 16) {
                this.gx.drawImage(this.gameMain.gameImg.bg_1, n * 8, n2 * 8, 4 | 0x10);
                ++n2;
            }
            ++n;
        }
        this.gx.setColor(255, 160, 0);
        this.gx.fillRect(25, 36, 79, 63);
        this.gx.setColor(122, 122, 255);
        this.gx.fillRect(10, 1, 100, 30);
        this.gx.drawImage(this.gameMain.gameImg.arrow_1, 51, 21, 4 | 0x10);
        this.dg.drawImage(this.gameMain.gameImg.arrow_1, 41, 21, 4 | 0x10, 8192);
        this.gx.setColor(255, 255, 254);
        this.gx.fillRect(24, 104, 80, 10);
        this.gx.setColor(0);
        this.gx.drawString("Press 5 to start", 64, 105, 1 | 0x10);
        this.gx.fillRect(37, 43, 57, 10);
        this.gx.fillRect(37, 56, 57, 10);
        this.gx.fillRect(37, 69, 57, 10);
        this.gx.fillRect(37, 82, 57, 10);
        this.gx.setColor(192, 192, 192);
        this.gx.drawRect(37, 42, 56, 11);
        this.gx.drawRect(37, 55, 56, 11);
        this.gx.drawRect(37, 68, 56, 11);
        this.gx.drawRect(37, 81, 56, 11);
        this.gx.setColor(254, 255, 255);
        this.gx.drawString("Exercise", 40, 44, 4 | 0x10);
        this.gx.drawString("Easy", 40, 57, 4 | 0x10);
        this.gx.drawString("Normal", 40, 70, 4 | 0x10);
        this.gx.drawString("Hard", 40, 83, 4 | 0x10);
        this.gx.setColor(255, 0, 0);
        switch (this.nLevel) {
            case 0: {
                this.gx.drawRect(37, 42, 56, 11);
                break;
            }
            case 1: {
                this.gx.drawRect(37, 55, 56, 11);
                break;
            }
            case 2: {
                this.gx.drawRect(37, 68, 56, 11);
                break;
            }
            case 3: {
                this.gx.drawRect(37, 81, 56, 11);
            }
        }
        switch (this.nGun) {
            case 0: {
                this.gx.drawImage(this.gun1, 60, 2, 1 | 0x10);
                break;
            }
            case 1: {
                this.gx.drawImage(this.gun2, 60, 2, 1 | 0x10);
                break;
            }
            case 2: {
                this.gx.drawImage(this.gun3, 60, 2, 1 | 0x10);
            }
        }
    }

    private void drawShow() {
        int n = 0;
        while (n < 17) {
            int n2 = 0;
            while (n2 < 16) {
                this.gx.drawImage(this.gameMain.gameImg.bg_1, n * 8, n2 * 8, 4 | 0x10);
                ++n2;
            }
            ++n;
        }
        this.gx.drawImage(this.gameMain.gameImg.baby, 42, 10, 1 | 0x10);
        this.gx.drawImage(this.gameMain.gameImg.grandma, 84, 10, 1 | 0x10);
        this.gx.setColor(254, 255, 255);
        this.gx.fillRect(18, 80, 92, 20);
        this.gx.setColor(0);
        this.gx.drawString("DON'T SHOOT!", 64, 85, 1 | 0x10);
        this.gx.drawRect(18, 80, 92, 20);
    }

    private void drawBG() {
        this.gx.setColor(254, 255, 255);
        this.gx.drawLine(0, 111, 0, 128);
        this.gx.drawLine(0, 111, 128, 111);
        this.gx.setColor(128, 192, 255);
        this.gx.fillRect(1, 112, 126, 15);
        this.gx.setColor(0, 128, 255);
        this.gx.drawLine(0, 128, 128, 128);
        this.gx.drawLine(128, 111, 128, 128);
        this.gx.drawImage(this.gameMain.gameImg.map, 4, 114, 4 | 0x10);
        this.gx.drawImage(this.gameMain.gameImg.clock_1, 32, 113, 4 | 0x10);
        this.gx.drawImage(this.gameMain.gameImg.enemy_1, 76, 114, 4 | 0x10);
        this.gx.drawImage(this.gameMain.gameImg.bg_2, 0, 0, 4 | 0x10);
        this.gx.drawImage(this.gameMain.gameImg.bullet_2, 2, 2, 4 | 0x10);
        this.gx.drawImage(this.gameMain.gameImg.no[this.nBullet / 10], 15, 2, 4 | 0x10);
        this.gx.drawImage(this.gameMain.gameImg.no[this.nBullet % 10], 23, 2, 4 | 0x10);
    }

    private void drawWindow() {
        this.gx.setColor(254, 255, 255);
        this.gx.fillRect(23, 30, 82, 67);
        if (this.bAMap[this.nX][this.nY]) {
            if (this.bAKiller[this.nX][this.nY]) {
                if (this.nChar == 0) {
                    this.gx.drawImage(this.gameMain.gameImg.girl, 34 + this.nTarget * 30, 35, 1 | 0x10);
                } else if (this.nChar == 1) {
                    this.gx.drawImage(this.gameMain.gameImg.killer_1, 34 + this.nTarget * 30, 35, 1 | 0x10);
                } else if (this.nChar == 2) {
                    this.gx.drawImage(this.gameMain.gameImg.killer_2, 34 + this.nTarget * 30, 35, 1 | 0x10);
                }
                if (this.gameMain.gameTimer.count % 4 == 0) {
                    this.gx.drawImage(this.gameMain.gameImg.target[0], 34 + this.nTarget * 30, 50, 1 | 0x10);
                } else if (this.gameMain.gameTimer.count % 4 == 1) {
                    this.gx.drawImage(this.gameMain.gameImg.target[1], 34 + this.nTarget * 30, 50, 1 | 0x10);
                } else if (this.gameMain.gameTimer.count % 4 == 2) {
                    this.gx.drawImage(this.gameMain.gameImg.target[2], 34 + this.nTarget * 30, 50, 1 | 0x10);
                } else if (this.gameMain.gameTimer.count % 4 == 3) {
                    this.gx.drawImage(this.gameMain.gameImg.target[3], 34 + this.nTarget * 30, 50, 1 | 0x10);
                }
            } else if (this.nChar == 3) {
                this.gx.drawImage(this.gameMain.gameImg.baby, 34 + this.nTarget * 30, 35, 1 | 0x10);
            } else if (this.nChar == 4) {
                this.gx.drawImage(this.gameMain.gameImg.grandma, 34 + this.nTarget * 30, 35, 1 | 0x10);
            } else if (this.nChar == 5) {
                this.gx.drawImage(this.gameMain.gameImg.baby, 34 + this.nTarget * 30, 35, 1 | 0x10);
            } else {
                this.gx.setColor(10, 255, 10);
                this.gx.drawString("Empty", 64, 50, 1 | 0x10);
            }
        }
        this.gx.drawImage(this.gameMain.gameImg.bg_3, 0, 0, 4 | 0x10);
        if (this.bAMap[this.nX][this.nY]) {
            if (this.bAKiller[this.nX][this.nY]) {
                this.gx.setColor(0);
                if (this.nShoot == 0) {
                    if ((this.nTY -= this.nPlus) <= 23) {
                        this.nTY = 96;
                    }
                    this.gx.drawLine(0, this.nTY, 120, this.nTY);
                } else if (this.nShoot == 1) {
                    if ((this.nTX += this.nPlus) >= 105) {
                        this.nTX = 23;
                    }
                    this.gx.drawLine(0, this.nTY, 120, this.nTY);
                    this.gx.drawLine(this.nTX, 0, this.nTX, 110);
                }
            } else if (this.nChar == 3 || this.nChar == 4 || this.nChar == 5) {
                if (this.bBullet) {
                    this.gx.drawImage(this.gameMain.gameImg.bullet_1, 34 + this.nTarget * 30, 80, 1 | 2);
                }
                this.gx.setColor(0);
                if (this.nShoot == 0) {
                    if ((this.nTY -= this.nPlus) <= 13) {
                        this.nTY = 96;
                    }
                    this.gx.drawLine(0, this.nTY, 120, this.nTY);
                } else if (this.nShoot == 1) {
                    if ((this.nTX += this.nPlus) >= 105) {
                        this.nTX = 23;
                    }
                    this.gx.drawLine(0, this.nTY, 120, this.nTY);
                    this.gx.drawLine(this.nTX, 0, this.nTX, 110);
                }
            }
        }
        this.gx.drawImage(this.gameMain.gameImg.bullet_2, 2, 2, 4 | 0x10);
        this.gx.drawImage(this.gameMain.gameImg.no[this.nBullet / 10], 15, 2, 4 | 0x10);
        this.gx.drawImage(this.gameMain.gameImg.no[this.nBullet % 10], 23, 2, 4 | 0x10);
        if (this.bAMap[this.nX][this.nY] && this.bAKiller[this.nX][this.nY] && this.nGame != GAME_OVER) {
            this.gx.setColor(50 + this.gameMain.gameTimer.count * 4, 0, 200 - this.gameMain.gameTimer.count * 4);
            if (this.nChar == 0) {
                this.gx.fillRect(120, 2, 6, 41 - this.gameMain.gameTimer.count);
            } else if (this.nChar == 1) {
                this.gx.fillRect(120, 2, 6, 31 - this.gameMain.gameTimer.count);
            } else if (this.nChar == 2) {
                this.gx.fillRect(120, 2, 6, 51 - this.gameMain.gameTimer.count);
            }
        }
    }

    private void drawReady() {
        this.gx.setColor(10, 255, 10);
        this.gx.drawString("Ready", 64, 50, 1 | 0x10);
    }

    private void setKiller() {
        int n = 0;
        if (this.nLevel == 0) {
            n = this.random.nextInt() % 25;
            if (n < 0) {
                n = -n;
            }
            this.bAKiller[n / 5][n % 5] = true;
        } else {
            int n2 = 0;
            while (n2 < this.nWindow) {
                int n3 = this.random.nextInt() % (this.nWindow * this.nWindow);
                if (n3 < 0) {
                    n3 = -n3;
                }
                if (this.bAKiller[n3 / this.nWindow][n3 % this.nWindow]) continue;
                n = n3;
                ++n2;
                this.bAKiller[n / this.nWindow][n % this.nWindow] = true;
            }
        }
    }

    private void setOneKiller() {
        int n;
        this.bAKiller[this.nX][this.nY] = false;
        do {
            if ((n = this.random.nextInt() % (this.nWindow * this.nWindow)) >= 0) continue;
            n = -n;
        } while (this.bAKiller[n / this.nWindow][n % this.nWindow] || this.bAMap[n / this.nWindow][n % this.nWindow]);
        this.bAKiller[n / this.nWindow][n % this.nWindow] = true;
    }

    private void drawTarget() {
        int n;
        int n2;
        int n3 = 0;
        this.gx.setColor(0);
        this.gx.drawLine(23, 56, 55, 56);
        this.gx.drawLine(64, 15, 64, 48);
        this.gx.drawLine(73, 56, 105, 56);
        this.gx.drawLine(64, 66, 64, 97);
        if (this.nX == 0) {
            this.dg.drawImage(this.gameMain.gameImg.arrow_2, 14, 52, 4 | 0x10, 180);
            this.gx.drawImage(this.gameMain.gameImg.no[0], 34, 52, 4 | 0x10);
        } else {
            this.dg.drawImage(this.gameMain.gameImg.arrow_1, 14, 52, 4 | 0x10, 180);
            n2 = 0;
            while (n2 < this.nWindow) {
                n = 0;
                while (n < this.nX) {
                    if (this.bAKiller[n][n2]) {
                        ++n3;
                    }
                    ++n;
                }
                ++n2;
            }
            this.gx.drawImage(this.gameMain.gameImg.no[n3], 34, 52, 4 | 0x10);
            n3 = 0;
        }
        if (this.nX == this.nWindow - 1) {
            this.gx.drawImage(this.gameMain.gameImg.arrow_2, 106, 51, 4 | 0x10);
            this.gx.drawImage(this.gameMain.gameImg.no[0], 96, 52, 4 | 0x10);
        } else {
            this.gx.drawImage(this.gameMain.gameImg.arrow_1, 106, 51, 4 | 0x10);
            n2 = 0;
            while (n2 < this.nWindow) {
                n = this.nWindow - 1;
                while (n > this.nX) {
                    if (this.bAKiller[n][n2]) {
                        ++n3;
                    }
                    --n;
                }
                ++n2;
            }
            this.gx.drawImage(this.gameMain.gameImg.no[n3], 96, 52, 4 | 0x10);
            n3 = 0;
        }
        if (this.nY == 0) {
            this.dg.drawImage(this.gameMain.gameImg.arrow_2, 60, 5, 4 | 0x10, 90);
            this.gx.drawImage(this.gameMain.gameImg.no[0], 65, 15, 4 | 0x10);
        } else {
            this.dg.drawImage(this.gameMain.gameImg.arrow_1, 60, 5, 4 | 0x10, 90);
            n2 = 0;
            while (n2 < this.nWindow) {
                n = 0;
                while (n < this.nY) {
                    if (this.bAKiller[n2][n]) {
                        ++n3;
                    }
                    ++n;
                }
                ++n2;
            }
            this.gx.drawImage(this.gameMain.gameImg.no[n3], 65, 15, 4 | 0x10);
            n3 = 0;
        }
        if (this.nY == this.nWindow - 1) {
            this.dg.drawImage(this.gameMain.gameImg.arrow_2, 61, 97, 4 | 0x10, 270);
            this.gx.drawImage(this.gameMain.gameImg.no[0], 65, 85, 4 | 0x10);
        } else {
            this.dg.drawImage(this.gameMain.gameImg.arrow_1, 61, 97, 4 | 0x10, 270);
            n2 = 0;
            while (n2 < this.nWindow) {
                n = this.nWindow - 1;
                while (n > this.nY) {
                    if (this.bAKiller[n2][n]) {
                        ++n3;
                    }
                    --n;
                }
                ++n2;
            }
            this.gx.drawImage(this.gameMain.gameImg.no[n3], 65, 85, 4 | 0x10);
        }
        this.gx.drawImage(this.gameMain.gameImg.no[0], 24, 52, 4 | 0x10);
        this.gx.drawImage(this.gameMain.gameImg.no[0], 86, 52, 4 | 0x10);
        this.gx.drawImage(this.gameMain.gameImg.no[0], 55, 15, 4 | 0x10);
        this.gx.drawImage(this.gameMain.gameImg.no[0], 55, 85, 4 | 0x10);
    }

    private void drawHole() {
        if (this.bAKiller[this.nX][this.nY]) {
            this.bAKiller[this.nX][this.nY] = false;
            --this.nKiller;
            this.bTarget = false;
            this.gx.drawImage(this.gameMain.gameImg.hole, this.nTX, this.nTY, 1 | 2);
            this.gx.setColor(0, 0, 255);
            this.gx.drawString("Nice", 64, 50, 1 | 0x10);
            if (this.nChar == 0) {
                this.nScore += 15;
            } else if (this.nChar == 1) {
                this.nScore += 20;
            } else if (this.nChar == 2) {
                this.nScore += 10;
            }
            if (this.nKiller <= 0) {
                this.load3();
                this.nGame = GAME_SUC;
                this.gameEffects.eachSound(6);
            }
            this.nTY = 96;
            this.nTX = 23;
        } else {
            if (this.bBullet) {
                this.bBullet = false;
                this.gx.drawImage(this.gameMain.gameImg.hole, this.nTX, this.nTY, 1 | 2);
                this.nTY = 96;
                this.nTX = 23;
            } else {
                this.gx.drawImage(this.gameMain.gameImg.hole, this.nTX, this.nTY, 1 | 2);
                this.nGame = GAME_OVER;
                this.gameEffects.eachSound(8);
            }
            this.bTarget = false;
        }
        this.nShoot = 0;
    }

    private void drawEnd() {
        this.gx.setColor(153, 0, 0);
        this.gx.fillRect(0, 0, 128, 4);
        this.gx.fillRect(0, 86, 128, 31);
        this.gx.setColor(204, 102, 0);
        this.gx.fillRect(0, 4, 128, 16);
        this.gx.setColor(255, 102, 0);
        this.gx.fillRect(0, 19, 128, 33);
        this.gx.setColor(255, 153, 0);
        this.gx.fillRect(0, 52, 128, 15);
        this.gx.fillRect(0, 79, 128, 7);
        this.gx.setColor(255, 204, 0);
        this.gx.fillRect(0, 67, 128, 12);
        this.gx.setColor(98, 3, 3);
        this.gx.fillRect(0, 117, 128, 11);
        this.gx.drawImage(this.sun, 64, 16, 1 | 0x10);
        if (this.nGame == GAME_SUC) {
            this.gx.drawImage(this.shadow, 64, 30, 1 | 0x10);
            this.gx.setColor(0);
            this.gx.drawString("Mission", 64, 5, 1 | 0x10);
            this.gx.drawString("clear", 64, 15, 1 | 0x10);
        } else {
            this.gx.drawImage(this.tombstone, 64, 30, 1 | 0x10);
            this.gx.setColor(0);
            this.gx.drawString("You", 64, 5, 1 | 0x10);
            this.gx.drawString("failed", 64, 15, 1 | 0x10);
        }
    }

    public void drawClock() {
        this.gx.drawImage(this.gameMain.gameImg.no[this.nTime / 60], 47, 114, 4 | 0x10);
        this.gx.drawImage(this.gameMain.gameImg.num_0, 56, 116, 4 | 0x10);
        this.gx.drawImage(this.gameMain.gameImg.no[this.nTime % 60 / 10], 58, 114, 4 | 0x10);
        this.gx.drawImage(this.gameMain.gameImg.no[this.nTime % 60 % 10], 67, 114, 4 | 0x10);
        this.gx.drawImage(this.gameMain.gameImg.no[0], 106, 114, 4 | 0x10);
        this.gx.drawImage(this.gameMain.gameImg.no[this.nKiller], 115, 114, 4 | 0x10);
    }

    private void drawMap() {
        this.gx.setColor(254, 255, 255);
        this.gx.drawLine(0, 79, 0, 110);
        this.gx.drawLine(0, 79, 30, 79);
        this.gx.setColor(128, 64, 128);
        this.gx.drawLine(31, 79, 31, 110);
        this.gx.drawLine(1, 110, 31, 110);
        this.gx.setColor(192, 160, 192);
        this.gx.drawRect(1, 80, 30, 30);
        this.gx.setColor(128, 192, 255);
        this.gx.fillRect(2, 81, 29, 29);
        if (this.nLevel == 0 || this.nLevel == 1) {
            int n = 0;
            while (n < 5) {
                int n2 = 0;
                while (n2 < 5) {
                    if (this.bAMap[n][n2]) {
                        this.gx.setColor(255, 0, 0);
                    } else {
                        this.gx.setColor(0);
                    }
                    this.gx.fillRect(9 + n * 3, 88 + n2 * 3, 2, 2);
                    ++n2;
                }
                ++n;
            }
            this.gx.setColor(254, 255, 255);
            this.gx.fillRect(9 + this.nX * 3, 88 + this.nY * 3, 2, 2);
        } else if (this.nLevel == 2) {
            int n = 0;
            while (n < 7) {
                int n3 = 0;
                while (n3 < 7) {
                    if (this.bAMap[n][n3]) {
                        this.gx.setColor(255, 0, 0);
                    } else {
                        this.gx.setColor(0);
                    }
                    this.gx.fillRect(6 + n * 3, 85 + n3 * 3, 2, 2);
                    ++n3;
                }
                ++n;
            }
            this.gx.setColor(254, 255, 255);
            this.gx.fillRect(6 + this.nX * 3, 85 + this.nY * 3, 2, 2);
        } else if (this.nLevel == 3) {
            int n = 0;
            while (n < 9) {
                int n4 = 0;
                while (n4 < 9) {
                    if (this.bAMap[n][n4]) {
                        this.gx.setColor(255, 0, 0);
                    } else {
                        this.gx.setColor(0);
                    }
                    this.gx.fillRect(3 + n * 3, 82 + n4 * 3, 2, 2);
                    ++n4;
                }
                ++n;
            }
            this.gx.setColor(254, 255, 255);
            this.gx.fillRect(3 + this.nX * 3, 82 + this.nY * 3, 2, 2);
        }
    }

    public void load3() {
        try {
            this.shadow = Image.createImage((String)"/img/shadow.png");
            this.sun = Image.createImage((String)"/img/sun.png");
            this.tombstone = Image.createImage((String)"/img/tombstone.png");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

