/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Timer;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class GameMain {
    public static final short START = 0;
    public static final short EXIT = 1;
    public static final short MENUVIEW = 2;
    public static final short INIT = 3;
    public static final short PAUSE = 4;
    private final NokiaGameEffects gameEffects;
    Display display;
    RecordStore rec;
    GameMIDlet midlet;
    GameImageLoader gameImg;
    TitleCanvas titleCanvas;
    GameTimer gameTimer;
    GameCanvas gameCanvas;
    ScoreBoard scoreBoard;
    Loading loading;
    Timer timer;
    int[] stageScoreBoard;
    int gameFlag;
    int totalScore;
    int firstScore;
    int secondScore;
    int thirdScore;
    int fourthScore;
    int fifthScore;
    int loadingCount;
    int screenSize;
    boolean soundFlag;
    boolean resumeFlag;
    int rank;

    public GameMain(Display display, GameMIDlet gameMIDlet) {
        this.display = display;
        this.midlet = gameMIDlet;
        this.soundFlag = true;
        this.timer = new Timer();
        this.gameEffects = new NokiaGameEffects(this);
    }

    public int scoreCal() {
        if (this.totalScore > this.firstScore) {
            this.fifthScore = this.fourthScore;
            this.fourthScore = this.thirdScore;
            this.thirdScore = this.secondScore;
            this.secondScore = this.firstScore;
            this.firstScore = this.totalScore;
            return 1;
        }
        if (this.totalScore > this.secondScore) {
            this.fifthScore = this.fourthScore;
            this.fourthScore = this.thirdScore;
            this.thirdScore = this.secondScore;
            this.secondScore = this.totalScore;
            return 2;
        }
        if (this.totalScore > this.thirdScore) {
            this.fifthScore = this.fourthScore;
            this.fourthScore = this.thirdScore;
            this.thirdScore = this.totalScore;
            return 3;
        }
        if (this.totalScore > this.fourthScore) {
            this.fifthScore = this.fourthScore;
            this.fourthScore = this.totalScore;
            return 4;
        }
        if (this.totalScore > this.fifthScore) {
            this.fifthScore = this.totalScore;
            return 5;
        }
        return 0;
    }

    private void openRMS() {
        try {
            if (this.rec == null) {
                this.rec = RecordStore.openRecordStore((String)"phoneshot", (boolean)true);
            }
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    private void readRMS() {
        try {
            if (this.rec.getNumRecords() == 0) {
                this.firstScore = 0;
                this.secondScore = 0;
                this.thirdScore = 0;
                this.fourthScore = 0;
                this.fifthScore = 0;
                this.soundFlag = true;
            } else {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.rec.getRecord(1));
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                try {
                    this.firstScore = dataInputStream.readInt();
                    this.secondScore = dataInputStream.readInt();
                    this.thirdScore = dataInputStream.readInt();
                    this.fourthScore = dataInputStream.readInt();
                    this.fifthScore = dataInputStream.readInt();
                    this.soundFlag = dataInputStream.readBoolean();
                }
                catch (IOException iOException) {}
            }
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    void saveRMS() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(this.firstScore);
            dataOutputStream.writeInt(this.secondScore);
            dataOutputStream.writeInt(this.thirdScore);
            dataOutputStream.writeInt(this.fourthScore);
            dataOutputStream.writeInt(this.fifthScore);
            dataOutputStream.writeBoolean(this.soundFlag);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        try {
            if (this.rec.getNumRecords() == 0) {
                this.rec.addRecord(byArray, 0, byArray.length);
            } else {
                this.rec.setRecord(1, byArray, 0, byArray.length);
            }
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    private void closeRMS() {
        try {
            if (this.rec != null) {
                this.rec.closeRecordStore();
            }
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public void gameControl() {
        switch (this.gameFlag) {
            case 3: {
                this.openRMS();
                this.readRMS();
                if (this.titleCanvas == null) {
                    this.titleCanvas = new TitleCanvas(this);
                }
                this.display.setCurrent((Displayable)this.titleCanvas);
                this.gameEffects.eachSound(14);
                break;
            }
            case 1: {
                if (this.gameCanvas != null) {
                    this.gameCanvas = null;
                }
                this.saveRMS();
                this.closeRMS();
                this.midlet.destroyApp(true);
                this.midlet.notifyDestroyed();
            }
        }
    }
}

