/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cldc.i18n.j2me;

import com.sun.cldc.i18n.StreamReader;
import java.io.IOException;
import java.io.UTFDataFormatException;

public class UTF_8_Reader
extends StreamReader {
    private static final int NO_BYTE = -2;
    private int[] readAhead = new int[3];
    private boolean newRead;

    public UTF_8_Reader() {
        this.prepareForNextChar();
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int count = 0;
        int currentChar = 0;
        if (len == 0) {
            return 0;
        }
        this.newRead = true;
        while (count < len) {
            int extraBytes;
            int firstByte = this.getByteOfCurrentChar(0);
            if (firstByte < 0) {
                if (firstByte == -1 && count == 0) {
                    return -1;
                }
                return count;
            }
            switch (firstByte >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    extraBytes = 0;
                    currentChar = firstByte;
                    break;
                }
                case 12: 
                case 13: {
                    extraBytes = 1;
                    currentChar = firstByte & 0x1F;
                    break;
                }
                case 14: {
                    extraBytes = 2;
                    currentChar = firstByte & 0xF;
                    break;
                }
                default: {
                    throw new UTFDataFormatException("invalid first byte " + Integer.toBinaryString(firstByte));
                }
            }
            int j2 = 1;
            while (j2 <= extraBytes) {
                int nextByte = this.getByteOfCurrentChar(j2);
                if (nextByte == -2) {
                    return count;
                }
                if (nextByte == -1) {
                    throw new UTFDataFormatException("partial character");
                }
                if ((nextByte & 0xC0) != 128) {
                    throw new UTFDataFormatException("invalid byte " + Integer.toBinaryString(nextByte));
                }
                currentChar = (currentChar << 6) + (nextByte & 0x3F);
                ++j2;
            }
            cbuf[off + count] = (char)currentChar;
            ++count;
            this.prepareForNextChar();
        }
        return count;
    }

    private int getByteOfCurrentChar(int byteOfChar) throws IOException {
        if (this.readAhead[byteOfChar] != -2) {
            return this.readAhead[byteOfChar];
        }
        if (!this.newRead && this.in.available() <= 0) {
            return -2;
        }
        this.readAhead[byteOfChar] = this.in.read();
        this.newRead = false;
        return this.readAhead[byteOfChar];
    }

    private void prepareForNextChar() {
        this.readAhead[0] = -2;
        this.readAhead[1] = -2;
        this.readAhead[2] = -2;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int readAheadLimit) throws IOException {
        throw new IOException("mark() not supported");
    }

    public void reset() throws IOException {
        throw new IOException("reset() not supported");
    }

    public int sizeOf(byte[] array, int offset, int length) {
        int count = 0;
        int endOfArray = offset + length;
        while (offset < endOfArray) {
            ++count;
            switch ((array[offset] & 0xFF) >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++offset;
                    break;
                }
                case 12: 
                case 13: {
                    offset += 2;
                    break;
                }
                case 14: {
                    offset += 3;
                    break;
                }
                default: {
                    return count;
                }
            }
        }
        return count;
    }
}

