/*
 * Decompiled with CFR 0.152.
 */
import com.samsung.util.AudioClip;
import com.samsung.util.Vibration;
import ru.antares.utils.DebugEx;

public class Sound {
    public static final int midiVolume = 3;
    public static final int soundVolume = 3;
    private AudioClip midiMusic;
    private AudioClip mp3Music;
    private String curMidiFileName = "none";
    private String[] midiFiles = new String[]{"/sound/MenuMusic.mid"};
    private String curMP3FileName = "none";
    private String[] mp3Files = new String[]{"/sound/fire.mp3", "/sound/strike.mp3", "/sound/blow.mp3", "/sound/move.mp3", "/sound/newrow.mp3"};

    public Sound() {
        DebugEx.debugOut("  Enabled Sound");
    }

    public boolean playMIDI(String string, int n, int n2) {
        if (this.midiMusic == null && AudioClip.isSupported()) {
            try {
                this.midiMusic = new AudioClip(3, string);
                this.midiMusic.play(n, n2);
                this.curMidiFileName = string;
                DebugEx.debugOut("        Start play MIDI file: " + string);
            }
            catch (Exception exception) {
                DebugEx.debugOut("        Error loading MIDI file: " + string);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean playMIDI(int n, int n2) {
        if (n >= 0 && n < this.midiFiles.length) {
            return this.playMIDI(this.midiFiles[n], n2, 3);
        }
        return false;
    }

    public void stopMIDI() {
        if (this.midiMusic != null) {
            this.midiMusic.stop();
            DebugEx.debugOut("        Stop Play Music file: " + this.curMidiFileName);
            this.midiMusic = null;
            this.curMidiFileName = "none";
        }
    }

    public boolean playMP3(String string, int n, int n2) {
        if (AudioClip.isSupported()) {
            try {
                this.mp3Music = new AudioClip(2, string);
                this.mp3Music.play(n, n2);
                this.curMP3FileName = string;
                DebugEx.debugOut("        Start play MP3 file: " + string);
            }
            catch (Exception exception) {
                DebugEx.debugOut("        Error loading MP3 file: " + string);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean playMP3(int n, int n2) {
        return false;
    }

    public void stopMP3() {
        if (this.mp3Music != null) {
            this.mp3Music.stop();
            DebugEx.debugOut("        Stop Play MP3 file: " + this.curMP3FileName);
            this.mp3Music = null;
            this.curMP3FileName = "none";
        }
    }

    public static void startVibration(int n, int n2) {
        if (Vibration.isSupported()) {
            Vibration.start((int)n, (int)n2);
            DebugEx.debugOut("      Vibration is On");
        }
    }

    public static void stopVibration() {
        Vibration.stop();
        DebugEx.debugOut("      Vibration is OFF");
    }
}

