/*
 * Decompiled with CFR 0.152.
 */
package ru.antares.utils;

import ru.antares.utils.MathEx;
import ru.antares.utils.PointXY;

public class Rect {
    public int x = 0;
    public int y = 0;
    public int width = 0;
    public int height = 0;

    public Rect() {
    }

    public Rect(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public Rect(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
    }

    public Rect(PointXY pointXY) {
        this.x = pointXY.x;
        this.y = pointXY.y;
    }

    public Rect(PointXY pointXY, PointXY pointXY2) {
        this.x = pointXY.x;
        this.y = pointXY.y;
        this.width = pointXY2.x - this.x;
        this.width = pointXY2.x - this.x;
    }

    public Rect(Rect rect) {
        this.x = rect.x;
        this.y = rect.y;
        this.width = rect.width;
        this.height = rect.height;
    }

    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public void setRect(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
    }

    public void setUpper(PointXY pointXY) {
        this.x = pointXY.x;
        this.y = pointXY.y;
    }

    public void setRect(PointXY pointXY, PointXY pointXY2) {
        this.x = pointXY.x;
        this.y = pointXY.y;
        this.width = pointXY2.x - this.x;
        this.width = pointXY2.x - this.x;
    }

    public void setRect(Rect rect) {
        this.x = rect.x;
        this.y = rect.y;
        this.width = rect.width;
        this.height = rect.height;
    }

    public PointXY getUpper() {
        return new PointXY(this.x, this.y);
    }

    public PointXY getLower() {
        return new PointXY(this.x + this.width, this.y + this.height);
    }

    public PointXY getCenter() {
        return new PointXY(this.x + this.width / 2, this.y + this.height / 2);
    }

    public int getRadius() {
        return Math.min(this.width, this.height) / 2;
    }

    public boolean inside(int n, int n2) {
        if ((this.width | this.height) < 0) {
            return false;
        }
        return n >= this.x && n2 >= this.y && n <= this.x + this.width && n2 <= this.y + this.height;
    }

    public boolean inside(PointXY pointXY) {
        if ((this.width | this.height) < 0) {
            return false;
        }
        return pointXY.x >= this.x && pointXY.y >= this.y && pointXY.x <= this.x + this.width && pointXY.y <= this.y + this.height;
    }

    public boolean isEmpty() {
        return this.width <= 0 || this.height <= 0;
    }

    public void move(int n, int n2) {
        this.x += n;
        this.y += n2;
    }

    public Rect intersection(Rect rect) {
        int n = Math.max(this.x, rect.x);
        int n2 = Math.max(this.y, rect.y);
        int n3 = Math.min(this.x + this.width, rect.x + rect.width);
        int n4 = Math.min(this.y + this.height, rect.y + rect.height);
        if (n > n3 || n2 > n4) {
            return null;
        }
        return new Rect(n, n2, n3 - n, n4 - n2);
    }

    public boolean intersection(Rect rect, Rect rect2) {
        int n = Math.max(this.x, rect.x);
        int n2 = Math.max(this.y, rect.y);
        int n3 = Math.min(this.x + this.width, rect.x + rect.width);
        int n4 = Math.min(this.y + this.height, rect.y + rect.height);
        if (n > n3 || n2 > n4) {
            return false;
        }
        rect2.setRect(n, n2, n3 - n, n4 - n2);
        return true;
    }

    public boolean intersect(Rect rect) {
        int n = Math.max(this.x, rect.x);
        int n2 = Math.max(this.y, rect.y);
        int n3 = Math.min(this.x + this.width, rect.x + rect.width);
        int n4 = Math.min(this.y + this.height, rect.y + rect.height);
        return n <= n3 && n2 <= n4;
    }

    public boolean intersectRound(Rect rect) {
        if (!this.intersect(rect)) {
            return false;
        }
        int n = this.x - rect.x;
        int n2 = this.y - rect.y;
        return MathEx.sqrt_fast(n * n + n2 * n2) < (long)(this.getRadius() + rect.getRadius() + 2);
    }

    public Rect union(Rect rect) {
        int n = Math.min(this.x, rect.x);
        int n2 = Math.min(this.y, rect.y);
        int n3 = Math.max(this.x + this.width, rect.x + rect.width);
        int n4 = Math.max(this.y + this.height, rect.y + rect.height);
        return new Rect(n, n2, n3 - n, n4 - n2);
    }

    public String toString() {
        return this.getClass().getName() + "[x1=" + this.x + ",y1=" + this.y + ",x2=" + (this.x + this.width) + ",y2=" + (this.y + this.height) + ",width=" + this.width + ",height=" + this.height + "]";
    }
}

