/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import ru.antares.utils.DebugEx;
import ru.antares.utils.Rect;

public class GameCanvas {
    public static final int GUN_SPEED_UP = 10;
    public static final int GUN_MOVE_SPEED_1 = 1;
    public static final int GUN_MOVE_SPEED_2 = 5;
    MainGameLoop mainGameLoop;
    private int width = 128;
    private int height = 128;
    public MainGame mainGame;
    private boolean gameAbort = false;
    private boolean moveGunLeft = false;
    private boolean moveGunRight = false;
    private int buttonPressTime = 0;
    public int gameMode = 0;
    public int gameDifficulty = 0;
    public int gameLevel = 0;

    public GameCanvas(MainGameLoop mainGameLoop, int n, int n2) {
        this.mainGameLoop = mainGameLoop;
        this.width = n;
        this.height = n2;
    }

    public boolean createGameCanvas() {
        DebugEx.debugOut("Creat main");
        this.mainGame = new MainGame();
        if (this.mainGame != null && this.mainGame.loadGameImages(new Rect(0, 0, this.width, this.height), 24, "/images/BackFieldImage.png", "/images/BackGunImage.png")) {
            return true;
        }
        DebugEx.debugOut("   create Game Canvas error");
        return false;
    }

    public boolean loadOldGame() {
        this.gameAbort = false;
        if (this.mainGame.loadOldGame() && this.mainGame.bubbleField.saveCurBubblesMap(true)) {
            this.gameMode = this.mainGame.gameMode;
            this.gameDifficulty = this.mainGame.gameDifficulty;
            this.gameLevel = this.mainGame.gameLevel;
            this.moveGunLeft = false;
            this.moveGunRight = false;
            this.buttonPressTime = 0;
            return true;
        }
        DebugEx.debugOut("    load old Game error");
        return false;
    }

    public boolean loadGame(int n, int n2, int n3) {
        this.gameAbort = false;
        if (!this.mainGame.createGame(n, n2, n3)) {
            DebugEx.debugOut("    create main error");
            return false;
        }
        this.gameMode = n;
        this.gameDifficulty = n2;
        this.gameLevel = n3;
        this.moveGunLeft = false;
        this.moveGunRight = false;
        this.buttonPressTime = 0;
        return true;
    }

    public void saveCurGame() {
        this.mainGame.saveCurGame();
    }

    public boolean curGameSaved() {
        return this.mainGame.curGameSaved();
    }

    public int getPlayerScore() {
        return this.mainGame.bubbleField.playerScore;
    }

    public void resetCurPlayerScore() {
        this.mainGame.bubbleField.resetCurPlayerScore();
    }

    public int getGameState() {
        if (this.mainGame.isGameOwer()) {
            return 1;
        }
        if (this.mainGame.isPlayerWin()) {
            return 2;
        }
        if (this.gameAbort) {
            return -1;
        }
        return 0;
    }

    public void paint(Graphics graphics) {
        if (this.moveGunLeft) {
            ++this.buttonPressTime;
            if (this.buttonPressTime < 10) {
                this.mainGame.moveSightLeft(1);
            } else {
                this.mainGame.moveSightLeft(5);
            }
        } else if (this.moveGunRight) {
            ++this.buttonPressTime;
            if (this.buttonPressTime < 10) {
                this.mainGame.moveSightRight(1);
            } else {
                this.mainGame.moveSightRight(5);
            }
        }
        this.mainGame.drawGame(graphics);
    }

    public void keyPressed(int n, int n2) {
        if (n2 == 0) {
            switch (n) {
                case -8: {
                    this.gameAbort = true;
                    break;
                }
                case 35: 
                case 49: 
                case 52: 
                case 55: {
                    this.moveGunLeft = true;
                    break;
                }
                case 42: 
                case 51: 
                case 54: 
                case 57: {
                    this.moveGunRight = true;
                    break;
                }
                case 48: 
                case 50: 
                case 53: 
                case 56: {
                    this.mainGame.fire();
                }
            }
        } else {
            switch (n2) {
                case 2: 
                case 9: 
                case 11: {
                    this.moveGunLeft = true;
                    break;
                }
                case 5: 
                case 10: 
                case 12: {
                    this.moveGunRight = true;
                    break;
                }
                case 1: {
                    this.mainGame.fire();
                    break;
                }
                case 6: {
                    this.mainGame.fire();
                }
            }
        }
    }

    public void keyReleased(int n, int n2) {
        this.buttonPressTime = 0;
        this.moveGunLeft = false;
        this.moveGunRight = false;
    }
}

