/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import ru.antares.utils.DebugEx;
import ru.antares.utils.Rect;

public class MainGame {
    public static final int GAME_MODES = 2;
    public static final int DIFFICULTY_COUNT = 3;
    public static final int LEVEL_COUNT = 10;
    public static final int MAX_ROWS_ON_FIELD = 11;
    public static final int RANDOM_BUBBLES_ARR_LEN = 60;
    public int gameMode = 0;
    public int gameDifficulty = 0;
    public int gameLevel = 0;
    public static final int[][] ENDLESS_MODE_FIELS_MAP = new int[][]{{6, 4, 35, 25, 3, 3, 3, 3}, {8, 4, 30, 20, 2, 2, 2, 2}, {10, 4, 15, 25, 1, 1, 1, 1}};
    public static final int GUN_EX_MODE_MAX_FIRE_COUNT = 3;
    private Image gameImage;
    public Graphics gameCanvas;
    private Rect displayRect;
    public BubbleField bubbleField;
    public BubbleGun bubbleGun;
    public Bubble curFireBubble;
    public int gameState = -2;
    private Image borderLeftImage;
    private Image borderRight1Image;
    private Image borderRight2Image;
    private Image backFieldImage;
    private Rect fieldRect;
    private Image backGunImage;
    private Rect gunRect;
    public Rect bigFieldRect;
    private Rect scoreOutRect;
    public Rect tempRect;
    private int remainingFileBubblesToNewRow = 10;
    private int remainingFileBubblesToWallDown = 10;
    public int gunExModeFireCount = 0;
    private boolean isCurGameSaved = false;
    private boolean mustSaveGame = false;
    private boolean isRealGameOwer = false;
    private boolean isRealPlayerWin = false;
    public boolean vibrationOn = false;
    public boolean soundOn = false;
    public boolean musicOn = false;
    public Sound sound;

    public boolean loadGameImages(Rect rect, int n, String string, String string2) {
        if (rect.isEmpty()) {
            return false;
        }
        this.displayRect = rect;
        try {
            this.gameImage = Image.createImage((int)rect.width, (int)rect.height);
            this.gameCanvas = this.gameImage.getGraphics();
            this.backFieldImage = Image.createImage((String)string);
            this.backGunImage = Image.createImage((String)string2);
            this.gunRect = new Rect(0, rect.y + rect.height - this.backGunImage.getHeight(), this.backGunImage.getWidth(), this.backGunImage.getHeight());
            this.borderLeftImage = Image.createImage((String)"/images/BorderLeft.png");
            this.borderRight1Image = Image.createImage((String)"/images/BorderRight_1.png");
            this.borderRight2Image = Image.createImage((String)"/images/BorderRight_2.png");
            this.bubbleGun = new BubbleGun();
            this.tempRect = new Rect();
            this.scoreOutRect = new Rect();
            this.sound = new Sound();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        this.bubbleField = new BubbleField();
        if (!this.bubbleField.loadPhizBubbles(n)) {
            DebugEx.debugOut("     error Loading phiz bubbles images");
            return false;
        }
        if (!this.bubbleField.connectFieldData(this)) {
            DebugEx.debugOut("     error Connecting Field Data");
            return false;
        }
        if (!this.bubbleGun.loadGunImages("/images/SightImage_1.png", "/images/SightImage_2.png", "/images/FiringPin.png")) {
            DebugEx.debugOut("     error Loding Gun Iamges");
            return false;
        }
        return true;
    }

    public boolean createGame(int n, int n2, int n3) {
        this.isRealGameOwer = false;
        this.isRealPlayerWin = false;
        this.isCurGameSaved = false;
        this.gunExModeFireCount = 0;
        if (n < 0) {
            n = 0;
        } else if (n >= 2) {
            n = 2;
        }
        this.gameMode = n;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= 3) {
            n2 = 2;
        }
        this.gameDifficulty = n2;
        if (n2 == 0) {
            this.gunExModeFireCount = 3;
        }
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 >= 10) {
            n3 = 9;
        }
        this.gameLevel = n3;
        this.remainingFileBubblesToNewRow = ENDLESS_MODE_FIELS_MAP[n2][2];
        this.remainingFileBubblesToWallDown = ENDLESS_MODE_FIELS_MAP[n2][3];
        switch (n) {
            case 0: {
                if (this.bubbleField.createBubblesMap(ENDLESS_MODE_FIELS_MAP[n2][0], 11, ENDLESS_MODE_FIELS_MAP[n2][1], 60, ENDLESS_MODE_FIELS_MAP[n2][5], ENDLESS_MODE_FIELS_MAP[n2][6], ENDLESS_MODE_FIELS_MAP[n2][7])) break;
                DebugEx.debugOut("     error Creating BubbleField Map on Endless Mode");
                return false;
            }
            case 1: {
                if (this.bubbleField.loadBubblesMap(n2, n3, 60)) break;
                DebugEx.debugOut("     error Loading BubbleField Map on Puzzle Mode");
                return false;
            }
        }
        if (!this.bubbleField.createField(new Rect(0, 0, this.displayRect.width, this.displayRect.height - this.backGunImage.getHeight()))) {
            DebugEx.debugOut("     create field error");
            return false;
        }
        this.fieldRect = this.bubbleField.getFieldRect();
        if (this.fieldRect == null) {
            DebugEx.debugOut("     error Creating BubbleField");
            return false;
        }
        this.bigFieldRect = new Rect(this.fieldRect.x, this.fieldRect.y, this.fieldRect.width, this.fieldRect.height + this.gunRect.height);
        if (!this.bubbleGun.createGun(this, this.gunRect, ENDLESS_MODE_FIELS_MAP[n2][4])) {
            DebugEx.debugOut("     error Creating Gun");
        }
        this.bubbleGun.setFirstRowBotY(this.bubbleField.getFirstRowBotY());
        this.scoreOutRect.setRect(this.bubbleGun.displayRect.x + 87, this.bubbleGun.displayRect.y + 3, 34, 13);
        DebugEx.debugOut("Load All Ok");
        this.redrawAll();
        if (this.fieldRect.x > 2) {
            this.gameCanvas.drawImage(this.borderLeftImage, this.fieldRect.x - this.borderLeftImage.getWidth(), this.displayRect.y, 0);
        }
        if (this.displayRect.x + this.displayRect.width - (this.fieldRect.x + this.fieldRect.width) > 2) {
            this.gameCanvas.drawImage(this.borderRight1Image, this.fieldRect.x + this.fieldRect.width, this.displayRect.y, 0);
            this.gameCanvas.drawImage(this.borderRight2Image, this.displayRect.x + this.displayRect.width - this.borderRight2Image.getWidth(), this.displayRect.y, 0);
        }
        this.gameState = -2;
        return true;
    }

    public boolean loadOldGame() {
        if (!this.bubbleField.loadCurBubblesMap()) {
            DebugEx.debugOut("     error Loading Old Game.");
            return false;
        }
        this.isCurGameSaved = false;
        this.isRealGameOwer = false;
        this.isRealPlayerWin = false;
        if (this.gameMode < 0) {
            this.gameMode = 0;
        } else if (this.gameMode >= 2) {
            this.gameMode = 2;
        }
        if (this.gameDifficulty < 0) {
            this.gameDifficulty = 0;
        } else if (this.gameDifficulty >= 3) {
            this.gameDifficulty = 2;
        }
        if (this.gameLevel < 0) {
            this.gameLevel = 0;
        } else if (this.gameLevel >= 10) {
            this.gameLevel = 9;
        }
        this.remainingFileBubblesToNewRow = ENDLESS_MODE_FIELS_MAP[this.gameDifficulty][2];
        this.remainingFileBubblesToWallDown = ENDLESS_MODE_FIELS_MAP[this.gameDifficulty][3];
        if (!this.bubbleField.createField(new Rect(0, 0, this.displayRect.width, this.displayRect.height - this.backGunImage.getHeight()))) {
            DebugEx.debugOut("     create field error");
            return false;
        }
        this.fieldRect = this.bubbleField.getFieldRect();
        if (this.fieldRect == null) {
            DebugEx.debugOut("     error Creating BubbleField");
            return false;
        }
        this.bigFieldRect = new Rect(this.fieldRect.x, this.fieldRect.y, this.fieldRect.width, this.fieldRect.height + this.gunRect.height);
        if (!this.bubbleGun.createGun(this, this.gunRect, ENDLESS_MODE_FIELS_MAP[this.gameDifficulty][4])) {
            DebugEx.debugOut("     error Creating Gun");
            return false;
        }
        this.bubbleGun.setFirstRowBotY(this.bubbleField.getFirstRowBotY());
        this.scoreOutRect.setRect(this.bubbleGun.displayRect.x + 87, this.bubbleGun.displayRect.y + 3, 34, 13);
        DebugEx.debugOut("Load All Ok");
        this.redrawAll();
        if (this.fieldRect.x > 2) {
            this.gameCanvas.drawImage(this.borderLeftImage, this.fieldRect.x - this.borderLeftImage.getWidth(), this.displayRect.y, 0);
        }
        if (this.displayRect.x + this.displayRect.width - (this.fieldRect.x + this.fieldRect.width) > 2) {
            this.gameCanvas.drawImage(this.borderRight1Image, this.fieldRect.x + this.fieldRect.width, this.displayRect.y, 0);
            this.gameCanvas.drawImage(this.borderRight2Image, this.displayRect.x + this.displayRect.width - this.borderRight2Image.getWidth(), this.displayRect.y, 0);
        }
        this.gameState = -2;
        return true;
    }

    public void saveCurGame() {
        this.mustSaveGame = true;
    }

    public boolean curGameSaved() {
        return this.isCurGameSaved;
    }

    public void addGunExModeFireCount() {
        this.gunExModeFireCount = 3;
    }

    public void fullRedraw() {
        this.gameState = -2;
        this.redrawAll();
    }

    public void redrawAll() {
        this.gameCanvas.setClip(this.fieldRect.x, this.fieldRect.y, this.fieldRect.width, this.fieldRect.height);
        this.drawBackFiledImage(this.gameCanvas, this.displayRect);
        this.gameCanvas.setClip(this.displayRect.x, this.displayRect.y, this.displayRect.width, this.displayRect.height);
        this.gameCanvas.drawImage(this.backGunImage, this.gunRect.x, this.gunRect.y, 0);
        this.bubbleField.redrawAllField();
        this.bubbleGun.redrawAllGun();
    }

    public void drawBackFiledImage(Graphics graphics, Rect rect) {
        int n = Math.max(rect.y, graphics.getClipY());
        int n2 = Math.min(rect.y + rect.height, graphics.getClipY() + graphics.getClipHeight());
        int n3 = this.backFieldImage.getHeight();
        while (n < n2) {
            graphics.drawImage(this.backFieldImage, rect.x, n, 0);
            n += n3;
        }
    }

    public void redrawBackImageInRect(Graphics graphics, Rect rect) {
        if (rect.intersection(this.fieldRect, this.tempRect)) {
            graphics.setClip(this.tempRect.x, this.tempRect.y, this.tempRect.width, this.tempRect.height);
            this.drawBackFiledImage(graphics, this.displayRect);
        }
        if (rect.intersection(this.gunRect, this.tempRect)) {
            graphics.setClip(this.tempRect.x, this.tempRect.y, this.tempRect.width, this.tempRect.height);
            graphics.drawImage(this.backGunImage, this.gunRect.x, this.gunRect.y, 0);
        }
        graphics.setClip(this.displayRect.x, this.displayRect.y, this.displayRect.width, this.displayRect.height);
    }

    public void redrawBackImageInRect(Rect rect) {
        if (rect.intersection(this.fieldRect, this.tempRect)) {
            this.gameCanvas.setClip(this.tempRect.x, this.tempRect.y, this.tempRect.width, this.tempRect.height);
            this.drawBackFiledImage(this.gameCanvas, this.displayRect);
        }
        if (rect.intersection(this.gunRect, this.tempRect)) {
            this.gameCanvas.setClip(this.tempRect.x, this.tempRect.y, this.tempRect.width, this.tempRect.height);
            this.gameCanvas.drawImage(this.backGunImage, this.gunRect.x, this.gunRect.y, 0);
        }
        this.gameCanvas.setClip(this.displayRect.x, this.displayRect.y, this.displayRect.width, this.displayRect.height);
    }

    public void redrawBackBufferRect(Graphics graphics, Rect rect) {
        if (rect.intersection(this.displayRect, this.tempRect)) {
            graphics.setClip(this.tempRect.x, this.tempRect.y, this.tempRect.width, this.tempRect.height);
            graphics.drawImage(this.gameImage, this.displayRect.x, this.displayRect.y, 0);
            graphics.setClip(this.displayRect.x, this.displayRect.y, this.displayRect.width, this.displayRect.height);
        }
    }

    public boolean drawGame(Graphics graphics) {
        switch (this.gameState) {
            case 0: {
                if (this.gunExModeFireCount == 0) {
                    this.bubbleGun.drawGun(graphics, true);
                } else {
                    this.bubbleGun.drawGunEx(graphics, true, true);
                    this.bubbleField.redrawCurPlayerScore(graphics, this.scoreOutRect, false);
                }
                if (this.curFireBubble != null) {
                    if (this.gunExModeFireCount == 0) {
                        this.bubbleGun.eraseGun(graphics);
                    } else {
                        this.bubbleGun.eraseGunEx(graphics);
                        this.bubbleField.redrawCurPlayerScore(graphics, this.scoreOutRect, false);
                    }
                    if (this.soundOn) {
                        this.sound.playMP3(0, 0);
                    }
                    this.gameState = 1;
                    --this.remainingFileBubblesToNewRow;
                    --this.remainingFileBubblesToWallDown;
                    if (this.gameDifficulty == 0) {
                        this.gunExModeFireCount = 3;
                    } else if (this.gunExModeFireCount > 0) {
                        --this.gunExModeFireCount;
                    }
                }
                if (!this.mustSaveGame) break;
                this.mustSaveGame = false;
                this.bubbleField.saveCurBubblesMap(false);
                this.isCurGameSaved = true;
                break;
            }
            case 1: {
                if (this.curFireBubble == null) break;
                this.redrawBackBufferRect(graphics, this.curFireBubble.rect);
                this.curFireBubble.move(this.bigFieldRect);
                if (this.bubbleField.testBubbleStick(this.curFireBubble, true) || this.curFireBubble.bubbleHitUpWall) {
                    this.curFireBubble.drawBubble(this.gameCanvas);
                    this.curFireBubble.drawBubble(graphics);
                    this.curFireBubble = null;
                    this.gameState = 2;
                    if (!this.soundOn) break;
                    this.sound.playMP3(1, 0);
                    break;
                }
                this.curFireBubble.drawBubble(graphics);
                break;
            }
            case 2: {
                switch (this.bubbleField.redrawDeadBubbles(graphics)) {
                    case -1: {
                        this.gameState = 5;
                        break;
                    }
                    case 1: {
                        if (this.soundOn) {
                            this.sound.playMP3(2, 0);
                        }
                        this.gameState = 3;
                    }
                }
                break;
            }
            case 3: {
                if (this.bubbleField.foundFallBubbles() > 0) {
                    this.redrawAll();
                    this.gameState = 4;
                    break;
                }
                this.gameState = 5;
                break;
            }
            case 4: {
                graphics.setClip(this.fieldRect.x, this.fieldRect.y, this.fieldRect.width, this.fieldRect.height);
                if (this.bubbleField.redrawFallBubbles(graphics)) break;
                this.gameState = 5;
                break;
            }
            case 5: {
                if (!this.bubbleGun.drawGunReload(graphics)) break;
                this.gameState = -1;
                break;
            }
            case -1: {
                boolean bl = false;
                if (this.gameMode == 0 && this.remainingFileBubblesToNewRow < 0) {
                    this.remainingFileBubblesToNewRow = ENDLESS_MODE_FIELS_MAP[this.gameDifficulty][2];
                    if (this.soundOn) {
                        this.sound.playMP3(4, 0);
                    }
                    this.bubbleField.addRandomRow();
                    bl = true;
                }
                if (this.remainingFileBubblesToWallDown < 0) {
                    this.remainingFileBubblesToWallDown = ENDLESS_MODE_FIELS_MAP[this.gameDifficulty][3];
                    if (this.vibrationOn) {
                        Sound.startVibration(500, 3);
                    }
                    if (this.soundOn) {
                        this.sound.playMP3(3, 0);
                    }
                    this.bubbleField.addEmptyRow();
                    this.bubbleGun.setFirstRowBotY(this.bubbleField.getFirstRowBotY());
                    bl = true;
                }
                if (bl) {
                    this.redrawAll();
                    this.redrawBackBufferRect(graphics, this.fieldRect);
                }
                System.gc();
                int n = 0;
                try {
                    while (Runtime.getRuntime().freeMemory() < 30000L && n < 50) {
                        Thread.sleep(20L);
                        ++n;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                DebugEx.debugOut(" game mem=" + Runtime.getRuntime().freeMemory());
                if (this.bubbleField.isGameOwer()) {
                    this.isRealGameOwer = true;
                    return true;
                }
                if (this.bubbleField.isPlayerWin()) {
                    this.redrawBackBufferRect(graphics, this.displayRect);
                    this.gameState = 10;
                    return true;
                }
                this.gameState = 0;
                if (this.gunExModeFireCount == 0) {
                    this.bubbleGun.drawGun(graphics, false);
                } else {
                    this.bubbleGun.drawGunEx(graphics, false, true);
                }
                this.bubbleField.redrawCurPlayerScore(graphics, this.scoreOutRect, false);
                break;
            }
            case -2: {
                graphics.drawImage(this.gameImage, this.displayRect.x, this.displayRect.y, 0);
                if (this.gunExModeFireCount == 0) {
                    this.bubbleGun.drawGun(graphics, false);
                } else {
                    this.bubbleGun.drawGunEx(graphics, false, true);
                }
                this.bubbleField.redrawCurPlayerScore(graphics, this.scoreOutRect, false);
                this.gameState = 0;
                break;
            }
            case 10: {
                if (this.bubbleField.addScoreWhenPlayerWins(graphics)) {
                    this.gameState = 0;
                    this.isRealPlayerWin = true;
                }
                this.bubbleField.redrawCurPlayerScore(graphics, this.scoreOutRect, true);
            }
        }
        return true;
    }

    public boolean moveSightLeft(int n) {
        return this.bubbleGun.moveSightLeft(n);
    }

    public boolean moveSightRight(int n) {
        return this.bubbleGun.moveSightRight(n);
    }

    public boolean isGameOwer() {
        return this.isRealGameOwer;
    }

    public boolean isPlayerWin() {
        return this.isRealPlayerWin;
    }

    public boolean fire() {
        if (this.curFireBubble == null && this.gameState == 0) {
            this.curFireBubble = this.bubbleGun.fire();
            if (this.curFireBubble == null) {
                return false;
            }
            this.curFireBubble.setCenterX(this.bubbleGun.getGunCenterX());
            this.curFireBubble.setCenterY(this.bubbleGun.getGunCenterY());
            this.curFireBubble.setDxFR(this.bubbleGun.sightX / 4);
            this.curFireBubble.setDyFR(-(this.bubbleGun.sightY / 4));
        }
        return true;
    }
}

