/*
 * Decompiled with CFR 0.152.
 */
package ru.antares.GameUtils;

import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import ru.antares.GameUtils.MenuItem;
import ru.antares.utils.DebugEx;
import ru.antares.utils.PointXY;
import ru.antares.utils.Rect;

public class GameMenu {
    private Image menuImage;
    public Graphics menuCanvas;
    private Rect displayRect;
    private Vector images;
    private Vector items;
    private int[] activeStaticItems;
    private int activeStaticItemsLen = 0;
    private int[] activeDynamicItems;
    private int activeDynamicItemsLen = 0;
    private int curActiveDynamicItem = -1;
    private int prevActiveDynamicItem = -1;
    boolean isForceFullRedraw = true;
    boolean isForceRedrawCurActiveDynamicItem = false;
    boolean isForceRedrawPrevActiveDynamicItem = false;
    private Rect tempRect;
    boolean keyPressed = false;
    boolean keyUp = false;
    boolean keyDown = false;
    boolean keyLeft = false;
    boolean keyRight = false;
    boolean keyFire = false;
    boolean keySoftLeft = false;
    boolean keySoftRight = false;
    private int itemSoftKeyLeftIndex = -1;
    private int itemSoftKeyRightIndex = -1;

    public boolean createMenu(Rect rect) {
        this.displayRect = rect == null ? new Rect(0, 0, 128, 128) : rect;
        try {
            this.menuImage = Image.createImage((int)this.displayRect.width, (int)this.displayRect.height);
            this.menuCanvas = this.menuImage.getGraphics();
            this.tempRect = new Rect();
            this.images = new Vector();
            this.items = new Vector();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public void resetMenu() {
        DebugEx.debugOut(" 1 mem=" + Runtime.getRuntime().freeMemory());
        this.removeAllImages();
        this.isForceFullRedraw = true;
        this.isForceRedrawCurActiveDynamicItem = false;
        this.isForceRedrawPrevActiveDynamicItem = false;
        this.items.removeAllElements();
        System.gc();
        this.activeStaticItemsLen = 0;
        this.activeDynamicItemsLen = 0;
        this.curActiveDynamicItem = -1;
        this.prevActiveDynamicItem = -1;
        this.keyPressed = false;
        this.keyUp = false;
        this.keyDown = false;
        this.keyLeft = false;
        this.keyRight = false;
        this.keyFire = false;
        this.keySoftLeft = false;
        this.keySoftRight = false;
        this.itemSoftKeyLeftIndex = -1;
        this.itemSoftKeyRightIndex = -1;
        int n = 0;
        try {
            while (Runtime.getRuntime().freeMemory() < 50000L && n < 200) {
                Thread.sleep(20L);
                ++n;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        DebugEx.debugOut(" 2 mem=" + Runtime.getRuntime().freeMemory());
    }

    public boolean addNewImage(String string) {
        try {
            Image image = Image.createImage((String)string);
            this.images.addElement(image);
        }
        catch (IOException iOException) {
            System.out.println(string);
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    public void removeAllImages() {
        this.images.removeAllElements();
    }

    public PointXY getImageSize(int n) {
        if (n >= 0 && n < this.images.size()) {
            Image image = (Image)this.images.elementAt(n);
            return new PointXY(image.getWidth(), image.getHeight());
        }
        return null;
    }

    public boolean addNewItem(MenuItem menuItem) {
        if (menuItem == null) {
            return false;
        }
        this.items.addElement(menuItem);
        return true;
    }

    public boolean removeItem(int n) {
        if (n >= 0 && n < this.items.size()) {
            this.items.removeElementAt(n);
            return true;
        }
        return false;
    }

    public void removeAllItems() {
        this.items.removeAllElements();
    }

    public boolean setActiveStaticItems(int[] nArray) {
        if (nArray == null) {
            return false;
        }
        this.activeStaticItems = nArray;
        this.activeStaticItemsLen = nArray.length;
        return true;
    }

    public boolean setActiveDynamicItems(int[] nArray) {
        if (nArray == null) {
            return false;
        }
        this.activeDynamicItems = nArray;
        this.activeDynamicItemsLen = nArray.length;
        return true;
    }

    public void changeCurActiveDynamicItem(int n, boolean bl, boolean bl2, int n2) {
        if (this.curActiveDynamicItem >= 0 && this.curActiveDynamicItem < this.activeDynamicItemsLen) {
            ((MenuItem)this.items.elementAt(this.activeDynamicItems[this.curActiveDynamicItem])).setItemParam(bl, bl2, n2);
            this.activeDynamicItems[this.curActiveDynamicItem] = n;
            this.prevActiveDynamicItem = -1;
        }
    }

    public void setCurActiveDynamicItem(int n) {
        this.curActiveDynamicItem = n;
    }

    public void setNextActiveDynamicItem() {
        ++this.curActiveDynamicItem;
        if (this.curActiveDynamicItem >= this.activeDynamicItemsLen) {
            this.curActiveDynamicItem = 0;
        }
    }

    public void setPrevActiveDynamicItem() {
        --this.curActiveDynamicItem;
        if (this.curActiveDynamicItem < 0) {
            this.curActiveDynamicItem = this.activeDynamicItemsLen - 1;
        }
    }

    public void fillBackBuf(Rect rect, int n) {
        this.menuCanvas.setColor(n);
        if (rect == null) {
            this.menuCanvas.fillRect(this.displayRect.x, this.displayRect.y, this.displayRect.width, this.displayRect.height);
        } else {
            this.menuCanvas.fillRect(rect.x, rect.y, rect.width, rect.height);
        }
    }

    public boolean drawImageToBackBuf(int n, int n2, int n3) {
        if (n >= 0 && n < this.images.size()) {
            this.menuCanvas.drawImage((Image)this.images.elementAt(n), n2, n3, 0);
            return true;
        }
        return false;
    }

    public boolean drawImageToBackBufTile(int n, int n2, int n3) {
        if (n >= 0 && n < this.images.size()) {
            int n4 = this.menuImage.getHeight();
            int n5 = ((Image)this.images.elementAt(n)).getHeight();
            while (n3 < n4) {
                this.menuCanvas.drawImage((Image)this.images.elementAt(n), n2, n3, 0);
                n3 += n5;
            }
            return true;
        }
        return false;
    }

    public boolean drawImageToBackBuf(int n, int n2, int n3, Rect rect) {
        if (n >= 0 && n < this.images.size() && this.displayRect.intersection(rect, this.tempRect)) {
            this.menuCanvas.setClip(n2, n3, this.tempRect.width, this.tempRect.height);
            this.menuCanvas.drawImage((Image)this.images.elementAt(n), n2 - this.tempRect.x, n3 - this.tempRect.y, 0);
            this.menuCanvas.setClip(this.displayRect.x, this.displayRect.y, this.displayRect.width, this.displayRect.height);
            return true;
        }
        return false;
    }

    public boolean drawImagePart(Graphics graphics, int n, int n2, int n3, Rect rect) {
        if (n >= 0 && n < this.images.size() && this.displayRect.intersection(rect, this.tempRect)) {
            graphics.setClip(n2, n3, this.tempRect.width, this.tempRect.height);
            graphics.drawImage((Image)this.images.elementAt(n), n2 - this.tempRect.x, n3 - this.tempRect.y, 0);
            graphics.setClip(this.displayRect.x, this.displayRect.y, this.displayRect.width, this.displayRect.height);
            return true;
        }
        return false;
    }

    public boolean drawImage(Graphics graphics, int n, int n2, int n3, Rect rect) {
        if (n >= 0 && n < this.images.size() && this.displayRect.intersection(rect, this.tempRect)) {
            graphics.setClip(this.tempRect.x, this.tempRect.y, this.tempRect.width, this.tempRect.height);
            graphics.drawImage((Image)this.images.elementAt(n), n2, n3, 0);
            graphics.setClip(this.displayRect.x, this.displayRect.y, this.displayRect.width, this.displayRect.height);
            return true;
        }
        return false;
    }

    public boolean redrawBackImage(Graphics graphics, Rect rect) {
        if (this.displayRect.intersection(rect, this.tempRect)) {
            graphics.setClip(this.tempRect.x, this.tempRect.y, this.tempRect.width, this.tempRect.height);
            graphics.drawImage(this.menuImage, this.displayRect.x, this.displayRect.y, 0);
            graphics.setClip(this.displayRect.x, this.displayRect.y, this.displayRect.width, this.displayRect.height);
            return true;
        }
        return false;
    }

    public void forceFullRedraw() {
        this.isForceFullRedraw = true;
    }

    public void forceRedrawCurActiveDynamicItem() {
        this.isForceRedrawCurActiveDynamicItem = true;
    }

    public void forceRedrawPrevActiveDynamicItem() {
        this.isForceRedrawPrevActiveDynamicItem = true;
    }

    public void drawStaticItems(Graphics graphics) {
        int n = 0;
        while (n < this.activeStaticItemsLen) {
            ((MenuItem)this.items.elementAt(this.activeStaticItems[n])).drawItem(graphics);
            ++n;
        }
        if (this.itemSoftKeyLeftIndex >= 0 && this.itemSoftKeyLeftIndex < this.items.size()) {
            ((MenuItem)this.items.elementAt(this.itemSoftKeyLeftIndex)).drawItem(graphics);
        }
        if (this.itemSoftKeyRightIndex >= 0 && this.itemSoftKeyRightIndex < this.items.size()) {
            ((MenuItem)this.items.elementAt(this.itemSoftKeyRightIndex)).drawItem(graphics);
        }
    }

    public void eraseStaticItems(Graphics graphics) {
        int n = 0;
        while (n < this.activeStaticItemsLen) {
            ((MenuItem)this.items.elementAt(this.activeStaticItems[n])).eraseItem(graphics);
            ++n;
        }
        if (this.itemSoftKeyLeftIndex >= 0 && this.itemSoftKeyLeftIndex < this.items.size()) {
            ((MenuItem)this.items.elementAt(this.itemSoftKeyLeftIndex)).eraseItem(graphics);
        }
        if (this.itemSoftKeyRightIndex >= 0 && this.itemSoftKeyRightIndex < this.items.size()) {
            ((MenuItem)this.items.elementAt(this.itemSoftKeyRightIndex)).eraseItem(graphics);
        }
    }

    public void drawDynamicItems(Graphics graphics) {
        int n = 0;
        while (n < this.activeDynamicItemsLen) {
            ((MenuItem)this.items.elementAt(this.activeDynamicItems[n])).drawItem(graphics);
            ++n;
        }
    }

    public void eraseDynamicItems(Graphics graphics) {
        int n = 0;
        while (n < this.activeDynamicItemsLen) {
            ((MenuItem)this.items.elementAt(this.activeDynamicItems[n])).eraseItem(graphics);
            ++n;
        }
    }

    public MenuItem getPrevActiveDynamicItem() {
        if (this.prevActiveDynamicItem >= 0 && this.prevActiveDynamicItem < this.activeDynamicItemsLen) {
            return (MenuItem)this.items.elementAt(this.activeDynamicItems[this.prevActiveDynamicItem]);
        }
        return null;
    }

    public MenuItem getCurActiveDynamicItem() {
        if (this.curActiveDynamicItem >= 0 && this.curActiveDynamicItem < this.activeDynamicItemsLen) {
            return (MenuItem)this.items.elementAt(this.activeDynamicItems[this.curActiveDynamicItem]);
        }
        return null;
    }

    public void paint(Graphics graphics) {
        if (this.keyPressed) {
            this.keyPressed = false;
            if (this.keyLeft) {
                if (this.curActiveDynamicItem >= 0 && this.curActiveDynamicItem < this.activeDynamicItemsLen) {
                    ((MenuItem)this.items.elementAt(this.activeDynamicItems[this.curActiveDynamicItem])).onKeyLeft();
                }
                this.keyLeft = false;
            } else if (this.keyRight) {
                if (this.curActiveDynamicItem >= 0 && this.curActiveDynamicItem < this.activeDynamicItemsLen) {
                    ((MenuItem)this.items.elementAt(this.activeDynamicItems[this.curActiveDynamicItem])).onKeyRight();
                }
                this.keyRight = false;
            } else if (this.keyUp) {
                if (this.curActiveDynamicItem >= 0 && this.curActiveDynamicItem < this.activeDynamicItemsLen) {
                    ((MenuItem)this.items.elementAt(this.activeDynamicItems[this.curActiveDynamicItem])).onKeyUp();
                }
                this.keyUp = false;
            } else if (this.keyDown) {
                if (this.curActiveDynamicItem >= 0 && this.curActiveDynamicItem < this.activeDynamicItemsLen) {
                    ((MenuItem)this.items.elementAt(this.activeDynamicItems[this.curActiveDynamicItem])).onKeyDown();
                }
                this.keyDown = false;
            } else if (this.keyFire) {
                if (this.curActiveDynamicItem >= 0 && this.curActiveDynamicItem < this.activeDynamicItemsLen) {
                    ((MenuItem)this.items.elementAt(this.activeDynamicItems[this.curActiveDynamicItem])).onKeyFire();
                }
                this.keyFire = false;
            }
            if (this.keySoftLeft && this.itemSoftKeyLeftIndex >= 0 && this.itemSoftKeyLeftIndex < this.items.size()) {
                ((MenuItem)this.items.elementAt(this.itemSoftKeyLeftIndex)).onKeyFire();
                this.keySoftLeft = false;
            } else if (this.keySoftRight && this.itemSoftKeyRightIndex >= 0 && this.itemSoftKeyRightIndex < this.items.size()) {
                ((MenuItem)this.items.elementAt(this.itemSoftKeyRightIndex)).onKeyFire();
                this.keySoftRight = false;
            }
        }
        if (this.curActiveDynamicItem != this.prevActiveDynamicItem) {
            if (this.prevActiveDynamicItem >= 0 && this.prevActiveDynamicItem < this.activeDynamicItemsLen) {
                ((MenuItem)this.items.elementAt(this.activeDynamicItems[this.prevActiveDynamicItem])).onLossFocus();
            }
            if (this.curActiveDynamicItem >= 0 && this.curActiveDynamicItem < this.activeDynamicItemsLen) {
                ((MenuItem)this.items.elementAt(this.activeDynamicItems[this.curActiveDynamicItem])).onSetFocus();
            }
        }
        if (this.isForceFullRedraw) {
            graphics.drawImage(this.menuImage, this.displayRect.x, this.displayRect.y, 0);
            this.drawStaticItems(graphics);
            this.drawDynamicItems(graphics);
            this.isForceFullRedraw = false;
        } else {
            if (this.isForceRedrawPrevActiveDynamicItem && this.prevActiveDynamicItem >= 0 && this.prevActiveDynamicItem < this.activeDynamicItemsLen) {
                ((MenuItem)this.items.elementAt(this.activeDynamicItems[this.prevActiveDynamicItem])).drawItem(graphics);
            }
            if (this.isForceRedrawCurActiveDynamicItem && this.curActiveDynamicItem >= 0 && this.curActiveDynamicItem < this.activeDynamicItemsLen) {
                ((MenuItem)this.items.elementAt(this.activeDynamicItems[this.curActiveDynamicItem])).drawItem(graphics);
            }
        }
        if (this.curActiveDynamicItem != this.prevActiveDynamicItem) {
            this.prevActiveDynamicItem = this.curActiveDynamicItem;
        }
    }

    public void keyPressed(int n, int n2) {
        this.keyPressed = true;
        if (n2 == 0) {
            switch (n) {
                case 52: {
                    this.keyLeft = true;
                    break;
                }
                case 54: {
                    this.keyRight = true;
                    break;
                }
                case 50: {
                    this.keyUp = true;
                    break;
                }
                case 56: {
                    this.keyDown = true;
                    break;
                }
                case 53: {
                    this.keyFire = true;
                    break;
                }
                case -6: 
                case 49: {
                    this.keySoftLeft = true;
                    break;
                }
                case -7: 
                case 51: {
                    this.keySoftRight = true;
                }
            }
        } else {
            switch (n2) {
                case 2: {
                    this.keyLeft = true;
                    break;
                }
                case 5: {
                    this.keyRight = true;
                    break;
                }
                case 1: {
                    this.keyUp = true;
                    break;
                }
                case 6: {
                    this.keyDown = true;
                    break;
                }
                case 8: {
                    this.keyFire = true;
                }
            }
        }
    }

    public void keyReleased(int n, int n2) {
        this.keyUp = false;
        this.keyDown = false;
        this.keyLeft = false;
        this.keyRight = false;
        this.keyFire = false;
        this.keySoftLeft = false;
        this.keySoftRight = false;
    }

    public void setItemIndexForSoftKeyLeft(int n) {
        this.itemSoftKeyLeftIndex = n;
    }

    public void setItemIndexForSoftKeyRight(int n) {
        this.itemSoftKeyRightIndex = n;
    }
}

