/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;

public abstract class Cannon {
    public static final byte SHOT_NONE = 0;
    public static final byte SHOT_PELLET = 1;
    public static final byte SHOT_DEBRIS = 2;
    public static final byte SHOT_EXPL = 3;
    public static final byte SHOT_SMALLBOMB = 4;
    public static final byte SHOT_CLUSTER = 5;
    public static final byte SHOT_GRENADE = 6;
    public static final byte SHOT_SHOTGUN = 7;
    public static final byte SHOT_SMALLGRENADE = 8;
    public static final byte SHOT_GRENADECLUSTER = 9;
    public static final byte SHOT_WALLRAISER = 10;
    public static final int maxWeapons = 10;
    int x;
    int y;
    int angle;
    int power;
    int hits;
    int points;
    int armor;
    int colour;
    int red;
    int green;
    int blue;
    boolean alive;
    Terrain ter;
    public final int id;
    public GameManager gm;
    public String name = "Dummy";
    public int wins = 0;
    protected byte[] weapons;
    protected byte[] shots;
    public static final int[][] barrelColour;
    public static Image[] images;
    public static final int[] atanTab1;
    public static final int[] atanTab2;
    public static final int[] atanTab3;

    protected Turn shoot(int n) {
        byte by = this.weapons[n];
        if (this.shots[n] > 0) {
            int n2 = n;
            this.shots[n2] = (byte)(this.shots[n2] - 1);
            if (this.shots[n] == 0) {
                for (int i = n; i < 9; ++i) {
                    this.weapons[i] = this.weapons[i + 1];
                    this.shots[i] = this.shots[i + 1];
                }
                this.weapons[9] = 0;
            }
        }
        return Turn.shootTurn(this.angle, this.power, by);
    }

    public Cannon(Terrain terrain, int n, GameManager gameManager, int n2) {
        this.ter = terrain;
        this.id = n;
        this.gm = gameManager;
        this.points = 0;
        this.weapons = new byte[10];
        this.shots = new byte[10];
        this.weapons[0] = 1;
        this.shots[0] = -1;
        this.weapons[1] = 5;
        this.shots[1] = -1;
        this.weapons[2] = 7;
        this.shots[2] = -1;
        this.colour = n2;
        this.red = barrelColour[n2][0];
        this.green = barrelColour[n2][1];
        this.blue = barrelColour[n2][2];
        this.reset();
    }

    public void reset() {
        this.angle = 70;
        this.power = 300;
        this.hits = 1000;
        this.alive = true;
    }

    private void _$9302(Turn turn) {
        this.angle = turn.ang;
        this.power = turn.power;
        byte by = turn.weapon;
        if (by == 6) {
            this.ter.shoot(this.x, this.y + 3, this.getTrueAngle(), this.power, by, -1, 0, this);
        } else {
            this.ter.shoot(this.x, this.y + 3, this.getTrueAngle(), this.power, by, 0, 0, this);
        }
    }

    public final void doTurn() {
        Turn turn = this.getNextTurn();
        switch (turn.action) {
            case 's': {
                this._$9302(turn);
                break;
            }
            case 'q': {
                this._$9325();
                break;
            }
            case 'p': {
                break;
            }
        }
    }

    public int getTrueAngle() {
        return this.angle >= 90 ? this.angle - 90 : 270 + this.angle;
    }

    public void hit(int n) {
        this.hits -= n * 100 / this.armor;
        if (this.hits <= 0) {
            this._$9325();
        }
    }

    private void _$9325() {
        this.hits = 0;
        this.alive = false;
        this.ter.clusterExplode(this.x, this.y, this);
    }

    public void incAngle(int n) {
        this.angle += n;
        if (this.angle > 180) {
            this.angle = 180;
        }
    }

    public void decAngle(int n) {
        this.angle -= n;
        if (this.angle < 0) {
            this.angle = 0;
        }
    }

    public void incPower(int n) {
        this.power += n;
        if (this.power > 1200) {
            this.power = 1200;
        }
    }

    public void decPower(int n) {
        this.power -= n;
        if (this.power < 0) {
            this.power = 0;
        }
    }

    public abstract void explosionNotify(int var1, int var2, Cannon var3);

    public abstract Turn getNextTurn();

    public Image getImage() {
        return images[this.colour];
    }

    public String packOptions() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name);
        stringBuffer.append(',');
        stringBuffer.append(this.colour);
        return stringBuffer.toString();
    }

    public void unpackOptions(String string) {
        try {
            int n = string.indexOf(44);
            String string2 = string.substring(0, n);
            int n2 = Integer.parseInt(string.substring(n + 1));
            this.name = string2;
            this.colour = n2;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void update() {
        int n = this.ter.getTankHeight(this.x);
        if (n < this.y) {
            this.hit((this.y - n) * 10);
            this.y = n;
        }
    }

    public static int atan(int n) {
        if (n < 0) {
            return -Cannon.atan(-n);
        }
        if (n == 0) {
            return 90;
        }
        if (n < 120) {
            return atanTab1[n / 2];
        }
        if (n < 320) {
            return atanTab2[(n - 120) / 10];
        }
        if (n < 2320) {
            return atanTab3[(n - 320) / 100];
        }
        return 0;
    }

    static {
        SHOT_NONE = 0;
        SHOT_PELLET = 1;
        SHOT_DEBRIS = (byte)2;
        SHOT_EXPL = (byte)3;
        SHOT_SMALLBOMB = (byte)4;
        SHOT_CLUSTER = (byte)5;
        SHOT_GRENADE = (byte)6;
        SHOT_SHOTGUN = (byte)7;
        SHOT_SMALLGRENADE = (byte)8;
        SHOT_GRENADECLUSTER = (byte)9;
        SHOT_WALLRAISER = (byte)10;
        maxWeapons = 10;
        barrelColour = new int[][]{{200, 100, 100}, {100, 200, 100}, {100, 100, 200}, {200, 200, 100}};
        images = new Image[4];
        for (int i = 0; i < images.length; ++i) {
            Cannon.images[i] = Cannons.getImage("cannon".concat(String.valueOf(String.valueOf(i))));
        }
        atanTab1 = new int[]{90, 88, 87, 86, 85, 84, 83, 81, 80, 79, 78, 77, 76, 75, 74, 73, 72, 71, 70, 69, 68, 67, 66, 65, 64, 63, 62, 61, 60, 59, 59, 58, 57, 56, 55, 55, 54, 53, 52, 52, 51, 50, 50, 49, 48, 48, 47, 46, 46, 45, 45, 44, 44, 43, 43, 42, 42, 41, 41, 40};
        atanTab2 = new int[]{39, 37, 35, 33, 31, 30, 28, 27, 26, 25, 24, 23, 22, 21, 21, 20, 19, 19, 18, 18};
        atanTab3 = new int[]{15, 12, 10, 8, 7, 7, 6, 5, 5, 5, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3};
    }
}

