/*
 * Decompiled with CFR 0.152.
 */
public class GameManager
implements Runnable {
    private static final byte _$9475 = 0;
    private static final byte _$9476 = 1;
    private static final byte _$9477 = 2;
    private static final byte _$9478 = 3;
    public static final int maxPlayers = 10;
    GameScreen gs;
    Terrain ter;
    public Cannon[] players;
    public int rounds;
    public int round;
    public int winner;
    public int numPlayers;
    public int id;
    public int gid;
    boolean local;
    private Thread _$9481;
    private SimpleRandom _$9188;
    byte mode;
    String[] playerNames = new String[]{"Bob", "Joe", "Ralph", "Fred", "Max", "George", "Wolfgang", "Pepe", "Ronald", "Arnold", "Chuck", "Doug", "Edward", "Hank", "Jacque", "Lou", "Norm", "Otto", "Ted", "Ajax", "Sam", "Frank", "Bubba", "Biff", "Leroy", "Newton"};
    private int _$9483;

    public GameManager(GameScreen gameScreen, Terrain terrain) {
        this.gs = gameScreen;
        this.ter = terrain;
        this.players = new Cannon[10];
        this._$9188 = new SimpleRandom();
        this._$9483 = Math.abs(this._$9188.nextInt() / 100 % this.playerNames.length);
    }

    public void run() {
        try {
            int n;
            for (n = 0; n < this.players.length; ++n) {
                this.players[n] = null;
            }
            this.numPlayers = 0;
            if (this.mode == 3) {
                int[] nArray = this.gs.getGameOptions();
                if (nArray == null) {
                    this.gs.showMenu();
                    return;
                }
                this.setOptions(nArray);
                this.gs.showMenu();
            }
            if (this.mode == 0) {
                this.gs.setPlayers(this.players);
                if (!this.gs.startPlayerSetup(true, 1)) {
                    this.gs.showMenu();
                    return;
                }
                this.ter.reset();
                while (this.round < this.rounds) {
                    this._$9485();
                    this._$9486();
                    for (n = 0; n < this.players.length && this.players[n] != null; ++n) {
                        this.ter.setCannon(this.players[n], n);
                    }
                    this.winner = this._$9487();
                    if (this.winner == -2) {
                        this.gs.showMenu();
                    }
                    this.gs.showRoundOver(this.players[this.winner]);
                    ++this.players[this.winner].wins;
                    ++this.round;
                }
                this.gs.showGameOver();
                this.gs.showMenu();
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void _$9485() {
        for (int i = 0; i < this.players.length && this.players[i] != null; ++i) {
            for (int j = i + 1; j < this.players.length; ++j) {
                if (this.players[j] == null || this.players[j].id >= this.players[i].id) continue;
                Cannon cannon = this.players[i];
                this.players[i] = this.players[j];
                this.players[j] = cannon;
            }
        }
    }

    private void _$9486() {
        for (int i = 0; i < this.numPlayers; ++i) {
            int n = i + Math.abs(this._$9188.nextInt() % (this.numPlayers - i));
            Cannon cannon = this.players[i];
            this.players[i] = this.players[n];
            this.players[n] = cannon;
        }
    }

    private int _$9487() {
        this.gs.showPlayMode();
        return this.ter.playRound(this._$9188.nextLong());
    }

    public void stop() {
        this.ter.quit();
    }

    public void setupOptions() {
        this.mode = (byte)3;
        this._$9481 = new Thread(this);
        this._$9481.start();
    }

    public void playLocalGame() {
        this.mode = 0;
        this.round = 0;
        this._$9481 = new Thread(this);
        this._$9481.start();
    }

    public int getPlayerId() {
        switch (this.mode) {
            case 0: {
                return 1;
            }
        }
        return 0;
    }

    private String _$9334(int[] nArray) {
        String string = "";
        for (int i = 0; i < 7; ++i) {
            string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(nArray[i]).append(",")));
        }
        return string;
    }

    private int[] _$9336(String string) {
        int[] nArray = new int[7];
        try {
            int n = 0;
            for (int i = 0; i < 7; ++i) {
                int n2 = string.indexOf(44, n);
                nArray[i] = Integer.parseInt(string.substring(n, n2));
                n = n2 + 1;
            }
        }
        catch (Exception exception) {
            int[] nArray2 = null;
            return nArray2;
        }
        return nArray;
    }

    public boolean isOkToStart() {
        return this.numPlayers > 1;
    }

    public Cannon getCannonForId(int n) {
        for (int i = 0; i < this.numPlayers; ++i) {
            if (this.players[i].id != n) continue;
            return this.players[i];
        }
        return null;
    }

    public void setOptions(int[] nArray) {
        this.ter.setSize(nArray[0], nArray[1]);
        this.ter.setWind(nArray[2], nArray[3]);
        this.ter.setGrav(nArray[4]);
        this.ter.setArmor(nArray[5]);
        this.rounds = nArray[6];
    }

    public void addPlayer(Cannon cannon, String string) {
        if (cannon != null) {
            this.players[this.numPlayers] = cannon;
            ++this.numPlayers;
        }
        this.gs.setPlayers(this.players);
        if (string.length() > 10) {
            string = string.substring(0, 10);
        }
        if (string.length() == 0) {
            string = this.playerNames[this._$9483++];
        }
        if (this._$9483 == this.playerNames.length) {
            this._$9483 = 0;
        }
        cannon.name = string;
        this.gs.showPlayerSetup();
    }

    public void cleanUp() {
    }

    static {
        _$9475 = 0;
        _$9476 = 1;
        _$9477 = (byte)2;
        _$9478 = (byte)3;
        maxPlayers = 10;
    }
}

