/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Terrain {
    public static final int maxWidth = 1000;
    public static final byte MODE_LOCALAIM = 0;
    public static final byte MODE_TRACKSHOT = 1;
    public static final byte MODE_WAIT = 2;
    public static final byte MODE_FREEVIEW = 3;
    public static final byte MODE_TRACKHOLE = 4;
    public static final byte TRACK_GROUND = 0;
    public static final byte TRACK_SHOT = 1;
    public static final byte TRACK_MIXED = 2;
    public static final int DRAW = -1;
    public static final int QUIT = -2;
    private static int[] _$9358;
    private static int[] _$9359;
    private static int[] _$9360;
    private int[] _$9361;
    private int[] _$9362;
    private SimpleRandom _$9188;
    private Delayer _$9036;
    int width;
    int wind;
    int grav;
    int maxWind;
    int windChange;
    int grain;
    int renderWidth;
    int renderHeight;
    int renderW2;
    int renderH2;
    int renderCX;
    int renderCY;
    int scale;
    int freeViewCX;
    int freeViewCY;
    boolean up;
    boolean down;
    boolean left;
    boolean right;
    boolean upOnce;
    boolean downOnce;
    boolean leftOnce;
    boolean rightOnce;
    boolean roundOver;
    short[] ground;
    short[] hole;
    short[] loose;
    short[] camY;
    short[] bg;
    int numCannons;
    int numShots;
    int armor;
    int winner;
    Cannon[] cannons;
    Shot[] shots;
    int firstEmpty;
    int active;
    int activeShots;
    byte mode;
    byte trackMode;
    int updateSkip;
    TurnThread turnThread;
    GameScreen gs;
    Image[] weaponImages;
    int[] weaponImageMapping = new int[]{-1, 0, -1, -1, -1, 1, 3, 2, -1, 4, 5};
    public static final byte SHOT_NONE = 0;
    public static final byte SHOT_PELLET = 1;
    public static final byte SHOT_DEBRIS = 2;
    public static final byte SHOT_EXPL = 3;
    public static final byte SHOT_SMALLBOMB = 4;
    public static final byte SHOT_CLUSTER = 5;
    public static final byte SHOT_GRENADE = 6;
    public static final byte SHOT_SHOTGUN = 7;
    public static final byte SHOT_SMALLGRENADE = 8;
    public static final byte SHOT_GRENADECLUSTER = 9;
    public static final byte SHOT_WALLRAISER = 10;
    boolean[] windAffects = new boolean[]{false, true, true, false, true, true, false, true, false, true, true};
    boolean[] gravAffects = new boolean[]{false, true, true, false, true, true, true, true, true, true, true};
    short[] expR = new short[]{30, 60, 80, 100, 120, 160, 200, 250, 255};
    short[] expG = new short[]{0, 0, 30, 60, 80, 100, 140, 180, 230};
    short[] expB = new short[]{0, 0, 10, 30, 40, 50, 60, 70, 100};

    private void _$9404() {
        for (int i = 0; i < this.numShots; ++i) {
            this.shots[i].type = 0;
        }
        this.firstEmpty = 0;
        this.activeShots = 0;
    }

    public void shoot(int n, int n2, int n3, int n4, byte by, int n5, int n6, Cannon cannon) {
        int n7 = FP.sinTab[n3];
        int n8 = FP.cosTab[n3];
        int n9 = FP.Mul(n7, FP.intToFP(n4) / 160);
        int n10 = FP.Mul(n8, FP.intToFP(n4) / 160);
        int n11 = n7 * 12;
        int n12 = n8 * 12;
        this.addShot(FP.intToFP(n) + n11, FP.intToFP(n2) + n12, n9, n10, by, n5, n6, cannon);
    }

    public boolean addShot(int n, int n2, int n3, int n4, byte by, int n5, int n6, Cannon cannon) {
        int n7;
        if (by == 0) {
            return false;
        }
        for (n7 = this.firstEmpty; n7 < this.numShots && this.shots[n7].type != 0; ++n7) {
        }
        if (n7 == this.numShots) {
            return false;
        }
        this.shots[n7].x = n;
        this.shots[n7].xsp = n3;
        this.shots[n7].y = n2;
        this.shots[n7].ysp = n4;
        this.shots[n7].type = by;
        this.shots[n7].val = n5;
        this.shots[n7].val2 = n6;
        this.shots[n7].ix = FP.toInt(n);
        this.shots[n7].iy = FP.toInt(n2);
        this.shots[n7].owner = cannon;
        ++this.activeShots;
        this.firstEmpty = n7;
        this.setMode((byte)1);
        return true;
    }

    private void _$9412(int n) {
        this.shots[n].type = 0;
        if (this.firstEmpty > n) {
            this.firstEmpty = n;
        }
        --this.activeShots;
    }

    public Terrain(GameScreen gameScreen, int n) {
        int n2;
        this.gs = gameScreen;
        this.numShots = 30;
        this.updateSkip = 3;
        this.ground = new short[1000];
        this.hole = new short[1000];
        this.loose = new short[1000];
        this.camY = new short[1000];
        this.bg = new short[1000];
        this.shots = new Shot[this.numShots];
        for (n2 = 0; n2 < this.numShots; ++n2) {
            this.shots[n2] = new Shot(this);
        }
        this.weaponImages = new Image[3];
        for (n2 = 0; n2 < this.weaponImages.length; ++n2) {
            this.weaponImages[n2] = Cannons.getImage("weapon".concat(String.valueOf(String.valueOf(n2))));
        }
        this._$9036 = new Delayer();
        this.cannons = new Cannon[n];
        this.reset();
        this._$9413();
    }

    private void _$9413() {
        this._$9361 = new int[32];
        this._$9362 = new int[32];
        for (int i = 0; i < 31; ++i) {
            int n = 90 - Cannon.atan(i * 100 / 8);
            this._$9361[i] = FP.cosTab[n];
            this._$9362[i] = FP.sinTab[n];
        }
        this._$9361[31] = FP.intToFP(-1);
        this._$9362[31] = FP.intToFP(0);
    }

    public void reset() {
        this.numCannons = 0;
        if (this.turnThread != null) {
            this.turnThread.stop = true;
        }
        this._$9404();
        this._$9188 = new SimpleRandom();
        this.mode = 0;
        this.trackMode = (byte)2;
        this.updateSkip = 3;
        this.scale = 1;
    }

    public void quit() {
        this.winner = -2;
        this.roundOver = true;
    }

    public void setRenderDimensions(int n, int n2) {
        this.renderWidth = n;
        this.renderHeight = n2;
        this.renderW2 = n / 2;
        this.renderH2 = n2 / 2;
    }

    public void setArmor(int n) {
        this.armor = n;
    }

    public void setWind(int n, int n2) {
        this.maxWind = n;
        this.windChange = n2;
    }

    public void clearCannons() {
        this.numCannons = 0;
    }

    public void setCannon(Cannon cannon, int n) {
        if (n >= this.numCannons) {
            this.numCannons = n + 1;
        }
        this.cannons[n] = cannon;
    }

    private void _$9423() {
        int n;
        int n2 = this.width / this.numCannons;
        int[] nArray = new int[this.numCannons];
        for (n = 0; n < this.numCannons; ++n) {
            nArray[n] = n;
        }
        for (n = 0; n < this.numCannons; ++n) {
            int n3 = n + Math.abs(this._$9188.nextInt() / 100 % (this.numCannons - n));
            int n4 = nArray[n3];
            nArray[n3] = nArray[n];
            nArray[n] = n4;
        }
        for (n = 0; n < this.numCannons; ++n) {
            this._$9427(nArray[n], n * n2 + n2 / 2 + this._$9188.nextInt() % (n2 / 2 - 8));
        }
    }

    public void setSeed(long l) {
        this._$9188.setSeed(l);
    }

    private void _$9427(int n, int n2) {
        this.cannons[n].x = n2;
        this.cannons[n].y = this.ground[this.cannons[n].x] + 7;
        for (int i = -10; i < 10; ++i) {
            if (this.cannons[n].x + i < 0 || this.cannons[n].x + i >= this.width) continue;
            this.ground[this.cannons[n].x + i] = (short)(this.cannons[n].y - 7);
        }
    }

    public void setMode(byte by) {
        this.mode = by;
    }

    public void setSize(int n, int n2) {
        this.width = n;
        this.grain = n2;
    }

    public void createRandomTerrain() {
        this.wind = this.maxWind == 0 ? 0 : FP.intToFP(this._$9188.nextInt() % this.maxWind) / 10000;
        int[] nArray = FractalGenerator.makeBrownianFractal(this.width, this.grain, 2559, this._$9188.nextLong());
        for (int i = 0; i < this.width; ++i) {
            this.ground[i] = (short)(nArray[i] / 10);
            this.hole[i] = 0;
            this.loose[i] = 0;
        }
    }

    private void _$9430() {
        int n;
        int n2 = 80;
        int n3 = n2 / 2;
        int n4 = 0;
        for (n = 0; n < n2; ++n) {
            n4 += this.ground[n];
        }
        for (n = 0; n < n3; ++n) {
            this.camY[n] = (short)(n4 / n2);
        }
        for (n = n3; n < this.width - n3; ++n) {
            this.camY[n] = (short)(n4 / n2);
            n4 -= this.ground[n - n3];
            n4 += this.ground[n + n3];
        }
        for (n = this.width - n3; n < this.width; ++n) {
            this.camY[n] = (short)(n4 / n2);
        }
    }

    public int playRound(long l) {
        this.setSeed(l);
        this.createRandomTerrain();
        for (int i = 0; i < this.numCannons; ++i) {
            this.cannons[i].reset();
            this.cannons[i].armor = this.armor;
        }
        this._$9423();
        this._$9430();
        this.active = 0;
        this.turnThread = new TurnThread();
        this.turnThread.start();
        this.roundOver = false;
        while (!this.roundOver) {
            this._$9036.delay(200);
        }
        this.turnThread.stop = true;
        return this.winner;
    }

    public void endRound(int n) {
        this.roundOver = true;
        this.winner = n;
    }

    public void doTurn() {
        if (this.cannons[this.active].alive) {
            int n = 0;
            for (int i = 0; i < this.numCannons; ++i) {
                if (!this.cannons[i].alive) continue;
                ++n;
            }
            if (n == 0) {
                this.endRound(-1);
                return;
            }
            if (n == 1) {
                this.endRound(this.active);
                return;
            }
            this.cannons[this.active].doTurn();
            while (this.mode == 1 || this.mode == 4) {
                this._$9036.delay(100);
            }
            this._$9036.delay(100);
        }
        if (this.windChange != 0) {
            this.wind += FP.intToFP(this._$9188.nextInt() % this.windChange) / 10000;
            if (this.wind > FP.intToFP(this.maxWind) / 10000) {
                this.wind = FP.intToFP(this.maxWind) / 10000;
            }
            if (this.wind < -FP.intToFP(this.maxWind) / 10000) {
                this.wind = -FP.intToFP(this.maxWind) / 10000;
            }
        }
        ++this.active;
        if (this.active == this.numCannons) {
            this.active = 0;
        }
    }

    public void setGrav(int n) {
        this.grav = FP.Div(FP.intToFP(n), FP.intToFP(1000));
    }

    public void printTerrain() {
        for (int i = 0; i < this.width; ++i) {
            System.out.println(this.ground[i]);
        }
    }

    public void changeScale() {
        if (this.width / 2 < this.renderWidth) {
            return;
        }
        ++this.scale;
        if (this.scale == 3) {
            this.scale = 1;
        }
    }

    public Cannon[] getCannons() {
        return this.cannons;
    }

    public int traceShot(int n, int n2, int n3, int n4) {
        int n5 = 0;
        while (!this.hits(FP.toInt(n), FP.toInt(n2), n5)) {
            ++n5;
            n2 += n4;
            n4 -= this.grav;
            if ((n += (n3 += this.wind)) < 0) {
                return 0;
            }
            if (n < FP.intToFP(this.width)) continue;
            return this.width - 1;
        }
        return FP.toInt(n);
    }

    private void _$9439() {
        for (int i = 0; i < this.numShots; ++i) {
            int n;
            int n2;
            Shot shot = this.shots[i];
            byte by = shot.type;
            if (by == 0) continue;
            shot.x += shot.xsp;
            shot.y += shot.ysp;
            if (this.gravAffects[shot.type]) {
                shot.ysp -= this.grav;
            }
            if (this.windAffects[shot.type]) {
                shot.xsp += this.wind;
            }
            shot.ix = FP.toInt(shot.x);
            shot.iy = FP.toInt(shot.y);
            if (shot.ix < 0 || shot.ix >= this.width) {
                this._$9412(i);
                continue;
            }
            if (shot.type == 1 || shot.type == 4 || shot.type == 5) {
                ++shot.val;
            }
            if (shot.type == 2 || shot.type == 3) {
                --shot.val;
                if (shot.val == 0) {
                    this._$9412(i);
                    continue;
                }
            }
            if (shot.type == 6 || shot.type == 8) {
                if (shot.val > 0) {
                    --shot.val;
                }
                if (shot.val == 0 || Math.abs(shot.xsp) + Math.abs(shot.ysp) < 12000) {
                    if (shot.type == 6) {
                        this.clusterExplode(shot.ix, shot.iy, shot.owner);
                    } else {
                        this._$9440(shot.ix, shot.iy, null, 6 + i % 4, 50, shot.owner);
                    }
                    this._$9412(i);
                    continue;
                }
                n2 = 0;
                for (n = 0; n < 4; ++n) {
                    int n3;
                    if (this.ground[FP.toInt(shot.x + shot.xsp)] < FP.toInt(shot.y + shot.ysp)) continue;
                    n2 = 1;
                    if (shot.val < 0) {
                        shot.val = 150;
                    }
                    if (Math.abs(n3 = (this.ground[shot.ix + 1] - this.ground[shot.ix - 1]) * 4) < 12) {
                        n3 = this.ground[shot.ix + 2] - this.ground[shot.ix - 2] * 2;
                    }
                    if (n3 > 31) {
                        n3 = 31;
                    }
                    if (n3 < -31) {
                        n3 = -31;
                    }
                    int n4 = 1;
                    if (n3 < 0) {
                        n3 = -n3;
                        n4 = -1;
                    }
                    int n5 = FP.Mul(this._$9361[n3], shot.xsp) - FP.Mul(this._$9362[n3] * n4, shot.ysp);
                    int n6 = FP.Mul(this._$9362[n3] * n4, shot.xsp) - FP.Mul(this._$9361[n3], shot.ysp);
                    shot.xsp = n5;
                    shot.ysp = n6;
                }
                if (n2 != 0) {
                    shot.xsp = shot.xsp * 2 / 3;
                    shot.ysp = shot.ysp * 2 / 3;
                }
            }
            if (shot.type == 7) {
                for (n2 = 0; n2 < 10; ++n2) {
                    this.addShot(shot.x, shot.y, shot.xsp + FP.intToFP(this._$9188.nextInt() % 40) / 100, shot.ysp + FP.intToFP(this._$9188.nextInt() % 40) / 100, (byte)4, 0, 0, shot.owner);
                }
                this._$9412(i);
            }
            if (shot.type == 3 || shot.type == 6 || shot.type == 8 || !this.hits(shot.ix, shot.iy, shot.val)) continue;
            if (shot.type == 1) {
                this._$9440(shot.ix, shot.iy, _$9360, 16, 500, shot.owner);
            }
            if (shot.type == 9) {
                this._$9440(shot.ix, shot.iy, _$9360, 16, 500, shot.owner);
                for (n2 = 0; n2 < 16; ++n2) {
                    this.addShot(shot.x, shot.y, FP.intToFP(this._$9188.nextInt() % 200) / 100, FP.intToFP(this._$9188.nextInt() % 200) / 100, (byte)8, 120, 0, shot.owner);
                }
            }
            if (shot.type == 4) {
                this._$9440(shot.ix, shot.iy, null, 6 + i % 4, 50, shot.owner);
            }
            if (shot.type == 5) {
                this.clusterExplode(shot.ix, shot.iy, shot.owner);
            }
            if (shot.type == 10) {
                n2 = (short)Math.min(this.ground[shot.ix] + 30, 255);
                for (n = -5; n <= 5; ++n) {
                    this.ground[shot.ix + n] = n2;
                }
            }
            this._$9412(i);
        }
    }

    public void clusterExplode(int n, int n2, Cannon cannon) {
        this._$9440(n, n2, _$9360, 16, 100, cannon);
        n = FP.intToFP(n);
        n2 = FP.intToFP(n2);
        for (int i = 0; i < 16; ++i) {
            this.addShot(n, n2, FP.intToFP(this._$9188.nextInt() % 200) / 100, FP.intToFP(this._$9188.nextInt() % 200) / 100, (byte)4, 0, 0, cannon);
        }
    }

    public boolean hits(int n, int n2, int n3) {
        if (this.ground[n] >= n2) {
            return true;
        }
        if (n3 >= 8) {
            for (int i = 0; i < this.numCannons; ++i) {
                if (!this.cannons[i].alive || n <= this.cannons[i].x - 7 || n >= this.cannons[i].x + 7 || n2 <= this.cannons[i].y - 5 || n2 >= this.cannons[i].y + 5) continue;
                return true;
            }
        }
        return false;
    }

    private void _$9440(int n, int n2, int[] nArray, int n3, int n4, Cannon cannon) {
        if (nArray != null) {
            this._$9446(n, n2, nArray);
        }
        for (int i = 0; i < this.numCannons; ++i) {
            if (!this.cannons[i].alive) continue;
            this.cannons[i].explosionNotify(n, n2, cannon);
            int n5 = Math.abs(n - this.cannons[i].x);
            int n6 = Math.abs(n2 - this.cannons[i].y);
            n5 = Math.max(n5 - 8, 0);
            n6 = Math.max(n6 - 8, 0);
            int n7 = 100 / ((n5 + n6 + 6) / 6);
            if (n7 < 10) continue;
            this.cannons[i].hit(n4 * n7 / 100);
        }
        this.addShot(FP.intToFP(n), FP.intToFP(n2), 0, 0, (byte)3, 9 * this.updateSkip - 1, n3, cannon);
    }

    private void _$9446(int n, int n2, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            short s;
            short s2;
            int n3 = nArray[i];
            if (n - i >= 0 && n - i < this.width - 1) {
                s2 = this.ground[n - i];
                s = (short)(n2 - n3);
                if (s < 0) {
                    s = 0;
                }
                if (s2 > s) {
                    if (s2 > n2 + n3) {
                        this.loose[n - i] = (short)(s2 - (n2 + n3));
                        this.hole[n - i] = (short)(n2 + n3 - s);
                    }
                    this.ground[n - i] = s;
                }
            }
            if (n + i < 0 || n + i >= this.width - 1) continue;
            s2 = this.ground[n + i];
            s = (short)(n2 - n3);
            if (s < 0) {
                s = 0;
            }
            if (s2 <= s) continue;
            if (s2 > n2 + n3) {
                this.loose[n + i] = (short)(s2 - (n2 + n3));
                this.hole[n + i] = (short)(n2 + n3 - s);
            }
            this.ground[n + i] = s;
        }
    }

    public int getTankHeight(int n) {
        int n2 = 0;
        for (int i = -8; i < 8; ++i) {
            if (n + i < 0 || n + i > this.width) continue;
            int n3 = n + i;
            n2 = this.hole[n3] > 0 ? Math.max(this.ground[n3] + this.hole[n3] + this.loose[n3], n2) : Math.max(this.ground[n3], n2);
        }
        return n2 + 7;
    }

    public void resetControls() {
        this.rightOnce = false;
        this.right = false;
        this.leftOnce = false;
        this.left = false;
        this.downOnce = false;
        this.down = false;
        this.upOnce = false;
        this.up = false;
    }

    public void update(Graphics graphics, boolean bl) {
        String string = "";
        try {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            for (n8 = 0; n8 < this.numCannons; ++n8) {
                if (!this.cannons[n8].alive) continue;
                this.cannons[n8].update();
            }
            graphics.setColor(0, 0, 48);
            graphics.fillRect(0, 0, this.renderWidth, this.renderHeight);
            graphics.setClip(0, 16, this.renderWidth, this.renderHeight - 16);
            if (this.mode == 1) {
                if (this.activeShots == 0) {
                    this.mode = (byte)2;
                } else {
                    for (n8 = 0; n8 < this.numShots && this.shots[n8].type == 0; ++n8) {
                    }
                    if (!bl) {
                        this.renderCX = this.shots[n8].ix;
                        if (this.trackMode == 2) {
                            this.renderCY = this.shots[n8].iy;
                            if (this.renderCY > this.camY[this.renderCX] + 80) {
                                this.renderCY = this.camY[this.renderCX] + 80;
                            }
                        } else {
                            this.renderCY = this.trackMode == 0 ? this.camY[this.renderCX] + 30 : this.shots[n8].iy;
                        }
                    }
                    for (n7 = 0; n7 < this.updateSkip; ++n7) {
                        this._$9439();
                    }
                }
            }
            if (this.mode == 0 && !bl) {
                this.renderCX = this.cannons[this.active].x;
                this.renderCY = this.cannons[this.active].y + 30;
            }
            if (bl) {
                this.renderCX = this.freeViewCX;
                this.renderCY = this.freeViewCY;
                if (this.left || this.leftOnce) {
                    this.freeViewCX -= 10 * this.scale;
                    if (this.freeViewCX < 0 + this.renderW2 * this.scale) {
                        this.freeViewCX = 0 + this.renderW2 * this.scale;
                    }
                    this.leftOnce = false;
                }
                if (this.right || this.rightOnce) {
                    this.freeViewCX += 10 * this.scale;
                    if (this.freeViewCX >= this.width - this.renderW2 * this.scale) {
                        this.freeViewCX = this.width - this.renderW2 * this.scale - 1;
                    }
                    this.rightOnce = false;
                }
                if (this.up || this.upOnce) {
                    this.freeViewCY += 10 * this.scale;
                    if (this.freeViewCY > 285) {
                        this.freeViewCY = 285;
                    }
                    this.upOnce = false;
                }
                if (this.down || this.downOnce) {
                    this.freeViewCY -= 10 * this.scale;
                    if (this.freeViewCY < 0) {
                        this.freeViewCY = 0;
                    }
                    this.downOnce = false;
                }
            } else {
                this.freeViewCX = this.renderCX;
                this.freeViewCY = this.renderCY;
            }
            n8 = this.width;
            n7 = 0;
            for (n6 = 0; n6 < this.width; ++n6) {
                if (this.hole[n6] == 0) continue;
                if (n6 < n8) {
                    n8 = n6;
                }
                if (n6 > n7) {
                    n7 = n6;
                }
                int n9 = n6;
                this.hole[n9] = (short)(this.hole[n9] - 1);
                if (this.hole[n6] != 0) continue;
                int n10 = n6;
                this.ground[n10] = (short)(this.ground[n10] + this.loose[n6]);
                if (this.ground[n6] <= 255) continue;
                this.ground[n6] = 255;
            }
            if (n8 < n7) {
                this.renderCX = (n8 + n7) / 2;
                this.renderCY = this.camY[this.renderCX] + 30;
                if (this.mode == 2) {
                    this.mode = (byte)4;
                }
            } else if (this.mode == 4) {
                this._$9430();
                this.mode = (byte)2;
            }
            n6 = this.renderCX - this.renderW2 * this.scale;
            int n11 = this.renderCY - this.renderH2 * this.scale;
            if (n6 < 0) {
                n6 = 0;
            }
            if (n11 < 0) {
                n11 = 0;
            }
            if (n6 + this.renderWidth * this.scale >= this.width) {
                n6 = this.width - this.renderWidth * this.scale - 1;
            }
            int n12 = n6 + this.renderWidth * this.scale;
            int n13 = n11 + this.renderHeight * this.scale - 16;
            string = "Updating cannons";
            for (n5 = 0; n5 < this.numCannons; ++n5) {
                string = String.valueOf(String.valueOf(new StringBuffer("Updating cannon ").append(n5).append(": ").append(this.cannons[n5])));
                if (!this.cannons[n5].alive || this.cannons[n5].x <= n6 || this.cannons[n5].x >= n12) continue;
                n4 = (this.cannons[n5].x - n6) / this.scale;
                n3 = this.renderHeight - (this.cannons[n5].y - n11) / this.scale;
                n2 = FP.sinTab[this.cannons[n5].getTrueAngle()];
                n = FP.cosTab[this.cannons[n5].getTrueAngle()];
                graphics.setColor(120, 120, 120);
                graphics.drawRect(n4 - 9, n3 - 18, 17, 4);
                graphics.setColor(0, 255, 0);
                graphics.fillRect(n4 - 8, n3 - 17, this.cannons[n5].hits * 16 / 1000, 3);
                graphics.drawImage(this.cannons[n5].getImage(), n4, n3, 3);
                graphics.setColor(this.cannons[n5].red, this.cannons[n5].green, this.cannons[n5].blue);
                graphics.drawLine(n4, n3 - 4 / this.scale, n4 + FP.toInt(n2 * 14 / this.scale), n3 - 4 / this.scale - FP.toInt(n * 14 / this.scale));
                graphics.drawString(this.cannons[n5].name, n4, n3 - 20, 65);
                if (this.mode != 0 || n5 != this.active) continue;
                graphics.setColor(0, 100, 255);
                graphics.drawArc(n4 - 4 / this.scale + FP.toInt(FP.Mul(n2, FP.intToFP(80 / this.scale))), n3 - 8 / this.scale - FP.toInt(FP.Mul(n, FP.intToFP(80 / this.scale))), 8 / this.scale, 8 / this.scale, 0, 360);
                graphics.setColor(255, 100, 100);
                graphics.drawArc(n4 - 3 / this.scale + FP.toInt(FP.Mul(n2, FP.intToFP(20 / this.scale + this.cannons[n5].power * 50 / 1000 / this.scale))), n3 - 7 / this.scale - FP.toInt(FP.Mul(n, FP.intToFP(20 / this.scale + this.cannons[n5].power * 50 / 1000 / this.scale))), 6 / this.scale, 6 / this.scale, 0, 360);
            }
            string = "Rendering terrain";
            graphics.setColor(60, 80, 160);
            for (n5 = 0; n5 < this.renderWidth; ++n5) {
                n4 = n5 * this.scale + n6;
                graphics.drawLine(n5, this.renderHeight - (this.ground[n4] - n11) / this.scale, n5, this.renderHeight);
                if (this.hole[n4] == 0) continue;
                graphics.drawLine(n5, this.renderHeight - (this.ground[n4] + this.hole[n4] + this.loose[n4] - n11) / this.scale, n5, this.renderHeight - (this.ground[n4] + this.hole[n4] - n11) / this.scale);
            }
            string = "Updating shots";
            for (n5 = 0; n5 < this.numShots; ++n5) {
                if (this.shots[n5].type == 0) continue;
                Shot shot = this.shots[n5];
                string = "s1";
                if (shot.ix < n6 - 16 || shot.ix >= n12 + 16 || shot.iy < n11 - 16) continue;
                n3 = (shot.ix - n6) / this.scale;
                n2 = (shot.iy - n13) / this.scale;
                string = "s2";
                if (shot.iy < n13) {
                    if (shot.type == 3) {
                        string = "s3";
                        n = shot.val / this.updateSkip;
                        string = "s3: ".concat(String.valueOf(String.valueOf(n)));
                        graphics.setColor((int)this.expR[n], (int)this.expG[n], (int)this.expB[n]);
                        graphics.fillArc(n3 - shot.val2, this.renderHeight - (shot.iy - n11) / this.scale - shot.val2, shot.val2 * 2, shot.val2 * 2, 0, 360);
                        continue;
                    }
                    if (shot.type == 4) {
                        string = "s4";
                        graphics.setColor(255, 255, 255);
                        graphics.drawLine(n3, this.renderHeight - (shot.iy - n11) / this.scale, n3, this.renderHeight - (shot.iy - n11) / this.scale);
                        continue;
                    }
                    if (shot.type == 8) {
                        graphics.setColor(255, 200, 100);
                        graphics.drawLine(n3, this.renderHeight - (shot.iy - n11) / this.scale, n3, this.renderHeight - (shot.iy - n11) / this.scale);
                        continue;
                    }
                    if (shot.type == 10) {
                        graphics.setColor(100, 200, 100);
                        graphics.fillArc(n3 - 2, this.renderHeight - (shot.iy - n11) / this.scale - 2, 4, 4, 0, 360);
                        continue;
                    }
                    graphics.setColor(255, 255, 255);
                    graphics.fillArc(n3 - 2, this.renderHeight - (shot.iy - n11) / this.scale - 2, 4, 4, 0, 360);
                    continue;
                }
                string = "s5";
                graphics.setColor(255, 255, 255);
                graphics.drawLine(n3, 16, n3, 26 + n2 / 10);
                graphics.drawLine(n3 - 3, 26 + n2 / 10, n3 + 3, 26 + n2 / 10);
                graphics.drawLine(n3 - 3, 26, n3 + 3, 26);
                graphics.drawLine(n3, 16, n3 - 3, 20);
                graphics.drawLine(n3, 16, n3 + 3, 20);
            }
            graphics.setClip(0, 0, this.renderWidth, this.renderHeight);
            graphics.setColor(255, 255, 255);
            graphics.drawString(this.cannons[this.active].name, 2, 0, 20);
            if (this.mode == 0 && this.gs.lpc != null) {
                LocalPlayerCannon localPlayerCannon = this.gs.lpc;
                graphics.setColor(160, 200, 255);
                String string2 = String.valueOf(String.valueOf(new StringBuffer("Ang:").append(Integer.toString(localPlayerCannon.angle)).append(" Pow:").append(Integer.toString(localPlayerCannon.power))));
                n3 = localPlayerCannon.mode;
                if (n3 == 1) {
                    string2 = String.valueOf(String.valueOf(string2)).concat(" Fine");
                }
                if (n3 == 2) {
                    string2 = String.valueOf(String.valueOf(string2)).concat(" ExFine");
                }
                graphics.drawString(string2, 2, 16, 20);
                String string3 = localPlayerCannon.getShotsLeft() == -1 ? "inf" : Integer.toString(localPlayerCannon.getShotsLeft());
                graphics.drawString(": ".concat(String.valueOf(String.valueOf(string3))), this.renderWidth - 16, 0, 24);
                graphics.drawImage(this.weaponImages[this.weaponImageMapping[localPlayerCannon.getSelectedWeapon()]], this.renderWidth, 0, 24);
            }
            graphics.setColor(255, 255, 255);
            String string4 = "";
            if (bl) {
                string4 = String.valueOf(String.valueOf(string4)).concat("F");
            }
            if (this.gs.moveView) {
                string4 = String.valueOf(String.valueOf(string4)).concat(" M");
            }
            if (this.scale != 1) {
                string4 = String.valueOf(String.valueOf(string4)).concat(String.valueOf(String.valueOf(" X".concat(String.valueOf(String.valueOf(this.scale))))));
            }
            graphics.drawString(string4, 2, 32, 20);
            int n14 = this.renderWidth - 30;
            n3 = this.renderWidth - 30 + FP.toInt(this.wind * 1000);
            graphics.drawLine(n14, 22, n3, 22);
            if (this.wind > 0) {
                graphics.drawLine(n3, 22, n3 - 4, 18);
                graphics.drawLine(n3, 22, n3 - 4, 26);
            }
            if (this.wind < 0) {
                graphics.drawLine(n3, 22, n3 + 4, 18);
                graphics.drawLine(n3, 22, n3 + 4, 26);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception at update(), phase = ".concat(String.valueOf(String.valueOf(string))));
            exception.printStackTrace();
        }
    }

    public void cleanUp() {
        if (this.turnThread != null) {
            this.turnThread.stop = true;
        }
    }

    static {
        maxWidth = 1000;
        MODE_LOCALAIM = 0;
        MODE_TRACKSHOT = 1;
        MODE_WAIT = (byte)2;
        MODE_FREEVIEW = (byte)3;
        MODE_TRACKHOLE = (byte)4;
        TRACK_GROUND = 0;
        TRACK_SHOT = 1;
        TRACK_MIXED = (byte)2;
        DRAW = -1;
        QUIT = -2;
        _$9358 = new int[]{6, 6, 5, 5, 4, 2};
        _$9359 = new int[]{8, 8, 7, 7, 6, 5, 4, 2};
        _$9360 = new int[]{16, 16, 16, 16, 15, 15, 15, 14, 14, 13, 13, 12, 11, 9, 7, 4};
        SHOT_NONE = 0;
        SHOT_PELLET = 1;
        SHOT_DEBRIS = (byte)2;
        SHOT_EXPL = (byte)3;
        SHOT_SMALLBOMB = (byte)4;
        SHOT_CLUSTER = (byte)5;
        SHOT_GRENADE = (byte)6;
        SHOT_SHOTGUN = (byte)7;
        SHOT_SMALLGRENADE = (byte)8;
        SHOT_GRENADECLUSTER = (byte)9;
        SHOT_WALLRAISER = (byte)10;
    }

    private class TurnThread
    extends Thread {
        boolean stop = false;

        public void run() {
            do {
                Terrain.this.doTurn();
            } while (!this.stop);
        }
    }

    public class Shot {
        int x;
        int y;
        int xsp;
        int ysp;
        int ix;
        int iy;
        byte type;
        int val;
        int val2;
        Cannon owner;

        public Shot(Terrain terrain) {
        }
    }
}

