/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class BabyCanvas
extends Canvas
implements Runnable,
CommandListener {
    public static T720Constant c = new T720Constant();
    public static final int X_SCREEN = 120;
    public static final int Y_SCREEN = 115;
    public String readyStr;
    public String debugStr;
    public int stringCounterMax;
    public int stringCounter;
    public static int SCALE = BabyCanvas.c.SCALE;
    public static int MAX_WALL_HEIGHT = 30;
    public static int MIN_WALL_HEIGHT = 5;
    public static int INIT_WALL_HEIGHT = MAX_WALL_HEIGHT >> 1;
    public static int WALL_WIDTH = 10;
    public static int WALL_COUNT = 120 / WALL_WIDTH;
    public static int WALL_COLOR = 13052672;
    public int[] wallHeight;
    public int wallPointer;
    public int wallNext;
    public int wallChange;
    public static int BLOCK_WIDTH = T720Constant.BLOCK_WIDTH;
    public static int BLOCK_HEIGHT = T720Constant.BLOCK_HEIGHT;
    public static int BLOCK_COUNT = WALL_COUNT;
    public static final int BLOCK_INTERVAL = 12;
    public static int BACKGROUND_COLOR = 0x720000;
    public int xShift;
    public static int BLOCK_RANGE = 115 - MAX_WALL_HEIGHT - MAX_WALL_HEIGHT;
    public static int MIN_BLOCK_Y = MAX_WALL_HEIGHT;
    public static int MAX_BLOCK_Y = MIN_BLOCK_Y + BLOCK_RANGE - BLOCK_HEIGHT;
    public int[] blockY;
    public int blockCountDown;
    public static int SPERM_X = T720Constant.SPERM_X;
    public static int SPERM_Y = T720Constant.SPERM_Y;
    public static int SPERM_SHIFT = T720Constant.SPERM_SHIFT;
    public static int GRAVITY = T720Constant.GRAVITY;
    public static int UP_FORCE = T720Constant.UP_FORCE;
    public static int MAX_SPEED = T720Constant.MAX_SPEED;
    public static int SLEEP_TIME = T720Constant.SLEEP_TIME;
    public int xPos;
    public int yPos;
    public int ySpeed;
    public int acceleration;
    public static int ENERGY_X = 4;
    public static int ENERGY_Y = 133;
    public static int ENERGY_WIDTH = 75;
    public static int ENERGY_HEIGHT = 3;
    public static int[] ENERGY_SCALE = T720Constant.ENERGY_SCALE;
    public static int ENERGY_COLOR = 0xFFF500;
    public static int ENERGY_MAX = T720Constant.ENERGY_MAX;
    public int energy;
    public static int DIGIT_WIDTH = 8;
    public static int DIGIT_HEIGHT = 17;
    public static int DIGIT_X = 84;
    public static int DIGIT_Y = 120;
    public static int STRING_COLOR = 0xFFFFFF;
    public static int STRING_X = 10;
    public static int STRING_Y = 37;
    public static int GAMEOVER_X = 35;
    public static int GAMEOVER_Y = 22;
    int score;
    public static final int DIR_UP = 50;
    public static final int DIR_DOWN = -60;
    public static final int DIR_UP2 = -10;
    public static final int START_STOP = 0;
    public static final int START_STOP2 = 0;
    public static final int STEP_BY_STEP = 0;
    public static final int STEP_BY_STEP2 = 0;
    public static final int RESTART = 48;
    public static final int RESTART2 = -901;
    public int collision;
    public int collisionBlock;
    boolean runFlag;
    boolean running;
    MyRandom rand;
    public GameEffect effect;
    public Command commandExit;
    public Command commandChange;
    public static Image[] spermImage = null;
    public int iFrame;
    public static Image backgroundImage = null;
    public static Image panelImage = null;
    public static Image blockImage = null;
    public static Image[] digitImage = null;
    boolean refreshPanel;
    boolean refreshEnergy;

    static {
        spermImage = new Image[2];
        BabyCanvas.spermImage[0] = BabyCanvas.LoadImage("/player01.png");
        BabyCanvas.spermImage[1] = BabyCanvas.LoadImage("/player02.png");
        backgroundImage = BabyCanvas.LoadImage("/background.png");
        panelImage = BabyCanvas.LoadImage("/panel.png");
        blockImage = BabyCanvas.LoadImage("/block.png");
        BabyCanvas.LoadDigits("/digits.png");
    }

    public BabyCanvas() {
        this.debugStr = this.readyStr = "Ready? Press Up!";
        this.stringCounter = this.stringCounterMax = 5;
        this.wallHeight = new int[WALL_COUNT];
        this.wallPointer = 0;
        this.wallNext = INIT_WALL_HEIGHT;
        this.wallChange = 1;
        this.xShift = 0;
        this.blockY = new int[BLOCK_COUNT];
        this.blockCountDown = 12;
        this.xPos = WALL_WIDTH * SPERM_SHIFT;
        this.yPos = 57;
        this.ySpeed = 0;
        this.acceleration = 0;
        this.energy = ENERGY_MAX;
        this.score = 0;
        this.collision = 0;
        this.collisionBlock = 0;
        this.runFlag = true;
        this.running = false;
        this.rand = new MyRandom();
        this.effect = null;
        this.commandExit = null;
        this.commandChange = null;
        this.iFrame = 0;
        this.refreshPanel = true;
        this.refreshEnergy = true;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.effect = this.CreateGameEffect();
        this.initGame();
    }

    public GameEffect CreateGameEffect() {
        GameEffect gameEffect = new GameEffect();
        return gameEffect;
    }

    private static void LoadDigits(String string) {
        Image image = BabyCanvas.LoadImage(string);
        digitImage = new Image[10];
        int n = 0;
        while (n < 10) {
            BabyCanvas.digitImage[n] = Image.createImage((int)DIGIT_WIDTH, (int)DIGIT_HEIGHT);
            Graphics graphics = digitImage[n].getGraphics();
            graphics.drawImage(image, -n * DIGIT_WIDTH, 0, 20);
            ++n;
        }
    }

    public static Image LoadImage(String string) {
        Image image = null;
        try {
            image = Image.createImage((String)string);
        }
        catch (Exception exception) {
            System.out.println("Error loading image: " + string);
            System.out.println(exception);
        }
        return image;
    }

    public int collisionDetect() {
        int n;
        int n2 = this.wallPointer + SPERM_SHIFT;
        if (n2 >= WALL_COUNT) {
            n2 -= WALL_COUNT;
        }
        int n3 = n = this.wallHeight[n2];
        int n4 = 115 - (MAX_WALL_HEIGHT - n) - SPERM_Y - 1;
        if (this.yPos <= n3 || this.yPos >= n4) {
            ++this.collision;
            return 1;
        }
        int n5 = this.blockY[n2];
        if (n5 <= 0) {
            return 0;
        }
        n3 = n5 - SPERM_Y;
        n4 = n5 + BLOCK_HEIGHT;
        if (this.yPos >= n3 && this.yPos <= n4) {
            ++this.collisionBlock;
            return 2;
        }
        return 0;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.commandExit) {
            this.runFlag = false;
            Baby.quitApp();
        }
    }

    public void frameAction() {
        int n;
        int n2;
        if (this.stringCounter == 0) {
            this.debugStr = "";
        } else {
            --this.stringCounter;
        }
        ++this.score;
        if (this.score > 9999) {
            this.score = 9999;
        }
        this.ySpeed = this.ySpeed + GRAVITY + this.acceleration;
        if (Math.abs(this.ySpeed) > MAX_SPEED) {
            this.ySpeed = this.ySpeed > 0 ? MAX_SPEED : -MAX_SPEED;
        }
        this.yPos += this.ySpeed;
        if (this.yPos >= 115 - SPERM_Y) {
            this.yPos = 115 - SPERM_Y - 1;
        }
        if (this.yPos < 0) {
            this.yPos = 0;
        }
        if ((n2 = this.rand.nextInt(4)) <= 4) {
            this.wallChange = n2 - 2;
        }
        this.wallNext += this.wallChange;
        if (this.wallNext < MIN_WALL_HEIGHT) {
            this.wallNext = MIN_WALL_HEIGHT;
            this.wallChange = -this.wallChange;
        }
        if (this.wallNext > MAX_WALL_HEIGHT - MIN_WALL_HEIGHT) {
            this.wallNext = MAX_WALL_HEIGHT - MIN_WALL_HEIGHT;
            this.wallChange = -this.wallChange;
        }
        this.wallHeight[this.wallPointer] = this.wallNext;
        this.blockY[this.wallPointer] = -1;
        --this.blockCountDown;
        if (this.blockCountDown <= 0) {
            this.blockCountDown = 12;
            n = this.rand.nextInt(5) + MIN_BLOCK_Y;
            if (n > MAX_BLOCK_Y) {
                n = MAX_BLOCK_Y;
            }
            int n3 = (this.wallPointer + WALL_COUNT) % WALL_COUNT;
            this.blockY[n3] = n;
        }
        ++this.wallPointer;
        if (this.wallPointer >= WALL_COUNT) {
            this.wallPointer = 0;
        }
        if ((n = this.collisionDetect()) == 1) {
            if (this.energy > 0) {
                --this.energy;
            }
            this.refreshEnergy = true;
            this.effect.vibrate();
        }
        if (n == 2) {
            if (this.energy > 0) {
                --this.energy;
            }
            this.refreshEnergy = true;
            this.effect.vibrate();
        }
    }

    public void initGame() {
        int n = 0;
        while (n < WALL_COUNT) {
            this.wallHeight[n] = INIT_WALL_HEIGHT;
            this.blockY[n] = -1;
            ++n;
        }
        this.wallPointer = 0;
        this.wallChange = 1;
        this.wallNext = this.wallHeight[this.wallPointer];
        this.yPos = 57;
        this.ySpeed = 0;
        this.acceleration = 0;
        this.energy = ENERGY_MAX;
        this.score = 0;
        this.refreshEnergy = true;
        this.refreshPanel = true;
        this.debugStr = this.readyStr;
        this.stringCounter = this.stringCounterMax;
    }

    private void jbInit() throws Exception {
        this.setCommandListener(this);
        this.commandExit = new Command("Exit", 4, 2);
        this.addCommand(this.commandExit);
    }

    protected void keyPressed(int n) {
        switch (n) {
            case -10: 
            case 50: {
                this.acceleration = UP_FORCE;
                if (this.ySpeed > 0) {
                    this.ySpeed = 0;
                }
                this.running = true;
                break;
            }
            case -901: 
            case 48: {
                this.running = false;
                this.initGame();
            }
        }
    }

    protected void keyReleased(int n) {
        switch (n) {
            case -10: 
            case 50: {
                this.acceleration = 0;
            }
        }
    }

    protected void paint(Graphics graphics) {
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, 120, 115);
        this.paintBackground(graphics);
        graphics.setColor(0);
        this.paintWall(graphics);
        this.paintBlock(graphics);
        this.paintSperm(graphics);
        if (this.refreshPanel) {
            this.refreshPanel = false;
            this.paintPanel(graphics);
        }
        if (this.refreshEnergy) {
            this.refreshEnergy = false;
            this.paintEnergy(graphics);
        }
        this.paintScore(graphics);
        if (this.energy == 0) {
            this.paintGameOver(graphics);
        }
        if (!"".equals(this.debugStr)) {
            graphics.setColor(STRING_COLOR);
            graphics.drawString(this.debugStr, STRING_X, STRING_Y, 20);
        }
    }

    public void paintBackground(Graphics graphics) {
        graphics.setColor(BACKGROUND_COLOR);
        graphics.fillRect(0, 0, 120, 115);
        graphics.drawImage(backgroundImage, 0, 0, 20);
    }

    public void paintBlock(Graphics graphics) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = n2 = this.wallPointer;
        while (n4 < WALL_COUNT) {
            n = this.blockY[n4];
            if (n != -1) {
                graphics.drawImage(blockImage, n3, n, 20);
            }
            ++n4;
            n3 += WALL_WIDTH;
        }
        int n5 = 0;
        while (n5 < n2) {
            n = this.blockY[n5];
            if (n != -1) {
                graphics.drawImage(blockImage, n3, n, 20);
            }
            ++n5;
            n3 += WALL_WIDTH;
        }
    }

    public void paintEnergy(Graphics graphics) {
        int n = 0;
        n = this.energy >= 0 && this.energy <= ENERGY_MAX ? ENERGY_SCALE[this.energy] : 0;
        graphics.setColor(0);
        graphics.fillRect(ENERGY_X + n, ENERGY_Y, ENERGY_WIDTH - n, ENERGY_HEIGHT);
    }

    public void paintGameOver(Graphics graphics) {
        graphics.setColor(STRING_COLOR);
        graphics.drawString("Game Over!", GAMEOVER_X, GAMEOVER_Y, 20);
        graphics.drawString("Press 0 to Restart", STRING_X, STRING_Y, 20);
    }

    public void paintPanel(Graphics graphics) {
        graphics.drawImage(panelImage, 0, 115, 20);
        graphics.setColor(ENERGY_COLOR);
        graphics.fillRect(ENERGY_X, ENERGY_Y, ENERGY_WIDTH, ENERGY_HEIGHT);
    }

    public void paintScore(Graphics graphics) {
        int n = 4;
        String string = String.valueOf(this.score);
        int n2 = string.length();
        int n3 = 4 - n2;
        int n4 = DIGIT_X;
        int n5 = n2;
        while (n5 < 4) {
            ++n5;
            n4 += DIGIT_WIDTH + 1;
        }
        int n6 = 0;
        while (n6 < n2) {
            int n7 = string.charAt(n6) - 48;
            if (n7 < 0 || n7 > 9) {
                n7 = 8;
            }
            graphics.drawImage(digitImage[n7], n4, DIGIT_Y, 20);
            ++n6;
            n4 += DIGIT_WIDTH + 1;
        }
    }

    public void paintSperm(Graphics graphics) {
        this.iFrame = 1 - this.iFrame;
        graphics.drawImage(spermImage[this.iFrame], this.xPos, this.yPos, 20);
    }

    public void paintWall(Graphics graphics) {
        int n;
        int n2;
        int n3 = 0xBB0000;
        graphics.setColor(n3);
        int n4 = 0;
        int n5 = n2 = this.wallPointer;
        while (n5 < WALL_COUNT) {
            n = MAX_WALL_HEIGHT - this.wallHeight[n5];
            if (n < 0) {
                n = 0;
            }
            graphics.fillRect(n4, 0, WALL_WIDTH, this.wallHeight[n5]);
            graphics.fillRect(n4, 115 - n, WALL_WIDTH, n);
            ++n5;
            n4 += WALL_WIDTH;
        }
        n = 0;
        while (n < n2) {
            int n6 = MAX_WALL_HEIGHT - this.wallHeight[n];
            if (n6 < 0) {
                n6 = 0;
            }
            graphics.fillRect(n4, 0, WALL_WIDTH, this.wallHeight[n]);
            graphics.fillRect(n4, 115 - n6, WALL_WIDTH, n6);
            ++n;
            n4 += WALL_WIDTH;
        }
    }

    public void run() {
        int n;
        int n2 = n = 20;
        this.runFlag = true;
        while (this.runFlag) {
            if (this.energy <= 0) {
                this.running = false;
            }
            if (!this.running) {
                this.repaint();
                try {
                    Thread.sleep(SLEEP_TIME);
                }
                catch (Exception exception) {}
                continue;
            }
            long l = System.currentTimeMillis();
            this.frameAction();
            this.repaint();
            long l2 = System.currentTimeMillis();
            try {
                long l3 = SLEEP_TIME;
                if ((l3 -= l2 - l) > 0L) {
                    Thread.sleep(l3);
                }
            }
            catch (Exception exception) {}
            if (--n2 > 0) continue;
            n2 = n;
            System.gc();
        }
    }
}

