/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;

class AtomicGUI
extends Canvas
implements CommandListener,
Runnable {
    private Display iDisplay;
    private Command iBack;
    private Command iHelp;
    private Command iPlay;
    private final int boardWidth;
    private final int boardHeight;
    private int boardOriginX;
    private int boardOriginY;
    private int boardRows = 6;
    private int boardColumns = 6;
    private int boardSquareSize = 15;
    private int[][] board;
    private Board gameBoard;
    private AtomicAI iAtomicAI;
    private int iAIIntelligence;
    private int selectedX = 0;
    private int selectedY = 0;
    private int playerTurn = 0;
    private int playerLost = 0;
    private int playerHasHadATurn = 0;
    private int iNumPlayers;
    private int iNumHumans;
    private int iNumComputers;
    private int[] player;
    private int iMove = 0;
    public boolean iGameOver;
    private final int SQUARE_EMPTY;
    private final int SQUARE_ONE_ATOM;
    private final int SQUARE_TWO_ATOMS;
    private final int SQUARE_THREE_ATOMS;
    private final int SQUARE_FOUR_ATOMS;
    private final int SQUARE_BANG;
    private final int SQUARE_PLAYER1;
    private final int SQUARE_PLAYER2;
    private final int SQUARE_PLAYER3;
    private final int SQUARE_PLAYER4;
    private final int SQUARE_REMOVE_SELECTED;
    private final int SQUARE_BLANK;
    private final int SQUARE_FRAME_1;
    private final int SQUARE_FRAME_2;
    private final int SQUARE_FRAME_3;
    private final int COMPUTER_PLAYER;
    private final int PLAYER_MASK;
    private final int ATOM_COUNT_MASK;
    private final int FRAME_MASK;
    private Image iRed1Atoms_3;
    private Image iRed2Atoms_1;
    private Image iRed2Atoms_2;
    private Image iRed2Atoms_3;
    private Image iRed3Atoms_1;
    private Image iRed3Atoms_2;
    private Image iRed3Atoms_3;
    private Image iRed4Atoms_1;
    private Image iRed4Atoms_2;
    private Image iRed4Atoms_3;
    private Image iBlue1Atoms_3;
    private Image iBlue2Atoms_1;
    private Image iBlue2Atoms_2;
    private Image iBlue2Atoms_3;
    private Image iBlue3Atoms_1;
    private Image iBlue3Atoms_2;
    private Image iBlue3Atoms_3;
    private Image iBlue4Atoms_1;
    private Image iBlue4Atoms_2;
    private Image iBlue4Atoms_3;
    private Image iYellow1Atoms_3;
    private Image iYellow2Atoms_1;
    private Image iYellow2Atoms_2;
    private Image iYellow2Atoms_3;
    private Image iYellow3Atoms_1;
    private Image iYellow3Atoms_2;
    private Image iYellow3Atoms_3;
    private Image iYellow4Atoms_1;
    private Image iYellow4Atoms_2;
    private Image iYellow4Atoms_3;
    private Image iGreen1Atoms_3;
    private Image iGreen2Atoms_1;
    private Image iGreen2Atoms_2;
    private Image iGreen2Atoms_3;
    private Image iGreen3Atoms_1;
    private Image iGreen3Atoms_2;
    private Image iGreen3Atoms_3;
    private Image iGreen4Atoms_1;
    private Image iGreen4Atoms_2;
    private Image iGreen4Atoms_3;
    private Image iBang;
    public boolean iPainted;
    private boolean iGridded;
    private int iIntroCountDown = 12;
    private boolean iEndDown = true;
    private int iEndPosition = 0;
    private int shake1;
    private int shake2;
    private Random r = new Random();
    private boolean iShakyAtoms;
    public boolean iMakingMove = false;
    public boolean iMadeMove = false;
    public boolean iBlockMove = false;
    private Form iStartScreen;
    private Thread iGUIThread;

    public AtomicGUI(Display display, Form form, int n, int n2, int n3, boolean bl) {
        this.boardWidth = 90;
        this.boardHeight = 90;
        this.SQUARE_EMPTY = 0;
        this.SQUARE_ONE_ATOM = 1;
        this.SQUARE_TWO_ATOMS = 2;
        this.SQUARE_THREE_ATOMS = 3;
        this.SQUARE_FOUR_ATOMS = 4;
        this.SQUARE_BANG = 5;
        this.SQUARE_PLAYER1 = 32;
        this.SQUARE_PLAYER2 = 64;
        this.SQUARE_PLAYER3 = 128;
        this.SQUARE_PLAYER4 = 256;
        this.SQUARE_REMOVE_SELECTED = 512;
        this.SQUARE_BLANK = 1024;
        this.SQUARE_FRAME_1 = 2048;
        this.SQUARE_FRAME_2 = 4096;
        this.SQUARE_FRAME_3 = 8192;
        this.COMPUTER_PLAYER = 16384;
        this.PLAYER_MASK = 480;
        this.ATOM_COUNT_MASK = 7;
        this.FRAME_MASK = 14336;
        this.iDisplay = display;
        this.iStartScreen = form;
        this.iNumHumans = n;
        this.iNumComputers = n2;
        this.iNumPlayers = this.iNumHumans + this.iNumComputers;
        this.iAIIntelligence = n3;
        this.iShakyAtoms = bl;
        this.iPainted = false;
        this.iGridded = false;
        this.iGameOver = false;
        this.iBack = new Command("Back", 2, 1);
        this.iHelp = new Command("Help", 5, 1);
        this.addCommand(this.iBack);
        this.addCommand(this.iHelp);
        this.setCommandListener(this);
        this.player = new int[this.iNumPlayers];
        switch (this.iNumPlayers) {
            case 4: {
                this.player[3] = 256;
            }
            case 3: {
                this.player[2] = 128;
            }
            case 2: {
                this.player[1] = 64;
            }
            case 1: {
                this.player[0] = 32;
            }
        }
        this.boardOriginX = this.getWidth() / 2 - 45;
        this.boardOriginY = this.getHeight() / 2 - 45;
        this.gameBoard = new Board(this.boardRows, this.boardColumns);
        this.gameBoard.Init();
        this.board = this.gameBoard.board;
        this.gameBoard.SetGui(this);
        this.iAtomicAI = new AtomicAI(this.gameBoard, this.iNumHumans, this.iNumComputers, this.iAIIntelligence);
        try {
            this.iRed1Atoms_3 = Image.createImage((String)"/r1-1.png");
            this.iRed2Atoms_1 = Image.createImage((String)"/r2-1.png");
            this.iRed2Atoms_2 = Image.createImage((String)"/r2-2.png");
            this.iRed2Atoms_3 = Image.createImage((String)"/r2-3.png");
            this.iRed3Atoms_1 = Image.createImage((String)"/r3-1.png");
            this.iRed3Atoms_2 = Image.createImage((String)"/r3-2.png");
            this.iRed3Atoms_3 = Image.createImage((String)"/r3-3.png");
            this.iRed4Atoms_1 = Image.createImage((String)"/r4-1.png");
            this.iRed4Atoms_2 = Image.createImage((String)"/r4-2.png");
            this.iRed4Atoms_3 = Image.createImage((String)"/r4-3.png");
            this.iBlue1Atoms_3 = Image.createImage((String)"/b1-1.png");
            this.iBlue2Atoms_1 = Image.createImage((String)"/b2-1.png");
            this.iBlue2Atoms_2 = Image.createImage((String)"/b2-2.png");
            this.iBlue2Atoms_3 = Image.createImage((String)"/b2-3.png");
            this.iBlue3Atoms_1 = Image.createImage((String)"/b3-1.png");
            this.iBlue3Atoms_2 = Image.createImage((String)"/b3-2.png");
            this.iBlue3Atoms_3 = Image.createImage((String)"/b3-3.png");
            this.iBlue4Atoms_1 = Image.createImage((String)"/b4-1.png");
            this.iBlue4Atoms_2 = Image.createImage((String)"/b4-2.png");
            this.iBlue4Atoms_3 = Image.createImage((String)"/b4-3.png");
            this.iYellow1Atoms_3 = Image.createImage((String)"/y1-1.png");
            this.iYellow2Atoms_1 = Image.createImage((String)"/y2-1.png");
            this.iYellow2Atoms_2 = Image.createImage((String)"/y2-2.png");
            this.iYellow2Atoms_3 = Image.createImage((String)"/y2-3.png");
            this.iYellow3Atoms_1 = Image.createImage((String)"/y3-1.png");
            this.iYellow3Atoms_2 = Image.createImage((String)"/y3-2.png");
            this.iYellow3Atoms_3 = Image.createImage((String)"/y3-3.png");
            this.iYellow4Atoms_1 = Image.createImage((String)"/y4-1.png");
            this.iYellow4Atoms_2 = Image.createImage((String)"/y4-2.png");
            this.iYellow4Atoms_3 = Image.createImage((String)"/y4-3.png");
            this.iGreen1Atoms_3 = Image.createImage((String)"/g1-1.png");
            this.iGreen2Atoms_1 = Image.createImage((String)"/g2-1.png");
            this.iGreen2Atoms_2 = Image.createImage((String)"/g2-2.png");
            this.iGreen2Atoms_3 = Image.createImage((String)"/g2-3.png");
            this.iGreen3Atoms_1 = Image.createImage((String)"/g3-1.png");
            this.iGreen3Atoms_2 = Image.createImage((String)"/g3-2.png");
            this.iGreen3Atoms_3 = Image.createImage((String)"/g3-3.png");
            this.iGreen4Atoms_1 = Image.createImage((String)"/g4-1.png");
            this.iGreen4Atoms_2 = Image.createImage((String)"/g4-2.png");
            this.iGreen4Atoms_3 = Image.createImage((String)"/g4-3.png");
            this.iBang = Image.createImage((String)"/bang.png");
        }
        catch (Exception exception) {
            System.out.println("Atomic: Problem loading images.");
        }
        this.shake1 = 0;
        this.shake2 = 0;
        this.iGUIThread = new Thread(this);
        this.iGUIThread.start();
        this.playerTurn = 32;
    }

    public void BlankSquare(Graphics graphics, int n, int n2) {
        graphics.setColor(255, 255, 255);
        graphics.fillRect(1 + this.boardOriginX + this.boardSquareSize * n, 1 + this.boardOriginY + this.boardSquareSize * n2, this.boardSquareSize - 1, this.boardSquareSize - 1);
    }

    public synchronized void CheckPlayers() {
        if (this.iMakingMove || !this.iMadeMove) {
            return;
        }
        this.iMakingMove = true;
        this.iMadeMove = false;
        ++this.iMove;
        this.playerTurn = this.player[this.iMove % this.iNumPlayers];
        while ((this.playerLost & this.playerTurn) == this.playerTurn) {
            ++this.iMove;
            this.playerTurn = this.player[this.iMove % this.iNumPlayers];
        }
    }

    private void Down() {
        int[] nArray = this.board[this.selectedX];
        int n = this.selectedY++;
        nArray[n] = nArray[n] | 0x200;
    }

    public void EndGame() {
        this.iGUIThread = null;
        this.iDisplay.setCurrent((Displayable)this.iStartScreen);
    }

    public final int Frame(int n, int n2) {
        return this.board[n][n2] & 0x3800;
    }

    public void Intro(Graphics graphics) {
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        int n = 10 * this.iIntroCountDown;
        graphics.setColor(n, 0, 0);
        graphics.fillRect(0, 0, this.getWidth() / (this.iIntroCountDown + 1), 2);
        graphics.drawRect(this.boardOriginX + this.iIntroCountDown * 5, this.boardOriginY, 90 + this.iIntroCountDown * 5, 90 - this.iIntroCountDown * 5);
        int n2 = 1;
        while (n2 < this.boardRows) {
            graphics.drawLine(this.iIntroCountDown + this.boardOriginX + this.boardSquareSize * n2, this.boardOriginY, this.iIntroCountDown * this.boardOriginX + this.boardSquareSize * n2, this.boardOriginY + 90 - this.iIntroCountDown);
            ++n2;
        }
        int n3 = 1;
        while (n3 < this.boardColumns) {
            graphics.drawLine(this.iIntroCountDown + this.boardOriginX, this.boardOriginY + this.boardSquareSize * n3 - this.iIntroCountDown, this.iIntroCountDown * this.boardOriginX + 90, this.boardOriginY + this.boardSquareSize * n3);
            ++n3;
        }
        try {
            Thread.sleep(75L);
        }
        catch (Exception exception) {}
        this.repaint();
    }

    private void Left() {
        int[] nArray = this.board[this.selectedX];
        int n = this.selectedY;
        nArray[n] = nArray[n] | 0x200;
        --this.selectedX;
    }

    public synchronized void Move(int n, int n2) {
        if (this.iBlockMove || this.iMakingMove) {
            return;
        }
        this.iBlockMove = true;
        this.iMakingMove = true;
        if (!this.gameBoard.iReacting) {
            boolean bl = this.gameBoard.AddAtom(this.playerTurn, n, n2);
            if (bl) {
                this.playerHasHadATurn |= this.playerTurn;
                while (this.gameBoard.iReacting) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.iMadeMove = true;
            }
            this.iMakingMove = false;
        }
    }

    private final void NextFrame(int n, int n2) {
        int n3 = this.Frame(n, n2);
        this.board[n][n2] = this.board[n][n2] & ~n3;
        switch (n3) {
            case 2048: {
                int[] nArray = this.board[n];
                int n4 = n2;
                nArray[n4] = nArray[n4] | 0x1000;
                break;
            }
            case 4096: {
                int[] nArray = this.board[n];
                int n5 = n2;
                nArray[n5] = nArray[n5] | 0x2000;
                break;
            }
            default: {
                int[] nArray = this.board[n];
                int n6 = n2;
                nArray[n6] = nArray[n6] | 0x2000;
            }
        }
    }

    private void Right() {
        int[] nArray = this.board[this.selectedX];
        int n = this.selectedY;
        nArray[n] = nArray[n] | 0x200;
        ++this.selectedX;
    }

    private void Up() {
        int[] nArray = this.board[this.selectedX];
        int n = this.selectedY--;
        nArray[n] = nArray[n] | 0x200;
    }

    public void UpdatePlayers() {
        int n = this.iNumPlayers;
        int n2 = 0;
        while (n2 < this.iNumPlayers) {
            if ((this.playerHasHadATurn & this.player[n2]) == this.player[n2] & this.gameBoard.Score(this.player[n2]) == 0) {
                this.playerLost |= this.player[n2];
                --n;
            }
            ++n2;
        }
        if (n == 1) {
            this.iGameOver = true;
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command.getLabel().equals("Back")) {
            this.EndGame();
        }
        if (command.getLabel().equals("Help")) {
            Form form = new Form("Atomic Help");
            String string = "Take over the board to win. You can add atoms to empty squares or squares that already contain one of your atoms.\n\nIf a square reaches its atomic limit it will explode taking over neighbouring squares. These chain reactions can have dramatic effects on the state of play. The Atomic limit of each square is\n4 (central squares)\n3 (edge squares) \n2 (corner squares)\n\nContols: Up, Down, Left, Right & Fire.";
            StringItem stringItem = new StringItem("", string);
            form.append((Item)stringItem);
            this.iPlay = new Command("Play", 1, 1);
            form.addCommand(this.iPlay);
            form.setCommandListener((CommandListener)this);
            this.iDisplay.setCurrent((Displayable)form);
        }
        if (command.getLabel().equals("Play")) {
            this.iGridded = false;
            this.iDisplay.setCurrent((Displayable)this);
        }
    }

    public Image getAtom(int n, int n2) {
        this.repaint();
        if ((this.board[n][n2] & 5) == 5) {
            return this.iBang;
        }
        int n3 = this.board[n][n2];
        int n4 = this.gameBoard.NumAtoms(n, n2);
        int n5 = this.Frame(n, n2);
        if ((n3 & 0x20) == 32) {
            switch (n4) {
                case 1: {
                    switch (n5) {
                        case 8192: {
                            return this.iRed1Atoms_3;
                        }
                        case 4096: {
                            return this.iRed1Atoms_3;
                        }
                        case 2048: {
                            return this.iRed1Atoms_3;
                        }
                    }
                    return this.iRed1Atoms_3;
                }
                case 2: {
                    switch (n5) {
                        case 8192: {
                            if (!this.gameBoard.AtomStable(n, n2)) {
                                int[] nArray = this.board[n];
                                int n6 = n2;
                                nArray[n6] = nArray[n6] | 5;
                            }
                            return this.iRed2Atoms_3;
                        }
                        case 4096: {
                            this.NextFrame(n, n2);
                            return this.iRed2Atoms_2;
                        }
                        case 2048: {
                            this.NextFrame(n, n2);
                            return this.iRed2Atoms_1;
                        }
                    }
                    return this.iRed2Atoms_3;
                }
                case 3: {
                    switch (n5) {
                        case 8192: {
                            if (!this.gameBoard.AtomStable(n, n2)) {
                                int[] nArray = this.board[n];
                                int n7 = n2;
                                nArray[n7] = nArray[n7] | 5;
                            }
                            return this.iRed3Atoms_3;
                        }
                        case 4096: {
                            this.NextFrame(n, n2);
                            return this.iRed3Atoms_2;
                        }
                        case 2048: {
                            this.NextFrame(n, n2);
                            return this.iRed3Atoms_1;
                        }
                    }
                    return this.iRed3Atoms_3;
                }
                case 4: {
                    switch (n5) {
                        case 8192: {
                            int[] nArray = this.board[n];
                            int n8 = n2;
                            nArray[n8] = nArray[n8] | 5;
                            return this.iRed4Atoms_3;
                        }
                        case 4096: {
                            this.NextFrame(n, n2);
                            return this.iRed4Atoms_2;
                        }
                        case 2048: {
                            this.NextFrame(n, n2);
                            return this.iRed4Atoms_1;
                        }
                    }
                    return this.iRed4Atoms_3;
                }
            }
            return this.iBang;
        }
        if ((n3 & 0x40) == 64) {
            switch (n4) {
                case 1: {
                    switch (n5) {
                        case 8192: {
                            return this.iBlue1Atoms_3;
                        }
                        case 4096: {
                            return this.iBlue1Atoms_3;
                        }
                        case 2048: {
                            return this.iBlue1Atoms_3;
                        }
                    }
                    return this.iBlue1Atoms_3;
                }
                case 2: {
                    switch (n5) {
                        case 8192: {
                            if (!this.gameBoard.AtomStable(n, n2)) {
                                int[] nArray = this.board[n];
                                int n9 = n2;
                                nArray[n9] = nArray[n9] | 5;
                            }
                            return this.iBlue2Atoms_3;
                        }
                        case 4096: {
                            this.NextFrame(n, n2);
                            return this.iBlue2Atoms_2;
                        }
                        case 2048: {
                            this.NextFrame(n, n2);
                            return this.iBlue2Atoms_1;
                        }
                    }
                    return this.iBlue2Atoms_3;
                }
                case 3: {
                    switch (n5) {
                        case 8192: {
                            if (!this.gameBoard.AtomStable(n, n2)) {
                                int[] nArray = this.board[n];
                                int n10 = n2;
                                nArray[n10] = nArray[n10] | 5;
                            }
                            return this.iBlue3Atoms_3;
                        }
                        case 4096: {
                            this.NextFrame(n, n2);
                            return this.iBlue3Atoms_2;
                        }
                        case 2048: {
                            this.NextFrame(n, n2);
                            return this.iBlue3Atoms_1;
                        }
                    }
                    return this.iBlue3Atoms_3;
                }
                case 4: {
                    switch (n5) {
                        case 8192: {
                            int[] nArray = this.board[n];
                            int n11 = n2;
                            nArray[n11] = nArray[n11] | 5;
                            return this.iBlue4Atoms_3;
                        }
                        case 4096: {
                            this.NextFrame(n, n2);
                            return this.iBlue4Atoms_2;
                        }
                        case 2048: {
                            this.NextFrame(n, n2);
                            return this.iBlue4Atoms_1;
                        }
                    }
                    return this.iBlue4Atoms_3;
                }
            }
            return this.iBang;
        }
        if ((n3 & 0x80) == 128) {
            switch (n4) {
                case 1: {
                    switch (n5) {
                        case 8192: {
                            return this.iYellow1Atoms_3;
                        }
                        case 4096: {
                            return this.iYellow1Atoms_3;
                        }
                        case 2048: {
                            return this.iYellow1Atoms_3;
                        }
                    }
                    return this.iYellow1Atoms_3;
                }
                case 2: {
                    switch (n5) {
                        case 8192: {
                            if (!this.gameBoard.AtomStable(n, n2)) {
                                int[] nArray = this.board[n];
                                int n12 = n2;
                                nArray[n12] = nArray[n12] | 5;
                            }
                            return this.iYellow2Atoms_3;
                        }
                        case 4096: {
                            this.NextFrame(n, n2);
                            return this.iYellow2Atoms_2;
                        }
                        case 2048: {
                            this.NextFrame(n, n2);
                            return this.iYellow2Atoms_1;
                        }
                    }
                    return this.iYellow2Atoms_3;
                }
                case 3: {
                    switch (n5) {
                        case 8192: {
                            if (!this.gameBoard.AtomStable(n, n2)) {
                                int[] nArray = this.board[n];
                                int n13 = n2;
                                nArray[n13] = nArray[n13] | 5;
                            }
                            return this.iYellow3Atoms_3;
                        }
                        case 4096: {
                            this.NextFrame(n, n2);
                            return this.iYellow3Atoms_2;
                        }
                        case 2048: {
                            this.NextFrame(n, n2);
                            return this.iYellow3Atoms_1;
                        }
                    }
                    return this.iYellow3Atoms_3;
                }
                case 4: {
                    switch (n5) {
                        case 8192: {
                            int[] nArray = this.board[n];
                            int n14 = n2;
                            nArray[n14] = nArray[n14] | 5;
                            return this.iYellow4Atoms_3;
                        }
                        case 4096: {
                            this.NextFrame(n, n2);
                            return this.iYellow4Atoms_2;
                        }
                        case 2048: {
                            this.NextFrame(n, n2);
                            return this.iYellow4Atoms_1;
                        }
                    }
                    return this.iYellow4Atoms_3;
                }
            }
            return this.iBang;
        }
        if ((n3 & 0x100) == 256) {
            switch (n4) {
                case 1: {
                    switch (n5) {
                        case 8192: {
                            return this.iGreen1Atoms_3;
                        }
                        case 4096: {
                            return this.iGreen1Atoms_3;
                        }
                        case 2048: {
                            return this.iGreen1Atoms_3;
                        }
                    }
                    return this.iGreen1Atoms_3;
                }
                case 2: {
                    switch (n5) {
                        case 8192: {
                            if (!this.gameBoard.AtomStable(n, n2)) {
                                int[] nArray = this.board[n];
                                int n15 = n2;
                                nArray[n15] = nArray[n15] | 5;
                            }
                            return this.iGreen2Atoms_3;
                        }
                        case 4096: {
                            this.NextFrame(n, n2);
                            return this.iGreen2Atoms_2;
                        }
                        case 2048: {
                            this.NextFrame(n, n2);
                            return this.iGreen2Atoms_1;
                        }
                    }
                    return this.iGreen2Atoms_3;
                }
                case 3: {
                    switch (n5) {
                        case 8192: {
                            if (!this.gameBoard.AtomStable(n, n2)) {
                                int[] nArray = this.board[n];
                                int n16 = n2;
                                nArray[n16] = nArray[n16] | 5;
                            }
                            return this.iGreen3Atoms_3;
                        }
                        case 4096: {
                            this.NextFrame(n, n2);
                            return this.iGreen3Atoms_2;
                        }
                        case 2048: {
                            this.NextFrame(n, n2);
                            return this.iGreen3Atoms_1;
                        }
                    }
                    return this.iGreen3Atoms_3;
                }
                case 4: {
                    switch (n5) {
                        case 8192: {
                            int[] nArray = this.board[n];
                            int n17 = n2;
                            nArray[n17] = nArray[n17] | 5;
                            return this.iGreen4Atoms_3;
                        }
                        case 4096: {
                            this.NextFrame(n, n2);
                            return this.iGreen4Atoms_2;
                        }
                        case 2048: {
                            this.NextFrame(n, n2);
                            return this.iGreen4Atoms_1;
                        }
                    }
                    return this.iGreen4Atoms_3;
                }
            }
            return this.iBang;
        }
        return this.iBang;
    }

    protected synchronized void keyPressed(int n) {
        switch (this.getGameAction(n)) {
            case 1: {
                if (this.selectedY == 0) {
                    return;
                }
                this.Up();
                break;
            }
            case 2: {
                if (this.selectedX == 0) {
                    return;
                }
                this.Left();
                break;
            }
            case 6: {
                if (this.selectedY == this.boardColumns - 1) {
                    return;
                }
                this.Down();
                break;
            }
            case 5: {
                if (this.selectedX == this.boardRows - 1) {
                    return;
                }
                this.Right();
                break;
            }
            case 8: {
                if (!((this.iAtomicAI.ComputerPlayer(this.playerTurn) ^ true) & (this.iBlockMove ^ true))) break;
                this.Move(this.selectedX, this.selectedY);
            }
        }
        this.repaint();
    }

    protected void paint(Graphics graphics) {
        int n;
        int n2;
        if ((this.iGridded ^ true) & this.iIntroCountDown == 0) {
            graphics.setColor(255, 255, 255);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(0, 0, 0);
            graphics.drawRect(this.boardOriginX, this.boardOriginY, 90, 90);
            n2 = 1;
            while (n2 < this.boardRows) {
                graphics.drawLine(this.boardOriginX + this.boardSquareSize * n2, this.boardOriginY, this.boardOriginX + this.boardSquareSize * n2, this.boardOriginY + 90);
                ++n2;
            }
            n = 1;
            while (n < this.boardColumns) {
                graphics.drawLine(this.boardOriginX, this.boardOriginY + this.boardSquareSize * n, this.boardOriginX + 90, this.boardOriginY + this.boardSquareSize * n);
                ++n;
            }
            this.iGridded = true;
        } else if (this.iIntroCountDown > 0) {
            --this.iIntroCountDown;
            this.Intro(graphics);
        } else {
            if (this.iGameOver) {
                this.gameBoard.Stop();
                graphics.setColor(255, 255, 255);
                graphics.fillRect(this.boardOriginX + 1, this.boardOriginY + 1 + this.iEndPosition, 89, 20);
                Font font = Font.getFont((int)32, (int)1, (int)0);
                graphics.setFont(font);
                String string = "";
                if (this.playerTurn == 32) {
                    graphics.setColor(255, 0, 0);
                    string = "Red";
                } else if (this.playerTurn == 64) {
                    graphics.setColor(0, 0, 255);
                    string = "Blue";
                } else if (this.playerTurn == 128) {
                    graphics.setColor(255, 255, 0);
                    string = "Yellow";
                } else {
                    graphics.setColor(0, 255, 0);
                    string = "Green";
                }
                graphics.drawString(String.valueOf(string) + " Wins!", this.getWidth() / 2, this.boardOriginY + 1 + this.iEndPosition + 5, 17);
                this.iEndPosition = this.iEndDown ? ++this.iEndPosition : --this.iEndPosition;
                if (this.iEndPosition == 0 || this.iEndPosition == 69) {
                    this.iEndDown ^= true;
                }
                return;
            }
            if (this.playerTurn == 32) {
                graphics.setColor(255, 0, 0);
            } else if (this.playerTurn == 64) {
                graphics.setColor(0, 0, 255);
            } else if (this.playerTurn == 128) {
                graphics.setColor(255, 255, 0);
            } else {
                graphics.setColor(0, 255, 0);
            }
            graphics.fillRect(0, 0, this.getWidth(), 3);
            graphics.fillRect(0, this.getHeight() - 3, this.getWidth(), this.getHeight());
        }
        n2 = 0;
        while (n2 < this.boardRows) {
            n = 0;
            while (n < this.boardColumns) {
                if (this.gameBoard.NumAtoms(n2, n) != 0) {
                    if (this.iShakyAtoms) {
                        int n3 = this.r.nextInt() % 20;
                        if (n3 == 0) {
                            this.shake1 = 1;
                        } else if (n3 == 1) {
                            this.shake2 = 1;
                        } else {
                            this.shake1 = 0;
                            this.shake2 = 0;
                        }
                    }
                    this.BlankSquare(graphics, n2, n);
                    graphics.drawImage(this.getAtom(n2, n), this.boardOriginX + n2 * this.boardSquareSize + this.boardSquareSize / 2 + this.shake1, this.boardOriginY + n * this.boardSquareSize + this.boardSquareSize / 2 + this.shake2, 3);
                } else if (this.board[n2][n] == 1024) {
                    this.board[n2][n] = 0;
                    this.BlankSquare(graphics, n2, n);
                } else if ((this.board[n2][n] & 0x200) == 512) {
                    this.board[n2][n] = this.board[n2][n] & 0xFFFFFDFF;
                    this.BlankSquare(graphics, n2, n);
                }
                ++n;
            }
            ++n2;
        }
        graphics.setColor(153, 51, 204);
        graphics.drawRect(1 + this.boardOriginX + this.boardSquareSize * this.selectedX, 1 + this.boardOriginY + this.boardSquareSize * this.selectedY, this.boardSquareSize - 2, this.boardSquareSize - 2);
        this.iPainted = true;
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    if (this.iGameOver) {
                        Thread.sleep(30L);
                        this.repaint();
                        continue;
                    }
                    if (this.iAtomicAI.ComputerPlayer(this.playerTurn) & (this.gameBoard.iReacting ^ true)) {
                        Thread.sleep(750L);
                        this.iAtomicAI.getMove(this.playerTurn);
                        this.iBlockMove = false;
                        this.Move(this.iAtomicAI.x, this.iAtomicAI.y);
                    }
                    this.repaint();
                    Thread.sleep(1000L);
                    this.iBlockMove = false;
                    if (this.gameBoard.iReacting) continue;
                    this.CheckPlayers();
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void showNotify() {
        this.iGridded = false;
    }
}

