/*
 * Decompiled with CFR 0.152.
 */
class Board
implements Runnable {
    public int[][] board;
    public static int rows;
    public static int columns;
    public boolean iReacting = false;
    public static final int SQUARE_EMPTY = 0;
    public static final int SQUARE_ONE_ATOM = 1;
    public static final int SQUARE_TWO_ATOMS = 2;
    public static final int SQUARE_THREE_ATOMS = 3;
    public static final int SQUARE_FOUR_ATOMS = 4;
    public static final int SQUARE_BANG = 5;
    public static final int SQUARE_PLAYER1 = 32;
    public static final int SQUARE_PLAYER2 = 64;
    public static final int SQUARE_PLAYER3 = 128;
    public static final int SQUARE_PLAYER4 = 256;
    public static final int SQUARE_BLANK = 1024;
    public static final int SQUARE_FRAME_1 = 2048;
    public static final int SQUARE_FRAME_2 = 4096;
    public static final int SQUARE_FRAME_3 = 8192;
    public static final int PLAYER_MASK = 480;
    public static final int ATOM_COUNT_MASK = 7;
    public static final int FRAME_MASK = 14336;
    private Thread iExplosionThread;
    private boolean iThreadRun = true;
    private AtomicGUI iGUI;

    public Board() {
    }

    public Board(int n, int n2) {
        rows = n;
        columns = n2;
    }

    public synchronized boolean AddAtom(int n, int n2, int n3) {
        if (this.board[n2][n3] != 0 & n != (this.board[n2][n3] & n)) {
            this.iReacting = false;
            return false;
        }
        int[] nArray = this.board[n2];
        int n4 = n3;
        nArray[n4] = nArray[n4] | n;
        int[] nArray2 = this.board[n2];
        int n5 = n3;
        nArray2[n5] = nArray2[n5] + 1;
        this.board[n2][n3] = this.board[n2][n3] & 0xFFFFC7FF;
        int[] nArray3 = this.board[n2];
        int n6 = n3;
        nArray3[n6] = nArray3[n6] | 0x800;
        return true;
    }

    public boolean AtomStable(int n, int n2) {
        if ((this.board[n][n2] & 5) == 5) {
            return false;
        }
        int n3 = this.NumAtoms(n, n2);
        if (n3 >= 4) {
            return false;
        }
        if (this.Corner(n, n2) & n3 >= 2) {
            return false;
        }
        return !(this.Edge(n, n2) & n3 >= 3);
    }

    private void Bang(int n, int n2) {
        int[] nArray = this.board[n];
        int n3 = n2;
        nArray[n3] = nArray[n3] | 5;
        this.forceRepaint();
        this.board[n][n2] = 1024;
        this.forceRepaint();
    }

    public boolean Corner(int n, int n2) {
        return n == 0 & n2 == 0 | n == 0 & n2 == columns - 1 | n == rows - 1 & n2 == 0 | n == rows - 1 & n2 == columns - 1;
    }

    public boolean Edge(int n, int n2) {
        return n == 0 | n2 == 0 | n == rows - 1 | n2 == columns - 1;
    }

    public void Init() {
        this.board = new int[rows][columns];
        int n = 0;
        while (n < rows) {
            int n2 = 0;
            while (n2 < columns) {
                this.board[n][n2] = 0;
                ++n2;
            }
            ++n;
        }
        this.iExplosionThread = new Thread(this);
        this.iExplosionThread.start();
    }

    public final int NumAtoms(int n, int n2) {
        return this.board[n][n2] & 7;
    }

    public final int Player(int n, int n2) {
        return this.board[n][n2] & 0x1E0;
    }

    /*
     * Unable to fully structure code
     */
    public void Reaction() {
        var1_1 = 0;
        while (var1_1 < Board.rows) {
            var2_2 = 0;
            while (var2_2 < Board.columns) {
                block14: {
                    block12: {
                        block16: {
                            block15: {
                                block13: {
                                    var3_3 = this.NumAtoms(var1_1, var2_2);
                                    var4_4 = this.Player(var1_1, var2_2);
                                    if (!(this.Corner(var1_1, var2_2) & var3_3 >= 2)) break block12;
                                    if (!(var1_1 == 0 & var2_2 == 0)) break block13;
                                    this.board[var1_1 + 1][var2_2] = this.NumAtoms(var1_1 + 1, var2_2) + 1 | var4_4;
                                    this.board[var1_1][var2_2 + 1] = this.NumAtoms(var1_1, var2_2 + 1) + 1 | var4_4;
                                    this.Bang(var1_1, var2_2);
                                    break block14;
                                }
                                if (!(var1_1 == 0 & var2_2 == Board.rows - 1)) break block15;
                                this.board[var1_1 + 1][var2_2] = this.NumAtoms(var1_1 + 1, var2_2) + 1 | var4_4;
                                this.board[var1_1][var2_2 - 1] = this.NumAtoms(var1_1, var2_2 - 1) + 1 | var4_4;
                                this.Bang(var1_1, var2_2);
                                break block14;
                            }
                            if (!(var1_1 == Board.columns - 1 & var2_2 == 0)) break block16;
                            this.board[var1_1 - 1][var2_2] = this.NumAtoms(var1_1 - 1, var2_2) + 1 | var4_4;
                            this.board[var1_1][var2_2 + 1] = this.NumAtoms(var1_1, var2_2 + 1) + 1 | var4_4;
                            this.Bang(var1_1, var2_2);
                            break block14;
                        }
                        if (!(var1_1 == Board.rows - 1 & var2_2 == Board.columns - 1)) break block12;
                        this.board[var1_1 - 1][var2_2] = this.NumAtoms(var1_1 - 1, var2_2) + 1 | var4_4;
                        this.board[var1_1][var2_2 - 1] = this.NumAtoms(var1_1, var2_2 - 1) + 1 | var4_4;
                        this.Bang(var1_1, var2_2);
                        break block14;
                    }
                    if (!(this.Edge(var1_1, var2_2) & var3_3 >= 3)) ** GOTO lbl-1000
                    if (var2_2 == 0) {
                        this.board[var1_1 + 1][var2_2] = this.NumAtoms(var1_1 + 1, var2_2) + 1 | var4_4;
                        this.board[var1_1 - 1][var2_2] = this.NumAtoms(var1_1 - 1, var2_2) + 1 | var4_4;
                        this.forceRepaint();
                        this.board[var1_1][var2_2 + 1] = this.NumAtoms(var1_1, var2_2 + 1) + 1 | var4_4;
                        this.Bang(var1_1, var2_2);
                    } else if (var2_2 == Board.rows - 1) {
                        this.board[var1_1 + 1][var2_2] = this.NumAtoms(var1_1 + 1, var2_2) + 1 | var4_4;
                        this.board[var1_1 - 1][var2_2] = this.NumAtoms(var1_1 - 1, var2_2) + 1 | var4_4;
                        this.forceRepaint();
                        this.board[var1_1][var2_2 - 1] = this.NumAtoms(var1_1, var2_2 - 1) + 1 | var4_4;
                        this.Bang(var1_1, var2_2);
                    } else if (var1_1 == 0) {
                        this.board[var1_1][var2_2 + 1] = this.NumAtoms(var1_1, var2_2 + 1) + 1 | var4_4;
                        this.board[var1_1][var2_2 - 1] = this.NumAtoms(var1_1, var2_2 - 1) + 1 | var4_4;
                        this.forceRepaint();
                        this.board[var1_1 + 1][var2_2] = this.NumAtoms(var1_1 + 1, var2_2) + 1 | var4_4;
                        this.Bang(var1_1, var2_2);
                    } else if (var1_1 == Board.columns - 1) {
                        this.board[var1_1][var2_2 + 1] = this.NumAtoms(var1_1, var2_2 + 1) + 1 | var4_4;
                        this.board[var1_1][var2_2 - 1] = this.NumAtoms(var1_1, var2_2 - 1) + 1 | var4_4;
                        this.forceRepaint();
                        this.board[var1_1 - 1][var2_2] = this.NumAtoms(var1_1 - 1, var2_2) + 1 | var4_4;
                        this.Bang(var1_1, var2_2);
                    } else if (var3_3 >= 4) {
                        this.board[var1_1][var2_2 - 1] = this.NumAtoms(var1_1, var2_2 - 1) + 1 | var4_4;
                        this.board[var1_1 + 1][var2_2] = this.NumAtoms(var1_1 + 1, var2_2) + 1 | var4_4;
                        this.forceRepaint();
                        this.board[var1_1][var2_2 + 1] = this.NumAtoms(var1_1, var2_2 + 1) + 1 | var4_4;
                        this.board[var1_1 - 1][var2_2] = this.NumAtoms(var1_1 - 1, var2_2) + 1 | var4_4;
                        this.Bang(var1_1, var2_2);
                    }
                }
                ++var2_2;
            }
            ++var1_1;
        }
        if (this.iGUI != null) {
            this.iGUI.iPainted = false;
        }
    }

    public int Score(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < rows) {
            int n4 = 0;
            while (n4 < columns) {
                if (this.Player(n3, n4) == n) {
                    int n5 = this.NumAtoms(n3, n4);
                    int n6 = 0;
                    if (this.Corner(n3, n4) & n5 == 0) {
                        n6 = 3;
                    } else if (n5 == 2 || n5 == 3) {
                        n6 = 2;
                    }
                    n2 += n5 + n6;
                }
                ++n4;
            }
            ++n3;
        }
        return n2;
    }

    public void SetGui(AtomicGUI atomicGUI) {
        this.iGUI = atomicGUI;
    }

    public synchronized boolean Stable() {
        int n = 0;
        while (n < rows) {
            int n2 = 0;
            while (n2 < columns) {
                if (!this.AtomStable(n, n2)) {
                    return false;
                }
                ++n2;
            }
            ++n;
        }
        if (this.iGUI != null) {
            this.iGUI.UpdatePlayers();
        }
        return true;
    }

    public void Stop() {
        this.iThreadRun = false;
    }

    private final void forceRepaint() {
        int n = 0;
        if (this.iGUI != null) {
            this.iGUI.iPainted = false;
            try {
                while (!this.iGUI.iPainted) {
                    Thread.sleep(60L);
                    this.iGUI.repaint();
                    if (++n != 10) continue;
                    return;
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void run() {
        if (!this.iThreadRun) {
            return;
        }
        do {
            if (!this.Stable()) {
                this.iReacting = true;
                this.Reaction();
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
                if (this.iGUI != null) {
                    this.iGUI.UpdatePlayers();
                }
            } else {
                if (this.iGUI != null) {
                    this.iGUI.iMakingMove = false;
                }
                this.iReacting = false;
            }
            if (this.iGUI != null) {
                this.iGUI.UpdatePlayers();
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        } while (this.iThreadRun);
    }
}

