/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class Swarm
extends MIDlet
implements CommandListener,
Runnable {
    private Display display;
    private Command exitCommand;
    private Command playCommand;
    private Command quitCommand;
    private Command againCommand;
    private Command nullCommand;
    private MainScreen mainscreen;
    private TitleScreen titlescreen;
    private ScoreScreen scorescreen;
    private static int WIDTH;
    private static int HEIGHT;
    private static int CENTERW;
    private static int CENTERH;
    private boolean runner;
    private Thread th;
    private Random rand = new Random();
    private static final int RED = 0xFF0000;
    private static final int ORANGE = 16748800;
    private static final int YELLOW = 0xFFFF00;
    private static final int WHITE = 0xFFFFFF;
    private static final int BLACK = 0;
    private static final int BLUE = 1442449;
    private static Image[] alienimg;
    private static Image[] explosionimg;
    private static Image playerimg;
    private static Image logoimg;
    private static int imgH;
    private static int imgW;
    private static int pimgH;
    private static int pimgW;
    private static int edgeH;
    private static int edgeV;
    private static int pedgeH;
    private static int pedgeV;
    private static final Font fs;
    private static final Font fl;
    private static final int[] sposX;
    private static final int[] sposY;
    private static final int LOOP = 0;
    private static final int ONCE = 1;
    private static final int HOLD = 2;
    private static final int[] move_none;
    private static final int[] alien_dx_right;
    private static final int[] alien_dy_right;
    private static final int[] alien_dx_left;
    private static final int[] alien_dy_left;
    private static final int[] alien_dx_flyright;
    private static final int[] alien_dy_flyright;
    private static final int[] alien_dx_flyleft;
    private static final int[] alien_dy_flyleft;
    private static final int slen;
    private static final int ailen;
    private static final int packlen;
    private static int[] pmode;
    private static int[] x;
    private static int[] y;
    private static int[][] dx;
    private static int[][] dy;
    private static int[] dxcount;
    private static int[] dycount;
    private static int[] frame;
    private static boolean[] flying;
    private static boolean[] dead;
    private static boolean[] exploding;
    private static int lastx;
    private static int lasty;
    private static int fly;
    private static int[] packX;
    private static int[] packY;
    private static int[] packdx;
    private static int[] packdy;
    private static int packcount;
    private static int framecount;
    private static int px;
    private static int py;
    private static int plastx;
    private static int score;
    private static String scorestr;
    private static int lives;
    private static int killed;
    private static boolean playerdead;
    private static int explodeframe;
    private static int playerpause;
    private static int rank;
    private static boolean playerLeft;
    private static boolean playerRight;
    private static boolean laser;
    private static int laserx;
    private static int lasery;
    private static RecordStore hsdata;
    private static int[] highscore;
    private static boolean showmessage;
    private static boolean showscores;
    private static boolean gameover;
    private static boolean wavecomplete;
    private static int messagepause;
    private static String msg;
    private static int difficulty;
    private static int wave;
    private static String tempstr;
    private static int templen;

    public Swarm() {
        this.display = Display.getDisplay((MIDlet)this);
        this.mainscreen = new MainScreen();
        this.titlescreen = new TitleScreen();
        this.scorescreen = new ScoreScreen();
        WIDTH = this.mainscreen.getWidth();
        HEIGHT = this.mainscreen.getHeight();
        CENTERW = WIDTH / 2;
        CENTERH = HEIGHT / 2;
        this.exitCommand = new Command("Exit", 7, 1);
        this.playCommand = new Command("Play", 1, 1);
        this.quitCommand = new Command("Quit", 1, 1);
        this.againCommand = new Command("Again", 1, 1);
        this.nullCommand = new Command("", 1, 1);
        try {
            Swarm.alienimg[0] = Image.createImage((String)"/alien1.png");
            Swarm.alienimg[1] = Image.createImage((String)"/alien2.png");
            Swarm.explosionimg[0] = Image.createImage((String)"/explosion1.png");
            Swarm.explosionimg[1] = Image.createImage((String)"/explosion2.png");
            Swarm.explosionimg[2] = Image.createImage((String)"/explosion3.png");
            playerimg = Image.createImage((String)"/player.png");
            logoimg = Image.createImage((String)"/logo.png");
        }
        catch (IOException iOException) {
            Swarm.db("Couldn't get images!");
        }
        imgW = alienimg[0].getWidth();
        imgH = alienimg[0].getHeight();
        edgeH = imgW / 2;
        edgeV = imgH / 2;
        pimgW = playerimg.getWidth();
        pimgH = playerimg.getHeight();
        pedgeH = pimgW / 2;
        pedgeV = pimgH / 2;
        highscore = this.getHighScores();
    }

    public void run() {
        while (this.runner) {
            this.rp();
            this.updatePos();
            try {
                Thread.sleep(75L);
            }
            catch (InterruptedException interruptedException) {
                Swarm.db("interrupted");
                this.runner = false;
            }
            Thread.yield();
        }
    }

    public void startApp() throws MIDletStateChangeException {
        this.display.setCurrent((Displayable)this.titlescreen);
        this.addBeginCommands((Displayable)this.titlescreen, false);
        this.addBeginCommands((Displayable)this.scorescreen, false);
        this.addPlayCommands((Displayable)this.mainscreen, false);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
        this.runner = false;
        this.th = null;
    }

    private void rp() {
        this.mainscreen.repaint();
    }

    private void startGame() {
        this.initGame();
        if (this.th == null) {
            this.th = new Thread(this);
            this.runner = true;
            this.th.start();
        }
    }

    private void initGame() {
        px = CENTERW;
        py = HEIGHT - pedgeV - pimgH;
        packcount = 0;
        lives = 3;
        score = 0;
        scorestr = "000000";
        rank = -1;
        difficulty = 400;
        wave = 1;
        this.initWave();
    }

    private void initWave() {
        int n = 0;
        while (n < slen) {
            Swarm.frame[n] = n % 2;
            Swarm.x[n] = Swarm.packX[n] = sposX[n];
            Swarm.y[n] = Swarm.packY[n] = sposY[n];
            packdx = alien_dx_right;
            Swarm.dx[n] = alien_dx_right;
            packdy = alien_dy_right;
            Swarm.dy[n] = alien_dy_right;
            Swarm.dycount[n] = 0;
            Swarm.dxcount[n] = 0;
            Swarm.pmode[n] = 0;
            Swarm.flying[n] = false;
            Swarm.dead[n] = false;
            ++n;
        }
        playerLeft = false;
        playerRight = false;
        laser = false;
        playerdead = false;
        showscores = false;
        showmessage = false;
        gameover = false;
        wavecomplete = false;
        playerpause = 0;
        messagepause = 0;
        killed = 0;
    }

    private void updatePos() {
        if (playerLeft) {
            this.updatePlayerPos(-2);
        } else if (playerRight) {
            this.updatePlayerPos(2);
        }
        fly = Math.abs(this.rand.nextInt() % difficulty);
        if (fly < slen && !flying[fly] && !dead[fly]) {
            if (x[fly] < CENTERW) {
                this.setDX(fly, alien_dx_flyright, 2);
                this.setDY(fly, alien_dy_flyright, 2);
            } else {
                this.setDX(fly, alien_dx_flyleft, 2);
                this.setDY(fly, alien_dy_flyleft, 2);
            }
            Swarm.flying[Swarm.fly] = true;
        }
        int n = 0;
        while (n < slen) {
            if (!dead[n]) {
                if (!flying[n]) {
                    if (x[n] + edgeH + dx[n][dxcount[n]] > WIDTH) {
                        this.changePackDir(alien_dx_left, alien_dy_left);
                    }
                    if (x[n] - edgeH + dx[n][dxcount[n]] < 0) {
                        this.changePackDir(alien_dx_right, alien_dy_right);
                    }
                } else {
                    if (y[n] + edgeV + dy[n][dycount[n]] > HEIGHT) {
                        Swarm.x[n] = packX[n];
                        Swarm.y[n] = packY[n];
                        Swarm.flying[n] = false;
                        this.setDX(n, packdx, 0);
                        this.setDY(n, packdy, 0);
                    }
                    if (!playerdead && y[n] <= py + pedgeV && y[n] >= py - pedgeV && x[n] <= px + pedgeH && x[n] >= px - pedgeH) {
                        this.playerHit();
                    }
                }
                if (laser && lasery <= y[n] + edgeV && lasery >= y[n] - edgeV && laserx <= x[n] + edgeH && laserx >= x[n] - edgeH) {
                    this.alienHit(n);
                }
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < slen) {
            if (!dead[n2]) {
                if (framecount == 3) {
                    Swarm.frame[n2] = frame[n2] + 1 >= 2 ? 0 : 1;
                }
                lastx = x[n2];
                lasty = y[n2];
                int n3 = n2;
                x[n3] = x[n3] + dx[n2][dxcount[n2]];
                int n4 = n2;
                y[n4] = y[n4] + dy[n2][dycount[n2]];
                if (pmode[n2] == 0) {
                    Swarm.dxcount[n2] = dxcount[n2] + 1 >= dx[n2].length ? 0 : dxcount[n2] + 1;
                    Swarm.dycount[n2] = dycount[n2] + 1 >= dy[n2].length ? 0 : dycount[n2] + 1;
                } else if (pmode[n2] == 2) {
                    Swarm.dxcount[n2] = dxcount[n2] + 1 >= dx[n2].length ? dxcount[n2] : dxcount[n2] + 1;
                    Swarm.dycount[n2] = dycount[n2] + 1 >= dy[n2].length ? dycount[n2] : dycount[n2] + 1;
                }
                int n5 = n2;
                packX[n5] = packX[n5] + packdx[packcount];
                int n6 = n2;
                packY[n6] = packY[n6] + packdy[packcount];
            }
            ++n2;
        }
        packcount = packcount + 1 >= packlen ? 0 : packcount + 1;
        int n7 = framecount = framecount + 1 >= 4 ? 0 : framecount + 1;
        if (laser && (lasery -= 6) < 0) {
            laser = false;
        }
    }

    private void setDX(int n, int[] nArray, int n2) {
        if (n == -1) {
            int n3 = 0;
            while (n3 < slen) {
                if (!flying[n3]) {
                    Swarm.dx[n3] = nArray;
                    Swarm.dxcount[n3] = 0;
                    Swarm.pmode[n3] = n2;
                }
                ++n3;
            }
        } else {
            Swarm.dx[n] = nArray;
            Swarm.dxcount[n] = 0;
            Swarm.pmode[n] = n2;
        }
    }

    private void setDY(int n, int[] nArray, int n2) {
        if (n == -1) {
            int n3 = 0;
            while (n3 < slen) {
                if (!flying[n3]) {
                    Swarm.dy[n3] = nArray;
                    Swarm.dycount[n3] = 0;
                    Swarm.pmode[n3] = n2;
                }
                ++n3;
            }
        } else {
            Swarm.dy[n] = nArray;
            Swarm.dycount[n] = 0;
            Swarm.pmode[n] = n2;
        }
    }

    private void changePackDir(int[] nArray, int[] nArray2) {
        this.setDX(-1, nArray, 0);
        this.setDY(-1, nArray2, 0);
        packdx = nArray;
        packdy = nArray2;
        packcount = 0;
    }

    private void updatePlayerPos(int n) {
        plastx = px;
        if ((px += n) + pedgeH > WIDTH || px - pedgeH < 0) {
            px = plastx;
        }
    }

    private void fireLaser() {
        if (!laser) {
            laser = true;
            laserx = px;
            lasery = py;
        }
    }

    private void alienHit(int n) {
        if (!playerdead) {
            Swarm.dead[n] = true;
            laser = false;
            score = flying[n] ? (score += 200) : (score += 50);
            if (++killed == slen) {
                this.waveComplete();
            }
            scorestr = this.getScoreStr(score);
        }
    }

    private void playerHit() {
        playerdead = true;
        playerpause = 0;
        explodeframe = 0;
        if (--lives == 0) {
            this.gameOver();
        }
    }

    private void waveComplete() {
        wavecomplete = true;
        if ((difficulty -= 100) < 100) {
            difficulty = 100;
        }
        msg = "WAVE " + wave + " COMPLETE";
        messagepause = 0;
        showmessage = true;
        scorestr = this.getScoreStr(score += 1000 * ++wave);
    }

    private void gameOver() {
        gameover = true;
        msg = "GAME OVER";
        int n = 0;
        while (n < 5) {
            if (score >= highscore[n]) {
                int n2 = 4;
                while (n2 > n) {
                    Swarm.highscore[n2] = highscore[n2 - 1];
                    --n2;
                }
                Swarm.highscore[n] = score;
                rank = n;
                break;
            }
            ++n;
        }
        this.setHighScores();
        showmessage = true;
        messagepause = 0;
        this.addEndCommands((Displayable)this.mainscreen, true);
    }

    private void addBeginCommands(Displayable displayable, boolean bl) {
        if (bl) {
            this.removeCommands();
        }
        displayable.addCommand(this.playCommand);
        displayable.addCommand(this.exitCommand);
        displayable.setCommandListener((CommandListener)this);
    }

    private void addPlayCommands(Displayable displayable, boolean bl) {
        if (bl) {
            this.removeCommands();
        }
        displayable.addCommand(this.nullCommand);
        displayable.addCommand(this.quitCommand);
        displayable.setCommandListener((CommandListener)this);
    }

    private void addEndCommands(Displayable displayable, boolean bl) {
        if (bl) {
            this.removeCommands();
        }
        displayable.addCommand(this.againCommand);
        displayable.addCommand(this.quitCommand);
        displayable.setCommandListener((CommandListener)this);
    }

    private void removeCommands() {
        Displayable displayable = this.display.getCurrent();
        displayable.removeCommand(this.nullCommand);
        displayable.removeCommand(this.quitCommand);
        displayable.removeCommand(this.againCommand);
        displayable.removeCommand(this.playCommand);
        displayable.removeCommand(this.exitCommand);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.playCommand) {
            this.display.setCurrent((Displayable)this.mainscreen);
            this.startGame();
        }
        if (command == this.quitCommand) {
            this.runner = false;
            while (this.th.isAlive()) {
            }
            this.th = null;
            this.addPlayCommands((Displayable)this.mainscreen, true);
            this.display.setCurrent((Displayable)this.titlescreen);
        }
        if (command == this.againCommand) {
            this.runner = false;
            while (this.th.isAlive()) {
            }
            this.th = null;
            this.display.setCurrent((Displayable)this.mainscreen);
            this.addPlayCommands((Displayable)this.mainscreen, true);
            this.startGame();
        }
        if (command == this.exitCommand) {
            this.destroyApp(false);
            this.notifyDestroyed();
        }
    }

    private int[] getHighScores() {
        int[] nArray = new int[]{5000, 4000, 3000, 2000, 1000};
        byte[][] byArray = new byte[5][6];
        try {
            hsdata = RecordStore.openRecordStore((String)"swarm", (boolean)true);
            int n = hsdata.getNumRecords();
            if (n == 0) {
                int n2 = 0;
                while (n2 < 5) {
                    byArray[n2] = Integer.toString(nArray[n2]).getBytes();
                    hsdata.addRecord(byArray[n2], 0, byArray[n2].length);
                    ++n2;
                }
            } else {
                int n3 = 0;
                while (n3 < 5) {
                    byArray[n3] = hsdata.getRecord(n3 + 1);
                    String string = "";
                    int n4 = 0;
                    while (n4 < byArray[n3].length) {
                        string = string + (char)byArray[n3][n4] + "";
                        ++n4;
                    }
                    nArray[n3] = Integer.parseInt(string);
                    ++n3;
                }
            }
        }
        catch (RecordStoreException recordStoreException) {
            Swarm.db("problem with initialising highscore data\n" + (Object)((Object)recordStoreException));
        }
        return nArray;
    }

    private void setHighScores() {
        byte[][] byArray = new byte[5][6];
        try {
            hsdata = RecordStore.openRecordStore((String)"swarm", (boolean)true);
            int n = 0;
            while (n < 5) {
                byArray[n] = Integer.toString(highscore[n]).getBytes();
                hsdata.setRecord(n + 1, byArray[n], 0, byArray[n].length);
                ++n;
            }
        }
        catch (RecordStoreException recordStoreException) {
            Swarm.db("problem with setting highscore data\n" + (Object)((Object)recordStoreException));
        }
    }

    private String getScoreStr(int n) {
        templen = 6 - (n + "").length();
        tempstr = "";
        int n2 = 0;
        while (n2 < templen) {
            tempstr = tempstr + "0";
            ++n2;
        }
        return tempstr + n;
    }

    public static void db(String string) {
        System.out.println(string);
    }

    public static void db(int n) {
        System.out.println(n + "");
    }

    static {
        alienimg = new Image[2];
        explosionimg = new Image[3];
        fs = Font.getFont((int)64, (int)0, (int)8);
        fl = Font.getFont((int)64, (int)1, (int)16);
        sposX = new int[]{16, 28, 40, 52, 4, 16, 28, 40, 52, 64, 4, 16, 28, 40, 52, 64};
        sposY = new int[]{14, 14, 14, 14, 26, 26, 26, 26, 26, 26, 38, 38, 38, 38, 38, 38};
        move_none = new int[]{0};
        alien_dx_right = new int[]{1, 1, 1, 1, 1, 1, 1, 1};
        alien_dy_right = new int[]{0, 0, 1, 1, 0, 0, -1, -1};
        alien_dx_left = new int[]{-1, -1, -1, -1, -1, -1, -1, -1};
        alien_dy_left = new int[]{0, 0, -1, -1, 0, 0, 1, 1};
        alien_dx_flyright = new int[]{1, 1, 1, 0, -1, -1, -1, -1, -1, 0, 1, 1, 2, 3, 4, 5, 6};
        alien_dy_flyright = new int[]{0, -1, -1, -1, -1, -1, 0, 1, 1, 1, 1, 1, 2, 3, 4, 5, 6};
        alien_dx_flyleft = new int[]{-1, -1, -1, 0, 1, 1, 1, 1, 1, 0, -1, -1, -2, -3, -4, -5, -6};
        alien_dy_flyleft = new int[]{0, -1, -1, -1, -1, -1, 0, 1, 1, 1, 1, 1, 2, 3, 4, 5, 6};
        slen = sposX.length;
        ailen = alien_dx_flyright.length;
        packlen = alien_dx_right.length;
        pmode = new int[slen];
        x = new int[slen];
        y = new int[slen];
        dx = new int[slen][ailen];
        dy = new int[slen][ailen];
        dxcount = new int[slen];
        dycount = new int[slen];
        frame = new int[slen];
        flying = new boolean[slen];
        dead = new boolean[slen];
        exploding = new boolean[slen];
        packX = new int[slen];
        packY = new int[slen];
        packdx = new int[packlen];
        packdy = new int[packlen];
        framecount = 3;
        highscore = new int[5];
    }

    class ScoreScreen
    extends Canvas {
        ScoreScreen() {
        }

        public void paint(Graphics graphics) {
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(0, 0, WIDTH, HEIGHT);
            graphics.setColor(1442449);
            graphics.setFont(fs);
            graphics.drawString("Instructions", CENTERW, 2, 17);
            graphics.setColor(0);
            graphics.drawString("Use left/right and fire", CENTERW, 20, 17);
            graphics.drawString("to destory the", CENTERW, 30, 17);
            graphics.drawString("incoming alien swarm", CENTERW, 40, 17);
            graphics.drawString("Alien", 2, 55, 20);
            graphics.drawString("Flying alien", 2, 65, 20);
            graphics.drawString("Wave Bonus", 2, 75, 20);
            graphics.setColor(0xFF0000);
            graphics.drawString("50", WIDTH - 2, 55, 24);
            graphics.drawString("200", WIDTH - 2, 65, 24);
            graphics.drawString("x1000", WIDTH - 2, 75, 24);
        }

        public void keyPressed(int n) {
            int n2 = this.getGameAction(n);
            if (n2 == 8) {
                Swarm.this.display.setCurrent((Displayable)Swarm.this.titlescreen);
            }
        }
    }

    class TitleScreen
    extends Canvas {
        TitleScreen() {
        }

        public void paint(Graphics graphics) {
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(0, 0, WIDTH, HEIGHT);
            graphics.drawImage(logoimg, CENTERW, 15, 17);
            graphics.setColor(0);
            graphics.setFont(fs);
            graphics.drawString("Press Fire to", CENTERW, 43, 17);
            graphics.drawString("view instructions", CENTERW, 53, 17);
            graphics.setColor(0xFF0000);
            graphics.drawString("www.zeroindex.co.uk", CENTERW, HEIGHT - 19, 17);
        }

        public void keyPressed(int n) {
            int n2 = this.getGameAction(n);
            if (n2 == 8) {
                Swarm.this.display.setCurrent((Displayable)Swarm.this.scorescreen);
            }
        }
    }

    class MainScreen
    extends Canvas {
        private Image offimg = Image.createImage((int)this.getWidth(), (int)this.getHeight());
        private Graphics offg = this.offimg.getGraphics();

        public MainScreen() {
            this.offg.setFont(fs);
        }

        public void paint(Graphics graphics) {
            this.offg.setColor(0xFFFFFF);
            this.offg.fillRect(0, 0, WIDTH, HEIGHT);
            int n = 0;
            while (n < slen) {
                if (!dead[n]) {
                    this.offg.drawImage(alienimg[frame[n]], x[n], y[n], 17);
                }
                ++n;
            }
            if (!playerdead) {
                this.offg.drawImage(playerimg, px, py, 17);
            } else {
                if (explodeframe < 3) {
                    this.offg.drawImage(explosionimg[explodeframe], px, py, 17);
                    explodeframe++;
                }
                if (!gameover) {
                    playerpause++;
                    if (playerpause < 50) {
                        playerpause++;
                    } else {
                        playerdead = false;
                        playerpause = 0;
                        px = CENTERW;
                    }
                }
            }
            this.offg.setColor(0);
            this.offg.drawString(scorestr, WIDTH, 0, 24);
            this.offg.drawImage(playerimg, 0, 0, 20);
            this.offg.drawString(lives + "", 12, 0, 20);
            if (laser) {
                this.offg.drawLine(laserx, lasery, laserx, lasery + 4);
            }
            if (showscores) {
                int n2 = 0;
                while (n2 < 5) {
                    if (n2 == rank) {
                        this.offg.setColor(0xFF0000);
                    } else {
                        this.offg.setColor(0);
                    }
                    this.offg.drawString(n2 + 1 + " .... " + Swarm.this.getScoreStr(highscore[n2]), CENTERW, 20 + n2 * 10, 17);
                    ++n2;
                }
            }
            if (showmessage) {
                this.offg.setColor(0xFF0000);
                this.offg.drawString(msg, CENTERW, CENTERH, 17);
                messagepause++;
                if (messagepause > 20) {
                    showmessage = false;
                    messagepause = 0;
                    if (gameover) {
                        showscores = true;
                    } else if (wavecomplete) {
                        Swarm.this.initWave();
                    }
                }
            }
            graphics.drawImage(this.offimg, 0, 0, 20);
        }

        public void keyPressed(int n) {
            int n2 = this.getGameAction(n);
            if (n2 == 2) {
                playerLeft = true;
            } else if (n2 == 5) {
                playerRight = true;
            } else if (n2 == 8) {
                Swarm.this.fireLaser();
            }
        }

        public void keyReleased(int n) {
            int n2 = this.getGameAction(n);
            if (n2 == 2) {
                playerLeft = false;
            } else if (n2 == 5) {
                playerRight = false;
            }
        }
    }
}

