/*
 * Decompiled with CFR 0.152.
 */
package bbmidlet;

import bbmidlet.BBMidlet;
import bbmidlet.feedback.DefaultSound;
import bbmidlet.feedback.Sound;
import bbmidlet.game.BBall;
import bbmidlet.game.Basket;
import bbmidlet.mode.DemoMode;
import bbmidlet.mode.GameMode;
import bbmidlet.mode.MessageListener;
import bbmidlet.mode.PracticeMode;
import bbmidlet.mode.ShotsMode;
import bbmidlet.mode.TimeMode;
import java.util.Random;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class BBCanvas
extends Canvas
implements MessageListener {
    public static final int PRACTICE_MODE = 0;
    public static final int SHOTS_MODE = 1;
    public static final int TIME_MODE = 2;
    public static final int DEMO_MODE = 3;
    private BBMidlet f1;
    private Display f2;
    private Displayable f3;
    private int f4;
    private int f5;
    public int playheight;
    private boolean f6;
    private boolean f7;
    Basket basket;
    public BBall ball;
    private boolean f8;
    private boolean f9;
    private boolean f10;
    private int f11;
    private int f12;
    private int f13;
    private int f14;
    private int f15;
    private int f16;
    private int f17;
    private int f18;
    private int f19;
    private String f20;
    private String f21;
    private int f22;
    private GameMode f23 = new PracticeMode();
    private boolean f24;
    private Random f25 = new Random(System.currentTimeMillis());
    private Sound f26;
    private Image f27;
    private int f28;
    private int f29;
    private static String f30 = "/icons/";

    public BBCanvas(BBMidlet bBMidlet, Display display, Displayable displayable) {
        int n;
        this.f1 = bBMidlet;
        this.f2 = display;
        this.f3 = displayable;
        this.f4 = BBMidlet.getIntProperty("width", this.getWidth());
        this.f5 = this.getHeight();
        this.f19 = BBMidlet.getIntProperty("background", 0xFFFFFF, 16);
        this.f7 = true;
        try {
            this.f26 = (Sound)Class.forName(bBMidlet.getAppProperty("Feedback_class")).newInstance();
        }
        catch (Exception exception) {
            this.f26 = new DefaultSound();
        }
        int n2 = BBMidlet.getIntProperty("basket_width", 0);
        if (n2 == 0) {
            n2 = 26;
            if (this.f4 > 120) {
                n2 = 40;
            }
            if (this.f4 > 160) {
                n2 = 52;
            }
        }
        if ((n = BBMidlet.getIntProperty("ball_width", 0)) == 0) {
            n = 16;
            if (this.f4 > 120) {
                n = 24;
            }
            if (this.f4 > 160) {
                n = 32;
            }
        }
        this.f6 = BBMidlet.getIntProperty("textabove", -1) == -1 ? this.f5 < 90 : BBMidlet.getIntProperty("textabove", 0) != 0;
        this.playheight = this.f6 ? this.f5 : this.f5 - Font.getDefaultFont().getHeight();
        if (this.f2.numColors() == 2) {
            f30 = f30 + "bw/";
        } else if (!this.f2.isColor()) {
            f30 = f30 + "gray/";
        }
        String string = "basket";
        String string2 = ".png";
        BBCanvas bBCanvas = this;
        this.basket = new Basket(bBCanvas, bBCanvas.f2, this.f19, f30 + string + "r" + n2 + string2, f30 + string + "l" + n2 + string2, n2, this.f4, this.playheight >> 1, false);
        BBCanvas bBCanvas2 = this;
        this.ball = new BBall(bBCanvas2, bBCanvas2.f2, this.f19, f30 + "bball" + n + string2, n, this.f4, this.playheight, this.basket, this.f26);
        try {
            this.f27 = Image.createImage((String)(f30 + "background" + string2));
            if (this.f27 != null) {
                this.f28 = this.f4 - this.f27.getWidth() >> 1;
                this.f29 = this.playheight - this.f27.getHeight() >> 1;
            }
        }
        catch (Exception exception) {}
        this.f9 = this.isDoubleBuffered();
        this.setGameMode(BBMidlet.getSettings().gamemode);
        this.f23.setMessageListener(this);
        BBCanvas bBCanvas3 = this;
        bBCanvas3.setMessage(bBCanvas3.f23.getMessage());
    }

    public GameMode getGameModeObject() {
        return this.f23;
    }

    public int getGameMode() {
        return this.f22;
    }

    public void setGameMode(int n) {
        if (this.f22 != n) {
            this.pause();
            this.f22 = n;
            if (this.f23 != null) {
                this.f23.setMessageListener(null);
            }
            switch (n) {
                case 0: {
                    this.f23 = new PracticeMode();
                    break;
                }
                case 1: {
                    this.f23 = new ShotsMode();
                    break;
                }
                case 2: {
                    this.f23 = new TimeMode();
                    break;
                }
                case 3: {
                    this.f23 = new DemoMode(this);
                    break;
                }
                default: {
                    this.f23 = new PracticeMode();
                }
            }
            this.f23.setMessageListener(this);
            BBCanvas bBCanvas = this;
            bBCanvas.setMessage(bBCanvas.f23.getMessage());
            if (n != 3) {
                BBMidlet.getSettings().gamemode = n;
            }
        }
    }

    public void updateMessage(String string) {
        this.setMessage(string);
        if (this.f23.isTimeBased()) {
            this.checkGameFinished();
        }
    }

    public int getBackground() {
        return this.f19;
    }

    protected void paint(Graphics graphics) {
        if (this.f9 || this.f8) {
            graphics.setColor(this.f19);
            graphics.fillRect(0, 0, this.f4, this.f5);
            this.f8 = false;
            this.f21 = null;
        } else {
            if (this.f10) {
                graphics.setColor(this.f19);
                graphics.drawLine(this.f15, this.f16, this.f17, this.f18);
            }
            this.ball.clear(graphics);
        }
        if (this.f27 != null) {
            graphics.drawImage(this.f27, this.f28, this.f29, 20);
        }
        graphics.setColor(0);
        this.m1(graphics);
        this.ball.draw(graphics);
        this.basket.draw(graphics);
        graphics.getFont().getHeight();
        graphics.drawLine(0, this.playheight - 1, this.f4, this.playheight - 1);
        graphics.drawLine(this.f4, 0, this.f4, this.playheight - 1);
        if (this.f10) {
            graphics.setColor(0);
            graphics.drawLine(this.f11, this.f12, this.f13, this.f14);
            this.f15 = this.f11;
            this.f16 = this.f12;
            this.f17 = this.f13;
            this.f18 = this.f14;
        }
        if (this.ball.checkTreffer() != 0) {
            this.addHit();
            this.pause();
            int n = this.basket.baskety + this.ball.radius / 3;
            if (this.basket.left) {
                this.ball.setXY(this.basket.getBasketWidth() - (this.basket.getBasketOpening() >> 1), n);
            } else {
                this.ball.setXY(this.basket.basketx + (this.basket.getBasketOpening() >> 1), n);
            }
            this.repaint();
        }
    }

    private void m1(Graphics graphics) {
        if (this.f21 != this.f20 || this.f6) {
            int n = this.f5 - this.playheight;
            if (this.f21 != null && this.f21 != this.f20) {
                graphics.setColor(this.f19);
                if (this.f6) {
                    graphics.fillRect(5, 1, graphics.getFont().stringWidth(this.f21), n);
                } else {
                    graphics.fillRect(5, this.playheight, graphics.getFont().stringWidth(this.f21), n);
                }
                graphics.setColor(0);
            }
            this.f21 = this.f20;
            if (this.f6) {
                graphics.drawString(this.f20, 5, 1, 20);
                return;
            }
            graphics.drawString(this.f20, 5, this.playheight, 20);
        }
    }

    public void setMessage(String string) {
        this.f20 = string;
        this.repaint();
    }

    public void addShot() {
        this.f23.addShot();
        if (BBMidlet.getSettings().sound) {
            this.f26.shot(this.f2);
        }
    }

    public void addHit() {
        this.f24 = true;
        this.f23.addHit();
        if (BBMidlet.getSettings().sound) {
            this.f26.hit(this.f2);
        }
    }

    public void checkGameFinished() {
        if (this.f23.isFinished()) {
            if (this.f23.isHighScore() >= 0) {
                this.f1.showName();
                return;
            }
            String string = BBMidlet.getProperty(21);
            Alert alert = new Alert(BBMidlet.getProperty(22));
            alert.setString(string);
            alert.setType(AlertType.INFO);
            alert.setTimeout(-2);
            this.pause();
            this.f2.setCurrent(alert, this.f3);
            this.f8 = true;
        }
    }

    private void m2() {
        this.basket.setLeft(!this.basket.left);
        if (!this.basket.left) {
            this.basket.setXY(this.f4 - this.basket.getBasketWidth(), this.basket.y);
            return;
        }
        this.basket.setXY(0, this.basket.y);
    }

    private void m3() {
        if (!BBMidlet.getSettings().fixedbasket) {
            this.m2();
            this.basket.setXY(this.basket.x, (this.playheight >> 1) + (int)((long)this.f25.nextInt() * (long)this.playheight / 4L / Integer.MAX_VALUE));
            this.f8 = true;
        }
        this.ball.y = this.playheight - this.ball.radius;
        this.ball.x = (int)((long)this.f25.nextInt() * (long)(this.f4 - this.basket.getBasketWidth()) / Integer.MAX_VALUE / 2L + (long)(this.f4 - this.basket.getBasketWidth() >> 1));
        if (this.ball.x < this.ball.radius) {
            this.ball.x = this.ball.radius;
        }
        if (this.ball.x > this.f4 - this.basket.getBasketWidth() - 2 * this.ball.radius) {
            this.ball.x = this.f4 - this.basket.getBasketWidth() - 2 * this.ball.radius;
        }
        if (this.basket.left) {
            this.ball.x += this.basket.getBasketWidth();
        }
        this.repaint();
    }

    public void keyPressed(int n) {
        BBCanvas bBCanvas = this;
        bBCanvas.handleKeyPressed(bBCanvas.getGameAction(n));
    }

    public void handleKeyPressed(int n) {
        this.checkGameFinished();
        if (n != 0) {
            if (!this.f24 && !this.f10) {
                this.pause();
                this.ball.setVelocity(0, 0);
                this.f11 = this.f13 = this.ball.x;
                this.f12 = this.f14 = this.ball.y;
                this.f10 = true;
            }
            int n2 = 3 * this.ball.radius >> 3;
            switch (n) {
                case 2: {
                    this.f13 -= n2;
                    break;
                }
                case 5: {
                    this.f13 += n2;
                    break;
                }
                case 1: {
                    this.f14 -= n2;
                    break;
                }
                case 6: {
                    this.f14 += n2;
                    break;
                }
                case 8: {
                    if (this.f24) {
                        this.m3();
                        this.f24 = false;
                        break;
                    }
                    this.f10 = false;
                    this.repaint();
                    this.ball.setVelocity(this.f13 - this.f11, this.f14 - this.f12, 4);
                    this.start();
                    this.addShot();
                }
            }
            this.repaint();
        }
    }

    protected void pointerPressed(int n, int n2) {
        if (this.f24) {
            this.m3();
            this.f24 = false;
            return;
        }
        if (this.ball.inside(n, n2)) {
            this.pause();
            this.ball.setVelocity(0, 0);
            this.f11 = this.f13 = this.ball.x;
            this.f12 = this.f14 = this.ball.y;
            this.f10 = true;
        }
    }

    protected void pointerDragged(int n, int n2) {
        if (this.f10) {
            this.f13 = n;
            this.f14 = n2;
            this.repaint();
        }
    }

    protected void pointerReleased(int n, int n2) {
        if (this.f10) {
            this.f13 = n;
            this.f14 = n2;
            this.f10 = false;
            this.repaint();
            this.ball.setVelocity(this.f13 - this.f11, this.f14 - this.f12, 6);
            this.start();
            this.addShot();
        }
    }

    void destroy() {
        this.pause();
    }

    boolean isPaused() {
        return this.f7;
    }

    void pause() {
        this.f7 = true;
        this.ball.stop();
        this.repaint();
    }

    void stop() {
        this.pause();
        this.f23.pause();
    }

    void start() {
        this.f24 = false;
        this.f7 = false;
        this.f2.setCurrent((Displayable)this);
        this.ball.start();
        this.f8 = true;
        this.repaint();
    }

    void restart() {
        this.ball.x = this.f4 >> 1;
        this.ball.y = this.playheight >> 1;
        this.ball.setVelocity(0, 0);
        this.ball.setGravity(BBMidlet.getSettings().gravity);
        this.f23.start();
        this.f10 = false;
        this.start();
    }
}

