/*
 * Decompiled with CFR 0.152.
 */
package bbmidlet.game;

import bbmidlet.feedback.Sound;
import bbmidlet.game.Basket;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class BBall
implements Runnable {
    protected Thread ballthread;
    protected Basket basket;
    protected boolean runs;
    protected Image img;
    protected Canvas parent;
    public int x;
    public int y;
    public int radius;
    protected int vx;
    protected int vy;
    protected int vydelta;
    protected int daempfung;
    protected int oldx;
    protected int oldy;
    private Sound f1;
    private Display f2;
    private int f3;
    private int f4;
    private int f5;
    private int f6;
    private int f7 = 0;

    public BBall(Canvas canvas, Display display, int n, String string, int n2, int n3, int n4, Basket basket, Sound sound) {
        this.parent = canvas;
        this.basket = basket;
        this.f3 = n;
        this.f1 = sound;
        this.f2 = display;
        if (string != null) {
            try {
                this.img = Image.createImage((String)string);
            }
            catch (Exception exception) {
                this.img = null;
            }
        } else {
            this.img = null;
        }
        if (this.img != null) {
            this.radius = this.img.getWidth() >> 1;
        } else {
            this.radius = n2 >> 1;
            this.img = Image.createImage((int)(2 * this.radius), (int)(2 * this.radius));
            BBall bBall = this;
            bBall.m1(bBall.img.getGraphics());
            this.img = Image.createImage((Image)this.img);
        }
        this.setGravity(102);
        this.f4 = n3;
        this.f5 = n4;
        this.x = n3 >> 1;
        this.y = n4 >> 1;
        this.oldx = this.x;
        this.oldy = this.y;
        this.f6 = -1;
        this.setVelocity(0, 0);
        this.daempfung = 180;
        this.runs = false;
    }

    private void m1(Graphics graphics) {
        graphics.setColor(this.f3);
        graphics.fillRect(0, 0, graphics.getClipWidth(), graphics.getClipHeight());
        if (this.f2.numColors() > 2) {
            graphics.setColor(250, 102, 0);
        } else {
            graphics.setColor(0);
        }
        graphics.fillArc(0, 0, graphics.getClipWidth() - 1, graphics.getClipHeight() - 1, 0, 360);
    }

    public void setGravity(int n) {
        this.vydelta = n * 10 * this.radius >> 3;
    }

    public void setVelocity(int n, int n2) {
        this.setVelocity(n, n2, 1);
    }

    public void setVelocity(int n, int n2, int n3) {
        this.vx = (n << 8) / n3;
        this.vy = (n2 << 8) / n3;
        this.f6 = -1;
    }

    public void start() {
        this.runs = true;
        this.ballthread = new Thread(this);
        this.ballthread.start();
    }

    public void run() {
        try {
            long l = System.currentTimeMillis();
            int n = 62;
            while (this.runs) {
                int n2;
                long l2 = l;
                l = System.currentTimeMillis();
                long l3 = (long)n - (l - l2);
                if (l3 > 0L) {
                    Thread.sleep(l3);
                    n2 = 1;
                } else {
                    n2 = (int)(-l3) / n + 2;
                }
                if (n2 > 2) {
                    n2 = 2;
                }
                while (n2-- > 0 && this.runs) {
                    this.bewegung();
                }
                this.parent.repaint();
                Thread.yield();
            }
            this.parent.repaint();
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public void stop() {
        this.vx = 0;
        this.vy = 0;
        this.f6 = -1;
        this.runs = false;
    }

    public void draw(Graphics graphics) {
        if (this.img != null) {
            graphics.drawImage(this.img, this.x - this.radius, this.y - this.radius, 20);
            this.oldx = this.x;
            this.oldy = this.y;
        }
    }

    public void clear(Graphics graphics) {
        if (this.img != null) {
            graphics.setColor(this.f3);
            graphics.fillRect(this.oldx - this.radius, this.oldy - this.radius, this.img.getWidth(), this.img.getHeight());
        }
    }

    public boolean inside(int n, int n2) {
        return (this.x - n) * (this.x - n) + (this.y - n2) * (this.y - n2) - this.radius * this.radius <= 0;
    }

    public boolean move(int n, int n2) {
        this.setXY(n, n2);
        if (Math.abs(this.vx) < 256 && this.vy < 512 && n2 >= this.f5 - this.radius) {
            this.stop();
        }
        boolean bl = this.checkWall();
        if (this.f1 != null && bl) {
            this.f1.bounce(this.f2);
        }
        if (this.f1 != null && (bl |= this.checkBasket())) {
            this.f1.basket(this.f2);
        }
        this.parent.repaint();
        return !bl;
    }

    public boolean checkBasket() {
        int n = this.basket.basketx;
        int n2 = this.basket.baskety;
        if (this.inside(n, n2)) {
            if (Math.abs(this.vx) < 256) {
                this.vx = 256;
            }
            this.vx = n < this.x ? Math.abs(this.vx) : -Math.abs(this.vx);
            this.vy = -this.vy;
            if (Math.abs(this.vx) > 512 || Math.abs(this.vy) > 512) {
                this.Daempfung(100);
            }
            return true;
        }
        n = this.basket.basketx + this.basket.getBasketOpening();
        if (this.inside(n, n2)) {
            if (Math.abs(this.vx) < 256) {
                this.vx = 256;
            }
            this.vx = n < this.x ? Math.abs(this.vx) : -Math.abs(this.vx);
            this.vy = -this.vy;
            if (Math.abs(this.vx) > 512 || Math.abs(this.vy) > 512) {
                this.Daempfung(100);
            }
            return true;
        }
        return false;
    }

    public boolean checkWall() {
        boolean bl = false;
        if (this.x <= this.radius) {
            this.setXY(2 * this.radius - this.x, this.y);
            this.vx = -this.vx;
            BBall bBall = this;
            bBall.Daempfung(bBall.daempfung);
            bl = true;
        } else if (this.x >= this.f4 - this.radius) {
            this.setXY(2 * (this.f4 - this.radius) - this.x, this.y);
            this.vx = -this.vx;
            BBall bBall = this;
            bBall.Daempfung(bBall.daempfung);
            bl = true;
        }
        if (this.y >= this.f5 - this.radius) {
            if (this.f6 < 0) {
                this.f6 = this.vy;
            }
            if (this.f6 < this.vy) {
                this.vy = 0;
            }
            this.f6 = this.vy;
            BBall bBall = this;
            bBall.setXY(bBall.x, this.f5 - this.radius);
            this.vy = -this.vy;
            BBall bBall2 = this;
            bBall2.Daempfung(bBall2.daempfung);
            return true;
        }
        return bl;
    }

    public int checkTreffer() {
        if (this.x > this.basket.basketx && this.x < this.basket.basketx + this.basket.getBasketOpening() && this.y >= this.basket.baskety && this.f7 < this.basket.baskety && this.vy >= 0) {
            this.f7 = this.y;
            return 1;
        }
        this.f7 = this.y;
        return 0;
    }

    public void Daempfung(int n) {
        this.vx = this.vx * n >> 8;
        this.vy = this.vy * n >> 8;
    }

    public void bewegung() {
        BBall bBall = this;
        bBall.move(bBall.x + (this.vx >> 8), this.y + (this.vy >> 8));
        this.vy += this.vydelta;
    }

    public void setXY(int n, int n2) {
        this.x = n;
        this.y = n2;
    }
}

