/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.Vector;

public class Board {
    public byte[] board;
    private Piece[][] _$2102;
    private Vector _$2103 = new Vector();
    private int _$2104 = 8;
    private int _$2105 = 8;
    protected ChessGame game;
    private byte[] _$2106 = new byte[]{3, 4, 5, 2, 1, 5, 4, 3, 6, 6, 6, 6, 6, 6, 6, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 14, 14, 14, 14, 14, 14, 14, 11, 12, 13, 10, 9, 13, 12, 11};
    protected Piece[] kings;
    protected Vector whitePieces;
    protected Vector blackPieces;

    public Board(ChessGame chessGame) {
        this.board = new byte[this._$2104 * this._$2105];
        this._$2102 = new Piece[this._$2104][this._$2105];
        int n = 0;
        while (n < this._$2104) {
            int n2 = 0;
            while (n2 < this._$2105) {
                this._$2102[n][n2] = null;
                ++n2;
            }
            ++n;
        }
        this.kings = new Piece[2];
        this.kings[0] = null;
        this.kings[1] = null;
        this.whitePieces = new Vector();
        this.blackPieces = new Vector();
        this.game = chessGame;
    }

    public void initBoard() {
        int n = 0;
        while (n < 64) {
            Position position = new Position(n & 7, n >>> 3);
            this.removePiece(position);
            byte by = this._$2106[n];
            if (by != 0) {
                switch (by & 7) {
                    case 1: {
                        this.addPiece(new King(by & 8, position));
                        break;
                    }
                    case 2: {
                        this.addPiece(new Queen(by & 8, position));
                        break;
                    }
                    case 3: {
                        this.addPiece(new Rook(by & 8, position));
                        break;
                    }
                    case 4: {
                        this.addPiece(new Knight(by & 8, position));
                        break;
                    }
                    case 5: {
                        this.addPiece(new Bishop(by & 8, position));
                        break;
                    }
                    case 6: {
                        this.addPiece(new Pawn(by & 8, position));
                    }
                }
            }
            ++n;
        }
    }

    public Position getKingPosition(int n) {
        if (n == 0) {
            if (this.kings[0] != null) {
                return this.kings[0].getPosition();
            }
            return null;
        }
        if (this.kings[1] != null) {
            return this.kings[1].getPosition();
        }
        return null;
    }

    public boolean removePiece(int n, int n2) {
        Piece piece = this.getPiece(n, n2);
        if (piece != null && this._$2102[n][n2] != null) {
            this._$2103.removeElement(this._$2102[n][n2]);
            this._$2102[n][n2] = null;
            this.board[n + (n2 << 3)] = 0;
            if (piece.getColor() == 0) {
                this.whitePieces.removeElement(piece);
            } else {
                this.blackPieces.removeElement(piece);
            }
            return true;
        }
        return false;
    }

    public int getNumWhitePieces() {
        return this.whitePieces.size();
    }

    public Enumeration getWhitePieces() {
        return this.whitePieces.elements();
    }

    public int getNumBlackPieces() {
        return this.blackPieces.size();
    }

    public Enumeration getBlackPieces() {
        return this.blackPieces.elements();
    }

    public boolean isUnderThreat(Position position, int n) {
        Enumeration enumeration = n == 8 ? this.getBlackPieces() : this.getWhitePieces();
        while (enumeration.hasMoreElements()) {
            Piece piece = (Piece)enumeration.nextElement();
            if (!piece.threatens(position)) continue;
            return true;
        }
        return false;
    }

    public Vector getValidMoves(int n) {
        Vector<Move> vector = new Vector<Move>();
        Enumeration enumeration = n == 0 ? this.getWhitePieces() : this.getBlackPieces();
        while (enumeration.hasMoreElements()) {
            Piece piece = (Piece)enumeration.nextElement();
            Enumeration enumeration2 = piece.getPossibleMoves().elements();
            boolean bl = false;
            while (enumeration2.hasMoreElements()) {
                Move move = (Move)enumeration2.nextElement();
                vector.addElement(move);
            }
        }
        return vector;
    }

    public boolean addPiece(int n, int n2, Position position) {
        switch (n) {
            case 1: {
                this.addPiece(new King(n2, new Position(position.x, position.y)));
                break;
            }
            case 2: {
                this.addPiece(new Queen(n2, new Position(position.x, position.y)));
                break;
            }
            case 3: {
                this.addPiece(new Rook(n2, new Position(position.x, position.y)));
                break;
            }
            case 4: {
                this.addPiece(new Knight(n2, new Position(position.x, position.y)));
                break;
            }
            case 5: {
                this.addPiece(new Bishop(n2, new Position(position.x, position.y)));
                break;
            }
            case 6: {
                this.addPiece(new Pawn(n2, new Position(position.x, position.y)));
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean addPiece(Piece piece) {
        if (piece != null && piece.getPosition() != null && this._$2102[piece.getPosition().x][piece.getPosition().y] == null && !this._$2103.contains(piece)) {
            int n = piece.getPosition().x;
            int n2 = piece.getPosition().y;
            this._$2102[n][n2] = piece;
            this.board[n + (n2 << 3)] = (byte)(piece.getType() | piece.getColor());
            this._$2103.addElement(piece);
            piece.setBoard(this);
            if (piece.getColor() == 0) {
                this.whitePieces.addElement(piece);
                if (piece.getType() == 1) {
                    this.kings[0] = piece;
                }
            } else {
                this.blackPieces.addElement(piece);
                if (piece.getType() == 1) {
                    this.kings[1] = piece;
                }
            }
            return true;
        }
        return false;
    }

    public ChessGame getGame() {
        return this.game;
    }

    public int getNumPieces() {
        if (this._$2103 != null) {
            return this._$2103.size();
        }
        return 0;
    }

    public boolean movePiece(Position position, Position position2) {
        Piece piece = this.getPiece(position);
        if (piece != null && this._$2102[position2.x][position2.y] == null && this._$2103.contains(piece)) {
            Position position3 = piece.getPosition();
            this._$2102[position3.x][position3.y] = null;
            this._$2102[position2.x][position2.y] = piece;
            int n = position3.x + position3.y * 8;
            int n2 = position2.x + position2.y * 8;
            this.board[n2] = this.board[n];
            this.board[n] = 0;
            piece.move(position2);
            return true;
        }
        return false;
    }

    public boolean removePiece(Position position) {
        return this.removePiece(position.x, position.y);
    }

    public boolean isOnBoard(int n, int n2) {
        return n >= 0 && n < this._$2104 && n2 >= 0 && n2 < this._$2105;
    }

    public boolean isOnBoard(Position position) {
        return this.isOnBoard(position.x, position.y);
    }

    public Piece getPiece(Position position) {
        return this.getPiece(position.x, position.y);
    }

    public Piece getPiece(int n, int n2) {
        if (this.isOnBoard(n, n2)) {
            return this._$2102[n][n2];
        }
        return null;
    }
}

