/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class Knight
extends Piece {
    public Knight(int n, Position position) {
        super(4, n, position);
    }

    public Vector getPossibleMoves() {
        ChessGame chessGame = this.getGame();
        if (chessGame == null || chessGame != null && chessGame.getNumMovesMade() != this.possibleMovesUpdated || Piece.kingCheckInProgress) {
            this.possibleMoves = new Vector();
            Position position = new Position();
            int[] nArray = new int[]{-2, 1, -1, 2, 1, 2, 2, 1, 2, -1, 1, -2, -1, -2, -2, -1};
            int n = 0;
            while (n < 16) {
                position.x = this.position.x + nArray[n];
                position.y = this.position.y + nArray[n + 1];
                if (this.board.isOnBoard(position) && (this.board.getPiece(position) == null || this.board.getPiece(position) != null && this.board.getPiece(position).getColor() != this.color)) {
                    Move move = new Move(new Position(this.position.x, this.position.y), position);
                    if (this.board.getPiece(position) != null) {
                        move.captures = true;
                        if (!this.board.getPiece(position).hasMoved()) {
                            move.capturedHadMoved = false;
                        }
                        move.capturedPieceType = this.board.getPiece(position).getType();
                    }
                    move.pieceType = this.type;
                    this.possibleMoves.addElement(move);
                    position = new Position();
                }
                n += 2;
            }
            if (!Piece.kingCheckInProgress) {
                Piece.kingCheckInProgress = true;
                this.checkPossibleMovesForCheck();
                Piece.kingCheckInProgress = false;
            }
            if (chessGame != null) {
                this.possibleMovesUpdated = chessGame.getNumMovesMade();
            }
        }
        return this.possibleMoves;
    }
}

