/*
 * Decompiled with CFR 0.152.
 */
public class SecTimer
implements Runnable {
    int timerCount;
    Thread myThread = null;
    Client owner = null;
    boolean timerEnabled = false;

    public SecTimer(Client client) {
        this.owner = client;
        this.myThread = new Thread(this);
        this.myThread.start();
    }

    public void run() {
        while (true) {
            if (!this.timerEnabled || this.timerCount == -1) {
                Thread.yield();
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
            while (this.timerCount > 0 && this.timerEnabled) {
                --this.timerCount;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.owner.timerUpdated(this.timerCount);
            }
            if (this.timerCount != 0) continue;
            this.timerCount = -1;
            this.owner.timerFinished();
        }
    }

    public void setTimer(int n) {
        this.timerCount = n;
        this.timerEnabled = true;
    }

    public void pause() {
        this.timerEnabled = false;
    }

    public void resume() {
        this.timerEnabled = true;
    }

    public boolean isEnabled() {
        return this.timerEnabled;
    }
}

